#!/usr/bin/perl
############################################################################
#  ⨪  hpt
# (c) Alexey Wasilyev 1999     2:5053/25
# ஢  Active Perl b519 / nt, perl 5.004_04 for i386-linux
############################################################################

use File::stat;
use Time::Local;
use Getopt::Long;

#   hpt'譮 import.log
$hpt_log="/var/log/fido/hpt.log";
#  㤥   last access
$la_hash="/var/log/fido/access";
#१ ᪮쪮  宦    ⢮
$la_dead_time=15;
# 室 ᯨ᮪  
$la_out="/var/spool/fido/flags/dead.areas";
# 䫠,  ⠢ ᫨    ⢠ 
$la_flag="/var/spool/fido/flags/dead.area.exist";
#  㤥   ⨪
$stat_hash="/var/log/fido/echostat";
# 䫠 ६ ᫥ ᡮ ⨪
$stat_last="/var/spool/fido/flags/echostat.last";
# 室 䠩  ⨪
$stat_out="/var/spool/fido/flags/statistic";

$sec_in_day=86400; #60*60*24

format STAT_HEADER=
ͻ
 @||||||||||||||||||||||||||||||||||||||||||||  @|||||||||||  @||||||||||| 
$area,$num,$proc

.
format STAT_BODY=
 @<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<  @|||||||||||     @##.##    
$area,$num,($num/$stat_total_num*100.0 )
.
format STAT_FOOTER=
͹
 @<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<  @|||||||||||     100.00    
$area,$stat_total_num
ͼ
.

sub Import {
    my($date_access);
    open(IN,$hpt_log) || die "Can't open $hpt_log";
    dbmopen(%stat,$stat_hash,0666) || die "Can't open $stat_hash";
    dbmopen(%la,$la_hash,0666) || die "Can't open $la_hash";
    while (<IN>) {
	if (/^----------\s+\S+\s+(\d+)\s+(\w+)\s+(\d+),.*/) {
		$date_access = timelocal(0, 0, 0, $1, $months{$2}, $3)/$sec_in_day;
	};
	if (/echo area (\S+) - (\d+) msgs/) {
	        $stat{$1}+=$2;
        	$la{$1}=$date_access
	};
    }
    dbmclose(%la);
    dbmclose(%stat);
    close(IN);
}

sub Stat {
    my $stat_header =<< '    EOT';

               Ŀ
                  Echomail statistic  ۲ 
               

    EOT
    $stat_total_num=0;
    open(OUT,">".$stat_out) || die "Can't open $stat_out";
    select OUT;
    dbmopen(%stat,$stat_hash,0666) || die "Can't open $stat_hash";
    print $stat_header;
    $stat_date_start=stat($stat_last);
    if ($stat_date_start) {
        $stat_date_start=localtime($stat_date_start->mtime);
    } else {
        $stat_date_start="Earth creating";
    }
    print "Based on data from ".$stat_date_start."\n";
    print "                to ".localtime()."\n";
    $area="Area name";$num="Messages";$proc="%";
    $~= STAT_HEADER;
    write(OUT);
    while (($area,$num)=each(%stat)) {
        $stat_total_num+=$num;
    }
    $~= STAT_BODY;
    foreach $area (sort (keys (%stat))) {
        $num=$stat{$area};
        write(OUT);
    }
    $~= STAT_FOOTER;
    $area="Total:";
    write(OUT);
    dbmclose(%stat);
    close(OUT);
}

sub CheckDead {
    my($dead_found);
    my($cur_day);

    $dead_found=0;
    $cur_day=time()/$sec_in_day;

    open(out,">".$la_out) || die "can't open $la_out";
    select out;
    dbmopen(%la,$la_hash,0666) || die "can't open $la_hash";
    while (($area,$la)=each(%la)) {
        if (($cur_day-$la) >= $la_dead_time) {
            $dead_found=1;
            delete $la{$area};
            print "$area\n";
        }
    }
    dbmclose(%la);
    close(out);
    if ($dead_found and $la_flag) {
        open(out,">".$la_flag) || die "can't creat $la_flag";
        close(out);
    }
}

sub Purge {
    unlink ($stat_hash . ".dir") || die "Can't delete $stat_hash.dir";
    unlink ($stat_hash . ".pag") || die "Can't delete $stat_hash.pag";
    #setting timestamp :)
    open(OUT,">".$stat_last) || die "Can't open $stat_last";
    close(OUT);
}

my $usage = <<'EOT';

Usage: stat.pl <options>
       Options are
        --import    - import statistic & last access time from hpt.log
        --stat      - generate statistic
        --checkdead - generate dead areas list
        --purge     - purge statistic
	--stdout    - output statistic to stdout, not files
	--verbose   - show start and shutdown moments
EOT


$result = GetOptions(\%opts, "stdout\!", "verbose\!", "import", "stat", 
		"checkdead", "purge", "help");
#$arg=lc($ARGV[0]);
if ($result && !$opts{"help"}) {
	if ($opts{"stdout"}) {
		$stat_out = $la_out = "&STDOUT";
	};
	# debug.  ᯮ짮  ७ࠢ 뢮  -䠩.
	print STDOUT "\n"."=-"x20 ."=\n".localtime() if ($opts{"verbose"});
	if ($opts{"import"}) {
    	    print STDOUT "\nImport start\n" if ($opts{"verbose"});
	    Import();
	    print STDOUT "\nImport sthutdown\n" if ($opts{"verbose"});
	};
	if ($opts{"stat"}) {
	    print STDOUT "\nStat start\n" if ($opts{"verbose"});
	    Stat();
	    print STDOUT "\nStat shutdown\n" if ($opts{"verbose"});
	};
	if ($opts{"checkdead"}) {
	    print STDOUT "\nCheckDead start\n" if ($opts{"verbose"});
	    CheckDead();
	    print STDOUT "\nCheckDead shutdown\n" if ($opts{"verbose"});
	};
	if ($opts{"purge"}) {
	    print STDOUT "\nPurge start\n" if ($opts{"verbose"});
	    Purge();
	    print STDOUT "\nPurge shutdown\n" if ($opts{"verbose"});
	};
	if (!$opts{"stat"} && !$opts{"import"} && !$opts{"checkdead"} && !$opts{"purge"}) {
	    print $usage;
	};
} else {
	print $usage;
};
