FACT SHEET:        PHOBOS DYNAMICS EXPERIMENT

SUMMARY
     American space scientists and NASA's Deep Space Network
(DSN) are participating in scientific activities of the USSR's
Phobos mission to study Mars and its satellite Phobos in 1989. 
     Two Soviet Phobos spacecraft were launched in July 1988 and
scheduled to arrive at Mars in January 1989.  Contact with one
spacecraft was lost in early September.  The other was put in an
equatorial orbit, to be carefully stepped down toward the orbit
of Phobos, the inner moon of Mars, to permit a very slow and
close flyby encounter with that body.  The rendezvous and
deployment of landers on the moon are planned for March/April
1989.  The Phobos orbiter carries a lander and a mobile "hopper"
which can make measurements at several sites on the moon's
surface.
     The DSN, which is operated by the California Institute of
Technology's Jet Propulsion Laboratory for NASA, will help Soviet
ground stations maintain radio contact with the lander on the
surface of Phobos, and will help measure Phobos's positions and
motions.  This supports the Phobos Dynamics Experiment, in which
U.S. scientists have a major role. 
     Making these measurements with sufficient precision, over an
extended period, can help scientists working on several different
problems: the rotation and internal makeup of the moon Phobos
itself, the gravitational field and interior of Mars, the
relation of Mars and other planets to a precise and distant frame
of reference based on quasars, the masses of passing asteroids,
and aspects of gravity itself.  Using a transponder aboard the
lander, the DSN will conduct two-way doppler, ranging, and very
long baseline interferometry (VLBI) passes to permit precise
calculation of the orbit and its location in space, working with
scientists from France and the Soviet Union.  In addition to the
Dynamics Experiment measurements, the DSN will help collect
lander telemetry for other experimenters and has helped provide
navigation information on the way to Phobos.
     Radio contact with the Phobos lander is complicated by the
fact that it and its radio antenna will be fixed to the moon,
which is rotating and orbiting rapidly.  The need to conserve the
lander's electric power also limits communication periods. 
Engineers estimate that one or more Earth stations will be able
to communicate with the Phobos lander for only about 17 minutes
out of each 7-1/2-hour rotation period.  
     In the framework of the 1987 U.S./USSR space cooperation
agreement, a number of U.S. scientists are participating in
scientific experiments of the mission.  The two orbiters and
three landers were launched carrying instruments supporting about
35 experiments in all, and scientists from about a dozen nations
are working on them.
PHOBOS, DEIMOS AND MARS
     Phobos is the larger and inner of the two satellites of the
planet Mars.  Deimos, the other satellite, is one-fifth as
massive and orbits more than twice as far from Mars as Phobos.  
     Both satellites are irregular in shape, dark gray in color
and rather low in density; both are covered with impact craters. 
They have nearly circular, equatorial orbits, and their rotations
are locked to their orbital motions, so that each always turns
the same face to Mars, as the Moon does to Earth.  
     Phobos's orbit is slowly decaying, spiraling in towards
Mars, so that Martian tidal forces may overcome the satellite's
own gravity and break Phobos up into rings like Saturn's, perhaps
within 50 million years.  Deimos may, like our Moon, be slowly
spiraling outward.   
     Their densities, color and size suggest that Phobos and
Deimos may be similar to carbonaceous chondrites, perhaps the
most primitive type in the asteroid belt.  The Martian moons may
be asteroids captured long ago by Mars's gravitational field.
     Mars is the outermost, coldest, next-to-smallest, least
dense and (except for Earth) most explored of the four
terrestrial planets of the solar system.  Its surface is highly
diverse, with impact craters, inactive volcanoes, lava flows,
polar caps which change with the seasons, and features suggesting
wind and water erosion.  
     Mars has a thin, relatively clear atmosphere, composed
mostly of carbon dioxide, with a surface pressure less than one
percent of Earth's.  From time to time, as in mid-1988, gigantic
dust storms rage across its deserts.  Mars has the largest known
extinct volcano (Olympus Mons), and the largest known canyon
(Valles Marineris) in the solar system.  Variations in its
gravitational field indicate irregularities in density within the
planet.  The surface composition appears to be dominated by
quartz (common sand) and iron-oxide minerals.  Water cannot long
exist in liquid form (depending on temperature at the low
pressure, it would either freeze or evaporate at once) and
appears to be rare in any form. 
     The orbital motions of Mars and the Earth interact in such a
way that Mars passes close to the Earth, and in opposition
relative to the Sun, every 780 days or about 26 months.  Because
of the eccentricity of Mars's orbit, the distance at opposition
varies from more than 60 million miles to less than 37 million
miles, as occurred in September 1988.

PREVIOUS MISSIONS TO MARS
     Exploration of Mars with unmanned spacecraft began with the
1964-65 flight of Mariner 4, which sent back some 20 close-up
images of the cratered surface, together with atmospheric density
measurements and other planetary data, during and after its July
15, 1965 flyby encounter.   The eleventh of these images, which
showed Moon-like craters, forever ended the romantic myth of Mars
as an Earthlike, fully developed but dying planet. Instead it
revealed at least a part of Mars's surface to be primordial,
little changed since early in solar system history.  
     In August 1969 Mariner 6 and 7 flew past Mars, collecting
two series of global images during the approach phase as well as wide-
 and narrow-angle close-ups, mostly of cratered regions, and data
on atmospheric and polar-cap composition and surface temperature.
     Minimum-energy opportunities to fly to Mars occur about
every 26 months; the launch opportunity occurs a few months
before, and the corresponding arrival at Mars a few months after,
each opposition, the point when Mars is approximately opposite
the Sun in our skies.
     During the 1971 opportunity Mariner 9, the first Mars
orbiter, began its global investigation of the planet, while the
Soviet Union sent Mars 2 and Mars 3, each consisting of an
orbiter and a lander.  However, a planet-wide dust storm obscured
nearly all the surface for several weeks after the spacecraft
arrived, and Mars 2 and 3 obtained very little useful scientific
data from orbit or surface.  
     Mariner 9 was able to wait out the storm, and continued
operations until late October 1972.  It mapped the whole globe,
most of it at about 2- to 4-kilometer (approximately 1- to 2-
mile) resolution, and obtained images of Phobos and Deimos from
as close as 5,600 kilometers (about 3,500 miles).  Mariner 9's
12-hour, elliptical orbit had a closest point 1,300 to 1,600
kilometers (about 800 to 1,000 miles) above the surface and was
tilted 64 degrees from the equator, permitting global and
especially polar coverage, but limiting satellite opportunities.
     The 7,300 images collected by Mariner 9 revealed the variety
of terrain types on Mars, going far beyond the impact craters
which dominate the regions observed earlier.  The pictures show
Deimos and Phobos to be small, irregular and dark, as expected,
and marked with many craters.
     In the 1973 opportunity the USSR sent four more spacecraft,
two orbiters and two landers; the Mars 5 orbiter acquired about
70 images comparable to those of Mariner 9, and the Mars 6 lander
sent atmospheric descent data and reached the surface.
     Viking 1 and Viking 2, launched in August and September
1975, entered inclined, near-synchronous elliptical orbits in
June and August 1976.  Their surface stations landed on Mars on
July 20 and September 3 of that year.  The two orbiters and two
landers supported comprehensive research and observation
programs, lasting until April 1980 in the case of Viking Orbiter
2 and November 1982 in the case of Viking Lander 1.
     The landers completed extensive visual, physical, chemical
and biochemical analyses of the surrounding areas and weather,
and of materials within reach.  The orbiters re-surveyed Mariner
9's territory at higher resolution, with extensive use of color,
and observed changes since Mariner 9 in 1972 and within the 1976-
80 Viking survey period.  Their orbits were altered at various
times after the landings in order to "walk" around the equator,
to fly closer to the surface for improved resolution, and to
bring Viking Orbiter 1 within about 90 kilometers (55 miles) of
Phobos and Viking Orbiter 2 within 25 kilometers (15 miles) of
Deimos.
      The Mariner projects and large parts of the Viking project
were managed or carried out for NASA by the Jet Propulsion
Laboratory.  Project Viking was managed by NASA's Langley
Research Center.
     Scientific data from the Mariner and Viking explorations of
Mars were shared with the international scientific community and
especially with Soviet space scientists as they undertook the
planning and development of the 1988 Phobos mission.  This
included the latest ephemeris of Phobos, which locates the moon
relative to Mars within about 10 kilometers (6 miles), based on
Mariner and Viking images.  The Phobos project will improve this
accuracy tenfold, using new spacecraft images, before attempting
rendezvous and landings.
     Future Mars missions include the U.S. Mars Observer,
scheduled for launch in August 1992 and Mars orbital operations
from August 1993 through July 1995, and a planned USSR lander
mission in the 1994 opportunity.  

PHOBOS MISSION
     On July 7 and July 12, 1988, the Soviet Union launched two
nearly identical 13,700-pound Phobos spacecraft aboard four-stage
Proton launch vehicles from Baikonur Cosmodrome near Tyuratam in
the southern part of the USSR.
     The Phobos spacecraft were scheduled to arrive at Mars on
January 25 and 29, 1989, after 480-million-kilometer (300-
million-mile) flights taking them two-fifths of the way around
the Sun.  During the interplanetary cruise phase they were to
observe and measure the Sun and the space environment,
communicating results to Earth about every five days.  In late
September, the first spacecraft was found to be out of
communication with Earth, apparently the result of a command
error.  It has not been recovered.  The other, duplicating most
of the sensors and carrying a lander and the hopper, was put in
Mars orbit January 29.  
     The initial Mars orbit, swinging in to 875 kilometers 540
miles) above the surface and back out to about 80,000 kilometers
(50,000 miles) every 77 hours, was maintained for about ten days. 
Then, at intervals of several weeks, giving time for observation
and study of Mars and the local environment and careful tracking
of Phobos, the spacecraft was to be maneuvered through three more
orbits, the last of which is circular, equatorial, and only about
30 kilometers (20 miles) beyond that of the tiny moon. 
Throughout the orbital phase, the spacecraft will record its
scientific and engineering data for transmission to Earth about
every three days. 
     From this close circle, armed with precise observations and
calculations of the relative positions and motions of the moon
and the spacecraft Phobos, controllers will fly the craft down
for a contour-following close flyby about 50 meters
(approximately 150 feet) from the surface, at about 7 to 15
kilometers per hour (5 to 10 miles per hour).  At the end of this
20-minute survey, the Phobos spacecraft will deploy a 110-pound
Long-Duration Lander (expected to operate for about a year), and
the 112-pound "hopper" (limited by its battery life of a few
hours). Then it will return to its 6,000-kilometer (3,700-mile)
circular orbit above Mars. 
     The "hopper" is a mobile instrument package which uses
spring-loaded legs to jump 20 yards at a time to examine several
surface locations.

PHOBOS SPACECRAFT
     Weighing nearly seven tons at launch and spanning about 9
meters (30 feet) when solar panels are unfolded, the Phobos
spacecraft is the newest generation of the Soviet planetary
series used in previous Mars and Venus missions. The design is
built around a large toroid or doughnut shape topped by a
cylinder containing most of the electronics, with antennas, solar
panels and scientific sensors mounted outside.  Much of the
initial mass is devoted to the orbital rocket system which
propels it into Mars orbit, does subsequent maneuvers, and then
is separated.  
     The spacecraft is normally stabilized relative to the Sun
and the star Canopus, and is gyro-controlled during maneuvers. 
Electric power is supplied by solar cells and rechargeable
batteries.

SCIENTIFIC EXPERIMENTS
     Eleven European nations, the European Space Agency, the
United States and the Soviet Union are participating in 37
experiments as part of the Phobos mission.  The experiments are
designed to study Phobos, Mars, the Sun and the interplanetary
environment.
      In addition to remote sensing devices such as imaging,
spectrometers, radiometers and radar, Phobos will use lasers and
ion beams to analyze surface materials. The landers and the
"hopper" will perform various on-site analyses; radiation and
particle detectors, plasma instruments, and magnetometers will
monitor the space environment; and the Dynamics Experiment, in
which the U.S. scientists play a major role, will use the lander-
to-Earth radio link to examine the motion of Phobos for
gravitational effects.

NASA/JPL PARTICIPATION AND SUPPORT
     As part of the U.S./USSR cooperation in solar system
exploration under the 1987 U.S./USSR space cooperation agreement,
NASA participates in the Phobos mission in a number of ways.  A
major investigation called the Dynamics Experiment, developed
largely by a U.S. scientist, will use precision ranging and very
long baseline interferometry (VLBI) with the Phobos lander,
together with data from the lander's sun sensor.  A team of U.S.
scientists will participate in this experiment, which represents
the major U.S. involvement in the Phobos mission.
     To conduct this experiment and provide supplementary support
to the other lander experiments, the Deep Space Network, operated
for NASA by the Jet Propulsion Laboratory, will conduct more than
200 telemetry, ranging and VLBI passes with the lander during the
mission's lifetime. The compatibility of lander communications
equipment with the DSN was verified on the ground before launch,
and the system was tested in flight as well.
     Under the same agreement, NASA has named ten U.S. scientists
to participate as guest investigators or interdisciplinary
investigators in the Phobos science activities; a like number of
Soviet scientists will participate in the U.S. Mars Observer
mission.  NASA and JPL scientists and engineers also support the
Phobos mission by providing navigational data and analyses,
providing preflight and inflight data analysis to improve
knowledge of the ephemeris of the Martian satellite, helping the
Soviet scientists and specialists to achieve the Phobos
rendezvous and landings.

DEEP SPACE NETWORK
     The NASA/JPL Deep Space Network (DSN) was established nearly
30 years ago, soon after the Jet Propulsion Laboratory became an
element of NASA.  The network was designed to be, and has become,
a general spacecraft tracking facility for all NASA spacecraft
missions beyond Earth orbit, and for some Earth satellites as
well.  NASA's Office of Space Operations is responsible for the
tracking and data acquisition for NASA spacecraft, and has
delegated DSN implementation and operations to JPL.
     The DSN participated in the Pioneer, Ranger, Surveyor, Lunar
Orbiter, Apollo and Mariner series of flights, supported the
Viking Mars orbital and landing operations, and has been a part
of the continuing Voyager outer planets mission for more than a
decade.
     International cooperation is a significant activity of the
DSN as well, exemplified by support to such missions as Helios,
AMPTE, the Vega/Venus balloons and the Halley's Comet
investigations conducted by the European Space Agency, the Soviet
Union and Japan.
     The DSN has large tracking antennas situated around the
world to assure continuous communication with spacecraft en route
to the Moon and beyond.  It is the only such sensitive, world-
wide facility in existence.  Deep-space communication complexes
are located in Australia, 40 kilometers (25 miles) southwest of
Canberra; in Spain, 60 kilometers (37 miles) west of Madrid; and
in the California desert 72 kilometers (45 miles) northeast of
Barstow.  Each complex includes four large parabolic dish
antennas: a 70-meter (230-foot) dish, two 34-meter (111-foot),
and a 26-meter (85-foot) antenna.  They are equipped with
sensitive receivers and precise computer controls, and are
capable of sending and receiving signals at a number of frequency
bands used for spacecraft.
     These stations are tied together and to the Network  Control
Center at JPL in Pasadena and mission controllers in the U.S. and
overseas by a NASA ground communications facility of cable,
microwave and satellite links. 
     A total of about 1,100 people are employed by NASA, the
responsible agencies of Australia and Spain, and their
contractors to operate and maintain the DSN 24 hours per day, 365
days per year.

DYNAMICS EXPERIMENT
     Planetary spacecraft carry sophisticated two-way radio
equipment to transmit their scientific observations to Earth and
receive commands from their mission controllers.  These systems
also include navigation transponders for measuring the range and
velocity between spacecraft and Earth, permitting controllers to
calculate precisely where the craft is and where it is going and
to change course as needed.
     This utilitarian system can also function as a huge
scientific instrument.  Perturbations in the flight path, or in
the spacecraft's orbit around a planet, enable scientists to
chart the gravitational fields through which it flies.  For
centuries, astronomers have used perturbations to discover new
planets through their influence on known ones, and to weigh them
by tracking their satellites.  A spacecraft, which can be located
and tracked with great precision, makes an excellent probe for
this kind of research.
     A radio astronomy technique called very long baseline
interferometry (VLBI) improves the navigation and scientific
value of the results by adding precise angular data and linking
the positions to a stable reference frame.  Using two widely
separated radio telescopes linked and calibrated together,
scientists count radio wavelengths to measure the difference in
the distances from the spacecraft to the two stations; a
trigonometric calculation then gives the angle.  Repeating the
measurement with a quasar (a natural, very distant radio source
whose position has been precisely determined), scientists can
precisely pin the spacecraft data to an absolute map of space.
     In the Phobos mission, the lander, anchored to the Martian
moon Phobos, will do the probing. Scientists will be able to
chart three kinds of motion: that of Phobos around its own
center, Phobos's orbital motion around Mars, and the motion of
Mars in solar orbit, relative to the motions of the Earth
stations. 
     They will measure the libration, or wobbling, in the moon's
synchronous rotation as it orbits Mars with one end always
pointing down at the planet. For this part of the study, the
lander's sun-sensor data will be combined with the radio data.  
     The scientists will continue charting the global gravity
field of Mars, work begun by Mariner and Viking.  They will also
look for tiny perturbations in the planet's orbit caused by
close-passing asteroids, to weigh those asteroids. 
     The accumulated data should also provide a test of the
theory that the universal gravitational constant is slightly and
slowly changing as the universe expands. Finally, they will
measure the gradual speeding-up and dropping-down motion of
Phobos as it falls toward Mars, a slow and inevitable decay that
may take 50 million years.
     This Phobos Dynamics Experiment is led by Dr. Robert Preston
of JPL in collaboration with a team of investigators from JPL,
MIT, the French space agency CNES and the Soviet Union.  The
experiment is supported by the Deep Space Network, whose
individual stations will do radio doppler and ranging and receive
telemetry from the landers, and pairs of whose ground stations
(for example, Madrid, Spain, and Goldstone, California) will make
VLBI measurements.  The large 70-meter (230-foot) antennas will
maintain the links to the Phobos lander.
     In order to test the system in flight, the Phobos project
installed transponders on the Phobos orbiters to simulate lander
radio systems, which will not be powered until after landing. 
This additional weight reduced spacecraft propellant reserves
slightly, and in compensation NASA and JPL agreed to provide VLBI
and other navigation data support and analysis to the spacecraft
in flight, reducing the uncertainty in the Mars orbit-insertion
maneuvers and saving fuel. 
     JPL is also helping six other teams in Europe and the USSR
to calculate and update the ephemeris of Phobos from Earth-based
and spacecraft observations, further assisting the delicate
operation of meeting and overflying the tiny moon.
     At JPL, the Phobos project manager is Dr. James A. Dunne,
and the tracking and data system manager is Marvin R. Traxler.




           CHARACTERISTICS OF MARS, PHOBOS AND DEIMOS

                            Mars        Phobos      Deimos

Av. orbital radius (km)     227 mill    9,400       24,200
                   (mi)     141 mill    5,800       15,000

Orbital period              687 days    7hr 37m     30hr 18m

Rotation period             24hr 37m    7hr 37m     30hr 18m

Density (water = 1.0)       3.9         1.9         1.4

Mass, million million tons  600 mill    9           2

Diameter (maximum), km      6800        27          12

Albedo (sunlight reflected) 9-43%       6%          6%

Color                       reddish     dark gray   dark gray



                    PHOBOS SCIENTIFIC PAYLOAD

Orbiter
Multichannel CCD Cameras      Bulgaria, E. Germany, USSR
Low-frequency Radar Sounder   USSR
Gamma-Ray Spectrometer        USSR
Neutron Spectrometer*         USSR
Infrared Spectrometer         France, USSR
Thermal IR Radiometer         France, USSR
Infrared Spec/Radiometer      USSR
Ion-Beam-Aided Analyzer       Austria, Finland, France, USSR
Laser-Aided Mass Spectrometer Austria, Bulgaria, Czecho-
                              slovakia, E. and W. Germany,       
                                                  Finland, USSR
Atmosphere Spectrometer       France, USSR
Radar Ionosphere Analyzer     USSR
Ion/Electron Mass Spec        Finland, Sweden, USSR
Magnetometers (2)             E. Germany, USSR
                              Austria, USSR
Plasma-Wave Analyzer          Czechoslovakia, ESA, Poland,       
                                        USSR
Solar Wind Mass Spectrometer  Austria, Hungary, W. Germany,
                              USSR
Proton/Alpha Spectrometer     Austrua, Hungary, W. Germany,
                              USSR
High-E Solar Cosmic-Ray       ESA, Hungary, W. Germany, USSR
Low-E Solar Cosmic-Ray        Hungary, W. Germany, USSR
High-E Gamma-Ray Burst        France, USSR
Low-E Gamma-Ray Burst         France, USSR
Solar X-Ray/Coronagraph*      Czechoslovakia, USSR
Solar X-Ray Spectrometer      Czechoslovakia, USSR
Solar Extreme Ultraviolet*    USSR
Solar-Constant Photometer     ESA, France, Switzerland

Lander
TV Camera                     France, USSR
Penetrometer Sensors          USSR
Seismometer                   USSR
X-Ray Fluorescence/Alpha      W. Germany, USSR
  Scattering Spectrometer
Celestial Mechanics/Dynamics  USA, France, USSR
Libration monitor             France, USSR

"Hopper"
X-Ray Fluorescence Spec       USSR
Magnetometer                  USSR
Penetrometer, Dynamograph,    USSR
   Gravimeter
__________________
*Phobos 1 only (apparently no longer operating)


                     U.S. PHOBOS SCIENTISTS


Dynamics Experiment:

Robert A. Preston, JPL (Principal Investigator)
John D. Anderson, JPL
John M. Davidson, JPL
Ronald W. Hellings, JPL
Robert D. Reasenberg, Harvard-Smithsonian Center for             
         Astrophysics
Irwin I.Shapiro, Harvard-Smithsonian Center
James G. Williams, JPL
Charles F. Yoder, JPL

Guest Investigators and Interdisciplinary Scientists:

William V. Boynton, University of Arizona
Dale Cruikshank, Ames Research Center
Thomas C. Duxbury, JPL
Frazer Fanale, University of Hawaii
James W. Head, Brown University
Bruce C. Murray, California Institute of Technology
Andrew F. Nagy, University of Michigan
Norman F. Ness, Bartol Res. Inst., University of Delaware
Gary Olhoeft, U. S. Geological Survey
Bradford A. Smith, University of Arizona

                         #####


2-89 JW