FACT SHEET:      VOYAGER JUPITER SCIENCE SUMMARY

		NASA launched the two Voyager spacecraft to Jupiter,
Saturn, Uranus, and Neptune in the late summer of 1977.  Voyager
1's closest approach to Jupiter occurred March 5, 1979.  Voyager
2's closest approach was July 9, 1979.
		Photography of Jupiter began in January 1979, when
images of the brightly banded planet already exceeded the best
taken from Earth.  Voyager 1 completed its Jupiter encounter in
early April, after taking almost 19,000 pictures and many other
scientific measurements.  Voyager 2 picked up the baton in late
April and its encounter continued into August.  They took more
than 33,000 pictures of Jupiter and its five major satellites.
		Although astronomers had studied Jupiter from Earth for
several centuries, scientists were surprised by many of Voyager 1
and 2's findings.  They now understand that important physical,
geological, and atmospheric processes go on - in the planet, its
satellites, and magnetosphere - that were new to observers.
		Discovery of active volcanism on the satellite Io was
probably the greatest surprise.  It was the first time active
volcanoes had been seen on another body in the solar system.  It
appears that activity on Io affects the entire Jovian system.  Io
appears to be the primary source of matter that pervades the
Jovian magnetosphere -- the region of space that surrounds the
planet, primarily influenced by the planet's strong magnetic
field.  Sulfur, oxygen, and sodium, apparently erupted by Io'svolcanoes and sputtered off the surface by impact of high-energy
particles, were detected at the outer edge of the magnetosphere.
		Particles of the same material are present inside Io's
orbit, where they accelerate to more than 10 percent of the speed
of light.  It is clear to scientists from a comparison of data
from Pioneers 10 and 11 (which flew past Jupiter in late 1973 and
1974) and the Voyagers that something changed in the four and
one-half years between the Pioneer and Voyager encounters.
		It is not entirely clear just how far-reaching those
changes are, or what brought them about.  They may be related to
Ionian activity.  It is difficult to imagine, however, that at
least some of Io's volcanoes were not erupting when the Pioneers
flew past; it is also, the Voyager scientists say, difficult to
believe the Pioneers' instruments failed to see magnetospheric
concentrations of sulfur detected by both Voyager spacecraft
(Voyager 1 saw greater concentrations than Voyager 2).
		Here is a summary of the more important science results
from the Voyager encounters with Jupiter:
JUPITER'S ATMOSPHERE
		Atmospheric features of broadly different sizes appear
to move with uniform velocities.  That suggests that mass motion
(movement of material) and not wave motion (movement of energy
through a relatively stationary mass) was being observed.
		Rapid brightening of features in the atmosphere was
followed by spreading of cloud material.  That is probably the
result of disturbances that trigger convective (upwelling and

downwelling) activity.
		A pattern of east-to-west winds extends as far poleward
as 60 degrees north and south, roughly similar to the pattern
seen in more temperate areas where belts and zones are visible. 
Previous investigations led scientists to believe the near-polar
regions (above 45 degrees latitude) are dominated by convective
upwelling and downwelling.  Voyager showed they apparently are
not, at least up to 60 degrees latitude, and probably to 75.
		Material associated with the Great Red Spot, Jupiter's
most prominent atmospheric feature, moves in a counter-clockwise
(anticyclonic) direction.  At the outer edge, material appears to
rotate in four to six days; near the center, motions are small
and nearly random in direction.
		Small spots appear to interact with the Great Red Spot
and with each other.
		Voyager instruments observed auroral emissions, similar
to Earth's northern lights, in the polar regions, in ultraviolet
and visible light.  Pioneer 10 and 11 didn't see the ultraviolet
emissions during their encounters.  The auroral emissions appear
to be related to material from Io that spirals along magnetic
field lines to fall into Jupiter's atmosphere.
		Voyager also saw cloud-top lightning bolts, similar to
superbolts in Earth's high atmosphere.
		Atmospheric temperature at 5 to 10 millibars (1/200th
to 1/100th Earth's surface atmospheric pressure) is about 160
Kelvins (-170 degrees Fahrenheit).  An inversion layer -- a warmregion above a cold layer, similar to the phenomenon that traps
smog in the Los Angeles Basin -- exists near the 150-millibar
level.  (Pressure at Earth's surface is about 1,000 millibars.)
		The Voyagers observed ionospheric temperatures that
changed with altitude, reaching about 1,100 Kelvins (1,500
degrees Fahrenheit).  That was also not observed by Pioneers 10
and 11, and Voyager scientists believe they are witnessing large
temporal or spatial changes in the ionosphere of Jupiter.
		The Voyagers measured helium in the upper atmosphere;
its percentage compared to hydrogen is important to understand
composition and history of the atmosphere -- and the primordial
cloud of which the Sun and planets formed.  Relative abundance of
helium to hydrogen is about 11 percent by volume.
SATELLITES AND RING
		Voyager 1 identified nine currently active (erupting)
volcanoes on Io, probably driven by tidal heating. Many more are
suspected.  Voyager 2 observed eight of the nine; the largest
shut down by the time Voyager 2 arrived at Jupiter.  Plumes from
the volcanoes reach more than 300 kilometers (190 miles) above
the surface.  The material was being ejected at velocities up to
1.05 kilometers a second (2,300 miles an hour).  By comparison,
ejection velocities at Mount Etna, one of Earth's most explosive
volcanoes, hit 50 meters a second (112 miles an hour).  Volcanism
is associated with heating of Io by tidal pumping.  Europa and
Ganymede, two large satellites nearby, perturb Io in its orbit
and Jupiter pulls Io back again.  The pumping action causes tidal

bulging up to 100 meters (330 feet) on Io's surface, compared
with typical tidal bulges on Earth of one meter (three feet).
		Voyager 1 measured the temperature of a large hot spot
on Io associated with a volcanic feature.  While the surrounding
terrain has a temperature of about 130 Kelvins (-230 degrees
Fahrenheit), the hot spot's temperature is about 290 Kelvins (60
degrees Fahrenheit).  Scientists believe the hot spot may be a
lava lake, although the temperature indicates the surface is not
molten; it is, at least, reminiscent of lava lakes on Earth.
		Europa displayed a large number of intersecting linear
features in the distant, low-resolution photos from Voyager 1. 
Scientists at first believed the features might be deep cracks,
caused by crustal rifting or tectonic processes.  Closer, high-
resolution photos by Voyager 2, however, left scientists puzzled: 
The features were so lacking in topographic relief that they
"might have been painted on with a felt marker," one scientist
commented.  There is a possibility that Europa may be internally
active due to tidal heating at a level one-tenth or less that of
Io.  Models of Europa's interior show that beneath a thin crust
(5 kilometers or 3 miles) of water ice, Europa may have oceans as
deep as 50 kilometers (30 miles) or more.
		Ganymede turned out to be the largest satellite in the
solar system.  Before the Voyager encounters, astronomers thought
that Saturn's satellite, Titan, was the largest.  Ground-based
observations of Titan, of necessity, had included its substantial
atmosphere.  Voyager measurements of Ganymede showed it is largerthan Titan.  Ganymede had two distinct terrain types --- cratered
and grooved, telling scientists that Ganymede's entire, ice-rich
crust has been under tension from global tectonic processes.
		Callisto has an ancient, heavily cratered crust, with
remnant rings of enormous impact basins.  The largest craters
apparently were erased when the ice-laden crust flowed during
geologic time; almost no topographic relief is apparent in ghost
remnants of the impact basins, identifiable only by their light
color and surrounding subdued rings of concentric ridges.
		Amalthea is elliptical:  270 kilometers (170 miles) by
165 kilometers (105 miles) by 150 kilometers (95 miles). It is
about 10 times larger than Mars' larger satellite, Phobos, and
has 1,000 times the volume.
		Voyager discovered a ring around Jupiter.  Its outer
edge is 129,000 kilometers (80,000 miles) from the center of the
planet, and, though the brightest portion is only about 6,000
kilometers (4,000 miles) wide, ring material may extend another
50,000 kilometers (30,000 miles) downward to the top of Jupiter's
atmosphere.  Evidence also suggests that diffuse ring material
extends as far out as the orbit of Amalthea.  The ring is no more
than 30 kilometers (20 miles) thick.  Thus Jupiter joins Saturn,
Uranus, and Neptune as a ringed planet -- although each ring
system is unique and distinct from the others.
		Two new satellites, Adrastea and Metis, only about 40
kilometers (25 miles) in diameter, orbit just outside the ring. 
A third new satellite, Thebe, diameter about 80 kilometers (50

miles), was discovered between the orbits of Amalthea and Io.
MAGNETOSPHERE
		An electric current of 5 million amperes was detected
in the flux tube that flows between Jupiter and Io, five times
stronger than predicted.  Voyager did not fly through the flux
tube, as planned, since the stronger current had twisted the tube
7,000 kilometers (4,300 miles) from the predicted location.
		The Voyagers saw ultraviolet emissions from doubly and
triply ionized sulfur and doubly ionized oxygen.  Pioneers 10 and
11 did not detect them, so hot plasma evidently was not present
in 1973 and 74.  The sulfur comes from Io's volcanoes.
		Plasma-electron densities in some regions of the Io
torus (an inner-tube-shaped ring of matter in the region of Io's
orbit) exceeded 4,500 per cubic centimeter.
		A cold plasma, rotating with Jupiter, lies inside six
Jupiter radii (430,000 kilometers or 270,000 miles) from the
planet.  Ions of sulfur, oxygen, and sulfur dioxide were found.
		High-energy trapped particles were also detected near
Jupiter, with enhanced abundances of oxygen, sodium, and sulfur.
		Kilometric radio emissions were coming from Jupiter. 
The emissions, in the frequency range from 10 kilohertz to 1
megahertz, may result from plasma oscillations in the Io torus.
		Plasma flows in the dayside outer magnetosphere; the
plasma rotates with the planet every 10 hours.
		Voyager 1 saw evidence of a transition from closed
magnetic field lines to a magnetotail on the antisolar side ofJupiter.  Although such a magnetotail was never in serious doubt,
its existence had not been confirmed before.
		Voyager 2 observations during its Jupiter-to-Saturn
cruise showed the magnetotail extends at least to the orbit of
Saturn, 650 million kilometers (400 million miles) away.
		Scientists interpreted whistler emissions as lightning
whistlers in the atmosphere.  Lightning was suspected, and it has
been proven, from the emissions and detection of bolts; lightning
is a major energy source for many activities on Jupiter.
		Voyager also measured radio spectral arcs (from about 1
megahertz to more than 30 megahertz) in patterns that correlate
with Jovian longitude.
		Both Voyagers continued on to encounters with Saturn. 
Voyager 1 is bound out of the solar system.  Voyager 2 completed
encounters with Uranus (in January 1986) and Neptune (in August
1989).  It is now also leaving the solar system.
		The next mission to Jupiter will be Galileo, launched
in 1989.  Galileo, an orbiter and an atmospheric probe, will
continue the exploration of Jupiter begun by the Pioneers and
continued by the Voyagers.  Both the missions are managed for
NASA by the Jet Propulsion Laboratory.
                                #####
5/7/90DB
