VOYAGER NEPTUNE SCIENCE SUMMARY


          In the summer of 1989, NASA's Voyager 2 became the
first spacecraft to observe the planet Neptune, its final
planetary target.  Passing about 4,950 kilometers (3,000 miles)
above Neptune's north pole, Voyager 2 made its closest approach
to any planet since leaving Earth 12 years ago.  Five hours
later, Voyager 2 passed about 40,000 kilometers (25,000 miles)
from Neptune's largest moon, Triton, the last solid body the
spacecraft will have an opportunity to study. 
          Neptune is one of the class of planets -- all of them
beyond the asteroid belt -- known as gas giants; the others in
this class are Jupiter, Saturn and Uranus.  These planets are
about 4 to 12 times greater in diameter than Earth.  They have no
solid surfaces but possess massive atmospheres that contain
substantial amounts of hydrogen and helium with traces of other
gases.
          Voyager 2 is one of twin spacecraft launched more than
a decade ago to explore the outer solar system.  Between them,
these spacecraft have explored four giant planets, 48 of their
moons, and their unique systems of rings and magnetic fields. 
          Voyager 1, launched September 5, 1977, visited Jupiter
in 1979 and Saturn in 1980.  It is now leaving the solar system,
rising above the ecliptic plane at an angle of about 35 degrees,
at a rate of about 520 million kilometers a year.
          Voyager 2, launched August 20, 1977, visited Jupiter in

1979, Saturn in 1981 and Uranus in 1986 before making its closest
approach to Neptune on August 25, 1989.  Voyager 2 traveled 12
years at an average velocity of 19 kilometers a second (about
42,000 miles an hour) to reach Neptune, which is 30 times farther
from the Sun than Earth is.  Voyager observed Neptune almost
continuously from June to October 1989.  Now Voyager 2 is also
headed out of the solar system, diving below the ecliptic plane
at an angle of about 48 degrees and a rate of about 470 million
kilometers a year.
          Both spacecraft will continue to study ultraviolet
sources among the stars, and their fields and particles detectors
will continue to search for the boundary between the Sun's
influence and interstellar space.  If all goes well, we will be
able to communicate with the two spacecraft for another 25 to 30
years, until their nuclear power sources can no longer supply
enough electrical energy to power critical subsystems.

BACKGROUND
          Astronomers have studied Neptune since September 23,
1846, when Johann Gottfried Galle, of the Berlin Observatory, and
Louis d'Arrest, an astronomy student, discovered the eighth
planet on the basis of mathematical predictions by Urbain Jean
Joseph Le Verrier.  Similar predictions were made independently
by John Couch Adams.  (Galileo Galilei had seen Neptune during
several nights of observing Jupiter, in January 1613, but didn't
realize he was seeing a new planet.)   Still, any knowledge and
understanding of Neptune was limited by the astronomer's abilityto see the distant object, almost 4.5 billion kilometers (2.8
billion miles) from Earth.
          Scarcely a month after Galle and d'Arrest first saw
Neptune, British astronomer William Lassell spotted a satellite
orbiting the planet and named it Triton.  Triton, almost the size
of Earth's Moon, is the only large satellite in the solar system
to circle a planet in a retrograde direction -- in a direction
opposite to the rotation of the planet.  That phenomenon led some
astronomers to surmise that Neptune had captured Triton as it
traveled through space several billion years ago.
          In 1949, astronomer Gerard Kuiper discovered Nereid,
the second of Neptune's escorts.  Nereid is only about 340
kilometers (210 miles) in diameter and is so far from Neptune
that it requires 360 days to make one orbit -- only five days
less than Earth takes to travel once around the Sun.
          In 1981, astronomers leaped at an infrequent
opportunity:  A star would pass behind Neptune so that observers
could measure the starlight and how it changed as it passed
through the upper layer of Neptune's atmosphere.  That would
provide clues to its structure.
          But the star's light winked off and on before Neptune
passed in front of it.  Similar measurements were obtained during
the mid-1980s.  Astronomers concluded that some material (perhaps
like that of the rings of Saturn) orbits Neptune, and was
responsible for occasional blockage of the star's light.  In each
observed event, astronomers saw that the ring or rings did not
appear to completely encircle the planet -- rather, each appeared

to be an arc segment of a ring.
          The laws of physics say that, with nothing else acting 
upon them, rings must orbit a planet at about the same distance
from the center all the way around.  Ring material, if
unrestrained, will tend to disperse uniformly around the planet.
In order to have "ring arcs," scientists thought that some
objects -- perhaps small satellites -- must shepherd the arcs,
keeping them in their place by gravity.
          Earth-based telescopic observations of Neptune over the 
last few years showed tantalizing hints of dynamic cloud
structures on the distant planet, from which scientists could 
estimate the speed of winds circling the planet. 
          Against that background, Voyager's scientists prepared 
for the first encounter of Neptune, perhaps the only close-up 
look at Neptune in the lifetime of many of us.  What they found
will force scholars to rewrite the astronomy textbooks, and
scientists to adjust their views of the solar system's other
giant planets.

NEPTUNE
          Nearly 4.5 billion kilometers (3 billion miles) from
the Sun, Neptune orbits the Sun once in 165 years, and therefore 
has made not quite a full circle around the Sun since it was 
discovered.  With an equatorial diameter of 49,528 kilometers 
(30,775 miles), Neptune is the smallest of our solar system's 
gas giants.  Even so, its volume could hold nearly 60 Earths.  
Neptune is the densest of the four giant planets, about 64 percent heavier than if it were composed entirely of water.      
          The most obvious feature of the planet in Voyager
pictures is its blue color, the result of methane in the
atmosphere.  Methane preferentially absorbs the longer
wavelengths of sunlight (those near the red end of the spectrum). 
What are left to be reflected are colors at the blue end of the
spectrum.
          While methane is not the only constituent in Neptune's
atmosphere, it is one of the most important.  Methane cycles
through the atmosphere like this:
          * Solar ultraviolet radiation destroys methane high in
Neptune's atmosphere by converting it to hydrocarbons such as
ethane, acetylene and haze particles of more complex polymers.
          * The haze particles sink to the cold lower
stratosphere, where they freeze and become ice particles.
          * The hydrocarbon ice particles gently fall into the
warmer troposphere, where they evaporate back into gases.
          * The hydrocarbon gases mix deeper into the atmosphere
where the temperature and pressure are higher, mix with hydrogen
gas and regenerate methane.
          * Buoyant, convective methane clouds then rise great
distances to the base of the stratosphere or higher, returning
methane vapor to the stratosphere.
          Throughout the process there is no net loss of methane
in Neptune's atmosphere.
          Neptune is a dynamic planet, even though it receives
only 3 percent as much sunlight as Jupiter does.  Several large,

dark spots are reminiscent of Jupiter's hurricane-like storms. 
The largest spot is big enough for Earth to fit neatly inside it. 
Designated the "Great Dark Spot" by its discoverers, the feature
appears to be an anticyclone similar to Jupiter's Great Red Spot. 
Neptune's Great Dark Spot is comparable in size, relative to the
planet, and at the same latitude (the Great Dark Spot is at 22
degrees south latitude) as Jupiter's Great Red Spot.  However,
Neptune's Great Dark Spot is far more variable in size and shape
than its Jupiter counterpart.  Bright, wispy "cirrus-type" clouds
overlaying the Great Dark Spot at its southern and northeastern
boundaries may be analogous to lenticular clouds that form over
mountains on Earth.
          At about 42 degrees south, a bright, irregularly
shaped, eastward-moving cloud circles much faster than does the
Great Dark Spot, "scooting" around Neptune in about 16 hours. 
This "scooter" may be a cloud plume rising between cloud decks.
          Another spot, designated "D2" by Voyager's scientists,
is located far to the south of the Great Dark Spot, at 55 degrees
south.  It is almond-shaped, with a bright central core, and
moves eastward around the planet in about 16 hours.
          Voyager also measured heat radiated by Neptune's
atmosphere.  The atmosphere above the clouds is hotter near the
equator, cooler in the mid-latitudes and warm again at the south
pole.  Temperatures in the stratosphere were measured to be 750
kelvins (900 degrees F), while at the 100 millibar pressure
level, they were measured to be 55 K (-360 degrees F).  Heat
appears to be caused, at least in part, by convection in theatmosphere that results in compressional heating:  Gases rise in
the mid-latitudes where they cool, then drift toward the equator
and the pole, where they sink and are warmed.
          Long, bright clouds, reminiscent of cirrus clouds on
Earth, can be seen high in Neptune's atmosphere.  They appear to
form above most of the methane, and consequently are not blue.
          At northern low latitudes (27 degrees north), Voyager
captured images of cloud streaks casting their shadows on cloud
decks estimated to be about 50 to 100 kilometers (30 to 60 miles)
below.  The widths of these cloud streaks range from 50 to 200
kilometers (30 to 125 miles), and the widths of the shadows range
from 30 to 50 kilometers (20 to 30 miles).  Cloud streaks were
also seen in the southern polar regions (71 degrees south), where
the cloud heights were about 50 kilometers (30 miles). 
          Most of the winds on Neptune blow in a westward
direction, which is retrograde, or opposite to the rotation of
the planet.  Near the Great Dark Spot, there are retrograde winds
blowing up to 1500 miles an hour -- the strongest winds measured
on any planet, including windy Saturn.

THE MAGNETIC ENVIRONMENT
          The character of Neptune's magnetic field is important
because it helps scientists understand what goes on deep in the
planet's interior.
          To have a magnetic field, scientists believe, a planet
must fulfill these conditions:

          * There must be a region within the planet that is
liquid;
          * The region must also be electrically conducting; 
          * There must be an energy source that sets the region
in motion and then keeps it moving.
          Neptune's magnetic field is tilted 47 degrees from the
planet's rotation axis, and is offset at least 0.55 radii (about
13,500 kilometers or 8,500 miles) from the physical center.  The
dynamo electric currents produced within the planet, therefore,
must be relatively closer to the surface than for Earth, Jupiter
or Saturn.  The field strength at the surface varies, depending
on which hemisphere is being measured, from a maximum of more
than 1 gauss in the southern hemisphere to a minimum of less than
0.1 gauss in the northern.  (Earth's equatorial magnetic field at
the surface is 0.32 gauss.)  Because of its unusual orientation
and the tilt of the planet's rotation axis, Neptune's magnetic
field goes through dramatic changes as the planet rotates in the
solar wind.
          Voyager's first indication of the Neptunian magnetic
field was the detection of periodic radio emissions from the
planet.  The spacecraft crossed the bow shock, the outer edge of
the field that stands ahead of the planet like a shield in the
solar wind, as a shock wave stands out before a supersonic
airplane, at 7:38 a.m. August 24, and shortly thereafter entered
the planet's magnetosphere.  Voyager 2 remained within the
magnetosphere for about 38 hours, or slightly more than two
planetary rotations, before passing once again into the solarwind.
          Because Neptune's magnetic field is so highly tilted,
and the timing of the encounter was such that the south magnetic
pole was very nearly pointed at the Sun, Voyager 2 flew into the
southern cusp of the magnetosphere, providing scientists a unique
opportunity to observe this region of a gigantic magnetic field.
          Magnetospheric scientists compared Neptune's field with
that of Uranus, which is tilted 59 degrees from the rotation
axis, with a center that is offset by 0.3 Uranus radii. After
Voyager 2 passed Uranus in January 1986, some scientists thought
they might have seen the planet as its magnetic field was
reversing direction.  Others found it difficult to believe such a
coincidence just happened as Voyager passed through the
neighborhood.  Scientists have no definite answers yet, but think
that the tilt may be characteristic of flows in the interiors of
both Uranus and Neptune and unrelated to either the high tilt of
Uranus' rotation axis or possible field reversals at either
planet.
          Neptune's magnetic field polarity is the same as those
of Jupiter and Saturn, and opposite to that of Earth.
          Neptune's magnetic field provided another clue to the
planet's structure and behavior.  Observers on Earth hadn't been
able to determine the length of a Neptunian day.  Cloud motions
are a poor indicator of the rotation of the bulk of the planet,
since they are affected by strong winds and vary substantially
with latitude.  The best telescopic estimate was a rotation
period of approximately 18 hours.  The best indicator of the

internal rotation period of the planet is periodic radio waves
generated by the magnetic field. Voyager's planetary radio
astronomy instrument measured these periodic radio waves, and
determined that the rotation rate of the interior of Neptune is
16 hours, 7 minutes.
          Voyager detected auroras, similar to the northern and
southern lights on Earth, in Neptune's atmosphere.  The auroras
on Earth occur when energetic particles strike the atmosphere as
they spiral down the magnetic field lines.  But because of
Neptune's complex magnetic field, the auroras are extremely
complicated processes that occur over wide regions of the planet,
not just near the planet's magnetic poles.  The auroral power on
Neptune is weak, estimated at about 50 million watts, compared to
100 billion watts on Earth.

TRITON
          The largest of Neptune's eight known satellites, Triton
is different from all other icy satellites Voyager has studied.
About three-quarters the size of Earth's Moon, Triton circles
Neptune in a tilted, circular, retrograde orbit (opposite to the
direction of the planet's rotation), completing an orbit in 5.875
days at an average distance of 330,000 kilometers (205,000 miles)
above Neptune's cloud tops.  Triton shows evidence of a
remarkable geologic history, and Voyager 2 images show active
geyser-like eruptions spewing invisible nitrogen gas and dark
dust particles several kilometers into space.
          Triton has a diameter of about 2,705 kilometers (1,680
miles) and a mean density of about 2.066 grams per cubic
centimeter (the density of water is 1.0 gram per cubic
centimeter).  This means Triton contains more rock in its
interior than the icy satellites of Saturn and Uranus do.
          The relatively high density and the retrograde orbit
offer strong evidence that Triton did not originate near Neptune,
but is a captured object.  If that is the case, tidal heating
could have melted Triton in its originally eccentric orbit, and
the satellite might even have been liquid for as long as one
billion years after its capture by Neptune.
          While scientists are unsure of the details of Triton's
history, icy volcanism is undoubtedly an important ingredient.
          To understand what is happening on Triton, one must
ask, "How cold is cold?  How soft is soft?  How young is young?" 
Water ice, whose melting point is 0 degrees Celsius (32 degrees
Fahrenheit), deforms more easily and rapidly on Earth than rock
does, but becomes almost as rigid as rock at the extremely low
temperatures found on Triton, more than 4.5 billion kilometers
from the Sun.  Most of the geologic structures on Triton's
surface are likely formed of water ice, because nitrogen and
methane ice are too soft to support much of their own weight.
          On the other hand, nitrogen and methane, which form a
thin veneer on Triton, turn from ice to gas at less than 100
degrees above absolute zero.  Most of the geologically recent
eruptions at those low cryogenic temperatures are due to the
nitrogen and methane on Triton. 

          Evidence that such eruptions occur was found in Voyager
images of several geyser-like volcanic vents that were apparently
spewing nitrogen gas laced with extremely fine, dark particles. 
The particles are carried to altitudes of 2 to 8 kilometers (1 to
5 miles) and then blown downwind before being deposited on
Triton's surface.
          An extremely thin atmosphere extends as much as 800
kilometers (500 miles) above Triton's surface.  Tiny nitrogen ice
particles may form thin clouds a few kilometers above the
surface.  Triton is very bright, reflecting 60 to 95 percent of
the sunlight that strikes it (by comparison, Earth's Moon
reflects 11 percent). 
          The atmospheric pressure at Triton's surface is about
14 microbars, a mere 1/70,000th the surface pressure on Earth.  
Temperature at the surface is about 38 kelvins (-391 degrees F),
the coldest surface of any body yet visited in the solar system. 
At 800 kilometers (500 miles) above the surface, the temperature
is 95 kelvins (-290 degrees F).
          Despite remarkable differences between Triton and the
other icy satellites in the solar system, photographs reveal
terrain that is reminiscent of Ariel (a satellite of Uranus),
Enceladus (a satellite of Saturn), and Europa, Ganymede and Io
(satellites of Jupiter).  Even a few reminders of Mars, such as
polar caps and wind streaks, can be seen on Triton's surface.
          Triton appears to have the same general size, density,
temperature and chemical composition as Pluto (the only outer
planet not yet visited by any spacecraft), and will probably beour best model of Pluto for a long time to come.

SMALL SATELLITES
          In addition to the previously known satellites Triton
and Nereid, Voyager 2 found six more satellites orbiting Neptune,
for a total of eight known satellites.  The new objects have not
yet been named, a task for the International Astronomical Union
(IAU), but were given temporary designations that tell the year
of discovery, the planet they are associated with and the order
of discovery; for example, 1989N1 was the first satellite of
Neptune found that year.  The final new body was designated
1989N6.
          Nereid was discovered in 1948 through Earth-based
telescopes.  Little is known about Nereid, which is slightly
smaller than 1989N1.  Voyager's best photos of Nereid were taken
from about 4.7 million kilometers (2.9 million miles), and show
that its surface reflects about 14 percent of the sunlight that
strikes it, making it somewhat more reflective than Earth's Moon,
and more than twice as reflective as 1989N1.  Nereid's orbit is
the most eccentric in the solar system, ranging from about
1,353,600 km (841,100 miles) to 9,623,700 km (5,980,200 mi).
          * 1989N1, like all six of Neptune's newly discovered
small satellites, is one of the darkest objects in the solar
system -- "as dark as soot" is not too strong a description.  
Like Saturn's satellite, Phoebe, it reflects only 6 percent of
the sunlight that strikes it.  1989N1 is about 400 kilometers
(250 miles) in diameter, larger than Nereid.  It wasn't

discovered from Earth because it is so close to Neptune that it
is lost in the glare of reflected sunlight.  It circles Neptune
at a distance of about 92,800 kilometers (57,700 miles) above the
cloud tops, and completes one orbit in 26 hours, 54 minutes. 
Scientists say it is about as large as a satellite can be without
being pulled into a spherical shape by its own gravity.
          * 1989N2 is only about 48,800 kilometers (30,300 miles)
from Neptune, and circles the planet in 13 hours, 18 minutes. 
Its diameter is about 190 kilometers (120 miles).
          * 1989N3, only 27,700 kilometers (17,200 miles) from
Neptune's clouds, orbits every 8 hours.  Its diameter is about
150 kilometers (90 miles).
          * 1989N4 lies 37,200 kilometers (23,100 miles) from
Neptune.  1989N4, diameter 180 kilometers (110 miles), completes
an orbit in 10 hours, 18 minutes.
          * 1989N5 appears to be about 80 kilometers (50 miles)
in diameter.  It orbits Neptune in 7 hours, 30 minutes about
25,200 kilometers (15,700 miles) above the cloud tops.
          * 1989N6, the last satellite discovered, is about 54
kilometers (33 miles) in diameter and orbits Neptune about 23,200
kilometers (14,400 miles) above the clouds in 7 hours, 6 minutes.
          1989N1 and its tiny companions are cratered and
irregularly shaped -- they are not round -- and show no signs of
any geologic modifications.  All circle the plant in the same
direction as Neptune rotates, and remain close to Neptune's
equatorial plane.
   

THE RINGS AND "RING ARCS"
          As Voyager 2 approached Neptune, scientists had been
working on theories of how partial rings, or "ring arcs," could
exist.  Most settled for the concept of shepherding satellites
that "herd" ring particles between them, keeping the particles
from either escaping to space or falling into the planet's
atmosphere.  This theory had explained some new phenomena
observed in the rings of Jupiter, Saturn and Uranus.  
          When Voyager 2 was close enough, its cameras
photographed three bright patches that looked like ring arcs.  
But closer approach, higher resolution and more computer
enhancement of the images showed that the rings do, in fact, go
all the way around the planet.
          The rings are so diffuse, and the material in them so
fine, that Earthbound astronomers simply hadn't been able to
detect the full rings.  (Based on Voyager's findings, one Earth-
based observation of the ring arcs is now attributed to the
passage of a small satellite through the ring area.)
          Late in the encounter, the scientists were able to sort
out the number of rings and a preliminary nomenclature:
          * The "Main Ring" (officially known as 1989N1R,
following the IAU convention) orbits Neptune about 38,100
kilometers (23,700 miles) above the cloud tops.  The main ring
contains three separate regions where the material is brighter
and denser, and explains most of the sightings or "ring arcs." 
Several Voyager photographs show what appear to be clumps 

embedded in the rings.  Scientists are not sure what causes the
material to clump.
          * The "Inner Ring" (1989N2R) -- about 28,400 kilometers
(17,700 miles) above the cloud tops.
          * An "Inside Diffuse Ring" (1989N3R) -- a complete ring
located about 17,100 kilometers (10,600 miles) from Neptune's 
cloud tops.  Some scientists suspect that this ring may extend
all the way down to Neptune's cloud tops.
          * An area called "the Plateau," a broad, diffuse sheet
of fine material just outside the so-called "Inner Ring."
          The material varies considerably in size from ring to
ring.  The largest proportion of fine material -- approximately
the size of smoke particles, is in the Plateau.  All other rings
contain a greater proportion of larger material.
          Both Voyagers have now completed all of the planetary
encounters on their itinerary, but both still have work to do. 
Voyager 1 is heading out of the solar system, climbing above the
ecliptic plane in which the planets orbit the Sun.  Voyager 2 is
also outbound, traveling below that plane.  Both are searching
for the heliopause, a boundary that marks the end of the solar
wind and the beginning of interstellar space.  Assuming both
spacecraft remain healthy, flight controllers expect to be able
to operate the spacecraft for another 25 to 30 years,
investigating magnetic fields and particles in interplanetary and
interstellar space, and observing ultraviolet sources among the
stars.
          The Voyager Project is managed by the Jet Propulsion
Laboratory for NASA's Office of Space Science and Applications.  
##### 
12-20-89 DB/AMS
