From: patth@sci.ccny.cuny.edu (Patt Bromberger)
Newsgroups: misc.handicap
Subject: Paper on Reading Disabilities
Message-ID: <27023@handicap.news>
Date: 8 Jan 93 20:00:12 GMT
Originator: wtm@sheldev.shel.isc-br.com
Lines: 1736

Index Number: 27023

      NEUROPSYCHOLOGICAL BASES OF EDUCATIONAL DISABILITIES

           Implications for Diagnosis and Remediation

          Expert Paper Submitted to the United Nations
                     Disability Unit, Vienna
                         February, 1990

                    Robert Zenhausern, Ph.D.
                     Professor of Psychology
                      St. Johns University
                        Jamaica, NY 11439
                               USA

                          INTRODUCTION

     The paragraphs below are in the form of a satire based on the
essay by Jonathan Swift entitled "A Modest Proposal" in which he
presented a solution to the "Irish Problem".  The parallel here is
Learning Disability and the inflexible ways these children are
taught.  It is the objective of this paper to show that the problem
of the learning disenfranchised is one that can be solved by
increasing the flexibility with which we teach.
  Another Modest Proposal:
               A Swift Response to an Old Problem
   The purpose of this essay is to examine the possibility that we
are systematically doing a disservice to a large segment of the
school population.  Students who have auditory or visual
impairments have been allowed to use artificial means, such as
glasses or hearing aids, to correct their deficits.  Indeed, it is
considered praiseworthy to identify such problems early and then
use the services of professionals who prescribe optical or
electronic devices which alleviate the deficiencies.
   The consequences of such actions, however, have not been
considered fully.  Such children may become lazy and make no
attempt to overcome their problems.  What motivation will they have
to strengthen their perceptual weaknesses when such devices make
it unnecessary for them to do so?  What will such people do if, for
whatever reason, such devices are not available? It is the
contention of this paper that artificial devices are crutches which
interfere with the complete development of the child.  As such,
they should be eliminated.
   Some might argue (and not without a modicum of validity) that
by eliminating those "support systems," such children may not
progress beyond the elementary rudiments of learning.  That,
however, should be secondary to the point that we are not dealing
directly with a serious problem.  The fact that our present state
of knowledge does not allow us to correct such deficiencies should
not dissuade us from this course of action.  Eventually specific
techniques will be developed to meet the problems of poor eyesight
and hearing in much the same way that techniques were developed to
alleviate reading and mathematical difficulties -- and probably
with as much success.  There is a minor problem in the fact that
many of the authority figures in the child's environment use those
same artificial devices and thus do not serve as good role models.
     Aside from the educational wisdom of this proposal, it has the
added advantage of eliminating the possibility of charges of
discrimination.  Consider, for example, if someone raised the point
that a deficit in vision or hearing might be compared to a deficit
in arithmetic computation.  They might argue that if vision can be
corrected by glasses why can a calculation deficit not be corrected
by the use of a calculator?       It is difficult to counter these
arguments since the two deficits have so much in common.  Even the
poor role model problem has a parallel since most of the authority
figures whom the children contact would have some difficulty in
taking a square root or doing long division of decimals by hand.
The conclusion is clear: take away glasses and hearing aids and
give the children with sensory defects the same advantages given
to children with calculation defects!
               *                   *                   *
     The essay is clearly satirical, but its point is clear.  In
this Decade of the Disabled it is essential to consider the human
rights of the Learning Disabled to an education that more closely
fits their capabilities.  The problems of the Learning Disabled are
unique because this is the only disabled group which is held
responsible for its disability.  "If he worked harder, he could do
it", says the frustrated teacher.  No one expects a blind person
to see, if he or she "worked harder".  Furthermore, to call a child
"learning disabled" is to put the burden of responsibility on the
wrong person! It is our responsibility to teach much more than it
is the responsibility of the child to learn.  It is we who should
be called teaching disabled.  The purpose of this paper is to focus
attention on individual differences among both normal and learning
disabled children and to consider alternative approaches to
education and thus eliminate our teaching disability.  The major
emphasis will be on the theory and remediation of reading
disability based on a 10 year program of research within a
neuropsychological framework.  The initial Chapter will introduce
the concepts of cerebral asymmetry and hemisphericity and put them
in perspective for education today.  The second Chapter will
discuss behavioral and physiological measures of individual
differences in neuropsychological functioning.  The third Chapter
will describe a study that underlines the importance of these
individual differences in an educational setting.  The fourth and
fifth Chapters will describe a series of studies dealing with the
theory, diagnosis and remediation of reading disability that has
been based on these neuropsychological concepts.  The final Chapter
will be a summary that includes the basic information on the Direct
Access approach to reading with specific recommendations.  It can
serve as an abstract of the whole paper.
     This Introduction ends with a short quote, found hanging on
the walls of an elementary school in Greensboro, North Carolina and
attributed to Ken Dunn.

If children cannot learn the way we are teaching them,
then we must teach them the way they can learn.

                            CHAPTER 1
  THE CEREBRAL HEMISPHERES OF THE BRAIN AND THE NEW PHRENOLOGY

     Recent work in the areas of neuropsychology, especially that
of Sperry who won the Nobel Prize, has popularized the notion of
cerebral asymmetry.  That is, the two hemispheres of the brain are
different in terms of the cognitive processes in which they excel.
There is clear evidence that the Left Hemisphere has unique control
of expressive speech and operates using a sequentially organized
system.  The Right Hemisphere, on the other hand, has systems that
are more capable of spatially and pictorially oriented processing.

     While there are clear differences between the hemispheres,
these differences have been overgeneralized into a new phrenology
of brain functions.  A typical list of "Left Hemisphere Functions"
reads something like: logical, verbal, analytic, inductive,
controlled; the Right Hemisphere is often called: synthetic,
emotional, deductive, intuitive, and abstract.  Some of these
labels are self-contradictory.  The Left Hemisphere is called both
analytic and inductive and the Right Hemisphere both synthetic and
deductive.  The term "abstract" has two diametrically opposed
meanings: an article abstract versus abstract art.  These
inconsistencies aside, this neo-phrenological approach must be
rejected on the grounds that it is atomistic.  A hemisphere is
neither verbal, logical, emotional, nor creative; it is a person
who has these characteristics!  All behavior flows from the
integrated functioning of the whole brain.  This does not mean,
however, that there are no individual differences associated with
the brain.  The concept of Hemispheric Related Strategies provides
a framework on which to base an individual difference variable.
     For the most part, the two hemispheres do the same things but
do them using different approaches.  Cerebral asymmetries reflect
relative efficiency rather than a "can do-can't do" dichotomy.
There seems to be one exception to this relative rather than
absolute difference between the hemispheres:  for most people, only
the left hemisphere is capable of speech and of phonetic
representation (Levy, 1974).  The isolated Left Hemisphere can tell
whether the two words "though" and "blow" rhyme but the isolated
Right Hemisphere can not, even though it may understand their
meaning.  Rhyming demands that the written word be converted to an
auditory form and only the left hemisphere has this capability.
   A second factor that differentiates the two hemispheres is their
type of processing systems: sequential for the left hemisphere and
parallel for the right hemisphere (see Bradshaw and Nettleton, 1981
for a review.)  Compare these two situations:  1) You are given a
description of someone and must then identify that person; and 2)
You are shown a picture of the person and then must select the
person.  The first task demands the sequential system of the left
hemisphere--the words, descriptive of the various facial features,
are read in sequence and must be combined into an overall
perception.  The latter situation reflects the parallel system of
the right hemisphere -- the picture is seen as a whole and various
facial features can be extracted.   The picture is seen all at once
in parallel while the verbal description must be sequentially
processed.        The sequential processing system of the Left
Hemisphere and its ability in speech production are the
characteristics that underlie the notion that the Left Hemisphere
is the verbal hemisphere.  Language, by its very nature, is
sequential.  Word order and syntax are essential to meaning--
language cannot be easily processed in parallel.  Thus the left
hemisphere has been labeled the "verbal" hemisphere because its
sequential processing system is compatible with the sequential
nature of language, and its control of auditory linguistic
processes makes it essential for speech.
     For other tasks, even though the processing system of either
hemisphere is compatible with the task, one hemisphere is clearly
superior.  The example of face recognition shows intuitively that
the Right Hemisphere pictorial approach is better than a Left
Hemisphere written description.  Note, however, that the task can
be done using Left Hemisphere strategies, but it takes a thousand
words to describe one picture.        Spatial relations tasks are
also more easily handled using Right Hemisphere processes.  Other
tasks can be handled equally well using the strategies of either
hemisphere.  For example, a list of words could be learned by
converting and storing them as visual representations or in an
auditory form.  The term Hemispheric Related Strategies can be used
to describe this relationship between observable behavior and its
underlying neuropsychological bases.

Hemispheric Cognitive Style
     Two individuals, when faced with the same task, do not
necessarily use the same strategies, that is, people do things in
different ways.  Sometimes those different approaches can be
associated with processing differences between the two cerebral
hemispheres.  These different approaches can be termed Hemispheric
Related Traits.  Hemispheric Cognitive Style is the tendency of an
individual to use distinct patterns of Hemispheric Related Traits.
It does not imply that one hemisphere is used exclusively, but that
individuals tend to approach tasks in unique and consistent ways.
For example, if a group of individuals were asked to remember the
words "dog, cat, tree, table, chair", few would have difficulty.
If these same individuals were asked what strategies they used,
there would be wide variation.  Some would report they repeated
the words to themselves, others that they "saw" the written form
of the word, and others would create images of the words.
     These differences in memory strategies can be related to
Hemispheric Related Traits. A person who would be more likely to
use imaginal strategies could be said to use a right Hemispheric
Related Trait, and a person who used auditory strategies could be
said to use a left Hemispheric Related Trait.  Some individuals
tend to use the Hemispheric Related Traits associated with one
hemisphere more than those of the other hemisphere and others show
little or no bias.  Those who do favor the Hemispheric Related
Traits of one hemisphere can be said to have a Right or Left
Hemispheric Cognitive Style.      It is important not to
overgeneralize the scope of Hemispheric Cognitive Style.  The fact
that a person tends to use particular strategies implies neither
a disuse nor deficiency in one hemisphere of the brain.  On a very
simple level, a right Hemispheric Cognitive Style individual has
access to the speech centers of the left hemisphere just as a left
Hemispheric Cognitive Style individual has access to the prosody
centers of the right hemisphere.  Thus both right and left
Hemispheric Cognitive Style individuals rely on the integrated
functioning of both hemispheres for expressive speech, and, in
fact, all behavior.      In an intact individual, no task can be
accomplished without the integrated functioning of both
hemispheres.  To call an individual "left or right brained" is to
ignore the fact that all activity depends on the integrated
functioning of the whole brain.  These differences, however, can
be related to different strategies with which people approach
specific tasks.  One purpose of this paper is to show how these
strategy differences can affect the educational system.  The next
chapter will describe how differences in Hemispheric Related Traits
can be measured.  The following chapters will focus on the
application of these traits to mainstream and learning disabled
education. 

                            CHAPTER 2
         THE MEASUREMENT OF HEMISPHERIC COGNITIVE STYLE

     Two distinct tools have been used in the measurement of
Hemispheric Cognitive Style, one behavioral and the other
physiological.  The behavioral measure is a self rating
questionnaire and the physiological measure relies on the
predominant direction of Lateral Eye Movement (LEM).

The Hemispheric Preference Questionnaire
     There are many questionnaires that have been used to measure
"hemisphericity" including many from popular magazines.  Over the
past 12 years I have developed an instrument that has been
successfully used to separate right and left Hemispheric Cognitive
Styles.  A copy of the questionnaire and its scoring key has been
included.  The following studies used the instrument successfully.
Coleman and Zenhausern (1979) compared those who used right and
left Hemispheric Related Traits on a memory retrieval task.  They
found the two groups differed on processing speed and the extent
of a left hemisphere bias induced by a verbal memory load.  The
bias was four times stronger for the those who use left Hemispheric
Related Traits than for those who use right Hemispheric Related
Traits.  Zenhausern and Nickel (1979) found that Right style
individuals learned a finger maze in fewer trials, in less time and
with fewer errors than Left style individuals.  Zenhausern, Notaro,
Grosso, and Schiano (1981) presented right and left style
individuals with auditory messages in which there was a conflict
between verbal content and emotional tone of voice.  Overall, those
who used right Hemispheric Related Traits responded significantly
more often to the inflection cues and those who use left
Hemispheric Related Traits significantly more often to the verbal
content.  Zenhausern and Dunivin (1981) found that left style
subjects were more obsessive compulsive, while right style subjects
had more hysterical traits.  Zenhausern and Parisi (1983) have
found that schizophrenics rate themselves as using left while
depressives rate themselves as using right hemisphere related
strategies.      The instrument has been used in the area of
reading disability to distinguish two separate syndromes.  Oexle
and Zenhausern (1980), Golden and Zenhausern (1981), Zenhausern
and Sinatra (1983), Maxwell and Zenhausern (1983) have found that
85% of reading disabled children rate themselves as using more
right than left hemisphere strategies.  A copy of the test and its
scoring key can be found in Table 2.1.

Lateral Eye Movements
     Research into the phenomenon of lateral eye movements (LEM)
as a behavioral measure of neuropsychological activity has been
pursued along two separate dimensions.  LEM have been considered
a measure of both individual differences and task demands. From a
neuropsychological perspective, the individual difference aspects
have been associated with the concept of cognitive style and the
effects of task demands with hemispheric asymmetry. There is,
however, considerable controversy as to whether LEM do indeed have
neuropsychological relevance.  The importance of LEM has been
overgeneralized to the point of faddism, which has led to a general
reluctance on the part of the scientific community to give them
credence. In addition, researchers in the area have sometimes
failed to distinguish between these two different aspects of LEM.

                            Table 2.1
     The Preference Test for Hemispheric Related Strategies

Indicate your choice by assigning a number from 1 to 10 (with 1
being the lowest) on each question.   To score the test, refer to
the scoring key below.  Add the ratings for all the items that are
to be scored right and those that are to be scored left, subtract
the two and divide by 10.  The larger number shows the predominant
preference and the greater the difference the larger the HRS
preference.  You should then develop your own local norms, but as
a rule of thumb a score of .7 or higher can be considered a clear
indication of a preference for a Hemispheric Related Strategy.

                           Test Items

1)   Do you base your decisions on objective facts rather than
     feelings?
2)   Are you psychic?
3)   Do you like using symbols or images in solving problems?
4)   Are you artistically or musically creative?
5)   Are you logical?
6)   Are you good at solving crossword puzzles?
7)   Can you read quickly?
8)   Are your daydreams vivid?
9)   Can you think of synonyms for words easily?
10)  Do you remember dreams?
11)  Are your dreams vivid?
12)  Are you fluent in using words?
13)  Are you good at using images in remembering and thinking?
14)  Do you use a playful approach to problem solving?
15)  Do you use a serious, all business approach to problem
solving?  16)  Do you like to keep experiences planned and
structured?
17)  Do you like to read or think while sitting upright?
18)  How much does your thinking consist of words?
19)  How much does your thinking consist of mental imagery?
20)  Do you like to explain something using visual presentation?

                           SCORING KEY

     Item      Scoring
     1         L
     2         R
     3         R
     4         R
     5         L
     6         L
     7         L
     8         R
     9         L
     10        R

                                        Item      Scoring
                                        11        R
                                        12        L
                                        13        R
                                        14        R
                                        15        L
                                        16        L
                                        17        L
                                        18        L
                                        19        R
                                        20        R
Individual Differences and LEM
	Research into whether LEM
reflect individual personality differences was initiated by Day
(1964), who reported that the direction of LEM was related to
individual styles of   coping with anxiety. Bakan (1971) was the
first to propose that the direction in which a person consistently
shifted gaze was related to which of the cerebral hemispheres an
individual used more often.
     The relationship between LEM and various dimensions of
individual differences has been explored. Tucker and Suib (1978)
found that left-movers had higher scores on the Performance tests
of the WAIS and did better with imagery oriented questions while
right-movers had better scores on the Verbal subtests of the WAIS
and with questions that were letter and number oriented (e.g., how
many letters are in the word house).       Gur and Gur (1975)
showed a relationship between direction of LEM and defensive style.
Predominantly rightward movers more often reported using projection
and "turning against others" as their main defenses, while
predominantly leftward movers reported using repression and denial
more often. LEM were again shown to be related to defensive styles
in males as measured by the Defense Mechanism Inventory (Krikorian
and Rafales, 1983).  This effect was not replicated with females,
however (Thompson, Greenberg, Fisher, 1982). In addition, subjects
who moved their eyes bidirectionally rather than predominantly to
the left or the right were shown to have better adaptive coping
styles ratings on the adjective check list (Parrott, 1984).
     Smokler and Shevrin (1979) showed that normal subjects with
hysterical tendencies made more leftward LEM than subjects with
obsessive compulsive tendencies.  The latter group was more likely
to show rightward LEM.  Gur (1978) and Schweitzer (1979) found that
schizophrenics had predominantly leftward LEM.
     The relationship between LEM and cognitive styles has also
been explored.  Subjects, who scored as left or right style
oriented on the Laterality Preference Schedule, were shown to have
consistent patterns of LEM, indicating the existence of consistent
patterns of information processing (Breitling and Bonnet, 1985;
Bruce, Herman, and Stern, 1982).  When using the Your Style of
Learning and Thinking Test (SOLAT) to measure style of thinking,
however, no relationship was found between LEM and thinking style
preference (Alberts and McCallum, 1982).  In addition, Owens and
Limber (1983) found no relationship between cognitive style and
LEM.
     One area of interest in the cognitive style research is the
relationship between what are considered right style ways of
thinking (holistic and broad) and left style ways of thinking
(analytic and narrow) based on proposed functions of the individual
hemispheres.  In support of the theory that eye movements indicate
hemispheric activation, and that left hemisphere activation is
associated with more analytic and narrow styles, Huang and Byrne
(1978) showed that narrow categorizers based on the Pettigrew's
Category Width Scale made more leftward LEM than broad
categorizers.
     Another area of interest has been the relationship between the
ability to recall dreams and LEM.  Predominantly leftward LEM have
been associated with the ability to vividly recall dreams in male
subjects (Leboeuf, Mckay, Clark, 1983), but the same has not been
found with females (Van Nuys, 1985). A related issue is that of
creativity and LEM.  Leftward eye movement has been associated with
thinking of more uses of objects on the Uses Test, which is often
used as a measure of creativity (Falcone and Loder, 1984).
Zenhausern (1987) has shown that LEM can differentiate between two
different types of reading disabled children.  Specifically,
rightward LEM are characteristic of reading disabled children who
are unable to derive meaning from the written word despite being
able to say it.  Leftward LEM are characteristic of reading
disabled children who are unable to pronounce the word despite
understanding what it means.  This sampling of research indicates
the scope of individual differences that have been associated with
LEM.       In their critique of the LEM literature, Ehrlichman and
Weinberger (1978) concluded that LEM are reliable measures of
individual differences.  They found that despite differences in
methodology and experimental situations the direction a person
moves his or her eyes is a consistent behavior of that individual.
The individual difference studies above indicate their behavioral
relevance.

Functional Hemispheric Asymmetry and LEM
     A second perspective on the nature of LEM was introduced by
Kinsbourne (1972) who proposed that LEM reflect the task demands
on the subject.  He suggested that those tasks that require input
predominantly from the left hemisphere resulted in rightward LEM,
the direction away from the left hemisphere; those tasks that
required predominantly right hemisphere functions resulted in
leftward LEM, away from the right hemisphere.       There has been
mixed support for this relationship between LEM and question type.
The critical variable has usually been whether rightward LEM are
associated with verbal questions, indicating a relationship between
a verbal task and left hemisphere activation.  A wide variety of
what have been called "verbal" questions have been used, however.
     Galin and Ornstein (1974) reported a relationship between
rightward LEM and logical problems and leftward LEM and visual
imagery tasks.   Proverb interpretation has been shown to be
related to rightward LEM (Kinsbourne, 1972; Gur, 1975).  Schwartz,
Davidson and Maer, 1977, found a relationship between LEM and task
demands.       There have been recent reports of relationships
between both rightward LEM and verbal questions (Hugdahl and
Carlgren, 1981; Ogorman and Siddle, 1981) and leftward LEM and
visual spatial tasks (Swinnen, 1984). In addition to the
verbal/non-verbal dichotomy, emotionally laden questions were used
to elicit predominantly leftward LEM (Krikorian and Rafales, 1983;
Jamieson and Sellick, 1985).
     Not all studies have resulted in significant findings. In
fact, Ehrlichman and Weinberger concluded that the evidence for a
relationship between LEM and question type was not convincing on
both empirical and theoretical grounds.  From the empirical point
of view, they noted that of the 21 studies reviewed, 10 resulted
in rightward movement in response to verbal questions, and 11
resulted in no difference in LEM to verbal and non verbal
questions.  The authors concluded that the literature thus did not
offer strong support that LEM were related to question type.
     A re-evaluation of the empirical studies, however, indicates
that there is a consistent relationship found between the type of
question asked and the direction of LEM.  In only one of the 21
studies reported by Erhlichman and Weinberger did verbal questions
lead to leftward LEM.  While the conclusion that verbal questions
lead to rightward LEM may be in question, the conclusion that
verbal questions do not lead to leftward LEM is strongly supported.
There may be a relationship between task demands and LEM, but it
is not a simplistic "verbal question leads to rightward LEM
relationship".
     There is clear evidence that LEM are related to both the type
of question asked and individual difference factors.  Therefore,
in any situation, LEM reflect the type of question asked
interacting with the individual differences and it is essential to
separate the two effects.
     Two distinct tasks were used in a study by Zenhausern and
Kraemer (1989) to investigage the dual nature of LEM.  One task is
purely informational and cannot be uniquely connected with either
hemisphere of the brain.  The second task involves rhyming of non-
words which clearly demands the speech centers of the left
hemisphere.  Two experimental questions were addressed.  1) Is the
direction of LEM consistent within an individual both across time
and across tasks?  2) Does the type of question asked have an
effect on the direction of LEM?
     A total of 50 adult subjects were tested.  There were 16 males
and 34 females, with an average age of 27 and a range of 16 to 50.
The stimuli for the rhyme task were four to five letter nonsense
words printed in black ink on white index cards and a series of
prepared questions.
     The subjects were informed that they were participating in a
study involving the different ways in which people think.  They
were asked two kinds of questions in a face to face encounter with
the experimenter. The subject responded yes or no with a nod or
shake of the head and the initial direction of eye movement to each
of 40 questions was recorded for each subject. These non-verbal
responses were used to eliminate left hemisphere involvement
through speech which was unrelated to the task.       The 20
informational questions did not call on any clearly defined brain
areas (Is Miami the capitol of Florida?).  The 20 rhyme questions,
on the other hand, clearly demanded the auditory linguistic
capabilities of the left hemisphere. The subject was shown a
nonsense word on an index card and told to remember it. The card
was removed and another nonsense word was verbally spelled by the
examiner and the subjects were asked whether the two words rhymed.
The subjects were tested in two blocks of 20 trials separated by
30 minutes.  Within each block 10 informational and 10 rhyme
questions were asked.
     The data were first explored by means of a correlational
analysis. Both test-retest and split half reliabilities for
informational questions and for rhyme questions are shown in Table
2.2.  In addition, the correlation between rhyme and informational
questions is also presented. LEM are clearly a consistent measure
of individual differences with reliability coefficients averaging
approximately .80 for the same type of question.  When the type of
question was changed, however, there was a dramatic drop in the
consistency of LEM although the correlations were still
significant. The direction of LEM changed as a function of task
demands, but not to the extreme that would result in no
correlation.

Table 2.2
Intercorrelations Among LEM for Information and Rhyme Questions

                         Split Half          Test Retest
Rhyme                       .85                 .78
Information                 .79                 .83
Rhyme with Information             .59

     An initial analysis on the two 20 question blocks indicated
no significant differences and the two were collapsed into a single
set of questions. The data were then analyzed by means of a split-
plot analysis of variance with LEM Group (whether a subject had
predominantly rightward or leftward movement) as a between factor
and Task (Rhyme and Informational questions) and Direction of
Movement (Right, Left, and Stares) as between factors.  Since the
scores are ipsative and the Grouping factor and dependent variable
are related, only the interactions are of interest in this design.
There was a significant interaction between the Direction of
Movement and Task.  The results are shown in Table 2.3 below.

Table 2.3
Number and Direction of LEM as a Function of Type of Question

Task                          Direction of LEM
                    Right          Left      Stare

Rhyme               6.82           7.64      4.92
Information         5.50           7.50      6.50

     Simple effects analysis indicated that the number of leftward
LEM to informational and rhyme questions were not significantly
different, but there were significantly more rightward LEM than
leftward LEM to rhyme questions.  There were no interactions
involving the LEM Group factor, indicating that the effects of the
type of question were the same for both groups.
     These results lead to two conclusions.  The first is a
verification of the Ehrlichman and Weinberger (p 1093) conclusion
"...that LEM patterns are reliable characteristics of persons."
Individuals do move their eyes in a consistent direction and
direction of LEM is a reliable measure of individual differences.
The questions, however, remain as to whether LEM differences can
be related to behavior and whether these behaviors have
neuropsychological implications.  Some of the research reported
above has shown the scope of the variables that have been related
to differences in LEM.  (A fuller listing can be found in Beaumont,
Young, and McManus, 1984). Not every study has shown that LEM
differences were related to differences in performance, but no one
should expect LEM to be related to all behavior.
     The final question remains, however, as to whether LEM have
neuropsychological implications. In a very general sense, all
behavior results from brain activity and thus all behavior has
neuropsychological implications.  From a more focused point of
view, LEM have been related to behaviors that neuropsychologists
have associated with the brain.  The problem has been, however,
that the association of the behavior with the brain has not always
been clearly specified.  Logical problems, proverbs, and spelling
have all been used as verbal tasks.  These tasks are extremely
complex and clearly involve both hemispheres of the brain, even
though there may be a portion of the task that is especially
dependent on left hemisphere processing.  This was clearly shown
in the present study since the rhyming task demanded the unique
ability of the left hemisphere to create the sound of the printed
word.  The information task had no such clear connections to either
hemisphere of the brain.  Both the correlations and analysis of
variance results pointed to the fact that LEM were different for
the two tasks, with an increase in the number of rightward
movements for the rhyming task.  This change, however, was
relatively subtle. Even though the task demanded specific left
hemisphere input, subjects did not make predominantly rightward
LEM; there was only a shift in that direction.  A subject who made
predominantly leftward movement continued to do so, but the number
of rightward movements increased and the number of stares
decreased.
     Lateral Eye Movements have been shown to be a reliable measure
of individual differences, as well as a response to the type of
questions asked.  The importance of both aspects, however, should
not be overemphasized.  The individual difference aspect must be
investigated from a more behavioral point of view. Rather than
comparing a lawyer or a scientist with an artist, determine whether
a courtroom lawyer has more in common with an actor or a corporate
lawyer, or whether a geometrician has more in common with an artist
or an algebraist.
     The LEM response to task demands must also be considered in
conjunction with the fact that any task demands the integrated
functioning of the whole brain.  The variable extent to which a
task places special emphasis on one hemisphere must be considered
within this integrated functioning. LEM can be a useful tool, but
their value and meaning can be misunderstood all too easily.   The
next Chapter provides evidence of the usefulness of LEM within a
normal classroom setting.
     This chapter has presented the evidence that Hemispheric
Related Strategies can be measured by means of questionnaires and
LEM.  The following chapters will provide evidence that this
individual difference variable has significance for education.

            Chapter 3
        THE INTERACTION OF HEMISPHERIC RELATED STRATEGIES
                   AND INDIVIDUAL DIFFERENCES

     The purpose of this Chapter is to provide evidence that the
individual difference aspect of LEM has meaningful behavioral
correlates in an educational setting.  No assumptions were made as
to the neuropsychological substrate of LEM.  They were used simply
as a means of dividing subjects into two groups:  those who move
their eyes predominantly to the right and those who move them
predominantly to the left.  Half of the right movers were taught
a learning strategy involving verbal rehearsal and the other half
a learning strategy involving imagery. The same procedure was
followed for the left movers.  The question was whether there is
a relationship between the typical direction of LEM and the
effectiveness of the two learning strategies.
     The subjects were drawn from a pool of 120 average or above
average fifth and sixth graders in a suburban school system. A
series of verbal, spatial, imaginal, and informational questions
were asked in a face to face situation and the 72 subjects who had
the most extreme number of left movements and the most extreme
number of right movements participated in the study.  The subjects
were divided into equal numbers of male and female right and left
movers.
     Seventy-two words appropriate to fifth and sixth graders and
matched for abstractness, concreteness, and imagery were chosen
from the list provided by Pavivo, Yuille, and Madigan (1968).   Two
equivalent sets consisting of 18 pairs, created from this list,
served as the learning stimuli.  Two distractor lists of 12 pairs
each were also created using the same procedure.  Each pair was
then photographed and developed as 35mm slides.
     Each subject, tested individually, was seated approximately
4 ft. from a screen on which the 18 pairs of words were presented
by means of a slide projector for 4 sec.  The child was then asked
to recall as many pairs of words as possible and the number of
correct pairs served as one dependent variable.  The subjects were
then shown 24 pairs of words, half of which they had already seen
and half of which were distractors.  These slides were then
presented and the subject had to indicate by switch closure whether
they had seen the word pair.  Both accuracy and response time (in
milliseconds) were measured.  Following this pre-training
procedure, half of the subjects whose LEM were predominantly
leftward and half whose LEM were predominantly rightward, were
taught a verbal rehearsal strategy in order to improve performance.
They were instructed to repeat the pairs of words as many times as
possible during the 4 sec interval between pairs.  They were then
given six practice trials.  The remaining subjects were instructed
on how to form an integrated image from the word pairs.  They were
also given six practice trials.  The subjects were then tested on
18 new pairs of words using the same procedures as in the pre-
training condition.  This effectively created four groups: right
movers taught to use either imagery or verbal rehearsal strategies
and left movers taught the same strategies.
     There were three dependent measures that were analyzed in this
study: the number of pairs recalled, the number of pairs
recognized, and the response time for recognition.  The design for
all three variables was a split plot factorial with Direction
(leftward or rightward LEM) and Strategy (verbal rehearsal or
imagery) as the between  factors and Time (before or after
training) as the within factor. The mean number of correct pairs
recalled under all conditions is shown in Table 3.1.

Table 3.1
Mean Number of Word Pairs Recalled for Right and Left Movers Under
Verbal Rehearsal and Imagery Instructions

     Set                 Pre Test        Post Test

Verbal
     Left Movers         3.39                1.78
     Right Movers        1.89                2.61
Imagery
     Left Movers         2.61                3.28
     Right Movers        2.39                2.56

     The analysis of variance indicated no significant differences
involving Direction or Strategy, but there was a significant
interaction of Direction, Strategy. and Time.  Simple effects
analysis indicated that children with rightward LEM did not change
as a result of imagery instructions, but made a significant
improvement as a result of verbal rehearsal instructions.  Children
with leftward LEM made a significant improvement as a result of
imagery instructions, but showed a significant decrement as a
result of verbal rehearsal instructions.
     Mean performance for the recognition scores is presented in
Table 3.2.  The analysis of variance again indicated a significant
interaction between Direction, Strategy and Time.

Table 3.2

 Set                          Pre Test            Post Test

Verbal
     Left Movers              29.28               27.61
     Right Movers             28.11               29.44
Imagery
     Left Movers              29.56               30.67
     Right Movers             29.89               29.44

     The simple effects analysis indicated that children with
rightward LEM showed a significant improvement using a verbal
rehearsal strategy and children with leftward LEM showed a
significant decrement using a verbal rehearsal strategy.  The mean
reaction times for the recognition task is shown in Table 3.3.  The
analysis of variance indicated that there was an overall decrease
in reaction time from pre to post testing and the same significant
three way interaction of Direction x Strategy x Time.

Table 3.3
Mean Reaction Times (in milliseconds) for the Recognition Task

Set                      Pre Test       Post Test

Verbal
     Left Movers         2059                2118
     Right Movers        2447                1894
Imagery
     Left Movers         2244                1829
     Right Movers        1846                1627

     Statistical analysis indicated that children with rightward
LEM were significantly faster using a verbal rehearsal strategy and
children with leftward LEM were significantly slower using a verbal
rehearsal strategy. The analyses of the three variables lead to the
single conclusion that children who have predominantly leftward LEM
should not be taught by a verbal repetition strategy.
     From the theoretical perspective, these results support the
findings of Ehrlichman and Weinberger that LEM are a reliable
measure of an individual difference variable. It also provides
evidence of the validity of LEM; individuals who differed on LEM
showed differences on a relevant behavioral measure -- verbal
learning.  The most important question, however, is whether LEM
have any relationship to brain organization.  Individuals who had
predominantly rightward LEM showed better retention when using the
left hemisphere oriented strategy of verbal rehearsal and
individuals who had predominantly leftward LEM showed decreased
retention when using the left hemisphere oriented strategy.  These
are the facts, and while it is premature to draw firm conclusions,
these facts are consistent with the existence of a relationship
between LEM and brain organization.      The clearest conclusion
from these findings is that children differ in the extent they can
benefit from a verbal repetition strategy in learning.  From the
educational perspective it is clear that there are children in
schools who not only do not benefit from a verbal rehearsal
strategy, but whose performance is actually decreased.  Spelling
and arithmetic tables are examples of subjects that usually stress
a rote memorization based on oral repetition.  One alternative
would be to have the child repeatedly image the letters of the word
or number facts without verbalizing them.  When it came time to use
the word or number fact the child would recall the image.
Educators must become more aware of the individual differences in
the way people learn.  This becomes even more evident in the next
chapter where these individual differences can be seen to be at the
heart of what has been called reading disability.

                            Chapter 4
               THE DIAGNOSIS OF READING DISABILITY

     Although there is general agreement that reading disability
is not a single entity, there is considerably less than a consensus
as to the number of different syndromes that actually exist.
Neuropsychological assessment, the types of errors made with verbal
material, cognitive tests, and differences in processing strategies
have all been used in the classification of the reading disabled
into symptom-related subtypes. As many as five different subtypes
of reading disability have been found through the use of
neuropsychological tests.
     For example, Mattis, French and Rapin (1978) reported three
groups and Doehring, Honshko, and Byans (1979) distinguished four
types. Fisk and Rourke (1979) Petroskas and Rourke (1979) have
identified subgroups which were consistent.  These subtypes,
however, can be considered in terms of the presence or absence of
auditory linguistic deficits, a distinction reported throughout the
reading disability literature.  Subtypes that include auditory
linguistic deficits comprise 80 to 90 percent of the total
population of reading disabled children.  The smaller group has
usually been reported to show deficits in visual spatial
processing.
     Boder (1973) examined the nature of the spelling errors made
by reading disabled children.  She used the term dysphonetic to
describe the type of reading disability marked by linguistic and
phonetic difficulties; and the term dyseidetic to describe the type
which had difficulties with the overall visual spatial aspects of
the written word.  Boder estimated that the dysphonetic group was
four to five times more prevalent than the dyseidetic group.
Pirozzolo (1979) used ratings, writing samples, and psychological
and neuropsychological tests to separate two reading disability
groups that were similar to those suggested by Boder.  Bakker
(1982) proposed a similar distinction that he related to
hemispheric functioning.  The auditory linguistic disabled reader
was not effective in the use of left hemisphere related tasks.
There was also an association of the visual spatial disabled reader
and the effective use of right hemisphere related strategies.
     Zenhausern (1987) distinguished these two types on the basis
of both reading related tasks and the predominant direction of
their lateral eye movements.  He found that the majority of
children with leftward lateral eye movements had difficulty
determining whether words in their sight vocabulary did or did not
rhyme.  He also found that a group of children with predominantly
rightward lateral eye movements had no difficulty in determining
whether two words rhymed, but were deficient in determining whether
words and pictures represented the same concept.  The auditory
linguistic group had difficulty converting a word to its sound and
the smaller group showed deficits in converting a word to its
meaning.  He used the terms Phonetic and Semantic to describe this
distinction.      From a behavioral perspective, phonetic disabled
readers are the children who struggle with every word when they
read aloud and thus lose continuity in the text.  They are
frequently anomic and have a general difficulty with the auditory
linguistic aspects of reading, especially the grapheme to phoneme
conversion. The Semantic disabled reader, on the other hand, is the
child who will give a perfect word for word rendition of text, but
has no comprehension of the meaning of that text. The Semantic
disabled readers can convert words into their phonetic
representation, but this representation is not converted into its
meaning.  They have no problems with the sound of a word but are
at deficit for tasks involving the meaning of words.
     The original study was based on 13 Phonetic and 13 Semantic
readers from the second to fourth grades.  One purpose of this
research was to determine whether these Phonetic and Semantic
subtypes would replicate across the entire elementary school
population.  A second goal of this study was to replicate the
second finding of the original study. The Phonetic disabled readers
moved their eyes predominantly to the left and Semantic disabled
readers predominantly to the right. This second purpose was an
attempt to determine whether lateral eye movements can be used as
a marker variable for the two types of reading disability.
     The subjects in this study were 160 children from the second
to the eighth grades.  All were of at least average intelligence.
Forty children were selected at grades 2 or 3, grades 4 or 5,
grades 6 or 7, and grade 8. Of the 40 children at each age level,
20 were at or above grade level and 20 children were at least one
year below grade level in reading.  Half of each group were chosen
on the basis of showing rightward LEM and half leftward LEM. The
predominant direction of LEM was determined individually for each
child.  A series of 20 informational questions were asked in a face
to face situation and the predominant direction of LEM was noted.
Normal readers split evenly between right and left movers, but 84%
of the disabled readers were left movers.
     There were four kinds of reading related tasks that used words
selected from the individual sight vocabulary of each child.  A
rhyme task stressed the auditory linguistic aspects of the written
word and the remaining three tasks placed more emphasis on the
meaning of the words.
     1) The rhyme stimuli consisted of 10 each of four types of
word pairs:      a) words which neither rhymed nor had similar
orthography (tree/eats);      b) words which were both phonetically
and orthographically similar (pool/cool);
     c) words which were orthographically similar, but did not
rhyme (bone/gone); and      d) words which were orthographically
dissimilar, but rhymed (by/tie).      2) The word match stimuli
consisted of 20 word pairs, one in upper case the other in lower
case which did or did not represent the same word (TREE/tree,
TREE/eats).3) The word/picture stimuli consisted of 20 word and
picture pairs, in which the word and picture did or did not
represent the same concept.
     4) The synonym/antonym pairs consisted of words which meant
either the same or the opposite.
     Each stimulus was presented on 35 mm slides and projected for
130 ms.  The subjects were tested individually and responded
verbally as to the whether the words rhymed in the rhyme condition
and whether they matched or meant the same in each of the three
other conditions. All words used in the study were determined to
be in the sight vocabulary of all subjects on the basis of prior
testing.
     The number of correct responses for all children on the four
grade levels was  subjected to an analysis of variance for each of
the four tasks. The grouping factors included Grade Level, Reading
Ability, and Eye Movement Direction. The normal readers achieved
virtually perfect performance on all tasks and their results were
not included in the tables. The interaction of eye movement group
and the rhyme task was significant.  The mean number of correct
responses for the interaction are presented in Table 4.1.  

Table 4.1
Mean Number Correct on the Rhyme Task for Disabled Readers with
predominately Right and Left LEM at Four Grade Levels

LEM       Grade          Similar             Dissimilar
                    Rhyme   Non-Rhyme        RhymeNon-Rhyme

Right     2-3       17.80     15.20          14.80     14.00
          4-5       17.80     17.80          16.40     17.89
          6-7       17.80     18.60          18.60     19.30
          8         19.90     19.80          19.10     19.70
Left      2-3       16.10      5.90           7.40     14.40
          4-5       16.10     10.30          10.20     17.30
          6-7       16.80     13.60          12.50     18.50
          8          9.60     12.00          10.40     17.60

    On the basis of the simple effects analysis, those children who
had predominantly leftward eye movements were significantly more
impaired than those who moved predominately to the right. This was
particularly true on those conditions for which the orthography and
phonology of the words were inconsistent (bye/tie or bone/gone).
Those children with predominantly leftward lateral eye movements
are the Phonetic disabled readers who have difficulty with the
auditory linguistic aspects of reading.     The analyses of
variance for the semantic tasks indicated a significant difference
between disability groups.  The results from the three tasks are
presented in Table 4.2.  Table 4.2
Mean Number Correct on the Uppercase/lowercase, Word/picture and
Synonym/antonym tasks for Disabled Readers with Right and Left LEM
at Four Grade Levels

LEM       Grade          Case        Word         Synonym

Right     2-3            15.70        7.90         8.65
          4-5            17.50        7.80         6.55
          6-7            18.80       13.40        13.05
          8              15.90       15.90        15.00
  Left    2-3            19.00       17.50        17.15
          4-5            19.30       19.30        17.45
          6-7            18.10       19.10        18.75
          8              17.40       19.70        17.40

   Again the normal readers performed almost flawlessly and the
disabled readers were inferior at every grade level.  It was the
reading disabled readers with predominantly rightward LEM who were
the significantly more disabled group for these tasks. They were
significantly inferior on the word matching task, the word picture
task and the synonym antonym task.  These children could create the
sound of a word from its orthography, but did not understand the
meaning of that word. This is a replication of a second type of
disabled reader, a Semantic subtype whose deficit involves the
meaning of words rather than their phonology.  Rightward lateral
eye movements are a marker for this subtype.  In the past, this
subtype has often been identified with visual spatial and
perceptual problems.  This may be true but it is incidental to
their reading disability since they had no difficulty in perceiving
the words in the rhyme task.  These results support the existence
of two subtypes of reading disability.  The Phonetic disabled
reader has difficulty converting the written form of a word to its
phonetic counterpart. The Semantic disabled reader can convert a
word to its sound, but not its meaning.
   There were two distinct patterns of errors made by the Phonetic
and Semantic disabled readers, but what is the relationship between
these patterns and reading disability?  The answer to this question
lies in the way we teach reading.  The next chapter is a discussion
of how these two deficits interact with current reading methods and
the effectiveness of a different approach to the reading process.

                           CHAPTER 5
        THE THEORY AND REMEDIATION OF READING DISABILITY

   Current teaching methods almost invariably use an indirect
phonological route to meaning in which the written word is
converted to its phonological counterpart so that meaning derives
from auditory comprehension. In practice, a child comes to school
with auditory comprehension, that is, hearing the word "ball" leads
to the concept of "a round, bouncy thing". In reading, the letters
b-a-l-l must lead to the concept of "a round, bouncy thing". In
virtually every case, the child is taught to see the word, say it,
and understand it from its sound.  This is an effective technique
for two reasons. First, it takes advantage of the existing auditory
comprehension of children; second, it provides the background for
the future decoding of new words.  As effective as this procedure
is for most children, a significant number of individuals are not
able to learn under this protocol and they comprise the majority
of the children we term "reading disabled."
   The Phonetic disabled reader has difficulty with the first step
of this indirect phonological route to reading, converting the
graphemic form of the word into its phonological counterpart.  The
Semantic reading disabled readers have no difficulty with this
first step; they can make the grapheme to phoneme conversion.  For
whatever reason, however, the sound of the word does not lead to
its comprehension.
   The standard methods of teaching reading are well-entrenched and
educators sincerely believe that this indirect phonological route
to meaning is the best.  Therefore, remediation for these "disabled
readers" means an intensification of what was not successful in the
past.  Extensive drilling in phonetic skills has led to an emphasis
on teaching to weakness, rather than strength. The imbalance is
reflected in reading curricula and standardized tests that stress
phonetic decoding at the expense of comprehension.  Phonetic
decoding is a means to the end of comprehension; it has become an
end in itself.
   A new approach, Direct Access, has been developed which achieves
comprehension without the necessity of decoding. The Direct Access
method has one basic principle: the meaning of the printed word
should not be derived from the sound of that word.  Any procedure
that avoids the grapheme to phoneme conversion is consistent with
this approach.  The child is never required to read aloud, but
asked to explain what a passage meant. Trivial deviations in
verbiage, e.g., "jet" for "plane", are de-emphasized. The stress
is on comprehension rather than a slavish word for word decoding.
   One of the simplest procedures used in the method involves
pairing words and pictures until the written word triggers a
concept directly, rather than indirectly through its sound.  The
child can then construct sentences composed of pictures in parallel
with sentences composed of words.  Children automatically fill in
words like "a", "the", "in", etc. when they comprehend the
sentence.  In a very short period, the pictures are no longer
needed and the written word is understood on its own.
   Several techniques are available for more abstract concepts.
One possibility involves a class discussion of, for example, our
legal system.  The teacher can then show the class the word
"justice" and ask the children to draw a picture of justice. It is
not the picture itself that is important, but it serves as a link
between the written word and its conceptualization by the child.
Another possibility is a homework assignment requiring the child
to bring pictures to school that represent specific concepts.
Direct Access places only one constraint on the creativity of
teachers:  Do not teach reading by deriving the meaning of a word
from the way it sounds.  Phonic decoding is a skill that should be
developed, but it should not serve as the usual reading strategy
for these two groups of readers.
   Maxwell and Zenhausern (1983) applied the method to First Grade
children who were "at risk" during the second semester. After 25
half-hour sessions, the children increased their comprehension
scores from the 26th to the 56th percentile on the Metropolitan
Achievement Test and increased their sight vocabulary by over 100
words. A comparable control group showed no gain in comprehension.
Minardi, Zenhausern, and Maxwell (1984) found similar results with
Junior and Senior High School children. Using the same regimen of
25 half-hour sessions, the Junior High School students gained an
average of 7 months and the Senior High School students an average
of 1.4 years.
   The previous research on the Direct Access method of reading has
been limited to a small number of children taught by a single
teacher. The purpose of this study was to apply the method in a
large scale basis, using a broad range of grades and teachers.
A total of 209 children from grades 1 through 10 (with the
exclusion of Grade 9) who were at least one year below grade level
in reading and 240 children who were reading at least on grade
level were the subjects in this study.
   A workshop explaining the theory and practice of the Direct
Access reading method was presented to teachers throughout a 32
school District in suburban North Carolina.  After the workshop was
completed, those teachers who were interested were given further
experience. There were no absolute procedures specified, but the
teachers were shown various possibilities and were told to use any
techniques that did not depend on the indirect phonological route
to meaning. Following these sessions the children in the classes
taught by the teachers were given the Metropolitan Achievement Test
Form L as a pretest measure of their reading ability.  The teachers
then used the Direct Access method exclusively for 10 weeks, after
which time the children were retested on the Metropolitan
Achievement Test Form M.
   The results of the reading disabled children and a control group
are presented in Table 3. The average gain across the whole group
was almost 1 year and several grades showed gains of over 2 years.
Individual gains of 4 or more years were not uncommon.  Given that
these results were obtained during only a 10-week period, the
Direct Access approach is clearly an effective strategy to use with
Phonetic and Semantic reading disabled children. In addition to
these objective gains, the teachers reported an extremely positive
reaction on the part of the students and have commented on the
effects of the method on both spelling and writing composition.
   During the past year (1988-89) Greensboro and High Point, North
Carolina used the Direct Access approach.  The average gain on the
State mandated California Achievement Test was over 20 percentile
points for those children.  As a result, High Point has mandated
the Direct Access approach as the treatment of choice for children
who are "at risk" for reading.  The approach has been used in
Currituck, North Carolina since September, 1989 and at Public
School 102 in New York City since January, 1990.  There are plans
for incorporating Direct Access into a psychiatric hospital for
children, a Parochial school in New York City, and a school system
in East Greenwich, Rhode Island by February, 1990.

Table 1
Total Gains in Percentile and Grade Equivalent Scores for Direct
Access and Controls

              Pre            Post           Gain
              Per  Grade     Per  Grade     Per   Grade

Grade 1
DA (38)        7   1.09      32   1.55      25    0.46
Control (27)  46   1.79      56   2.13      10    0.34
Grade 2
DA (21)       17   1.76      32   2.15      15    0.39
Control (36)  54   2.89      58   3.19      40    0.3

Grade 3
DA (28)       16   2.33      31   2.99      15    0.66
Control (28)  56   4.49      61   4.94      5     0.45

Grade 4
DA (52)       15   2.59      31   3.28      16    0.69
Control (53)  60   5.82      61   5.97      1     0.15
Grade 5
DA (20)       21   3.63      38   5.01      17    1.38
Control (38)  56   6.53      60   7.09      4     0.56

Grade 6
DA (13)        3   2.36      15   3.68      12    1.32
Control (17)  71   9.58      74    9.9      3      0.32
Grade 7
DA (21)        8   3.39      26   5.45      18    2.068
Control (18)  35   6.57      36   6.64      1     0.07
Grade 8
DA (9)         5   3.38      21   5.61      16    2.23
Control (10)  34   6.94      35   7.36      1     0.42
Grade 10
DA (7)        17   5.58      26   6.65      9     1.07
Control (13)  15   5.25      18    5.6      3     0.35

Total
Exper.(209)   12   2.27      29   3.22      17    0.95
Control (240) 52   5.35      56   5.71      4     0.36

    This chapter has outlined some of the successes that have been
attributed to the Direct Access approach.  The next Chapter is a
discussion of some of the methods that are consistent with Direct
Access.

                           CHAPTER 6
              SUMMARY, CONCLUSIONS, RECOMMENDATIONS
Summary
    Current teaching methods almost invariably use an indirect
phonological route to meaning in which the written word is
converted to its phonological counterpart so that meaning derives
from auditory comprehension.  A child comes to school knowing that
the sound "ball" means the concept "a round, bouncy thing".  In
reading, the letters b-a-l-l must lead to the concept of "a round,
bouncy thing".  In virtually every case, the child is taught to see
the word, say it, and understand its meaning from its sound.  This
is an effective technique for two reasons.  First, it takes
advantage of the existing auditory comprehension of children;
second, it provides the background for the future decoding of new
words.  As effective as this procedure is for most children, a
significant number of individuals are not able to learn under this
protocol and they comprise the majority of the children we term
"reading disabled."
    Kaliski, Zenhausern, and Andrews have shown that there are two
groups of children who have unique deficits that interact with
these standard strategies used for teaching reading.  It is this
interaction that directly leads to reading disability.  All the
children in grades 1 to 8 who were reading at least one year below
grade level were screened for inclusion in the study.  The majority
of the reading disabled group (85 per cent) fall into the category
of children who have to struggle to pronounce every word and thus
lose all continuity in reading.  They were termed Phonetic disabled
readers.  The smaller group of reading disabled children can "read"
aloud fluently, but do not comprehend what was "read".  These
children were called Semantic disabled readers.  The final sample
consisted of 80 children, 40 Phonetic and 40 Semantic disabled
readers, spread evenly across the 8 grades.  The authors showed
that the Phonetic children could not determine whether two words
(which were known to be in their sight vocabulary) did or did not
rhyme.  The Semantic group had no difficulty with a rhyme task, but
made considerably more errors than the normal readers and Phonetic
disabled readers in determining whether a word and a picture
represented the same concept. These two deficits can be directly
related to the indirect phonological approaches to the teaching of
reading. The Phonetic disabled reader can not convert the word to
its sound and thus can not take the first step required by these
reading methods. The Semantic disabled reader can perceive the
words and translate them to their sound but has difficulty in
comprehending the meaning of the written word from this sound. This
disabled reader can take the first step and convert the written
word to its phonological counterpart, but the sound does not lead
to meaning.  The results of this study can be seen in Figures 1 and
2.

    The standard methods of teaching reading are well-entrenched
and educators sincerely believe that this indirect phonological
route to meaning is the best. Therefore, remediation for these
"disabled readers" means an intensification of what was not
successful in the past.  Extensive drilling in phonetic skills has
led to an emphasis on teaching to weakness, rather than strength.
The imbalance is reflected in reading curricula and standardized
tests that stress phonetic decoding at the expense of
comprehension.  Phonetic decoding is a means to the end of
comprehension; it has become an end in itself.     An alternative
approach to reading which does not depend on an indirect
phonological approach to comprehension, called Direct Access, has
one basic principle: the meaning of the printed word should not be
derived from the sound of that word.  Any procedure that avoids the
grapheme to phoneme conversion is consistent with this approach.
The child is never required to read aloud, but is asked to explain
what a passage meant.  Trivial deviations in verbiage, e.g., "jet"
for "plane", are de-emphasized. The stress is on comprehension
rather than a slavish word for word decoding.  Specific Direct
Access techniques will be discussed later in this chapter.
    The first study involving Direct Access was by Maxwell and
Zenhausern (1982) who applied the approach to First Grade children
"at risk" in reading by the second half of the year. After 25 half-
hour sessions, the children increased their scores from the 26th
to the 56th percentile on the Metropolitan Achievement Test and
increased their sight vocabulary by over 100 words.  A comparable
control group showed no gain. Minardi, Zenhausern, and Maxwell
(1983) found similar results with Junior and Senior High School
children.  Using the same regimen of 25 half-hour sessions, the
Junior High School students gained an average of 7 months and the
Senior High School students an average of 1.4 years on the Reading
Comprehension scale of the Metropolitan Achievement Test.
    During the Spring of 1988, over 200 reading disabled children
in grades 1 through 10 from 8 schools within the Guilford County
School System in Greensboro NC used the Direct Access approach.
The children were tested on the Metropolitan Achievement Test
before and after 10 weeks of using the approach. The average gain
was .95 years and every grade from Grade 6 onward gained at least
1 year, with the 7th and 8th grades showing gains of over 2 years.
In the Fall of 1988, High Point NC used the approach with 73
reading disabled children.  After 7 weeks, there was an average
gain on the Woodcock Johnson of 15 months.  The Kindergarten group
showed a 12 month gain; the primary, a 7 month gain, and the middle
school a 21 month gain.  Both Greensboro and High Point, North
Carolina used Direct Access for the past year.  On their State
mandated California Achievement Test, those children on Direct
Access instruction showed an average gain of 17 percentile points
above last year's scores.

                SELECTED DIRECT ACCESS TECHNIQUES
    The results of the demonstration project and the use of Direct
Access in the past year in North Carolina clearly show that reading
disabled children can benefit from the Direct Access method of
teaching reading.  To be able to read means that one can get
meaning from the printed word.  The indirect phonological route
attempts to accomplish this by having the reader convert the
written word to its phonological counterpart and from this sound
derive meaning.  Converting the word to its sound is a means to the
end of comprehension, not the comprehension itself.  Direct Access
attempts to derive the meaning of the printed word not via its
sound, but directly.  The stress is on comprehension, not decoding.
    One of the first and most basic Direct Access techniques
consists of pairing an index card which contains a word and one
that contains a picture so that the child can consistently make the
pairing.  At that point the child can read the word, that is, the
child can comprehend the printed word.  Note that this is true
whether or not the child can say the word correctly or not.  The
pictures can be provided by the teacher, cut from magazines for
homework by the child, or even drawn by the child.  The question
of abstractions and hard to picture words at first seems
insurmountable, but it is surprising how easily a child will
develop and remember appropriate pictures.  In connection with this
aspect, games can be developed to strengthen the connection between
the words and the pictures.  Variations of Concentration and Old
Maid have been used successfully.
    This pairing, however, is only the beginning of the Direct
Access approach.  The typical reaction at this point is, "This is
nothing new." or "We tried that 20 years ago and it did not work."
The next step is the most critical.  The words and pictures must
be combined into sentences.  A word sentence can be covered by the
appropriate picture and vice versa.  The child should not be asked
to read the sentence aloud, word for word.  Rather, have the child
summarize the sentence, point to a picture from a series that
corresponds to it, or even draw a picture of the sentence.  The
stress should always be on whether the child has understood the
basic meaning of the sentence rather than a word for word rendition
of it.
    There are two important side benefits of this approach.  One
is an increase in spelling skills.  The second advantage is the
ease with which children can do creative writing using the cards.
It is a simple way to separate penmanship from writing.  The child
could be asked to write the funniest (most exciting, etc.) sentence
they can from their words.  The step from sentences to paragraphs
is minimal.
    There are two basic approaches to class recitation within a
Direct Access framework.  The phonetic disabled reader would be
asked to summarize a passage for the class and the teacher and
classmates could discuss the errors of omission and commission.
It also opens the door for class discussion on any relevant issues.
The semantic disabled reader would read aloud, but be required to
do so with expression to assure that the meaning and not only the
words were being read.  Of course, any child could be given the
opportunity to use either approach.
    Flash cards are a standard part of the classroom and can be
used within a Direct Access framework.  Let the children have their
pictures in front of them when the words are flashed.  They will
serve as a cue and minimize the chance of failure.  As the children
progress, they can turn the pictures face down on the desk and only
turn them over as needed.  This will strengthen skills and continue
to minimize the chance of failure.  This technique could easily be
converted into a game where more points accrue if a card is not
turned over, but the child will always get some points.
    What happens when children come across a word they have never
seen before?  This is the usual response of people who first
encounter Direct Access.  There are several approaches to this.
First and foremost, the child should be encouraged to determine the
meaning of the word from the context of the whole passage.
    Second, the teacher can tell the child the word and immediately
have the child cut out or draw an appropriate picture for that
word.
    Third, the child can be encouraged to look it up in the
dictionary just like anyone else who comes across a word with which
they are unfamiliar.  The child may not be able to pronounce the
word, but its meaning will be known.
    Fourth, phonetic decoding should be an essential part of any
reading program.  It is an important skill and should not be
neglected.  On the other hand, it should not be the main approach
to deriving meaning from the printed word for some children.
There is a temporary remediation procedure to use with Semantic
disabled readers.  Have the child read aloud into a tape recorder.
Then the child can play back the tape while reading from the text
material.  Although this is an awkward procedure it will allow the
child to get meaning from the printed word.  Direct Access has a
technique for the teaching of spelling and number facts.  It has
been shown that some children not only do not learn by verbally
repeating the word and letters (e.g. "cat, C-A-T, cat", "6 times
3 is 18") but this procedure can actually interfere with learning.
As an alternative have the child look at the word and practice
forming an image of the letters without saying anything (This is
essential!!).  When it comes time to spell the word, have the child
bring back the image of the letters and copy them.
    The Direct Access approach does not depend on a rigid structure
that the teacher must follow slavishly, but is a general principle
that can lead to unique and creative techniques.  Furthermore, the
method is not limited to the disabled population, but may be an
effective strategy for all readers since it has some similarities
to "speed reading" techniques.

                   SUMMARY AND RECOMMENDATIONS
Summary
    Reading Disability is as much a physical disability as
blindness, deafness and paralysis but a person with such a
disability has not received the help offered to those suffering
from the latter disorders.  The reading disabled child is
considered responsible for the disability.  The purpose of this
paper is to point out that these children can learn to read if only
we are willing to change the methods with which we teach reading.

    The standard approaches to reading demand that the child
convert the written word to its sound and, from that sound, derive
the meaning.  It was shown that 85% of the children we call reading
disabled have difficulty making that first step and the remaining
15% can convert the word to its sound, but this still does not give
them meaning.  The Direct Access approach to reading can help both
types of children because meaning is not derived by converting the
printed word to its sound.  Rather, the sound of the word is
derived from its meaning.  Several specific techniques using this
approach have been discussed earlier in this Paper.
    Our brain is capable of many fascinating and wondrous things.
Our conscious awareness of our surroundings is somehow derived from
light of various wavelengths falling on our retina and causing
neurons to fire and not fire.  It is this pattern of neuronal
activity that gives us conscious experience.  Even more amazing is
the ability to create literary, musical, and visual works of art.
It is the brain that is responsible for all of this.  The brain
also has a rather obscure function.  It can take an arbitrary
series of symbols (printed words) and convert them into an equally
arbitrary set of sounds (spoken words).  This function pales
alongside literary and artistic masterpieces.  Why have we made it
the basis of our educational system?
Recommendations
    There are two major administrative recommendations that flow
from this paper.  The first concerns the establishment of a centre
for learning disability to be associated with the Centre for Social
Development and Humanitarian Affairs.  The second concerns the
development of a pilot project to investigate the effectiveness of
the Direct Access approach to reading.
1)  A center for the dissemination of information and training in
learning disabilities should be established which would be called
the Learning Enhancement Centre of the Disabled Persons Unit.
    The purpose of the Learning Enhancement Centre would be to
research and disseminate information on the theory and remediation
of educational disabilities and to provide training in the
remediation of these disabilities.  The scope of this training
would include all educational approaches that stress the individual
styles of learning with a particular emphasis on the Direct Access
approach in reading.  There would be two main educational foci:
    1) ongoing workshops open to teachers from all member
countries; and      2) visiting teams which would provide on-site
training for those teachers who cannot travel to the Centre.  In
addition, new teaching techniques would constantly be developed
and evaluated in real classroom situations.  These teaching
techniques would take advantage of the latest technology, but the
effective use of more basic strategies would also be investigated.
The Centre would publish a newsletter to promulgate its activities
and share the latest innovations in teaching techniques.
2)  A large scale pilot study should be initiated by the Learning
Enhancement Centre to evaluate the effectiveness of the Direct
Access approach across a wide variety of cultures.     The Learning
Enhancement Centre would provide a series of workshops to train
teachers in the theory and practice of Direct Access.  These
teachers would consist of individuals from various countries who
would then develop Direct Access projects in their country.
Consultants from the Learning Enhancement Centre would visit the
project sites to provide ongoing feedback to the teachers.  These
same teachers can provide on site training for countries who are
unable to send teachers to the Centre.     In addition to these
administrative recommendations, there are several educational
recommendations that are aimed at eliminating all forms of learning
disability.  The aim of the Learning Enhancement Centre is to
implement these recommendations. 3) Individual preferences in
learning strategies should be taken into consideration in selecting
teaching strategies.
    Both lateral eye movements and Hemispheric Preference Test data
should be collected on all children.  Strategies of teaching that
are compatible with the learning strategies associated with these
Hemispheric Related Strategies should be incorporated into the
classroom.  In addition, other measures of individual differences
in learning styles should be incorporated into the framework of the
Centre.
 4) A testing program aimed at identifying individual differences
in learning styles should be developed at the Centre and
disseminated among the various member nations.     Children can be
tested for Phonetic and Semantic reading disability by means of a
test derived from the results presented in Chapter 4.  The Phonetic
Semantic Reading Scale (PSRS) requires a child to match written and
pictorial material on the basis of their sound or on the basis of
their meaning.  The point would be to identify individuals who do
well on one portion of the test and poorly on the other to make a
differential diagnosis between the Phonetic and Semantic disabled.

5) The techniques described in the Selected Direct Access Technique
section above should be applied to these children.
    These would include, but not be limited to:
a) Alternative forms of class recitation
b) De-emphasis of phonics
c) Use of word picture vocabulary cards
d) Emphasis on comprehension rather than decoding
6) The criteria for success should reflect the capabilities of the
child in conjunction with the demands of the culture rather than
artificial restrictions.
    These would include, but not be limited to:
a) Speed should be de-emphasized
b) Tests should be given on an "open book" basis.
c) Calculators should be allowed on mathematics tests.
    Note that these changes actually reflect the way people operate
in the real world.  No successful business places unrealistic time
limits on workers or denies them use of tools and references.
7)  An essential aspect of the Centre will be to develop new and
creative techniques aimed at the elimination of all forms of
learning disabilities.
    While the emphasis at present is on developmental disabilities,
it is expected that this will expand to cover acquired
disabilities, especially those related to head injuries.  The same
principles of educational remediation will be applied to cognitive
remediation.     The major recommendation of this paper is that
learning disability should be recognized as a true disability and
treated in the same way as the more physical disabilities such as
deafness, blindness and paralysis.  The learning disabled child
should not be considered at fault for the disorder, but should be
recognized as a person in need of special help.  It is our
responsibility to supply that special help.
    The emphasis must be on individualizing instruction rather than
finding the "one true method".  The good from all approaches must
be used with those who find it good and avoided for those who find
it not good.  Only by tailoring our teaching to the unique style
of each student do we maximize their strengths rather than trying
to strengthen their minima.

                         BIBLIOGRAPHY

Alberts, F. L., & McCallum, R. S. (1982).  The relationship among
three measures of     cognitive style. Clinical Neuropsychology,4,
70-71.

Bakker, D. (1982) Cognitive deficits and cerebral asymmetry.
Journal of Research and     Development in Education, 150, 49-54.

Beaumont, J., Young, A., & McManus (1984) Hemisphericity: A
critical review.  Cognitive     Neuropsychology, 1, 191-212.

Boder, E. (1973) Developmental dyslexia: A diagnostic approach
based on three atypical     reading-spelling patterns.
Developmental Medicine and Child Neurology, 15, 663-    687.

Bradshaw, J. & Nettleton, N. (1981)  The nature of hemispheric
specialization in man.      Behavior and Brain Sciences, 4, 51-97

Breitling, D., & Bonnet, K. (1985). Lateralization of GSR,  lateral
eye movements and a     visual half-fields recognition task.
International Journal of Clinical Neuropsychology,     7, 140-143

Bruce, P. R., Herman, J. F., & Stern, J. (1982). Lateral eye
movements and the recall of     spatial information in a familiar,
large-scale environment.  Neuropsychologica, 20,     505-508.

Coleman, S. & Zenhausern, R. (1979) Processing speed, laterality
patterns, and memory     encoding as a function of hemispheric
dominance.  Bulletin of the Psychonomic     Society, 14, 357-360.

Day, M. E. (1967) An eye-movement indicator of individual
differences in the psychological     organization of attentional
process and anxiety.  Journal of  Psychology, 66, 51-62.

Denckla, M.B. (1979) Childhood learning disabilities. In. K.M.
Heilman     and E.M. Valenstein (Eds.), Clinical Neuropsychology,
New York:  Oxford University     Press.

Dunn, R., Price, G., Bacilious, Z., & Zenhausern, R. (1983)
Learning Style -- a predictor     of school achievement. Momentum,
13, 47-48.

Dunn, R., Zenhausern, R., Cavanaugh, D., & Eberle, B. (1982)
Hemispheric preference the     newest elements of learning style.
Journal of the National Association of Biology     Teachers, 44,
291-294.

Dunn, R, White, R. & Zenhausern, R. (1984) Do educators create some
discipline     problems? Illinois School Research and Development
Journal, 34, 56-67.

Ehrlichman, H., & Barrett, J.  (1984) Right
hemisphere specialization for mental imagery:     A review of the
evidence.  Brain and Cognition, 2, 55-76.

Ehrlichman, H., & Weinberger, A.  (1978) Lateral eye movements and
hemispheric     asymmetry: A critical review. Psychological
Bulletin, 86, 1080-1101.

Falcone, D. J., & Loder, K. (1984). A
modified lateral eye  movement measure, the right     hemisphere,
and creativity.  Perceptual and Motor Skills, 58, 823-830.

Fisk, J. & Rourke, B. (1979) Identification of subtypes of learning
disabled children at three age levels: A neuropsychological,
multivariate approach. Journal of Clinical Neuropsychology, 1,
289-310.

Furst, C.  EEG asymmetry and visuospatial performance.  Nature,
260, 254-255.   Galin,D., & Ornstein, R.  (1972) Lateral
specialization of cognitive mode: An EEG study.
Psychophysiology, 9, 412-418.

Galin, D., & Ornstein, R.  (1975) Hemispheric specialization and
the duality of     consciousness.  Laterality and brain function.
Springfield, IL: C.C.Thomas.

Golden, M., & Zenhausern, R.  (1983)
Grapheme to phoneme conversion: The basis of     reading
disability? International Journal of Neuroscience, 20, 229-240.

Gur, R.E. (1978) Left hemisphere dysfunction and left hemisphere
overactivation in     schizophrenia. Journal of Abnormal
Psychology, 87, 226-238.

Gur, R. E., & Gur, R. C. (1975).  Defense mechanisms,
psychosomatic symptomatology,     and conjugate lateral eye
movements.  Journal of Consulting and Clinical Psychology,
43, 416-420.

Gur, R.E., Gur, R.C., & Harris (1975) Cerebral activation, as
measured by subjects' lateral eye movements is influenced by
experimenter location. Neuropsychologia, 13, 35-44.

Gur, R.C., Packer, I, Hungerbuhler, J., Reivich, M., Obrist, W., & Amarner,
W.(1980)     Differences in the ion of grey and white matter in the
human cerebral cortex.      Science, 207, 1226-128.

Huang, M. S., & Byrne, B. (1978).  Cognitive style and lateral eye
movements.  British     Journal of Psychology, 69, 85-90.

Hugdahl, K., & Carlgren, H. E. (1981).  Hemispheric asymmetry as
indexed by differences     in direction of initial conjugate
lateral eye movements (CLEMS) in response to     verbal, spatial,
and emotional tasks.  Journal of Mind and Behavior 2, 259-270.

Jamieson, J. L., & Sellick, T. B. (1985) Effects of subject-to-
experimenter distance and     instructions on lateral eye movement.
Perceptual and Motor Skills, 60, 155-159.

Kaliski, M., Zenhausern, R., Andrews, R. (1989) The direct
access method of teaching reading and the diagnosis and
remediation of reading disability.  International Journal
of Neuroscience, 44, 103-109.

Kinsbourne, M. (1972) Eye and head turning indicate cerebral
lateralization.  Science, 176,     539-541.

Kinsbourne, M., & Warrington, E. (1963) Developmental factors in
reading and writing     backwardness.  British Journal of
Psychology, 54, 145-156.

Krikorian, R., & Rafales, L. (1983). Emotional stimulation,
defensive orientation, and     hemispheric activation.  Brain and
Cognition, 1, 371-380.

Leboeuf, A., McKay, P., & Clarke, K. (1983). Lateral eye movements
and dream recall in     males: a reappraisal. Imagination,
Cognition, and Personality, 3, 61-68.

Lenhart, R. E. (1985) The effects of distance between interactants
and subject anxiety on conjugate lateral eye movements.
Brain and Cognition,  4(3), 328-337.

Levy, J. (1974) Psychobiological implications of bilateral
asymmetry. In S.  Dimond & J.      Beaumont (Eds.) Hemispheric
function and the human brain.  New York: Wiley

Markman, S. & Zenhausern, R. (1988) The interaction of hemispheric related
strategies and     individual differences in learning.
International Journal of Neuroscience, 43, 165-170.

Mattis, S., French, J., & Rapin, I. (1975) Dyslexia in children and young
adults: three     independent neuropsychological syndromes.
Developmental Medicine and Child     Neurology, 17, 150-163

Maxwell, M. & Zenhausern, R. (1983) Teaching reading to disabled
readers by eliminating     the necessity for grapheme to phoneme
conversion.  Paper presented at the Eastern     Psychological
Association, Philadelphia.

Minardi, A., Zenhausern, R., & Maxwell, M. (1984) The remediation
of reading disability:     a new approach. Paper presented at the
International Neuropsychology Convention,     Houston.

Oexle, J. & Zenhausern, R. (1981) Differential hemispheric
activation in good and poor     readers. International Journal of
Neuroscience, 15, 31-36.

Ogorman, J. & Siddle, D. (1981).  The effects of question type  and
experimenter position     on bilateral differences in electrodermal
activity and conjugate lateral eye movements.     Acta
Psychologica, 49, 43-51.

Owens, W., & Limber, J. (1983). Lateral eye movement as a measure
of cognitive ability     and style.  Perceptual and Motor Skills,
56, 711-719.

Parrott, C. A. (1983). Personality characteristics associated  with
lateral eye movement     patterns.  Perceptual and Motor Skills,
58, 867-874.

Paivio, A., Yuille, J., & Madigan, S. (1968) Concreteness, imagery
and meaningfulness     values for 925 nouns.  Journal of
Experimental Psychology Monographs, 76, (1 pt. 2).

Petroskas, R.  & Rourke, B. (1979) Identification of subtypes
of retarded readers: A neuropsychological, multivariate approach.
Journal of Clinical Neuropsychology, 1,     17-37.

Pirozzolo, F. (1979) The neuropsychology of developmental reading
disorders. New York:     Praeger.

Schwartz, G., Davidson, R., & Maer, F. (1977). Right Hemisphere
Lateralization for     Emotion in the Human Brain:  Interactions
with cognition. Science, 190, 286-288.

Schweitzer, L. (1979). Differences of cerebral lateralization
among schizophrenic and depressed patients.  Biological
Psychiatry, 14, 721-733.

Smokler, I. A., & Shevrin, H. (1979).  Cerebral lateralization  and
personality style.      Archives of General Psychiatry, 36,
949-954.

Swinnen, S. (1984). Some evidence for the hemispheric asymmetry
model of lateral eye     movements.  Perceptual and Motor Skills,
58, 79-88.

Thompson, M., Greenberg, R. P., & Fisher, S. (1982). Defense
mechanisms, somatic     symptoms, and lateral eye movements in
females.  Perceptual and Motor Skills, 55,     939-942.

Tucker, D. M., Antes, J. R., Stenslie, C. E., & Barnhardt, T.  M.
(1978).  Anxiety and     lateral cerebral function.  Journal of
Abnormal Psychology, 87, 380-383.

Tucker, G. H., & Suib, M. R.  (1978).  Conjugate lateral
eye  movement (CLEM) direction and its relationship to
performance on verbal and visuospatial tasks.
Neuropsychologica, 16, 251-254

Tucker, D. (1981) Lateral brain function, emotion, and
conceptualization.  Psychological     Bulletin, 89, 19-46.

Van Nuys, D. (1985) Lateral eye movement and dream recall: II sex
differences and     handedness.  International Journal of
Psychosomatics, 31, 3-7.

Weiten, W., & Etaugh, C. F. (1974) Lateral eye movement as related
to verbal and     perceptual-motor skills and values.  Perceptual
and Motor Skills, 36, 423-428.

Zenhausern, R. (1978) Imagery, cerebral dominance, and
style of thinking: A unified field model.  Bulletin of
the Psychonomic Society, 12, 381-384.

Zenhausern, R. (1982) Rights and lefts and how they learn. Early
Years, 12, 51-67.

Zenhausern, R. (1983) Lateralized presentation
and hemispheric integration.  American     Psychologist, 38.

Zenhausern, R. (1987) The relationship of reading disability and
the techniques of teaching     reading. International Journal of
Neuroscience, 34, 55-62.

Zenhausern, R. (1988) Eyes Right. Teaching K through 8, 23, 76-78.

Zenhausern, R. & Dunivin, D. (1981) Differential hemispheric
activation and handedness and hysterical and obsessive
personality styles.  Bulletin of the Psychonomic Society, 17,
23-25.

Zenhausern, R., & Dunn, R. (1984) How brainy are you about the
brain?  Early Years, 15, 46-49.

Zenhausern, R., Dunn, R., Cavanaugh, D. & Eberle, B. (1981) Do
right and left brained students learn differently. Roeper
Review, 4, 35-39.

Zenhausern, R. & Nickel, M. (1978) Hemispheric dominance in recall
and recognition. Bulletin of the Psychonomic Society, 13, 50-54.

Zenhausern, R. & Gebhard, M. (1979) Hemispheric dominance in recall
and recognition. Bulletin of the Psychonomic Society, 14, 71-73.

Zenhausern, R., Notaro, J. Grosso, J. & Schiano, P. (1980) The
interaction of hemispheric preference, laterality, and sex in
the perception of emotional tone and verbal content.
International Journal of Neuroscience, 13, 121-126.

Zenhausern, R. & Parisi, I. (1981) Brain dis-integration in
psychosis. Paper presented at International Neuropsychology
Society, Atlanta.

Zenhausern, R. & Sinatra, R.(1983) The rapid identification of poor
readers with a grapheme to phoneme deficit. Eastern
Psychological Association, Philadelphia.

----
For more information contact:
Robert Zenhausern, Ph.D.        Internet: drz@sjuvm.stjohns.edu
St. John's University           Bitnet: drz@sjuvm.bitnet
SB 15 Marillac                  Phone:  718-990-6447
Jamaica, NY 11439               Fax:    718-990-6705
