Date: 29 Oct 89 20:27:52 GMT
Subject: Secure Distributed Databases for Epidemiological Control

English update of: 
Stodolsky, D. S. (1989, August). 
Brugerforvaltet datakommunikationssystem til bekaempelse af seksuelt 
overfoerbare infektionssygdomme 
[Secure Distributed Databases for Epidemiological Control]. 
Research proposal submitted to the AIDS-Fund Secretariat, Danish Health 
Department. 
(Available from the author at the Psychology Department, University of 
Copenhagen )

==============================================================

Secure Distributed Databases for Epidemiological Control

Abstract

The project's objective is to develop a personal computer-based 
system for control of infectious agents. The overall goal is a 
better understanding of affects of enhanced social facilitation 
and health education on disease transmission. A theory of real-
time epidemiological control, based on contact tracing, specifies 
a cryptographicly-secure distributed-database system 
providing situationally specific risk assessments that are based 
upon personal histories.

Personal computer systems negotiate exchanges of information that 
permit preselection of conversation partners. The techniques used 
yield unprecedented protection for user's identities and data. 
Users communicate under the protection of pseudonyms. Data is 
kept private, but is releasable through exchange negotiations. 
The systems permit self-administration of questionnaires and 
distribution of health information, as well as 
communication with selected conversation partners. 

Information on changing health status and risk related 
behaviors are routinely gathered during system operation. In 
addition to giving users situationally specific risk assessments, 
these data permit new types of epidemiological analysis.

A pilot project devoted to design and development of a 
prototype system is specified in detail. The plan includes 
discussions with potential organizational participants in the 
proposed experiment and other interested parties.

=====================================================

30 August, 1989

"I don't want to know your name, 
I want your history."
(Painters and Dockers, 1988). 

Secure Distributed Databases for Epidemiological Control

(Controlling Sexually Transmitted Diseases with Informational Barriers)

1..Objectives

Information technology offers new techniques for the control of 
infectious agents that can complement medical and public health 
measures. The techniques described here are most useful when medical 
measures are of limited value and where privacy concerns 
predominate. The discussion is focused on control of the Human 
Immunodeficiency Virus (HIV), even though the approach is of general 
applicability. For instance, HIV seropositive persons benefit even more 
from this approach than others, since it helps protect them from 
exposure to infectious agents that can activate the virus and cause 
other infections. The specific project objective is the development of 
information technology techniques for control of sexually transmitted 
diseases. The overall project objective is to investigate the impact of 
social facilitation and health education on disease transmission, that is 
achieved by using such techniques. 

Social facilitation has two roles. First, to enhance risk free contacts 
through preemptive detection of risky transactions. Second, to reduce 
the total number of transactions, and thereby risk, by stabilizing 
relationships through increasing the probability that continuing 
interactions results from mediated contacts. Both of these objectives 
require negotiations using significant amounts of sensitive information 
prior to actual contact. In the first case this information is of a medical 
nature, in the second it is of an ideological or social nature. The 
negotiation procedure can be highly restrictive, resulting in rejection of 
most potential contacts. Thus, if social support is to be maintained, the 
scope of potential contacts must be increased. This requirement is 
satisfied by using telematic systems and computer support in the 
negotiation process. Such automatic mediation also permits effective 
protection of sensitive personal information, thereby enhancing the 
likelihood that the data is complete and reliable.

1.1..Detection of risk

Preemptive risk detection is facilitated by individualized real-time 
epidemiological modeling. Both the medical and behavioral history of 
each person is available during the negotiation process. Certain risky 
contacts are blocked by the mediating system. For instance, a 
HIV seropositive person would never be matched with a HIV 
seronegative person. In most cases, however, medical test results will 
not be available, thus behavioral information provide estimates of risk. 
Adequate data is maintained to permit contact tracing in real-time 
when a positive test result occurs. Thus, a single positive test result 
could propagate through a  chain of contacts, changing the risk status of 
a large number of persons rapidly. Persons at high risk would be 
rejected as social contacts, in most cases, until a negative test result was 
obtained. This would lead to voluntary compliance with a program of 
selective testing for persons at greatest risk. Thus, preemptive risk 
detection operates in two ways. First, risky contacts are rejected by 
presumably uninfected persons, thereby blocking transmission of 
infectious agents. Second, at-risk persons are motivating to seek 
medical assistance for a change of risk status.

1.2..Stabilizing relationships

As long as infectious agents are prevalent, risk of infection is 
proportional to the number of (risky) contacts. In the case that persons 
are seeking a stable relationship, a prior knowledge of objective factors 
including behaviors, and subjective factors such as interests, desires, 
attitudes, and beliefs can play a role in predicting outcome of a contact 
and thereby minimizing the number of contacts needed to find a stable 
relationship. While guarantees of privacy can improve the reliability of 
data contributed by persons, it is likely that feedback from prior 
contacts can be used to improve data accuracy. It certainly can play a 
role in confirming that self reports are complete and honest.

1.3..Security system development

The success of the strategy proposed requires the ability to use data 
without disclosing it except when absolutely required. The highly 
sensitive nature of the data needed for this study presumes 
development of improved security models. Security that is dependent 
on trusted third parties may be adequate for the initial phase of this 
study, but elimination of such intermediaries is an objective. Thus, in 
the limit, each person would exercise control over their sensitive data 
directly. This would, of course, require a personal computer or "smart 
card" for each user. Such systems have been proposed and will become 
economically feasible in the near future. Specification and feasibility 
analysis of various security enhancements will be examined as part of 
the project.

A first security enhancement step would be to provide the user with a 
card that in connection with a password or personal identification 
number (PIN)  could be used to activate remotely held sensitive data. 
This level of security is currently available with electronic funds 
transfer (EFT) terminals (automated teller machines). A next level of 
security is to provide each user with a "key loader" that provides a 
sequence of binary digits that is used to decode remotely held data files 
that normally remain enciphered. 

Optimal security is available when data is under the direct physical 
control of the user as well as being secured by password and 
cryptographic security mechanisms. Currently available personal 
computers have adequate capacity to perform these functions. Central 
data would list pseudonyms (public-keys) of persons using compatible 
systems and provide mail boxes for messages. All exchanges of 
information would be encrypted. 

2..Significance

The AIDS epidemic has created a medical emergency of major 
proportions.  It also threatens to create a crisis of social control 
unprecedented in modern times.  The major reason for this is the lack 
of medical countermeasures against the virus.  A second reason is the 
effect of the HIV on the brain, AIDS dementia complex (ADC), that can 
result in irresponsible behavior (AIDS not, 1987; Smith, 1989).  A third 
reason is that some common institutions for social coordination may 
actually accelerate the spread of the disease.  This deficiency can be 
overcome by a strategy that simultaneously enhances personal 
integrity and social control.

Factors including changing population density, behavioral patterns, and 
infection pathways alter niches for pathogenic organisms which evolve 
under new conditions. AIDS is an example of a disease which has 
dramatized the availability of a new niche. Seale and Medvedev (1987) 
argue that the AIDS epidemic could not have started without the 
availability of multi-use hypodermics.  An important characteristic of 
this disease is inapparent infection that inhibits its control.  Effective 
control presumes the ability to visualize the infectious agent and take 
appropriate action to avoid further transmission. Cost effective medical 
testing alone cannot reliable visualize HIV, due to delayed 
seroconversion resulting from the virus remaining hidden inside cells, 
failures in seroconversion, and even loss of antibody response. 
Transmission can apparently not be reliably blocked by physical 
barriers. Related organisms pose an even greater threat prior to 
identification (Cancer virus, 1987). These limitations demand a new 
control strategy suitable to new conditions of disease transmission.

The control strategy suggested here permits an approach to disease 
management independent of medical capabilities. It has the potential of 
being both effective and economical. Infection risk is visualized entirely 
through information handling. Thus, the technique can be applied 
without detailed knowledge of the infectious agent. Avoidance of 
infection is an integrated function of the information handling strategy, 
as is the motivational structure needed to promote cooperation. A most 
important aspect of the strategy is that it is a preventative approach. 
Brecher (1975) concluded that the three major strategies for control of 
sexually transmitted diseases, treatment of symptomatic cases, contact 
tracing, and routine screening are ineffective compared to simple 
preventative measures. He argues for health education and effective 
prophylaxis as likely to lead to reduced incidence. In the case of HIV, 
prophylaxis is the only strategy currently available, and thus it is 
crucial that informational as well as physical barriers be used to inhibit 
the spread of the virus.

This is perhaps even more important when we consider the long term 
dynamics of disease. Often diseases evolve in the direction of reduced 
virulence, making them less apparent and often more prevalent (Seale 
& Medvedev, 1987). In the case of HIV, it is likely that the first 
successful medical countermeasures will consist of methods to extend 
the latent period of the disease. Thus, while currently, a person can 
remain symptom free for 5 to 7 years, a person receiving this first type 
of treatment for HIV may remain symptom free for 20 years or more. 
The key premise of this strategy asserts that HIV infection and AIDS 
are chronic, manageable conditions (Smith, 1989). During this time 
persons may pose a continuing infection risk. If these persons are to 
remain contributing members of society the informational barriers 
suggested here may be crucial.

A wide range of compulsory measures directed towards individuals 
have been suggested and in some cases implemented, even though their 
negative side effects have been recognized. However, voluntary ones 
which could be equally effective have not been exploited.  The potential 
of voluntary measures has been recognized by the public.  The news 
report, "Blodgivarnaal blir 'friskhetsintyg'?", was occasioned by a sharp 
increase in blood donors in Malmo and reports that blood donor pins 
were being used at a dance hall as health certificates (Fredriksson, 
1987).  A corresponding increase was noted to not have occurred in 
Goteborg.  In Malmo the pins are given out after the first blood 
donation, while in Goteborg they are given out after ten donations.  So 
the difference in public response is hardly surprising, it results from a 
natural experiment on the control of sexually transmissible diseases.

3..Background

3.1..Informational precursors in social medicine

The epidemiological approach taken here is similar to the highly 
effective public health measures taken in 18th and 19th century to 
control infectious diseases. Up until that time cities (e.g., Copenhagen 
and Stockholm) most often had no effective sewage or garbage disposal 
services. This led to a situation in many cities where maximum 
population levels were reached, with deaths due to infection balancing 
population inputs. Having recognized that many diseases were 
transmitted (by microorganisms) in wastes, public works programs 
were undertaken in order to segregate fluids carrying wastes from 
fluids used for consumption and for food preparation.  These measures 
were taken well before effective medical procedures for dealing with 
many diseases were developed, and in most cases before the actual 
causative agents were identified. A key point is that knowledge about 
transmission of infectious agents preceeded their control. This control 
was implemented by a physical restructuring of fluid management  
through sanitary engineering.

The fluids dealt with here are distinguished by the source individual. 
Due to higher population densities, changes in attitudes about sex, 
increases in uses of invasive procedures (use of blood and other bodily 
products in medicine, and use of injectable drugs) persons are now 
much "closer" in a physiological sense then in earlier times (Seale & 
Medvedev, 1987). It is not only recommended to avoid certain classes 
of fluids that are in general known to contain infectious agents, but to 
avoid contact with body fluids from classes of persons in risk groups 
(Prostitutes asked, 1987). The approach discussed here goes one step 
further in this line of development, it introduces measures permitting 
one to routinely avoid contact with fluids from specific individuals who 
are at risk or known to be carriers of an infectious agent. This requires 
the routine use of prior knowledge about these agents. That is,  the 
availability of informational precursors associated with these agents.

3.1.1..Biological agents

A clear understanding of the approach requires distinction between 
biological agents, informational agents making demands upon attention, 
and informational agents that require only processing by machines. If 
each person was to inform a potential contact of all infectious agents 
carried by that person, then we could say that an informational 
precursor existed for each infectious agent. This would give persons the 
option of avoiding contact with fluids containing infectious agents. 

3.1.2..Informational demands upon attention

Aside from the privacy problems and diagnostic uncertainties which 
would reduce the effectiveness of such a procedure, there are major 
informational demands upon attention associated with it. Particularly in 
the case where there is a reasonable prevalence of an infectious agent 
in a population, the simple communication of diagnostic information 
would be inadequate. With sexually transmitted diseases, in most cases, 
at least one new person has been infected by the time a given 
individual has been diagnosed as carrying the infectious agent. Thus, a 
person would have to communicate not only their own diagnostic 
information, but also the diagnostic information from previous contacts. 
Some of information concerning a given contact would only become 
available much after that contact had take place, thus inducing 
unrealistic informational demands upon communicators.

3.1.3..Information processible by machine

A solution to this problem is to structure diagnostic data in 
standardized machine readable forms, thus permitting precursor 
information (both from direct diagnosis and from diagnostic 
information transmitted by contact tracing) to be exchanged by 
computers prior to an anticipated contact. This strategy also permits the 
introduction of an effective solution to the privacy problem. The idea is 
to make use of the information without revealing that information 
except when it is no longer sensitive (Stodolsky, in prep.). It also 
compensates to some degree for diagnostic uncertainties, since what is 
transmitted by automated contact tracing is information about risk, as 
opposed to direct diagnostic information. The automated contact tracing 
mechanism can also be implemented in a manner protecting personal 
integrity (Stodolsky, 1979a; 1979b; 1979c; 1983; 1986)

3.2..Theory of operation

The system outlined here is most simply explained if we assume that 
each person has a personal computer capable of directly exchanging 
information with those of other persons. These computers can, in the 
simplest case,  generate random numbers that are used to label 
transactions. A transaction is defined as an interaction capable of 
transmitting the infectious agent. After each transaction, therefore, a 
person has a unique label or code for that transaction. 

In the event that a person becomes ill or is identified as carrying an 
infectious agent, the transaction codes which represent transactions 
during which that agent could have been transmitted are then 
broadcast to all other computers. If a receiver's computer has a 
matching code, then that person is alerted to the possibility of the 
agent's presence, and can report to a medical center for testing and 
treatment. This iterates the process, thus identifying all carriers 
eventually. The effect is to model the epidemiological process, thereby 
identifying all (potential) carriers through forward and backward 
contact tracing.

In order to clarify the procedure, consider a scenario in which there are 
two types of actors, persons (Pi) and doctors (Di) (Figure 1). Doctors 
operate only within a health center (HC). There are also two types of 
agents, biological and informational, that can be transmitted during a 
transaction. Informational agents are always transmitted with physical 
agents. Each actor has a computer that can exchange information with 
another actor's computer. A doctor's computer can also broadcast 
messages to all actors at once by sending them through a more 
powerful computer at the health center.  Contact tracing is illustrated 
by the sequence in Figure 2. At time T1 person A (Pa) and person B 
(Pb) engage in a transaction. Their computers label this transaction with 
a number N1 and store the number. Pb then physically moves into 
contact with person C (Pc), this transaction is labeled N2 and recorded 
at time T2.  At time T3, Pb becomes ill and reports to a doctor (Da). The 
doctor verifies the infectious nature of the illness and then reads the 
transaction codes, N1 and N2, out of Pb's computer. These are broadcast 
to all other computers at time T4. When Pa's computer receives the 
broadcast, the transaction code N1 matches the number stored in 
memory. This alerts Pa to the fact that s/he is in the chain of 
transmission of the infection ( in this case Pa was the initial carrier of 
the infectious agent). When Pc's computer receives the broadcast, the 
transaction code N2 matches the number stored in memory. This alerts 
Pc to the fact that s/he may have been infected (at T2). The alerting of 
Pa is an example of backward tracing from Pb. The alerting of Pc is an 
example of forward tracing. We assume in this simplest case, that when 
an alert is received, the affected person voluntarily reports to a doctor. 
In a more secure system, a person's computer would not be capable of 
generating new transaction codes if a matching code had been received. 
This would indicate to potential new contacts that contact with this 
person was risky. (Actually, the more secure procedure would require 
the exchange of updated health certificates.)

3.3..Operational alternatives

An ideal system would ensure that all contacts were mediated by 
computer. Since the most appropriate technology, powerful wristwatch 
like computers with communication capabilities, is not available for the 
moment (though key components have become available [Ivey, Cox, , 
Harbridge, & Oldfield (1989)]), development will proceed on standard 
personal computers. While these machines are available in a hand held 
format, people can not be expected to carry them at all times. In many 
cases, people can organize their contacts using a personal computer 
from an office, public computer center, or their home, but clearly other 
options must be available. A voice-message system that duplicates all 
function of the personal computer, but with voice output and telephone 
key-pad input is an attractive option. It permits planned organization 
of contact opportunities with limited, but, for most persons, more than 
adequate security.

In the case of chance meetings, persons would be required to make an 
inquiry prior to proceeding with a contact. The common magnetic strip 
credit card offers an adequate level of security, but requires a readily 
accessible teller machine. Such a verification system assumes 
cooperation of appropriate financial institutions. A telephone-based 
verification system used in a manner similar to credit card verification 
is another option. The various options will be considered during the 
first year of the project.

4..Research plan

The overall research plan is based on a 2 factor design with repeated 
measures. One factor is risk group and the second is availability of an 
experimental health conferencing system. Dependent measures include 
health status and health related behaviors. The plan is designed to 
permit rigorous evaluation of results without interfering with effective 
service to the subject populations, and to permit rapid scaling up to a 
larger population if justified by the initial results. If the security needs 
are met, it is expected that demand for service will exceed supply. The 
waiting list management strategy will generate the control groups.

The effect of the health conferencing system on infection and risk 
behaviors is of major interest, thus this effect is measured as a within 
subject factor. Each group will be compared to itself at a later time. 
Comparison to cross sectionally matched individuals controls for time 
effects. The differential effectiveness the experimental intervention on 
different risk groups is studied as a between subject factor in order to 
enhance the generalizability of the results. A nested multi-variate 
analysis of co-variance with repeated measures using matched controls 
is used for overall data evaluation. 

4.1..Method

A secure conferencing system permitting automated interviewing and 
selection of conversation partners, as well as mail delivery functions 
will be developed.  The software will be installed on two identical 
systems. One system will be made available to the Organization of Gays and 
Lesbians in Denmark, the other to the (HIV) Positive Group in Denmark. 

Each person expressing interest in participating receives information 
describing the study and a preliminary self-administered interview. 
Person applying to the Positive Group must present evidence of 
seropositivity to be considered further. Persons applying to the 
Organization of Gays and Lesbians in Denmark must present results of a 
Polymerase Chain Reaction (PCR) investigation to be considered further. 
Upon presentation of appropriate medical evidence, the registrar 
assigns them a pseudonym and password. A comprehensive interview 
covering health history and health behaviors is then self-administered. 
Each person receives health education materials and is placed on the 
waiting list.

When 500 persons are available from each organization they will be 
formed into matched groups and randomly assigned to either treatment 
or control conditions. The treatment groups receive a questionnaire for 
guiding the selection of conversation partners. Controls remain on the 
waiting list for six months at which time they are integrated into the 
treatment condition. Depending upon results of a risk assessment 
interview, serological testing may again be required. Participants are 
required to give feedback interviews after meeting conversation 
partners. This serves as a check on self-reported data and as a source of 
information on opportunities for transmission of infectious agents. Data 
on interactions with other persons and degree of risk associated with 
them is also collected routinely. Sexual transmitted infections and other 
conditions requiring medical intervention are reported routinely. Health 
behavior interviews are readministered on six month intervals just 
prior to integration of a new persons into the treatment groups.

4.2..Time frame

The first year is devoted to preparations including software 
development, finalizing arrangements with participating organizations, 
and pilot testing (See "Specific tasks for preparation phase (First year)" 
below). The first six month period of the second year is reserved for 
training of registrars , and accumulating and interviewing of 
participants. The second six month period is for comprehensive testing 
of operational procedures as the first set of participants begins using 
the experimental system. Cross sectional data analysis techniques will 
be applied during this period.

The third half-year of the operational phase of the project will be 
devoted to the integration of the first set of control groups into the 
treatment condition. After this, all procedures and software will have 
been finalized. Longitudinal data analysis procedures will be integrated 
with those already in use. At two additional six month intervals, half of 
those on the waiting list will be added to the experimental groups using 
the health conferencing system. 

4.3. Specific tasks for preparation phase (First year)

4.3.1..Contact and discussions with organizations. 

The wide range of sensitive and important questions raised by the 
proposed study make it imperative that affected and concerned 
organizations and persons (Dansk Epidemiologisk Institut, Statens 
Serum Institut, Registertilsynet, Sundhedsstyrelsen, Landsforeningen 
for Boesser og Lesbiske, Positivgruppen, Frivillige Bloddonorer, selected 
journalists and politicians, etc.) have the opportunity to review and 
comment upon the proposal. This will include, but not be limited to 
those collaborating in the experiment proper. Invitations to a workshop 
series will be issued to those selected. The workshops will include 
lectures, demonstrations (both manual and computer), and discussions. 
Feedback from participants will be used as input to the experiment 
design.

4.3.2..Design of experimental trials

The specifics of the design including control procedures will be 
structured to insure both scientific validity of collected data and 
acceptability of procedures to participants and their organizations. It is 
expected there will be conflicts between these two demands and the 
workshops will be used to anticipate and facilitate their resolution. A 
specific question to be addressed will be the potential conflict between 
demands for participation and capacity of organizations to respond to 
them without sacrificing rigor of the trials. While previously developed 
questionnaires will serve a base for data collection, specific concerns 
and interests of different organizations and interests groups will 
influence the actual data requested from participants.

4.3.3..Design of secure registration procedures

Protection of the participants identity will be in part dependent upon 
the security of the registration and pseudonym assignment procedures. 
Abuse of the system that could result from persons obtaining multiple 
names will also be controlled by the registration system. Both 
administrative and cryptographic mechanisms will require careful 
specification. After a description of the cryptographic mechanisms for 
registration, organizational placement for administrative procedures 
will be determined.

4.3.4..Software development

The most important factor in protection of the participants is the 
security of their own computer systems. Both privacy and protection of 
identity depends upon the integrity of the cryptographic software. The 
software is also plays an essential role  of demonstrating the system so 
better understanding can be achieved by both users and 
representatives of organizations considering the adoption of the system. 
Certain components of the proposed system perform functions that 
have never been implemented on computer systems or that have not 
been implemented to perform the functions needed in this application. 
Preliminary software development will permit a better estimate of the 
overall effort required to satisfy the security and efficiency 
requirements in the proposed application. Preliminary development 
will also permit testing of the user interface to ensure easy operation 
under strict security requirements.

4.3.5..Simulation modeling

Simulation modeling for predicting effects of the completed system can 
play both analytic and educational roles. Graphics can effectively 
illustrate the relative impact of preventative as opposed to treatment-
based methods in epidemiology. Such simulations can influence 
organizational decision makers as well as potential users. Analytic 
questions concerning the relative impact of limited adoption of the 
technology on overall population morbidity and mortality can also be 
answered with simulation methods. This could answer cost 
effectiveness questions and be used to guide the rate of adoption of the 
new technology. Considering the very large expenses associated with 
clinical treatment of AIDS, the simulation models may be useful in 
estimating appropriate funding for operational stages of the project.

4.3.6..Publication of "Hormones" epidemiological model. 

While the general concept of real-time epidemiological modeling has 
been presented at a conference (Stodolsky, 1983), publication has been 
limited to an application involving control of electronic infections on 
computer networks (Stodolsky, 1989). Conference presentation and 
publication as a human population oriented application will strengthen 
theoretical review, and directly address specific questions concerning 
human and legal rights. The secure model was included in a recent 
conference presentation (Stodolsky, 1986). It would best be 
mathematized and then subject to a proof of correctness to insure that 
any flaws are identified before substantial software development 
efforts are made. 

4.3.7..Publication of "Conditional privacy:..."

The paper "Conditional privacy: Protecting expression by one-bit 
matchmaking" received public exposure in a conference presentation 
(Stodolsky, 1986). While the method is relatively straight forward 
cryptographicly, conference presentation and publication would 
increase the probability that any protocol errors are uncovered and 
perhaps suggest enhancements that integrate certification with 
information exchange.

4.3.8..Test data collection

Once data requirements are identified, data collection procedures will 
be tested in a software environment approximating the final system. 
This will permit identification of user interface and security problems 
that could cause problems.

4.3.9..Pilot tests

Test of the completed system, not including cryptographic security, can 
be conducted with non-sensitive data to insure operational procedures 
are functional. Participants could include students and interested 
person attending demonstrations.

5..References

AIDS not gentle on the mind. (1987, March 26). New Scientist, (1153), 
38-39.

Brecher, E. M. (1975). Prevention of sexually transmitted diseases. The 
Journal of Sex Research, 11(4), 318-328.

Cancer virus linked to drug users. (1987, May 21). International Herald 
Tribune, 8.

Chaum, D. (1985). Security without identification: Transaction systems 
to make big brother obsolete. Communications of the ACM, 28(10), 
1030-1044.

Fredriksson, A. (1987, July, 15). Blodgivarnaal blir "friskhetsintyg"? 
Goteborgs-Posten, No. 88, 18.

Hellerstedt, L. (1987, June 19). Homosexutredning: Aidstest "frikort" 
foer loesslaeppt sex. Dagens Nyheter.

Ivey, P. A., Cox, A. L., Harbridge, J. r., & Oldfield, J. K. (1989, August).
A single-chip public key encryption subsystem. IEEE Journal of Solid-
State Circuits.

Painters and Dockers (Rock musicians). (1988). "Safe Sex", Crocodile 
(Compact Disk EMA CD1). Export Music Australia.

Prostitutes asked not to give blood. (1987, April 9). New Scientist, 
(1555), 29.

Seale, J. R. & Medvedev, Z. A. (1987). Origin and transmission of AIDS. 
Multi-use hypodermics and the threat to the Soviet Union: discussion 
paper. Journal of the Royal Society of Medicine, 80, 301-304.

Smith, D. (1989, July 14). AZT, Acyclovir, and the case for early 
treatment. AIDS Treatment News, Issue No. 83.

Stodolsky, D. (1979a, April 9). Personal computers for supporting health 
behaviors. Stanford, CA: Department of Psychology, Stanford University. 
(Preliminary proposal)

Stodolsky, D. (1979b, May 21). Social facilitation supporting health 
behaviors. Stanford, CA: Department of Psychology, Stanford University. 
(Preliminary proposal)

Stodolsky, D. (1979c, October). Systems approach to the epidemiology 
and control of sexually transmitted diseases. Louisville, KY: System 
Science Institute, University of Louisville. (Preliminary project 
proposal)

Stodolsky, D. (1983, June 15). Health promotion with an advanced 
information system. Presented at the Lake Tahoe Life Extension 
Conference. (Summary)

Stodolsky, D. (1986, June). Data security and the control of infectious 
agents. (Abstracts of the cross disciplinary symposium at the University 
of Linkoeping, Sweden: Department of Communication Studies). 

Stodolsky, D. (1989). Net hormones: Part 1 - Infection control assuming 
cooperation among computers [Machine-readable file]. Van Wyk, K. R. 
(1989, March 30). Several reports available via anonymous FTP. Virus-
L Digest, 2(77). Abstract republished in van Wyk, K. R. (1989, April 24). 
Virus papers (finally) available on Lehigh LISTSERV. Virus-L Digest, 
2(98). (Available via anonymous file transfer protocol from LLL-
WINKEN.LLNL.GOV: File name "~ftp/virus-l/docs/net.hormones" at 
Livermore, CA: Lawrence Livermore National Laboratory, Nuclear 
Chemistry Division and IBM1.CC.LEHIGH.EDU: File name "HORMONES 
NET" at Bethlehem, PA: Lehigh University. And by electronic mail from 
LISTSERV@LEHIIBM1.BITNET: File name "HORMONES NET" at Lehigh 
University).

Stodolsky, D. (in prep.). Conditional privacy: Protecting expression by 
one-bit matchmaking.

=========================================================

 /---[]                                  []
| Pa  |                   ---------------[]--------------
 \---/                   |               []              |
                         |                               |
 /---[]                  |   /---[]    /---[]            |
| Pb  |                  |  | Da  |   | Db  |            |
 \---/                   |   \---/     \---/             |
                         |                               |
                         | Health Center                 |
/---[]                    -------------------------------
| Pc |
\---/

----------------------------------------------------------

Explanation of Symbols:

          /---\
Persons  | Pi  |
          \---/
          
          
          
          /---\
Doctors  | Di  |
          \---/

       
           
Computers []

Figure 1

============================================================

P
h                           -----------      -----[]-----
y                          |   N1,N2   |    |     N1,N2  |
s                          | Pb     Da |    |   Da       |
i                          |           |    |            |
c                           -----------      ------------
a    Pa           Pa                                    
l    N1                                           N1=N1 
     Pb                        Pa               Pa      
P                 Pb                                    
l                 N2                              N2=N2 
a    Pc           Pc           Pc               Pc     
c                                                       
e                                                 Pb

 Time ----------------------------------------------->
     T1           T2           T3                 T4

----------------------------------------------------------

Explanation of symbols:

Person i        Pi             Doctor A            Da

Physical and    Pi
informational   Ni             Transaction codes   Ni
exchange        Pj
                                                  ----
Information       Ni,Nj        Health Center     |    |
transmission    Pi                                ----

Information       Ni=Ni        Health Center      -[]-
reception       Pi             Computer          |    |
and matching                   Transmitting       ----

Time of operation   Ti

Figure 2

===========================================================
David S. Stodolsky, PhD      Routing: <@uunet.uu.net:stodol@diku.dk>
Department of Psychology                  Internet: <stodol@diku.dk>
Copenhagen Univ., Njalsg. 88                  Voice + 45 31 58 48 86
DK-2300 Copenhagen S, Denmark                  Fax. + 45 31 54 32 11
