
Minimum Requirements
for Creating a DXF File
of a 3D Model


Paul Bourke
School of Architecture, Property, and Planning
Auckland University, Private Bag, Auckland, New Zealand
Fax: +64 9 3737410, Ph: +64 9 737599 x7367
EMail: pdbourke@ccu1.auckland.ac.nz

Original: March 1990
Revision: September 1993

Introduction
DXF is possibly the most widespread CAD exchange format in use by CAD packages on small computer systems. It was developed primarily by the AutoCAD developers and has thus received it popularity mainly from the high number of AutoCAD stations. Most CAD systems can export and most also import DXF, at least for 2D data.
This document describes the minimum requirements needed to create a DXF description of some 3D object and/or scene. This description is not complete by any means but contains enough information for describing the geometry of many 3D models.
A DXF file is a text only file which consists of the following sections: header, tables, blocks, and entities. Each section contains a set of groups each of which occupies two lines in the file. The first line is called the group code, it is an integer in the range of 0 to 999. The second line is called the value which depends on the group code.
The group code indicates the type of value that follows according to the table below.
Group code	Value type  
0-9	string
10-59	real number
60-79	integer
210-239	real number
999	comment

Header comment and header section
It is common for the first line of a DXF file to contain a comment, the group code for comments is 999. A standard convention is to describe the creator of the DXF file in this comment. It might also be relevant to include the date and time of creation.
The header section contains general information about the drawing, these are only relevant when creating specialised DXF files for AutoCAD. Some examples of what can be included in the header section are: version numbers, unit specification, current layer, grid spacing, tolerances, drawing bounds, fill mode and pattern, etc. Programs that read DXF files will have sensible defaults for these parameters. Since this document is only interested in the transfer of the geometry we don't need a complicated header section. A header comment and header section may look like the following. The model extents ($EXTMIN and $EXTMAX) are included here because some packages insist on it.
999
DXF created from <program name>
0
SECTION
2
HEADER
9
$ACADVER
1
AC1006
9
$INSBASE
10
0.0
20
0.0
30
0.0
9
$EXTMIN
10
0.0
20
0.0
9
$EXTMAX
10
1000.0
20
1000.0
0
ENDSEC

Tables Section
These can be used to specify predefined constants, line styles, text styles, layers, view tables, user coordinate systems, etc. We will only use tables to define some layers for use later on. Note: not all programs that support DXF import will support layers and those that do usually insist on the layers being defined before use. The following will create a default line style and initialise layers 1 and 2 for use later on.
0
SECTION
2
TABLES
0
TABLE
2
LTYPE
70
1
0
LTYPE
2
CONTINUOUS
70
64
3
Solid line
72
65
73
0
40
0.000000
0
ENDTAB
0
TABLE
2
LAYER
70
6
0
LAYER
2
1
70
64
62
7
6
CONTINUOUS
0
LAYER
2
2
70
64
62
7
6
CONTINUOUS
0
ENDTAB
0
TABLE
2
STYLE
70
0
0
ENDTAB
0
ENDSEC

Blocks section
Not necessary here but it is good form to include one anyway. The following is an empty block section.
0
SECTION
2
BLOCKS
0
ENDSEC

Entities section
The entities section is where the geometric elements of the model or scene are described. The following is the standard form of the entities section.
0
SECTION
2
ENTITIES
<Geometric entities go here, see later>
0
ENDSEC

Colour
Only index colour is supported, it is done with group code 62 within an entity description. The value is the colour index. The way the colours are mapped is dependent on the application and the hardware capabilities. To determine the colour mappings on a particular system create a number of lines segments each with a different colour and import that into the CAD package. Many packages that don't use an index colour model will simply ignore the colour instruction. See appendix 1 for a sample DXF file to determine the first 64 index colours on your system. The following will specify index colour 4
62
4

Layers
Layer numbers are specified with group code 8 within an entity description. The layers to be used should be defined as described earlier in the tables section. Most DXF importers will insist on predefining the layers in the tables. Note: the number of layers possible will vary on the software used to import the DXF file. The following indicates that the current entity is to be placed on layer 2
8
2

Geometry
DXF explicitly supports two 3D primitive types, namely, 3DFACE and 3DLINE (it is usual to just use the plain LINE primitive). LINE consists of the two endpoints, 3DFACE specifies either three or four vertex facets (polygonal bounded planes). All four vertices must be specified, in the case of a three point facet the last vertex is specified twice. In general vertex group codes are numbers 10,20,30 for the first (x,y,z) triple, 11,21,31 for the second, 12,22,32 for the third and 13,23,33 for the fourth. Each vertex group code is followed by the appropriate coordinate value. Note: that there is no requirement for the four vertices specifying the facet to be planar but it may be important for the software that imports the DXF file. The vertices can be ordered clockwise or anticlockwise with respect to the outward pointing normal, however some packages may insist on a particular orientation, especially rendering software.

The following specifies a line on layer 2 of index colour number 4 between the points (8500, -12563.4, 0) and (8500, -12563.4, 4150.99)
0
LINE
8
2
62
4
10
8500
20
-12563.4
30
0
11
8500
21
-12563.4
31
4150.99

The following specifies a 4 vertex facet on layer 1 with index colour number 3.
0
3DFACE
8
1
62
3
10
3000
20
10000
30
5419.35
11
4000
21
10000
31
5605.46
12
4000
22
11000
32
4861.04
13
3000
23
11000
33
4674.94

To create planar facets with more than 3 or 4 vertices it is necesary to use the POLYLINE primitive, the reader should consult the DXF specification for more information on this.

End of file
This indicates the end of the DXF file, it is not usually necessary but should be included for good form. Most applications expect a carriage return after the EOF text.
0
EOF

Appendix 1
The following can be used to determine the colour mapping used on your system. It contains 64 line segments with colours from 0 to 63. Note that many CAD packages only support 8 colours, also the following will indicate whether your package starts its colour numbering at 0 or 1 (the two most common choices)

999
Colour
0
SECTION
2
HEADER
9
$ACADVER
1
AC1006
9
$INSBASE
10
0.0
20
0.0
30
0.0
9
$EXTMIN
10
0.0
20
0.0
9
$EXTMAX
10
1000.0
20
1000.0
9
$LINMIN
10
0.0
20
0.0
9
$LINMAX
10
1000.0
20
1000.0
0
ENDSEC
0
SECTION
2
TABLES
0
TABLE
2
LTYPE
70
1
0
LTYPE
2
CONTINUOUS
70
64
3
Solid line
72
65
73
0
40
0.000000
0
ENDTAB
0
TABLE
2
LAYER
70
6
0
LAYER
2
1
70
64
62
7
6
CONTINUOUS
0
ENDTAB
0
TABLE
2
STYLE
70
0
0
ENDTAB
0
ENDSEC
0
SECTION
2
BLOCKS
0
ENDSEC
0
SECTION
2
ENTITIES
0
LINE
8
1
62
0
10
0
20
0
30
0
11
0
21
0
31
1
0
LINE
8
1
62
1
10
0.05
20
0
30
0
11
0.05
21
0
31
1
0
LINE
8
1
62
2
10
0.1
20
0
30
0
11
0.1
21
0
31
1
0
LINE
8
1
62
3
10
0.15
20
0
30
0
11
0.15
21
0
31
1
0
LINE
8
1
62
4
10
0.2
20
0
30
0
11
0.2
21
0
31
1
0
LINE
8
1
62
5
10
0.25
20
0
30
0
11
0.25
21
0
31
1
0
LINE
8
1
62
6
10
0.3
20
0
30
0
11
0.3
21
0
31
1
0
LINE
8
1
62
7
10
0.35
20
0
30
0
11
0.35
21
0
31
1
0
LINE
8
1
62
8
10
0.4
20
0
30
0
11
0.4
21
0
31
1
0
LINE
8
1
62
9
10
0.45
20
0
30
0
11
0.45
21
0
31
1
0
LINE
8
1
62
10
10
0.5
20
0
30
0
11
0.5
21
0
31
1
0
LINE
8
1
62
11
10
0.55
20
0
30
0
11
0.55
21
0
31
1
0
LINE
8
1
62
12
10
0.6
20
0
30
0
11
0.6
21
0
31
1
0
LINE
8
1
62
13
10
0.65
20
0
30
0
11
0.65
21
0
31
1
0
LINE
8
1
62
14
10
0.7
20
0
30
0
11
0.7
21
0
31
1
0
LINE
8
1
62
15
10
0.75
20
0
30
0
11
0.75
21
0
31
1
0
LINE
8
1
62
16
10
0.8
20
0
30
0
11
0.8
21
0
31
1
0
LINE
8
1
62
17
10
0.85
20
0
30
0
11
0.85
21
0
31
1
0
LINE
8
1
62
18
10
0.9
20
0
30
0
11
0.9
21
0
31
1
0
LINE
8
1
62
19
10
0.95
20
0
30
0
11
0.95
21
0
31
1
0
LINE
8
1
62
20
10
1
20
0
30
0
11
1
21
0
31
1
0
LINE
8
1
62
21
10
1.05
20
0
30
0
11
1.05
21
0
31
1
0
LINE
8
1
62
22
10
1.1
20
0
30
0
11
1.1
21
0
31
1
0
LINE
8
1
62
23
10
1.15
20
0
30
0
11
1.15
21
0
31
1
0
LINE
8
1
62
24
10
1.2
20
0
30
0
11
1.2
21
0
31
1
0
LINE
8
1
62
25
10
1.25
20
0
30
0
11
1.25
21
0
31
1
0
LINE
8
1
62
26
10
1.3
20
0
30
0
11
1.3
21
0
31
1
0
LINE
8
1
62
27
10
1.35
20
0
30
0
11
1.35
21
0
31
1
0
LINE
8
1
62
28
10
1.4
20
0
30
0
11
1.4
21
0
31
1
0
LINE
8
1
62
29
10
1.45
20
0
30
0
11
1.45
21
0
31
1
0
LINE
8
1
62
30
10
1.5
20
0
30
0
11
1.5
21
0
31
1
0
LINE
8
1
62
31
10
1.55
20
0
30
0
11
1.55
21
0
31
1
0
LINE
8
1
62
32
10
1.6
20
0
30
0
11
1.6
21
0
31
1
0
LINE
8
1
62
33
10
1.65
20
0
30
0
11
1.65
21
0
31
1
0
LINE
8
1
62
34
10
1.7
20
0
30
0
11
1.7
21
0
31
1
0
LINE
8
1
62
35
10
1.75
20
0
30
0
11
1.75
21
0
31
1
0
LINE
8
1
62
36
10
1.8
20
0
30
0
11
1.8
21
0
31
1
0
LINE
8
1
62
37
10
1.85
20
0
30
0
11
1.85
21
0
31
1
0
LINE
8
1
62
38
10
1.9
20
0
30
0
11
1.9
21
0
31
1
0
LINE
8
1
62
39
10
1.95
20
0
30
0
11
1.95
21
0
31
1
0
LINE
8
1
62
40
10
2
20
0
30
0
11
2
21
0
31
1
0
LINE
8
1
62
41
10
2.05
20
0
30
0
11
2.05
21
0
31
1
0
LINE
8
1
62
42
10
2.1
20
0
30
0
11
2.1
21
0
31
1
0
LINE
8
1
62
43
10
2.15
20
0
30
0
11
2.15
21
0
31
1
0
LINE
8
1
62
44
10
2.2
20
0
30
0
11
2.2
21
0
31
1
0
LINE
8
1
62
45
10
2.25
20
0
30
0
11
2.25
21
0
31
1
0
LINE
8
1
62
46
10
2.3
20
0
30
0
11
2.3
21
0
31
1
0
LINE
8
1
62
47
10
2.35
20
0
30
0
11
2.35
21
0
31
1
0
LINE
8
1
62
48
10
2.4
20
0
30
0
11
2.4
21
0
31
1
0
LINE
8
1
62
49
10
2.45
20
0
30
0
11
2.45
21
0
31
1
0
LINE
8
1
62
50
10
2.5
20
0
30
0
11
2.5
21
0
31
1
0
LINE
8
1
62
51
10
2.55
20
0
30
0
11
2.55
21
0
31
1
0
LINE
8
1
62
52
10
2.6
20
0
30
0
11
2.6
21
0
31
1
0
LINE
8
1
62
53
10
2.65
20
0
30
0
11
2.65
21
0
31
1
0
LINE
8
1
62
54
10
2.7
20
0
30
0
11
2.7
21
0
31
1
0
LINE
8
1
62
55
10
2.75
20
0
30
0
11
2.75
21
0
31
1
0
LINE
8
1
62
56
10
2.8
20
0
30
0
11
2.8
21
0
31
1
0
LINE
8
1
62
57
10
2.85
20
0
30
0
11
2.85
21
0
31
1
0
LINE
8
1
62
58
10
2.9
20
0
30
0
11
2.9
21
0
31
1
0
LINE
8
1
62
59
10
2.95
20
0
30
0
11
2.95
21
0
31
1
0
LINE
8
1
62
60
10
3
20
0
30
0
11
3
21
0
31
1
0
LINE
8
1
62
61
10
3.05
20
0
30
0
11
3.05
21
0
31
1
0
LINE
8
1
62
62
10
3.1
20
0
30
0
11
3.1
21
0
31
1
0
LINE
8
1
62
63
10
3.15
20
0
30
0
11
3.15
21
0
31
1
0
ENDSEC
0
EOF



Appendix 2
The following example is a complete description of a line, a triangular facet, and a four pointed facet. All the objects are on layer 1, and have colour index 1. This can be used to test whether the DXF importer you are using supports all of these 3D primitives. The resulting model should look like the following.

 

999
VISION3D DXF
0
SECTION
2
HEADER
9
$ACADVER
1
AC1006
9
$INSBASE
10
0.0
20
0.0
30
0.0
9
$EXTMIN
10
0.0
20
0.0
9
$EXTMAX
10
1000.0
20
1000.0
9
$LINMIN
10
0.0
20
0.0
9
$LINMAX
10
1000.0
20
1000.0
0
ENDSEC
0
SECTION
2
TABLES
0
TABLE
2
LTYPE
70
1
0
LTYPE
2
CONTINUOUS
70
64
3
Solid line
72
65
73
0
40
0.000000
0
ENDTAB
0
TABLE
2
LAYER
70
6
0
LAYER
2
1
70
64
62
7
6
CONTINUOUS
0
ENDTAB
0
TABLE
2
STYLE
70
0
0
ENDTAB
0
ENDSEC
0
SECTION
2
BLOCKS
0
ENDSEC
0
SECTION
2
ENTITIES
0
3DFACE
8
1
62
1
10
-0.5
20
-0.5
30
-0.5
11
-0.5
21
0.5
31
-0.5
12
0.5
22
0.5
32
-0.5
13
0.5
23
-0.5
33
-0.5
0
3DFACE
8
1
62
1
10
-0.5
20
-0.5
30
-0.5
11
0.5
21
-0.5
31
-0.5
12
0
22
-0.5
32
0.5
13
0
23
-0.5
33
0.5
0
LINE
8
1
62
1
10
0
20
-0.5
30
0.5
11
0
21
0.5
31
-0.5
0
ENDSEC
0
EOF


