                        38 page printout

                   THE CLAIMS OF CHRISTIANITY
                            EXAMINED
                 FROM A RATIONALIST STANDPOINT.

                               BY

                         CHARLES WATTS.

         "To believe without evidence and demonstration
          is an act of ignorance and folly." -- VOLNEY.

          (Issued for the Rationalist Press Committee.)

                             LONDON:

           WATTS & CO., 17, JOHNSON'S COURT, FLEET ST.

                          ****     ****

                            PREFACE.

     IN the following pages there is no attempt to criticize all
the alleged evidences in favor of Christianity. The aim of the
writer has been to fairly examine the, principal claims that have
recently been put forward on behalf of the orthodox faith. It is
hoped that the examination that has been made, and the facts given
in these pages, may be of some practical service to the young and
earnest searchers for truth.

                                                       C.W.

                          ****     ****

                          INTRODUCTION.

     THE purpose of the following unpretentious contribution to the
modern criticism of the claims of orthodox Christianity is to
present to the reader, from a Rationalistic standpoint, a popular,
brief, and impartial examination of the evidences which are set
forth in support of the supernatural and unique character of the
Christian religion. The object of the writer has been to ascertain
if there is sufficient reason to justify the maintaining of the
various positions that are now taken by Christian exponents in the
defence of their faith. The nature of the evidence required for
such a purpose, and the different subjects to which it is applied,
together with the questions that are defended, are all duly
considered.

     We have taken the recently-published "Handbook of Christian
Evidences," by Dr. Alexander Stewart, Professor of the Theological
University of Aberdeen, as a basis for our critical examination;
but we have not attempted to reply in detail to all the positions
laid down in his book. We have preferred to give a general summary
of the arguments that may be advanced against his conclusions, so
that those who read both treatises may be the better able to form
an accurate judgment on the various questions dealt with. The
"Handbook" is issued specially for the young, with the expressed
hope "that it may be the means of strengthening the faith of
inquiring minds, at a time when the most sacred truths are 

                         Bank of Wisdom
                  Box 926, Louisville, KY 40201
                               1

               THE CLAIMS OF CHRISTIANITY EXAMINED

subjected to unsparing criticism." The Professor has stated his
case calmly, and we trust it will be found that we have been
equally calm in presenting the Rationalistic view. We desire that
those who read the "Handbook" should carefully peruse the following
pages, and we hope that its contents may strengthen the
discriminating power of inquiring minds at a time when all rational
persons should be "ready always to give answer to every man that
asketh them a reason concerning the hope that is in them."

     We sincerely hope that no believer in Christianity will
hesitate to read and to well ponder over what is here written. If
what we have stated be studied with an earnest desire to arrive at
truth, good results only will follow, for, as Bacon says, it is
"error alone that suffers through conflict with truth." Principles
unable to withstand the test of investigation are destitute of what
should be one of their highest recommendations. Belief without
critical examination has too often perpetuated error and fostered
credulity. If Christianity be fallacious, why should not its
fallacy be made known? If, however, it be true, its truth will be
the more apparent as its claims are honestly investigated and
examined. Dr. Collyer observes, in his lectures on miracles, that
"he who forbids you to reason on religions subjects, or to apply
your understanding to the investigation of revealed truth, is
insulting the character of God, as though his acts shrank from
scrutiny -- is degrading his own powers, which are best employed
when they are in pursuit of such sublime and interesting subjects."
Dr. Chalmers, the eminent Scotch divine, also remarks: "We should
separate the exercises of the understanding from the tendencies of
the heart. We should be prepared to follow the light of evidence,
though it may lead us to conclusions the most painful and
melancholy. We should train our thoughts to all the hardihood of
abstract and unfeeling intelligence. We should give up everything
to the supremacy of argument, and be able to renounce without a
sigh all the tenderest prepossessions of infancy the moment that
truth demands of us the sacrifice."

                          ****     ****

                           SECTION I.

          THE NATURE AND VALUE OF CHRISTIAN EVIDENCES.

     IT is reasonable to demand that definite evidence should be
furnished in support of extraordinary claims, Proof that would be
sufficient to win our belief in an ordinary matter-of-fact
occurrence would be inadequate to establish the truth of those
claims which are generally put forward on behalf of Christianity.
According to Webster, evidence is "that which elucidates and
enables the mind to see truth; proof arising from our own
perceptions by the senses, or from the testimony of others, or from
the induction of reason." Thus we have three methods through which
evidence is obtained, and we propose to consider if either one of
them is of any value in establishing the claims of Christian
exponents.





                         Bank of Wisdom
                  Box 926, Louisville, KY 40201
                               2

               THE CLAIMS OF CHRISTIANITY EXAMINED

     1. Consciousness. -- This method can only be of service where
truths are self-evident, which those claimed for Christianity are 
not; therefore, if they can be corroborated at all, it must be from
external sources. If Christian truths were self-evident, there
would be no necessity for the repeated efforts that are being
constantly made to ascertain what the truths are. Moreover, we find
that different persons have different conceptions of what
Christianity really is, while many fail to recognize in any way its
alleged verities. It appears to us that this would not be so if
Christian claims were based upon self-evident truths, for in that
case they would command ready assent from every honest inquirer.

     2. Testimony. -- This method, to be valuable as evidence,
should be thoroughly trustworthy, and ought to come to us through
channels that are, beyond all doubt, unimpeachable. But, in
reference to Christianity, the very opposite is the fact. Its
testimony is found in the New Testament, which, as the Rev. Dr.
Giles observes, contains "contradictions that cannot be reconciled,
imperfections that would greatly detract from even admitted human
compositions, and erroneous principles of morality that would have
hardly found a place in the most incomplete systems of the
philosophers of Greece and Rome" ("Christian Records," Preface,
p.-7). John W. Haley, M.A., in his work on "An Examination of the
Alleged Discrepancies of the Bible," also states (pages 1 and 2)
that "no candid and intelligent student of the Bible will deny that
it contains numerous discrepancies; that its statements, taken
Prima facie, not infrequently conflict with or contradict one
another, may safely be presumed. This fact has been more or less
recognized by Christian scholars in all ages." Haley further
alleges in the same work (page 2): "Moses Stuart ('Critical History
and Defence of Old Testament Canon,' page 193': revised edition,
page 179), whose candor was commensurate with his erudition,
acknowledges that in our present copies of the Scriptures there are
some discrepancies between different portions of them which no
learning or ingenuity can reconcile,' To much the same effect
Archbishop Whately ('On Difficulties in Writings of St. Paul,'
essay 7, section 4) observes: 'That the apparent contradictions of
Scripture are numerous ... is too notorious to need being much
insisted on."' Now, we submit that testimony, coming through such
a doubtful channel as these eminent Christian writers have stated
the New Testament to be, cannot be depended upon as furnishing
reliable evidence in favor of the extraordinary claims of
Christianity.

     3. The Induction of Reason. -- The evidence to be derived from
this method in support of Christianity is exceedingly slight.
Reason gives no authority for the belief in the Fall of Man,
Original Sin, Vicarious Sacrifice, the Trinity, the Miraculous
Conception, Hell, and Eternal Torments. To us it seems most
unreasonable to expect that all mankind, with their different
trainings and varied mental capacities, should be compelled to
accept one particular faith under a threat of the infliction of a
most cruel and agonizing penalty (see Acts iv. 10 - 12; Mark xvi.
16; 2 Thess. i. 7, 8, 9); to believe that a good God would so have
arranged matters that the majority of his children would be doomed
to eternal perdition (see Matt. vii. 13, 14; Matt. xx. 16), and
that God should have ordained some men to condemnation and others 


                         Bank of Wisdom
                  Box 926, Louisville, KY 40201
                               3

               THE CLAIMS OF CHRISTIANITY EXAMINED

to dishonor before they were born (see Jude 4; Romans .ix. 15-22).
These are but a few specimens of a system against which reason
revolts. The only "evidence" that can fairly be produced in favor
of orthodox Christianity is that of faith and revelation. It was by
these agencies that the greatest Bible blessings were said to have
been obtained, and through which it is reported that St. Paul
himself was convinced of its truth (see Hebrews xi.; Gal. i. 12).
Such "evidence," however, is impotent to have any practical
argumentative force to-day.

     In dealing with Christian evidences, we must not overlook the
fact that the present age is one of unlimited inquiry, which should
neither be baffled nor arrested -- a time when many of the old
landmarks of theology are being removed. We have thus to make a new
survey of the controversial field, in order to ascertain our
correct position, Indeed, we are frequently cautioned by modern
Christian writers that we must attack the latest views put forth
concerning their faith. This appears to us a reasonable request,
for no sensible general would waste his powder upon forts that had
been abandoned by the enemy. But the fact that Christians have been
compelled to take up new positions in defence of their faith is
certainly no evidence in its favor, but rather the opposite. Still,
as they have forsaken their old citadels, it is necessary to follow
them to their new battle-ground. The changes that have taken place
in the advocacy of Christianity are indeed remarkable, and they
afford striking evidence against the assumption of its being a God
sent religion. Let us note a few of its principal mutations. At a
period not very remote the whole of the Bible was believed to be
the "word of God;" Christians of to-day assert that only a portion
of the Scriptures should be so described. Hence plenary inspiration
has been given up, and we are now informed that the Bible contains
the "inspired word," but that the whole of it is not inspired. The
question, however, here arises, How are we to distinguish the
inspired from the uninspired? Is the human to decide what is
divine? If yes, the reason of man is superior to the revelation of
God. If no, by what evidence are we to judge what is truth and what
is error in the Bible? Miracles are now said to require evidence to
prove their truth, whereas in former times they were cited to prove
the truth of Christianity. Prophecy is now thought to be the desire
of the human heart, and is no longer depended upon as the
infallible foreteller of future events. The fact that unbelievers
have heroically faced death in attestation of what they deemed to
be true has caused Christian exponents to give up the contention
that martyrdom proves the truth of that for which a man becomes a
martyr.

     Now, surely it cannot reasonably be alleged that these changes
and modifications afford any evidence of the stability of the
Christian faith. To affirm that the Christians of the past were in
error in their conceptions of the nature of Christianity does not
remove the difficulty, because we have no evidence that the
Christians of the present time are more correct in their
representations of Christianity than were their predecessors. Both
have had the same sources from which they drew their conclusions.
Besides, what guarantee have we that Christians of future
generations will not condemn the nineteenth-century interpretation
of their faith? The mutability which has hitherto characterized the


                         Bank of Wisdom
                  Box 926, Louisville, KY 40201
                               4

               THE CLAIMS OF CHRISTIANITY EXAMINED

Christian religion will, in all probability, continue as knowledge
increases and mental freedom expands. It must not be forgotten,
moreover, that, if Christianity were perfect at its inception,
every subsequent change must necessarily have deteriorated its
value; while, if it were not perfect at its origin, and if the
alterations which it has undergone have improved it, then its
present condition is the result of man's ingenuity, and the faith
of to-day is not the production of what is called Divinity.

     Professor Stewart, in his "Handbook," says The evidences of
Christianity do not claim to be demonstrative, but to have a high
degree of probability -- as high as in the case of other principles
which determine human action." But there is no analogy between
Christianity and "other principles which determine human action."
We have no evidence upon which we can depend as to the origin and
early history of the Christian faith, and therefore we cannot
consistently apply the law of probability to its birth and infancy.
In human affairs we establish "a high degree of probability,"
either by personal investigation or upon the trustworthy testimony
of others. In the case of the establishment of Christianity,
however, we can adopt neither of these methods. Of course, personal
examination is impossible; and, apart from the New Testament, there
is no reliable testimony, either sacred or secular, as to the
birth, life, and death of Jesus. Supposing the Gospel account of
his birth is accepted, even then only one person could testify as
to its accuracy, and she maintained silence upon the subject. No
other person then living could have vouched for its truth. How,
therefore, is it possible for us to possess any evidence of the
miraculous introduction of Christ into the world? At the most we
have but an account of a rumor that is supposed to have been
circulated two thousand years ago; and this rumor did not, it
appears, reach the historians living at the time when the birth is
said to have taken place. Even two of the special biographers of
Christ seem to have known nothing of the event. This is where good
testimony would be valuable; but it is nowhere to be found in the
two Gospels referred to.

     It is quite useless to talk about "the nature and value" of
the evidences of Christianity, as many theologians do, inasmuch as
the institution of the faith is not the subject of any history that
has survived to the present day. The documents that are alleged to
have contained its earliest credentials cannot be traced. It is
admitted by Biblical scholars that nothing was known of the New
Testament for nearly two centuries after the events therein
recorded were said to have happened; and it is also acknowledged
that, from that period to the present, the book has been altered
again and again. Now, remembering that these very Scriptures
contain the only evidence of the primitive history of Christianity,
it will be seen that such evidence cannot be of any real value in
the attempt to establish the validity of the Christian claims.

     An important fact in connection with the value of Christian
evidences is this, that the very nature of many of the events
recorded in the New Testament is such that it is impossible to
secure any evidence to prove that they took place. The age of
implicit belief has gone, and the intelligent minds of to-day
cannot be satisfied by being told that ages ago things occurred 


                         Bank of Wisdom
                  Box 926, Louisville, KY 40201
                               5

               THE CLAIMS OF CHRISTIANITY EXAMINED

that are now known to be contrary to the experience of the world
and to the laws of nature. The knowledge that certain phenomena
result from natural causes should prevent men from ascribing them
to agencies above, beyond, or outside nature. Hence evidences, to
carry conviction, ought to refer to matters which accord with what
is known of nature and of man. The fact is Christian evidences do
not do this, for they are cited to prove the truth of a system
which teaches many absurd improbabilities that no sane man would
now believe upon any amount of testimony. For instance, what
evidence would prove to the existing generation that a child could
be born without a human father, that the human body could possess
at one time hundreds of devils, and that dead men could be raised
to life from their graves? Such things are opposed to all reason,
and yet they form a part of the teachings of Christianity.

     The best evidence that can be adduced to prove the truth of
any religion is the reasonableness of its doctrines and the
practicability and usefulness of its ethics. With such advantages
its truth becomes self-evident, and requires no elaborate treatises
to prove its value. Now, it is of these two particular features
that Christianity is deficient; its doctrines are mystical and
absurd, and, so far as it has any unique morality, it is incapable
of being reduced to practice in daily life. Of its doctrinal folly
there is ample evidence in its teachings as to the Trinity, the
scheme of salvation, and the perplexity of Free Will; of the
impracticability of the ethical inculcation the Sermon on the Mount
is a sufficient witness. It is true this "Sermon" has been called
the Magna Charta proclaimed by Christ, although it has never been
made the basis of any human government. Its injunctions are so
antagonistic to the requirements of modern civilization that no
serious attempt has ever been made to put them in practice. It may
be mentioned that the genuineness of the "Sermon" has been boldly
questioned by Professor Huxley, who writes: "I am of opinion that
there is the gravest reason for doubting whether the Sermon on the
Mount was ever preached, and whether the so-called Lord's Prayer
was ever prayed by Jesus of Nazareth" ("Controverted Questions,"
page 415). The late Bishop of Peterborough said: "It is not
possible for the State to carry out all the precepts of Christ. A
State that attempted to do so could not exist for a week. If there
be any person who maintains the contrary, his proper place is in a
lunatic asylum " (Fortnightly, January, 1890). Even supposing the
historical claims for Christianity were supported by evidence, that
would not be a sufficient set-off against the evidence of our time
as to the inadequacy of Christianity to suit mundane requirements.

     Before the claims of Christianity can be evidential
established, it must be proved that Christianity has self-evident
truths and trustworthy testimony, and that its teachings harmonize
with cultivated reason. In its history no self-interest or party
zeal must be imported; candor and sincerity should be manifest, and
bias and prejudice excluded. In its pages the difference between
what was known to be true, and what was but the mere belief of the
time, must be made clear. Such so-called historical evidence as
consists of the imaginations of poets, the theories of dreamers, or
accounts of pretended supernatural events, is to our mind utterly
worthless for the purpose of establishing the truth and value of
any moral system. Taking the New Testament as the only source of 


                         Bank of Wisdom
                  Box 926, Louisville, KY 40201
                               6

               THE CLAIMS OF CHRISTIANITY EXAMINED

evidence as to Christ and his religion, the student is advised to
ascertain, if possible, for himself whether or not it is of the
nature of genuine history. To us it resembles what Livy says of
Scipio Africanus, that the account of his life, trial, death,
funeral, and sepulture was so contradictory that he was unable to
determine what tradition or whose writings he ought to credit. The
whole question of Christian evidence resolves itself into this: Is
it probable enough to deserve implicit belief?

     Now, to sum up our estimate of Christian evidences. To us they
appear to be destitute of all the essentials of true evidence, and
to be entirely worthless in proving that Christianity is aught but
a natural growth. We consider that during its various stages of
development it has yielded to the force of its environments,
whereby many of its elements have been changed and modified to suit
the tastes and requirements of those who professed it at different
epochs of our history. We fail to discover a particle of legitimate
proof to justify the orthodox claim that Christianity had a
supernatural origin, that it has had an unbroken history, and that
to-day it stands pre-eminently above all other systems as a
practical monitor of human conduct.

                           SECTION II.

                        GOD AND RELIGION.

     PROFESSOR STEWART'S chapter, in his "Handbook of Christian
Evidences," on "God and Religion," is a fair sample of orthodox
exposition and defence. It is intended to justify the belief in a
God who is described as the "First Cause, a self-existent Being,
the Creator and Regulator of the Universe;" and also to establish
as a fact "the reality, power, and universality of religion." This,
however, it should be remembered, has nothing to do with the
question of Christian evidences, inasmuch as, if the main
contentions of this chapter were proved to be correct, it would not
necessarily prove the existence of the Christian Deity, or that
Christianity is "a universal phenomenon of human experience and
history." The fact seems to be overlooked that there are other gods
believed in besides the one depicted in the Bible, and that there
are several religions professed which have but little in common
with Christianity. The duty of an expounder of Christian evidences
appears to us to be to endeavor to show that the Theism of the
Scriptures is reasonable, and that the religion based upon its
teachings is true. Whatever is urged in reference to other
religions may, or may not, be accurate; but it is of no value as
Christian evidence.

     Let us illustrate our meaning upon these points. The God
believed in by Voltaire, Paine, Francis William Newman, and most of
the adherents of what is termed "Advanced Theism," is certainly not
the same Deity as is believed in by so-called Christians, and
therefore, if the existence of the God of the advanced Theists were
demonstrated, it would not follow that the reality of the Bible God
was established. The ablest of our modern Theists will not attempt
to defend the "Supreme Being" of either the Old or the New
Testament. The same argument applies to religion. It is not enough
for an expounder of Christian evidences to make the general 


                         Bank of Wisdom
                  Box 926, Louisville, KY 40201
                               7

               THE CLAIMS OF CHRISTIANITY EXAMINED

statement that religion is a fact, and to urge that a belief in
some form of it is universal. Even if this were true, that would
not prove the evidential claims made on behalf of the Christian
system, which must be judged by its own merits. It is admitted that
other religions, Buddhism for instance, is as sublime in its
teachings as Christianity, and that the followers of Buddha are
more numerous than the disciples of Christ. Up to the present time
Christianity is not known by two-thirds of the human race; and
among the one-third, where a knowledge of it obtains, the majority
of the people have no practical faith in its teachings. As a matter
of fact, religion per se may be true, while the Christian form of
it may be false. Orthodox believers seem to ignore this truth. We
need not dwell here upon the original meaning of the term
"religion," or upon the fact that with the Romans it did not
signify merely theological worship, but it meant justice to the
State and to the community. It is only necessary for our present
purpose to remind the reader that Christian evidences have failed
to show that the religion of the New Testament is unique, or that
it is superior to other religious systems. The theory that
Christianity has the advantage of the authority of revelation to
support it has no force whatever, for, as Max Maller, in his
"Science of Religion" (page 45), observes, "the claims to a
revealed authority are urged far more strongly and elaborately by
the believers in the Veda than by the apologetical theologians
among the Jews and Christians."

     Professor Stewart, like most Christian advocates, puts it that
the study of the Christian evidences must be preceded by "a
conviction of the existence of God and of the reality and power of
religion." Now, we submit that persons who are already convinced
need no evidence to convince then), and, therefore, to seek for
evidence to prove what is regarded as having been proved is, to say
the least, a work of supererogation. Much importance is attached by
Christian exponents to the alleged universal need that is said to
be felt for religion. But the truth of this allegation will depend
entirely upon the definition that is given of religion. If by the
term we mean love, truth, justice, and benevolence, the cultivation
of man's moral nature, and the exemplification in our daily actions
of fidelity to our professions, and due consideration for the
rights and comforts of others, then, doubtless, most civilized
person are religious. But if by religion we mean the teachings of
theology and its doctrines, then its universal need has not been
proved. Neither has it been shown that such religious ideas are
innate; they are acquired as the result of early training and of
general education. (See F.J. Gould's "Concise History of Religion,"
vol. 1., pages 10, 11, and 12.)

     Professor Stewart endorses, as indeed most Christians do,
among the definitions of religion, the following. "Religion
consists fundamentally in the practical recognition of a
constraining bond between the inward life of man and an unseen
person." "The perception of the infinite under such manifestations
as are able to influence the moral character of man." Now, to
assert that religion, as it is here defined, is universal is the
height of presumption. We know of no one who can recognize a "bond"
between himself and "an unseen person," or who has the faculties to
perceive "the infinite," who is able "to influence the moral 


                         Bank of Wisdom
                  Box 926, Louisville, KY 40201
                               8

               THE CLAIMS OF CHRISTIANITY EXAMINED

character of man." The question is not if such a "bond" and "the
infinite" exist, but can we know of them? If, as we allege, we
cannot, then they form no part of practical religion, which is,
when properly understood, the ruling principle of a man's life.
Now, we do know of many persons who acknowledge that they have no
belief whatever in theological religion, and these facts are
sufficient to destroy the contention of its universality. We repeat
that there is a marked difference between the universal belief in
some of the claimants that are found in all the different religions
of the world, and the universality of one particular form of
religion. The former may be true, while the latter we know to be
false, which proves that Christian evidences are of no value upon
this point. For facts to prove that the belief in any one
theological religion is not universal, the reader is referred to
Sir John Lubbock's "Origin of Civilization," Tuttle's "Career of
Religious Ideas," and to vol. i. of F.J. Gould's "Concise History
of Religion." In these works ample evidence is furnished upon the
authority of travellers and missionaries, whose names are there
given, that tribes and races of men have been found where there was
not the slightest belief in any form of religion. Sir John
Lubbock,. on page 467 of his work above mentioned, says: "It has
been asserted over and over again that there is no race of men so
degraded as to be entirely without a religion -- without some idea
of a Deity. So far from this being true, the very reverse is the
case. Many, we might almost say all, of the most savage races are,
according to the nearly universal testimony of travellers, in this
condition." Burton states that some of the tribes in the Lake
Districts of Central Africa "admit neither God, nor angel, nor
devil" (page 468). "In the Pellew Islands Wilson found no religious
building nor any sign of religion ... Some of the tribes (of
Brazilian Indians), according to Bates and Wallace, were entirely
without religion."

     Professor Stewart frankly admits that "it is not by argument
we obtain our conviction of the existence of God," but he adds:
"Formal arguments in support of this conclusion are not useless."
As this position is a very popular one among a certain section of
Christians, and, moreover, as it is regarded as a part of the
Christian evidences, it deserves a brief notice. In the first
place, it appears to us that, if argument will not secure
conviction, there is no utility in attempting to supply it; yet
"four forms" of an argument are given by Professor Stewart to prove
the existence of God. They areas follows: --

     1. The First Cause. The belief in this is considered to be
more reasonable than to believe either in an unending series of
natural causes, or that things came "into existence without a
cause." Here, it will be observed, creation is Assumed without a
particle of evidence being given in its favor; while no notice is
taken of the theory of the eternity of the universe. Now, if it is
unreasonable to believe that anything could come into existence
without a cause (which we think it is), what about the alleged
First Cause, which is held to be 'uncaused'? Is it not more
reasonable to believe in the eternity of that of which we know
something than in the uncaused existence of that of which we know
nothing?



                         Bank of Wisdom
                  Box 926, Louisville, KY 40201
                               9

               THE CLAIMS OF CHRISTIANITY EXAMINED

     2. It is stated that, as there are in the works of nature
marks of intelligence and purpose, the author of nature must be
intelligent. The weak and inconclusive feature in this argument
lies in the inference that intelligence in nature must have had an
intelligent author. This very point, upon which some evidence is
required, is simply assumed without even any attempt being made to
give reasons for the assumption. If the intelligence in nature
needed a higher intelligence to produce it, is it not fair to
suppose, upon the same principle, that this higher intelligence
would require for its production a still higher intelligence?
Further, if, in consequence of the existence of intelligence, it be
more rational to believe that the universe was caused than to
believe that it is self-existent, then must it not be equally
rational to consider that this still higher intelligence was
caused?

     3. The allegation here is that our minds are so constituted
that we are driven to the conclusion that God is a being that must
be. This is but an assertion, and, until some evidence is given in
its support, it proves nothing. The same may be said of space,
which we cannot conceive of either beginning or ending.

     4. We are here told that we have a feeling of responsibility
to a personal and moral Being, and, therefore, we are led to infer
his existence. To this we offer an unqualified denial; for no such
feeling of responsibility is found among savages or untaught
persons. To attempt to show that the presence of a moral sense in
cultivated man is a proof of the existence of a supernatural power
is really too illogical to require further comment than to say that
it is a pure assumption, and cannot possibly afford any evidence of
a logical conclusion.

     The case of Religion and God stands thus: The former, to be
acceptable to the refined intelligence of the present age, should
be free from all theological mysticism and doctrinal absurdity; and
the latter can only be a question of subjective faith, not capable
of argumentative demonstration. Christianity has not the required
freedom, and, therefore, it is desirable that it should yield to a
better faith -- one that is more in harmony with the genius and
mental culture of the nineteenth century. As to the God of the
Christians, with his Biblical record of folly, cruelty, and
injustice, we allege that such a being is not suited as an subject
of worship; while in the earthquakes, cyclones, and volcanic
eruptions that are constantly destroying the lives of thousands of
innocent men, women, and children we fail to see any proof of love
and kindness on the part of what is termed the God of Nature. In
our opinion, no moral argument can be based upon Theism in the
presence of the fact that these calamities and disorders obtain in
the world. So long as the lion and the tiger roam the forest
pursuing their work of devastation and devouring their prey; so
long as vice flourishes, and virtue pines in want and misery; so
long as "fraud glitters in the palace, and honesty droops in the
hovel," so long shall we be ready to exclaim with the Rev. George
Gilfillan, who, in his "Grand Discovery of the Fatherhood," in
noticing the horrors and the evils that exist around us, asks: "Is
this the spot chosen by the Father for the education of his
children, or is it a den of banishment or torture for his foes? Is 


                         Bank of Wisdom
                  Box 926, Louisville, KY 40201
                               10

               THE CLAIMS OF CHRISTIANITY EXAMINED

it a nursery, or is it a hell? There is no discovery of the Father
in man, in his science, philosophy, history, art, or in any of his
relations." Well may Dr. Vaughan, in his work, "The Age and
Christianity," write: "No attempt of any philosopher to harmonize
our ideal notions as to the sort of world which it became a Being
of infinite person to create, with the world existing around us,
can ever be Pronounced successful. The facts of the moral and
physical world seem to justify inferences of an opposite
description from benevolent.'

                          SECTION III.

                    THEISM AND OTHER "ISMS."

     IN this section of his "Christian Evidences" Professor Stewart
rejects Materialism, Pantheism, and Agnosticism, because they do,
not furnish a satisfactory "explanation of the universe." The usual
Christian allegation is here made that, if we do not accept the
theory offered by Theism (it should be said by Christian Theism),
we are logically bound to submit another to take its place. But to
this we emphatically demur, for it does not follow, because the
above "isms" fail to give an adequate explanation of the universe,
that Christianity supplies the omission; that is what should be
proved, but it is not. The assertion that God created matter and
life is no explanation of the one or the other. In the light of
modern science, it is evident to us that the Bible account of the
supposed origin of the universe and the creation of man -- which
contains the Christian theory -- is utterly erroneous, and no
evidence is produced to establish its validity.

     It is not enough, therefore, for expounders of the Christian
evidences to show that Agnosticism or Materialism has no theory to
explain the why and wherefore of existence; they must, in order to
make good their claim, prove that their hypothesis is a reasonable
one. For instance, it must be demonstrated, as stated in the Old
Testament, that the universe and Adam and Eve were created in six
days, about six thousand years ago; that man was made from the dust
of the earth, and that woman was made from one of his ribs; that
the human race has degenerated from an original state of
perfection; that death was the result of sin upon the part of Adam;
and that, in the time of Noah, a universal flood "prevailed upon
the earth a hundred and fifty days," covering "all the high hills
and the mountains," destroying "every living substance" that was
then in existence, except Noah "and they that were with him in the
ark." Further, before the Christian theory can be accepted as being
true, evidence should be forthcoming that man by nature is
necessarily corrupt, and that in him "dwelleth no good thing" (see
Romans iii. 23, vii. 18; 2 Cor. iii. 5; Phil. ii. 13, iii. 21;
Psalm li. 5.); that the majority of those who are now living are
doomed to suffer after death the tortures of a burning hell (see
Matt. vii. 13 and 14, xxii. 14; 2 Thess. i. 7, 8, 9); that it is
possible for all mankind to believe one thing -- namely, salvation
through Christ (see Acts iv. 10, 11, 12; Mark xvi. 16); and that
the New Testament is accurate in describing persons who were
suffering from physical disease as being possessed with devils.
Now, the reader is requested to particularly note that, from a
Christian point of view, the question is not, are there any other 


                         Bank of Wisdom
                  Box 926, Louisville, KY 40201
                               11

               THE CLAIMS OF CHRISTIANITY EXAMINED

theories of the universe apart from the one given by Christianity
that will satisfy the critical test? As Christians claim that their
theory is correct, it should be made to harmonize with the facts of
science, philosophy, and experience. Up to the present, so far as
we are aware, no such harmony has been established.

     The very fact that the theory of evolution has been accepted
even by many Theists, as a partial explanation of phenomena, is
evidence that the Christian theory is not considered satisfactory.
Granted that evolution does not come within the domain of
demonstrated science, it does, however, agree with the science of
probability, and Bishop Butler has said, "Probability is the guide
of life." It should not be here overlooked that probability cannot
apply to that of which nothing is known, hence it can have no
reference to the alleged origin of the universe, or to its
supernatural government, for these are questions of speculation,
not of knowledge. The very thought of a beginning of the universe
is unthinkable, as Dean Mansel observes: "Creation is, to the human
mind, inconceivable." As to the term "supernatural," it meads, in
popular language, something higher than nature. But, if there is a
sphere higher than nature, and yet often breaking through nature,
nature itself must be limited by something, and the question
arises, By what is such limitation fixed, and what is the boundary
line which marks it off and separates it from the supernatural?
Further, supposing such a line to be well known, so that no
difficulty could arise in pointing it out, a still more difficult
problem presents itself for solution -- namely, how man, who is a
part of nature, and able only to come into contact with nature, can
push his knowledge into that other sphere which, being non-natural,
cannot be at all accessible to a natural being? If the supernatural
region be synonymous with the unknowable, it cannot clearly concern
us, simply because we have no faculties with which to cognise it,
and no powers capable of penetrating into its profound depths.

     In examining the claims of Christianity, we must enforce our
contention that we have nothing to do with any other system but
that of Christianity, for the reason that, if there were twenty
other theories, and all were proved to be false, that would not
make the Christian theory true. Materialism and Agnosticism have no
theories as to the origin and government of the universe by an
external power; and while in our present inquiry we are not
concerned to defend either of these "isms," we desire to correct an
error into which Professor Stewart has fallen. In reference to
Agnosticism, he observes: "The truth in Agnosticism is that man's
knowledge of God ... is, though real, imperfect and inadequate."
This is an inaccurate statement of the Agnostic position, which
recognizes no knowledge, either adequate or inadequate, of the
existence of God. Agnosticism declares that the subject is outside
our gnosis, and, while refusing to dogmatically deny Deity's
existence, it alleges that we can know nothing of him, since such
a being as the one described by Theists transcends all our powers
and faculties. The Agnostic is always willing to carry on his
investigations into nature to the utmost extent of his ability. He
seeks to wring from her the secrets hidden through all the ages of
the past; he pushes his inquiries from point to point, and learns
all that can be known of the marvelous processes of life and mind;
but the incomprehensible he seeks not to comprehend, and the 


                         Bank of Wisdom
                  Box 926, Louisville, KY 40201
                               12

               THE CLAIMS OF CHRISTIANITY EXAMINED

unknowable he does not make the idle attempt to know. This course
he deems more courageous, more dignified, and more candid than that
adopted by the dogmatic theologian, who, yearning for a knowledge
of the absolute, and yet failing to discover it, lacks the courage
to avow his inability to achieve the impossible.

                           SECTION IV.

                   THE QUESTION OF REVELATION.

     THE positions taken by orthodox Christians upon the question
of Revelation are: (1) That the Old and New Testaments contain a
special revelation from God; that there are some parts of the Bible
which are not divinely inspired, but are simply the recorded
opinions of the writers, and that the New Testament is of more
importance to Christians than the Old, because the latter was
intended for the Jews. Some Christians, however, urge that, in
order that the Jews may participate in the salvation offered
through Christ, it is necessary that they should accept the New
Testament as well as the Old. (2) That Biblical revelation was
necessary, inasmuch as nature is not only insufficient as a guide
to mankind, but that on many "an occasion of our sorest need" it
"is blind and deaf to our beseeching." Such is the statement of
Professor Stewart, who adds: "We find it impossible to believe that
a Supreme Being who is good would leave man without needed
guidance, and that One who is wise and powerful could not discover
a method of affording such guidance." (3) That the doctrine which
denies that God "has revealed himself, except through nature and
conscience, finds itself involved in difficulties when confronted
with the problem of physical and moral evil." These are the three
principal features which differentiate Christianity from natural
religion.

     As to the first position. If the whole of the Bible is not a
revelation from God, how are we to decide what portions are
inspired and what are not? If each person is to decide the question
for himself, then, as the Rev. Dr. Caird has shown, other Bibles
that inculcate teachings which are very different from those taught
by Christianity may be considered as "divine revelations." Besides,
this " explanation makes the man decide what is "divine," which is
fatal to the claims of Christianity. Moreover, against the validity
of this Christian position the following objections appear to us to
deserve attention: Could revelations which are contradictory in
themselves emanate from a mind that is infinite and unchanging? If
the later revelation contains something which is superior to
anything found in the earlier, is it not a reflection upon an all-
wise and all-good God that he should have so long deprived his
children of the superior communication? Supposing that God sent the
Old Testament to the Jews, it is reasonable to presume that he knew
what would be sufficient for them. Is it not, therefore, orthodox
impertinence to endeavor to force upon them the New Testament?

     Another point that should be remembered is that, if this
alleged new revelation were a direct communication from God, it
could only have been so to the person or persons to whom it was
made. A revelation to Paul would not be a revelation to us, and
therefore it could be of no evidential value to the present 


                         Bank of Wisdom
                  Box 926, Louisville, KY 40201
                               13

               THE CLAIMS OF CHRISTIANITY EXAMINED

generation. There is also to be considered the doubtful channel
through which the New Testament has come down to us; the many
abridgments and interpolations to which the documents have been
subjected must necessarily have prevented it from being evidence in
support of the Christian claims. Again, it does not appear that the
writers of the New Testament professed that what they recorded was
a revelation from God; they only claimed it to be a narration of
what they saw, heard, and gathered from the traditions of earlier
periods. This seems to be the Rationalistic view that should be
taken of the entire Bible, inasmuch as the numerous errors and
contradictions which it contains make the fact self-evident that
the book, as we have it to-day, could not possibly have been a
revelation from a perfect Being.

     The second position taken by Christians as to revelation is
based upon the double fallacy of supposing that the New Testament
gives us a better guide for human conduct than we find in nature;
and that the God of Revelation is not "blind and deaf to our
beseeching." Here, as in previous sections, we find orthodox
assumptions taking the place of legitimate evidence. Can there be
any doubt that the two important guides, cultivated reason and
scientific facts, are to be attributed to nature? Where are these
guides to be found in the Christian Revelation? In it faith is
regarded as being higher than reason, and reliance upon prayer as
of more value than dependence upon science. It should be borne in
mind that at one period of our history an attempt was made to
accept this revelation as a guide of life, but it was found
thoroughly inadequate as a monitor in human actions. The very
effort to make it so completely paralysed the progress of science,
the advancement of education, and the ethical growth of the age.
Even now, when the "Peculiar People" follow the teachings of this
revelation as a guide, the results are unfortunate, for the
consistent believers are punished for adhering to the assumed
revealed instructions. It is only where reason and science, aided
by human experience, guide the actions of mundane life that we find
advancement going on to a higher and nobler civilization.

     Those who profess to believe that the God of Revelation is not
"blind and deaf to our beseeching" should produce some evidence
that their belief has a sound basis. It is of no value as evidence
to remind us that Revelation promises that prayers shall be
answered, unless it can be shown that the promises were fulfilled.
And this, we submit, has not hitherto been done, Have we not on
record too many instances where loving parents have spent hours in
"beseeching" that the lives of their children should be spared; of
earnest prayers being offered up that pain and agony should cease
that poverty and despotism should no longer mar the happiness of
the race? Were not special supplications sent to the God of
Revelation to avert the deaths of Prince Albert, the Duke of
Clarence, the late Emperor of Russia, Abraham Lincoln, and
Garfield? In these cases not only personal, but national
"beseechings" were made to the God of Revelation that the lives of
these men should be saved but he was "blind and deaf" to all
"beseechings." It is no answer to say that in these instances it
was not God's will that the prayers should be answered, for, if
that were so, it shows the folly of "beseeching" him to do
anything. The Bible tells us that God " knoweth the secrets of the 


                         Bank of Wisdom
                  Box 926, Louisville, KY 40201
                               14

               THE CLAIMS OF CHRISTIANITY EXAMINED

heart " (Psalm xliv. 21); that he "doeth according to his will, and
none shall stay his hand" (Daniel iv. 35); and that he never
changes " (Mal. iii. 6). If these "revealed" words are to be relied
upon, where is the utility of "beseeching him to help us at all? He
knows when help is required, and, if he intends to render it, he
will do so; but, if he does not, no "beseeching" will be of any
avail, for he "never changes."

     The third position involves the problem of the existence of
physical and moral evil in the world. Professor Stewart, in his
"Christian Evidences," admits that there are difficulties connected
with this question, and he contends that the Deists with their "God
of Nature" cannot remove the difficulties, but that the Christians
with their God of Revelation can. Referring to John Stuart Mill's
essay, "On Nature," the Professor says: "It must be acknowledged
that, if natural laws be all, and natural ends the only ends to be
achieved, it is difficult to avoid the horns of Mill's dilemma, by
which we are called upon to reject either the power or the goodness
of God. And what is true of physical evil is still more apparent
when we turn to consider moral evil. Perfect as the system of the
world may have been when it left the hands of its Creator, who can
doubt, in the face of daily experience, that it has somehow gone
wrong? Christianity recognizes this." Here it may be asked: "If the
system of the world "were originally perfect, how could it have
"gone wrong"? And, if God were all-powerful, why did he allow it to
go wrong? The Christian's answer is, that God could not give man
liberty of choice, without his having the option of going wrong.
This is the proffered harmony between the existence of a God of
infinite power, wisdom, and goodness, and the existence of physical
and moral evil. We fail to see where the goodness of God is
manifest here, for, from a human standpoint, we consider that, if
a being had the power to keep the world right, it should have been
impossible for it to have "gone wrong." It is admitted that there
is physical evil in nature, and moral evil in man; therefore they
must both possess a power independent of, and opposed to, infinite
power. Is not this both absurd and contradictory?

     The defenders of the claims of Christianity seem to ignore the
following logical conclusions from their preipises: If the
Christian Deity be the creator of all things, then he must
necessarily be the "God of Nature," and, in consequence, he is
responsible for the pain and misery produced by such calamities as
volcanoes, with their red-hot lava; the earthquakes and epidemics
that destroy millions of human beings; the explosions in the mines
which cause the agonizing deaths of husbands, fathers, and sons,
upon whom whole families are dependent for the means of existence;
the railway accidents and the storms at sea. Now, these calamities
occur either with or without God's interference. If with his
interference, he is not all-good; if without, he is not kind and
benevolent; and if they happen in spite of him, he is not all-
powerful. Hence we agree with J.S. Mill when he says: "For, however
offensive the proposition may appear to many religious persons,
they should be willing to look in the face the undeniable fact that
the order of nature, in so far as unmodified by man, is such as no
being, whose attributes are justice and benevolence, would have 




                         Bank of Wisdom
                  Box 926, Louisville, KY 40201
                               15

               THE CLAIMS OF CHRISTIANITY EXAMINED

made with the intention that his rational creatures should follow
it as an example" (essay, "On Nature," p. 25). A new version of the
Doxology would not be here out of place, and it should read
something like this

          Praise God from whom all cyclones blow,
          Praise Him when rivers overflow,
          Praise Him who whirls the churches down,
          And sinks the boats, their crews to drown."

     Briefly, the Rationalistic objections to the orthodox claims
of a book-revelation from God are as follows: That in the New
Testament nothing of any value is revealed that was unknown to the
world before. That the God of Revelation, being the creator of all
things, is responsible for the physical and moral evils in the
world. That the same being who arranged for the redemption of man
planned his fall, and surrounded that event with conditions that
rendered moral freedom of no avail. That, if Adam and Eve before
the Fall did not know good from evil, the power of choice to them
was useless. That to postulate one infinite will as an absolute
ruler of the universe, and then to add millions of finite wills,
which are capable of thwarting the Infinite one, is, to say the
least, absurd. That no evidence has been produced which shows that
the God of Revelation listens to human "beseechings," and supplies
the wants of mankind more than does the "God of Nature." Finally,
that cruel and unjust as nature is (which it ought not to be if it
is the production of a good God), in it are contained the remedies
for all the evils that can be removed. When this nature is modified
and improved by man, it is found to be the only source from which
the means are obtained that enable us to augment human happiness,
and to promote the physical, intellectual, and ethical advancement
of the human race.

                           SECTION V.

                            MIRACLES.

     THE question to be kept in view in this section is Supposing
miracles were ever wrought, would that be evidence that
Christianity is a divine system? To prove that miracles have
happened does not necessarily substantiate the claims of
Christianity, because other religious systems also profess to be
based upon the miraculous. Even the Bible admits that miracles
occurred without divine aid. For proof of this the reader is
referred to Deut. xiii, 1-3; Matt. xxiv. 24; Acts viii. 9, 10. Here
it is clearly stated that miracles were actually performed by
agencies the very opposite to those claimed by Christianity

     Professor Stewart says the miraculous is "evidence of the real
and reliable character of the revelation, and of the divine source
of the power, manifested in Christianity." But this is a fallacy
upon the very face of it. What have miracles to do with the
"reliable character of the revelation" upon the practical duties of
life? If Christ did raise the dead, and perform other wonders, it
would not make him accurate when he taught that this world should
be considered as being only of secondary importance; that utter
indifference should be manifested as to the future of mundane life;


                         Bank of Wisdom
                  Box 926, Louisville, KY 40201
                               16

               THE CLAIMS OF CHRISTIANITY EXAMINED

that a state of poverty is desirable that prayer is a reliable
source of material help; that salvation cannot be obtained except
through him; that the possession of devils was the cause of
physical and mental disease; or that the world was to have come to
an end during the lifetime of those to whom he was speaking.
Because the "revelation" very properly advises children to honor
their parents, it does not, therefore, follow that it is "reliable"
when it says that Christ was born without a human father, or that
he could have been in two places at the same time. Neither does it
corroborate the statement that Christ the Son, who was "born of a
virgin," was as old as God the Father, and that the Devil has been
more potent than either of them. To make good the claims of
Christianity here put forth, their reliability must be established
apart altogether from an appeal to miracles.

     The Christian claim, that the miracles which Christ is said to
have performed prove that he was more than man, is equally
fallacious. As already stated, wonders as great as those ascribed
to Christ have been accomplished by persons who are admitted to
have been but human. Besides, some of the miracles credited to
Christ do not harmonize with that wisdom, utility, and justice
which are said to be characteristic of divinity. As evidence of
this, the reader is requested to peruse the account of his cursing
the fig-tree (Matt. xxi.); of his reckless destruction of another
person's property by casting a herd of swine into the sea, so that
they "perished in the waters" (Matt. viii. 32) "and of his turning
water into wine (John ii.).

     Dr. Middleton, in his Free Inquiry," speaking of miraculous
events, writes thus "If either part be infirm their credit must
sink in proportion; and, if the facts especially be incredible,
they must of course fall to the ground, because no force of
testimony can alter the nature of things." If the unbiased reader
will test the miracles of Christ by the rule that this eminent
Christian sets down, it will be seen how groundless the miraculous
claims of Christianity really are. For, beyond doubt, many of the
Christian "facts" are incredible and, therefore, as the Doctor
observes, "they must of course fall to the ground." Is it credible
that "Lazarus should come from his grave, bound hand and foot with
graveclothes," after he was dead, and decomposition had set in?
That certain saints who were dead and in their graves should rise
and go into the city, and be heard of no more? That Christ should
feed a hungry multitude of "about five thousand men, besides women
and children," with five loaves and two fishes, and, when all were
filled, that there should be twelve baskets full remaining? Such
tales would not be believed to-day in connection with human
affairs. Why, then, should they be thought reliable in support of
claims at which "reason stands aghast, and faith itself is half
confounded"?

     It is worthy of note, as showing the weakness of the claim
that Christ's miracles prove his divinity, that where he performed
some of his principal works many of the people were not convinced
of the genuineness of his professions. Faith was a necessary
requisite for the belief in miracles. Where skepticism existed,
Christ's occupation as a thaumaturgus was gone. Matthew informs us
(xiii. 58) that Christ "did not many mighty works there, because of


                         Bank of Wisdom
                  Box 926, Louisville, KY 40201
                               17

               THE CLAIMS OF CHRISTIANITY EXAMINED

their unbelief." But, had the object of miracles been to prove the
divine mission of Christ, it was in the midst of unbelief that they
should have been wrought. Jesus seems to have succeeded tolerably
well with his wonders among the ignorant, the insane, and the deaf
and dumb people. When, however, he came in contact with thoughtful
unbelievers, his prestige was gone. Hence, we read in Matthew (xi.
20): "Then began he to upbraid the cities wherein most of his
mighty works were done, because they repented not;" and in John
(xii. 37): "But though he had done so many miracles before  them.
yet they believed not on him." Here is a clear admission that, in
Christ's time, his best miracles were disbelieved and rejected. Is
it expected that in the nineteenth century we are more credulous
than were our predecessors eighteen hundred years ago?

     The question of the reality, or otherwise, of miracles is not
here involved. Still, it may be urged, as against the Christian
claims, that, if the stories of the miracles of the New Testament
were true, the attributes of an omnipotent, good, all-wise, and
impartial God would be destroyed. Further, the perfection of his
government would be rendered impossible. A miracle, as understood
by the Church, implies a special act upon the part of God, and his
interference with natural sequences. Now, all acts of God --
supposing him to be the being Christians regard him -- must be good
acts. If, therefore, it were wise for God to perform certain acts
eighteen hundred years ago, it would have been equally wise for him
to have done so four thousand years previously. So long, therefore,
as he abstained from performing those acts, so long did he withhold
advantages from his children, and thereby deal unjustly towards
them. To urge that an act of God may be good and necessary at one
time, and not at another, is to reduce the government of God to a
level with that of man, and to admit that the "divine" economy is
neither uniform nor perfect. Again, granting the existence of God,
all sequences were arranged by that God. If arranged by him, they
were so arranged from eternity. Anything which acted contrary to
that arrangement was either the result of an after-plan on God's
part -- in which case he is not all-wise and immutable -- or the
arrangement took place in spite of God; and in that case he is not
all-powerful. We only know of existence as it is, and we judge of
its nature and power from experience and investigation. From these
sources of knowledge we learn that at certain degrees heat will
burn, water will drown, and poison, in given quantities, will
destroy life. To believe otherwise is for man to leave facts and
reason, and to revel in fancy and credulity. The forces in nature,
so far as we have discovered them, are regular in their order, and
"constancy of succession marks their operations." These are truths
that science has made known in modern times, and, if they were
always relied upon, no claim could consistently be made for the
reality of miracles.

     The Rationalistic view of the miraculous claims of
Christianity may be thus briefly slated: (1) That it is impossible
to prove from experience that Christ's miracles were ever
performed. (2) That the only approach to evidence of their reality
is testimony, which is far from being reliable. (3) That it is not
reasonable to suppose that God would work miracles, and at the same
time endow man with faculties which enabled him to reject them. (4)
That it is true some events have occurred that have not yet been 


                         Bank of Wisdom
                  Box 926, Louisville, KY 40201
                               18

               THE CLAIMS OF CHRISTIANITY EXAMINED

accounted for by natural law. If this were not the case, science
would now have no unsolved problems to deal with. But we know that
many events that were once thought to be unaccountable science has
now traced to natural law; thus "the supernatural of one age has
become the natural of another." (5) To the allegation that
religious interests require a departure from the ordinary laws of
nature, we reply that the difference between ordinary and
extraordinary laws has not been defined, and it cannot be defined
until the extraordinary law is understood; and, when it is
understood, actions in conformity thereto will not be considered
miraculous. (6) If it be true that God specially interferes in the
order of the universe, all certainty in human affairs is an
impossibility. (7) If a person to-day were to say that one who was
dead had been brought back to life, we should feel certain that
that person had been deceived. Our conclusion would be based upon
natural law, which there is no reason to suppose could ever have
been violated. (8) Even if we admit the existence of supernatural
power, before we can logically attribute any event to that power,
should we not be prepared to state where the natural ends, and
where the alleged supernatural begins? Should we not, also, have
some means of recognizing the manifestations of that power? Because
we are not able to explain the why and the where-fore of certain
effects, that does not justify us in saying they are supernaturally
produced. Until man knows all that nature can do, let him not
presume to assert what it cannot do.

                           SECTION VI.

            THE PERSONALITY AND CHARACTER OF CHRIST.

     PROFESSED Christians regard Christ as the foundation and
center of their faith. Whatever weaknesses may be thought to belong
to other alleged evidences of the truth of Christianity, it is said
that Jesus is the invulnerable rock, without flaw or imperfection.
This extravagant and unprovable claim is sought to be maintained by
Professor Stewart and other Christian defenders upon the following
grounds: -- (1) That the superior excellence of Christ's character
is acknowledged by opponents of Christianity. (2) That the outlines
of his life are historical, and that the portraiture given of him
in the Gospels harmonizes with the belief of the earliest
Christians. (3) That this portraiture, in the words of Professor
Stewart, "must be either an invention or an idealized picture, or
be drawn from actual knowledge of the person represented." It is
contended that it is impossible for it to have been either of the
first two, and, therefore, his character "is a strikingly original
one." (4) It is further alleged that, if the claims which Christ
puts forward in his own name are not justified, they evince a
fanatical self-delusion, and are fatal to his moral reputation.
purpose of such is the latest evidence given for the proving the
orthodox claims for Christ. That it is inadequate for the purpose
we hope to demonstrate; for, even if we admit that the facts are as
stated in the first three positions here set forth, it does not,
therefore, follow that the claims of Christianity are established.
The fact that certain Skeptics hold a high opinion of Jesus; that
the earliest Christians based their belief on the portraiture of
the Gospels, which are supposed to be, in their "main outlines,"
historically accurate; and that the character drawn of Christ is 


                         Bank of Wisdom
                  Box 926, Louisville, KY 40201
                               19

               THE CLAIMS OF CHRISTIANITY EXAMINED

original, can in no way prove the truth of all that is taught by
the Christian faith. For instance, it would be no proof that Christ
was equal with God; that he was in every particular perfect; that
his death atoned for the sins of the world and that his teachings
are of practical value in regulating the mundane affairs of to-day.
Before we can accept such positions as furnishing any evidence of
the truth of the claims of Christianity, it must be shown: (1) That
the opinions of the Skeptics were correct; (2) that the outlines of
Christ's life are consistent, and in accordance with natural law;
and (3) that the portraiture given of Jesus in the Four Gospels is
a correct one.

     In connection with this last point it should be remembered
that during the early centuries no one definite uniform opinion as
to the nature and character of Christ obtained among his followers.
E.P. Meredith observes that "at a most early period of the
Christian era there appear to have been great doubts as to the real
existence of Christ. The Manichees, as Augustine informs us, denied
that he was a man, while others maintained that he was a man, but
denied that be was a God (August. Sermon, xxxvii., c. 12). The
Fathers tell us that it was in the times of the apostles believed
that Christ was a phantom, and that no such person as Jesus Christ
had ever had any corporeal existence. There is, therefore,
considerable force in the expressions of a modern writer, that the
being of no other individual mentioned in history ever labored
under such a deficiency of evidence as to its reality, or ever was
overset by a thousandth part of the weight of positive proof that
it was a creation of imagination only, as that of Jesus Christ. His
existence as a man has, from the earliest day on which it can be
shown to have been asserted, been earnestly and strenuously denied;
and that not by the enemies of the Christian faith, but by the most
intelligent, most learned, and most sincere of the Christian name
who ever left to the world proofs of their intelligence and
learning in their writings, and of their sincerity in their
sufferings" ("The Prophet of Nazareth," pp. 287-8).

     Even at the present day contradictory ideas are entertained as
to the real personality or character of Christ. Trinitarians
believe him to be God, but the Unitarians regard him only as a man;
while the Swedenborgians think him a "divine humanity." The General
Baptists maintain that he died for all men, and the Particular
Baptists assert that he died only for an elect number. Many of
Christ's admirers look upon his character as being perfect; others
admit that, being human, his character must necessarily be
imperfect. Christian Socialists claim him as a great social and
political reformer; but their more religious opponents aver that he
was a spiritual revenerator, and that he spoke the truth when he
said, "My kingdom is not of this world." In the New Testament there
are clearly two portraiture given of Christ: the one, gentle and
loving; the other, harsh and unforgiving. From the one come the
sympathetic words: "Father, forgive them;" "Suffer little children
to come unto me;" and the command, "Love one another." From the
other proceed the gloomy and revengeful exclamations: "He that
denieth me before men shall be denied before the angels of God
Depart from me, ye cursed, into everlasting fire;"  "If any man
come to me and hate not his father, and mother, and wife, etc., he
cannot be my disciple." Now the question is, As these two 


                         Bank of Wisdom
                  Box 926, Louisville, KY 40201
                               20

               THE CLAIMS OF CHRISTIANITY EXAMINED

come to me and hate not his father, and mother, and wife, etc., he
cannot be my disciple." Now the question is, As these two 
portraiture are diametrically opposed to each other, and given by
the same authorities, which is the correct one?

     In reference to the fourth position put forth to prove the
claims of Christianity, it differs from the other three, inasmuch
as it is evidential; but the evidence is not for, but against,
orthodox claims. The argument urged therein is that, if Christ were
not what, according to the Gospels, he professed to be, he was a
victim to a fanatical self-delusion, which would indicate weakness
in his moral character. The question, then, is, Was Christ what he
claimed to be, and did he do what he promised to accomplish?
Moreover, were his actions governed by reasonable modesty, or were
they performed under the influence of uncontrolled enthusiasm? To
decide this question, the New Testament is our only standard of
appeal, and therein we find that the Gospels represent Christ as
claiming to be equal with God, and yet he was not impervious to
human weaknesses and imperfections. He suffered from hunger (Matt.
iv. 2); he gave way to anger (Mark iii. 5), and to petty passion
(Matt. xxi. 18, 19); he lacked power (John v. 19-30); and he was
limited in wisdom (Mark xiii. 32). Further, he acknowledged that he
could do nothing of himself (see John v. 19 and 30). He announced
that he "proceeded forth and came from God" (John viii. 42); but he
failed to justify this claim to his townsmen, for they said of him:
"Is not this the carpenter, the son of Mary, the brother of James,
and Joses, and Judah, and Simon? And are not his sisters here with
us?" " Is not this Jesus the son of Joseph, whose father and mother
we know? How is it, then, that he saith I came down from heaven?"
So unpopular, however, he became at Nazareth that "all they in the
synagogue rose up and thrust him out of the city, and led him unto
the brow of the hill whereon their city was built, that they might
cast him down headlong" (Mark vi. 3, John vi. 42, Luke iv. 28, 29).
Even his own relatives had no faith in his pretensions to
miraculous power; they accused him of secrecy, and told him to
"Depart hence, and go into Judaea, that thy disciples also may see
the works that thou doest; for there is no man that doeth anything
in secret, and he himself seeketh to be known. If thou do these
things, show thyself to the world. For neither did his brethren
believe in him" (John vii.1-5).

     In moments of enthusiasm Christ made promises which he never
fulfilled. In Matthew (xix.) we are told that he promised that
certain of his followers should "sit upon thrones judging the
twelve tribes of Israel"; but there is no record that such an event
ever took place. He also assured believers in him that they should
"cast out devils" "take up serpents, and, if they drink any deadly
thing, it shall not hurt them" (Mark xvi. 7, 18). Will his
followers test his promise in these matters? Moreover, he
emphatically said: "If two of you shall agree upon earth, as
touching anything that they shall ask, it shall be done for them of
my father which is in heaven" (Matthew xviii. 19). "Whatsoever ye
shall ask in my name, that will I do, that the Father may be
glorified in the Son. If ye shall ask anything in my name, I will
do it" (John xiv. 13, 14). Now, here Christ claims to be in a
position to guarantee that the prayers of his believers shall be
answered. But was he justified in so doing? Experience says, No; 


                         Bank of Wisdom
                  Box 926, Louisville, KY 40201
                               21

               THE CLAIMS OF CHRISTIANITY EXAMINED

for, in spite of prayers asking that skepticism should cease, it
has increased as time rolled on, until to-day it is more extensive
than it ever was. What has been more prayed for than the unity of
Christendom? Jesus himself prayed that his followers might be one
(John xvii. 21); yet, from his time, divisions among Christians
have gone on increasing, and each sect prays in vain for the
conversion of the others.

     That many of the acts ascribed to Christ were of a fanatical
kind is evident. For instance, his riding into Jerusalem upon an
ass and a colt (Matthew xxi.); his entering the Temple,
overthrowing the money-changers' tables, and whipping the merchants
from the building with "a scourge of small cords" (John ii. 5); his
cursing the fig-tree, because it did not bear fruit out of season;
his designating those who came before him as "thieves and robbers"
(John x. 8), and his vituperations against certain persons, calling
them "Ye serpents, ye generation of vipers, how can ye escape the
damnation of hell?" No wonder that his friends thought he was
"beside himself" (Mark iii. 21), and that the Jews considered "he
hath a devil, and is mad (John x. 26). The Rev. Charles Voysey says
Christ could not have been God, because he was not a perfect man.
He had faults which neither I nor my readers would venture to
imitate without loss of self-respect. His mind gave way, and he was
not responsible for what he said." Instead of regarding Jesus as an
impostor, the rev. gentleman said that "he was simply mistaken, and
finally insane" (Fortnightly Review, January, 1887). Perhaps this
will account for his delusions in reference to prayer, his belief
in people being possessed with devils, that believers could drink
poison and suffer no injurious results, and that the world was to
come to an end during the lifetime of the people of his day. Now,
if fanaticism and self-delusion are fatal to moral reputation, as
Professor Stewart says they are, then Christ's moral character must
be impaired, for the Gospels allege that he was a victim to both
these drawbacks.

     What, then, does the evidence at our command in reference to
the claims of and for Christ prove? Simply this: That for many
centuries contradictory and varying beliefs have obtained in
connection with a person called Jesus, who is supposed to have
lived nearly two thousand years ago; that he is regarded as having
been the founder of the Christian religion; that his birth was
miraculous, his life and teachings unique, his death unparalleled,
and that he rose from the dead and ascended to heaven. These are
the fundamental claims urged on behalf of orthodox Christianity;
and we submit that there is no historical evidence, sufficiently
trustworthy, to justify such claims. We look in vain among the
writings of Jewish and heathen historians, who lived in or near the
time when the events are said to have happened, for any testimony
of their occurrence. Besides, the incidents are so contrary to
human experience, and the New Testament, which records the events,
is so contradictory in narrating them, that, according to the
general law of evidence, the claims have no logical demand upon our
credence. The fact is that the reports found in the Gospels as to
when and where Christ was born, his genealogy, his sayings and
doings, and his death, resurrection, and ascension, are too
conflicting and inconsistent for their credibility to be relied
upon. Moreover, the theories based upon the supposition that the 


                         Bank of Wisdom
                  Box 926, Louisville, KY 40201
                               22

               THE CLAIMS OF CHRISTIANITY EXAMINED

narratives were accurate are so discordant, and have been so
varying in their development, that it is difficult to conceive they
were supported by fact. The Church, which accepted a theory in one
age, often rejected it in another; while views that were regarded
by some Christian exponents as being orthodox have been condemned
by others as heterodox. And to-day the very beliefs that were based
upon the records of the New Testament are either modified or
entirely discarded, not only by secular scholars, but by learned
divines. The new view entertained by "advanced Christians" is that
Christ is an "ideal;" but this position is not a sound one,
inasmuch as the question arises, An ideal of what? If the better
parts of an ideal are marred by that which is erroneous and
impracticable, the ideal is not a safe one for human guidance. That
this is so in reference to the Christ of the gospels is, to our
mind, beyond doubt. Surely, with these facts before us, it is
unreasonable to attempt to exact implicit belief in events
destitute of logical coherence and of historical corroboration.

     We believe that the more dignified and correct coarse to take,
from a Rationalist point of view, is to estimate the value of the
traditions that have grown up around the name of Christ, by the
peculiar features belonging to the ages of their growth, and by the
intellectual light of the nineteenth century. Modern thought must
not be fettered by ancient speculation. If it could be proved that
the history of Christ were historical, it would not make the
impracticable portion of his teachings useful to us and if it could
be shown that he was an impostor, it would not rob any truth he
taught of its real value. In this utilitarian age what is said
should be considered of greater importance than by whom it is said.
Personally, the origin of Christianity has but little interest for
us; we are the more concerned as to its truth and utility. Like all
religious systems, the one bearing the Christian name is a
combination of the true and the erroneous, the real and the
imaginary, and our duty is to discriminate between fact and
fiction, and to accept the one and to reject the other. Neither do
we consider that the admission that Jesus might have lived
necessitates our regarding him either as a supernatural being or as
an impostor. Supposing he lived, he might have been, as we think he
was, self-deceived, his better judgment being overwhelmed by his
fanatical nature. Christians, while admitting the existence of
Buddha and Mohammed, will not grant that they were divine
personages, or that their teachings were perfect; but the time is
past for those religious founders to be denounced as impostors. Why
should a different rule be applied to Christ? His teachings are not
superior to theirs, the progress of his faith has not been more
extensive than theirs, and certainly his followers have not been
more numerous than those of Buddha.

     What, then, is the Rationalist view of Christ? It is, briefly,
this: That, assuming the New Testament account of him to be
accurate, we must regard him as a man who possessed but limited
education, who was surrounded by unfavorable influences for
intellectual acquirements, who belonged to a race not very
remarkable for literary culture, who retained many of the failings
of his progenitors, and who had but little regard for the world or
the things of the world. Viewed under these circumstances, we can,
while excusing many of his errors, recognize and admire something 


                         Bank of Wisdom
                  Box 926, Louisville, KY 40201
                               23

               THE CLAIMS OF CHRISTIANITY EXAMINED

that is praiseworthy in his character. But, when he is raised upon
a pinnacle of greatness as an exemplar of virtue and wisdom, and as
surpassing the production of any age or country, he is then exalted
to a position which he does not merit, and which deprives him of
that credit which otherwise he would perhaps be entitled to. He
revealed nothing of practical value, and he taught no virtues that
were before unknown. No doubt in his life there were many
commendable features; but he was far from being perfect. While he
might have been well-meaning, he was in belief superstitious, in
conduct inconsistent, in opinions contradictory, in teaching
arbitrary, in faith vacillating, and in pretensions great. He
taught false notions of existence; he had no knowledge of science;
he misled his followers by claiming to be what he was not, and he
deceived himself by his own credulity. He lacked experimental
force, frequently living a life of isolation, and taking but slight
interest in the affairs of this world. It is this lack of
experimental force throughout the career of Christ that renders his
notions of domestic duties so thoroughly imperfect. As a son, he
lacked affection and consideration for the feelings of his parents;
as a teacher, he was mystical and rude; and, as a reasoner, he was
defective and illogical. Lacking a true method of reasoning,
possessing no uniformity of character, he exhibited a strange
example -- an example injudicious to exalt and dangerous to
emulate. At times he was severe when he should have been gentle.
When he might have reasoned he frequently rebuked. When he ought to
have been firm and resolute he was vacillating. When he should have
been happy he was sorrowful and desponding. After preaching faith
as the one thing needful, he himself lacked it when he required it
the most. Thus, on the cross, when a knowledge of a life of
integrity, a sensibility of the fulfillment of a good mission, a
conviction that he was dying for a noble and righteous cause, and
fulfilling the object of his life -- when all these should have
given him moral strength we find him giving vent to utter despair.
So overwhelmed was he with grief and anxiety of mind that, we are
told, he "began to be sorrowful and very heavy." "My soul," he
exclaimed, "is sorrowful even unto death." At last, overcome with
grief, he implores his father to rescue him from the death which
was then awaiting him.  [For further evidence that the orthodox
view of Christ is erroneous, and that he was no general reformer,
the reader is referred to the present writer's pamphlet, "Was
Christ a Political and Social Reformer?" where this phase of his
character is fully dealt with.]

                          SECTION VII.

                   THE RESURRECTION OF CHRIST.

     THE alleged resurrection of Christ is an important feature in
his history. In fact, the orthodox defenders of Christianity stake
the truth of their entire faith upon the reality of this one event,
which is an exceedingly illogical thing to do. For, supposing
Christ did rise from the dead, that would be no evidence that the
whole system of orthodoxy is true and reasonable. Of course the
fallacy in this instance originated with St. Paul, who is reported
to have said: "And if Christ be not risen, then is our preaching
vain, and your faith is also vain" (i Cor. xv. 14). "What
advantageth it me if the dead rise not? Let us eat and drink, for 


                         Bank of Wisdom
                  Box 926, Louisville, KY 40201
                               24

               THE CLAIMS OF CHRISTIANITY EXAMINED

to-morrow we die." This is really the most irrational and selfish
test that was ever submitted to prove the validity of any claim. It
makes the usefulness of Christianity to depend not upon its ethical
value, but upon a theological dogma. The utter selfishness of the
test is apparent, for it puts personal gain before all
considerations of general good. If all belief in the resurrection
were ignored, should we then have no duties to perform, and no
consolation to support us in the battle of life? Would all love for
mankind and interest in their welfare cease? Should we have no
hearts to gladden, no homes to make happy, and no characters to
improve and elevate? The faith that makes the sunshine of
existence, the recognition of duty, and the cultivation of virtue
to depend upon the belief in a "risen Christ" is low and grovelling
in the extreme, and it is thoroughly opposed to the Rationalist
view of the nature and capabilities of the manifold energies of the
human race. Fortunately, such a sordid and degrading view of life
is as false as it is despairing; for, long before the story of the
resurrection was heard of, the noblest virtues were fostered and
the highest possible happiness was realized; and even to-day it is
the same among millions of the human family where the belief does
not obtain.

     Although, from a Rationalist standpoint, the reality or
otherwise of the resurrection of Christ should have no influence
upon personal conduct, it may be interesting to inquire upon what
grounds the belief in it rests. The account of such a marvelous
event as the restoration from death to life of one upon whom the
salvation of the world was supposed to depend should be supported
by the clearest of evidence. But no such evidence exists, which is
very remarkable, if the event were to be considered the strongest
proof of the truth of Christianity. We have not the testimony of
any eye-witnesses of the resurrection. Early historians are silent
in reference to it, and the accounts in the Gospels are
inconsistent and contradictory. Even the extraordinary phenomena
which are said to have happened at the death of Christ (Matt.
xxvii.) are not mentioned by Seneca and Pliny, although each of
them, as Gibbon informs us, "in a laborious work, has recorded all
the great phenomena of nature -- earthquakes, meteors, comets, and
eclipses -- which his indefatigable curiosity could collect."

     Having, then, no historical evidence of the resurrection, let
us see if there is any value in what the New Testament says upon
the subject. We have not space to present the many contradictions
contained in the Gospels as to the incidents which are reported to
have occurred at the resurrection; but, if the reader will examine
these carefully, it will be found that the four writers differ
materially upon the following points: The number of women who went
to the sepulchre; the number of "angels" or "men" the women found
there; the words spoken by the "angels" or "men;" the giving of the
information of what they had seen; to whom Jesus appeared after his
resurrection; and, finally, where the appearance of Christ after
the resurrection took place. Such conflicting statements as are
recorded in the four Gospels would not be received as evidence,
even upon ordinary matters, in any of our law courts to-day. Some
of these allegations must be false, and it is not impossible that
none of them are true. Not being able to decide which is correct,
we discard them all as being of no evidential value.


                         Bank of Wisdom
                  Box 926, Louisville, KY 40201
                               25

               THE CLAIMS OF CHRISTIANITY EXAMINED

     In Matthew (xx. 18, 19) it is recorded that Jesus said
"Behold, we go up to Jerusalem; and the Son of man shall be
betrayed unto the chief priests and unto the scribes, and they
shall condemn him to death; and shall deliver him to the Gentiles
to mock and to scourge him, and to crucify him, and the third day
he shall rise again." Now, if these words were spoken, we may
fairly suppose that such definite language would have made a deep
impression upon his friends and disciples. But it does not appear
to have done anything of the kind, for, as Greg observes: "We have
ample proof that no such impression was made, that the disciples
had no conception of their Lord's approaching death -- still less
of his resurrection -- and that, so far from their expecting either
of these events, both, when they occurred, took them entirely by
surprise they were utterly confounded by the one, and could not
believe the other. We find them shortly after -- nay, in one
instance, instantly after -- these predictions were uttered
disputing which among them should be greatest in their coming
dominion (Matthew xx. 24-27; Mark ix. 34-5 ; Luke xxii. 25, 30),
glorying in the idea of thrones, and asking for seats on his right
hand and on his left in his Messianic kingdom (Matthew xix. 27, 28;
xx. 21; Mark x. 37; Luke xxii. 30), which, when he approached
Jerusalem, they thought "would immediately appear" (Luke xix. II.
xxiv. 21). The four following incidents mentioned in the Gospels
strongly corroborate the theory that Christ's words, that he would
"rise again," had no effect upon some of his friends: (1) When the
two women visited the sepulchre they took sweet spices to anoint
the body (Mark xvi.), which they would not have done if they
expected that he would rise from the grave; (2) when Mary Magdalene
discovered that the body was gone she thought the gardener had
removed it (John xx. 15), which is quite inconsistent with the
belief that the resurrection had taken place; (3) when the women
reported his resurrection to the disciples "their words seemed to
them as idle tales, and they believed them not" (Luke xxiv. II),
although it is distinctly said that Jesus told them the event would
happen; (4) when he was supposed to have appeared, after his
resurrection, to the eleven disciples at Galilee "some doubted"
(Matt. xxviii. 17), while others thought that "they had seen a
spirit" (Luke xxiv. 37). So skeptical were certain of the disciples
about the "risen Christ" that it is reported that he "upbraided
them with their unbelief" (Mark xvi. 14).

     With these Gospel admissions that the story of the
resurrection was not accepted as true by many of those who lived at
the time it is said to have occurred, of what value is the
assertion that the event gained universal assent? Why, not only did
some of the Christians disbelieve the story after all possible
evidence had been produced (i Cor. xv. 12), but the great body of
the Jews and the Romans had no faith in its truth. The fact that
the Jewish Sanhedrim, composed of educated Jews, and the six Roman
governors, mentioned in the New Testament, who had every
opportunity of judging of the genuineness or otherwise of the
story, refused to believe in it, is evidence of its doubtful
character. Besides, according to Mosheim, many of the early
Christians thought that Christ was not crucified, but that it was
Judas; and it was not until the second century, says Charles B.
Waite, M.A., in his "History of the Christian Religion," that "the
doctrine of the resurrection of Christ, in a material body, 


                         Bank of Wisdom
                  Box 926, Louisville, KY 40201
                               26

               THE CLAIMS OF CHRISTIANITY EXAMINED

appeared." It is evident that the writer of Matthew's Gospel did
not pretend to record contemporary events, for he writes: "This
saying is commonly reported among the Jews until this day
(xxviii. 15).

     The case stands thus: The resurrection itself would have been
an extraordinary event, one contrary to known natural law, and
opposed to all human experience. In its favor we have no testimony
either of eye-witnesses or of historians who lived at or near the
time Christ is alleged to have risen. The accounts given by the
writers of the Gospels upon the subject are too contradictory to be
received as evidence; many of the people who, it is said, had been
informed that Christ would rise had no idea that he had risen,
while the most learned men of the period entirely disbelieved the
story. These facts afford abundant evidence that the resurrection
is not a demonstrated truth.

     Now, let us briefly consider the reasons given by Christian
exponents in favor of the belief in this -- to say the least --
improbable and uncorroborated story, which, be it remembered,
originated in an ignorant, uncritical, and superstitious age. In
the first place, it is contended that, unless we accept the
Christian account of the origin and perpetuation of the belief in
the resurrection of Christ, we are bound to furnish a better one.
Logically, we are not compelled to do anything of the kind; all
that really devolves upon us who cannot accept the story is to
examine the case for the affirmation, and to show that the reasons
given are insufficient to establish the truth of what is affirmed.
Christians deny many of the pretensions of Buddha and Mohammed, and
they disbelieve the stories of the resurrection of Christ and of
Adonis, of Osiris, and of many other ancient "saviours," in whom
thousands of sincere devotees have believed. But these very
Christians do not deem it their duty to explain how the faith in
the miraculous birth, death, and resurrection of these religious
heroes originated, and how it was perpetuated. Why, then, are we
expected to account for the belief in such an unlikely event as the
resurrection of Christ? Superstitions of various kinds, such as the
belief in the miracles of the Catholic Church, in the pretensions
of Joseph Smith, and in the story of the approaching end of the
world, have always been found allied with ignorance and duplicity.
These factors, no doubt, played an important part in the
origination of the belief that Christ rose from the dead.

     While it is not necessary to the position we take that we
should furnish a better reason for the existence of the belief in
the resurrection than the one supplied by Christianity, the
following probable causes may be assigned: (1) The expectation,
based upon Christ's own prediction, that he would rise again. It is
true his words failed to impress some, but others of more weak and
credulous natures were affected by what he was supposed to have
said. (2) The revolt of the Jews against the Roman power which
preceded the destruction of Jerusalem. This, no doubt, induced many
of Christ's disciples to think that the end of the world was at
hand in accordance with his predictions (Matt. xxiv.; Mark xiii.;
Luke xxi.), and that he was coming to establish his kingdom, in
which they were to be governors (Matt. xix. 28). That they were
deceived would not alter the fact that these events tended to 


                         Bank of Wisdom
                  Box 926, Louisville, KY 40201
                               27

               THE CLAIMS OF CHRISTIANITY EXAMINED

justify, to their minds, the delusion in which they believed. (3)
The disciples suffered from persecution which they might have
mistaken for the fulfillment of another of their Master's
prophecies (Matt. xxiv. 9). These three circumstances were
calculated to encourage the idea in credulous minds that Christ had
been restored to life, and that he would be with them again. Of
course, they were disappointed, as the second coming of Jesus was
no more a reality than was his resurrection. Besides, resurrections
were believed in long before Christ's time. Ovid's prophecy, in
reference to AEsculapius, was very similar to what has been said
about Christ. Here are the words

          "Once, as the sacred infant she surveyed,
           The God was kindled in the raving maid
           And thus she uttered her prophetic tale
           Hail, great physician of the world! all hail
           Hail, mighty infant, who in years to come
           Shall heal the nations and defraud the tomb.
           Swift be thy growth, thy triumphs unconfined;
           Make kingdoms thicker and increase mankind.
           Thy daring heart shall animate the dead,
           And draw the thunder on thy guilty head
           Then shalt thou die, but from the dark abode
           Shalt rise victorious, and be twice a God."

     The belief in the resurrection has been perpetuated
principally through persons accepting the faith without
investigation. This has been the cause of the growth of nearly all
the superstitions of the world. The fact that the belief in a
personal devil, a burning hell, purgatory, and the efficacy of the
mass has been retained so long is to be attributed to the lack of
free inquiry upon the part of those who have accepted these
theological dogmas. The same with the belief in the resurrection.
How many of those who regard it as a fact to-day have sought to
ascertain what evidence it has in its support? Even the majority of
ministers who preach this doctrine can give no other reason for
believing in it than because they find that it is taught in a
certain book; and most of the laity who endorse the belief that
Christ rose from the dead are influenced by the delusion that
heaven will be the reward of all who accept the belief, and that
hell will be the portion of those who reject it. Even St. Paul, who
is the principal witness for the resurrection, believed it on trust
and faith, "according to the Scriptures" (i Cor. xv. 3, 4). He also
thought that the end of the world would arrive in the time in which
he lived, but he was mistaken. Why, then, should he be relied upon
in reference to the resurrection? The supposed evidence of St. Paul
is worthless to prove that Christ rose from the dead. He was not an
eye-witness of the event, and his references to it are most
misleading. For instance, he says, Christ was "Seen of the twelve,"
but Judas was dead (Matt. xxvii, 3-5), and Mathias was not chosen
until after the Ascension (Acts i. 26). Then we are told "he was
seen of above five hundred brethren;" yet not one of the five
hundred has left the testimony that "I saw Jesus." "Last of all,"
says St. Paul, "he was seen of me." But how did he see him? Let the
apostle answer for himself. "I will come to visions and revelations
of the Lord. I knew a man in Christ above fourteen years ago 



                         Bank of Wisdom
                  Box 926, Louisville, KY 40201
                               28

               THE CLAIMS OF CHRISTIANITY EXAMINED

(whether in the body I cannot tell, or whether out of the body I
cannot tell: God knoweth), such an one caught up to the third
heaven. And I knew such a man (whether in the body or out of the
body I cannot tell: God knoweth)" (2 Cor. xii. 1-3).

     Some of the Spiritualists to-day profess to have "visions and
revelations;" but rational minds do not accept such "visions and
revelations" as matters of fact, to be depended upon to prove
anything of importance. Moreover, St. Paul's idea of a resurrection
was that it would be a spiritual one; and he says "flesh and blood
cannot inherit the kingdom of God" (i Cor. xv. 50); but the alleged
resurrection of Christ was of his natural body, and, after he had
risen, we are told he ate broiled fish just before he ascended up
into heaven" (Luke xxiv.).

     Professor Stewart says; "The existence of the Church, and
especially the early institution of the Lord's Day and of Easter
Day, are proofs of the nature and strength of primitive belief as
to the resurrection." To this we reply, that the resurrection was
not a recognized doctrine of the Church until the second century.
But suppose it were, it would not follow that, because the Church
believed it, therefore it was true. The Roman Catholics dedicated
their Church to the "Holy Virgin;" but is that evidence that Mary,
who was the mother of many children, was a virgin? There is St.
Peter's at Rome, although it is a disputed point that Peter ever
went to Rome. As to the term "Lord's Day," Tertullian (A.D. 200) is
the first writer who applies to it the resurrection, and we can
find no evidence that the two were associated prior to that time.
The Professor ought to know that the "Lord's Day" has no reference
to the day when Christ is said to have risen. Many conflicting
opinions have been given as to its real meaning. It has been
thought to refer to "the Gospel dispensation," to "the Day of
Judgment," to the "first day of the week;" but, so far as it can be
applied to anything, it is to the Bible Sabbath, which is Saturday,
the seventh day of the week, and this was not the day of the
supposed resurrection.

     In reference to Easter, that was of pagan origin, and in
Chambers's "Encyclopedia" (article "Easter") it is said: "With her
usual policy the Church endeavored to give a Christian significance
to such of the rites as could not be rooted out; and in this case
the conversion was practically easy." Christian exponents have a
reckless habit of connecting certain events together as if they
bore the relation to each other of cause and effect, when, in
reality, there is no such relation between them. To claim that the
resurrection was a fact because the Church believed it, and because
the "Lord's Day" and Easter have become recognized institutions, is
the very height of theological assumption. There is not a shadow of
legitimate evidence to support such a claim.

     We have dwelt upon this and the previous section at some
length, for the reason that the subjects treated are regarded by
Christians as affording the greatest proof of the truth of their
claims. We trust that, from our examination of the points at issue,
our readers will see that at least there are to these, as to most
questions, two sides and it is for them to decide for themselves
which they regard as the correct one.


                         Bank of Wisdom
                  Box 926, Louisville, KY 40201
                               29

               THE CLAIMS OF CHRISTIANITY EXAMINED

                          SECTION VIII.

                 THE INFLUENCE OF CHRISTIANITY.

     No one, we presume, who has marked the development of
religious thought will deny that Christianity has been a potent
factor in the history of the world. Its nature, incentive, and
general environment would naturally make it so. Nothing influences
the theological mind, either for good or for evil, more than its
notion of supernaturalism. If a person is induced to have absolute
faith in the fatherhood and sovereignty of God, he deems it his
first duty to carry out that which he considers to be the will of
that God. Hence it is that during intellectual periods men's
notions of Deity have been refined and cultivated, and, as a
consequence, oppression and persecution of Skepticism have been
more rare; while, on the other hand, when the multitude held rude
ideas of divinity, minds pure and chaste were sickened at the
scenes of cruelty and bloodshed which were enacted in accordance
with what was supposed to be "the will of God."  [For important
facts bearing upon this point the reader is referred to Earl
Russell's "History of the Christian Religion" and to Buckle's
history of Civilization.]  What we desire to consider in this
section is: Are the claims put forward by Christian exponents, as
to the influence of Christianity upon personal character and
natural progress, borne out by individual experience and the
records of history? As a rule, man is supposed to know himself
better than others know him; but there are instances in which other
people can estimate a person more correctly than he can estimate
himself. They will take a more dispassionate view of his character.
They will be in a better position to compare him with others, and
thus judge more accurately of his relations and comparative place
in the scale of humanity. As with individuals, so it is with
systems of religions. The devotees of a certain faith are wont to
regard it as being spotless, and as containing the panacea for all
the imperfections of society. This is particularly the case with
Christian advocates, who not only ignore all that is evil and
defective in the world as belonging to their system, but credit
Christianity with all the progress that has taken place in modern
times. This we believe to be a theological assumption which is
utterly opposed to the true history of all human improvement. The
progress of a nation cannot be attributed to any one thing or to
any one age, but rather to a combination of circumstances which
have been in operation during many ages. For instance, had it not
been for the scientific discoveries in the last century of a Watt,
a Dalton, and others, the sciences with which their names are
associated would not have been so easy of application to human
utility as they are at the present time. It is equally true that
for the freedom from religious intolerance which we now enjoy we
are as much indebted to Franklin, Paine, Carlile, Hetherington,
Watson, and other Freethought heroes of the past, as to any of
their representatives of this generation. To judge fairly of the
influence of Christianity, the following facts should be kept in
view: -- (1) That it is not an original system of harmonious
teachings and of uniform history. This fact we have already
abundantly proved. No one who has carefully and impartially read
the histories of the ancient religions and ethical systems can
truly allege that the principal doctrines and moral teachings of 


                         Bank of Wisdom
                  Box 926, Louisville, KY 40201
                               30

               THE CLAIMS OF CHRISTIANITY EXAMINED

the New Testament were known for the first time in their connection
with Christianity. The able American writer, Charles B. Waite,
M.A., in his "History of the Christian Religion," observes: "Many
of the more prominent doctrines of the Christian religion prevailed
among nations of antiquity hundreds -- and in some instances
thousands -- of years before Christ." Judge Strange, in his work,
"The Sources and Development Of Christianity," shows that nearly
all the Christian doctrines -- the Atonement, Trinity, Incarnation,
judgment of the Dead, Immortality, Sacrifice -- were of Egyptian
origin, and therefore, existed long before the time of Christ. The
same writer, on page 100 of the work mentioned, says:
"Christianity, it is thus apparent, was not the result of a special
revelation from above, but the growth of circumstances, and
developed out of the materials, working in a natural manner in the
human mind in the place and at the time that the movement
occurred." "To the truths already uttered in the Athenian prison,"
remarks Mackay, "Christianity added little or nothing, except a few
symbols, which, though well calculated for popular acceptance, are
more likely to perplex than to instruct, and offer the best
opportunity for priestly mystification." Sir William Jones, in his
tenth discourse before the Asiatic Society, says: "Christianity has
no need of such aids as many are willing to give it, by asserting
that the wisest men of the world were ignorant of the great maxim,
that we should act in respect to others as we would wish them to
act in respect of ourselves, as the rule is implied in a speech of
Lysias, expressed in distinct phrases by Thales and Pittacus, and
I have seen it word for word in the original of Confucius." And the
Rev. Dr. George Matheson, in his lecture on "The Religions of
China," page 84, frankly states "The glory of Christian morality is
that it is not original."

     (2) That to say professed Christians have performed noble and
useful actions is not sufficient to make good the orthodox claims;
it must be shown that such actions accord with the teachings of the
New Testament. It does not follow that, because Christianity and
civilization coexist, therefore the former is the cause of the
latter. Skepticism now obtains more than at any previous period;
but Christians will not grant that modern progress is the result of
unbelief. Civilization is not an invention, but a growth; a process
from low animal conditions to higher physical, moral, and
intellectual attainments. The real value of civilization consists
in its being the means whereby the community can enjoy personal
comfort and general happiness. History teaches that the progress of
a people depends upon their knowledge of, and their obedience to,
organic laws. The principal causes of modern civilization are: The
development of the intellect -- this rules the world to-day; the
expansion of mechanical genius -- this provides for the increased
needs of the people; the extension of national commerce -- this
causes an interchange of ideas; the invention of printing -- this
provides for the circulation of newly-discovered facts; the
beneficial influence of climate -- this affects the condition both
of body and mind; the knowledge and the application of science --
these reveal the value and the power of natural resources; the
spread of skepticism -- this provides for the vindication of the
right of mental freedom; the practical recognition of political
justice -- this forms the basis of all just governments; and,
finally, the establishment of the social equality of women with men


                         Bank of Wisdom
                  Box 926, Louisville, KY 40201
                               31

               THE CLAIMS OF CHRISTIANITY EXAMINED

-- this secures the emancipation of women from that state of
domestic servitude and general inferiority in which theology had
for centuries kept them. Now, these civilizing elements are not to
be found in the teachings of the New Testament; but, on the
contrary, as we have shown in previous sections of this pamphlet,
much that is taught therein discourages a progressive spirit (see
Matthew vi. 25-34; xlx. 21, 29; Luke xiv. 26; John vi. 27 Xii. 25;
i Corinthians vii. 20; Romans xiii. I, 2; Ephesians v. 22-24; and
2 Peter ii. 13-18).

     (3) The personal results of Christianity have depended upon
the nature and characteristics of those who accepted it as a
belief. Hence persons of the most contrary dispositions and the
most opposite natures have been its illustrators, expounders, and
living representatives. It has found room for all temperaments --
the ascetic and luxurious enjoyer of life; the man of action and
the man of contemplation; the monk and the king; the
philanthropist, and the destroyer of his race; the iconoclastic
hater of all ceremonies and the superstitious devotee. It has been,
in the words of St. Paul, "all things to all men." This
heterogeneous influence upon the human character, however, is by no
means the result of any all-embracing comprehensiveness in
Christianity, but is rather the effect of a system characterized
alike by its indefinite, incomplete, and indecisive principles.
This fact explains why some men have been good in spite of their
being believers in the orthodox faith, while other believers have
been destitute of the nobler qualities of our nature. The power
that "makes for righteousness" came not from Christianity, but from
the natural proclivities of its professors. If this were not so, we
might justly expect that all the recipients of the faith would have
been influenced for good. That they were not thus influenced we
learn from the New Testament and Christian history. "Contentions,"
"strife," "indignation," "fraud," and lying were indulged in by St.
Paul and his contemporaries (see Acts xv. 39; Luke xxii. 24;
Matthew xx. 24; i Corinthians vi. 8 and v. i; Matthew xxvi. 70, 72;
2 Corinthians xi. 8 and xii. 16). Mosheim admits that in the fourth
century "the Church was contaminated with shoals of profligate
Christians ... It cannot be affirmed that even true Christians were
entirely innocent and irreproachable in this matter" (see Mosheim's
"Ecclesiastical History," vol. i., pp. 55, 77, 102, Salvian, an
eminent pious clergyman of the fifth century writes: "With the
exception of a very few who flee from vice, what is almost every
Christian congregation but a sink of vices? For you will find in
the Church scarcely one who is not either a drunkard, a glutton, or
an adulterer ... or a robber, or a man-slayer, and, what is worse
than all, almost all these without limit" (Miall's "Memorials of
Early Christianity," p. 366). Dr. Cave, in his "Primitive
Christianity" (p. 2), observes: "If a modest and honest heathen
were to estimate Christianity by the lives of its professors, he
would certainly proscribe it as the vilest religion in the world."
Dr. Dicks, in his "Philosophy of Religion" (pp. 366-7), also
states: "There is nothing which so strikingly marks the character
of the Christian world in general as the want of candor [and the
existence of] the spirit of jealousy ... Slander, dishonesty,
falsehood, and cheating are far from being uncommon among those who
profess to be united in the bonds of a common Christianity."
Wesley, after stating that "Bible-reading England" was guilty of 


                         Bank of Wisdom
                  Box 926, Louisville, KY 40201
                               32

               THE CLAIMS OF CHRISTIANITY EXAMINED

every species of vice, even those that nature itself abhors, thus
concludes: "Such a complication of villainies of every kind,
considered with all their aggravations; such a scorn of whatever
bears the face of virtue; such injustice, fraud, and falsehood;
above all, such perjury and such a method of law, we may defy the
whole world to produce ("Sermons," vol. xii., P. 223).

     It is not true that, as orthodox believers allege,
Christianity is a universal religion. Christ states that he was
"not sent but unto the lost sheep of the house of Israel" (Matthew
xv. 24). And when he sent his disciples forth to preach he
commanded them to "go not into the way of the Gentiles, and into
any city of the Samaritans enter ye not (Matthew x. 5). Besides,
the very nature of the faith precludes it from being suitable to
all the nations of the world. Hence it has always been subject to
human conditions and national environments, and when those factors
were unfavorable to its advancement it either made comparatively no
progress, or its exponents altered its form that it might be
adapted to the conditions by which it was surrounded. Of this fact
there is abundant testimony. Tennent, in his "Christianity in
Ceylon," says: "Neither history nor more recent experience can
furnish any example of the long retention of pure Christianity by
a people themselves rude and unenlightened. In all the nations of
Europe, embracing every period since the second century,
Christianity must be regarded as having taken the hue and
complexion of the social state with which it was incorporated,
presenting itself unsullied, contaminated, or corrupted, in
sympathy with the enlightenment, or ignorance, or debasement of
those by whom it had been originally embraced. The rapid and
universal degeneracy of the early Asiatic Churches is associated
with the decline of education and the intellectual decay of the
communities among whom they were established." Dean Milman, in his
"History of Civilization," observes: "Its [Christianity's] specific
character will almost entirely depend upon the character of the
people who are its votaries ... it will darken with the darkness
and brighten with the light of each succeeding century." Lord
Macaulay says, with no less truth than brilliancy: "Christianity
conquered Paganism, but Paganism infected Christianity. The rites
of the Pantheon passed into her worship, and the subtleties of the
Academy into her creed." Francis William Newman, in his "Phases of
Faith," also remarks; "I at length saw how untenable is the
argument drawn from the inward history of Christianity in favor of
its superhuman origin. In fact, this religion cannot pretend to
self-sustaining power. Hardly was it started on its course when it
began to be polluted by the heathenism and false philosophy around
it. With the decline of national genius and civil culture it became
more and more debased. So far from being able to uphold the
existing morality of the best Pagan teachers, it became barbarized
itself, and sank into deep superstition and manifold moral
corruption. From ferocious men it learned ferocity. When civil
society began to coalesce into order, Christianity also turned for
the better, and presently learned to use the wisdom, first of
Romans, then of Greeks; such studies opened men's eyes to new
apprehensions of the Scripture and of its doctrine. By gradual and
human means, Europe, like ancient Greece, grew up towards better
political institutions, and Christianity improved with them."



                         Bank of Wisdom
                  Box 926, Louisville, KY 40201
                               33

               THE CLAIMS OF CHRISTIANITY EXAMINED

     With these historical facts at their command, it is strange
that Christian writers should put forward, as they do, such
extravagant and groundless claims on behalf of their faith.
Professor Stewart has the temerity to claim, in his "Handbook of
Christian Evidences," the following as achievements of
Christianity: (1) The introduction of the spirit of humanity and
the doctrine of brotherhood of man; (2) the modern elevation of
woman; (3) the abolition of slavery; (4) the extinction of the
gladiatorial combats in Rome; (5) the establishment of hospitals;
and (6) the fostering of art and general culture. These are some of
the advantages for which it is said we are indebted to the
influence of Christianity. A greater perversion of facts we have
seldom encountered, as we purpose now showing.

     (1) The great principle of love, humanity, and the brotherhood
of man was understood and practiced long before Christianity
existed. "Love," says the great teacher of the Academy, "is peace
and goodwill among men, calm upon the waters, repose and stillness
in the storm, and balm of sleep in sadness." "Independently of
Christian revelation," says Merivale, "the heathen world was
gravitating, through natural causes, towards the acknowledgment of
the cardinal doctrines of humanity" ("Conversion of the Roman
Empire," p. 118). In Mencius we have the noble statement that
"Humanity is the heart of man." Lecky writes: "The duty of humanity
to slaves had been at all times one of those which the philosophers
had most ardently inculcated ... But these exhortations [on the
duty of abstaining from cruelty to slaves], in which some have
imagined that they have discovered the influence of Christianity,
were, in fact, simply an echo of the teaching of ancient Greece,
and especially of Zeno, the founder of the sect who had laid down,
long before the dawn of Christianity the broad principle that all
men are by nature equal, and that virtue alone establishes a
difference between them ("History of European Morals," vol. i., pp.
324-5; see also "The Sacred Anthology," by Moncure D. Conway, pp.
10 and 354). Lecky also states that "the doctrine of the
brotherhood of mankind" was an active factor in Rome, and that
"Cicero asserted it as emphatically as Seneca" (ibid, p. 361).
Christ's idea of brotherhood was an exceedingly limited one,
inasmuch as it was confined to those who believed in him. Even at
the "judgment day " mankind are to be divided, "as a shepherd
divideth his sheep from his goats" (see Luke xii. 9; Matthew xxv.
32).

     (2) The position of woman, according to the Bible, is low and
humiliating in the extreme. It teaches that "Thy desire shall be to
thy husband, and he shall rule over thee" (Genesis iii. 16). It
enjoins that, as the Church is subject unto Christ, so let the
wives be to their own husbands in everything (Ephesians v. 22-24).
Women are not to speak in public, but to be under obedience, as
also saith the law; they are not permitted to teach, but to learn
in silence with all subjection, for the reason that "Adam was first
formed, then Eve, and Adam was not deceived, but the woman, being
deceived, was in the transgression (I Timothy ii. II, 15). These
notions are not, when accepted, calculated to elevate the character
or better the condition of woman. Herbert Spencer says: "In
England, as late as the seventeenth century, husbands of decent
station were not ashamed to beat their wives, Gentlemen arranged 


                         Bank of Wisdom
                  Box 926, Louisville, KY 40201
                               34

               THE CLAIMS OF CHRISTIANITY EXAMINED

parties of pleasure for the purpose of seeing wretched women
whipped at Bridewell. It was not until 1817 that the public
whipping of women was abolished in England. Wives in England were
bought from the fifth to the seventeenth century." Contrast this
with the treatment of woman before the advent of Christianity.
Lecky says: "The Roman religion was essentially domestic, and it
was the main object of the legislator to surround marriage with
every circumstance of dignity and solemnity. Monogamy was, from the
earliest times, strictly enjoined, and it was one of the great
benefits that have resulted from the expansion of the Roman power
that it made this type dominant in Europe. In the legends of early
Rome we have ample evidence of the high moral estimate of women,
and of their prominence in Roman life. The tragedies of Lucretia
and of Virginia display a delicacy of honor, a sense of supreme
excellence, of unsullied purity, which no Christian nation could
surpass" ("European' Morals," vol. ii., p. 316). "The legal
position of the wife had become one of complete independence, while
her social position was one of great dignity (ibid, p. 323). Sir
Henry Maine, in his "Ancient Law," says: "No society which
preserves any tincture of Christian institutions is likely to
restore to married women the personal liberty conferred on them by
the middle Roman law ... The later Roman law having assumed, on the
theory of natural law, the equality of the sexes, control of the
person of the woman was quite obsolete when Christianity was born.
Her situation had become one of great personal liberty and
proprietary independence, even when married, and the arbitrary
power over her of her male relatives, or her guardian, was reduced
to a nullity; while the form of marriage conferred on the husband
no superiority ... But Christianity tended from the first to narrow
this remarkable liberty."  [For ample evidence, showing the unjust
laws which Christian Councils passed, that were degrading to Woman,
and also the treatment she received from the Christian Fathers, the
reader is referred to a very able book, "Woman, Church, and State"
(chapters vii. and ix.), by Matilda J. Gage; also to "Men, Women,
and Gods," by Helen H. Gardener. In these two works ample evidence
is given to disprove the allegation that woman owes her improved
condition to Christianity.]

     (3) No one questions that slavery is taught in the Bible. But
the damaging fact to the Professor's contention is that, while at
the time when Christ is supposed to have lived the horrors of
slavery existed on every hand, yet he was silent upon this great
evil. In fact, slavery is endorsed in the New Testament, for we
read: "Let as many servants as are under the yoke count their own
masters as worthy of all honor." "Exhort servants to be obedient
unto their own masters.), "Servants, be obedient to them that are
your masters according to the flesh, with fear and trembling."
"Servants, be subject to your masters with all fear: not only to
the good and gentle, but also to the froward "(i Tim. vi. 1; Titus
ii. 9; Ephesians vi. 5; I Peter ii. 8). While the humanity of many
professed Christians prompted them to oppose slavery, among the
most persistent upholders of slavery and the most determined
opponents to its abolition were Christians, not only of this
country, but also of nearly all the American denominations. It is
stated in "The Life and Times of Garrison" that, at an American
convention held in May, 1841, he proposed: "That, among the
responsible classes in the non-slaveholding States, in regard to 


                         Bank of Wisdom
                  Box 926, Louisville, KY 40201
                               35

               THE CLAIMS OF CHRISTIANITY EXAMINED

the existence of slavery the religious professors, and especially
the clergy, stand wickedly preeminent, and ought to be unsparingly
exposed and reproved before all the people." Theodore Parker said
that, if the whole American Church had "dropped through the
Continent and disappeared altogether, the anti-slavery cause would
have been further on" ("Works," vol. vi., p. 333). He pointed out
that no Church ever issued a single tract among all its thousands
against property in human flesh and blood, and 80,000 slaves were
owned by Presbyterians, 225,000 by Baptists, and 250,000 by
Methodists. Even Wilberforce himself declared that the American
Episcopal Church "raises no voice against the predominant evil; she
palliates it in theory, and in practice she shares in it. The
mildest and most conscientious of the bishops of the South are
slave-holders themselves."

     Neither did Christianity improve the position of the slaves,
for both Lecky and Gibbon have shown that the condition of slaves
was, in some instances, better before than it was after the
introduction of Christianity. Prior to Christianity many of the
slaves had political power; they were educated, and allowed to mix
in the domestic circles of their masters; but subsequent to the
Christian advent the fate of the slave was far more severe, hence
Lecky observes "The slave code of imperial Rome compares not
unfavorably with those of some Christian countries. The physician
who tended the Roman in his sickness, the tutor to whom he confided
the education of his son, the artists whose services commanded the
admiration of the city, were usually slaves. Slaves sometimes mixed
with their masters in the family, ate habitually with them at the
same table, and were regarded by them with the warmest affection"
(Lecky's "History of Morals," vol. i., pp. 323 and 327). The
Council of Laodicea actually interdicted slaves from Church
communion without the consent of their masters. The Council of
Orleans (541) ordered that the descendants of slave parents might
be captured and replaced in the servile condition of their
ancestors. The Council of Toledo (633) forbade Bishops to liberate
slaves belonging to the Church. Jews having made fortunes by slave-
dealing, the Councils of Rheims and Toledo both prohibited the
selling of Christian slaves except to Christians. Parker
Pillsbury's excellent work, "Acts of the Anti-Slavery Apostles," is
a strong indictment against the Christian Church for its conduct in
supporting slavery.

     (4) It is not true that the Galilean faith removed the blots
that dimmed the glory of the ancient world. Slavery, infanticide,
and brutal sports remained for centuries after the erection of the
symbol of the Cross. We grant that Rome, like every other country,
had its vices; but Christianity failed to remove them. As Lecky
observes, "the golden age of Roman law was not Christian, but
Pagan" ("History of European Morals," vol. ii., p. 44). The
gladiatorial shows of Rome had a religious origin; and, while some
of the grandest pagan writers condemned them, they were not
abolished till four hundred years after the commencement of the
Christian era. And be it observed that the immediate cause of their
ultimately being stopped was that at one of the exhibitions, in
A.D. 404, a monk was killed. "His death," says Lecky, "led to the
final abolition of the games" (ibid, p. 40). It was a noteworthy
fact that, while the passion for these games existed in Rome, its 


                         Bank of Wisdom
                  Box 926, Louisville, KY 40201
                               36

               THE CLAIMS OF CHRISTIANITY EXAMINED

love for religious liberty was equally as strong; and it was this
very liberty that was first destroyed in the Christian Empire
(ibid, p. 38). Every nation has had its national drawback, and
Christian countries are no exception to the general rule. Under the
very shadow of the Cross cruelties of the deepest dye have been
practiced. Bull-fights, badger-hunting, cock-fighting, and pigeon-
shooting have all been, and still are, favorite amusements in
Christian lands. What was the state of morals in England during the
reigns of Henry VIII., Queen Mary, Queen Elizabeth, and George IV.?
Was there ever a period of greater moral depravity and intellectual
poverty than when the Christian Church was paramount and supreme,
when the saints, the bishops, and the priests were guilty of the
worst of crimes, including incest, adultery, and concubinage, when
"sacred institutions," filled with pious nuns, were converted into
brothels and hot-beds of infanticide? (ibid, 351). Rome, with all
its immorality, will bear comparison with the early ages of
Christianity.

     (5) There is no lack of evidence to prove that consideration
for the poor and the sick existed centuries before the Christian
era. Such virtue is confined to no one race, and to no one
religion. According to Prescott, the ancient Mexicans had hospitals
in the principal cities "for the cure of the sick, and for the
permanent refuge of disabled soldiers" ("History of the Conquest of
Mexico," p. 140). Hospitals are evidently the outgrowth of
dispensaries, and we are told that, as far back as the eleventh
century B.C., the Egyptians had medical officers who were paid by
the State, and who attended in some public place to prescribe for
the sick who came there. These were qualified men; for at this
early date there was a College of Physicians, and only those who
were licensed by this college were allowed to practice. R. Bosworth
Smith, M.A., writes in his "Mohammed and Mohammedanism": "No
Christian need be sorry to learn, or be backward to acknowledge,
that, contrary to what is usually supposed, two of these noble
institutions [hospitals and lunatic asylums] ... owe their origin
and their early spread, not to his own religion, but to the great
heart of humanity, which beat in two other of the grandest
religions of the world. Hospitals are the direct outcome of
Buddhism" (p. 253). About 325 B.C. King Asoka commanded his people
to build hospitals for the poor, the sick, and distressed, at each
of the four gates of Patna and throughout his dominions. The first
Christian hospital was built by a Roman lady named Fabiola, in the
fourth century A.D., so that it took some time for Christianity to
begin to develop this good fruit, though Egyptians, Greeks, and
Hindoos had long before shown the value of it. If it were true that
the world is indebted to Christianity for benevolent institutions,
it would be a sad reproach to the supposed "Heavenly Father," who,
until less than two thousand years ago, failed to inspire his
children with active sympathy for those who required help. Were
God's chosen people "destitute of love and consideration for their
fellows? Let the Old Testament answer the question.

     (6) No doubt Christianity at one period gave an impetus to
art, and so it did to monkish lying chronicles. William Hole,
R.S.A., however, says: "Christianity brought about the
deterioration of Greek art ... In early centuries Christianity 



                         Bank of Wisdom
                  Box 926, Louisville, KY 40201
                               37

               THE CLAIMS OF CHRISTIANITY EXAMINED

tended generally to the decay of art. When it did favor it, it was
not through love of art, but for the sake of religion" (Address
delivered before the Edinburgh Philosophical Institute, February
16th, 1892).

     The assistance that culture has received from Christian
teachings is of a very doubtful character. Where in the New
Testament is culture inculcated? We know that the Christian Church
destroyed much of the learning of Rome, and plunged Europe into a
state of mental darkness. For centuries it monopolized, with a
blighting force, the agencies of intellectual training, with the
result that the world was cursed with what Lecky terms "a night of
mental and moral darkness," and he further adds: "Nearly all the
greatest intellectual achievements of the last three centuries have
been preceded and prepared by the growth of skepticism. ... The
splendid discoveries of physical science would have been impossible
but for the scientific skepticism of the school of Bacon ... Not
till the education of Europe passed from the monasteries to the
universities, not till Mohammedan science and classical Freethought
and industrial independence broke the scepter of the Church, did
the intellectual revival of Europe begin." History of Morals," vol.
ii., pp. 205 and 219).

                          ****     ****

          Books recommended to Students of the Subjects
                discussed in the foregoing Pages.

Buckle's "History of Civilization." Especially chapters iv.-vii.
Professor Huxley's "Controversial Questions;" and his reference to
     Miracles in his "Life of Hume."
Laing's "Modern Science and Modern Thought," "Problems of the
     Future," and "Human Origins."
Leslie Stephen's "An Agnostic's Apology."
J.S. Mill's "On Liberty."
Schmidt's "Social Aspects of Early Christianity."
Draper's "Conflict between Religion and Science."
J. Cotter Morison's "The Service of Man."
William Addis's "Christianity in the Roman Empire."
Herbert Spencer's "First Principles."
W.R. Greg's "The Creed of Christendom."
Charles Bradlaugh's "Genesis."
Evan Powell Meredith's "The Prophet of Nazareth."
Mosheim's "Ecclesiastical History."
Dr. Giles's "Hebrew and Christian Records."
Dr. Irons's "The Bible and its Interpreters."
Rev. S. Davidson's  "The Canon of the Bible."
Professor Graham's  "The Creed of Science."
Karl Pearson's "The Grammar of Science."
Lecky's "History of European Morals." 2 vols.
Charles Watts's "Was Christ a Political and Social Reformer?"
G.W. Foote's "Flowers of Freethought."
Constance E. Plumptre's " Natural Causation."

                          ****     ****

    Reproducible Electronic Publishing can defeat censorship.


                         Bank of Wisdom
                  Box 926, Louisville, KY 40201
                               38
