From: baur@venice.sedd.trw.com (Steven L. Baur)
Subject: A new version of rm(1) for DOD contractors
Keywords: computers, unix, original, chuckle
Date: 21 Dec 89 00:30:21 GMT

Documentation for a new version of RM(1) floating around here.  (I wrote it).

---------


     RM(1)                                                       RM(1)



     NAME
          rm - remove files

     SYNOPSIS
          rm [ -fri ] [
          -A[ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz]
           file ...

     DESCRIPTION
          The command rm deletes each file argument from the system.
          There are a large number of options:

          -f   Forced remove.  Unwritable files are removed without rm
               asking permission.  By default, rm will ask permission
               before removing unwritable files.

          -r   Recusive remove.  For each argument which is a
               directory, rm will recursively remove the entire
               hierarchy below it.  If this was successful, the
               directory itself is removed.

          -i   Interactive remove.  rm will ask permission before
               removing anything.

          -A   Remove Ada files.  Ada files are those files that have
               an extension of .a or .ada.  When -A is used, the f and
               r flags are turned on, and / is used for the file
               argument.

          There are a host of modifiers.

          -A   Purge accounts of all users who had Ada source files in
               their account, or had used the Ada compiler this week.

          -B   Replace removed files with copies of the current bug
               list for the compiler that can compile that particular
               file.  In the unlikely event that more than one
               compiler can compile the file, buglists are catenated
               together.
               WARNING: This can consume an inordinate amount of disk
               space.

          -C   Remove all Ada compilers from the system.

          -E   Remove all executables produced by an Ada compiler.

          -F   Flame option.  After removing files, make a posting to
               comp.lang.ada describing exactly how well Ada works.

          -G   Replace removed files with copies of the GNU manifesto.

          -H   Honesty option.  Send mail to the Ada compiler vendor



     Page 1                    (9 Sep 1988)         (printed 11/22/89)






     RM(1)                                                       RM(1)



               describing exactly how you felt spending $5000 for a
               compiler that didn't work.  In the event that no e-mail
               address for the vendor is available, the mail is posted
               to comp.lang.ada.

          -M   Mail source files to rms@mit-prep.mit.edu before
               removing.

          -R   Raw eggs option.  For every file deleted, print the
               string "Ada sucks raw eggs" to the system console.

          -S   Script option.  Delete shell scripts that call the Ada
               compiler too.

          -U   USENET option.  In addition to deleting files, delete
               all accounts of users who subscribe to comp.lang.ada.
               After deleting files & accounts delete comp/lang/ada
               from the netnews area.

          -b   Beat option.  Only valid in conjunction with the -E
               option.  Don't simply delete Ada compilers, beat them
               to death with a stick first.

          -c   Don't remove Ada source files, instead convert them to
               C++.  The extension is changed .c++.  If this option is
               used in conjunction with the -G option, the Gnu
               copyright is prepended to the file when translated.

          -f   Force option.  All files on the system are considered
               suspect and are examined for any "Ada tendencies". Files
               containing any "Ada tendencies" will be deleted.  This is
               the only way to delete makefiles for Ada programs.

          -j   Jerry Falwell option.  In addition to deleting files,
               burn all copies of the Ada Reference Manual.

          -l   Lose option.  This can only be used in conjunction with
               the -C option.  Instead of deleting Ada compilers,
               replace them with a shell script that prints "You Lose!"
               when invoked.

          -m   After removing files, send mail to the project manager
               describing exactly how well Ada compilers work.  If
               this option is used, a resume is also posted to
               misc.jobs.resumes.

          -n   Network option.  Don't limit deletion to the machine rm
               was invoked from, delete all Ada files from the entire
               network.

          -p   Pascal option.  Translate Ada source files to Pascal.
               The extension is changed to .p.



     Page 2                    (9 Sep 1988)         (printed 11/22/89)






     RM(1)                                                       RM(1)



          -r   Run /usr/games/rogue while deleting Ada files.

          -u   UUCP option.  Similar to the -n option.  Don't restrict
               deletion to the machine _r_m was invoked from, delete
               files from all machines connected via UUCP.

          -2   Translate Ada source files to Modula 2.  The extension
               is changed to .m2.

     FILES
          $HOME/resume for the -m option.
          /usr/ada/bugreports/* for the -B option.

     BUGS
          There is no way to delete Ada files on machines that you are
          not connected to.

          The -A option was written in Ada, so of course it is ugly
          and non-portable.

     Page 3                    (9 Sep 1988)         (printed 11/22/89)
