        Written by Alan Silverstein, Hewlett Packard, circa 1983:


        PLACE(1)                Parody Systems                        PLACE(1)


        NAME
            place - print and set the system location

        SYNOPSIS
            place [ [-v] [-]ddmmss[-]dddmmss ] [ +format ]

        DESCRIPTION
            If no  argument  is given, or if the  argument  begins  with
            ``+'', the current  location  (latitude and  longitude)  are
            printed.  Otherwise,   the   current   location  is  set  by
            teleporting  the  system.  The  first dd is the  degrees  of
            latitude   (negative  for  south);  mm  is  the  minutes  of
            latitude;  ss is the seconds of latitude.  The second ddd is
            the  degrees of  longitude  (negative  for west); and so on.
            For example:

                place 385100-1050300

            sets the  location  of the system to the top of Pikes  Peak,
            Colorado.  The correct  altitude is  automatically  provided
            and  cannot  be  specified.  The  system  operates  in feet.
            Place  takes  care  of  the  conversion  to and  from  local
            standard measurement units.

            When a new  location  is set, all  logged-in  terminals  and
            users  are   transported   along   with  all  other   system
            peripherals.

            If the -v (verbose)  option is specified when a new location
            is set, place prints a running  description of the locations
            the system passes through enroute to the given  destination.
            Note that this can slow down  transport  time  considerably,
            from  instantaneous  to  however  long it takes to print the
            description   to  standard   output.  This   option  is  not
            recommended  if stdout is a terminal  connected at less than
            4800  baud,  since  hitting   BREAK  can  leave  the  system
            stranded.

            Attempting to set the place off-planet  generates a warning,
            and requires an extra confirmation from the (super)user.

            If the  argument  begins  with ``+'', the output of place is
            under the control of the user.  The format for the output is
            similar to that of  date(1).  All  output  fields  which use
            hours,  minutes,  or  seconds  are  applicable   (substitute
            "degrees" for hours, where appropriate).

            Place writes an accounting record on the file /usr/adm/wtmp.

        DIAGNOSTICS
            No permission   If you aren't the super-user  and you try to
                            move the system.

            bad conversion  If the place set is syntactically incorrect,
                            or below sea level.

            bad format character
                            If the field descriptor is not recognizable.

        FILES
            /dev/kmem
            /usr/adm/wtmp
            /usr/lib/altitudes

        AUTHOR
            Alan Silverstein, Hewlett-Packard

        SEE ALSO
            date(1), whereami(1)

        BUGS
            If there is not a supply of compatible electric power at the
            new  location,  the  system  usually  crashes  before  place
            finishes writing accounting information to /usr/adm/wtmp.

            This  command  should not be used on systems  connected to a
            Local Area Network, for obvious reasons.
--
