URANUS SCIENCE SUMMARY



		NASA's Voyager 2 spacecraft flew closely past distant
Uranus, the seventh planet from the Sun, in January 1986. 		
		At its closest, the spacecraft came within 81,500
kilometers (50,600 miles) of Uranus's cloudtops on Jan. 24, 1986.
		Voyager 2 radioed thousands of images and voluminous
amounts of other scientific data on the planet, its moons, rings,
atmosphere, interior and the magnetic environment surrounding
Uranus.
		Since launch on Aug. 20, 1977, Voyager 2's itinerary
has taken the spacecraft to Jupiter in July 1979, Saturn in
August 1981, and then Uranus.  Voyager 2's next encounter is with
Neptune in August 1989.  Both Voyager 2 and its twin, Voyager 1,
will eventually leave our solar system and enter interstellar
space.
		Voyager 2's images of the five largest moons around
Uranus revealed complex surfaces indicative of varying geologic
pasts.  The cameras also detected 10 previously unseen moons. 
Several instruments studied the ring system, uncovering the fine
detail of the previously known rings and two newly detected
rings.  Voyager data showed that the planet's rate of rotation is
17 hours, 14 minutes.  The spacecraft also found a Uranian
magnetic field that is both large and unusual.  In addition, the
temperature of the equatorial region, which receives less
sunlight over a Uranian year, is nevertheless about the same as
that at the poles.
Before Voyager
		Nearly 3 billion kilometers (1.8 billion miles) from
Earth, Uranus is the most distant object yet visited by a
spacecraft.  Uranus is so far away that scientists knew
comparatively little about it before Voyager 2 undertook its
historic first-ever encounter with the planet.
		Indeed, since its discovery by William Herschel in
1781, Uranus had remained largely a mystery throughout the
ensuing two centuries.  Five moons -- the first discovered in
1787, the last in 1948 -- were visible only as tiny points of
light.  A system of nine narrow rings went undetected until 1977. 
The planet's rate of rotation could be estimated only roughly and
was believed to be anywhere from 16 to 24 hours.  Before Voyager,
there were indirect indications of a magnetic field at Uranus,
although the evidence was not conclusive.
		Scientists were not sure what to expect from Uranus's
strange orientation.  The planet is tipped on its side, with its
orbiting moons and rings forming a giant celestial bull's-eye. 
As a result, the northern and southern polar regions are
alternatively exposed to sunlight or to the dark of space during
the planet's 84-year orbit around the Sun.
The Encounter

		Voyager 2's encounter of Uranus began Nov. 4, 1985 with
an observatory phase.  Activity built to a peak in late January
1986, with most of the critical observations occurring in a six-
hour period in and around the time of closest approach.  The
spacecraft made its closest approach to Uranus at 9:59 a.m. PST
on Jan. 24.

		To prepare for the flyby of this unusual planetary
system, engineers extensively reprogrammed Voyager 2's onboard
computers via radio control from the ground.  They endowed the
spacecraft with new capabilities that would enable it to return
clear, close-up pictures despite the dim light and high velocity
at which Voyager would be passing its targets.  (Uranus receives
about 1/400th of the sunlight that falls on Earth.)
		In addition, giant antenna receiving stations on Earth
were linked electronically in order to capture and enhance
Voyager's faint radio signal.
Moons
		Voyager 2 obtained clear, high-resolution images of
each of the five large moons of Uranus known before the
encounter: Miranda, Ariel, Umbriel, Titania and Oberon.  The two
largest, Titania and Oberon, are about 1,600 kilometers (1,000
miles) in diameter, roughly half the size of Earth's Moon.  The
smallest, Miranda, is only 500 kilometers (300 miles) across, or
just one-seventh the lunar size.
		The 10 new moons discovered by Voyager bring the total
number of known Uranian satellites to 15.  The largest of the
newly detected moons, named Puck, is about 150 kilometers (about
90 miles) in diameter, or larger than most asteroids.
		Preliminary analysis shows that the five large moons
are ice-rock conglomerates like the satellites of Saturn.  The
large Uranian moons appear, in fact, to be about 50 percent water
ice, 20 percent carbon- and nitrogen-based materials, and 30
percent rock.  Their surfaces, almost uniformly dark gray incolor, display varying degrees of geologic history.  Very
ancient, heavily cratered surfaces are apparent on some of the
moons, while others show strong evidence of internal geologic
activity.
		Titania, for example, is marked by huge fault systems
and canyons that indicate some degree of geologic activity in its
history.  These features may be the result of tectonic movement
in its crust.  Ariel has the brightest and possibly the
geologically youngest surface in the Uranian moon system.  It is
largely devoid of craters greater than about 50 kilometers (30
miles) in diameter.  This indicates that low-velocity material
within the Uranian system itself peppered the surface, helping to
obliterate larger, older craters.  Ariel also appears to have
undergone a period of even more intense activity leading to many
fault valleys and what appear to be extensive flows of icy
material.  Where many of the larger valleys intersect, their
surfaces are smooth; this could indicate that the valley floors
have been covered with younger icy flows.
		Umbriel is ancient and dark, apparently having
undergone little geologic activity.  Large craters pockmark its
surface.  The darkness of Umbriel's surface may be due to a
coating of dust and small debris somehow created near and
confined to the vicinity of that moon's orbit.
		The outermost of the pre-Voyager moons, Oberon, also
has an old, heavily cratered surface with little evidence of
internal activity other than some unknown dark material
apparently covering the floors of many craters.

		Miranda, innermost of the five large moons, is one of
the strangest bodies yet observed in the solar system.  Voyager
images, which showed some areas of the moon at resolutions of a
kilometer or less, consists of huge fault canyons as deep as 20
kilometers (12 miles), terraced layers and a mixture of old and
young surfaces.  The younger regions may have been produced by
incomplete differentiation of the moon, a process in which
upwelling of lighter material surfaced in limited areas. 
Alternatively, Miranda may be a reaggregation of material from an
earlier time when the moon was fractured into pieces by a violent
impact.  
		Given Miranda's small size and low temperature 
(-335 degrees Fahrenheit or -187 Celsius), the degree and
diversity of the tectonic activity on this moon has surprised
scientists.  It is believed that an additional heat source such
as tidal heating caused by the gravitational tug of Uranus must
have been involved.  In addition, some means must have mobilized
the flow of icy material at low temperatures.
The Rings
		All nine previously known rings of Uranus were
photographed and measured, as were other new rings and ringlets
in the Uranian system.  These observations showed that Uranus's
rings are distinctly different from those at Jupiter and Saturn.
		Radio measurements showed the outermost ring, the
epsilon, to be composed mostly of ice boulders several feet
across.  However, a very tenuous distribution of fine dust also
seems to be spread throughout the ring system.
		Incomplete rings and the varying opacity in several of
the main rings leads scientists to believe that the ring system
may be relatively young and did not form at the same time as
Uranus.  The particles that make up the rings may be remnants of
a moon that was broken by a high-velocity impact or torn up by
gravitational effects.
		To date, two new rings have been positively identified. 
The first, 1986 U1R, was detected between the outermost of the
previously known rings -- epsilon and delta -- at a distance of
50,000 kilometers (31,000 miles) from Uranus's center.  It is a
narrow ring like the others.  The second, designated 1986 U2R, is
a broad region of material perhaps 3,000 kilometers (1,900 miles)
across and just 39,000 kilometers (24,000 miles) from the
planet's center. 
		The number of known rings may eventually grow as a
result of observations by the Voyager 2 photopolarimeter
instrument.  The sensor revealed what may be a large number of
narrow rings -- or possibly incomplete rings or ring 
arcs -- as small as 50 meters (160 feet) in width.  
		The individual ring particles were found to be of  low
reflectivity.  At least one ring, the epsilon, was found to be
gray in color.  Important clues to Uranus's ring structure may
come from the discovery that two small moons --Cordelia and
Ophelia -- straddle the epsilon ring.  This finding lends
credence to theories that small moonlets may be responsible for
confining or deflecting material into rings and keeping it from
escaping into space.  Eighteen such satellites were expected to

have been found, but only two were photographed. 
		The sharp edge of the epsilon ring indicates that the
ring is less than 150 meters (500 feet) thick and that particles
near the outer edge are less than 30 meters (100 feet) in
diameter. 
		The epsilon ring is surprisingly deficient in particles
smaller than about the size of a beachball.  This may be due to
atmospheric drag from the planet's extended hydrogen atmosphere,
which probably siphons smaller particles and dust from the ring.
The Planet
		As expected, the dominant constituents of the
atmosphere are hydrogen and helium.  But the amount of helium --
about 15 percent -- was considerably less than the 40 percent
that had been suggested by some Earth-based studies.  Methane,
acetylene and other hydrocarbons exist in much smaller
quantities.  Methane in the upper atmosphere absorbs red light,
giving Uranus its blue-green color.  
		Voyager images showed that the atmosphere is arranged
into clouds running at constant latitudes, similar to the
orientation to the more vivid latitudinal bands seen on Jupiter
and Saturn.  Winds at mid-latitudes on Uranus blow in the same
direction as the planet rotates, just as on Earth, Jupiter and
Saturn.  These winds blow at velocities of 40 to 160 meters per
second (90 to 360 miles per hour); on Earth, jet streams in the
atmosphere blow at about 50 meters per second (110 mph).  Radio
science experiments found winds of about 100 meters per second
blowing in the opposite direction at the equator.
		A high layer of haze -- photochemical smog -- was
detected around the sunlit pole.
		The sunlit hemisphere also was found to radiate large
amounts of ultraviolet light, a phenomenon that Voyager
scientists have dubbed "dayglow."
		The average temperature on Uranus is about 60 Kelvin (-
350 degrees Fahrenheit).  The minimum near the tropopause is 52 K
(-366 F) at the 0.1-bar pressure level.  (The tropopause is the
boundary between the stratosphere and the troposphere, the lowest
level of atmosphere, comparable to the region on Earth where life
abounds.  One bar is the average pressure at sea level on Earth.)
		Surprisingly, the illuminated and dark poles, and most
of the planet, show nearly the same temperature below the
tropopause.  Voyager instruments did detect a somewhat colder
band between 15 and 40 degrees latitude, where temperatures are
about 2 to 3 K lower.  The temperatures rise with increasing
altitude, reaching 150 K (-190 F) in the rarified upper
atmosphere.  Below this level, temperatures increase steadily to
thousands of degrees in the interior.
Magnetosphere
		Radio emissions detected several days before closest
approach provided the first conclusive indication that Uranus
actually possesses an magnetosphere.
		Not only does a Uranian magnetic field exist; it is
intense and skewed with its axis tilted at a 60-degree angle to
rotational axis.  At Earth, by comparison, the two axes are
offset by about 12 degrees.

		The intensity of the magnetic field at Uranus's surface
is roughly comparable to that of Earth's, though it varies much
more from point to point because of its large offset from the
center of Uranus.  The magnetic field source is unknown; the
electrically conductive, super-pressurized ocean of water and
ammonia once thought to lie between the core and the atmosphere
now appears to be nonexistent.  The magnetic fields of Earth and
other planets are believed to arise from electrical currents
produced in their molten cores.
		As at Mercury, Earth, Jupiter and Saturn, there is a
magnetic tail extending millions of miles behind Uranus.  Voyager
measured the magnetotail to at least 10 million kilometers (6.2
million miles) behind the planet.  The extreme tilt of the
magnetic axis, combined with the tilt of the rotational axis,
causes the field lines in this cylindrical magnetotail to be
wound into a corkscrew shape.
		Voyager 2 found radiation belts at Uranus of an
intensity similar to those at Saturn, although they differ in
composition.  The radiation belts at Uranus appear to be
dominated by hydrogen ions, without any evidence of heavier ions
(charged atoms) that might have been sputtered from the surfaces
of the moons.  Uranus's radiation belts are so intense that
irradiation would quickly darken (within 100,000 years) any
methane trapped in the icy surfaces of the inner moons and ring
particles.  This may have contributed to the darkened surfaces of
the moons and ring particles.
		Voyager detected radio emissions from Uranus that,
along with imaging data, helped narrow the planet's rate of
rotation to about 17 hours, 14 minutes.
The Next Encounter
		 The Uranus encounter officially came to an end on Feb.
25, 1986.  Eleven days earlier, project engineers took a major
step toward the encounter at Neptune by commanding Voyager 2 to
fire its thrusters for a course-correction maneuver lasting more
than 2-1/2 hours.
		Voyager 2 will fly about 1,300 kilometers (800 miles)
over the north pole of Neptune at 9 p.m. PDT on Aug. 24, 1989. 
Five hours later, Voyager 2 will encounter Neptune's moon, Triton
-- the spacecraft's final destination before heading toward the
boundary of our solar system.
		The Voyager project manager is Norman R. Haynes of JPL,
and George P. Textor, also of JPL, is the deputy project manager. 
Dr. Edward C. Stone of the California Institute of Technology is
the project scientist.  Dr. Ellis D. Miner of JPL is the deputy
project scientist.  JPL manages the Voyager Project for NASA's
Office of Space Science and Applications.
                           #####
		 

12/21/88
MBM