PRE-BUILDING PLANS

  Before you start building your ramp make sure that you read and understand
these plans completely.  You've got to have a good feeling for what you are
about to tackle or you will probably end up with a mess.  There are some
important things to consider before you even decide what kind of ramp you are
going to be building.  There is almost nothing worse than starting off on a
project and finding out half-way through that you're not going to be able to
pull it off because you've blown-off or forgotten some important step along the
way.

  This is a big undertaking, don't be embarrassed about asking for a little
help.  Ramps are now popping up all around the country at an amazing rate,
chances are good that at least one ramp is already being ridden in your
neighborhood.  Go check out a ramp that's already built and see what kind of
problems the owners have had with it, or get some good ideas for things to do
with your own ramp.  Also don't be too proud to ask dad or some other adult for
help on the carpentry; every man alive likes to believe he is an accomplished
builder and will usually jump at the chance to pound a few nails.  If you get
dad to help you, rather than letting the project turn out half-assed under his
supervision, he will probably do all he can to make it turn out good.  Who
knows, if he really gets into it he might even float a few bucks towards the
cost of materials.  Then, when all the work is done he might appreciate more
the idea of having this big wooden monster sitting in his backyard.  You, on
the otherhand, should have no problems appreciating this big wooden monster.
Skate tough or stay in a coma.

  Enough planning, it's time to build some vertical terrain.  First of all you
must decide what your limitations are and how this will affect the ramp you are
going to build.

  Limitation Aspect #1.  Location-probably the most important thing to resolve;
where are you going to put it?	Ramps can virtually be built anywhere.	We've
seen ramps of every description built in backyards, fields, orchards,
sidewalks, parking lots, rooftops, mountain sides and creek beds.  First look
at the obvious spots, like your own backyard or a tolerant friend's pad.
Private property with permission is best for obvious reasons.  Putting up a
quarter pipe or lightweight structure is one thing, but sweating out a killer
ramp only to have someone tell you to take it down is not happening.
Warehouses, garages and the like are good sites because they are level, indoors
and away from the elements (cops and neighbors).  Check with your city or town
officials in regard to public lands or park and recreation facilities that
might be available.  It is becoming more common for local governments to take
interest in the skateboarder's plight and build a public ramp, check into this
idea with your own.

  Ideally, for a decent sized half-pipe like the one described in this book,
you will want to build on a fairly large, flat cement surface (patio, parking
lot, etc.) but a relatively level dirt or grass area will work fine.  Be sure
and check out local ordinances regarding construction, you might need a
building permit for the ramp you have in mind.	Keep in mind that this is going
to be a permanent structure, once it's done you won't want to think about
anything but the next session, so make sure your facts are straight before you
follow through with the construction.

  In most cities, the ordinances require that the structure cover more than a
certain percentage of your yard, such as, 30% of the available open space.  In
many cases, making your ramp portable (or at least appear so) will help bypass
many of the requirements, such as building permits, etc.  Also, most city codes
specify that no backyard structure can be higher than the highest point of the
house.	Check into it, once you know what must be done to build your ramp
legally, you will most likely have to abide by some civil laws as well.

  It is very rare that all surrounding neighbors will put up with extended
night sessions, trash floating around or boards shooting into their pool or
pegging their backyard pooch.  Because of the brash nature of skating and
skaters themselves, it is wise to inform your immediate neighbors of the
possibility of such goings on, and get a feeling for what you can and cannot
do.  Believe me, if you push your limits with them, the ramp will not last long
because the law will side with them almost every time.

  Limitation Aspect #2.  Type of ramp you can afford to build.	So you've found
the perfect spot; some old lady with a ranch outside of town craves the energy
of youth and has agreed to give you free reign of an acre of land with a nice
swimming hole and rows of pregnant apple trees, no problems there, but now
there's the question of materials.  What do you have to build with?

  The materials you are able to get your hands on will basically tell you what
kind of ramp you'll soon be ripping.  Unless you have 20 or 30 sheets of
plywood lying around or a large stack of 2 x 4s you will probably be spending
close to $1000 for your basic 8' wide, 8' radius transition half-pipe.  Plywood
isn't cheap and even though 2 x 4s do grow on trees they aren't just lying
around, but there are ways of getting some free wood.  Ripping off wood or
shopping at "the midnight lumber store" can get you busted.  We've been hearing
some real nightmares about young thrashers getting caught with a load and
getting to see the legal system work first hand.  The amount of lumber you'll
need for your ramp will probably constitute grand theft in most lawbooks so
watch it.  Don't get stopped before you've even started.  Check your own
backyard or garage for wood and ask friends or neighbors if they have any.
Also, hang around local construction sites and beg for cut-off ends and various
scraps, every little bit gets you one step closer.

  Wood is expensive if you have to buy it outright, but it's plentiful enough
that you can find a bargain if you shop around.  Check the phone book for
salvage yards that deal in used wood.  Most of the time they'll have all you
need at a fraction of the cost.  You may have to pull a few nails but it's
worth it.  When dealing with these guys try to to bargain for your final price,
you might save yourself even more bucks by not agreeing to the first price they
give you.

  Once you have assembled all you can feasibly scrounge, it's time to start
putting it together.  The hard part is over now, you realize your limitations
and you must now decide what type of ramp you're going to build.  You may find
that because of one thing or another you are limited to building a smaller ramp
or quarter-pipe rather than a full-blown half-pipe.  Don't be discouraged if
the ramp forecast looks bleaker than you imagined before, almost any variation
of most big ramp maneuvers can be pulled off on a smaller dimension ramp.
Also, to the beginning verticalist, a smaller ramp is going to be helpful for
training purposes and will keep you shredding until you can move up to big
time.  Use what you can to ride what you've got; real skaters ignore
limitations.

CONSTRUCTION:

Banked Ramps

  There is no reason why any skater who craves vert should be deprived of a
vertical wall or bank to skate.  Even if you are flat broke there are things
you can do.  In reality all you need is a 3/4" thick piece of plywood and
you're in business.  Whenever you get the urge to skate a bank just drag out
that old piece of plywood and "set it up."

  If you can get your hands on some 2 x 4s, try expanding on the banked ramp
theme by building a frame for your piece of plywood.  Starting with a "banked
ramp" is a good way for the beginning skater/carpenter to get into basic wall
riding and ramp construction at the same time.	Quarter Pipes

  A quarter-pipe is just what it sounds like, a quarter piece of round pipe.
If you can rustle up at least four or more 4' x 8' sheets of plywood and a
decent supply of 2 x 4s you can throw together a small quarter-pipe that will
carry you up to vertical.  A cash outlay here will still run around $75 for new
wood.

  As far as transition from horizontal to vertical goes there are several ways
of constructing a quarter-pipe.  One method is to build an L-shaped framework
similar to the one shown for the banked ramp, except that you create the curve
for the transition with 2 x 4s.  By cutting and fitting lengths of 2 x 4 into
place you can make a solid curve and a foundation for the plywood skating
surface.  (Fig.  1) The thickness of the plywood for making this type of ramp
should be no more than 3/8".  Using two or three layers of 1/4" ply is
recommended here for the optimum transition.

  Another method of quarter pipe construction involves the use of plywood
templates to form the transition and 2 x 4 cross bracing to support the skating
surface.  If you go ahead with this type of design, using the template method,
you'll need to look ahead to the plans for building a half-pipe for
instructions on how to make templates using the string/compass method.	(Fig.
2)

  Regardless of the type of method you use to construct a quarter-pipe, the
radius of the transition should measure between 6' and 8'.  Also because you
are building a single sided ramp, you'll be pushing into the ramp from another
surface such as the street or sidewalk.  In this case you want a smooth
connection between the street and where the ramp begins.  Try cutting the edge
of the plywood at an angle, where it will meet the asphalt, before you nail it
down.  Or, slap a thin strip of sheet metal down over the critical area, tack
it with small nails and finish it off with a length of silver duct tape to
insure against flesh wounds if you have to slide over it.  Half-pipe

  Here are the plans for building the basic minimum structure needed for
full-on vertical skating (16' wide, 10 feet of flat bottom, 8' transitions with
a foot of vertical, hence a 9 foot wall).  These dimensions are commonly used
for several reasons.  One, plywood is widely available in 4' x 8' sheets and 2"
x 4" and 2" x 6" studs are usually bought in 8' and 16 lengths.  Using lumber
of these dimensions will add up to a nice 16-footer without wasting cut-off
ends and creating a lot of unusable scrap.  Another reason for the 16-foot size
is that anything smaller is going to seem too cramped for full-on sessioning.
Twelve foot is passable, but if you go 12 feet, it's almost easier to stretch
it out to 16 feet because of those standard lumber dimensions.

  Another point that we should review is that the methods we are discussing
here for building a skateboard ramp will result in an ultimately sturdy
structure.  One that can be pummeled year after year without so much as
resheeting of plywood or masonite from time to time.  If you have to take short
cuts because of lack of funds or materials, there are ways to cut back.  The
size of your ramp for starters.  Smaller ramp; less wood.  There is also a way
to make your transition templates using less plywood than we discuss here
without sacrificing too much in the strength department.  We'll try to cover
some of these cost-saving tips as we get to them; otherwise, if you've got the
materials and the cash, build it big and strong, it'll pay off in the long run.

  Once you have found a site to build on it is important to make sure it is
close to level.  Starting with a bottom framework that is level makes
everything else fall into place a little easier once you begin building
upwards.  If you're building on an incline or on otherwise shaky ground, you'll
want to sink 4" x 4" posts at least 2' into the ground (preferably in cement)
and sticking up high enough at the low end to run a level beam between them.
(Fig.  3)

  If the ground is soft, build the framing on top of cement pier blocks placed
at the strategic corners.  Posting also lifts the structure off the ground,
thereby keeping rot and insect damage in check for a longer period.

  Bottom Framework

  This is where the strenth and sturdiness of your ramp lies; the more solid
your initial framework is, the longer your ramp is going to last.  This part of
the ramp will be completely covered up so make sure that it is solid before you
move onto the next step.

  It is best to use 4 x 4s for the framework but 2 x 4s will work.  Lay these
in a rectangular bo th siz o th ramp I ou cas i woul b 10 of flat
bottom plus two 8' radius transitions-26 feet long and 16 feet wide.  Brace
this structure with 2 x 4s spaced 6 inches apart under the flat section and a
foot apart under the transitional areas.  For more strength, support these
bracings with additional 2 x 4s as shown in the diagram.  Place the 2 x 4s in
the frame with the 2" side facing up and sitting flush with the top of the 4 x
4s.  The 2 x 4s will act as a solid base for connecting the plywood to the flat
bottom section.  (Fig.	4)

Horizontal to Vertical Transitions

  The next step is deciding what radius should be used for the transition from
the flat bottom to the vertical wall.  The shorter the radius, the steeper the
incline, is the basic law.  We chose an 8' radius to a 9' high wall for a fluid
yet thrustable transition to a foot of "true" vert.  Larger ramps have been
built with as much as a 9 or 10 foot radius.  For larger transitions you should
plan on a higher wall to accomodate some vertical.

  To cut out 8' transitions for your ramp you will need:  a sabre saw, a piece
of string or twine at least 9 1/2 feet long, a pencil and a nail.  Make a large
compass by tying one end of the string to the nail and the other end to the
pencil at exactly the 8-foot mark.

  By securing the nail at one end (use a wooden stake in the ground if a nail
doesn't work), you can pull the string taut and draw transitional arc on a
sheet of plywood, (Fig.  5) (and you thought that geometry had no place in the
real world).

  Using a half sheet laid down next to the full sheet, you should be able to
draw one full transition.  Using a sabre saw, cut out the template being
careful to stay right on your pencil line.  This is where the smoothness of the
transition begins.  To save time, use the first transition that you've cut out
as a pattern for the other transition pieces you will need.  Or, apply the
string/compass method using a large piece of cardboard instead of plywood.  By
doing this, you'll have a lightweight pattern that is easy to handle for
tracing and insures that each transition is the exact same radius.

  You will be able to save on expensive plywood without sacrificing the
strength of your ramp by cutting transition "ribs." To do this, draw an initial
8' radius and then readjust your string compass to 9' and draw another arc
right behind the first one.  This will give you a foot wide piece of plywood
with an 8' radius arc on one side.  These 'ribs' are then nailed onto the
framework to support the middle of the wall without using a whole piece of
plywood (Fig.  6).  Full sheets of at least 5/8" plywood should be used for the
templates on the four outside corners.

  Connecting Templates to Framework

  Start by placing 4 x 4 posts in each of the four corners of your bottom
framework.  For extra strength sink these 2 to 3 feet into the ground.	The
height of these posts will be determined by how high you want your walls and
how much vert.	Start with posts 10 to 12 feet high; you can always saw off the
extra length at the top.  Use a carpenter's level to make sure everything is at
right angles and then brace the posts with 2 x 4s.

  Now you're ready to nail the plywood transition templates to the sides of
your framework.  Connect the pieces of your templates together first, so that
they form one whole 90 degree arc from flat bottom to vertical.  Now position
the completed template flush with the floor section of your framework and flush
with the 4" x 4" vertical upright post and tack it on.  Do likewise around the
four corners of your framework.  Now, for the tricky transition supports in
between the outer templates, you'll want to build up some 2" x 4" framing that
you can hang the transition ribs on.  It is important here to make sure all
your transition supports are in alignment with each other.  If they're not,
you'll find out when you start trying to fit in your cross bracing.  Use a line
level to make sure before you start the cross bracing.

  Bracing

  Building the 2" x 4" cross bracing into your ramp framework is an important
step because they supply the main support, as well as the nailing studs for the
plywood skating surface.  The strongest method is to notch out the plywood
templates to accomodate a 2" x 4" cross brace so that its edge is flush with
the ply edge.

  Make a notching "pattern" by using a full transition and tracing the end of a
2 x 4 onto the template.  Do this at 6" intervals at the bottom of the
transition and continue up the wall.  Once you are past the impact zone (the
lower 2/3 of the transition) you can increase the distance between notches to 8
to 10 inches.

  By making a notching pattern, either of cardboard or plywood and tracing it
onto each of the transition templates, you'll be sure that the cross bracing is
straight from one side of the ramp to the other and more importantly, flush
with the curve of the transition template.  Cut out the notching with sabre saw
and lay in the 2 x 4s.

  These are plans for the framework of a basic half-pipe.  Before you cover
with plywood there are some things you might want to think about adding to your
ramp.  With the addition of stairs, vertical extention, coping, roll-out decks
and canyons you can turn this into a completely raging structure.  Once the
plywood has been layed on ramp do your best not to even think about taking it
back up.  Decide which extra features you want to add now and then move on
towards the end.  Besides being a complete hassle, pulling up a sheet of
plywood after its been nailed down is a great way to waste it.	Tombstones &
Extenstions

  A "tombstone" is really just an extension of the vertical wall of your ramp.
Having some extra vertical footage on one side (or both sides) of your ramp is
nice for getting those extra gnarly sensations, there's nothing like a
frontside grind on top of a 12-foot wall with 3 1/2 feet of vert.  A tombstone
will also give you that extra launch needed for airs and other bio tricks that
require an extra speed thrust.

  Building a tombstone into your ramp framework is easy.  Just extend your wall
supports above the ramp lip for as much vert as you think you can handle, brace
it up and ply it along with the rest of the ramp.

  If you want to add a tombstone to an already existing ramp, it's a little
tricky because you'll want to tie the extension into the subframing for max
strength.  Do this by prying up the roll-out deck, adding supports where needed
and secure solidly to the existing framework behind the ramp wall.  A good
place for an extension is on an edge or one corner of your ramp, because its
easier to brace there.	Once it is in place you'll be able to use it to get
good speed lines on the opposing wall of the ramp.

  Canyons and Rollout Decks

  Rollout decking is a must for any ramp.  Most regulars will drop off the lip
from the axles or tail or just simply roll in from the top decking.  It is also
much safer to ride with a rollout deck because you won't go over the side on a
miscalculated layback air or rock 'n' roll.  To add on to your existing ramp,
just build a basic boxlike framework behind the transitions and cover with used
ply.

  Roll-in canyons are sometimes rather difficult to install once your ramp has
been completed.  The optimum channel width is 3' wide, manageable yet
challenging enough for ollie/airs and channel plant type maneuvers.  A 6 ft.
roll in radius is desirable.  This allows you to comfortably drop into the meat
of transition.	Learning fakie tricks on the wall opposite the canyon is easier
without having to start from a fakie rock 'n' roll position all the time.

  Build a channel opening just like a regular transition except upside down.
Start by cutting two 6' radius transition 'ribs' out of some scrap ply.  Fit
them in on either side of your channel gap so that they flush up against the
underside of the plywood near the top of the transition and under the rollout
platform.  Nail the ribs to the framework of your ramp, 2" x 4" cross bracing
in between, and you're ready to ply down (Fig.  7).

  Coping

  Coping applications is a must for any skate ramp.  One of the best things
about coping is that it keeps the edge of your ramp from getting splintered and
ground up.  Not to mention making a ramp extra grindable with less hangups.
Materials for coping are fairly plentiful as well as various in accordance with
different tastes.  Here's a quick rundown of some of the more common cope.

  PVC plastic piping seems to be quite popular, plentiful and cheap.  It
provides a good sliding grind with or without truck protection and is fairly
easy to install.  Rip a length (at least 4') of 2" PVC pipe right down the
middle and you'll have two equal halves that you can work with.  Drill small
holes for nails or countersink screws and secure it to the lip.

  Real pool coping is, naturally, an excellent choice for a ramp lip.  It gives
you that extra bite and just has a more comfortable feel to it.  Some skaters
have managed to salvage enough blocks from dirt filled or destroyed pools to
edge their ramps with, otherwise you can sometimes buy blocks at a pool supply
outlet or masonry yard.

  Lately we've been seeing some other variations on the coping theme.  Angle
iron, which is iron bar shaped in a 90 degree angle, has been showing up on a
few ramps.  It is easy to apply, provides an ultra durable lip cap that will
last the lifetime of three or four ramps, if not forever, and provides a super
slippery edge for plastic and metal to metal grinding.	Arguments against using
iron for cope is that it doesn't grab well on handplant maneuvers and it hurts
a lot more than something like PVC if you slip and slap your shin against it.
But, you only live once.

  Stairs & Ladders

  You're going to want to be able to get to the rollout deck of your ramp,
without running up the wall everytime.	Stairs are ideal, but they are also a
bitch to build right.  Ladders are not as stylish but it doesn't take much
expertise to build one.  All you need is two 2" x4"s (minimum size for support)
the same height as your ramp and about ten short pieces for steps.  Support the
long pieces and nail in the steps at whatever distance you feel comfortable
with.  If you're still hell-bent on stairs go to the library and check out a
book on carpentry, you should be able to find plans and put together a mean
staircase.

  THAT IMPORTANT FIRST LAYER

  Let's recap a few strong points that we've already covered.  Before you even
think of applying the first layer of plywood you should have solid
reinforcement in the framework and crosspieces of the flat, transition, and
vertical sections of the ramp.	The transition should have rigidly supported 2"
x 4" cross members spaced, at the most, 6" apart.  The floor of the ramp should
be just that:  as close to a solid unit as possible.  The optimum for this flat
bottomed section would be to build almost exclusively from lumber like a
redwood deck or patio.

  Another way to attain a completely rigid ramp floor is to construct it like
the floor of your house with a cement block foundation supporting a solid
framework structure and the entire flat area covered with 3/4" - 1 1/4" thick
plywood.  The next time you see a house under construction, stop and check out
how the floors are made.  It is a simple framework, with HEAVY DUTY plywood on
top.  You'll want your floor as inflexible as possible.

  If your transition and vertical cross members are into notches in the
transition templates, make sure they are solidly secured at each notch point.
Get on the side of the ramp and sight down the length of the framework.  This
is important because you want the first layer of plywood to flush on each cross
brace to achieve a flowing, 'kinkless' transition.

  There are a few things to keep in mind when designing the supporting
framework:  1) Floor area plywood pieces must always run lengthwise with the
grain running in the direction of the skating (coping to coping).  This means
that the braces under these pieces should be positioned such that the plywood
can be fastened lengthwise along the edges to these supporting braces.	2>
Where two pieces of plywood meet on the transitions there tends to be a certain
amount of straightening of the pieces in the seam area because there are no
internal shear stresses set up in the wood to hold it down.  To remedy this, I
would suggest placing extra support brace cross members on either side of the
seam supporting cross members to help hold down the edges of the plywood into a
smooth curvature.  3) If you choose to construct the floor of the ramp with
lumber decking or heavy duty 1 1/4" plywood, you will only need, at the most,
one layer of 3/8" on top of that and it should last a lifetime.  With this in
mind, design the transition so that the layers of ply stack up to the height of
this single layer on flat.  There's no use in putting three or four layers on
top of a perfectly solid floor.  4) Get out the old geometry book and calculate
the surface distance from the top of one side of the ramp to the top of the
other.	This will help you determine how much plywood you will need and it
should give you an idea of the most efficient, economical way to lay it down on
the framework to get the best use of the wood.

  Once you have achieved a strong, rigidly secured supporting framework, you
are ready to apply the all important first layer.

  Plywood is constructed with cross-grained layers of wood and therefore has
its strength in the lengthwise direction, because there are more plys running
in this direction within the piece of plywood.	The same principle can be used
in surface construction of your ramp by alternating each layer of 3/8" thick
plywood on your ramp:  Make the first layer run lengthwise, the second layer
crosswise and the last layer lengthwise again.	This will give the best
strength and stability to the riding surface.

  If your ramp has a tight transition design you may have trouble bending the
pieces of plywood (especially lengthwise) into the transition without cracking
or breaking them.

  To check for this problem, lay your plywood pieced down on the ramp so that
half are on the floor and half on the transition.  Now, <HI>gently apply steady
pressure to the piece.	If it can be flexed all the way down without stress
fracturing, then move it to the transition and try it again.  Here you may hear
a few creaks and groans as you ease it into place, but don't worry unless it
really sounds gnarly.  Whatever you do don't shove it down or have some idiot
stamping on it to jam it in place, it will break instantly.  If the pieces of
plywood cannot be eased down gently and steadily into place without them
screaming in pain, then you'll have to soak them first to get them to comply.

  Do this by forming a shallow, flat bath out of a plastic tarp and soak the
wood for a day under water.  Make sure you are using exterior grade plywood if
you do this.  A way to get around this problem if you are buying new plywood is
to look around for fresh, still damp exterior plywood at the hardware store or
lumber yard and purchase it the day you plan to surface your ramp.  Bring it
straight to the ramp site and apply it.  You should have no trouble at all
doing it this way.

  Make sure they are all positioned correctly and parallel.  Now use dry wall,
sheet rock type, screws to secure down the plywood.

  It is crucial here to get this layer tightly secured and fitted against all
support members in the flat area and the transitions of the framework.	To do
this now on the transitions, the screws must be applied in horizontal rows
working from the bottom of the sheet to the top.  Do not merely tack down the
corners while holding down the sheet, then put screws in at random.  This will
result in a poor fit to the transition.  Each row of sheets must be applied in
step from the floor to the top of the ramp for the best fit.

  Make sure you pay attention to details during this first layer application.
Seams should be flush, with corners all joining at a point; sheets with cracks
and defects should be placed facing down and in the outer corners of the ramp.
Your strongest pieces should be put on the middle transition area.

  Sheets placed on crooked or gaps left between sheets will cause a compounding
problem that will magnify as you go about laying down the rest of the first
layer.	Don't be conservative with screws.  The more screws you use, the closer
the plywood will assume your intended transition, and the smoother and more
solid will be your ride.  Make sure all screws go into brace supports.	If
there appear to be any soft spots, then replace that piece or build up more
supports and bracing behind it.

  FINAL TOUCHES

  The second, third and each successive layer of plywood should be alternated
or criss-crossed when applied.	It will be much easier to lay these alternate
layers but remember to line up all the sheets so that they are parallel and fit
well together at the seams.  Try not to align the seams of the second layer
over the seams of the first, in fact stagger it as much as possible for maximum
strength.

  Check the smoothness of the surface, use sandpaper to smooth out any spots
where there might be splinter action.  Check out where the sheets of plywood
meet each other, check for nails or screws sticking up and for uneven surfaces.
Check out the supports, stomp on the ramp and make sure it's solid, give it a
good enough beating that you can be sure it's not going to come apart on you.

  Now that you've completed the basic structure, you may want to session it for
a few days to get that initial buzz out of your system.  For all intents and
purposes you are done, however, if you still have the funds there are some
things you should do to protect the surface and insure your ramp's long life.
The dumpings of winter rain and snow and the scorching summer sun on some poor
ramps can deteriorate all that nice wood fast.	A little preventive medicine in
the form of surface protection is going to go a long way to preserve your
riding surface.

  Painting is the cheapest way to protect your ramp's surface, not to mention
giving you a chance to personalize it with your art skills.  Your basic enamel
(water base) exterior paint works best because it soaks in and dries fast.  You
should apply two thin coats rather than one thick coat, letting the first one
dry before applying the second.  This will prevent the surface from becoming
slippery.

  Water sealant can be added to the layer directly beneath the top layer.  The
top layer can be coated on both sides and edges.

  Allow everything to dry for at least 24 hours before applying the top layer
to the ramp.  This method works well with masonite and will keep water from
seeping in from behind during the wet months.

  One of the best surface coverings is SPAR urethane.  This will make your
plywood or masonite top layer superfast and ultra-endurable.  Apply two light
coats then one heavy coat, allowing it to drip into all the cracks and seams of
the surface layer.  About 3 cans will do the job for a 16' wide ramp.

  An expensive route, but one that, if done right, will stay for years is the
application of 1/8" masonite shower wall on top of a layer of masonite or very
smooth, high grade plywood.  Shower walling is a thin, easily bendable, epoxy
coated masonite that is 100% waterproof, and requires no screws or nails to
apply.	There are dozens of surface designs available in any bathroom supply
section at any hardware store.	To apply this wonder surface you will need
ample amounts of epoxy-base glue, such as linoleum glue, or any strong
industrial adhesive.  Slap liberal coats onto each sheet and press with a
rolling pin into place on top of your top layer.  Remember, this is a surfacing
technique, NOT a support layer.  Shower wall will not increase the strength of
your ramp at all.  You must make sure your underplys are very strong and smooth
before applying shower wall.  Once applied, you will have the hardest, fastest,
most impregnable surface known at this point in ramp construction.

  NOTE:  Any of the sealing methods must be done thoroughly so that water
cannot seep under the top layer.  When this happens, the moisture will stay in
between the plys because the sealant won't allow the top layer to breathe, thus
allowing it to dry out.  The moisture will cause rot and mildew in the wood and
you'll have to tear it up.

  Now you have your ramp.  Our best wishes go out to you and your new
structure, may it be a long-term high-energy affair.  If you have done the work
right, shown patience and not blown anything off, then all that's left is the
ride.  Skate unconventionally but stay safe.

  OWNING YOUR RAMP

  Legality

  If you have dealt with the proper legal channels as mentioned in the
beginning of this booklet and your ramp meets local construction ordinances,
etc., then you should have little to worry about, the law cannot get you unless
someone makes a complaint.  As mentioned before, your neighbors are the ones
who can put a legal stop to your ramp riding.  Bear down and do your best to
avoid offending them and things will go much smoother for you.

  If the ramp is up by a neighbor's fence, put up some kind of catch netting to
stop flying boards.  If it is prone to be an eyesore, then paint the ramp a
suitable color or nail paneling around the sides and back.  The neighbors may
complain about the noise when the ramp is being skated.  This noise comes from
underneath the transitions.  You can dampen this noise by stuffing foam rubber,
styrofoam or insulation in the back between the support braces.  Even a few old
sleeping bags tacked in place will help.

  Set a time limit for sessions and watch the volume of music if you play it.
A lot of neighbors don't mind the noise but after twelve hours of skating and
rocking most non-skater's nerves will grow thin.  Put out a trash can for
litter.

  Liability

  It is very important to realize that you are liable for any injuy that occurs
on your property which includes your ramp.  People in this country have a very
selfish tradition of blaming someone else if they take a risk and get hurt.
They try to justify their injury by making someone else pay the price in cold
hard cash.  With the amount of money-hungry lawyers out there who specialize in
lawsuits, charging no fee unless they win, it's no wonder that everyone seems
to be getting sued.  To avoid this fate yourself, you had better make it clear
to all skaters who ride your ramp that they are riding AT THEIR OWN RISK.  Post
a sheet of ground rules easily visible from the ramp.  This will minimize the
chance that you and your family will be liable.  Make everyone wear all safety
equipment, especially helmets.	Many ramp owners require skaters to sign "Skate
at your own risk" type release forms to exclude them from liability.  These
rules may seem tiresome and a pain but you are responsible for enforcing them.
It is much better to skate safe, and have your friends do so, than to be
battling in court or living in the streets.

  Finally, don't let things get out of hand around the ramp.  You, as the
owner, are responsible for keeping it under control, even if it means telling
some out of line skaters to take off.  Many times a new ramp will attract a
crowd you don't even know who make themselves right at home by barging into
your house for a drink, pissing in your yard or severely thrashing your ramp
and property in a frenzied skate session.  It is your right as the owner to
determine the who, when, where, and what of your ramp so don't let yourself be
pushed around, make decisions and stick by them.

  REHABILITATION OF OLDER RAMPS

  There will probably come a point after hours of sessioning and multiple
weather beating days, that you will have to make repairs on your ramp.	If you
have taken care and preserved the wood with a protective layer then the repairs
should only be minor, usually soft spots, kinks or spongy areas.

  A common "solution" to these problems seems to be slapping on more and more
layers of plywood until it "goes away." This can be very expensive and will
hardly ever work in the long run.  We've seen the same weak spot resurface in
the exact same place though more than 10 layers had been put on the ramp in
question.

  The way to fix these defects is by getting to the root of the problem, like
when you go the dentist:  when you have a cavity, he makes sure he gets to the
bottom of it before he starts filling it.  If he doesn't, then you still have
the problem.  Most of the troubles on the riding surface are due to weak or
kinked transition structures, look behind the the ramp if possible, where the
problem spot lies.  You may find that the cross members are broken or weak at
that point, and need to be braced.  If it is possible to do this without
removing any plywood, simply brace the bad cross piece with extra 2 x 4's or
steel brackets.  Often the bad spot is impossible to get to from behind.  In
this case, remove all layers of plywood over the spot and support the frame
work underneath.  Always replace the plywood with new layers where the soft
spot has been repaired.

  When a plywood related surface problem develops, the best solution is to
replace that sheet.  A lot of funky methods are used to avoid doing this, like:
cramming the spot with wood chips and duct-taping it closed (works for about
three runs), nailing a scrap of tin over the spot (usually more death than the
spot by itself), or chiseling out the piece of plywood that contains the spot
and nailing in another piece (extremely weak).	Replace the entire piece of
plywood whenever possible.  If the spot is small and replacing the whole sheet
just seems like a waste, then there are a few alternatives.  The best thing to
repair a hole or soft spot with in this case is something resin-based like
fiberglass.  Chip the bad area open with a chisel and clean it out good.  Now
apply a filler like bondo or fiberglass layers to bring the hole up to the
surface of the rest of the piece of plywood.  Once this is dry, lay a piece of
fiberglass over the whole area to make it smooth.  Be careful when using resins
to fix holes and soft spots, they set very fast when it's hot, and you need
acetone to get the stuff off tools or your hands.  Fiberglass sticks well to
the wood on ramps and is far stronger than plywood so it will hold up well
under punishment.

  Another ramp repair method that has been suggested is using a mixture of
Elmer's glue and fine sawdust.  Once this stuff dries it can be easily sanded
and smoothed flush.

  Once again, when making surface repairs in the ramp, get down to the root of
the problem.  Most soft spots, kinks, and other defects are caused by flexible
or weak supporting structure (i.e., bent, cracked, or broken cross members), so
this is where the bracing and additional support is needed.  Do not neglect to
repair all spots before they become dangerously large.

  Build strong and skate long.
