FACT SHEET:     VOYAGER SATURN SCIENCE SUMMARY

		The Voyager 1 and 2 Saturn encounters occurred nine
months apart, in November 1980 and August 1981.  Voyager 1 is
leaving the solar system.  Voyager 2 completed its encounter with
Uranus in January 1986 and with Neptune in August 1989, and is
now also en route out of the solar system.
		The two Saturn encounters increased our knowledge and
altered our understanding of Saturn.  The extended, close-range
observations provided high-resolution data far different from the
picture assembled during centuries of Earth-based studies.
		Here is a summary of scientific findings by the two
Voyagers at Saturn:
SATURN
		Saturn's atmosphere is almost entirely hydrogen and
helium.  Voyager 1 found that about 7 percent of the volume of
Saturn's upper atmosphere is helium (compared with 11 percent of
Jupiter's atmosphere), while almost all the rest is hydrogen. 
Since Saturn's internal helium abundance was expected to be the
same as Jupiter's and the Sun's, the lower abundance of helium in
the upper atmosphere may imply that the heavier helium may be
slowly sinking through Saturn's hydrogen; that might explain the
excess heat that Saturn radiates over energy it receives from the
Sun.  (Saturn is the only planet less dense than water.  In the
unlikely event that a lake could be found large enough, Saturn
would float in it.)
		Subdued contrasts and color differences on Saturn could
be a result of more horizontal mixing or less production of
localized colors than in Jupiter's atmosphere. While Voyager 1
saw few markings, Voyager 2's more sensitive cameras saw many:
Long-lived ovals, tilted features in east-west shear zones, and
others similar to, but generally smaller than, on Jupiter.
		Winds blow at high speeds in Saturn.  Near the equator,
the Voyagers measured winds about 500 meters a second (1,100
miles an hour).  The wind blows mostly in an easterly direction. 
Strongest winds are found near the equator, and velocity falls
off uniformly at higher latitudes.  At latitudes greater than 35
degrees, winds alternate east and west as latitude increases. 
Marked dominance of eastward jet streams indicates that winds are
not confined to the cloud layer, but must extend inward at least
2,000 kilometers (1,200 miles).  Furthermore, measurements by
Voyager 2 showing a striking north-south symmetry that leads some
scientists to suggest the winds may extend from north to south
through the interior of the planet.
		While Voyager 2 was behind Saturn, its radio beam
penetrated the upper atmosphere, and measured temperature and
density.  Minimum temperatures of 82 Kelvins (-312 degrees
Fahrenheit) were found at the 70-millibar level (surface pressure
on Earth is 1,000 millibars).  The temperature increased to 143
Kelvins (-202 degrees Fahrenheit) at the deepest levels probed -
- about 1,200 millibars.  Near the north pole temperatures were
about 10 degrees Celsius (18 degrees Fahrenheit) colder at 100

millibars than at mid-latitudes.  The difference may be seasonal.
		The Voyagers found aurora-like ultraviolet emissions of
hydrogen at mid-latitudes in the atmosphere, and auroras at polar
latitudes (above 65 degrees).  The high-level auroral activity
may lead to formation of complex hydrocarbon molecules that are
carried toward the equator.  The mid-latitude auroras, which
occur only in sunlit regions, remain a puzzle, since bombardment
by electrons and ions, known to cause auroras on Earth, occurs
primarily at high latitudes.
		Both Voyagers measured the rotation of Saturn (the
length of a day) at 10 hours, 39 minutes, 24 seconds.
THE RINGS
		Perhaps the greatest surprises and the most perplexing
puzzles the two Voyagers found are in the rings.
		Voyager 1 found much structure in the classical A-, B-
and C-rings.  Some scientists suggest that the structure might be
unresolved ringlets and gaps.  Photos by Voyager 1 were of lower
resolution than those of Voyager 2, and scientists at first
believed the gaps might be created by tiny satellites orbiting
within the rings and sweeping out bands of particles.  One such
gap was detected at the inner edge of the Cassini Division.
		Voyager 2 measurements provided the data scientists
need to understand the structure.  High-resolution photos of the
inner edge of the Cassini Division showed no sign of satellites
larger than five to nine kilometers (three to six miles). No 
systematic searches were conducted in other ring gaps.
		Voyager 2's photopolarimeter provided more surprises. 
The instrument measured changes in starlight from Delta Scorpii
as Voyager 2 flew above the rings and the light passed through
them.  The photopolarimeter could resolve structure smaller than
300 meters (1,000 feet).
		The star-occultation experiment showed that few clear
gaps exist in the rings.  The structure in the B-ring, instead,
appears to be variations in density waves or other, stationary,
forms of waves.  Density waves are formed by the gravitational
effects of Saturn's satellites.  (The resonant points are places
where a particle would orbit Saturn in one-half or one-third the
time needed by a satellite, such as Mimas.)  For example, at the
2:1 resonant point with 1980S1, a series of outward-propagating
density waves has about 60 grams of material per square
centimeter of ring area, and the velocity of particles relative
to one another is about one millimeter per second.  Small-scale
structure of the rings may therefore be transitory, although
larger-scale features, such as the Cassini and Encke Divisions,
appear more permanent.
		The edges of the rings where the few gaps exist are so
sharp that the ring must be less than about 200 meters (650 feet)
thick there, and may be only 10 meters (33 feet) thick.
		In almost every case where clear gaps do appear in the
rings, eccentric ringlets are found.  All show variations in
brightness.  Some differences are due to clumping or kinking, and
others to nearly complete absence of material.  Some scientists

believe the only plausible explanation for the clear regions and
kinky ringlets is the presence of nearby undetected satellites.
		Two separate, discontinuous ringlets were found in the
A-ring gap, known as Encke's Gap, about 73,000 kilometers (45,000
miles) from Saturn's cloud tops.  At high resolution, at least
one of the ringlets has multiple strands.
		Saturn's F-ring was discovered by Pioneer 11 in 1979. 
Photos of the F-ring taken by Voyager 1 showed three separate
strands that appear twisted or braided.  At higher resolution,
Voyager 2 found five separate strands in a region that had no
apparent braiding, and surprisingly revealed only one small
region where the F-ring appeared twisted.  The photopolarimeter
found the brightest of the F-ring strands was subdivided into at
least 10 strands.  The twists are believed to originate in
gravitational perturbations caused by one of two shepherding
satellites, 1980S27.  Clumps in the F-ring appear uniformly
distributed around the ring every 9,000 kilometers (6,999 miles),
a spacing that very nearly coincides with the relative motion of
F-ring particles and the interior shepherding satellite in one
orbital period.  By analogy, similar mechanisms might be
operating for the kinky ringlets that exist in the Encke Gap.
		The spokes found in the B-ring appear only at radial
distances between 43,000 kilometers (27,000 miles) and 57,000
kilometers (35,000 miles) above Saturn's clouds.  Some spokes,
those thought to be most recently formed, are narrow and have a
radial alignment, and appear to corotate with Saturn's magneticfield in 10 hours, 39.4 minutes.  The broader, less radial spokes
appear to have formed earlier than the narrow examples and seem
to follow Keplerian orbits:  Individual areas corotate at speeds
governed by distances from the center of the planet.  In some
cases, scientists believe they see evidence that new spokes are
reprinted over older ones.  Their formation is not restricted to
regions near the planet's shadow, but seems to favor a particular
Saturnian longitude.  As both spacecraft approached Saturn, the
spokes appeared dark against a bright ring background.  As the
Voyagers departed, the spokes appeared brighter than the
surrounding ring areas, indicating that the material scatters
reflected sunlight more efficiently in a forward direction, a
quality that is characteristic of fine, dust-sized particles. 
Spokes are also visible at high phase angles in light reflected
from Saturn on the unilluminated underside of the rings.
		Another challenge scientists face in understanding the
rings is that even general dimensions do not seem to remain true
at all positions around Saturn:  The distance of the B-ring;s
outer edge, near a 2:1 resonance with Mimas, varies by at least
140 kilometers (90 miles) and probably by as much as 200
kilometers (120 miles).  Furthermore, the elliptical shape of the
outer edge does not follow a Keplerian orbit, since Saturn is at
the center of the ellipse, rather than at one focus.  The
gravitational effects of Mimas are most likely responsible for
the elliptical shape, as well as for the variable width of the
Huygens Gap between the B-ring and the Cassini Division.

TITAN
		Titan is the largest of Saturn's satellites.  It is the
second largest satellite in the solar system, and the only one
know to have a dense atmosphere.
		It may be the most interesting body, from a terrestrial
perspective, in the solar system.  For almost two decades, space
scientists have searched for clues to the primeval Earth.  The
chemistry in Titan's atmosphere may be similar to what occurred
in Earth's atmosphere several billion years ago.
		Because of its thick, opaque atmosphere, astronomers
believed Titan was the largest satellite in the solar system. 
Their measurements were necessarily limited to the cloud tops. 
Voyager 1's close approach and diametric radio occultation show
Titan's surface diameter is only 5,150 kilometers (3,200 miles) -
- slightly smaller than Ganymede, Jupiter's largest satellite. 
Both are larger than Mercury.  Titan's density appears to be
about twice that of water ice; it may be composed of nearly equal
amounts of rock and ice.
		Titan's surface cannot be seen in any Voyager photos;
it is hidden by a dense, photochemical haze whose main layer is
about 300 kilometers (200 miles) above Titan's surface.  Several
distinct, detached haze layers can be seen above the opaque haze
layer.  The haze layers merge with the main layer over the north
pole of Titan, forming what scientists first thought was a dark
hood.  The hood was found, under the better viewing conditions of
Voyager 2, to be a dark ring around the pole.  The southernhemisphere is slightly brighter than the northern, possibly the
result of seasonal effects.  When the Voyagers flew past, the
season on Titan was the equivalent of mid-April and early May on
Earth, or early spring in the northern hemisphere and early fall
in the south.
		Atmospheric pressure near Titan's surface is about 1.6
bars, 60 percent greater than Earth's.  The atmosphere is mostly
nitrogen, also the major constituent of Earth's atmosphere.
		The surface temperature appears to be about 95 Kelvins
(-289 degrees Fahrenheit), only 4 Kelvins above the triple-point
temperature of methane.  Methane, however, appears to be below
its saturation pressure near Titan's surface; rivers and lakes of
methane probably don't exist, in spite of the tantalizing analogy
to water on Earth.  On the other hand, scientists believe lakes
of ethane exist, and methane is probably dissolved in the ethane. 
Titan's methane, through continuing photochemistry, is converted
to ethane, acetylene, ethylene, and (when combined with nitrogen)
hydrogen cyanide.  The last is an especially important molecule;
it is a building block of amino acids.  Titan's low temperature
undoubtedly inhibits more complex organic chemistry.
		Titan has no intrinsic magnetic field; therefore it has
no electrically conducting and convecting liquid core.  Its
interaction with Saturn's magnetosphere creates a magnetic wake
behind Titan.  The big satellite also serves as a source for both
neutral and charged hydrogen atoms in Saturn's magnetosphere.


NEW SATELLITES
		Before the first Voyager encounter, astronomers
believed Saturn had 11 satellites.  Now they know it has at least
17 and possibly more.  Three of the 17 were discovered by Voyager
1.  Three additional possible satellites have been identified in
imaging data since the Voyager 2 encounter.  (Three others were
discovered in ground-based observations.)
		The innermost satellite, Atlas, orbits near the outer
edge of the A-ring and is about 40 by 20 kilometers (25 by 15
miles) in size.  It was discovered in Voyager 1 images.
		The next satellite outward, Prometheus, shepherds the
inner edge of the F-ring and is about 140 by 100 by 80 kilometers
(90 by 60 by 50 miles).  Next is Pandora, outer shepherd of the
F-ring, 110 by 90 by 80 kilometers (70 by 55 by 50 miles).  Both
shepherds were found by Voyager 1.
		Next are Epimetheus and Janus, which share about the
same orbit -- 91,000 kilometers (56,600 miles) above the clouds. 
As they near each other, the satellites trade orbits (the outer
is about 50 kilometers, or 30 miles, farther from Saturn than the
inner).  Janus is 220 by 200 by 160 kilometers (140 by 125 by 100
miles), and Epimetheus is 140 by 120 by 100 kilometers (90 by 70
by 50 miles).  Both were discovered by ground-based observers.
		One new satellite, Helene, shares the orbit of Dione,
about 60 degrees ahead of its larger companion, and is called the
Dione Trojan.  It is about 36 by 32 by 30 kilometers (22 by 20 by
19 miles). Helene was discovered in ground-based photographs.
		Two more satellites are called the Tethys Trojans
because they circle Saturn in the same orbit as Tethys, about 60
degrees ahead of and behind that body.  They are Telesto (the
leading Trojan) and Calypso (the trailing Trojan).  Both were
found in 1981 among ground-based observations made in 1980. 
Telesto is 34 by 28 by 26 kilometers (21 by 17 by 16 miles) and
Calypso is 34 by 22 by 22 kilometers (21 by 14 by 14 miles).
		There are three unconfirmed satellites.  One circles
Saturn in the orbit of Dione, a second is located between the
orbits of Tethys and Dione, and the third, between Dione and
Rhea.  All three were found in Voyager photographs, but were not
confirmed by more than one sighting.
OTHER SATELLITES
		Mimas, Enceladus, Tethys, Dione, and Rhea are
approximately spherical in shape and appear to be composed mostly
of water ice.  Enceladus reflects almost 100 percent of the
sunlight that strikes it.  All five satellites represent a size
range that had not been explored before.
		Mimas, Tethys, Dione, and Rhea are all cratered;
Enceladus appears to have by far the most active surface of any
satellite in the system (with the possible exception of Titan,
whose surface was not photographed).  At least five types of
terrain have been identified on Enceladus.  Although craters can
be seen across portions of its surface, the lack of craters in
other areas implies an age less than a few hundred million years
for the youngest regions.  It seems likely that parts of the

surface are still undergoing change, since some areas are covered
by ridged plains with no evidence of cratering down to the limit
of resolution of Voyager 2's cameras (2 kilometers or 1.2 miles). 
A pattern of linear faults crisscrosses other areas.  It is not
likely that a satellite as small as Enceladus could have enough
radioactive material to produce the modification.  A more likely
source of heating appears to be tidal interaction with Saturn,
caused by perturbations in Enceladus' orbit by Dione (like
Jupiter's satellite Io).  Theories of tidal heating do not
predict generation of enough energy to explain all the heating
that must have occurred.  Because it reflects so much sunlight,
Enceladus' current surface temperature is only 72 Kelvins (-330
degrees Fahrenheit).
		Photos of Mimas show a huge impact crater.  The crater,
named Herschel, is 130 kilometers (80 miles) wide, one-third the
diameter of Mimas.  Herschel is 10 kilometers (6 miles) deep,
with a central mountain almost as high as Mount Everest on Earth.
		Photos of Tethys taken by Voyager 2 show an even larger
impact crater, named Odysseus, nearly one-third the diameter of
Tethys and larger than Mimas.  In contrast to Mimas' Herschel,
the floor of Odysseus returned to about the original shape of the
surface, most likely a result of Tethys' larger gravity and the
relative fluidity of water ice.  A gigantic fracture covers
three-fourths of Tethys' circumference.  The fissure is about the
size scientists would predict if Tethys were once fluid and its
crust hardened before the interior, although the expansion of theinterior due to freezing would not be expected to cause only one
large crack.  The canyon has been named Ithaca Chasma.  Tethys'
surface temperature is 86 Kelvins (-305 degrees Fahrenheit).
		Hyperion shows no evidence of internal activity.  Its
irregular shape causes an unusual phenomenon:  Each time Hyperion
passes Titan, the larger satellite's gravity gives Hyperion a tug
and it tumbles erratically, changing orientation.  The irregular
shape of Hyperion and evidence of bombardment by meteors make it
appear to be the oldest surface in the Saturn system.
		Iapetus has long been known to have large differences
in surface brightness.  Brightness of the surface material on the
trailing side has been measured at 50 percent, while material on
the leading side reflects only 5 percent of the sunlight.  Most
dark material is distributed in a pattern directly centered on
the leading surface, causing conjecture that dark material in
orbit around Saturn was swept up by Iapetus.  The trailing face
of Iapetus, however, has craters with dark floors.  That implies
that the dark material originated in the satellite's interior. 
It is possible that the dark material on the leading hemisphere
was exposed by ablation (erosion) of a thin, overlying, bright
surface covering.
		Voyager 2 photographed Phoebe after passing Saturn. 
Phoebe orbits Saturn in a retrograde direction (opposite to the
direction of the other satellites' orbits) in a plane much closer
to the ecliptic than to Saturn's equatorial plane.  Voyager 2
found that Phoebe has a roughly circular shape, and reflects

about 6 percent of the sunlight.  It also is quite red.  Phoebe
rotates on its axis about once in nine hours.  Thus, unlike the
other Saturnian satellites (except Hyperion), it does not always
show the same face to the planet.  If, as scientists believe,
Phoebe is a captured asteroid with its composition unmodified
since its formation in the outer solar system, it is the first
such object that has been photographed at close enough range to
show shape and surface brightness.
		Both Dione and Rhea have bright, wispy streaks that
stand out against an already-bright surface.  The streaks are
probably the results of ice that evolved from the interior along
fractures in the crust.
THE MAGNETOSPHERE
		The size of Saturn's magnetosphere is determined by
external pressure of the solar wind.  When Voyager 2 entered the
magnetosphere, the solar-wind pressure was high and the magneto-
sphere extended only 19 Saturn radii (1.1 million kilometers or
712,000 miles) in the Sun's direction.  Several hours later,
however, the solar-wind pressure dropped and Saturn's magneto-
sphere ballooned outward over a six-hour period.  It apparently
remained inflated for at least three days, since it was 70
percent larger when Voyager 2 crossed the magnetic boundary on
the outbound leg.
		Unlike all the other planets whose magnetic fields have
been measured, Saturn's field is tipped less than one degree
relative to the rotation poles.  That rare alignment was firstmeasured by Pioneer 11 in 1979 and was later confirmed by
Voyagers 1 and 2.
		Several distinct regions have been identified within
Saturn's magnetosphere.  Inside about 400,000 kilometers (250,000
miles) there is a torus of H+ and O+ ions, probably originating
from water ice sputtered from the surfaces of Dione and Tethys. 
(The ions are positively charged atoms of hydrogen and oxygen
that have lost one electron.)  Strong plasma-wave emissions
appear to be associated with the inner torus.
		At the outer regions of the inner torus some ions have
been accelerated to high velocities.  In terms of temperatures,
such velocities correspond to 400 million to 500 million Kelvins
(700 to 900 million degrees Fahrenheit).
		Outside the inner torus is a thick sheet of plasma that
extends out to about 1 million kilometers (600,000 miles).  The
source for material in the outer plasma sheet is probably
Saturn's ionosphere, Titan's atmosphere, and the neutral hydrogen
torus that surrounds Titan between 500,000 kilometers (300,000
miles) and 1.5 million kilometers (1 million miles).
		Radio emissions from Saturn had changed between the
encounters of Voyager 1 and 2.  Voyager 2 detected Jupiter's
magnetotail as the spacecraft approached Saturn in the winter and
early spring of 1981.  Son afterward, when Saturn was believed to
be bathed in the Jovian magnetotail, the ringed planet's
kilometric radio emissions were undetectable.
		During portions of Voyager 2's Saturn encounter,

kilometric radio emissions again were not detected.  The
observations are consistent with Saturn's being immersed in
Jupiter's magnetotail, as was also the apparent reduction in
solar-wind pressure mentioned earlier, although Voyager
scientists say they have no direct evidence that those effects
were caused by Jupiter's magnetotail.
                              #####
5/4/90DB
