by: William Mann MD
Univ of North Dakota School of Medicine



PREMENSTRUAL SYNDROME

Case History

An unemployed  nulliparous 19-year-old woman was arrested for stabbing
her boyfriend while intoxicated.  Menarche was at 13 years, and she had
been well with no behavioral problem until l5, when she began to
exhibit paroxysmal aberrant behavior including: slashing her wrists,
shoplifting, arson, promiscuity, alcohol intoxication, expulsion from
school for assaulting teachers, and mutilation of her hands and feet
with cuts and cigarette burns. In prison, prior to her next four
menstrual periods, she assaulted a guard, tried to hang herself, cut her
wrists, and attempted to escape.  During the rest of her cycle, she was
cooperative, rational, and penitent.  All past episodes of aberrant
behavior which could be accurately dated, occurred on a cycle length of
29+- 2.5 days.


Initially in prison she was treated with Chlorpromazine 100mg bid and
fluphenazine injections 20 mg every 10 days.  She stated that she felt
a little calmer, but depressed, with continued cyclic suicidal impulses
and a wish to "escape from life".  On several occasions during the
premenstruum she requested that she be locked up alone and expressed
fear that she was going to lose control.

She was started on medroxyprogesterone 10 mg qd on day 22 of each cycle,
and for the past two years has been free of premenstrual behavior
changes, with only mild symptoms of restlessness and bloating.  She is
now working full time and married.

Definition

Premenstrual Syndrome is any combination of symptoms and signs occurring
cyclically prior to menses and resolving with the onset of menses.

Clinical Presentation

Subjective

The commonest symptoms are related to mood; - depression, irritability,
tension, lability, lassitude, insomnia and impulsivity; to body fluid
changes; - edema, weight gain, abdominal bloating, and breast fullness;
and to physical discomfort - headache, breast pain, abdominal pain or
generalized physical dysphoria.

Polydipsia, polyphagia, diarrhea and acne are also common.
Pre-existing physical and emotional problems may be exacerbated.

Objective

Weight gain is common, but so is weight loss, and affect changes may be
apparent in familiar patients.  Laboratory investigations are not
generally helpful.

Clinical Management

Assessment

Almost all women report some premenstrual symptoms.  It is essential to
differentiate between those who find their symptoms tolerable, and
those who consider themselves ill and who have distressing symptoms and
impaired functional capacity.  It is also important to assess any
exacerbation of ongoing health problems.  The specific symptoms most
troublesome to the patient and their severity guide rational therapy.

Mechanisms

The large number of theoretical models of the biochemical basis of PMS
reflect the fragile, incomplete understanding of the problem and the
complexity of its causative mechanisms. Likewise, the large number of
recommended treatments, none of which are consistently effective,
suggest a multiplicity of mechanisms with variable expression from
patient to patient.  In general terms, PMS seems to represent protean
manifestations of psycho-neuro-endocrine flux, or dysfunction in the
cycling of the hypothalamic-pituitary-ovarian axis.  Particular
symptoms suggest a role for specific mediators and provide some
rationale for management of individual cases.


Estrogen effects sodium and water retention, and in addition alters the
metabolism of plasma renin and angiotesin II with a resultant increase
in Aldosterone

Progesterone has a natriuretic effect, but also increases aldosterone
activity.  PMS symptoms do not occur when physiologic progesterone
levels are low in the pre-ovulatory phase and anovulatory cycles.
Paradoxically, progesterone frequently is effective treatment.
Although excreted levels of estrogren and progesterone are not
measurably abnormal, an imbalance of estrogen/progesterone is a
currently favored hypothesis.  Further confusing this is the
observation that as many patients are made worse as are made better
with OCs.

Prolactin and vasopressin secretion may play a role in breast and fluid
balance changes, and although plasma levels have not correlated with
symptoms, normal bromocriptine has been beneficial, as have ergot
alkaloids.

Changes in central catecholamines (dopamine, norepinephrine, and
epinephrine) may play a role in affective and fluid balance changes.

The measurable changes in other pituitary products - alpha MSH,GH,LH,
FSH and Beta endorphin - which occur premenstrually probably contribute
to the complexity of PMS.

Numerous clinical therapeutic trials have been provoked by such
possible causal associations as Vitamin B6 with abnormal tryptophan
metabolism and estrogen metabolism, by the anti-estrogenic effect of
Vitamin A, and its effect on acne, by possible allergy to endogenous
progresterone, and by catharsis as a means of eliminating fluid and
unspecified toxin in constipated patients.

Plans

The goal of therapy is to reduce symptoms to a level which is tolerable
to the patient and which does not impair her function.  Treatment
should be aimed at the specifically troublesome symptoms, and frequent
follow up should gauge the effect on these symptoms and the patient's
improvement in function.  Treatment should be carefully matched to the
patient's distress, as many suggested therapies have significant
toxicity.

Documented weight gain can be rationally approached with spironolactone
25-50 mg b-tid, and if this fails, hydrochlorothiazide, 25-50 mg qd.

Headache, mastalgia, and generalized discomfort may be relieved with
mild analgesics, and NSAIDs may be particularly useful with patients
who also suffer from dysmenorrhea.

Non-specific measures such as local heat, rest, and sodium restriction
may be helpful, as may exercise and weight loss which, in theory, may
have a beneficial effect on estrogen metabolism.

In patients with sleep disturbance and depression, tricyclics and
occasionally lithium may be indicated.

Bellergal, a combination of ergot, phenobarbitol, and belladonna, is a
non-specific but frequently useful treatment for patients with
irritability, breast tenderness, and abdominal bloating.  Except in low
dose for occasional use, tranquilizers are best avoided as they are
entirely non-specific, even though they will reduce any patient's
complaints about most symptoms.

Medroxy progesterone 10 mg daily during the symptomatic days, and
progesterone suppositories are very frequently effective.  The estrogen
antagonist methyltestosterone is very effective, but rarely, if ever,
indicated.  Bromocriptine counteracts the osmoregulatory actions and
breast stimulation of prolactin, but also has numerous poorly
understood actions in the pituitary hyopthalamus and basal ganglia.

Follow Up

The fine adjustment of treatment against symptoms can generally be
achieved in a few monthly visits.


Education

Explanation that PMS is not pathologic, accompanied by support from the
physician and from acquaintances with PMS is very helpful.  The patient
should understand the goals of treatment and be given the
responsibility for adjustment of therapy.

Epidmiology

Most women suffer some symptoms of PMS, and at least a third report
significant incapacity.  Psychiatric disturbance, crime and accidents
are more frequent during the premenstrual period but still less
frequent than the noncycling base line for males.  The data, then, may
suggest that women deteriorate toward the male level of functioning
during the premenstrual period, or conversely that women have a
syndrome of functional improvement during the rest of the cycle, with
fewer seizures, fewer symptoms, less aberrant behavior, increased
energy and self-esteem, and improved mood.

Costs

The very significant costs of functional disability, interpersonal
discord, and personal distress may be greatly ameliorated with
education, support, and carefully adjusted symptomatic treatment.

Learning Issues

In managing a problem with no consistent physical signs or laboratory
abnormalities, it is essential to make an accurate assessment of the
patient's function and symptomatic distress, to tailor treatment to
these, and to set and move toward appropriate goals together with the
patient.



References

Premenstrual Syndrome, Editorial; Lancet; December 1981, 1393-94.

Reid, R.L. and Yen, S.S.C. Premenstrual Syndrome; American Journal of
Obstetrics and Gynecology; 139; 85-104. 1981.

Elsner, C.W., et.al.  Bromocriptine in the Treatment of Premenstrual
Tension Syndrome, Obstetrics and Gynecology; 56, 6; 723-26.  1980.
in the pre-ovulatory phase and anovulatory cycles.
Paradoxically, progesterone frequently is effective treatment.
Although excreted levels of estrogren and progesterone are not
measurably abnormal, an imbalance of estrogen/progesterone is a
currently f