
     BROADCAST SERVICE PIONEERS: POLICIES AND STATIONS	Thomas H. White
							September 1, 1987



Despite extensive interest about the formation of the American broadcasting
service and its pioneering members, there has been a dearth of information
about a number of fundamental topics.  This is designed as an overview and
reference source for some of the neglected areas, spotlighting the period
through May of 1922.

FORMATION OF THE BROADCASTING SERVICE

The formal inauguration of the broadcasting service took place in September of
1921 (1), with the assignment of two wavelengths:  360 meters (833 kiloHertz)
for entertainment, defined as "news, concerts, lectures, and such matter", and
485 meters (618 kiloHertz) for "crop reports and weather forecasts".  The use
of two different wavelengths reflected the department practice of segregating
different activities on different wavelengths.	Individual station
authorizations were issued for either or both of the wavelengths, depending on
the service the station provided.  Although broadcasting activities had been
evolving for more than a decade, this allocation was the first to designate
stations stations specifically licensed for, and restricted to, public
broadcasting, using wavelengths exclusively set aside for the broadcasting
service.

The choice of these two wavelengths was apparently ratification of previous
practice.  Two stations, operated by the Westinghouse Electric and
Manufacturing Company, already held licenses authorizing radiophone operation
on 360 meters:	KDKA, East Pittsburgh, Pennsylvania, which received its initial
license October 27, 1920 and began daily transmissions with election returns on
November 2, 1920, and WJZ, Newark, New Jersey, which received its initial
authorization in May of 1921, but did not begin regular broadcasts until the
first of October.  (3) Westinghouse officials had specifically requested the
use of 360 meters to avoid interference from other services, (4) and the
wavelength apparently had never been previously used.  (5)

The status of the other broadcasting wavelength, 485 meters, prior to its
assignment to the broadcasting service, is less clear.	However, an
experimental station, 5XD, operated by the New Mexico State College in State
College, New Mexico, is reported to have used it for transmitting telegraphic
"time signals, weather reports, and news items", and then, beginning in early
1920, for voice transmissions including music and educational talks.  (6)

LICENSING POLICIES AND PROCEDURES

At the time of the creation of the broadcasting service, licensing was
conducted under the provisions of the Radio Act of 1912.  Although the standard
since the 1927 formation of the Federal Radio Commission has been that stations
serve the "public convenience, interest, or necessity", (7), no comparable
guideline was mandated by the 1912 act, and licensing of the pioneer broadcast
service stations amounted to little more than registration.  Licensing
authority at the time of the creation of the broadcasting service was vested in
the Secretary of Commerce, and exercised through the Bureau of Navigation.
This body operated on a much more informal basis than successor regulators.
Moreover, control was much more decentralized, with oversight, performed
primarily by regional Radio Inspectors, generally limited to insuring that
stations met technical standards.  (8)

The standard procedure for procuring a broadcast license in the early twenties
was as follows:  the prospective station operator filled out an "Applicant's
Description of Apparatus" (Form 761), obtained from the region's Radio
Inspector.(9) The completed form, which provided mostly technical information,
was submitted to the inspector, who, if deemed necessary, inspected the
proposed apparatus.  Next the form, including the inspection report plus a
recommendation on the type of authorization to be issused, was forwarded to the
Commissioner of Navigation in Washington, D.C.	(10)

Here two distinct steps were taken:  first call letters were assigned to the
application, then, if everything was in order, a formal operating authorization
was issued.  The period between the assignment of call letters and formal
authorization ranged from immediate action to as much as forty days, and
according to Commerce records was usually in the range of one to three days.

The assignment of a call sign, usually recorded in the files as taking place
when the Form 761 was received, was not considered as establishing a station.
New stations were not reported in the RADIO SERVICE BULLETIN until the first
operating authorization--usually a license but in a few cases a preliminary
telephoned or telegraphed authorization--was issued.  (11)

License periods for broadcasting stations ranged from as few as ten days (12)
to one year, with one year licenses the norm for grants made until early
January, 1922, six months the standard during mid-January, 1922, and three
months the norm thereafter.  License renewal was obtained via the submission of
an updated Form 761 at the required intervals.

The above covers the standard and normally used procedures, although Commerce
files report the process was speeded in a few special cases by direct letters,
telegrams, and telephone conversations between applicants and Washington
officials.

STATION DELETIONS

Station deletions in the early twenties were performed with even less formality
and consistency than licensing.  When a station discontinued broadcasting
before the end of a license period, the station operator could return the
license for cancellation.  However, it appears that in most cases the station
owners didn't bother--instead they just let the licenses expire in due course.
Moreover, the lapse of a station license was seen as no more the the close of
an operating authorization, and rarely resulted in immediate deletion from the
official station lists.  Generally a grace period was allowed, on the
assumption that many would eventually received another license.

The timespan between the expiration of a license and formal deletion varied
greatly, and according to Commerce files most stations were not removed from
the published lists until one to six months after their operating licenses had
lapsed.  The whole process has a distinct "we'll delete them when we get around
to it" feel, and appears to have been to some degree dependent on the diligence
of the district Radio Inspectors.(13) Because of the flexible deletion
practices, the number of stations deleted in a given month is by no means a
precise barometer of the decline in activity for that month, as the licenses
for many of these stations had in fact expired a number of weeks or months
previously.  Likewise, official lists of this period invariably include
stations no longer holding active licenses, and merely awaiting formal removal.

TEMPORARY STATIONS

One category of broadcasting stations has been almost completely
undocumented--that of temporary grants.  These were issued for special
occasions, usually lasting a month or less, and were not reported in the RADIO
SERVICE BULLETIN.  There is very little detailed information about these grants
recorded in the Commerce files, although at least seventy were issued in the
period from January, 1922 to October, 1928.  For temporary grants made through
May, 1922, where wavelength information is recorded, the wavelength assigned
was always 360 meters.(14) Detailed histories for five temporary stations
operated by educational organizations can be found in EDUCATION'S OWN
STATIONS.(15)

Listed below are the fifteen stations listed in Commerce files as receiving
temporary grants for the period through the end of May, 1922.  Commerce records
for these stations are minimal, and as there is apparent source of additional
information, save for those stations documented in EDUCATION'S OWN STATIONS,
there can be no guarantee of completeness.


     TEMPORARY BROADCAST STATION GRANTS THROUGH MAY, 1922
     ----------------------------------------------------
     1st Air  Call
      date    Assign  Call  Location	     Grantee/notes
     -------  ------  ----  --------	     -------------
      1/--    1/20    WPU   Buffalo, NY      Buffalo Courier and Enquirer
      2/--    2/2     KDP   Seattle, WA      Saint James Cathedral
      2/23    2/22    WHO   Kansas City, MO  Kansas City Post (2 days)
      3/--    3/1     WWS   Pella, IA	     Fowler Telephone Company
      3/10    3/--    WBI   Marquette, MI    Northern State Normal School
					     (2 days)
      3/16    3/6     WTB   Evansville, IN   Sieffert Electric Company
      3/--    3/10    WSH   New York, NY     Experiment Information
					     Service (2 days)
      3/23    3/20    WMX   Port Huron, MI   Port Huron Times Herald
					     (also for 3/27/22)
      3/27    3/9     WTA   Uhrichsville, OH Board of Trade
      3/--    3/27    WDS   Richmond, VA     Mann S. Valentine
      4/16    4/15    WAAT  Jersey City, NJ  Jersey Review (also 4/19/22)
      4/16    4/15    WAAU  Philadelphia, PA H. C. Kuser
      4/28    4/18    WBAC  Des Moines, IA   Kiwanas Club (2 days, also
					     for 2 days starting 4/28/23)
      5/13    5/5     WCAI  Topeka, KS	     American Legion
      5/--    5/31    WEAL  Des Moines, IA   Mystic Shrine, special train
					    "to coast and back"


CALL LETTER POLICIES

One area which has been particularly murky is that of call letter policies.
Following the adoption of the "Radio Act of 1912", call signs for most
non-amateur services were composed of three letters.(16) Because most early
commercial land stations were clustered along the coast, the original policy
for land stations was that those on the Pacific coast were normally assigned
calls starting with K, while calls starting with W were normally assigned to
outlets along the Great Lakes and the Atlantic and Pacific coasts.(17)

With the development of inland services, further refinements were required.  As
land stations, broadcasters have generally followed the "K's in the West, W's
in the East" standard.  However, two different East-West dividing lines have
been used.  Originally the boundary ran along the eastern borders of Montana,
Wyoming, Colorado, and New Mexico.  It was only in late January, 1923 that the
line was shifted to the current standard of the Mississippi River.

The rapid expansion of the ship service during World War One required
utilization of four-letter calls for ship stations, including, in alphabetical
order, calls from the KE--, KI--, KO--, KU--, and, starting June, 1920, KD--
blocks.  (Land stations continued to generally receive three-letter calls.) The
assignment of the conspicuous call KDKA to the pioneer East Pittsburgh
broadcaster has been viewed as evidence of some sort of special status.
However, review of the RADIO SERVICE BULLETIN shows what actually occurred was
more mundane.  For some reason, during the period of June, 1920 through April,
1921 most commercial land stations received calls from the four letter ship
blocks, and by nothing more significant than coincidence KDKA was the only
broadcaster to be born in this period.(18)

The policy of three-letter calls for land stations was restored after this
lapse, until the flood of broadcasting grants required that the broadcasting
service switch to four-letter calls, with Western broadcasting stations sharing
the KD--, and later KF-- and KG-- blocks with ship stations, while Eastern
broadcasters were assigned calls from the W-A-, and later W-B-, blocks.  Some
stations received calls outside these blocks due to special requests, and
eventually individual call requests became the norm.

Call letter "combinations which, for various reasons, international, national,
local, or individual may be objectionable" (19) were avoided.  Accordingly, in
this period it was apparently decided that "WDAM" might be considered
objectionable, as Commerce records show that the assignment of this particular
call to a Western Electric Company station in New York City was changed after
ten days, with the call WEAF substituted.  (This station is now WNBC.)

CRITIQUE OF PERIOD SOURCES

While preparing the chronological list of station activity some idiosyncracies
of three traditional sources of licensing information became apparent.	The
best generally available source of information for the early twenties is the
RADIO SERVICE BULLETIN, issued by the Bureau of Navigation, which reported
monthly the changes, deletions, and new station grants made during the
preceding month.  Three important characteristics of the Bulletin have
sometimes been overlooked.  The first is that its station lists do not report
chronologically the grants within a given month, as the Bulletin lists always
used non-chronological formats, such as alphabetically by city of license or
call sign.  Second, a few stations entered the broadcasting service
classification by metamorphosis from another service category, so their debuts
are recorded in the "alterations and corrections" lists, rather than the new
station lists which herald the appearance of more conventional entrants to the
service.  This alternate route was used by three stations in the period through
May, 1922:  KQV, Pittsburgh, Pennsylvania; KDPT, San Diego, California; and
WRR, Dallas, Texas.  Third, broadcasting station additions, changes, and
deletions were not reported in a separate category until the July 1, 1922
issue.	Prior to this date they were intermixed with the other classes of
"commercial land stations", so care must be taken in extracting broadcast
service information.

The Bulletin was not completely free from occasional typographical errors--for
example, in the January 2, 1922 issue both KJB, Everett, Washington and KFL,
Seattle, Washington are incorrectly listed as being broadcast grants, and one
station, WGI (later WARC), Medford Hillside, Massachusetts, seems to have
disappeared without benefit of official notification.  However, overall there
were only a few minor discrepancies betweeen information contained in the
Bulletin, and that found in government records.

Another source of licensing information proved somewhat more suspect.  W.  E.
Downey, Supervisor of Radio at the Department of Commerce, appears to have
regularly provided monthly totals of broadcasting station additions, deletions,
and outstanding authorizations.(20) As seen in the listing below there are a
number of discrepancies, for the period through May, 1922, between the monthly
figures reported by Downey, and the information contained in Commerce records
and the RADIO SERVICE BULLETIN.(21)



	    W.E Downey Figures		      Research Figures
	    ------------------		      -----------------
     Month  New Deleted Increase Total	      New Deleted Increase Total
     -----  --------------------------	      --------------------------
     1921
     Sept    3	   ..	    3	   3	       4*     ..      4      4
     Oct     1	   ..	    1	   4	       3      ..      3      7
     Nov     1	   ..	    1	   5	       2**    ..      2      9
     Dec    23	   ..	   23	  28	      20      .      20     29

     1922
     Jan     8	   ..	    8	  36	       9      ..      9     38
     Feb    24	   ..	   24	  60	      23      ..     23     61
     Mar    77	   ..	   77	 137	      79       2     77    138
     Apr    76	   ..	   76	 213	      83      ..     83    221
     May    97	   ..	   97	 310	      96       5     91    312

					  * includes WJZ ** includes KDKA


The most troubling feature about the Downey figures is the complete absence of
deletions.  In fact, Downey reports no deletions until September of 1922.
However, review of the Commerce records and the RADIO SERVICE BULLETIN clearly
shows that fifteen stations were deleted prior to September, beginning with two
in March.  Since the Downey figures do not list specific stations, the cause of
the differences is not readily apparent.

Finally, the new station totals appearing in Gleason Archer's HISTORY OF RADIO
TO 1926 (22) have a readily identifiable flaw.	Archer's figures are inflated,
because they are actually the number of new "commercial land stations" reported
monthly by the RADIO SERVICE BULLETIN.	As noted earlier, this means the
figures erroneously include many non-broadcast service grants, and also omit a
few transfers to the broadcast service that were reported in the change lists.

BROADCAST SERVICE ACTIVITY LIST

Presented at the close is a chronological list of broadcasting service activity
for all non-temporary stations from October, 1920 to the close of May, 1922.

Most of the actions are new station grants.  The information for new grants is
organized according to the headers appearing at the top of each page.  The
additions are listed by their initial broadcasting service authorization
date--normally the date of the first broadcast service license.  "LIC" refers
to the standard case where the first broadcast authorization was the licensing
of a new station.  "TRN" denotes stations whose first broadcast license was a
transfer from a non-broadcast service classification, using the same call sign.
"REL" refers to the relicensing of a previously deleted broadcast station.  In
a few cases an authorization to broadcast was made before the first license was
issued.  Initial authorizations by telephone and telegraph are denoted "TP" and
"TG" respectively.  "STA" stands for a "Special Temporary Authorization", while
"AUT" appears for one station where the records merely list it as "authorized".

Included with the initial authorization date is the call sign, city of license,
and station owner, plus frequency assigned.  "E" stands for the entertainment
wavelength of 360 meters (833 KiloHertz), and "M" denotes the market and
weather wavelength of 485 meters (618 kiloHertz).

The next column covers the call letter assignment information, which as noted
earlier was a part of the application process, and took place prior to the
issuance of an operating authorization.  The three entries here are the date of
the call assignment, the form of the request, and the origin of the request.
In most cases the standard procedure was followed, with the application process
begun with the receipt of a Form 761 from a regional Radio Inspector.  The nine
radio inspection districts were headquartered in the following locations:

	    1. Boston, Massachusetts	6. San Francisco, California
	    2. New York, New York	7. Seattle, Washington
	    3. Baltimore, Maryland	8. Detroit, Michigan
	    4. Savannah, Georgia	9. Chicago, Illinois
	    5. New Orleans, Louisiana

In addition, a few of the Form 761s came via Norfolk, Virginia.

Most exceptions to the standard procedure occurred when the station owners
("OWN") dealt directly with Washington, via telephone ("TP"), telegraph ("TG"),
letter ("LET"), or call letter reservation ("RES").  In one case W.  E.  Downey
("WED") was listed as the person involved in making the call assignment.

The next column notes the date of the first broadcast service license and the
duration of that initial license.  The final "status" column lists the eventual
fate of the station--either its deletion date (with call sign if different from
the original) or status as of September 1, 1987.

When only the month of an action is known, usually reflecting data derived from
the RADIO SERVICE BULLETIN, two dashes appear for the day the action took
place.	A "(?)" marks a "best guess" required because of incomplete or
ambigious information, which in most cases should not be more than a few days
off.  As might be expected, some errors, both in the original records and
during the research process, must be assumed to have crept in.	However,
extensive cross-referencing of original records and other source material
should insure that errors have been minimalized.  Moreover, it is certain that
these 319 grants comprise the complete roster of non-temporary broadcasting
authorizations issued during this period.

The one entry which must be viewed with due caution is that of current status.
Unlike human beings, which have clearly defined births, lives, and deaths,
these stations sometimes had very complicated histories, complete with
resurrections, call sign and ownership changes, consolidations of two or more
stations under a single call, and facility exchanges.  Review of the station
histories in EDUCATION'S OWN STATIONS will give a good idea of the tumultuous
histories some of these stations enjoyed.  This caveat nowithstanding, the
status information was included to provide a feel for the outcome of these
stations as a class, even though a few station histories are really too tangled
to allow refinement to a single entry.	One general standard for status column
entries was that, in case of doubt, the nod was given to interpretations which
provide continuity and longevity.  In particular, stations which were deleted
but then immediately relicensed were treated as having a single unbroken
lifespan, so deletion dates are those where the final unreversed deletion took
place, and stations still active might have been deleted and relicensed
somewhere along the way.

SUMMARY

The information presented will hopefully provide a more complete understanding
of the policies of the period, and permit more detailed analysis of the
development of the broadcast service.  For instance, the chronological list of
new broadcast station grants clearly shows the abrupt shift from the slow
initial expansion of the service though November of 1921, with the grand total
of nine grants dominated by notheastern and midwestern radio equipment firms,
to the popular expansion that began in December of 1921, when owners of all
kinds sponsored stations.  In fact, this popularization has every appearance of
a rapidly spreading West Coast fad, as fully sixteen of the twenty-two grants
made from December, 1921 to January 4, 1922 were for West Coast facilities.

NOTES ON SOURCES

The original card files for broadcasting stations, maintained by the Commerce
Department, comprised the basic source of station information through the
period up to the March, 1927 assumption of regulatory authority by the Federal
Radio Commission.  [NOTE:  A major componant of the Commerce files used for
this research no longer exists.  The nature of the Ownership card files, which
held licensee and license date data, was apparantly misunderstood, and
according to FCC employee Mary McDonald these files were declared in August,
1987 to be "no longer needed" and destroyed].  Information from that point
forward is included in the Federal Communications Commission station card
files.	Both sets of cards are currently available through the Mass Media
Bureau of the Federal Communica- tions Commission, and as of September, 1987
obtainable from the Public Reference Room located on the second floor of 1919 M
Street, Northwest, Washington, D.  C.

Information from the basic resources was double-checked against a number of
sources, the most important being the grant, deletion, and cumulative station
lists appearing in the RADIO SERVICE BULLETIN, the original station licenses
and 761 Forms archived at the Washington National Records Center in Suitland,
Maryland, and an undated "List of First Stations Licensed for Broadcasting"
(through March, 1922, with a few omissions), which was prepared by FCC
personnel, but had no additional identification, and was obtained through the
Broadcast Pioneers Library in Washington, D.  C.

     NOTES:

(1) Gleason L.	Archer, HISTORY OF RADIO TO 1926, (New York, NY, American
Historical Society, 1938), p.  215-216

(2) United States Department of Commerce, Bureau of Navigation, "Amendments to
Regulations", RADIO SERVICE BULLETIN (No.  57), January 3, 1922, (Washington,
DC, Government Printing Office, 1922), p.  10

(3) Gleason L.	Archer, HISTORY OF RADIO TO 1926, (New York, NY, American
Historical Society, 1938), p.  203, 208, 217

(4) Eric Barnouw, A HISTORY OF BROADCASTING IN THE UNITED STATES, volume 1, A
Tower in Babel (New York, Oxford University Press, 1966), p.  69

(5) KDKA and WJZ did not receive broadcasting service licenses until November
7, 1921 and September 30, 1921 respectively.  However, these two stations are
considered for the purposes of this review to mark the start of the broadcast
service, and unless otherwise noted are listed according to their initial 360
meter grants.

(6) S.	E.  Frost, EDUCATION'S OWN STATIONS, (Chicago, IL, University of
Chicago Press, 1937), p.  246

(7) "The Radio Act of 1927", section 9, and the "Communications Act of 1934",
section 307(a)

(8) Eric Barnouw, A HISTORY OF BROADCASTING IN THE UNITED STATES, volume 1, A
Tower in Babel (New York, Oxford University Press, 1966), p.  95

(9) The United States was divided into nine Radio Inspection Districts, with
the region's Radio Inspector headquartered at a major port of each district.
United States Department of Commerce, Bureau of Navigation, "Radio
Broadcasting", RADIO SERVICE BULLETIN (No.  60), April 1, 1922, (Washington,
DC, Government Printing Office, 1922), p.  23

(10) Form 761 instructions; United States Department of Commerce, Bureau of
Navigation, "Radio Broadcasting", RADIO SERVICE BULLETIN (No.  60), April 1,
1922, (Washington, DC, Government Printing Office,1922), p.  23; C.  Joseph
Pusateri, ENTERPRISE IN RADIO:	WWL AND THE BUSINESS OF BROADCASTING,
(Washington, DC, University Press of America, Inc., 1980), p.  18-19, 24-25

(11) United States Department of Commerce, Bureau of Navigation, "Land Station
Licenses", RADIO SERVICE BULLETIN (No.  61), May 1, 1922, (Washington, DC,
Government Printing Office, 1922), p.  15

(12) The initial license for WDT, Ship Owner's Radio Service in New York, NY,
was for only ten days, as there was concern that the station might cause
interference.

(13) A number of station files refer to a letter from the Radio Inspector as
the impetus for deletion.

(14) The Radio Corporation of America's temporary grant for WJY, Hoboken, New
Jersey, used to report the Dempsey-Carpentier prize fight on July 2, 1921, is
not considered in this review to be part of the broadcasting service, as it
transmitted on the longwave wavelength of 1600 meters (187 kilohertz).

(15) The five review are:  Bancroft School, Haddonfield, NJ (WRAQ); Gardenville
High School, Gardenville, NY (WGHS); Gettysburg College, Gettysburg, PA (WDBG);
Milton College, Milton, WI (WSAM); and Northern State Normal School, Marquette,
MI, (WBI).

(16) Government stations received calls starting with N, and until October,
1928, when W and K prefixes were added, amateur and special land stations had
calls composed of the district number followed by two or three letters.

(17) United States Department of Commerce, Bureau of Navigation, RADIO STATIONS
OF THE UNITED STATES, July 1, 1914, (Washington, DC, Government Printing
Office, 1914), p.  6

(18) Two non-broadcast service stations first licensed during this period,
KDPM, Cleveland, OH, and KDPT, San Diego, CA, later transfered to the broadcast
service.  Both were eventually deleted.

(19) United States Department of Commerce, Bureau of Navigation, RADIO STATIONS
OF THE UNITED STATES, July 1, 1914, (Washington, DC, Government Printing
Office, 1914), p.  8

(20) Hiram L.  Jome, ECONOMICS OF THE RADIO INDUSTRY, (Chicago, A.  V.	Shaw
Company, 1925), p.  78 (through August, 1924), and "The Broadcast Hotel is
Overcrowded", Radio in the Home, April, 1925, (H.  M.  Neely Publishing
Company, Philadelphia, PA, 1925), p.  28 (through February 12, 1925)

(21) The research information is based on the list of broadcast service
activity appearing at the close.  This information agrees fully with that
appearing in the RADIO SERVICE BULLETIN, with the exception of three
stations--KFI, KOJ, and WBAZ--listed by the Bulletin as being April grants.
These stations are recorded in Commerce files with license dates of March 31st
for KFI, and May 1st for KOJ and WBAZ.

(22) Gleason L.  Archer, HISTORY OF RADIO TO 1926, (New York, NY, American
Historical Society, 1938), p.  241 (Monthly grant totals for August, 1921 to
May, 1922)

==============================================================================

BROADCAST PIONEERS:  STATION ACTIVITY LIST THROUGH MAY 31, 1922 Thomas H.
White Chronoligical list of the first 319 Broadcast Service authorizations,
including changes and deletions, for the period through May 31, 1922.
Companion to the review of policies and procedures in PION1.  Includes current
status of surviving stations.

Add#|1st Auth|Call|Location		 |Call Asgn|First Lic|
---------------------------------------------------------------------------
Type|Owner			    |Freq|Type|Loc |Duration |Status 9/1/87
===========================================================================

  1  10/27/20 KDKA East Pittsburgh, PA	  10/22/20  11/07/21  KDKA-1020
LIC  Westinghouse Elec & Mfg Co      E	  761  DET  1YR       Pittsburgh, PA

  2  05/--/21 WJZ  Newark, NJ		  --/--/--  09/30/21  WABC-770
LIC  Westinghouse Elec & Mfg Co      E	  ---  ---  ---       New York, NY

  3  09/15/21 WBZ  Springfield, MA	  --/--/--  09/15/22  WBZ-1030
LIC  Westinghouse Elec & Mfg Co      E	  ---  ---  3M	      Boston, MA

  4  09/19/21 WDY  Roselle Park, NJ	  09/16/21  09/19/21  DEL 02/20/23
LIC  Radio Corporation of America    E	  761  NYC  3M

  5  09/29/21 WCJ  New Haven, CT	  09/23/21  09/29/21  DEL 12/01/22
LIC  A. C. Gilbert Company	     E	  761  BOS  1YR

  6  10/13/21 KQL  Los Angeles, CA	  --/--/--  10/13/21  DEL 06/09/22
LIC  Arno A. Kluge		     E	  ---  ---  1YR

  7  10/13/21 WBL  Detroit, MI		  10/06/21  10/13/21  WWJ-950
LIC  Detroit News		     EM   761  DET  1YR       Detroit, MI

  8  10/13/21 WJX  New York, NY 	  10/05/21  10/13/21  DEL 06/--/24
LIC  De Forest Radio Telep & Teleg   E	  761  NYC  ---

  9  11/09/21 KYW  Chicago, IL		  11/09/21  11/15/21  KYW-1060
?TP  Westinghouse Elec & Mfg Co      E	  TP   CHI  1YR       Philadelphia, PA

 10  12/07/21 KWG  Stockton, CA 	  12/07/21  12/07/21  KWG-1230
LIC  Portable Wireless Telephone Co  E	  761  SF   1YR       Stockton, CA

 11  12/08/21 KDN  San Francisco, CA	  12/03/21  12/08/21  DEL 05/01/23
LIC  Leo J. Meyberg Company	     E	  761  SF   1YR

 12  12/08/21 KFC  Seattle, WA		  12/03/21  12/08/21  DEL 01/23/23
LIC  Northern Radio & Elec Company   E	  761  SEA  1YR

 13  12/08/21 KGB  San Francisco, CA	  --/--/--  12/08/21  DEL 03/23/22
LIC  Edwin L. Lorden		     E	  ---  ---  1YR

 14  12/08/21 KGC  Hollywood, CA	  --/--/--  12/08/21  KNX-1070
LIC  Electric Lighting Supply Co     E	  ---  ---  1YR       Los Angeles, CA

 15  12/08/21 WJH  Washington, DC	  12/03/21  12/08/21  DEL 03/26/24
LIC  White & Boyer Company	     E	  761  BAL  1YR

 16  12/09/21 KQW  San Jose, CA 	  12/07/21  12/09/21  KCBS-740
LIC  Charles D. Herrold 	     E	  761  SF   1YR       San Francisco, CA

 17  12/09/21 KVQ  Sacramento, CA	  12/07/21  12/09/21  DEL 01/02/23
LIC  J. C. Hobrecht		     E	  761  SF   1YR

 18  12/09/21 KYJ  Los Angeles, CA	  12/07/21  12/09/21  DEL 05/01/23
LIC  Leo J. Meyberg Company	     E	  761  SF   1YR

 19  12/09/21 KZC  Los Angeles, CA	  12/07/21  12/09/21  DEL 03/09/23 (KOG)
LIC  Western Radio Electric Company  E	  761  SF   1YR

 20  12/09/21 KZM  Oakland, CA		  12/07/21  12/09/21  DEL 06/23/31
LIC  Preston D. Allen		     E	  761  SF   1YR

 21  12/09/21 KZY  Oakland, CA		  12/07/21  12/09/21  DEL 01/24/23
LIC  Atlantic-Pacific Radio Suppl    E	  761  SF   1YR

 22  12/20/21 KJJ  Sunnyvale, CA	  12/16/21  12/20/21  DEL 06/16/23
LIC  The Radio Shop		     E	  761  SF   1YR

 23  12/20/21 KJQ  Stockton, CA 	  12/16/21  12/20/21  DEL 04/--/25 (?)
LIC  C. O. Gould		     E	  761  SF   1YR

 24  12/20/21 KYY  San Francisco, CA	  12/16/21  12/20/21  DEL 01/24/23
LIC  The Radio Telephone Shop	     E	  761  SF   1YR

 25  12/22/21 WDM  Washington, DC	  12/22/21  12/22/21  DEL 06/08/25
LIC  Church of the Covenant	     E	  761  BAL  30D

 26  12/22/21 WDT  New York, NY 	  12/22/21  12/22/21  DEL 12/28/23
LIC  Ship Owners Radio Service	     E	  761  NYC  10D

 27  12/22/21 WDW  Washington, DC	  12/22/21  12/22/21  DEL 05/--/22
LIC  Radio Construction & Elec Co    E	  761  ---  30D

 28  12/29/21 WOU  Omaha, NE		  12/29/21  12/29/21  DEL 06/23/23
LIC  R. B. Howell		     EM   761  ---  1YR

 29  12/30/21 WMH  Cincinnati, OH	  12/29/21  12/30/21  DEL 12/11/23
LIC  Precision Equipment Company     EM   761  DET  1YR

 30  01/04/22 KLB  Pasadena, CA 	  01/03/22  01/04/22  DEL 04/25/23
LIC  J. J. Dunn & Company	     E	  761  SF   1YR

 31  01/04/22 KLP  Los Altos, CA	  01/03/22  01/04/22  DEL 03/09/23
LIC  Colin B. Kennedy Company	     E	  761  SF   1YR

 32  01/09/22 KQV  Pittsburgh, PA	  --/--/--  01/09/22  KQV-1410
TRN  Doubleday-Hill Electric Co      E	  ---  ---  ---       Pittsburgh, PA

 33  01/10/22 WPB  Pittsburgh, PA	  01/10/22  01/10/22  DEL 05/05/22
LIC  Newspaper Printing Company      E	  761  ---  6M

 34  01/13/22 WHA  Madison, WI		  --/--/--  01/13/22  WHA-970
LIC  University of Wisconsin	     EM   ---  ---  6M	      Madison, WI

 35  01/13/22 WLB  Minneapolis, MN	  --/--/--  01/13/22  KUOM-770
LIC  University of Minnesota	     EM   ---  ---  6M	      Minneapolis, MN

 36  01/18/22 WNO  Jersey City, NJ	  01/18/22  01/18/22  DEL 03/--/23 (?)
LIC  Wireless Telephone-Hudson Cnty  E	  761  NYC  6M

 37  01/26/22 WDZ  Toledo, OH		  --/--/--  01/26/22  DEL 01/02/23(WBAJ)
LIC  Marshall-Gerken Company	     EM   ---  ---  3M

 38  01/26/22 WLK  Indianapolis, IN	  01/18/22  01/26/22  DEL 06/01/23
LIC  Hamilton Manufacturing Company  E	  761  CHI  3M

     02/02/22 Change KZC [19] Los Angeles, CA
     CALL: KOG

 39  02/03/22 WGH  Montgomery, AL	  02/01/22  02/03/22  DEL 06/05/22
LIC  Montgomery Light & Power Co     EM   761  NO   3M

 40  02/04/22 WGY  Schenectady, NY	  02/03/22  02/04/22  WGY-810
LIC  General Electric Company	     E	  761  NYC  3M	      Schenectady, NY

 41  02/07/22 WGI  Medford Hillside, MA   02/01/22  02/07/22  DEL 04/--/27 (?)
LIC  American Radio Research Corp    E	  761  BOS  3M	      WARC

 42  02/08/22 KGF  Pomona, CA		  02/01/22  02/08/22  DEL 12/06/22
LIC  Pomona Fixture & Wiring Co      E	  761  SF   3M

 43  02/08/22 WGL  Philadelphia, PA	  02/01/22  02/08/22  DEL 12/31/24
LIC  Thomas F. J. Howlett	     E	  761  BAL  3M

 44  02/13/22 KUO  San Francisco, CA	  02/14/22  02/13/22  DEL 01/21/26
LIC  Examiner Printing Company	     E	  761  SF   30D

 45  02/16/22 WOK  Pine Bluff, AR	  02/15/22  02/16/22  DEL 06/--/24
LIC  Pine Bluff Company 	     E	  ASN  ---  3M

 46  02/16/22 WOZ  Richmond, IN 	  02/16/22  02/16/22  DEL 04/09/23
LIC  Palladium Printing Company      EM   LET  OWN  3M

 47  02/17/22 WOQ  Kansas City, MO	  02/16/22  02/17/22  DEL 06/14/34
LIC  Western Radio Company	     EM   761  CHI  3M

 48  02/18/22 WOC  Rock Island, IL	  02/18/22  02/18/22  WOC-1420
LIC  Karlowa Radio Company	     EM   761  ---  3M	      Davenport, IA

 49  02/20/22 WOH  Indianapolis, IN	  02/18/22  02/20/22  DEL 02/14/23
LIC  Hatfield Electric Company	     E	  761  CHI  3M

 50  02/20/22 WOR  Newark, NJ		  02/17/22  02/20/22  WOR-710
LIC  L. Bamberger & Company	     E	  761  NYC  3M	      New York, NY

 51  02/21/22 WBU  Chicago, IL		  02/09/22  02/21/22  DEL 11/07/23
LIC  City of Chicago		     E	  761  CHI  3M

 52  02/21/22 WHK  Cleveland, OH	  02/20/22  02/21/22  WHK-1420
LIC  Warren R. Cox		     E	  761  DET  3M	      Cleveland, OH

 53  02/23/22 WOS  Jefferson City, MO	  02/20/22  02/23/22  DEL 03/27/36
LIC  Missouri State Marketing Bur    M	  761  CHI  3M

 54  02/24/22 WFO  Dayton, OH		  02/24/22  02/24/22  DEL 11/28/22
LIC  Rike-Kumler Company	     EM   761  DET  3M

 55  02/24/22 WHQ  Rochester, NY	  02/17/22  02/24/22  DEL 10/02/22
LIC  Rochester Times Union	     EM   761  DET  3M

 56  02/24/22 WHW  East Lansing, MI	  02/24/22  02/24/22  DEL 01/16/23
LIC  Stuart Seeley (US Wx Bureau)    M	  761  DET  3M

 57  02/24/22 WRK  Hamilton, OH 	  02/24/22  02/24/22  DEL 09/29/30
LIC  Doron Brothers Electric Co      E	  761  DET  3M

 58  02/28/22 KFU  Gridley, CA		  02/25/22  02/28/22  DEL 07/22/22
LIC  The Precision Shop 	     E	  761  ---  3M

 59  02/28/22 KHQ  Seattle, WA		  --/--/--  02/28/22  KAQQ-590
LIC  Louis Wasmer		     E	  ---  ---  3M	      Spokane, WA

 60  02/28/22 WHU  Toledo, OH		  02/25/22  02/28/22  DEL 10/27/22
LIC  William B. Duck Company	     E	  761  OWN  3M

 61  02/28/22 WJK  Toledo, OH		  02/28/22  02/28/22  DEL 02/01/23
LIC  Service Radio Equipment Co      E	  761  DET  3M

     03/--/22 Change KDN [11] San Francisco, CA
     FREQ: EM

     03/--/22 Change KYJ [18] Los Angeles, CA
     FREQ: EM

     03/--/22 Change KYW [9] Chicago, IL
     FREQ: EM

     03/--/22 Change WOU [28] Omaha, NE
     OWNER: Metropolitan Utilities Dist

 62  03/02/22 WLW  Cincinnati, OH	  03/02/22  03/02/22  WLW-700
LIC  Crosley Manufacturing Company   E	  761  DET  3M	      Cincinnati, OH

 63  03/02/22 WRL  Schenectady, NY	  03/02/22  03/02/22  DEL 02/--/25
LIC  Union College		     E	  761  NYC  3M

     03/03/22 Change WBL [7] Detroit, MI
     CALL: WWJ

 64  03/09/22 KJR  Seattle, WA		  03/06/22  03/09/22  KJR-950
LIC  Vincent I. Kraft		     EM   761  SEA  3M	      Seattle, WA

 65  03/10/22 KJS  Los Angeles, CA	  03/06/22  03/10/22  KFAC-1330
LIC  Bible Institute of Los Angeles  E	  761  SF   3M	      Los Angeles, CA

 66  03/10/22 KLS  Oakland, CA		  03/06/22  03/10/22  KDIA-1310
LIC  Warner Brothers		     E	  761  SF   3M	      Oakland, CA

 67  03/10/22 KLZ  Denver, CO		  03/06/22  03/10/22  KLZ-560
LIC  Reynolds Radio Company	     EM   761  CHI  3M	      Denver, CO

 68  03/11/22 KRE  Berkeley, CA 	  03/11/22  03/11/22  KBLX-1400
LIC  Maxwell Electric Company	     E	  761  SF   3M	      Berkeley, CA

 69  03/11/22 KSL  San Francisco, CA	  03/11/22  03/11/22  DEL 06/16/23
LIC  The Emporium		     E	  761  SF   3M

 70  03/11/22 WBS  Newark, NJ		  03/11/22  03/11/22  DEL 07/18/62(WHBI)
LIC  D. W. May			     E	  761  NYC  3M

 71  03/13/22 WRR  Dallas, TX		  --/--/--  03/13/22  KAAM-1310
TRN  City of Dallas		     EM   ---  ---  3M	      Dallas, TX

 72  03/14/22 KGU  Honolulu, HI 	  03/11/22  03/14/22  KGU-760
LIC  Marion A. Mulrony		     E	  761  SF   3M	      Honolulu, HI

 73  03/14/22 KSD  Saint Louis, MO	  03/07/22  03/14/22  KUSA-550
LIC  Post Dispatch		     E	  TG   OWN  3M	      Saint Louis, MO

 74  03/14/22 WGF  Des Moines, IA	  03/14/22  03/14/22  DEL 09/29/23
LIC  The Register & Tribune	     E	  TG   OWN  3M

 75  03/14/22 WGR  Buffalo, NY		  03/11/22  03/14/22  WGR-550
LIC  Federal Telephone & Telegraph   EM   761  DET  3M	      Buffalo, NY

 76  03/14/22 WIK  McKeesport, PA	  03/14/22  03/14/22  DEL 03/09/25
LIC  K & L Electric Company	     E	  761  DET  3M

 77  03/14/22 WIL  Washington, DC	  03/14/22  03/14/22  DEL 09/13/24
LIC  Continental Electrical Supply   E	  761  BAL  3M

 78  03/14/22 WPM  Washington, DC	  03/06/22  03/14/22  DEL 05/10/23
LIC  Thomas J. Williams 	     E	  ---  WED  3M

 79  03/14/22 WRW  Tarrytown, NY	  03/11/22  03/14/22  DEL 07/31/26
LIC  Tarrytown Radio Research Lab    E	  761  NYC  3M

 80  03/15/22 KGG  Portland, OR 	  03/14/22  03/15/22  DEL 11/25/24
LIC  Hallock & Watson Radio Service  E	  761  SEA  3M

 81  03/15/22 KGO  Altadena, CA 	  03/11/22  03/15/22  DEL 08/21/23
LIC  Altadena Radio Laboratory	     E	  761  SF   3M

 82  03/15/22 WGM  Atlanta, GA		  03/15/22  03/15/22  DEL 08/28/23
?    Atlanta Constitution	     EM   761  ---  ---

 83  03/15/22 WSB  Atlanta, GA		  03/15/22  04/11/22  WSB-750
TG   Atlanta Journal		     EM   TG   OWN  3M	      Atlanta, GA

 84  03/16/22 KDPT San Diego, CA	  03/01/22  03/16/22  DEL 03/19/25
TRN  Southern Electrical Company     E	  761  SF   ---

 85  03/16/22 WHD  Morgantown, WV	  03/11/22  03/16/22  DEL 11/19/23
LIC  West Virginia University	     E	  761  DET  3M

 86  03/16/22 WKY  Oklahoma City, OK	  03/06/22  03/16/22  WKY-930
LIC  Oklahoma Radio Shop	     EM   761  NO   3M	      Oklahoma City, OK

 87  03/16/22 WPA  Fort Worth, TX	  03/16/22  03/16/22  DEL 05/24/23
LIC  Fort Worth Record		     E	  761  NO   3M

 88  03/16/22 WSL  Utica, NY		  03/11/22  03/16/22  DEL 04/29/25
LIC  J & M Electric Company	     E	  761  DET  3M

 89  03/18/22 KHJ  Los Angeles, CA	  03/18/22  03/18/22  KRTH-930
LIC  C. R. Kierulff & Company	     E	  761  SF   3M	      Los Angeles, CA

 90  03/18/22 KOP  Detroit, MI		  03/17/22  03/18/22  DEL 11/28/25
LIC  Detroit Police Department	     E	  761  DET  3M

 91  03/18/22 WBT  Charlotte, NC	  03/17/22  03/18/22  WBT-1110
LIC  Southern Radio Corporation      E	  761  BAL  3M	      Charlotte, NC

 92  03/18/22 WFI  Philadelphia, PA	  03/16/22  03/18/22  WFIL-560
LIC  Strawbridge & Clothier	     E	  761  ---  3M	      Philadelphia, PA

 93  03/18/22 WHN  Ridgewood, NY	  03/17/22  03/18/22  WFAN-1050
LIC  Ridgewood Times Printing & Pub  E	  761  NYC  3M	      New York, NY

 94  03/18/22 WOO  Philadelphia, PA	  03/17/22  03/18/22  DEL 02/20/29
LIC  John Wanamaker		     E	  761  BAL  3M

     03/20/22 Delete WDZ [37] Toledo, OH

 95  03/20/22 KOA  Denver, CO		  03/17/22  03/20/22  DEL 06/23/23
LIC  Young Men's Christian Assoc     M    761  CHI  3M

 96  03/20/22 WIP  Philadelphia, PA	  03/16/22  03/20/22  WIP-610
LIC  Gimbel Brothers		     E	  761  ---  3M	      Philadelphia, PA

 97  03/21/22 KGW  Portland, OR 	  03/20/22  03/21/22  KGW-620
LIC  Oregonian Publishing Company    E	  761  SEA  3M	      Portland, OR

 98  03/21/22 WCN  Worcester, MA	  03/17/22  03/21/22  DEL 06/25/23
LIC  Clark University		     EM   761  BOS  3M

 99  03/21/22 WGV  New Orleans, LA	  03/17/22  03/21/22  DEL 06/--/24
LIC  Interstate Electric Company     E	  761  NO   3M

100  03/21/22 WJT  Erie, PA		  03/21/22  03/21/22  DEL 10/21/22
LIC  Electric Equipment Company      E	  761  DET  3M

101  03/21/22 WRP  Camden, NJ		  03/21/22  03/21/22  DEL 08/20/23
LIC  Federal Inst Radio Telegraphy   E	  761  BAL  3M

102  03/21/22 WSX  Erie, PA		  03/21/22  03/21/22  DEL 01/26/23
LIC  Erie Radio Company 	     E	  761  DET  3M

103  03/22/22 WCM  Austin, TX		  03/17/22  03/22/22  KTRH-740
LIC  University of Texas	     EM   761  NO   3M	      Houston, TX

     03/23/22 Delete KGB [13] San Francisco, CA

104  03/23/22 KFZ  Spokane, WA		  03/22/22  03/23/22  DEL 09/08/23
LIC  Doerr-Mitchell Electric Co      E	  761  SEA  3M

105  03/23/22 KMJ  Fresno, CA		  03/23/22  03/23/22  KMJ-580
LIC  San Joaquin Light & Power Corp  E	  761  SF   3M	      Fresno, CA

106  03/23/22 KQT  Yakima, WA		  03/22/22  03/23/22  DEL 10/06/22
LIC  Electric Power & Appliance Co   E	  761  SEA  3M

107  03/23/22 WEV  Houston, TX		  03/17/22  03/23/22  DEL 01/10/25
LIC  Hurlburt-Still Electrical Co    EM   761  NO   3M

108  03/23/22 WEW  Saint Louis, MO	  03/17/22  03/23/22  WEW-770
LIC  Saint Louis University	     M	  761  CHI  3M	      Saint Louis, MO

109  03/23/22 WEY  Wichita, KS		  03/17/22  03/23/22  DEL 06/23/23
LIC  Cosradio Company		     EM   761  CHI  3M

110  03/23/22 WKC  Baltimore, MD	  03/22/22  03/23/23  DEL 11/24/23
LIC  Joseph M. Zamoiski Company      E	  761  BAL  3M

111  03/23/22 WKN  Memphis, TN		  03/22/22  03/23/22  DEL 06/11/23
LIC  Riechman-Crosby Company	     EM   761  NO   3M

112  03/23/22 WMU  Washington, DC	  03/22/22  03/23/22  DEL 10/--/25 (?)
LIC  Doubleday-Hill Electric Co      E	  761  BAL  3M

113  03/24/22 WWZ  New York, NY 	  03/24/22  04/17/22  DEL 11/05/23
?TG  John Wanamaker		     E	  ---  ---  3M

114  03/25/22 KFV  Yakima, WA		  03/24/22  03/25/22  DEL 05/05/23
LIC  Foster-Bradbury Radio Store     E	  761  SEA  3M

115  03/25/22 WWI  Dearborn, MI 	  03/24/22  03/25/22  DEL 04/24/26
LIC  Ford Motor Company 	     E	  761  DET  3M

116  03/25/22 WWT  Buffalo, NY		  03/25/22  03/25/22  DEL 10/02/22
LIC  McCarthy Brothers & Ford	     E	  761  DET  3M

117  03/27/22 WMC  Youngstown, OH	  03/24/22  03/27/22  DEL 12/19/22
LIC  Columbia Radio Company	     E	  761  DET  3M

118  03/27/22 WNJ  Albany, NY		  03/24/22  03/27/22  DEL 06/--/24
LIC  Shotton Radio Manufacturing Co  E	  761  NYC  3M

119  03/27/22 WPG  New Lebanon, OH	  03/24/22  03/27/22  DEL 02/19/24
LIC  Nushawg Poultry Farm	     E	  761  DET  3M

120  03/27/22 WWB  Canton, OH		  03/24/22  03/27/22  DEL 11/19/23
LIC  Daily News Printing Company     E	  761  DET  3M

121  03/28/22 KYG  Portland, OR 	  03/28/22  03/28/22  DEL 10/13/22
LIC  Willard P. Hawley Junior	     E	  761  SEA  3M

122  03/28/22 WAH  El Dorado, KS	  03/27/22  03/28/22  DEL 03/06/23
LIC  Midland Refining Company	     M	  761  CHI  3M

123  03/28/22 WHX  Des Moines, IA	  --/--/--  --/--/--  DEL 05/--/22
TG   Iowa Radio Corporation	     E	  ---  ---  ---

124  03/28/22 WPO  Memphis, TN		  03/24/22  03/28/22  DEL 06/12/23
LIC  United Equipment Company	     E	  761  NO   3M

125  03/28/22 WRM  Urbana, IL		  03/24/22  03/28/22  WILL-580
LIC  University of Illinois	     E	  761  CHI  3M	      Urbana, IL

126  03/28/22 WSV  Little Rock, AR	  03/24/22  03/28/22  DEL 11/06/22
LIC  L M Hunter & G L Carrington     E	  761  NO   3M

127  03/29/22 WEH  Tulsa, OK		  03/29/22  --/--/--  DEL 06/12/23
?    Midland Refining Company	     M	  761  NO   ---

128  03/29/22 WGU  Chicago, IL		  03/29/22  03/29/22  WMAQ-670
LIC  The Fair			     E	  761  CHI  3M	      Chicago, IL

129  03/29/22 WSY  Birmingham, AL	  03/24/22  03/29/22  DEL 10/30/24
LIC  Alabama Power Company	     E	  761  NO   3M

130  03/29/22 WTK  Paris, TX		  03/24/22  03/29/22  DEL 11/20/22
LIC  Paris Radio Electric Company    E	  761  DET  3M

131  03/30/22 KGY  Lacey, WA		  03/24/22  03/30/22  KGY-1240
LIC  Saint Martin's Coll (Rev Ruth)  E    761  SEA  3M        Olympia, WA

132  03/30/22 KMO  Tacoma, WA		  03/24/22  03/30/22  KKMO-1360
LIC  Love Electric Company	     E	  761  SEA  3M	      Tacoma, WA

133  03/30/22 KQY  Portland, OR 	  03/29/22  03/30/22  DEL 05/03/23
LIC  Stubbs Electric Company	     E	  761  SEA  3M

134  03/30/22 WDV  Omaha, NE		  03/30/22  03/30/22  DEL 02/07/23
LIC  John O. Yeiser Junior	     E	  761  CHI  3M

135  03/30/22 WTP  Bay City, MI 	  03/24/22  03/30/22  DEL 07/20/23
LIC  George M. McBride		     E	  761  DET  3M

136  03/31/22 KFI  Los Angeles, CA	  --/--/--  03/31/22  KFI-640
LIC  Earle C. Anthony		     E	  TG   OWN  ---       Los Angeles, CA

137  03/31/22 KGN  Portland, OR 	  03/24/22  03/31/22  DEL 06/--/24 (?)
LIC  Northwestern Radio Mfg Company  E	  761  SEA  3M

138  03/31/22 KLN  Monterey, CA 	  03/24/22  03/31/22  DEL 11/30/23
LIC  Noggle Electric Works	     E	  761  SF   3M

139  03/31/22 KMC  Reedley, CA		  03/24/22  03/31/22  DEL 09/01/23
LIC  Lindsay-Weatherill & Company    E	  761  SF   3M

140  03/31/22 WWL  New Orleans, LA	  03/31/22  03/31/22  WWL-870
LIC  Loyola University		     E	  761  NO   3M	      New Orleans, LA

     04/--/22 Change WAH [122] El Dorado, KS
     FREQ: EM

     04/--/22 Change WBT [91] Charlotte, NC
     FREQ: EM

     04/--/22 Change WLK [38] Indianapolis, IN
     FREQ: EM

     04/--/22 Change WOC [48] Rock Island, IL
     LOC: Davenport, IA OWNER: Palmer School of Chiropractic

     04/--/22 Change WPA [87] Fort Worth, TX
     FREQ: EM

141  04/03/22 WCK  Saint Louis, MO	  04/03/22  04/03/22  DEL 11/30/28(WSBF)
LIC  Stix-Baer-Fuller		     E	  761  CHI  3M

142  04/05/22 KHD  Colorado Springs, CO   04/04/22  04/05/22  DEL 03/20/23
LIC  C F Aldrich Marble & Granite    M	  761  CHI  3M

143  04/05/22 KNJ  Roswell, NM		  04/04/22  04/05/22  DEL 11/26/23
LIC  Roswell Public Service Company  E	  761  NO   3M

144  04/05/22 KOB  State College, NM	  04/04/22  04/05/22  KKOB-770
LIC  New Mexico College 	     EM   761  NO   3M	      Albuquerque, NM

145  04/05/22 WBAA West Lafayette, IN	  04/04/22  04/05/22  WBAA-920
LIC  Purdue University		     E	  761  CHI  3M	      West Lafayette, IN

146  04/05/22 WBL  Anthony, KS		  04/04/22  04/05/22  DEL 12/15/24
LIC  T & H Radio Company	     E	  761  CHI  3M

147  04/05/22 WCE  Minneapolis, MN	  04/04/22  04/05/22  DEL 12/01/23
LIC  Findley Electric Company	     E	  761  CHI  3M

148  04/05/22 WDZ  Tuscola, IL		  04/04/22  04/05/22  WDZ-1050
LIC  James L. Bush		     E	  761  CHI  3M	      Decatur, IL

149  04/05/22 WEB  Saint Louis, MO	  04/04/22  04/05/22  WIL-1430
LIC  Benwood Company		     E	  761  CHI  3M	      Saint Louis, MO

150  04/05/22 WMB  Auburn, ME		  04/04/22  04/05/22  DEL 03/21/23
LIC  Auburn Electrical Company	     E	  761  BOS  3M

151  04/05/22 WPE  Kansas City, MO	  04/04/22  04/05/22  KMBZ-980
LIC  Central Radio Company	     E	  761  CHI  3M	      Kansas City, MO

152  04/05/22 WPJ  Philadelphia, PA	  04/04/22  04/05/22  DEL 01/19/23
LIC  Saint Joseph's College          E    761  ---  3M

153  04/06/22 WJD  Granville, OH	  04/04/22  04/06/22  DEL 12/07/25
LIC  Richard H. Howe		     E	  761  DET  3M

154  04/06/22 WMA  Anderson, IN 	  04/04/22  04/06/22  DEL 03/01/23(WEAW)
LIC  Arrow Radio Laboratories	     E	  761  CHI  3M

155  04/06/22 WOE  Akron, OH		  04/04/22  04/06/22  DEL 07/--/23 (?)
LIC  Buckeye Radio Service Co	     E	  761  DET  3M

156  04/06/22 WPI  Clearfield, PA	  04/04/22  04/06/22  DEL 07/20/23
LIC  Electric Supply Company	     E	  761  DET  3M

157  04/06/22 WPL  Zanesville, OH	  04/04/22  04/06/22  DEL 10/23/22
LIC  Fergus Electric Company	     E	  761  DET  3M

158  04/06/22 WSN  Norfolk, VA		  04/04/22  04/06/22  DEL 01/16/23
LIC  Ship Owners Radio Service	     E	  761  NOR  3M

159  04/06/22 WTG  Manhatten, KS	  04/04/22  04/06/22  KKSU-580
LIC  Kansas State Agricultural Coll  M	  761  CHI  3M	      Manhatten, KS

160  04/07/22 WAAF Chicago, IL		  04/07/22  04/07/22  WJPC-950
LIC  Union Stock Yards & Transit Co  EM   761  CHI  3M	      Chicago, IL

161  04/08/22 KGB  Tacoma, WA		  04/08/22  04/08/22  DEL 12/11/25
LIC  William Mullins Electric Co     E	  761  SEA  3M

162  04/10/22 KJC  Los Angeles, CA	  04/08/22  04/10/22  DEL 01/24/23
LIC  Standard Radio Company	     E	  761  SF   3M

163  04/10/22 KNR  Los Angeles, CA	  04/08/22  04/10/22  DEL 08/23/22
LIC  Beacon Light Company	     E	  761  SF   3M

164  04/10/22 KNV  Los Angeles, CA	  04/08/22  04/10/22  DEL 04/02/24
LIC  Radio Supply Company	     E	  761  SF   3M

165  04/10/22 KON  San Diego, CA	  04/08/22  04/10/22  DEL 03/09/23
LIC  Holzwasser 		     E	  761  SF   3M

166  04/10/22 KSS  Long Beach, CA	  04/08/22  04/10/22  DEL 04/02/24
LIC  Prest & Dean Radio Research     E	  761  SF   3M

167  04/10/22 KXS  Los Angeles, CA	  04/08/22  04/10/22  DEL 03/09/23
LIC  Braun Corporation		     E	  761  SF   3M

168  04/10/22 KZI  Los Angeles, CA	  04/08/22  04/10/22  DEL 08/15/22
LIC  Irving S. Cooper		     E	  761  SF   3M

169  04/10/22 WAAH Saint Paul, MN	  04/08/22  04/10/22  DEL 11/07/23
LIC  Commonwealth Electric Company   E	  761  CHI  3M

170  04/10/22 WAAJ Boston, MA		  04/08/22  04/10/22  DEL 05/15/23
LIC  Eastern Radio Institute	     E	  761  BOS  3M

171  04/10/22 WAAL Minneapolis, MN	  04/08/22  04/10/22  DEL 06/23/23
LIC  Minn Tribune& Anderson-Beamish  E	  761  CHI  3M

172  04/10/22 WAAM Newark, NJ		  04/08/22  04/10/22  WNEW-1130
LIC  I. R. Nelson Company	     E	  761  NYC  3M	      New York, NY

173  04/10/22 WAAO Charles Town, WV	  04/08/22  04/10/22  DEL 12/01/22
LIC  Radio Service Company	     E	  761  DET  3M

174  04/11/22 WAAG Shreveport, LA	  04/11/22  04/11/22  DEL 12/19/22
LIC  Elliott Electric Company	     E	  761  NO   3M

175  04/12/22 KOE  Spokane, WA		  04/11/22  04/12/22  DEL 10/07/22
LIC  Spokane Chronicle		     E	  761  SEA  3M

176  04/12/22 KOQ  Modesto, CA		  04/11/22  04/12/22  DEL 09/06/22
LIC  Modesto Evening News	     E	  761  SF   3M

177  04/12/22 KQP  Hood River, OR	  04/11/22  04/12/22  KYTE-970
LIC  Blue Diamond Electric Company   EM   761  SEA  3M	      Portland, OR

178  04/12/22 WAAE Saint Louis, MO	  04/11/22  04/12/22  DEL 09/23/22
LIC  Saint Louis Chamber of Comm     E	  761  CHI  3M

179  04/13/22 KUS  Los Angeles, CA	  04/12/22  04/13/22  DEL 04/04/24
LIC  City Dye Works & Laundry Co     E	  761  SF   3M

180  04/13/22 KWH  Los Angeles, CA	  04/12/22  04/13/22  DEL 03/18/25
LIC  Los Angeles Examiner	     E	  761  SF   3M

181  04/13/22 KXD  Modesto, CA		  04/12/22  04/13/22  DEL 03/10/24
LIC  Herald Publishing Company	     E	  761  SF   3M

182  04/13/22 WAAK Milwaukee, WI	  04/12/22  04/13/22  DEL 12/01/23
LIC  Gimbel Brothers		     E	  761  CHI  3M

183  04/13/22 WAAN Columbia, MO 	  04/12/22  04/13/22  DEL 03/16/25
LIC  University of Missouri	     E	  761  CHI  3M

184  04/13/22 WAAQ Greenwich, CT	  04/13/22  04/13/22  DEL 05/15/23
LIC  New England Motor Sales Co      E	  761  BOS  3M

185  04/13/22 WAAR Huntington, WV	  04/13/22  04/13/22  DEL 12/04/22
LIC  Groves-Thornton Hardware Co     E	  761  DET  3M

186  04/13/22 WAAZ Emporia, KS		  03/11/22  04/13/22  DEL 01/28/24
LIC  Hollister-Miller Motor Company  E	  TG   OWN  3M

187  04/14/22 WAAP Wichita, KS		  04/13/22  04/14/22  DEL 10/15/23
LIC  Otto W. Taylor		     E	  761  CHI  3M

188  04/17/22 KPO  San Francisco, CA	  04/13/22  04/17/22  KNBR-680
LIC  Hale Brothers		     E	  761  SF   3M	      San Francisco, CA

189  04/17/22 WAAB New Orleans, LA	  04/04/22  04/17/22  WJBO-1150
LIC  Times-Picayune		     E	  761  ---  3M	      Baton Rouge, LA

190  04/17/22 WAAS Decatur, GA		  04/13/22  04/17/22  DEL 05/25/23
LIC  Georgia Radio Company	     E	  761  NOR  3M

191  04/19/22 WAAV Athens, OH		  04/17/22  04/19/22  DEL 12/01/22
LIC  Athens Radio Company	     E	  761  DET  3M

192  04/19/22 WAAW Omaha, NE		  04/17/22  04/19/22  KCRO-660
LIC  Omaha Grain Exchange	     E	  761  CHI  3M	      Omaha, NE

193  04/19/22 WAAX Crafton, PA		  04/17/22  04/19/22  DEL 01/04/23
LIC  Radio Service Corporation	     E	  761  DET  3M

194  04/19/22 WAAY Youngstown, OH	  04/17/22  04/19/22  DEL 06/12/23
LIC  Yahrling-Rayner Piano Company   E	  761  DET  3M

195  04/19/22 WBAB Syracuse, NY 	  04/17/22  04/19/22  DEL 03/22/23
LIC  Andrew J. Potter		     E	  761  DET  3M

196  04/20/22 KZC  Seattle, WA		  04/14/22  04/20/22  DEL 04/11/23
LIC  Public Market & Market Stores   E	  761  SEA  3M

197  04/21/22 KZN  Salt Lake City, UT	  04/20/22  04/21/22  KSL-1160
LIC  The Deseret News		     EM   761  SF   3M	      Salt Lake City, UT

198  04/21/22 WBAE Peoria, IL		  04/19/22  04/21/22  DEL 11/01/22
LIC  Bradley Polytechnic Institute   EM   761  CHI  3M

199  04/21/22 WBAF Moorestown, NJ	  04/20/22  04/21/22  DEL 10/05/23
LIC  Fred M. Middleton		     E	  761  BAL  3M

200  04/21/22 WBAG Bridgeport, PA	  04/20/22  04/21/22  DEL 04/16/23
LIC  Diamond State Fibre Company     EM   761  BAL  3M

201  04/21/22 WBAH Minneapolis, MN	  04/20/22  04/21/22  DEL 09/05/24
LIC  The Dayton Company 	     E	  761  CHI  3M

202  04/22/22 KTW  Seattle, WA		  04/13/22  04/22/22  DEL 08/30/75
LIC  First Presbyterian Church	     E	  TG   OWN  3M

203  04/22/22 WBAD Minneapolis, MN	  04/19/22  04/22/22  DEL 04/22/24
LIC  Sterling Elec & Journal Print   E	  761  ---  3M

204  04/22/22 WBAJ Toledo, OH		  04/21/22  04/22/22  DEL 01/02/23
REL  Marshall-Gerken Company	     E	  761  DET  3M

205  04/24/22 WAAC New Orleans, LA	  04/05/22  04/24/22  DEL 11/25/25
LIC  Tulane University		     E	  TG   OWN  3M

206  04/24/22 WBAM New Orleans, LA	  04/22/22  04/24/22  DEL 10/17/22
LIC  I. B. Rennyson		     E	  761  NO   3M

207  04/24/22 WBAN Paterson, NJ 	  04/24/22  04/24/22  DEL 04/10/25
LIC  Wireless Phone Corporation      E	  761  NYC  3M

208  04/24/22 WIZ  Cincinnati, OH	  03/18/22  04/24/22  DEL 07/20/23
LIC  Cino Radio Manufacturing Co     EM   761  ---  3M

209  04/25/22 KNN  Los Angeles, CA	  04/24/22  04/25/22  DEL 06/07/23
LIC  Bullock's                       E    761  SF   3M

210  04/25/22 KUY  El Monte, CA 	  04/24/22  04/25/22  DEL 09/29/24
LIC  Coast Radio Company	     E	  761  SF   3M

211  04/25/22 WBAO Decatur, IL		  04/24/22  04/25/22  WSOY-1340
LIC  James Millikin University	     E	  761  CHI  3M	      Decatur, IL

212  04/26/22 KNT  Aberdeen, WA 	  04/25/22  04/26/22  DEL 03/19/25
LIC  North Coast Products Company    E	  761  SEA  3M

213  04/26/22 KSC  San Jose, CA 	  04/24/22  04/26/22  DEL 07/06/22
LIC  O. A. Hale & Company	     E	  761  SF   3M

214  04/26/22 KYF  San Diego, CA	  04/25/22  04/26/22  DEL 12/01/22
LIC  Thearle Music Company	     E	  761  SF   3M

215  04/26/22 WBAP Fort Worth, TX	  04/26/22  05/02/22  WBAP-820
STA  Wortham-Carter Publishing Co    EM   ---  ---  3M	      Fort Worth, TX

216  04/28/22 WOI  Ames, IA		  03/06/22  04/28/22  WOI-640
LIC  Iowa State College 	     EM   761  CHI  3M	      Ames, IA

     04/28/22 Change WGM [82] Atlanta, GA
     FREQ: EM OWNER: Georgia Railway (Atlanta Cons)

217  04/29/22 KNI  Eureka, CA		  04/28/22  04/29/22  DEL 06/16/23
LIC  T. W. Smith		     E	  761  SF   3M

218  04/29/22 WBAQ South Bend, IN	  04/28/22  04/29/22  DEL 11/07/22
LIC  Myron L. Harmon (YMCA)	     E	  761  CHI  3M

219  04/29/22 WBAU Hamilton, OH 	  04/28/22  04/29/22  DEL 09/17/23
LIC  Repubican Publishing Company    E	  761  DET  3M

220  04/29/22 WBAV Columbus, OH 	  04/28/22  04/29/22  WTVN-610
LIC  Erner & Hopkins Company	     E	  761  DET  3M	      Columbus, OH

221  04/29/22 WBAW Marietta, OH 	  04/28/22  04/29/22  DEL 01/21/24
LIC  Marietta College		     E	  761  DET  3M

222  04/29/22 WBAX Wilkes-Barre, PA	  04/28/22  04/29/22  WBAX-1240
LIC  John H. Stenger Junior	     E	  761  ---  3M	      Wilkes-Barre, PA

223  04/29/22 WBAY New York, NY 	  04/29/22  04/29/22  DEL 11/06/24(WECO)
LIC  American Telephone & Telegraph  E	  761  NYC  3M

     05/--/22 Delete WDW [27] Washington, DC

     05/--/22 Delete WEH [127] Tulsa, OK

     05/--/22 Delete WHX [123] Des Moines, IA

     05/--/22 Change KNJ [143] Roswell, NM
     FREQ: EM

     05/--/22 Change KUO [44] San Francisco, CA
     FREQ: EM

     05/--/22 Change WEW [108] Saint Louis, MO
     FREQ: EM

     05/--/22 Change WLW [62] Cincinnati, OH
     FREQ: EM

224  05/01/22 KOJ  Reno, NV		  --/--/--  05/01/22  DEL 06/07/22
LIC  University of Nevada	     E	  ---  ---  3M

225  05/01/22 WBAZ Richmond, VA 	  04/29/22  05/01/22  DEL 10/18/22
LIC  Times-Dispatch Publishing Co    E	  761  BAL  3M

226  05/03/22 KLX  Oakland, CA		  05/03/22  05/03/22  KNEW-910
LIC  Tribune Publishing Company      E	  761  SF   3M	      Oakland, CA

227  05/03/22 KZV  Wenatchee, WA	  05/03/22  05/03/22  DEL 06/--/24
LIC  Wenatchee Battery & Motor Co    E	  761  SEA  3M

228  05/03/22 WCAB Newburgh, NY 	  05/03/22  05/03/22  DEL 06/15/23
LIC  Newburgh News Print & Pub Co    E	  761  NYC  3M

229  05/03/22 WCAE Pittsburgh, PA	  05/03/22  05/03/22  WTAE-1250
LIC  Kaufman & Baer Company	     E	  761  DET  3M	      Pittsburgh, PA

230  05/04/22 KNX  Los Angeles, CA	  05/04/22  05/04/22  KNX-1070
REL  Electric Lighting Supply Co     E	  761  ---  3M	      Los Angeles, CA

231  05/04/22 KQI  Berkeley, CA 	  05/04/22  05/04/22  DEL 12/10/23
LIC  University of California	     E	  761  SF   3M

232  05/04/22 KYI  Bakersfield, CA	  05/03/22  05/04/22  DEL 05/01/23
LIC  Alfred Harrell		     E	  761  SF   3M

233  05/04/22 WCAC Fort Smith, AR	  05/03/22  05/04/22  DEL 06/12/23
LIC  John Fink Jewelry Company	     E	  761  NO   3M

234  05/04/22 WCAD Canton, NY		  05/03/22  05/04/22  DEL 06/03/41
LIC  Saint Lawrence University	     E	  761  ---  3M

235  05/04/22 WCAG New Orleans, LA	  05/04/22  05/04/22  DEL 07/15/25
LIC  Daily States Publishing Co      E	  761  NO   3M

236  05/04/22 WCX  Detroit, MI		  05/04/22  05/04/22  WJR-760
LIC  Detroit Free Press 	     EM   761  CHI  3M	      Detroit, MI

     05/05/22 Delete WPB [33] Pittsburgh, PA

237  05/06/22 WCAJ University Place, NE   05/06/22  05/06/22  DEL 08/01/33
LIC  Nebraska Wesleyan University    EM   761  CHI  3M

238  05/06/22 WCAK Houston, TX		  05/06/22  05/06/22  DEL 01/10/25
LIC  Alfred P. Daniel		     E	  761  NO   3M

239  05/06/22 WCAL Northfield, MN	  05/06/22  05/06/22  WCAL-770
LIC  Saint Olaf College 	     E	  761  CHI  3M	      Northfield, MN

240  05/08/22 KDYL Salt Lake City, UT	  05/08/22  05/08/22  KBUG-1320
LIC  Telegram Publishing Company     E	  761  SF   3M	      Salt Lake City, UT

241  05/08/22 WCAM Villanova, PA	  05/06/22  05/08/22  DEL 06/10/24
LIC  Villanova College		     E	  761  BAL  3M

242  05/08/22 WCAN Jacksonville, FL	  05/08/22  05/08/22  DEL 10/26/22
LIC  Southeastern Radio Telephone    E	  761  BAL  3M

243  05/08/22 WCAO Baltimore, MD	  05/06/22  05/08/22  WCAO-600
LIC  Sanders & Stayman Company	     E	  761  BAL  3M	      Baltimore, MD

244  05/08/22 WCAP Decatur, IL		  05/08/22  05/08/22  DEL 03/05/23
LIC  Central Radio Service	     E	  761  OWN  3M

245  05/09/22 KDYO San Diego, CA	  05/08/22  05/09/22  DEL 01/24/23
LIC  Carlson & Simpson		     E	  761  SF   3M

246  05/09/22 KDYQ Portland, OR 	  05/08/22  05/09/22  DEL 01/23/25
LIC  Oregon Institute of Technology  M	  761  SEA  3M

247  05/09/22 WCAQ Defiance, OH 	  05/08/22  05/09/22  DEL 03/--/23 (?)
LIC  Tri-State Radio Mfg & Supply    E	  761  DET  3M

248  05/09/22 WCAR San Antonio, TX	  05/08/22  05/09/22  KTSA-550
LIC  Alamo Radio Electric Company    E	  761  NO   3M	      San Antonio, TX

249  05/09/22 WCAS Minneapolis, MN	  05/08/22  05/09/22  DEL 09/04/31(WHDI)
LIC  William Hood Dunwoody Inst      E	  761  CHI  3M

250  05/09/22 WCAT Rapid City, SD	  05/08/22  05/09/22  DEL 10/28/52
LIC  S Dakota State School of Mines  M	  761  CHI  3M

251  05/10/22 KDYM San Diego, CA	  05/08/22  05/10/22  DEL 03/19/25
LIC  Savoy Theatre		     E	  761  SF   3M

252  05/10/22 KDYN Redwood City, CA	  05/08/22  05/10/22  DEL 11/08/22
LIC  Great Western Radio Corp	     E	  761  SF   3M

253  05/10/22 KDYR Pasadena, CA 	  05/10/22  05/10/22  DEL 12/01/22
LIC  Pasadena Star-News Publishing   E	  761  SF   3M

254  05/10/22 WCAU Philadelphia, PA	  05/10/22  05/10/22  WCAU-1210
LIC  Philadelphia Radiophone Co      E	  761  ---  3M	      Philadelphia, PA

255  05/10/22 WHB  Kansas City, MO	  04/21/22  05/10/22  WHB-710
LIC  Sweeny School Company	     EM   RES  OWN  3M	      Kansas City, MO

256  05/13/22 KDYS Great Falls, MT	  05/13/22  05/13/22  DEL 11/30/23
LIC  The Tribune		     E	  761  SEA  3M

257  05/13/22 KDYU Klamath Falls, OR	  05/13/22  05/13/22  DEL 11/01/22
LIC  Herald Publishing Company	     E	  761  SEA  3M

258  05/13/22 KDYV Salt Lake City, UT	  05/13/22  05/13/22  DEL 03/15/23
LIC  Cope & Cornwell Company	     E	  761  SF   3M

259  05/13/22 WAAD Cincinnati, OH	  04/06/22  05/13/22  DEL 06/15/29
LIC  Ohio Mechanics Institute	     E	  TG   OWN  3M

260  05/13/22 WCAH Columbus, OH 	  05/05/22  06/12/22  WBNS-1460
?TG  Entrekin Electric Company	     E	  TG   OWN  3M	      Columbus, OH

261  05/13/22 WCAV Little Rock, AR	  05/13/22  05/13/22  DEL 03/11/25
LIC  J. C. Dice Electric Company     E	  761  NO   3M

262  05/13/22 WCAW Quincy, IL		  05/13/22  05/13/22  DEL 06/23/23
LIC  Quincy Herald & Quincy Elec     E	  761  CHI  3M

263  05/13/22 WCAX Burlington, VT	  05/13/22  05/13/22  WVMT-620
LIC  University of Vermont	     E	  761  BOS  3M	      Burlington, VT

264  05/15/22 KDYW Phoenix, AZ		  05/15/22  05/15/22  DEL 04/04/24
LIC  Smith Hughes & Company	     E	  761  SF   3M

265  05/15/22 WCAY Milwaukee, WI	  05/15/22  05/15/22  WTMJ-620
LIC  Kesselman O'Driscoll Company    E    761  CHI  3M        Milwaukee, WI

266  05/15/22 WCAZ Quincy, IL		  05/15/22  05/15/22  WCAZ-990
LIC  Compton & Quincy Whig-General   E	  761  CHI  3M	      Carthage, IL

267  05/15/22 WDAA Nashville, TN	  05/15/22  05/15/22  DEL 11/04/22
LIC  Ward-Belmont School	     E	  761  NO   3M

268  05/15/22 WDAB Portsmouth, OH	  05/15/22  05/15/22  DEL 10/23/22
LIC  H. C. Summers & Son	     E	  761  DET  3M

269  05/15/22 WDAC Springfield, IL	  05/15/22  05/15/22  DEL 05/05/23
LIC  Illinois Watch Company	     M	  761  CHI  3M

270  05/15/22 WDAD Lindsborg, KS	  05/15/22  05/15/22  DEL 11/07/23
LIC  William L. Harrison	     E	  761  CHI  3M

271  05/15/22 WDAE Tampa, FL		  05/15/22  05/15/22  WDAE-1250
LIC  Tampa Daily Times		     EM   761  BAL  3M	      Tampa, FL

272  05/16/22 WDAF Kansas City, MO	  05/16/22  05/16/22  WDAF-610
LIC  Kansas City Star		     E	  761  CHI  3M	      Kansas City, MO

273  05/16/22 WDAG Amarillo, TX 	  05/16/22  05/16/22  KGNC-710
LIC  J. Laurance Martin 	     E	  761  NO   3M	      Amarillo, TX

274  05/16/22 WDAH El Paso, TX		  05/16/22  05/16/22  DEL 10/01/40
LIC  Mine & Smelter Supply Company   E	  761  NO   3M

275  05/16/22 WDAI Syracuse, NY 	  05/16/22  05/16/22  DEL 11/19/23
LIC  Hughes Electrical Corporation   E	  761  DET  3M

276  05/18/22 KDYY Denver, CO		  05/17/22  05/18/22  DEL 03/--/23
LIC  Rocky Mountain Radio Corp	     E	  761  CHI  3M

277  05/18/22 WDAJ College Park, GA	  05/17/22  05/18/22  DEL 09/10/23
LIC  Atlanta & West Point Railroad   E	  761  BAL  3M

     05/19/22 Delete WGM [82] Atlanta, GA

278  05/19/22 KDZA Tucson, AZ		  05/18/22  05/19/22  DEL 04/12/23
LIC  Arizona Daily Star 	     E	  761  SF   3M

279  05/19/22 WDAL Jacksonville, FL	  05/18/22  05/19/22  DEL 12/22/23
LIC  Florida Times-Union	     EM   761  BAL  3M

280  05/19/22 WDAM New York, NY 	  05/18/22  05/19/22  WNBC-660
LIC  Western Electric Company	     E	  761  NYC  3M	      New York, NY

281  05/19/22 WDAN Shreveport, LA	  05/18/22  05/19/22  KEEL-710
LIC  Glenwood Radio Corporation      E	  761  NO   3M	      Shreveport, LA

282  05/19/22 WDAO Dallas, TX		  05/18/22  05/19/22  DEL 06/--/24
LIC  Automotive Electric Company     E	  761  NO   3M

283  05/19/22 WDAP Chicago, IL		  05/19/22  05/19/22  WGN-720
LIC  Mid West Radio Central Inc      E	  761  CHI  3M	      Chicago, IL

284  05/20/22 KDZB Bakersfield, CA	  05/19/22  05/20/22  DEL 02/12/26
LIC  Frank E. Siefert		     E	  761  SF   3M

285  05/20/22 WDAQ Brownsville, PA	  05/19/22  05/20/22  DEL 01/22/23
LIC  Hartman-Riker Elec & Mach Co    E	  761  DET  3M

286  05/20/22 WDAR Philadelphia, PA	  05/19/22  05/20/22  WFIL-610
LIC  Lit Brothers		     E	  761  BAL  3M	      Philadelphia, PA

287  05/22/22 WDAK Hartford, CT 	  05/17/22  05/22/22  DEL 07/30/24
LIC  The Courant		     E	  TG   OWN  3M

288  05/22/22 WDAS Worcester, MA	  05/20/22  05/22/22  DEL 01/03/25
LIC  Samuel A. Waite		     E	  761  BOS  3M

289  05/22/22 WDAT Worcester, MA	  05/20/22  05/22/22  DEL 10/05/22
LIC  Delta Electric Company	     E	  761  BOS  3M

290  05/22/22 WDAU New Bedford, MA	  05/20/22  05/22/22  DEL 11/18/24
LIC  Slocum & Kilburn		     E	  761  BOS  3M

291  05/22/22 WDAW Atlanta, GA		  05/20/22  05/22/22  DEL 08/28/23 (WGM)
LIC  Georgia Railway & Power Co      EM   761  NOR  3M

292  05/23/22 KDZD Los Angeles, CA	  05/22/22  05/23/22  DEL 11/08/22
LIC  W. R. Mitchell		     E	  761  SF   3M

293  05/23/22 KDZE Seattle, WA		  05/23/22  05/23/22  KMPS-1300
LIC  The Rhodes Company 	     E	  761  SF   3M	      Seattle, WA

294  05/23/22 WDAV Muskogee, OK 	  05/22/22  05/23/22  DEL 01/15/23
LIC  Muskogee Daily Phoenix	     E	  761  NO   3M

295  05/23/22 WDAX Centerville, IA	  05/22/22  05/23/22  DEL 01/03/24
LIC  First National Bank	     E	  761  CHI  3M

296  05/23/22 WDAY Fargo, ND		  05/22/22  05/23/22  WDAY-970
LIC  Kenneth M. Hance		     EM   761  CHI  3M	      Fargo, ND

297  05/25/22 KDZF Los Angeles, CA	  05/24/22  05/25/22  DEL 04/04/24
LIC  Automobile Club of Southern Ca  E	  761  SF   3M

298  05/25/22 KDZG San Francisco, CA	  05/24/22  05/25/22  DEL 06/16/23
LIC  Cyrus Peirce & Company	     E	  761  SF   3M

299  05/25/22 KDZH Fresno, CA		  05/24/22  05/25/22  DEL 05/16/23
LIC  Fresno Evening Herald	     E	  761  SF   3M

300  05/25/22 WEAA Flint, MI		  05/24/22  05/25/22  WFDF-910
LIC  Fallain & Lathrop		     E	  761  DET  3M	      Flint, MI

301  05/25/22 WEAB Fort Dodge, IA	  05/24/22  05/25/22  DEL 10/30/23
LIC  Standard Radio Equipment Co     E	  761  CHI  3M

302  05/25/22 WEAC Terre Haute, IN	  05/24/22  05/25/22  DEL 03/05/23
LIC  Baines Elec Service Company     E	  761  CHI  3M

303  05/25/22 WEAD Atwood, KS		  05/24/22  05/25/22  DEL 08/13/23
LIC  Northwest Kansas Radio Supply   E	  761  CHI  3M

304  05/25/22 WEAE Blacksburg, VA	  05/24/22  --/--/--  DEL 03/01/23
?    Virginia Polytechnic Institute  E	  761  ---  ---

     05/25/22 Change WDAM [280] New York, NY
     CALL: WEAF

305  05/26/22 KDZI Wenatchee, WA	  05/25/22  05/26/22  DEL 07/18/24
LIC  Electric Supply Company	     E	  761  SEA  3M

306  05/26/22 KDZJ Eugene, OR		  05/25/22  05/26/22  DEL 11/02/22
LIC  Excelsior Radio Company	     E	  ---  SEA  3M

307  05/26/22 WEAH Wichita, KS		  05/25/22  05/26/22  KFH-1330
LIC  Wichita B.O.T. & Lander Radio   EM   761  ---  3M	      Wichita, KS

308  05/27/22 WEAI Ithaca, NY		  05/26/22  05/27/22  WHCU-870
LIC  Cornell University 	     E	  761  DET  3M	      Ithaca, NY

309  05/27/22 WEAJ Vermillion, SD	  05/26/22  02/06/23  KUSD-690
AUT  University of South Dakota      E	  TG   OWN  3M	      Vermillion, SD

310  05/29/22 KDZK Reno, NV		  05/27/22  05/29/22  DEL 11/30/23
LIC  Nevada Machinery & Electric Co  E	  761  SF   3M

311  05/29/22 KDZL Ogden, UT		  05/27/22  05/29/22  DEL 03/13/23
LIC  Rocky Mountain Radio Corp	     E	  761  SF   3M

312  05/29/22 KDZM Centralia, WA	  05/28/22  05/29/22  DEL 03/12/23
LIC  E. A. Hollingworth 	     E	  761  SEA  3M

313  05/29/22 WEAG Edgewood, RI 	  05/25/22  05/29/22  DEL 11/12/23
LIC  Nichols-Hineline-Bassett Lab    E	  761  BOS  3M

314  05/31/22 KDYX Honolulu, HI 	  05/16/22  05/31/22  DEL 06/17/24
LIC  Star Bulletin		     E	  TG   OWN  3M

315  05/31/22 KDZP Los Angeles, CA	  05/31/22  05/31/22  DEL 01/24/23
LIC  Newberry Electric Corporation   E	  761  SF   3M

316  05/31/22 KDZQ Denver, CO		  05/31/22  05/31/22  KHOW-630
LIC  Motor Generator Company	     E	  761  CHI  3M	      Denver, CO

317  05/31/22 KDZR Bellingham, WA	  05/31/22  05/31/22  DEL 12/20/24
LIC  Bellingham Publishing Company   E	  761  SF   3M

318  05/31/22 WEAK Saint Joseph, MO	  05/31/22  05/31/22  KGBX-1260
LIC  Julius B. Abercrombie	     E	  761  CHI  3M	      Springfield, MO

319  05/31/22 WEAM North Plainfield, NJ   05/31/22  05/31/22  DEL 12/21/28
LIC  Borough of North Plainfield     E	  761  BAL  3M
