HOW TO SUCCEED IN FREELANCING WITHOUT BEING "TRYING"
By Douglas Arnold, Executive Producer, Quantum Productions

It seems that everybody wants to be a freelancer today.  The least amount of
film or video experience suddenly transforms a novice technician into a
freelancing professional anxious to take on any and every job.

As a producer and director, I've hired and fired my share of freelancers.  I
often thought that if only someone would give these men and women some idea of
what the real world is like, they would be able to advance their careers with
fewer headaches -- both for themselves and for the producers they work for
during a project.

This is by no means a comprehensive list of ideas, opinions or recemmendations,
but I think it is a good start.  Freelancers, regardless of age or experience,
can benefit from some or all of these ideas presented.	I welcome your comments
and hope other producers and directors will contact me with other ideas to
expand on this document.  I will update it as often as I get new material.

You will find three subchapters entitled "How Much Do You Really Know You
Know?", "The Business of Freelancing" and "Preparing for an Assignment." It
takes about ten minutes to finish the entire article.

So, let's begin at the beginning:

1.  HOW MUCH DO YOU REALLY KNOW YOU KNOW?

O.K., you went to college and have a degree in communications/ speech/
journalism/ theatre/ etc.  You know how (or should) to walk around a studio or
set and turn on some fancy equipment.  You know the difference between 3/4" and
1", as well as how to point a camera at a subject.  But how many assignments
have you really been on?  How much tape have you edited or shot?  I, as a
producer hiring experienced people, want to know your level of experience in
hours of tape shot, not numbers of cassettes!

Regretfully, there are more recent grads out there than jobs.  Most experienced
producers can spot them in a New York second -- age 21 to 24, full of
enthusiasm, a resume padded heavily with co-op assignments, charity activities
and some "hands-on" internships.

Most of these novices are looking for their first real break in commercial
production and they freelance to stay alive until a real 40-hour a week job
opens up.  If they have a demo tape it is of their college extra-credit
assignment, usually of kids, animals or old people.

These are not criticisms, just observations.  I've seen dozens - more than a
hundred - resumes of this type.  The University of Missouri Journalism School
is about 100 miles from here and it turns out some of the best grads anywhere.
Most return home to St.  Louis and eventually I get their resume.  Most are
heavy on education, light on experience.

If you are a recent grad with limited professional (as in "I got paid money for
this job") experience, don't try to dazzle people with your resume.  It will
show through immediately.

So you don't have years, or even months, of experience.  Producers will
consider young talent if they are mature, willing to following orders,
recognize their limited economic value and have an positive, hard-working
attitude.

Maturity is simple to define.  Be on time.  Be neatly and appropriately dressed
for your duties.  This means a suit sometimes, and jeans sometimes.  Being
mature is knowing when to do things.  Know when to keep quiet and when to
speak.	Most immature freelancers run at the mouth constantly; and in front of
clients this can be a problem to the producer.

Willingness to follow orders is vitally important.  I was recently on a shoot
and my gaffer would not light the scene the way my director wanted it lit.  The
gaffer was a professional -- he told my director his opinion of how it should
be lit.  This is not only fine, but I expect my professionals to make good
recommendations, even if it is not the way I originally planned.

He was polite and direct, no beating around the bush.  My director listened to
the gaffer's idea.  I like this director a great deal; she knew the man had
lighting experience and respected his knowledge.  However, when he was through
explaining his recommendation, she said it was a good idea but not appropriate
for the mood the script called for.  The problem resulted when the gaffer
refused to set up the lights the way the director wanted them prepared.  He
wanted to set them up his way and show her the effect.

Now my director was quite experienced and could mentally visualize most
lighting situations.  She also knew that we were on a tight schedule -- and
translate that into every additional hour meant hundreds of dollars spent by
the client.

The two went back and forth for about ten minutes before the diretor called me
and explained the situation.  She was not authorized to fire the gaffer; I was.
I heard her side and asked the gaffer for his side.  (A good producer mediates
everything and should always hear both sides before making a decision) I
respected his opinion but felt the director had a better understanding of the
overall "look" and "feel" of this production.  Her lighting set up was to be
prepared immediately and the gaffer was informed that he would follow her
orders on this shoot without getting me involved again.

I told him that if was to work for me again, my directors were the final
authority on everything that occurs on a set.  He understood, but more than 45
minutes were lost on a very busy day.  And he knew that my directors were in
charge of all creative decisions before he took the job.

Creative recommendations are important.  They should be expressed, but when
prima donna directors, scriptwriters, gaffers, shooters, and talent clash one
-- and only one -- person will ultimately be in charge.  Know who that person
is and do what that person wants done.

Recognize that you have limited economic value to the producer.  What does this
mean?  Simply put, the producer is going to spend more of the client's money on
experienced professionals than for young professionals still learning the
business.  Most young people don't understand the principle that you don't get
paid for the amount of work you do, you get paid for how you do your work.
This relates to the saying "Work Smarter, Not Harder," but for most apprentice
workers you must work smarter and harder.

A young production assistant stopped me during a shoot several years ago and
said he did not understand why he got only $90 a day for being a production
assistant (a.k.a.  "go-fer"/grip/driver/etc.).  He complained that he was
working his ass off doing grunt work when he knew more than the videographer
doing the shooting.

I reminded him that he was hired as a production assistant and that he knew he
was a P.A.  when he signed on to the shoot.  I didn't need two shooters, I
needed a shooter and a P.A.  and he was the P.A.

He did not like the fact the shooter was getting $150 a day for a lot less
"sweat work."

Maybe he was a better shooter.	Today, I know he is a better videographer.  But
he was hired as a P.A.	and he was paid P.A.  wages.  I make sure my crew knows
what they are to do and what they get paid before they work for me.

New grads are not going to get paid the same as experienced, older workers.
These workers usually know tricks of the trade, shortcuts and pitfalls to
avoid.	Younger workers are expected to learn while they earn, but earn less.

Many producers won't hire new grads at all.  They don't want to be bothered
with overly enthusiastic, under-experienced people on a set.  I must confess,
if the client is going to hover over a shoot, I don't want a novice doing
something foolish in front of my bread-and-butter.  There are jobs where new
grads are welcome, and their are jobs where they are best avoided.

Now, the subject of working hard.  Really, I mean working "harder", usually
harder than anyone on the crew.  I look for young people who are willing to do
any job, large/small, heavy/light, minor/major with the right attitude.

A person succeeds in life partially because of their attitude.	I like
positive, upbeat people on my crews.  I want my crew's spirit to be high.  This
sends a message to my clients that we are confident, capable and creative.

Hard workers surface in every profession.  They go the extra mile, do the
little things, and follow up on every detail.  It is hard to explain, but it is
easy to see when someone is a hard worker.  Usually it is in contrast with
other workers who just aren't putting 100 percent into their task.  The hard
worker is obvious.

I remember a videographer who did not carry or move the camera equipment on the
set -- that was left for P.A.s to do.  He was a bit of a prima donna, but
outstanding creatively.  He worked hard finding the right angles, the right
lighting, the right movement for each shot, but he rarely touched the camera.

When our day of shooting was over and we were breaking the set, he walked over
and picked up some trash that was blowing across the floor.  He helped pitch in
loading our grip and offered to take one of our gaffers home, even though it
was out of his way.  He had worked hard doing his job during the day, and after
the shoot continued to be a team player by offering to do more.

A producer looks for people with maturity, the ability to follow orders, a
solid grasp of their true economic value and the ability and willingness to
work hard.

2.  THE BUSINESS OF FREELANCING

Many freelancers don't know there is more to freelancing than just working.
Much more.

First, the IRS is interested in your work, or more appropriately, the fruits of
your labor.  If you make more than $600 from any one job, the producer who
hired you is obligated to file a Form 1099 with the IRS.  This lists all money
you earned on the freelance job along with your social security number and
address.  Failure to report income could be hazardous to your freedom and
future.

Keep good records.  Know who you worked for and when.  Know precisely how much
you were paid and get be sure to invoice for jobs completed.  Even if you were
paid in cash, you must keep good records.

Most producers today are faced with considerable liability burdens.  Insurance
rates for production have gone up dramatically.  If you are independently
insured as a freelancer you may be able to find more employment.  This is
because your insurance reduces the cost normally paid by the producer to insure
crew and equipment on a shoot.	Be sure to discuss this with your insurance
agent before telling a producer you are covered.  It is vitally important that
you have special coverage for your liabilities when working -- equipment
damage, injuries to you or other parties, etc.	Having such insurance coverage
is a good idea anyway.

If you do not have special coverage you may be asked to sign a waiver of
liability.  I get one from all of my freelancers who do not have insurance
coverage of their own.	It simply states you will not hold the producer or
client liable for any accidents that occur during the production.  It may also
state that the freelancer will be held responsible for any and all damage and
injuries that occur while he or she is operating or responsible for equipment
during the duration of a production.

I always get a signed letter of agreement from freelancers prior to an
assignment.  This letter spells out the terms of payment, when and where the
work is to be accomplished, the duties and responsibilities of the freelancer
and other details (dress code, safety, travel, insurance, etc.) that may be
necessary.  This way the producer and freelancer know precisely what is to be
expected during a job.	The successful producer lives by the motto "NO
SURPRISES!"

So should the successful freelancer.

3.  PREPARING FOR AN ASSIGNMENT

I can tell precisely how professional a freelancer is by his or her interest in
a project during the initial contact.  Most of my most trusted freelancers are
eager to prepare for an assignment.

Doing one's homework involves several things.  For the production crew it means
reviewing the script and shoot list well in advance of the actual day of
shooting.

For the creative workers it is important to have some understanding of the
client -- who they are, where they are from, what they do, who their customers
are, what their services or products are, and what their services and products
do.

I always have client literature available for my "eyeball" people - directors
and videographers.  These people must be able to "see" the video production
from the very start.  Of course, if I don't write the script or produce the
project, my scriptwriters and producers work with such resources first.

Quite often there are previous films, videos or slide shows available that help
define the visual personality of a company or institution.  These should be
reviewed before scripts or storyboards are prepared.  Freelancers who can
identify such traits such as logoes, packaging identities or other visual
"corporate signatures" are very valuable to me and other producers.

It is also expected that the freelancer know the equipment that is going to be
used on the shoot.  Often the producer packages a variety of rental equipment
from a variety of suppliers for a project.  This means that all personnel who
will handle equipment should be familiar with the technology used.

I would rather have a freelancers say "I've never worked with a JVC 4900, but
I'll get the book immediately," than pretend he or she knows how to operate the
same.  Handbooks, directories and guides should be made available prior to the
shoot so freelancers can familiarize themselves with the machines that will
capture the images desired.

Most rental houses will provide the original guides on cameras, recorders,
editors, etc.  and these resources should be reviewed.	Nothing will ruin your
reputation faster than messing up a shoot.  If a director expects you to know
how to operate an "Iki" or any other type of equipment you better be ready to
shoot efficiently on the day of production.

Novices who tinker and fuss around a camera or recorder trying to get it to
work usually have limited careers as freelancers.  Know thy equipment!

Freelancing can be a profitable and exciting way of making a living.  I hope
these few ideas help you and others discover what producers and directors look
for and expect from freelancers.

A good friend has been a professional freelancer for more than 18 year in St.
Louis - which is known to be a tough market.  He has shared some of his
experiences with me and and after more than 18 years his mother, to this day,
tells all of her friends that her son makes a living as a video "freeloader." I
hope your freelancing prospers and grows.

Best wishes.
Douglas Arnold (76456,2630)
Executive Producer
Quantum Productions
Suite 320T
225 S. Meramec
St. Louis, MO  63105

