
WHAT ARE BLACK HOLES? By Andrew Fraknoi and Sherwood Harrington

  JUST TWO DECADES ago, black holes were an interesting footnote to our
astronomical theories that few non-specialists had heard about.  Today, black
holes have "arrived" - one hears about them in Hollywood thrillers, in cartoon
strips, and more and more on the science pages of your local newspaper.

  What exactly are these intriguing cosmic objects and why have they so
captured the imagination of astronomers and the public?

  A black hole is what remains after the death of a very massive star.
Although stars seem reasonably permanent on human time scales, we know that
over the eons all stars will run out of fuel and eventually die.  When smaller
stars like our own Sun burn out, they simply shrink under there own weight
until they become so compact they cannot be compressed any further.  (This will
not happen to the Sun for billions of years, so there is no reason to add a
rider to your home owners policy at this time!)

  When the largest (most massive) stars have no more fuel left, they have a
much more dramatic demise in store for them.  These stars have so much material
that they just cannot support themselves once their nuclear fires go out.
Current theories predict that nothing can stop the collapse of these huge
stars.	Once they begin to die, whatever remains of them will collapse FOREVER.

  As the collapsing star falls in on itself, pull of gravity near its surface
will increase.	Eventually its pull will become so great that nothing - not
even light - can escape, the star will look BLACK to an outside observer.  And
anything you throw into it will never return.  Hence astronomers have dubbed
these collapsed stellar corpses "black holes."

  Alert readers will quickly note that this expanation of black holes does not
bode well for finding one.  How do we detect something that cannot give off any
light (or other form of radiation)?  You might suggest that we can spot a black
hole as it blocks the light of stars that happens to lie behind it.  That might
work if the black hole hovered near the Earth, but for any black holes that are
a respectful distance away in space, the part of the sky it would cover would
be so small as to be invisible.

  To make matters worse, the sort of black hole that forms from a single
collapsing star would be only 10 or 20 miles across - totally insignificant in
size compared to most objects astronomers study and much too small to help a
distant black hole hunter on Earth.

  The size of a black hole, by the way, is not the size of the collapsing star
remnant.  The stuff of the former star does continue to collapse forever inside
the black hole.  What gives the hole its "size" is a special zone around the
star's collapsing core, called the "event horizon." If you are outside this
zone, and you have a powerfull rocket, you still have a chance to get away.
Once you passed inside this zone, the gravitational pull of the collapsing
stuff is so great, nothing you can do can help you from being pulled inexorably
to your doom.  The name "event horizon" comes from the fact that once objects
are inside the zone, events that happen to them can no longer be communicated
to the outside world.  It is as if a tight "horizon" has been wrapped around
the star.

  How then could we detect these bizzare objects and verify the strange things
predicted about them?  It turns out that far away from a black hole the only
way to detect it is to "watch it eating."

  If a black hole forms in a single star system, there is very little material
close to the collapsed remnant for its enormous gravity to pull in.  But we
believe that more than half of the stars form in double, triple or multiple
systems.  When two stars orbit each other in proximity, and one becomes a black
hole, the other one may have some difficult times ahead.

  Under the right circumstances, material from the outer regions of the normal
star will begin to flow toward its black hole companion.  As particles of this
stolen material are pulled into a twisting, whirling stream around the black
hole's event horizon, they are heated to enormous temperatures.  They quickly
become so hot that they glow - not just with visable light, but with far more
energetic X-rays.  (Of course, all this can be seen only above the event
horizon; once the material falls into the horizon, we have no way of ever
seeing it again.)

  Astronomers began searching in the 1970s for the tell-tale X-rays that
indicate that a black hole is consuming a part of its neighbor star.  Since
cosmic X-rays are blocked by the Earth's atmosphere, these observations became
possible only when we could launch sensitive X-ray telescopes into space.  But
in the last decade and a half, at least three excellent candidates for a
"feeding" black hole have been identified.

  Probably the best-known case is called Cygnus X-1, a system in the
constellation of Cygnus the swan, in which we see a normal star that appears to
be going around a region of space with nothing visable in it.  Smack dab from
the middle of that region, we see just the sort of X-rays that reveal the
stream of material being sucked into the hole.

  While this sort of indirect evidence is not quite as satisfying as seeing a
black hole "up close," for now (and perhaps fortunately) it will have to do.
What is intriguing astronomers these days is the posibility that enormous black
holes may have formed in crowded regions of space.  These may not just eat part
of a companion star, but may actually consume many of their neighbor stars
eventually.  What we would then have is an even larger black hole, able to eat
even more of the material in its immediate neighborhood.

  In the most populated areas of a galaxy - for example, its center - black
holes may ultimately form that contain the material of a million or billion
stars.	In recent years, astronomers have begun to see tantalizing evidence
from the center of our own galaxy and from violent galaxies in the distant
reaches of space indicating that such supermassive black holes may be more
common than we ever imagined.  If this evidence is further confirmed, we may
find that the strange black hole plays an important role not only in the death
of a few stars but even in the way entire galaxies of stars evolve.

