
***************************************
*                                     *
*                                     *
*   MACHINE LANGUAGE TUTORIAL DISK    *
*                                     *
*      WRITTEN BY DR. FIRMWARE        *
*                                     *
*                                     *
***************************************


The aim of this disk is for you the    
reader to understand machine language  
to an extent so that you can program   
fully in machine language (ml).


PART I


The fundamentals.


The first part of the course is number 
bases. if you undestand binary and     
hexadecimal numbers and conversion     
between these and decimal, you can skip
to the next section.


Binary: Base two.


Number bases are what we are dealing   
with here. The number base that we     
normally use in everday life is        
decimal. 'Decimal' comes from latin    
where it meant ten. We have ten digits,
0,1,2,3,4,5,6,7,8, and 9, which are    
combined in various ways to produced   
other numbers. It is understood that   
the number '345' means 3x100+4x10+5x1. 
The right-most digit has the least     
significance, while the left-most has  
the most significance. From left to    
right, the numbers that are multiplied 
with the digits are successive powers  
of 10. 1=10~0, 10=10~1, 100=10~2, etc. 

Now applying these fundamentals, we'll 
construct the base two, or binary,     
number system. First there are two     
digits, 0, and 1. So, the right-most   
digit has the least significance and   
the left-most, the most significance,  
just like in decimal. Now, the numbers 
multiplied with the digits will be     
successive powers of two. 2~0=1, 2~1=2,
2~2=4, 2~3=8, etc. We now have the     
basics down, so we'll take a number,   
such as '1001101', and find it's       
decimal value.

To start, we'll take the right-most    
digit and find out what it is          
multiplied with. Since it's the right- 
most digit, it's multiplied with two   
to the power of zero. 1x2~0=1. Now,    
repeat the process, this time with the 
second right most digit, which is a 0. 
0x2~1=0. Continueing produces: 1x2~2=4,
1x2~3=8, 0x2~4=0, 0x2~5=0, and         
1x2~6=64. Summing the results,         
1+0+4+8+0+0+64=77. So 77 is the decimal
value of the binary number 1001101.

If you want to practice some, just make
strings of 0's and 1's and do what we  
did above.

Conversion from decimal to binary is a 
little more complex. Suppose we take a 
decimal number, 35. To convert, we do a
series of steps.

1> Divide the number by two, and put   
the remainder aside.

2> Replace the dividend with the       
quotient.

3> Repeat step 1 & 2 until the number  
reaches zero.

4> Take the remainders and place them  
in a row, the first is right-most, the 
last is left-most.

And that's it. To demostrate, we'll    
convert 35 to binary.

       0 R=1 -------
     ---           !
   2)  1 R=0       !
     ---           !
   2)  2 R=0       !
     ---           v
   2)  4 R=0       100011
     ---                ~
   2)  8 R=1            !
     ---                !
   2) 17 R=1 ------------
     ---
   2) 35

There. Quite simple. The diagram would 
look somewhat better on paper, but this
will have to do in the mean while.


Hexadecimal


'Hex', as it is affectionately called  
by in most computerese dialects, is    
nothing more than a base sixteen number
system. Let's go through some basics.  

It has 16 digits. These digits are the 
numbers 0-9, and the letters A-F. The  
reason why the letters are included is 
because there aren't enough numbers.   
Let's take a number, $4A. Note that    
when you see a '$' infront of a number,
it denotes that the number is a hex    
number. $4A means 4x16~1+10x16~0. The  
letters are the numbers from 10-15, A  
being 10, B is 11, C=12, etc.

Conversion to decimal is exactly the   
same as for binary. To demostrate we'll
convert 10234 to hex.

            0
       ------
    16)     2  R=7  ----
       ------          v
    16)    39  R=15    7FA
       ------            ~
    16)   639  R=10 -----/
       ------
    16) 10234


There we are! 10234 is $7FA.

One interesting fact: since 16=2~4,    
then a 4 digit binary number is equal  
to 1 hex digit, i.e. 1111=$F, 1010=$A, 
etc. This makes binary to hex, and     
vice versa, conversion very easy. For  
example, the number $3A0 in binary is  
  0011 1010 0000.
   ~    ~    ~
   !    !    $0
   !    $a
   $3


This ends the discussion on number     
bases and now the reader should be     
aquianted with binary and hex and what 
they mean.


Bits and Bytes.


A bit is really only a binary digit.   
In other words, a 1 or a 0. These are  
digital computers handle, strings upon 
strigs of bits. Unfortunately, bits are
very combersome, because even the      
charcters that you see require 8 bits  
each. The screen size is 40x24, and    
that adds up to 7680! bits!

A more convinient form are two digit   
hex numbers. A two digit hex number    
represents 8 bits in only two digits.  
A more common name for this compact    
unit is a byte.

You might know that your computer has  
64K RAM. The K represents 1,024 bytes. 
So this means that your computer has   
65,536 bytes of RAM memory. 65,536 can 
be expresses more conviniently as 2~16.
This is important for reasons that     
we'll discuss a little later.

Well, there we are! Now that we have   
some basics down, we can get to some   
machine language.

=======================================
DR. FIRMWARE, OCT 21st, 1985.          
I CAN BE REACHED ON TESTY, 514-332-6852
OR ON TRANSFERS AE, 514-738-1247       
=======================================

