:::::::::::::::::::::::::::::::::::::::
::*:::::::::::::::::::::::::::::::::*::
:::				    :::
:::   DISK TIPS & TRICKS TUTORIAL   :::
:::		PART 1		    :::
:::	  INTRODUCTION TO DOS	    :::
:::				    :::
:::	    BY CANDY APPLE	    :::
:::				    :::
::*:::::::::::::::::::::::::::::::::*::
:::::::::::::::::::::::::::::::::::::::

   *:::::::::::::::::::::::::::::::*
   ::	    DISTRIBUTED BY	  ::
   :: CRYSTAL CASTLE 313/856-3804 ::
   *:::::::::::::::::::::::::::::::*

  THIS ARTICLE CONTAINS AN OVERVIEW OF HOW A NORMAL DISK IS FORMATTED AND DIS-
CUSSES BRIEFLY THE TWO WAYS OF READING A DISK.	IT IS WRITTEN FOR THOSE WHO
AREN'T FAMILIAR WITH DOS OR FOR THOSE WHO WANT A SHORT REVIEW ON DISK FORMAT-
TING, ETC.

  FIRST LET'S START OFF WITH A LITTLE BACKGROUND ON HOW DOS FORMATS A DISK.
WHEN A DISK IS 'INIT'IALIZED BY DOS, IT WILL DIVIDE IT INTO 35 CONCENTRIC
TRACKS.  IF YOU HAVE DOS 3.3, THEN EACH TRACK WILL BE DIVIDED INTO 16 BLOCKS
CALLED SECTORS, WHEREAS DOS 3.2 WILL CREATE 13 SECTORS.  ON EACH OF THESE
SECTORS ARE AN ADDRESS MARK AND A DATA MARK.

  THE ADDRESS MARK WILL TELL DOS WHAT TRACK AND SECTOR IT IS CURRENTLY READ-
ING.  WITHIN THIS ADDRESS MARK, THE VOL- UME, TRACK, SECTOR, AND CHECKSUM INFOR-
MATION CAN BE FOUND.  THE DATA MARKS SURROUNDS THE ACTUAL DATA AND TELLS DOS
WHERE THE DATA BEGINS AND ENDS.  IT ALSO CONTAINS A CHECKSUM THAT'S USED TO VER-
IFY THE ACCURACY OF THE DATA.

  THE TRACKS ARE NUMBERED FROM $00 (0- DEC.) TO $22 (34-DEC.); WHEREAS THE
SECTORS ARE NUMBERED FROM $00 (0) TO $0F (15).	THE DOS PROGRAM USES TRACKS $00
THRU TRACKS $02 (A TOTAL OF 3 TRACKS;0,1,2).

  THE DOS ALLOWS THE APPLE TO MANIPULATE DATA ON A DISKETTE.  WITHIN THE DOS
PRO- GRAM ARE ALL OF THE COMMANDS THAT CON- TROL THE DISKDRIVE (I.E.:  CATALOG,
INIT, LOAD...) AND THE ERROR MESSAGES WHICH YOU HAVE PROBABLY SEEN BY NOW.

  ON THE DISK CONTROLLER CARD THAT CON- NECTS THE APPLE TO YOUR DISK DRIVE IS A
SMALL PROGRAM, SO THAT WHEN YOU BOOT A DISK, IT WILL TELL THE DISK DRIVE TO READ
TRACK $00(0).  THE PROGRAM ON TRK $00, SCT $00 CONTAINS THE INFORMATION TO READ
IN SECTORS $00-$09 ON TRACK $00.  THIS PROGRAM ON SECTORS $00-$09 WILL READ IN
THE REMAINING INFORMATION ON TRK $00-$02.  IN OTHER WORDS, THE APPLE HAS NOW
LOADED THE DOS, AND DOS WILL NOW TAKE OVER AND RUN THE PROGRAM YOU HAVE
INITIALIZED THE DISK WITH.

  DOS FINDS THE HELLO PROGRAM BY GOING TO THE VOLUME TABLE OF CONTENTS (VTOC)
AND DIRECTORY THAT'S LOCATED ON TRACK $11 (17).  THE VTOC OR "BIT MAP" WILL SHOW
WHICH SECTORS ARE USED AND WHICH ARE FREE.  THE DIRECTORY BEGINS ON SECTOR
$0F(15) AND CONTINUES ON DOWN TO SECTOR $01(19).  THE VTOC AND DIRCECTORY ARE
USED BY DOS WHEN YOU SAVE OR DELETE A FILE.

  WITHIN THE DIRECTORY, YOU WILL FIND A LIST OF ALL THE FILES FOUND ON THE DISK.
EACH ENTRY CONTAINS A POINTER TO THE TRACK/SECTOR LIST, FILE-LOCKED AND
FILE-TYPE CODE, FILE-NAME AND FILE-SIZE WHICH WE'LL GO INTO MORE DETAIL LATER.
ACTUALLY THE TRK/SCT LIST IS A LIST OF THE TRK/SCT PAIRS THAT STORE THAT FILE.
THAT'S WHY SAVING A BLANK FILE ALWAYS TAKES 2 SECTORS BECAUSE ONE IS USED FOR
THE BLANK FILE AND ONE IS FOR THE TRK/ SCT LIST.

  BECAUSE THE CATALOG TRACK IS IN THE CENTER OF THE DISK, THE ARM NEVER HAS TO
TRAVEL MORE THEN 17 TRACKS TO GET TO THE CATALOG TRACK.  THEN AS FILES ARE
ALLOCATED ON THE DISK, THEY WILL OCCUPY THE TRACKS JUST ABOVE THE CATALOG FIRST
UNTIL IT REACHES TR $22(34), THEN IT WILL START USING THE TRACKS JUST BELOW THE
CATALOG $10(16), THEN TRACK $0F(15) ETC, MOVING TOWARDS THE DOS IMAGE TRACKS.

  ANOTHER THING THAT'S INTERESTING TO KNOW IS THAT WHEN YOU 'SAVE' OR 'BSAVE' A
PROGRAM, DOS WILL TOTALLY ALTER THE PROGRAM CODE BEFORE IT IS WRITTEN TO THE
DISK.  THEN WHEN YOU 'LOAD' OR 'RUN' THAT PROGRAM, DOS WILL CHANGE IT BACK AGAIN
TO ITS ORIGINAL FORM, ALTHOUGH THE USER NEVER NOTICES THIS PROCESS.

  YOU MIGHT WONDER WHY DOS GOES TO ALL THIS EXTRA TROUBLE?  ACTUALLY THE AP-
PLE'S HARDWARE (AND THAT OF OTHER MA- CHINES) HAS SOME LIMITATIONS WHICH RE-
STRICT THE RANGE OF BYTE VALUES THAT CAN BE ALLOWED TO PASS BETWEEN THE MA-
CHINE AND ITS DISK DRIVES.

  IF YOU TYPE "CALL -151" AND LIST A RANGE OF MEMORY (SAY 'F800.FFFF'), YOU WILL
NOTICE THAT ALMOSE EVERY BYTE VALUE FROM $00 TO $FF CAN BE SEEN SCROLLING BY.
EVERYTHING THAT'S STORED IN RAM SUCH AS PROGRAMS, TEXT FILES, ETC.., IS
REPRESENTED BY A BLOCK OF HEX VALUES IN THIS RANGE.  THIS MEANS THAT THE APPLE
HAS 256 DIFFERENT BYTE VALUES TO USE FOR REPRESENTING INFOR- MATION IN MEMORY
(THERE ARE 256 DIFFER- ENT HEX NUMBERS IN THE RANGE OF $00 TO $FF).

  UNFORTUNATELY, WHEN THE APPLE COMMUNI- CATES WITH THE DISK DRIVES, IT CAN'T
HANDLE SUCH A LARGE RANGE OF VALUES DUE TO HARDWARE CONSTRAINTS.  DOS 3.3 CAN
ONLY SEND TO THE DISK OR RECIEVE FROM IT THE VALUES $96 TO $FF (150 TO 256).
EVEN SOME OF THESE BYTES WITHIN THAT RANGE ARE ILLEGAL BECAUSE THEY VIOLATE
APPLE HARDWARE RULES, AND OTHERS ARE RESERVED FOR SPECIAL DISK USE.  ACTUALLY
DOS 3.3 HAS TO REPRESENT ALL 256 DIF- FERENT VALUES THAT APPEAR IN RAM USING
ONLY 64 VALUES ON THE DISK.  EARLIER VERSIONS OF DOS HAD TO MAKE DO WITH A
SMALLER RANGE OF DISK BYTES.

THERE ARE 2 WAYS OF READING A DISK:

   1) A RAW NIBBLE DUMP
   2) AN RWTS READ.

  "RAW NIBBLES" REFERS TO INFORMATION EX- ACTLY AS IT IS REPRESENTED ON DISK -
IN THE SPECIALLY ENCODED FORM DESCRIBED ABOVE.

  NIBBLE DUMP YOU WILL NOTICE (ON A DOS 3.3 DISK) THAT THE HEX NUMBERS WILL BE
BETWEEN THE VALUES $96 TO $FF.	THIS IS HARDLY RECOGNIZABLE AS PROGRAM OR TEXT
FILE CODE.  YOU WILL ALSO SEE DOZENS OF HEX NUMBERS WHICH HELP DOS DO ITS JOB IN
GETTING INFORMATION ON AND OFF THE DISK.  THESE "DOS MARKS" WILL TELL YOU A
GREAT DEAL ABOUT THE DISK AND WILL BE COVERED IN A LATER TUTORIAL.

  THE OTHER WAY A DISK IS READ IS THROUGH A SUBROUTINE IN DOS CALLED "READ AND
WRITE TRACKS AND SECTORS" OR OTHERWISE KNOWN AS RWTS.  THIS ROUTINE PUTS DATA
(WRITES) ON THE DISK AND GETS IT BACK (READS).	ONE OF ITS IMPORTANT JOBS IS TO
TRANSLATE THE RAW NIBBLES FROM THE DISK INTO INTELLIGIBLE CODE FOR APPLE ROMS
AND PROGRAMMERS.

  THE RWTS WILL ALSO FILTER OUT THE DOS MARKS REFEREED TO EARLIER, BECAUSE ONCE
THE PROGRAM IS LOADED INTO MEMORY, THE DATA MARKS SERVE NO PURPOSE AND SO THEY
ARE DISCARDED AFTER BEING PICKED UP BY THE READ/WRITE HEAD.  JUST REMEMBER THAT
WHEN DOS LOADS AND RUNS ANY PROGRAM, IT WILL AUTOMATICALLY PERFORM AN RWTS READ
TO GET THE PROGRAM INTO MEMORY, WHEREAS A RAW NIBBLE DUMP COMES DIRECTLY FROM
THE DISK AND BYPASSES RWTS AND DOS ENTIRELY.

  IN THE NEXT TUTORIAL, WE'LL GET DOWN TO BUSINESS AND START EXAMINING THE VTOC
AND ITS INNER WORKINGS.

  INCLUDED BELOW IS A HEX, BINARY, DECI- MAL CHART WHICH MIGHT PROVE USEFUL TO
YOU IN LATER TUTORIALS.

  HEX	 BINARY   DECIMAL
   0   0000 0000    0
   1   0000 0001    1
   2   0000 0010    2
   3   0000 0011    3
   4   0000 0100    4
   5   0000 0101    5
   6   0000 0110    6
   7   0000 0111    7
   8   0000 1000    8
   9   0000 1001    9
   A   0000 1010   10
   B   0000 1011   11
   C   0000 1100   12
   D   0000 1101   13
   E   0000 1110   14
   F   0000 1111   15
  10   0001 0000   16
  20   0010 0000   32
  3F   0011 1111   63
  40   0100 0000   64
  7F   0111 1111  127
  80   1000 0000  128
  AA   1010 1010  170
  C0   1100 0000  192
  E8   1110 1000  232
  FE   1111 1110  254
  FF   1111 1111  255

=======================================
:::::::::::::::::::::::::::::::::::::::
::*:::::::::::::::::::::::::::::::::*::
:::				    :::
:::   DISK TIPS & TRICKS TUTORIAL   :::
:::		PART 2		    :::
:::	CLOSER LOOK AT THE VTOC     :::
:::				    :::
:::	    BY CANDY APPLE	    :::
:::				    :::
::*:::::::::::::::::::::::::::::::::*::
:::::::::::::::::::::::::::::::::::::::

   *:::::::::::::::::::::::::::::::*
   ::	    DISTRIBUTED BY	  ::
   :: CRYSTAL CASTLE 313/856-3804 ::
   *:::::::::::::::::::::::::::::::*

  THIS TUTORIAL WILL REPRESENT THE FIRST LEG OF YOUR JOURNEY TOWARDS DISK
EXPERTISE.  LET IT BE KNOW N THAT THE DOS MOD- IFICATIONS EXPLAINED BELOW AND
HEREAFTE R ONLY APPLY TO A STANDARD DOS 3.3 SLAVE DISK UNLESS OTHE RWISE STATED.
A DISK WITH ANY OTHER TYPE OF DOS SUCH AS DOS 3.2 OR A FAST DOS WILL HAVE
LOCATIONS WHERE MANY OF T HESE PATCHES WON'T WORK AND COULD EVEN RUIN A DISK.
IN FA CT IT'S BEST TO MAKE THESE PATCHES ON A SCRATCH DISK UN TIL THINGS WORK
PROPERLY.  THE AUTHOR IS NOT RESPONSIBL E FOR DAMAGE DONE TO ANY DISKETTE.

  TO CONTINUE WITH THIS TUTORIAL, YOU WIL L NEED A DOS 3.3 SLAVE DISK AND A
TRACK AND SECTOR EDITOR PROG RAM SUCH AS DISK EDIT, THE INSPECTOR, TRICKY DICK,
OR THE SECT OR EDITOR ON COPY II+, ETC.  ALSO, SO WE CAN WORK AND UNDERSTA ND ON
THE SAME LEVEL, MAKE A 'FID' COPY OF THE APPLE SYSTEM M ASTER DISKETTE AND LEAVE
IT UNPROTECTED.  NOW LETS GET STA RTED.


THE VOLUME TABLE OF CONTENTS
--- ------ ----- -- --------

  USING YOUR DISK EDIT PROGRAM, READ IN T RACK $11(17), SECTOR $00(0).	YOU ARE
NOW LOOKING AT THE VTO C WHICH WILL SOONER OR LATER IN YOUR LIFE GET OVERWRITTEN
WITH WORRY ABOUT FIXING A CLOBBERED VTOC RIG HT NOW BUT IN A LATER TUTORIAL
WE'LL DISCUSS THIS.

  LET'S TAKE A CLOSER LOOK AT THE FIRST L INE OF DATA STARTING WITH BYTE $00.
IT SHOULD LOOK SIMILIAR TO THE FOLLOWING:

BYTE  TRACK $11   SECTOR$00

00:  04 11 0F 03 00 00 FE 00


  THE FIRST NUMBER "04" DOESN'T HAVE ANY FUNCTIONS, SO IGNORE IT.  THE NEXT TWO
NUMBERS GIVE US THE F IRST CATALOG ENTRIES.  THE SECOND BYTE REPRESENTS THE
TRACK NU MBER AND THE NEXT IS THE SECTOR NUMBER.  IN OTHER WORDS, IT' S TELLING
US THAT THE CATALOG STARTS ON TRACK $11, SECTOR $0F (ON A DOS 3.2 DISK, IT
STARTS AT SECTOR $0C).	THE FOURTH B YTE, "03" TELLS US THAT THE DOS VERSION IS
3.3 (A "2" = 3.2).  THE FIFTH AND SIXTH BYTES AREN'T USED.  THE "FE" GIVES US T
HE DISK VOLUME NUMBER WHICH IN THIS CASE IS 254 DECIMAL.

  THE NEXT SEVERAL ROWS CONTAIN ZEROS BUT WHEN WE GET TO BYTE "$27", NOTICE THE
"7A".  THIS BYTE INDI CATES THE MAXIMUM NUMBER OF TRACK/SECTOR ADDRESSES THAT A
TRACK AND SECTOR LIST IS ALLOWED TO HOLD, SO $7A = 122 ( DECIMAL) OF 256 BYTE
SECTORS IN A TRACK/SECTOR LIST.

  STARTING WITH BYTE $30, YOU WILL SEE TH E FOLLOWING:

  BYTE $30....12 01 00 00 23 10 00 01

  THE FIRST NUMBER, "12", INDICATES THAT TRACK $12 WAS THE LAST TRACK ALLOCATED
BY DOS FOR FILE STORAGE .  THE NEXT NUMBER MAY BE DIFFERENT, SINCE A SMALL
VARIATION I N THE WAY FID WROTE OUT THE FILES COULD ALTER THE SELECTION OF THE
NEXT TRACK USED.  IF YOU HAVE "01", THAT TELLS US THAT TH E NEXT TRACK THAT DOS
WILL ATTEMPT TO WRITE TO IS $12 + $01 = $13.  INSTEAD OF A "1", YOU MIGHT SEE AN
"FF".  THIS TELLS DOS TO SEARCH IN A NEGATIVE DIRECTION, FOR EXAMPLE 12 - 1, FOR
THE NEXT AVAILABLE TRACK.  A HEX NUMBER WHOSE HIGH BIT IS SET OR WHOSE VALUE IS
$80 OR GREATER IS TAKEN AS A NEGATIVE N UMBER BY THE SYSTEM.

  NOW GO TO THE "23 10".  THESE BYTES INDI CATE THAT DOS HAS FOR- MATTED $23(35)
TRACKS ON THE DISK AND T HAT EACH TRACK CONTAINS $10(16) SECTORS.  THE "00 01"
ALSO INDI CATE THAT THERE ARE $100(256) BYTES PER SECTOR.  THIS IS WR ITTEN IN
LO/HI BYTE FORMAT - SO REVERSE THEM TO GET $100.


BIT MAPS
--- ----

  NOW COMES THE "BIT MAP" FIELD WHICH IS THE MOST IMPORTANT AREA OF THE VTOC.
STARTING WITH BYTE $38 AN D EXTENDING UP TO BYTE $C8 ARE THE BIT MAPS.	THESE
BIT M APS TELL DOS WHICH TRACKS AND SECTORS HAVE NOT BEEN WRITTE N ON AND WHICH
ARE AVAILABLE FOR FILE STORAGE.  SO DOS DOE SN'T CLOBBER THE PROGRAMS ON THE
DISK, IT WILL LOOK AT T HE BIT MAP FIELD EACH TIME YOU SAVE ANY NEW INFORMATION
ON TH E DISK.  IF YOU'RE LOOKING AT THE "FID"ED SYSTEM MASTER, Y OU WILL BE
SEEING MOSTLY ZEROS.  SINCE THIS IS A LITTLE D IFFICULT TO LEARN ON TRY THE
FOLLOWING:

  (1) BREAK OUT OF YOUR DISK EDIT PROGR AM

  (2) PLACE AN UNINITIALIZED DISK IN TH E DRIVE

  (3) TYPE "CALL -151" TO GO INTO THE M ONITOR

  (4) TYPE "BEFE:24"

  (5) NOW "INIT HELLO" ON THE UNINITIAL IZED DISK

  (6) REBOOT YOUR DISK EDIT PROGRAM AND READ IN TRACK $11, SECTOR $00 OF THE
      TEST DISK YOU J UST CREATED.



  YOU WILL NOW NOTICE SEVERAL DOZEN "FF"S ' THAT WEREN'T PRESENT ON THE SYSTEM
MASTER DISK.  NOW LET'S L OOK AT THE ROWS STARTING WITH BYTE $38 WHICH IS THE
FIRST BYTE O F THE BIT MAP.

  WHOEVER WROTE DOS, EMPLOYED A SIMPLE WA Y OF RECORDING THE STATUS (FULL OR
EMPTY) OF EVERY SINGLE SECTOR ON THE DISK AND SQUEEZING THIS INFO INTO AS LITTLE
SPAC E AS POSSIBLE.  IT'S DONE BY ASSIGNING A TWO BYTE "MAP" TO E ACH TRACK AND
THEN STRUCTURING DOS TO VARY THE VALUES OF T HE MAP WHICH INDICATES THE TRACKS
AVAILABLE SECTORS.

  THE ILLUSTRATION BELOW SHOWS HOW THE MA PS ARE LINKED TO THEIR RESPECTIVE
TRACKS:

BYTE# TRK $00	    TRK $01
 38:  !00 00! 00 00 !00 00! 00 00
      TRK $02	    TRK $03
 40:  !00 00! 00 00 !FF FF! 00 00
      TRK $04	    TRK $05
 48:  !FF FF! 00 00 !FF FF! 00 00
  :
  :
  :   TRK $1E	    TRK $1F
 B0:  !FF FF! 00 00 !00 00! 00 00

  THE FIRST "00 00" STARTING WITH BYTE $3 8 IS THE BIT MAP FOR TRACK $00, THE
NEXT "00 00" ARE SKIPPED AND THE THIRD BYTE PAIR ARE ASSIGNED TO $01, THIS
METHOD C ONTINUES ON THROUGH THE BIT MAP FIELD.

  THIS APPEARS AS SEEMINGLY MEANINGLESS D ATA ABOUT EACH SECTOR'S STATUS BUT
REMEMBER THAT ALL HEX BYTES ARE COMPOSED OF 8 INDIVIDUAL BITS.	IF YOU ARE
UNFAMILIAR WITH THIS, THEN I SUGGEST YOUR READ UP ON THE HEXADECIMAL SYSTEM.  I
WON'T GO INTO IT HERE BECAUSE THERE ARE NUMEROUS ARTICLES AND BOOKS, ETC., ON
THIS SUBJECT.  ANYWAY, IF WE A LLOT 2 BYTES FOR EACH TRACKS BIT MAP, WE THEN
HAVE 16 BITS TO PLAY WITH.

  ISN'T IT A COINCIDENCE THAT EACH TRACK ALSO CONTAINS 16 SEC- TORS.  AND WHAT'S
EVEN MORE CONVENIENT IS THAT EACH BIT CAN HAVE 1 OR 2 VALUES - A '0' OR A '1'.
I F A SINGLE BIT IS ASSIGNED TO EACH SECTOR IN A TRACK, WE CAN SHOW THAT A
SECTOR IS FREE BY SETTING ITS BIT TO A '1', WH EREAS A '0' WOULD TELL US AND DOS
THAT IT CONTAINS DATA.	LOOK AT THE EXAMPLE BELOW:

SECTOR #'S : FDECBA98   76543210
BIT VALUES : 00111111	11111111
BYTE VALUES:	3F	   FF

  THE '0'S' IN SECTORS $0F AND $0E TELLS US THAT THESE ARE USED; THE '1'S' IN
SECTORS $0D-$00 TELLS US T HAT THEY ARE FREE.  THE APPLE WILL AUTOMATICALLY
TRANSLATE THE BINARY NUMBER, '00111111' INTO THE HEX NUMBER '3F', AN D
'11111111' INTO 'FF', AND THE BIT MAP WOULD SHOW UP AS '3F FF '.  REFER TO THE
HEX, BINARY, DECIMAL TABLE IN THE FIRST TUTO RIAL.

  IF YOU'VE BEEN FOLLOWING ALONG IN THE E XAMPLE ON THE TEST DISK YOU SHOULD SEE
THESE 2 BYTES STARTING A T BYTE $80.  THIS TELLS US THAT THE '3F FF' REPRESENTS
THE STAT US OF THE SECTORS IN TRACK $12(18).  THIS IS WHERE THE HELLO PROGRAM
WAS LOCATED WHEN YOU INITIALIZED THIS TEST DISK.  S O IT OCCUPIES SECTORS $0E
AND $0F.  WHENEVER DOS WRITES DATA ON A TRACK, IT ALWAYS STARTS WITH THE HIGHEST
AVAILABLE SECTO R AND THEN WORKS DOWN.

  A GLANCE AT THE TABLE IN THE FIRST TUTO RIAL SHOWS US THAT IF YOU WANT TO SHOW
THAT ALL THE 16 SECTOR S ON A GIVEN TRACK ARE FREE, THEN ALL OF ITS 16 BITS ARE
SET T O '1', GIVING US AN 'FF FF' BYTE-PAIR.  IF YOU WANTED TO RE SERVE AN
ENTIRE TRACK FOR SOMETHING, THEN PLACE '00 00' INTO ITS BIT MAP.

  NOW THAT WE'RE BECOMING FAMILIAR WITH D OS AND ITS VTOC, NEXT TIME WE'LL START
PERFORMING A FEW TIPS & TRICKS.

