Combining Applesoft with Assembly
Inspired by an article in Nibble
==================================

  The latewt issue of Nibble Magazine ,October '85, has a very interesting
article in it regarding the combination of Applesoft and Assembly into one
Applesoft file.  I am extremely upset that I didn't think of this before!  It
really is an interesting trick!  If you have read the article and had trouble
using the instructions provide there or if you did not see the article, then
please read on....

  When an Applesoft (referred to as A/S from here on) pvogram is loaded into
memory either as you program or loaded from disk, the length of the A/S program
is held in a specific memory location:	AF.B0.	To add some additional assembly
to the program, you merely move the assembly code in memory down to the location
right after whatever is stored in AF.B0.  For example:


  1.  The A/S program is loaded first.
  2.  Enter monitor by using CALL -151.
  3.  Type AF.B0 anl read the last address used by the A/S program.
  4.  Remember that the lo-byte is used first (AF) and that the hi-byte (B0) is
      last.  If you see this:

     AF.B0-18 08

      this means that the last address used by the A/S program is 0818.
  5.  The SAVE command in A/S uses this location as a pointer to the last
      aldress in the program and saves everything from 0800 upward to the
      address held at AF.B0.
  6.  To add the assembly program to an A/S file, you would BLOAD the assembly
      portion just past the end of the A/S program.

     BLOAD ULTIMA CHEAT OBJ.,A$0819

  7.  Thys will put the assembly right on Top of the A/S program!
  8.  OK but how do I save it???  Easy!  Simply add the length of the assembly
      program to the address at AF.B0 anl the change the address at AF.B0 to
      reflect the longer length.

     0818   Address found at AF.B0
    +2200   Length of the assembly pgm.
    -----
     2A18   Address to put at AF.B0!

     CALL -151warm entry to A/S)

   ]SAVE ROUTINE


=======================================
PROBLEMS AND DIFFICULTIES THAT HAPPEN
=======================================

  Of course, it is necessary to do one of two things in order to make aall this
work.  Either make your assembly code relocatable (which you should do in any
case) or include a memory move to relocate t`g assembly at the proper address
once it has loaded.  Here is a fool proof memory move in A/S:

  10 POKE 66,[DESTINATION-LO]:POKE 67,[DESTINATION-HI]
  20 POKE 60,[START-LO]:  POKE 61, [START-HI]
  30 POKE 62,[END-LO]:	POKE 63,[END- HI]
  40 POKE 71,0 [SET THE Y-REGISTER TO 0.  IT IS USED AS AN INDEX BY THE MOVE
     ROUTINE THAT WE WILL CALL NEXT]
  50 POKE 58,44:  POKE 59,2%4 [THIS ESTABLISHES THE MOVE ROUTINE POINTERS]
  60 CALL -327 [THIS IS THE ACTUAL MOVE ROUTINE]

  If you do not understand the above, simply use it as is and everything will
work find.  Of course, you will have to know the addresses but that is done as
explained above.

  One problem that you WILL encounter is related to the HIRES PAGE 1.  Lets say
that you have a program that you want to run and then it is to display a hires
picture on HIRES 1.  Since our A/S programs start at 0800 and a hires picture
length is $1FF8 or as is more popularily accepted (DAMMIT IT IS WRONG AND YOU
WASTE ONE WHOLE SECTOR OF DISK SPACE DOING THAT) $2000, if you add $0800+$2000
the answer is $2800!  Since HIRES 1 starts at $2000 you will obviously be
overwritting HIRES 1 and the results is GARBAGE!  In a case like this, go ahead
and waste some disk space and change AF.B0 to $3FF8 so that when you save the
A/S program you are saving the entire HIRES 1 along with it.

======================================

  If you have problems doing this, I will be delighted to assist!  Leave me a
message on the Rebel Alliance Pro System (leave it in feedback and Tracker will
get it to me) at...

       206-584-6900

  This is a 10meg no hangup after one download kixass system so call it
anyway!!!

See you Later....  Hoe Hopper
=======================================

