
                             CONTENTS


 1.  INTRODUCTION

 2.  SOURCEROR

 3.  GETTING STARTED

 4.  COMMAND SUMMARY

 5.  OPEN APPLE COMMANDS (global)

 6.  EXPANDED EXPLANATION OF SOME COMMANDS
     6.1   CUT AND PASTE

 7.  FIND TEXT and GOTO LABEL (or line number)

 8.   GLOBAL EXCHANGE

 9.  REPLACE LINE and DELETE LINE

10.  OPEN APPLE UP AND DOWN

11.  STATUS

12.  CHARACTER INSERT MODE

13.  LOWER CASE TOGGLE

14.  LINE NUMBER and EOL MARKER

15.  GENERAL REMARKS

16.  MEMORY USAGE

17.  INSTALLING ED ON THE FLY

18.  THE KEYBOARD MACRO PROGRAMS (EDMAC)

19.  OOPS

20.  THE ED.16 VERSION

21.  LOADING OTHER UTILITIES

22.  TECHNICAL INFORMATION

23.  IMPORTANT NOTE

24.  BASIS 108 VERSION

25.  ADDENDUM

26.  NEW DISK COMMANDS (ProDOS Version)

27.  CATALOG COMMAND

28.  INTERPRETER

29.  NEW DISK COMMANDS [DOS 3.3 Version]

30.  [ProDOS  and DOS 3.3  versions]
     30.1  Merlin Pro and 'SPEED UP' CARDS

31.  LINKER

32.  LUP

33.  CLOCK

34.  CONV.LNK.REL [ProDOS only]

35.  CLR.HI.BIT [ProDOS only]

36.  65C02 SPECIAL NOTES

37.  MANUAL CORRECTIONS and ADDITIONAL INFORMATION
     37.1  (Page 109)
     37.2  (page 117)

1.  INTRODUCTION

The Merlin Pro ProDOS and DOS 3.3 versions load the standard editor
on boot.  The Merlin Pro manual refers to this editor and it
recommended that you become familiar with its operation.

At some point you may prefer to use the Full Screen Editor instead.
Please read the information in this page carefully.  It has been
provided to help avoid confusion.

The easiest way to identify which editor is in effect is to enter
the Editor and press  "A" to add a line.  If the line number
appears in the upper right hand corner of the screen, the Full
Screen Editor has been installed.

To have the ProDOS Full Screen Editor installed on boot, you should
first make a copy of the Merlin Pro, ProDOS version.  In the sub-
directory UTIL is a file called FS.ED.  RENAME this file to ED and
you're all done.  For easy reference, write "Full Screen Editor-
ProDOS" on the diskette label.

To have DOS 3.3 Full Screen Editor installed on boot, you should
first make a copy of the Merlin Pro, DOS 3.3 version.  LOAD the
HELLO program and add the following line:

80 PRINT CHR$(4)"BRUN ED"

and then SAVE HELLO.  For easy reference, write "Full Screen
Editor, DOS 3.3" on the diskette label.


2.  SOURCEROR

Most Merlin Pro utilities such as XREF and PRINTFILER can be in
memory at the same time as the Full Screen Editor version.
However, on the ProDOS version, the Full Screen Editor uses the
same memory area as SOURCEROR.  Therefore, you must boot the
Standard Editor version of Merlin Pro to use SOURCEROR.  This does
NOT apply to the DOS 3.3 version.

See the additional notes on using SOURCEROR and SOURCER.FP at the
rear of the Full Screen Editor manual.


3.  GETTING STARTED

Merlin Pro's Full Screen Editor is very compact and powerful.  It
is on both the DOS 3.3 version and the ProDOS version, where it is
in the UTIL directory.

It is compatible with the //c and //e 80 column cards as well as
the Videx Ultraterm and Checkmate Technology Multiview cards (all
modes).  Its command structure is modeled closely on the Merlin Pro
Standard Editor so that you don't have to learn another radically
different set of commands.

After it has been loaded, it is accessed from within the editor by
typing an "A" command.  If there is a source file in memory then
the "E" command also sends you to the Full Screen Editor

If you have one of the new 65802 16-bit microprocessors in your
Apple //e or //c then you can make use of the "ED.16" version of
the Full Screen Editor.  This is faster and has some added
capabilities such as the ability to move source files easily and
quickly between DOS 3.3 and ProDOS versions.

The 65802 can be plugged right into your Apple //e or //c,
replacing the existing 65C02 or 6502.  There are no known
incompatibilities with this chip, except for those that already
exist for the 65C02.  The entire 65C02 instruction set is
supported, with the exception of the so called Rockwell codes.
Those codes only exist on the Rockwel1 version of the 65C02 and do
not exist on the versions used by Apple Computer for the //c or the
//e enhancement.

It is strongly suggested that you install the Enhancement Kit in
your //e if you don't already have it.  This is not strictly
required, but the Mousetext Toolkit characters will produce a
substantial improvement of appearance.


4.  COMMAND SUMMARY

The command structure follows that of the Standard Editor as much
as possible.  Commands that are 'global' in nature use the same
control character as the but use the Open Apple (OA) key as a
prefix instead of the Control key.  If you are familiar with Merlin
Pro's Standard Editor, or the many editors with similar command
structure, these commands will seem very natural.

CONTROL COMMANDS (line oriented and cursor moves)

Control B .......... Cursor to beginning of the line
Control D .......... Delete character under the cursor
Control F .......... Find  character typed next (recursive)
Control I .......... Toggle character insert mode
Control L .......... Toggle lower case convert mode
Control N .......... Cursor to end of the line
Control Q .......... Delete all characters from cursor to end
Control R .......... Replace original line
Control S .......... Show memory status box
Control W .......... Find next word (alphanumeric)
Control X .......... Cancel global exchange in progress
Control Y .......... Remember current line for recall by OA Y
Cursor keys ........ Move cursor
DELETE ............. Delete character to the left of cursor
ESC ................ Move cursor to the start of next line
RETURN ............. Carriage return and insert new line
TAB ................ Toggle insert mode


5.  OPEN APPLE COMMANDS (global)

OA DELETE ....... Delete previous line (UNDO by OA TAB/OA R)
OA DOWN ARROW ... Cursor down 10 lines, screen centered
OA ESC .......... Return to the standard editor
OA TAB .......... Insert new line at cursor
OA UP ARROW ..... Cursor up 10 lines, screen centered
OA B ............ Go to the beginning of source, screen centered
OA C ............ Cut to the clipboard, start select if 1st time
OA D ............ Delete current line (UNDO by OA TAB/OA R)
OA F ............ Find text (recursive)
OA I ............ Insert new line at the editor
OA L ............ Go to label in label column or line number
OA N ............ Go to the end of source
OA P ............ Paste clipboard at line containing cursor
OA Q ............ Select all text from current line to end
OA R ............ Replace last line deleted with current line
OA W ............ Find word (recursive)
OA X ............ Global exchange (produces dialog box)
OA Y ............ Go to last control Y line, screen centered
OA Z ............ Reprint screen, screen centered
OA 8 ............ Produce a line of asterisks
OA 9 ............ Produce a line of boxes
OA - ............ Produce a line of dashes
OA = ............ Produce a line of equal signs


6.  EXPANDED EXPLANATION OF SOME COMMANDS

6.1  CUT AND PASTE

Open Apple C starts the select mode and selects the line the cursor
is on.  After this, you can select further lines with the down
arrow key.  The up arrow key does not cancel select mode, so you
can adjust the select range if you go to far.

However, the select mode will be canceled if you move the cursor
above the first selected line or past the top of the screen.  Any
other command will cancel the select mode.  Selected lines are
shown in inverse.  When you want to cut, type OA C again.  The
selected lines will disappear from the screen and are placed on the
clipboard.

Open Apple Q selects everything from the current line to the end of
the file for  cutting.  OA C will then cut it; anything else will
cancel the select mode.  This provides a simple means of moving the
entire file to the clipboard.

Open Apple P pastes the current contents of the clipboard on the
screen starting at the line containing the cursor.  Only full lines
are moved.  This does not change the contents of the clipboard, so
that this can be used to replicate a range of lines.


7.  FIND TEXT and GOTO LABEL (or line number)

The OA F command brings up a box which asks for the find text.  It
then finds the first occurrence of the text in the entire text
file.  The text can be anywhere on a line.  After the first find,
you can find the next occurrence by typing another OA F.  You can
edit the line and then type OA F to go to the next occurrence.

The OA B command and the Control-S status command both cancel the
find mode, as does failure to find the text below the current line.
This continued find mode is indicated by one or more '+' signs
preceding the line number at the top right corner of the screen.
The continued find starts from the row the current line, so it
locates only one occurrence per line.

The OA W command is identical to OA F except that it finds only
whole words bounded by non-alphanumeric characters.  If you type
either OA W or OA F to find the next occurrence, this mode will
change accordingly.

The OA L command asks for a label or any text to locate.  It finds
the first occurrence of that text in the file, but only in the
label column.  Only the characters typed are compared with the
labels, so in some cases you may wish to end your input with a
space.

The intended use of this command is to move rapidly to a particular
place in the source.  You can use 'markers' to enhance the
capability of this command.  Therefore, if a line starts '* 7', you
can specify '* 7' as the find text for this command and it will
work.

If you type a number for the label in an OA L command, you will be
sent to that line number.  This is convenient when editing a source
file using the printed listing.

In all cases the line containing the text is moved to the center of
the screen, unless it is within the first 10 lines of the start of
the source.


8.   GLOBAL EXCHANGE

The OA  X command produces a dialog box that asks for the text to
change, and the new text to replace it (if you just type RETURN for
either of these, the command is aborted).  Then the file is
searched for the change text.  Unlike the FIND command, it looks
only for full words.  That is, the text found must be bounded by
non-alphanumeric characters or it will be ignored.

If If text is found with this method, the screen is reprinted with
the replacement made and the cursor is placed on the first
character of the replacement.  Now you must hit a key to continue,
Pressing RETURN or any other control character will defeat the
change and the routine will look for the next occurrence of the
text to change.  Pressing the space bar or any other character will
accept the change and the routine will continue.

One exception to this is the Control-X key, which will abort the
process and return control to you.  Another exception is the 'A'
key which will cause all occurrences to be changed.  Caution: this
can be aborted only by RESET.

You can tell when the routine is finished by the fact that the line
number at the top right is missing during the exchange sequence and
will return when there are no more matches for the change text, or
until you press Control-X.


9.  REPLACE LINE and DELETE LINE

The OA D and OA-DEL commands delete a line from source and place it
in a special 'undo' buffer, which is independent of the clipboard.
The OA R command exchanges the current line with this undo buffer.
Thus two successive OA R commands cancel one another out.  OA R on
an empty line places the undo buffer at that line and clears the
undo buffer.

Note that these commands can be used to move a single line to
another location.  Just place the cursor on the line to be moved
and type OA D; then move the cursor to an empty line or anywhere
else, Now press either OA-TAB or RETURN to create an empty line,
and then type OA R.

OA R can be used by itself to easily interchange two lines.  Just
place the cursor on the first line, press OA R, move the cursor to
the second line, press OA R again, move the cursor back to where
the first line was and press OA R for the third and final time.


10.  OPEN APPLE UP AND DOWN

The OA DOWN ARROW command moves the cursor to the 10th line below
its present position and then reprints the screen so that the
cursor will be on the 11th line.  If this command is repeated it
has the effect of moving the current line to the top of the screen
and then moving the cursor to the 11th line on the screen.

Similarly repeating the OA  UP ARROW command moves the top line to
the 11th line on the screen and puts the cursor on that line.


11.  STATUS

The Control-S command displays a status box showing the number of
used and free bytes.


12.  CHARACTER INSERT MODE

The character insert mode defaults to ON upon entry.  When you
change it with the TAB or Control-I key, it remains that way until
changed again.  Thus, moving from one line to another has no effect
on this status.

The status is indicated by the type of cursor displayed.  It is an
inverse 'I' when insert mode is active, and an inverse space when
it is not active.  The cursor is an inverse 'F' when you are in
find mode.


13.  LOWER CASE TOGGLE

Ordinarily, unless the cursor is in a comment or an ASCII string,
lower case characters will be converted to upper case characters.
This is also defeated when the tabs are zeroed.  To override this
conversion, or to reinstate it, just use the Control-L command.
This conversion is also in effect when you use the OA F or OA  L
find commands.


14.  LINE NUMBER and EOL MARKER

At the upper right hand corner of the screen, the number of the
line containing the cursor is printed.  Somewhat to the left of
this you may see a vertical bar.  This bar indicates the position
at which an assembly listing will overflow the printer line.  You
can put characters beyond this mark, since it is for information
only.  The position of the mark is calculated using your line
length parameter in the PARMS file.  If this is very large, the
mark will not be shown.


15.  GENERAL REMARKS

When you move the cursor between lines its horizontal position will
jump around.  This is because it is based on the actual position in
the line and not on the screen position.  If the tabs are zeroed
you will not notice this, except for the fact that the cursor is
never beyond the last character in the line.

The editor works with any 80-column card and supports all modes of
the Ultraterm and Multiview cards.  Except for minor details, it
even works on the 40 column screen.  However, only that part of a
line that can fit on one screen line is displayed.

The maximum line length is 192 characters.  Lines longer than that
will be truncated IF they are edited.

The editor uses the mousetext characters in some places, but this
is just cosmetic.  In 40 column mode these will show up as strange
characters because Merlin Pro does not use the video firmware in
that mode.

You must return to the standard editor (OA  ESC) in order to use
the ASM command to assemble, or to Quit and access the EXEC mode,
the monitor, etc.

If the 'search character' parameter location is in negative ASCII,
then when you return to the standard editor, the 'A' and 'E'
commands no longer send you to the screen editor.  This way you
still have use of the standard editor if you desire.  The entry to
the screen editor is reestablished when you go to EXEC mode and
back, or when you assemble a file.

On the other hand, if you defeat the 'Update source (?)' question
by putting a zero in this parameter location, then the 'A' and 'E'
commands will always send you to the screen editor.  The standard
editor can be used only for immediate commands.  Using any positive
byte except zero for this parameter will defeat the 'Update source
(?)' question but still allow access to the standard editor.

The editor conflicts with some other utilities in its use of memory
such as SOURCEROR.  To use these utilities you should remove the
editor by running the REMOVE.ED program.  This pertains only to the
ProDOS version.

Users of the Ultraterm or Multiview cards can set up any mode of
the card by typing the appropriate ESCAPE sequence when in the
standard editor.  That mode will then be automatically supported
when you go to the screen editor.

Unlike the standard editor, the Control-Q key does not move to the
next line after deletion of characters from the cursor on.  This
makes it possible to use the Control-R key to undo this command.

An assembly will delete the current clipboard file.  RESET will
return to the EXEC mode with everything intact.

The editor has keyboard buffering so that keys will still be read
during time consuming operations such as reprinting the screen or
moving data to and from the clipboard.


16.  MEMORY USAGE

The ProDOS version uses 12 pages (3K) from the top of source file
memory.  If you use the keyboard macro file EDMAC it uses and
additional 2 pages.  It is protected from overwrite.  The DOS 3.3
version uses the other language card  and thus does not use any
memory ordinarily used by Merlin Pro.


17.  INSTALLING ED ON THE FLY

If you have deleted line 80 from the DOS 3.3 HELLO program, and you
want to install the Full Screen Editor from within Merlin Pro,
press C to Catalog from the EXEC mode, and at the BASIC prompt type
BRUN ED.  You can also BRUN ED from BASIC after Merlin Pro is in
memory.

With the ProDOS Standard Editor version, press D for Disk command
from the EXEC mode, and type BRUN/MERLIN/UTIL/FS.ED at the command
prompt.


18.  THE KEYBOARD MACRO PROGRAMS (EDMAC)

These are versions of the keyboard macro parts of KEYMAC that will
support the screen editor.  The macros are invoked by pressing the
Close Apple key along with other keys.  The source files are
provided so that you can change the macro definitions if you so
desire.  To set up the keyboard macros, press C to catalog from the
EXEC mode (assuming ED has been loaded), and at the command prompt,
type BRUN EDMAC.


19.  OOPS

Virtually any command can be undone.  The proper undo command is of
the same 'type' as the command you want to undo.  Line editing
commands are undone by Control-R.  This includes the OA 8, OA 9, OA
-, and OA = commands which are regarded as line editing commands
for this purpose.

Line deletion commands OA D and OA  DEL are undone by creating an
empty line with OA TAB and then OA R.  If you forget to create the
empty line, type another OA R and then do this.

The OA  R command undoes itself.  A CUT is undone by a PASTE
without moving the cursor off its line.


20.  THE ED.16 VERSION

ED.16 is for use with the 65802 or 65826 chip.  The speed sensitive
parts of the editor make use of the enhanced abilities of these
chips.  For very large files the difference is substantial.  Do not
run ED.16 with a 6502 or 65C02.  It should have no effect, but this
has not been tested.

If you have a 65802 in your Apple, you can use ED.16.  Just rename
ED.16 so that it becomes 'ED'.  If you have a program selector,
tell the selector to use 'ED.26' as a 'startup'.

There are extra features in ED.16.  The 'A' entry goes to end of
source and the 'E' entry with line number goes to that line, unless
the line is less than 11.  The Control-S status request also shows
the length of the clipboard, if any.

There are two more OA  commands, OA LEFT ARROW and OA RIGHT ARROW.
These move through the text a page at a time.  This is roughly
equivalent to two successive OA  UP or DOWN Arrows.

The Control-O override command enables insertion of control
characters in the text file.

The clipboard is this version only can be used to transfer files
between ProDOS  and DOS 3.3.  To do this, place the cursor on the
first line and type OA Q then OA C which will place the entire file
in the clipboard.  Then boot up the other version of Merlin Pro and
ED.16 and type OA P.


If you use OA F, OA W, or OA X while a range is selected by OA C
and Down Arrows, only that range will be searched.  Otherwise, the
entire file is searched.  These commands cancel the select mode.
If the OA P paste command is used when a range is selected, the
clipboard replaces the text in that range.  Note: text deleted in
this manner is not recoverable.

Things that will destroy the clipboard:

1. Turning off the computer
2. Writing to /RAM
3. Using any program that writes to auxiliary memory.
4. Using the SWAP command in the standard editor.
5. Assembling a file.

Things the clipboard will survive (ED.16 only)

1. A cold boot (Control OA  RESET).
2. Running a program that does not use auxiliary memory.
3. RAM format request (but no writing of files).
4. Loading and saving files (all ED versions).


21.  LOADING OTHER UTILITIES

You can have another utility such as XREF or SOURCEROR, loaded on
boot instead of ED.  To do this, change the name 'UTIL/ED' located
at $2006 with a leading length byte, in MERLIN.SYSTEM, to the path
name of the utility you want executed upon boot.  This is for the
ProDOS version only.


22.  TECHNICAL INFORMATION

The editor has been arranged so that certain parameters can be
altered with little effort.  At relative byte 3 in the file there
is an address which points to the main part of the program, past a
relocating header.

This address is referred to as START and is the address in the file
when loaded and not necessarily when it is running.  At Start there
is a JMP.  After the jump there is an address for use in linking
macro programs (see EDMAC source).

At START + 5, there are characters used for the four cursors
(Inverse I, F, space, and F; the two F's depend on the state of the
insert mode).  You can substitute any characters you want here
except that you should not use the range $40-$7F.

At START + 9 is the byte $A0 which controls the blink rate.
Raising this makes the blinking slower.  This is desirable with
speedup cards.  A value of 0 gives the slowest rate.

At START + 10 a  table of command characters used without the OA
key.  Some commands such as up and down arrow keys are handled
separately and are not in these tables.  This table ends with a
zero.  Following this is the table of the key commands used with
OA, again ending with zero.


23.  IMPORTANT NOTE

Do not use KEYMAC (instead of EDMAC) when ED is in memory!


24.  BASIS 108 VERSION

On the BASIS 108 only the ED.16 version has been implemented.  The
Full Screen Editor can be used only if you  have a 65802 chip.

The 'Open Apple' commands are implemented by 'shift-control'.  Thus
shift-control C is the Cut command, etc.  On the BASIS there is a
limited amount of memory for the clipboard: 16K.  If you try to cut
more than this you get an "Out of Memory" message.  Also, you
cannot Cut out of or paste into memory above $8000.  Thus some cuts
will be disallowed on very large sources.  This will also yield the
Out of Memory message.  Because of this limitation, it is a good
idea to avoid such extremely large source files.

There is no version of EDMAC for the BASIS 108.

Following the two key tables is the routine that tests for the
control-shift combination.  This is followed by 16 zero bytes to
accommodate patching, should the user want to change this routine.

The routine should return with the Z-flag set (EQ true) if the
shift-control (or its replacement) is pressed.  The command key
itself is read elsewhere.  The X and Y registers must be preserved
but the A register does not matter.  If this routine is changed the
the 'OA" command table may also have to be changed.  The routine is
located at START + $33 (see technical information) but changes to
the editor may shift it slightly.

To have the Standard Editor installed on boot, delete line 61 from
the HELLO program (e.g.  BRUN ED.16B).


25.  ADDENDUM

The following addendum is provided for Merlin Pro users that had a
version prior to 2.34


26.  NEW DISK COMMANDS (ProDOS Version)

There is an alternate way to set the disk prefix.  Press D for disk
command, then enter PFX= or PFX=1 to specify slot 6, Drive 1, or
PFX=2 for Slot 6, Drive 2.  You can use the new SLOT command to
specify slots other than 6.  SLOT is to be used with the PFX= and
CATALOG command as described below.


27.  CATALOG COMMAND

After using the CATALOG command, if you press =, =1, or =2, Merlin
Pro will set the prefix to the volume found in the specified drive
and then catalog that volume.  If you press OPEN APPLE during a
catalog, Merlin Pro lists only the TEXT files present in the
specified directory.

If you press OPEN APPLE and CLOSED APPLE at the same time during a
catalog, Merlin Pro lists only the BIN files present in the
specified directory.  These keys must be pressed and held during
the entire catalog process.


28.  INTERPRETER

If the Merlin Pro ProDOS interpreter cannot find a disk volume
required for linking or assembly, it will ask for the correct
volume to be inserted.  This request can be aborted by pressing
Control-C or RESET.  This only applies to volumes, not files.  If
you want a PUT opcode to prompt you to switch disks, you must use
the full path name with the PUT opcode.

This feature will not work with the Linker when using one disk
drive.  If the present prefix does not correspond to any volume
online, Merlin Pro will give a VOLUME NOT FOUND error.

The PROGRAM TOO LARGE error message has been changed to MEMORY IN
USE.  See page 104 in the main Merlin Pro manual.


29.  NEW DISK COMMANDS [DOS 3.3 Version]

The DOS 3.3 version does not perform the same volume checking as
the ProDOS version.  However, it is possible to simulate this with
the following code:

LST XXX  KBD "INSERT MYFILE DISK AND TYPE 0 <RETURN>"
PAUSE

The assembler will stop at KBD on the first pass and assign a 0
value to XXX (any dummy label you desire).  Pause forces a pause on
the second pass and LST makes sure you see the KBD line.  On the
second pass, assembly resumes when you press any key (it is not
necessary to type 0 and press RETURN.)


30.  [ProDOS  and DOS 3.3  versions]

30.1  Merlin Pro and 'SPEED UP' CARDS

Merlin Pro will work either in main or auxiliary memory (aux is the
default).  If you are using the main memory version, you will get
about a 1.6 speed improvement with the SpeeDemon card, and about a
2x increase with the Accelerator.  This is due to the heavy use of
auxiliary memory during assembly.  To select the main memory
version with DOS 3.3, change the HELLO program to BLOAD MERLIN.X
instead of MERLIN.

To select the main memory version with ProDOS, use a $C3 as the
fifth byte in the PARMS file.  The V-bit of that location is used
as a flag to instruct the interpreter to make the main memory
modifications.  A + sign after the MERLIN PRO VERSION 2.xx on the
EXEC mode screen indicates the main memory version is active.

Some utilities do not work with the ProDOS main memory version
because ProDOS is moved to aux memory.  Programs that do not switch
zero pages will work fine.  Programs designs to be run in 64K will
most likely run properly.  The Filer and Convert programs run as
long as the - command is used to run them, and all Merlin Pro
utilities will work.  The QUIT command moves ProDOS back to main
memory.

MACROS

Errors in macros no longer abort assembly.


31.  LINKER

The addresses of all external references are printed whether or not
they are resolved.  If you use the TRON command prior to the LINK
command, only the errors will be printed in the external list (NOT
RESOLVED and DUPLICATE errors).


32.  LUP

In a LUP, if the @ character appears in the label column, it will
be increased by the loop count (thus A, B, C...).  Since it is a
countdown, these labels go backwards (the last label has the A).
Thus it is possible to label items inside a LUP.  This works with a
maximum LUP length of 26, or you will get a BAD LABEL error and
possibly some DUPLICATE LABEL errors.


33.  CLOCK

This utility is an interrupt driven software clock for the //c
which lacks a clock to do ProDOS time stamping.  It uses the VBLINT
interrupt provision of the //c.  This should be used with caution!
If overwritten, anything might happen.  Press RESET to turn off
interrupts.  The source files are provided in the SOURCE directory
on the ProDOS version.


34.  CONV.LNK.REL [ProDOS only]

This makes Merlin Pro's REL files compatible with Apple's RLOAD and
RBOOT programs.  It will convert a Merlin Pro LNK file to Apple's
REL format (only if there are no externals).  You can BRUN it from
EXEC mode.  If there is a source file in memory, it will just
return, so enter NEW first in the editor.

You will be prompted for the path name of the file.  The program
will do the conversion and set up the converted file for Merlin
Pro's object save command.  The CONV.LNK.REL utility does not write
anything to disk and does not delete or otherwise damage the
original file.


35.  CLR.HI.BIT [ProDOS only]

This converts a source file in memory to positive Ascii so the file
can be sent to other programs that expect data in this form, such
as Apple's ProDOS ED/ASM.  To use it, just BRUN UTIL/CLR.HI.BIT and
the save the source.  CAUTION: If you re-enter the Editor, the
source will be deleted from memory, since the Editor does not like
this format.


36.  65C02 SPECIAL NOTES

To assemble or disassemble 65C02 code with the older //e ROMs, you
must first BRUN MON.65C92.  This must be done from BASIC if you are
using the DOS 3.3 version.  This utility is not needed with the
newer //e of //c ROMs.

With both versions, you MUST use the XC opcode (see page 75 for
details) as the very first line in your code.  This flag tells
Merlin Pro you are using 65C02 or 65802 opcodes.

You will have problems if you do not use the standard 65C02 opcodes
as specified by GTE, NCR, and Rockwell.  In creating the //c
Reference manual, Apple apparently did not check with the
manufactures regarding the final set of opcodes.  Thus, Apple
refers to three non-standard opcodes.


For example, to increment the Accumulator, you must use INC with no
address argument, not in a.  Branch on Bit Set (BBS) and Branch on
Bit Reset (BBR) are also non-standard opcodes and are not supported
by the NCR and GTE chips.


37.  MANUAL CORRECTIONS and ADDITIONAL INFORMATION

37.1  (Page 109)

37.1.1  Configuration (ProDOS version)

Configuration data is kept in a file called PARMS which is loaded
when the assembler is run.  To change the data in the source file
called PARMS.S, with the prefix set to /MERLIN/, type L to load
source.  Then type SOURCE/PARMS at the prompt.  When you are done
making changes, reassemble the file.  Use S to SAVE the source code
as /MERLIN/SOURCE/PARMS (Merlin Pro adds the .S automatically).
Then save the object code as /MERLIN/PARMS by using the O command.

37.2  (page 117)

37.2.1  SOURCEOR

37.2.1.1  Introduction

SOURCEROR is a sophisticated and easy to use co-resident
disassembler designed to create MERLIN source files out of binary
programs, usually in a matter of minutes.  SOURCEROR disassembles
6502, 64C02, 65802, and Sweet 16 code.

37.2.1.2  Using SOURCEROR

  1.  [DOS 3.3 ] From the EXEC mode, type C to Catalog Merlin Pro.
      At the command prompt, type BRUN SOURCEROR.  [ProDOS - see
      note on page 1 of this manual] From the EXEC mode, type D for
      DISK COMMAND.  At the prompt, type BRUN/MERLIN/SOURCEROR/OBJ.

  2.  From the EDIT mode, use ESC CTRL-Q (not Escape-4) to set the
      screen to 40 columns, then type USER.  If the screen is in 80
      columns, the USER command will be ignored.

  3.  You will be asked if you want to load an object file to be
      disassembled.  If you have loaded the object file prior to
      using SOURCEROR, type N.

      If yes, type Y and enter the filename.  It will load and show
      the load address and end of program address.  Note: If you
      type CTRL-S after the filename, files using a RAM version of
      Sweet 16 can be disassembled.

  4.  Next, you are asked to press RETURN if the program to be
      disassembled is at its original (running) location, or you
      must specify, in hex, the present location of the file to be
      disassembled.  You will then be asked to give the ORIGINAL
      location of the program.

  5.  Finally, the screen displays the disassembly commands.  You
      may begin disassembling now, or use any of the other commands
      shown.  Your first command MUST include a hex address.
      Thereafter, this is optional.

37.2.1.3  Bird Tracks

Take the situation where you have stored a file that runs at
address "X" and because it interferes with Merlin memory usage or
whatever, you have stored it with a different loading address "Y."
If you then answer yes to the above the program will be loaded at
"Y." This will cause the disassembly to be messed up.  The way
around all this is to either load the file from the command mode or
allow Merlin to load the file and accept Merlin's decisions.  You
then disassemble no more than one "L" of program.  Q)uit and be
returned to the editor where you once more enter Sourceror where
you state that the program is already in memory at address "Y"
*BUT* it normally resides at address "X."

37.2.2  (Page 125)

4. Type the following to print the listing to your printer:

PRTR 1 "I80N" APPLESOFT LISTING

ASM

37.2.3  (page 126)


5. Issue the PRTR command: PRTR 1 "I80N" APPLESOFT XREF

6. Issue the following command: USER 3

37.2.4  (Page 135)

3. Enter the Editor and type in the appropriate USER command:

37.2.5  (Page 137: Last sentence in step 3)

In this case enter the following instead if the USER command: PRTR
8 "path name" page header (quotes only for path name).

37.2.6  MERLIN PRO & SOURCEROR FP

1) Make a copy of the Sourceror.FP diskette as per the warning on
page 124 in the Merlin Pro manual.

2) Boot the Merlin Pro ProDOS diskette.

3) Insert the Sourceror.FP diskette.

4) Press D for Disk command. At the prompt type:

 BRUN/APPLESOFT/SOURCEROR.FP

5) From the main menu, type L to LOAD, then:

 /APPLESOFT/APPLESOFT

6) Enter the Editor, and type:
 PRTR1""APPLESOFT LISTING

7) Then type:

 ASM

 N  (This is not needed if you have defeated the
     stupid "Update" prompt.)

8) You'll be prompted as follows:

Print DO OFF areas ? (Y/N)  (You may answer Y or N)

Assemble new ROM version ? (Y/N)  If you answer N, you'll get the
][+ version.)
 (If you answer Y, You'll be prompted with:)

Assemble //c version ? (Y/N)
 (answer Y for the //c & enhanced //e version.)
 (Answer N for the original //e version.)


37.2.7  SOURCER.FP & XREF LISTING


1) Boot the Merlin Pro ProDOS diskette.

2) Insert the Sourceror.FP diskette

3) Type L to LOAD, then: /APPLESOFT/APPLESOFT

4) Type Q to quit the Editor, & return to the EXEC mode.

5) Insert the Merlin Pro ProDOS diskette.

6) Press D for Disk command, then type: BRUN/MERLIN/UTIL/XREFA

7) Enter the editor then type: PRTR1""APPLESOFT XREF

8) Then type: USER 3

9) Then type: ASM

N (Not needed if update prompt is defeated)

10) You'll be prompted as follows: Print DO OFF areas ? (Y/N)
 (You may answer Y or N  Be smart, answer Y)

Assemble new ROM version ? (Y/N)  (If you answer N, you'll get the
][+ version) (If you answer Y, you'll be prompted with:)

Assemble /c version ? (Y/N)
 (Answer Y for the //c and Enhanced //e version.)
 (Answer N for the original //e version)

11) Insert the Sourceror.FP diskette at the prompt:

 Insert /APPLESOFT/APPLESOFT.A.S

12) Press RETURN and you're done.
