
DDD Pro

Version 1.0

Written by:  Dr. DX

Prelude:
-------

Dalton's Disk Disintegrator (DDD) has remained the standard packer for Apple II
disks for a number of years.  It has suffered recently because of poor attempts
to create a ProDOS version of the packing program.  Thus, the rationale for DDD
Pro, the ProDOS version of DDD. (No, the "Pro" does NOT stand for
"Professional," it stands for "ProDOS")

The History of Packing:
----------------------

"In the beginning, most Apple programs were single files.  In those days, all
pirates had to do to upload and download programs was to call up an AE line and
send the program across.  But as software became more sophisticated, programs
began to require full disks.  To send an entire disk just could not be done with
AE!  So pirating software had to get more sophisticated to keep up with the new
programs.  At that point, the Stack (of Corrupt Computing) wrote his first Disk
Splitter, which was a program that split a full disk into a sector map and 1-6
binary files.  This made it possible to upload a full disk with AE by first
splitting it, then unsplitting it back to its original state after down loading.
Although this program ignored unused sectors, it did no data compression.  Thus
began the succession of programs that ultimately led to Daltons Disk
Disintegrator ][.1 Enhanced.

Disk Splitter worked, but it was unfriendly and the files it created took up a
lot of disk space.  It was followed by a number of similar programs which began
to use various data compression methods.  First there was Disk Rigger 1.0 and
the its modifications (none of which were successful).  Although it did
compression and some fancy tricks, it simply did not work.  Other programs were
Disk Slicer by the Rocker and Disk Divider by M. Hata.  Disk Rigger 2.0 was the
next widely accepted program after Disk Splitter, but it had been the standard
for only a short period when Dalton came out with his revolutionary Dalton's
Disk Disintegrator 1.0.  This program had a bug when working with ][e's with one
drive, so DDD 1.1 was released.  Because its data compression techniques created
files which were smaller than those of any other splitting/packing program,
Dalton's set a new standard which lasted for quite some time.  The better the
compression, the less space was required to store the split files and the faster
they could be transferred.  Then a challenger invented a new technique: instead
of splitting a full disk into several binary files, it combined these files into
one long file.  Dalton incorporated this idea into his next major revision: DDD
2.0.  DDD 2.0 had another big bug.  It would not compress a disk if the end of
track $22 was blank (the most common reason being a TSL on that track).  The bug
was fixed in DDD 2.1, which is the current standard.  Everyone is happy with
this version--unless you own a hard drive, and can not use your volumes
conveniently.  To correct this problem, the Shadow wrote a program called Disk
Cruncher (current version 1.1) which is a nice program (much like Dalton's in
many respects), that has light-bar file selection and volume support, but a less
efficient packing routine. The next entry into the field was Krackerjack's
Fireworx.  Krackerjack has shown his programming expertise through Krackerjack's
Autograph, but his packer simply doesn't stack up against Dalton's in speed,
data compression, and reliability. It took about six and a half minutes to
unpack a fairly full disk, and the disk in question did not work after
unpacking!"

--The Watcher of The Assembly Line

And, then, after the "Enhanced" version of DDD 2.1 came out, it was successfully
followed by version 2.5, which was written by Tom E. Hawk. Tom E. Hawk added
some new features to DDD, most notable of which was the "#XXXX" we all saw
mysteriously appended onto DOS 3.3 filenames.  The mysterious lettering, was, of
course, a checksum that had been calculated on the disk as it was being packed.
This helped with transfers with AE, because AE Pro uses a checksum variety of
xmodem to transfer files.  Checksum xmodem is inherently unreliable because it
does not check the ORDER of the bytes in a file, it just checks the values.  So,
DDD 2.5 filled a very necessary gap.

Even though ProDOS had been around since 1984, no one hardy ever used the OS for
bulletin boards and file transfers because there was not a decent packing
program for packing disks or files.  Then came Propacker. ProPacker ended with
version 5.3c written by Randall Banning, who now makes his residence in Canada.
(as does Dalton).  ProPacker ushered in the era of ProDOS boards, because now
files could be packed into an efficient format for use in transferring.

However, the number of pirate boards that used ProPacker could be counted on the
fingers of one hand.  The reason: DDD was king, and so was DOS 3.3. Everyone was
happy until Apple Computer, Inc. unveiled a little monster called "The Apple
IIgs."  You see, the IIgs could use these 3.5 inch drives that held 800k of
data.  Could DDD handle a 3.5" drive?  No.  The reason: DOS 3.3 could only
handle up to 400k volumes, and even then, it had to be "forced."  ProDOS was the
answer.  Apple's ProDOS operating system for our II's meant that we had a fast
OS, and a lot more power because now we could use devices that could hold as
much as 32 megabytes.  So, ProDOS was the answer.  But, the problem had not yet
arrived... when the IIgs came out, we had a problem, and a BIG one.

The initial question that everyone asked was "what types of disks will we be
transferring if we own IIgs's?"  Apple made that abundantly clear when we were
told that the new operating system, the native mode version of ProDOS,
ProDOS/16, would only FIT on a 3.5" disk.  And, when the first IIgs ware came
out, the size of the executable file itself almost exceeded the capacity of a
5.25" disk.  So, we had our problem, and we had the solution at hand: ProPacker.

ProPacker was (and still is) a nice nifty little program written to pack BOTH
3.5" and 5.25" disks.  As a bonus, it could tell if you had packed a 3.5" disk,
and would tell you if what you were unpacking was a 3.5" disk. ProPacker was
NICE.  ProPacker was reasonably fast, and it worked well as long as you hadn't
gotten a bad transfer, in which case, it would crash while unpacking.  But, on
the whole, a decent packing program.

Then, after a bunch of DOS 3.3 based pirate boards decided that they would
convert to the ProDOS format because of the increased demands for space, there
quietly came a ProDOS compatible type of DDD.  It was called PBH Pack. (PBH for
"Pretty Boy Hackers")  Essentially, if you made a DOS 3.3 DDD file an "R" file.
(a RELative file), and then converted it to ProDOS, his packer could then unpack
the disk.  This made the conversion to ProDOS a little easier; however,
ProPacker 5.3c was still king in ProDOs land. It stayed that way for good
reason: the earlier versions of PBH Pack were awful.  They were bug-ridden, and
for the most part, just DID NOT WORK. We were finally given a decent version of
PBH in PBH version 2.0e, which was written by Major Disaster.  PBH 2.0e made
life a little easier because of one other MAJOR innovation on the terminal
program front.

ProTerm 1.2 became THE standard for Apple II telecommunications among pirates
during the summer of 1987.  ProTerm 1.2 had the capability to send files using
many different protocols, among which was a "different" style protocol whereby
it would pack a whole disk "on-the-fly" and send it... the packing algorithm
that Greg Scheafer uses in Proterm is compatible with DDD and PBH pack.  Great,
we finally have some sort of standard emerging.

Now comes the advent of DDD Pro.  For the first time, someone has taken a great
deal of time to re-write DDD for ProDOS the way it SHOULD have been done in the
first place.  DDD Pro features high-lighter bar option selection, optional CRC
generation on disks or files, an "Optimization" utility for ProDOS disks, Disk
AND FILE packing built-in, and many other "nice" features that make this packer
stand out as an exceptional program.  Read on...

Commands:
--------

Upon entering DDD Pro from your file-selection utility (such as ECP8,
ECP16,ProSel, or any number of other ProDOS file selection utilities), you will
see a menu of options containing the following commands:


Set Prefix
Set Device
Format a Disk
Pack Disk/File
Unpack Disk/File
Catalog
Optimize a Disk
Generate a CRC
Delete a File
About DDD Pro
Quit

SET PREFIX: This selection will allow you to set the current ProDOS prefix to a
certain volume or subdirectory.  Once prompted for the prefix, you can either
enter the entire path for the prefix, or a partial pathname.  If you use a
partial pathname, the additional path data will be appended to the original path
to produce a full pathname.

Pressing  ?  at the prompt will show a list of on line volumes. Pressing  ! at
the prompt will show you a catalog of the current prefix.

SET DEVICE: This selection allows you to select the drive and slot of the ProDOS
device that you want packed.  DDD Pro currently only supports 5.25" drives, and
3.5" drives. DDD Pro will "assume" that if the device does not have the
signature bytes for a 5.25" drive, you are using a 3.5" drive.  This may change
in the future as different devices are supported, and different search
mechanisms are implemented.

By using the left and right (or up and down) arrow keys, you can select the
proper slot and drive combination for use as the source device to pack. After
you hit return to actually select the slot and drive, DDD Pro will check to make
sure there is actually a ProDOS disk device at that slot and drive.  If there
isn't, you will be alerted, and the previous slot and drive will be retained.

FORMAT A DISK: This selection will first prompt you for the device that you want
formatted by a ProTERM style selection box.  If the media in the device has been
formatted before by a ProDOS formatter, you will be prompted as to whether or
not you actually want to format the media.  This was added as a safeguard so
that people do not go accidently formatting their hard drives by mistake because
they chose the wrong slot and drive.

If you answer affirmatively, the program will format the media in the device in
ProDOS format, and write an empty directory onto the volume.  The name of this
volume will always be /BLANK.  Jerry Hewett's Hyper-Format routines were used to
add speed to the formatting of 5.25" disks.

PACK DISK/FILE: This selection will allow you to pack the media in a device into
a DDD file, or the contents of a file into a DDD REL file.

You will first be prompted for the type of pack procedure to make.  Moving the
left-right arrow keys will allow you to select the type of pack you wish to make
ala ProTERM.

If you selected "DISK" in the pack-type selection, you will be prompted for the
name of the output file.  This is the DDD file that will be created by packing
the disk. The output file will be placed under the filename you choose. DDD Pro
will then pack the disk in the current device that was selected from the main
menu.  You may hit ESCape while packing if you wish to abort, in which case the
destination file will be deleted.

If you selected "FILE" in the pack-type selection, you will first be prompted
for the file that you want to pack.  You will then be prompted for the pathname
of the file that you wish to pack TO.  Once provided, the program will pack the
file, attaching a 100 byte header onto the front of the packed file which
includes some vital information.  The format of the info in the header packet is
as follows:

Offset   Length    Data Byte(s)
------   ------    -----------------------------------------
+0         1       $0A  / ID byte #1
+1         1       $44  / ID byte #2
+2         1       $42  / ID byte #3
+3         1       Access code
+4         1       File type code
+5         2       Auxilary type code
+7         1       Storage type code
+8         2       Number of 512 byte blocks used by the file
+10        2       Date of modification
+12        2       Time of modification
+14        2       Date of creation
+16        2       Time of creation
+18        3       EOF position
+21        2       CRC-16 of file
+23        2       Read count  (# of 16 page reads to make)
+25        1       Length of filename
+26        64      filename, or pathname of file, possibly including up to 64
characters.
+91        9       Reserved for future expansion (Should be 0)
+100               Packed data

As noted in the header info, DDD Pro runs a CRC-16 (not CRC- CCITT, for those
interested) on the source file while it is compacting its data.  The CRC checks
the ORDER AND CONTENT of the data to make sure that the file's integrity is not
damaged during a transfer.

UNPACK DISK/FILE: The selection does the exact opposite of pack a disk/file. It
will prompt you as to whether you want to unpack a disk or a file.  Once
answered, DDD Pro will prompt you for the name of the disk or file to unpack. If
you select disk, DDD Pro will check to see if the target disk has already been
formatted.  If not, DDD Pro will format the disk and start unpacking. If the
disk has already been formatted, you will be asked if you want to overwrite it.
If you answer yes, DDD Pro will start unpacking immediately instead of
unnecessarily reformatting the disk.

Since the filename is already stored in the header of a DDD packed file, there
is no need to provide an output filename for a packed file.

If you have a DDD packed file, and try to unpack it to a disk, you will be told
that it is "Not a DDD format file." Simply choose the "File" option in the
select box, and the file will unpack correctly.

CATALOG: This selection acts as advertised in that it allows you to get a
catalog of the currently prefixed volume, or subdirectory.

OPTIMIZE A DISK: This selection will allow you to "zero-out" the contents of the
unused blocks on a ProDOS disk.  You will be prompted for the device whose
unused blocks you wish to clear.

You will want to "zero-out" the blocks on a disk that you are about to pack if
and ONLY IF it is a ProDOS disk. This option can save a LOT of space in packing
because when ProDOS deletes a file, it does NOT place all zeros (0's) in the
blocks that the file was using.  Whenever a file wants some more space on the
disk, it will simply place itself over top of the old data. (after all, why
spend more zeroing out something if more data is going to be placed there
anyway?)  But, since the DDD packing algorithm works on the principle of
repeated bytes packing more efficiently, you will want to remove all the data
from these blocks. So, that's why you would want to "optimize" them. The
procedure just makes a disk have less data to pack because you removed the
unused data.

GENERATE A CRC: This selection will allow you to generate a CRC-16 on a whole
disk, or on a file.  Why would you want to do this?  If you need a quick way to
tell if 2 files are different, then the CRC's of the files will be different.
If two disks are different, even by so much as 1 bit, the CRC's will be
different.  So, you could have a friend run a CRC on a disk before he sends it
to you, and after it is unpacked, you could run a CRC on the disk to find out if
the transfer was successful without line noise.

Note, however, that a CRC-16 for files is built-in to the DDD packed file
format.  If the file somehow got scrambled, DDD Pro will tell you so by a subtle
warning message.

DELETE A FILE: The selection will allow you to delete a file from the currently
prefixed volume/path.

ABOUT DDD PRO: This will show you current information about the version of DDD
Pro you are using.  It will also give credit where credit is due.

MISC:
----

Before formatting any device, if the disk in that device has been formatted
before, you will be prompted as to whether or not you actually want that disk
formatted.  This is provided for your protection if you have any valuable disk
you don't want accidently formatted.


If you press ? at any filename prompt, you will be given a list of the currently
on line volumes, and if you press ! you will be given a catalog of the current
prefix.

CREDITS:
-------

Dalton, without whose packing algorithm, apple pirating would be going nowhere.
Ziopoth, for writing the first "enhanced" version of DDD. Tom E Hawk, for
writing the second "enhanced" version of DDD, DDD 2.5. The Nybbler, for writing
that wonderful/awful DDD compacter, PBH Pack 1.0-2.1 Major Disaster, for writing
PBH Pack 2.0e, and providing the source to PBH. Mountain Man, for his INCREDIBLE
disassembly and translation of the DDD packing algorithm.

Dr. DX, for writing the first credible translation of DDD for ProDOS.

Me, for writing the docs for this thing.

All the sysops who run a ProDOS board, without whose pushing, this program would
not exist.

And everyone else who has had anything to do with making any of the many
versions of DDD and PBH Pack.

POSTLUDE:
--------

Because he has a penchant for this type of thing, Dr. DX will be making better
and improved version of DDD Pro.  The next MAJOR revision should support the
65C02 and have 80-columns, mousetext, and ProTERM-style file selection.  The
packing algorithm will be enhanced ever so slightly by the additional support of
the 65C02's extra opcodes.

If I ever get time, I will be writing a ProDOS/16 version of DDD Pro... It will
use pull-downs and SuperHires for file selection, etc.  The algorithm will be
tweaked some more by the use of the 65816's 16-bit opcodes.

And, while on the subject of algorithms, we will probably be "enhancing" the DDD
algorithm in the not-so-near future to include additional packing algorithms.
We will try to remain completely compatible with the existing DDD standard for
packed files, and just increase the effective compaction.

--Sound Wave

-END-
