DEATH KNIGHTS OF KRYNN

INTRODUCTION

 This walkthru is divided into several sections for different levels of help. 
GETTING STARTED will give you tips on party composition, general combat tips, 
and a skeleton storyline which will give you a feel for what you have to do. 
As DEATH KNIGHTS OF KRYNN (DKOK) is a fairly linear game, the segments are 
then listed in order by location, with the goals and events explained. This 
will get you through the game in short order and is good for a transferred 
party from CHAMPIONS OF KRYNN which is well-equipped and experienced.

 Next, the side quests are detailed for those who want to play the whole 
game, or for those using new characters or the party supplied with the game.
These quests can yield good magic items and experience. "Dave's Challenge" is
a bonus available after the main game is won, and out of respect for the game,
I'll only give general information about it. I was able to play the entire 
game at "Champion" level using the starter party, and if you save before the
tough battles you shouldn't have *much* trouble.

 Finally, I list each location, and where possible, the exact locations of the 
encounters and known treasure caches. This is for those who don't want to miss 
*anything*.

GETTING STARTED

 The party supplied with DKOK is well suited for the forces you'll encounter 
in the game. Five of the characters are Clerics or have the clerical ability
to turn Undead (Paladin), important as there are so many of them. In addition,
one character is a Majere Cleric, allowing him to turn Undead as well as a
cleric two levels higher. You also have both a Red and White robes Mage, along
with the spells your high-level Ranger gets. As Skeletal Warriors and other
Undead are not affected by most magic and are hard to turn, everyone is a good
Fighter. Add to that the Knight's leadership ability and the Thief's backstab
(devastating if you set up the enemy properly), and you have a good group.

 If you make your own group, a Knight is a must, for he can use the powerful
Dragonlance to be found. Despite the slow advancement, if he has sufficient
statistics to become a Knight of the Rose, the clerical spells and additional
leadership ability are worth the sacrifice of the Order. There are enough
chances for experience when playing at Champions level to get him to at least
level 11. As stated before, Clerics are a must also, and a Thief's backstab
is handy in a pinch. A Ranger has his bonus against Giant class monsters
(Zombies, Skeletal Warriors, Golems) and the Paladin has a constant Protection
from Evil 10' spell in effect and the ability to Heal once per day (useful if
all your clerics are knocked out). Make sure one mage learns Haste, it can be 
invaluable in key battles.

 Weapons and armor aren't much of a problem, your characters are outfitted
pretty well at the beginning of the game. Knights are provided with Solamnic
Plate armor, mages with Bracers AC 6, thieves with Leather Armor +2, and all
fighters get regular plate armor. Each character gets a plus one weapon that
is appropriate for his class (Long Sword, Short Sword, Mace, Quarter Staff)
and 500 steel pieces. Better weapons and armor can be found after key battles
and side quests, including the Dragonlance. Magic weapons (plus) are a must,
as most creatures in the game are immune to normal weapons. This also means
that non-magical ranged weapons (bows, darts, etc.) that you can buy aren't
much good except to disrupt spellcasters.

 Money certainly isn't a problem. In the version (1.00) I played I never 
seemed to get charged for healing. Every battle with spellcasters yields at
least one Bracers AC 6, worth 3000 SP each. In fact, aside from thugs, the
occasional inn, and a magic shop that appears in Cekos after that side 
mission, there really isn't much to spend your money on.

 Most of the "routine" battles involve Evil Warriors, Black Wizards, Rogue
High Mages, Patriarchs and Skeletal Warriors. Fireballs, Magic Missiles,
Stinking Cloud, Hold Person, and Silence 15' radius are the best spells 
against all but Skeletal Warriors and other Undead. The most important thing 
is to hit the spellcasters every round, before they cast their Hold Person or 
Slay Living spells. When fighting Skeletal Warriors, work on one at a time, 
and make use of your Thief's backstab; attack from the exact opposite direc-
tion that the target was last hit or the direction he attacked. Also remember 
that pointed and edged weapons only do half damage to many Undead, so switch 
to maces, staves, and other blunt weapons.

 With the Undead, if they are far enough away, give each cleric character a 
shot at turning them. Fireballs are good against most types, and remember that 
Vampires will stay right where they are, you have to go after them. On Undead 
Beasts, don't waste magic, switch to blunt weapons.

 Dragons: what can I tell you? Remember that their breath attacks will do
50-100% of their hit points in damage, which can kill most characters. Spread
out, and with dragons that breathe lightning, stay away from walls! Your
Knight armed with a Dragonlance does his own (remaining) hit points in damage,
and dragons are susceptible to Stinking Cloud. Other than these tips, if you
know dragons are in your future, cast Haste and Resist Fire, and hope for the
initiative and lucky rolls!

 As soon as you feel up to it, you may want to do the CURSED VILLAGE side
quest. You'll get Olin's Quarter Staff, a valuable weapon that can stun any
creature for at least 2 rounds, even dragons.

 Basically, your mission in this game is to defeat Lord Soth, a Death Knight 
intent on stealing the bodies of great Solamnic Knights to convert into an 
army of Death Knights. The only way to defeat Lord Soth is to use the Rod of 
Omniscience to send him into another dimension. You must gain the trust of 
Sebas Astmoor, Soth's former servant cleric, before he'll tell where he laid 
the Rod. After returning from the quests he sends you on, you find he's been 
kidnaped by forces loyal to Kitiara, Lord Soth's consort, who wants the Rod 
for herself. A rescued knight tells you where Sebas hid the rod, which you 
retrieve. Entering Soth's castle, you fight your way to him, uncovering de-
ceptions and saving the body of the famous hero Sturm Brightblade. Using the 
Rod, you send him away, followed by Kitiara who tries to take the Rod from 
you. In a nutshell, you've saved Krynn again!

GARGATH OUTPOST

 Gargath outpost is where Sir Karl commanded during CHAMPIONS OF KRYNN, and 
was buried there after being kidnaped and slain in Neraka. Your party has been 
invited back to celebrate the victory over Myrtani one year ago, and to hear 
Maya's eulogy for her fallen love. During the ceremony, Sir Karl himself, 
raised by Lord Soth, swoops down astride a Death Dragon to shower taunts and 
cursed items upon the gathering. Flying away with Maya (in her White Dragon 
form) in hot pursuit, he steals the Dragonlance on display and leaves a force 
of Skeletal Warriors and Nightmares to cover his retreat. This is your first 
battle, and you should have used the rest period offered at the start of the 
game to memorize Fireball and Cure Light Wounds spells.

 After this battle, you take the casualties back to the keep and the exits are 
sealed against the enemy siege. You take the dead and wounded to the temple 
and are offered a chance to heal a wounded person, in exchange for which you 
are given a Ring of Protection +1. Gargath outpost is a place to get used to 
combat, get some background information, and to meet the old knight Sir Thom. 
He will give you the Sleepstone, in which is captured his strange dream con-
cerning Lord Soth and Sebas Astmoor. Gargath outpost also has an store on the 
north side of the street just inside the gates, a bank (the only one in the 
game, including a vault) across from the temple, a training hall in the south-
east and a bar south of the store where you might hear more about the Dream 
Merchant (Journal Entry 29).

 There also is an inn in the northwest corner, where you should go and rest in
the room the innkeeper points out. You'll have to fight two or three battles
against combinations of Mercenaries, Black Wizards, and Patriarchs before the
siege lifts. Memorize spells appropriate for the occasion (Magic Missile, Hold 
Person, Stinking Cloud, Silence) as well as one Charm Snakes. You then can go 
to the Commander's office on the upper level (the stairs are directly east 
from the main gates) to receive an assignment from Sir Bertil. It does not 
matter whether you choose Cemetery, Patrol, or Guard duty: if you don't choose 
Cemetery, Bertil will assign it to you after one or two tasks.

 If you choose Guard or Patrol, Sir Bertil will send you to see Ann Rampyke, 
who you find by wandering the upper battlements and towers. When patrolling, 
your encounter should occur at the southwest area of the  battlements or the 
northeast area of the outpost, near the cemetery. Guard duty is either by the 
well by the south wall or the temple. When you return to  Bertil's office 
after a task, you will first encounter Sir Garren and Commander Bertil arguing 
whether to break the siege. Garren storms out, with a cursed sword which Sir 
Karl dropped during on his visit. Upon returning from your second task, you 
will meet Sir Thom and get the Sleepstone.

 Cemetery duty involves no combat, but you hear the priest's story about the 
disappearance of Sir Karl's body from it's grave. After you help lay the 
fallen to rest, go south and west to the alcove where Sir Karl was buried and
you will meet the Dread Wolf for the first of several times. This time he's
just there to taunt you, though carrion snakes will attack (this is why you
memorize the Charm Snakes spell, otherwise the priest will rescue you).

 After the encounters with Garren, Sir Thom, the priest, and the Dread Wolf,
the siege will lift. Now you should have a clear idea of where to go and what
to do. Subsequent visits may reveal a Sivak spy, a attack by Sivaks and an
attack by Blue Dragons. For defeating these, you will get a Wand of Fireballs.

KALAMAN

 On the way to Kalaman, of course you will assist the knights being attacked
by Undead. There are many opportunities for your Knight to get experience, and
you should seize them all. Kalaman has an inn, a temple, a store in the center
of the bazaar, and a training hall. Gangs roam the street and will sell you a
map (Journal Entry 37), useful for finding your way through the bazaar. It 
also shows a spot where a bar opens at night, good for brawls and rumors. The
gangs will attack you a couple of times in the southeast corner, but after you 
beat them once or twice they'll bother you no more.

 Upon entering Kalaman, the knights will ask you to report to City Commander
Daine's house in the northeast corner of town. There, Daine, his consort 
Ariela, and Major Tems await your news from Gargath outpost. If you tell Daine 
about the Dream Merchant, Ariela will tell you his pavilion is in the bazaar, 
and warn you about Sebas Astmoor. Ariela is really a Red Dragon in human form, 
serving Kitiara (surprised?) and wants to find Sebas to get the location of 
the Rod of Omniscience. You aren't aware of this at this point, but it ex-
plains the attack on Gargath (to get Sir Thom) and the soon to come kidnaping 
of the Dream Merchant to learn the meaning of Sir Thom's dream (within the 
Sleepstone you now carry).

 Head for the Dream Pavilion, located in the northwest part of the bazaar. 
Sivaks will attack to slow you down while more Sivaks take the Merchant away. 
The forces will retreat in two directions. One force cuts a pretty clear path
that leads to the back door of the inn in the SW, a diversion while the other
group heads into the Commander's house by a secret one way door in the north-
east. You can't catch either group, so just go to the room in the southwest 
part of the inn, rest and read the kidnaper's note (Journal Entry 58). If you 
don't find the note, it'll find you some other way.

 Return to the bazaar and wait for the meeting. Ariela shows up in her dragon 
form with the Dream Merchant. Keeping the truce earns you experience and you 
avoid fighting 3 blue dragons as well as losing the Dream Merchant's trust. 
Give the Sleepstone to him, and the Dread Wolf sends Soth's forces to stop the 
Merchant from revealing the dream. Soth doesn't want his consort Kitiara to 
get to the Rod, the key to his destruction.

 Ariela flees the scene, the Dream Merchant escapes to Vingaard Keep, and you 
must defeat the troops the Dread Wolf brought (you still don't meet the beast 
in combat...yet). After this battle, you get a Clerical scroll with three 
spells. If you visit the Commander's house, Ariela (you don't know that she's 
a dragon) will let it slip the that Dream Merchant has a shop in Vingaard 
Keep. You'll return to Kalaman later after you find the truth.

VINGAARD KEEP

 Vingaard is one of the areas of the game where the overhead map view and
coordinate display are not available. Although it can be mapped into a 16-by-
16 grid, Crook Street (the only street) has three points which wrap around to 
other points. This will make direction-giving difficult, but there are only 
three locations important to find and remember how to get to. There are 
several taverns and training halls, a fletcher's shop (bows, arrows, etc), an
armorer, a temple, an inn (just inside the entrance) and other miscellaneous 
shops.

 Lord Soth and Kitiara both have forces searching for Sebas Astmoor. Soth's
men are usually slinking around between arches or meeting in back rooms while
Kitiara's Sivaks don't show up much until you find Sebas. There are thugs who
set up toll gates, after a few beatings they'll leave you alone. The Dread
Wolf will taunt you with occasional attacks, and visiting the taverns can 
bring on a fight: you can even LEAVE "Too Loudly!"

 To find the Dream Merchant's shop, turn east on Crook immediately after 
entering Vingaard. Continue south, not east, after the well, through the next
two arches. The shop is on the west side of the street, a door with a half-
closed eye on it. Make sure you rest and memorize some good healing spells at 
the inn before you seek the Dream Merchant.

 You may have to fight some tough battles before you can rest again. If you
broke the truce in Kalaman and kept the Sleepstone, you will have to fight a
dream battle to gain the Merchant's trust. After he explains the dream to you
(Journal Entries 7 & 12), you may have nightmares and be unable to sleep until
you defeat the beasts that plague his dreams. Once in a dream battle, you have
the option to awake after each fight if you are too badly hurt. However, you
will not be able to rest until you finish all three fights without waking.
After your nightmares are cured, you can rest in the shop before seeking 
Sebas.

 The candle shop can be reached from the Merchant's shop by going south 
through the arches, turning east at the next arch, continuing east to the well 
then directly south. Or, on return visits, head south from the entrance then 
east. Follow the directions exactly, and ignore the voices. When you first 
meet Sebas, choose "Talk" to start the dialogue and answer the questions to 
stop him from killing himself. If you have a knight, have him answer for the 
party. Sebas then tells his story (Journal Entry 66).

 Sebas still doesn't trust you enough to reveal the Rod's location. The party 
must prove that it is a strong force of good, powerful enough to wield the Rod 
to destroy Soth. He will first send you to the High Clerist's Tower to protect 
the bodies of the Knights within, then to the Dragon Pit to face Lord Soth and 
the Dread Wolf (finally). On your last visit to Sebas' hideout, you will fight 
a Sivak ambush, find Sebas kidnaped, and find the proof of Ariela's treachery.

HIGH CLERIST'S TOWER

 The first quest that Sebas requires you to do in order to prove yourselves
involves the defense of the High Clerist's Tower. The crypts within contain
the bodies of famous Solamnic Knights, including the hero Sturm Brightblade.
This is an irresistible source of bodies for Soth to convert into Death 
Knights, so he sends his forces to loot the tombs via an underground tunnel. 
Normally, you are only permitted in the room just inside the entrance to rest, 
but during this attack you'll be allowed into the lower levels.

 On the way from Vingaard Keep to the Clerist's Tower, you'll most likely en-
counter an enemy attack. When you enter the tower, the Knight in charge will 
be skeptical of your report of the imminent attack that Sebas told you to 
defend against. To allay your fears, he takes you down to the crypts, and to 
his surprise, the Undead legion is ransacking the tombs! One aged Knight, Sir 
Durfey, is making a valiant stand but soon will fall. He joins your party and 
together you repel the attack. While other Knights continue the defense, you 
and Sir Durfey go on the offensive, pursuing the Undead who seem to have 
someone helping them with directions.

 During these battles, you can retreat to the rooms upstairs to rest. Once in 
the tunnels, it's usually safe to rest for short periods after a battle. On 
the crypt level, the party is aided by Knights. You can explore all of the 
rooms, discovering more looted tombs, but your objective is to the far south-
west where Sturm's tomb is located. When you arrive at this location, the body 
has been taken along with a Red Dragon that was imprisoned to the north. You 
can't stop the thefts, you must chase Soth and his troops through the tunnels.

 After entering the tunnels, head south where you'll meet the Red Dragon that 
Soth's forces freed. The leader of the attack turns out to be Sir Garren, who 
is acting under the influence of the cursed sword he obtained at Gargath 
Outpost. He orders the dragon to hurl a boulder at the party, which collapses
the tunnel behind you. Garren retreats with the bodies, and as you follow, you 
must fight his rear guard at several spots. Stick to the main, wide passage, 
the side corridors lead to Giant Zombies who are trying to destroy the tower's 
supports.

 After fighting two groups of Skeletal Warriors and Undead, the party must
fight the Red Dragon. Cast Resist Fire on everyone first, and hope for lucky
rolls. Continue on and you will battle two more guard groups. The first will
get you a Short Sword +4 and a Staff Sling +3. You find a Hoopak +3 after the
second battle, then head west to finally meet Sir Garren. Take his cursed
sword away from him and he'll revert to normal and tell you his story (Journal
Entry 31). An angry Lord Soth will attempt to slay Garren, have your Knight
throw himself into the path of the blast for the party to gain experience.

 Turn south and you will see the bodies being loaded onto Nightmares. Jump
right in and attack to rescue as many bodies as possible. Then comes a mock
battle with Lord Soth, as he can't be destroyed by physical means. When he is
defeated, he gets back up, mounts a Nightmare and escapes. Don't worry, he's
not that easy the next time around. Soth will still get some bodies, including
Sturm Brightblade's. You'll get the chance to save him later.

 Now rest, return to Vingaard Keep and seek Sebas Astmoor again. He will send 
you to the Dragon Pit, where you'll finally battle the Dread Wolf, see a 
touching end to the love story of Sir Karl and Lady Maya, and retrieve the 
Dragonlance at last.

THE DRAGON PIT

 Because of your "failure" to stop Soth at the High Clerist's Tower, Sebas
still won't trust you with the location of the Rod of Omniscience. Instead, he 
sends you to the Dragon Pit, a temple to Takhisis and the stronghold of Sir 
Karl and his Undead forces. You will not be able to enter the main part of the 
temple until Sebas gives you the map (Journal Entry 41). The Dragon Pit is 
located northwest of Vingaard Keep, and the party stands a greater chance of 
encountering dragons in this area.

 Maya will meet you after you enter the Dragon Pit, and when you approach the 
secret entrance that Sebas told you about, she'll leave and fly across the 
chasm to seek Sir Karl. You can't cross the chasm from this side, you'll have 
to take the long way around. There are no absolutely safe places to rest, 
Undead patrols wander the main temple, and on the west and south sides there
is a chance of disturbing slumbering Undead Dragons.

 Once through the secret passageway, there is a room to the northeast where
a decomposing Knight is changed into a Wight as you enter. Defeat him and his
fellow Undead to lay him to rest. The Knight, Sir Bregen, disappeared on
patrol a few weeks before, as Sir Durfey tells you after the battle.

 From the secret passageway, go west to the T-intersection, south to the next 
intersection then east. The south door leads to the main altar room of the 
temple, where the Dread Wolf appears once again to taunt you, then leaves you 
to battle Skeletal Warriors and Nightmares. After the fight, you will find a 
valuable cache in the altar to the south, containing Plate Mail +3, a Shield 
+2, a White Mage scroll and a Clerical scroll.

 Head all the way west from the altar room and through the arch. Undead
Dragons sleep here, but will occasionally awake and attack the party. They
aren't a big threat as they have no breath attacks. Through the first arch to 
the south is another altar room, with Undead Dragons guarding it. A bit fur-
ther south, a Red Dragon is chained, soon to be converted to an Undead. If the 
party frees it, it will give general directions to find Sir Karl.

 Continue south then east through the arches. The far eastern exit is magic-
ally warded to allow only non-living creatures by, the party will take damage 
if it tries. Turn north then west, the rooms to the east are a stables for 
Nightmares and a barracks for Skeletal Warriors. At the end of the west pass-
age, you will confront Sir Karl, who retreats through the north door.

 Follow Sir Karl through the door and he will retreat to the east, finally
calling on the Dread Wolf to attack the party. Fortunately, in this battle 
he's behind a row of Skeletal Warriors, giving you some breathing room. The
corridor is only 4 squares wide, so your fighters can work on the Skeletal
Warriors while the back rank uses any magical ranged weapons (Staff Sling,
Hoopak) on the Dread Wolf. When you finally are able to attack the Dread Wolf
directly (and he you), what can I tell you? Hack away, and keep a Cleric away 
from the fray to cast Cure spells. The Dread Wolf gets 3-6 attacks per round 
and can hit pretty hard. Rest before resuming the chase after Sir Karl, who 
fled around the corner to the north.

 In the open courtyard Maya rejoins the party and asks if you've seen Sir Karl 
anywhere. Before you can answer, Sir Karl steps forward and Maya changes back 
into dragon form. Sir Karl plunges the stolen Dragonlance deeply into Maya's 
side, and although mortally wounded, she lifts off with Sir Karl and the 
Dragonlance. Too bad for you, your party will have to battle Sir Karl's mount
without that powerful weapon. The Death Dragon was awakened by the fuss and
attacks. This is one tough battle, the Death Dragon breathes Death, and it can
do 50-100% of the Dragon's hit points in damage to the characters it hits. At
Champion level, the damage is 90-180 hit points, enough to kill most of your
characters outright. You must hope for the initiative and try to immobilize
the Dragon immediately with Stinking Cloud or stun it with Olin's Quarter 
Staff (if you've done the CURSED VILLAGE side quest).

 After this climactic battle, you finally recover the Dragonlance for your
knight to use. Through the eastern doorway is the dragon's hoard, with more
silver pieces, gems and jewelry than the party can probably carry. Of more
interest to you is a Short Bow +3, Leather Armor +3 and Plate Mail +2. After
collecting the loot, take the east door, follow the passage to the chasm which
is now crossable. Exit the temple and witness the end to the story of Sir Karl
and Maya, at peace at last.

ARIELA EXPOSED

 With the Dragon Pit quest completed, you should return once again to Vingaard 
Keep to seek Sebas, who is finally going to reveal the location of the Rod of 
Omniscience, right? The door sequence is the same, but the final secret door 
to Sebas' hideout doesn't appear. Pass through two more special doors to the 
*real* hideout. Upon entering, you fight a Sivak ambush for which the party 
gets a Long Sword +3 and a Red Mage scroll. After the battle, you find that 
Sebas has been kidnaped and evidence of Ariela's involvement, an earring! 
Proof in hand, go to Commander Daine's house back in Kalaman and show the ear-
ring to Daine. He will have Major Tems watch the party while he confronts his 
consort and the Major will tell you of his suspicions (Journal Entry 46). This 
will give you an idea where Ariela goes to meet Kitiara.

 When Ariela is exposed, she slays Daine and orders some Sivak troops to fight 
you while others take Sebas away (Journal Entry 25). You'll have the help of 
some Solamnic Knights for this battle, afterwards Tems leaves you to guard 
Ariela (you still don't know her true form) while they chase the Sivaks. 
Ariela changes into her Red Dragon form and you must fight her, which should
be easier if you have a Knight to use the Dragonlance. This battle will get
the party an Elixir of Youth.

 With Ariela defeated, pursue the kidnapers west, through the second door to 
the south, and out the secret one way door to the west which leads into the 
bazaar. The Sivaks split into two groups once again, and as before, one is a
diversion and the other has Sebas. You'll not be able to catch the group with
Sebas, but defeating the other group will get you a Dart of Hornet's Nest and
let you rescue the young knight that was in Sir Thom's dream. He was in a cell
with Sebas inside the Commander's house, and relays the message Sebas gave him
concerning the Rod (Journal Entry 36). He also teaches you the chant to enter
Voice Wood. If you don't find the group with the Knight, (in the southwest
corner of the bazaar), go to Daine's office where Major Tems gives you the 
same message and teaches you the chant.

 Although you now know that Ariela visited Cerberus to meet with Kitiara 
(there is a tunnel in Cerberus graveyard leading into Daargard Keep), Cerberus
and the graveyard are really a side quest and are not essential to the story.
I will describe them later, Dulcimer is the next step in this walkthru.

DULCIMER

 Dulcimer is a twisted duplicate of Cerberus, created by a lich who admired
the town. Save often here, as the town is inhabited by Undead and once the
fighting starts, the potential for lost levels is great. Shortly after you
enter the town, you are greeted by the Lich Mayor and warned to stay out of 
his personal quarters and the eastern exit from the town (which is the en-
trance to Voice Wood). If you attempt to leave by the eastern exit, a spectre 
appears and tells that the Lich must be destroyed before he can let you pass 
and be freed himself. Slaying the Lich isn't enough, he will keep regenerating 
until you find and destroy the phylactery, which contains his soul.

 Dulcimer's citizens are all Undead, going through the motions of life. The
tavernkeeper will serve you a glass of acid, and the Farmer's Market doesn't
offer anything remotely palatable. There are a few locations in the game where
your clerics will have less success Turning Undead, Dulcimer is one of them.
For the most part the town is safe to wander save for an occasional attack by
Spectral Minions and Wraiths.

 In the far northeast is a building where Zombie Giants are gambling. You may 
want to battle them before going into Town Hall, as you will get a Scroll of 
Protection against Dragon's Breath, a Long Sword +4, 4 Darts +3, and a  Potion 
of Invisibility. These items will free for the taking after the Lich is gone, 
but you may want to have the Potion and Sword for the next battles.

 The Lich's quarters are in the Town Hall, just go straight north from the
town entrance. On the side of Town Hall is a live man in the stocks who tried
to kill the Lich but forgot to destroy the phylactery. Enter Town Hall and
pass through the door to the north. If you immediately go west and confront
the Lich, you will face his guard of Spectres and High Wizards as well. Cast
Protection from Evil spells as well as Bless and Prayer (Haste is helpful,
also) before entering the room. Well-placed Fireballs will do a lot of damage,
but try to take out the Spectres first, remembering that a Lich can immobilize
a character but that it doesn't drain levels.

 An alternative to battling the Lich and his guard at once is to first enter
the guard room to the east. If you fight the force in here (Spectres, Zombie 
Giants and Skeletal Giants) and reenter the room to fight another wave; after-
wards, you can enter the Lich's quarters and battle the Lich alone.

 If you fight the Lich with his guards, you will may recover some Darts +3, if 
the Wizards haven't used them all. After slaying the Lich, head directly for 
the garden (of sorts), located directly west from the entrance to Dulcimer.
You may encounter a battle or two along the way, but don't stray or stop to
rest as the Lich will soon regenerate. You will get three warnings in the form 
of increasing winds before he strikes again. Use the Area command and head 
directly for the center row of rotting asparagus. Dig up the phylactery and 
smash it and all the Undead will crumble, including the Zombie Giants who 
guard the treasure in the northeast.

 With the evil removed from Dulcimer, the spectre is free to leave as well.
You may enter Voice Wood via the eastern exit from Dulcimer and recover the
Rod of Omniscience from the Hall of the Voice.

VOICE WOOD

 After destroying the Dulcimer Lich the party is free to enter Voice Wood if 
it has learned the chant from the young Knight rescued in Kalaman. You must 
make your way through the hedges and trees as well as an enemy attack to the 
Hall of the Voice at the eastern side of the Wood. Although Voice Wood is 
strongly protected from evil forces, powerful High Wizards can cast a short
lived Protection from Good spell to allow them to enter.

 The Area command is available inside this area until you receive the Rod, so 
remember the path to the Dulcimer exit. Should you become lost, there are 
arches that will transport you to four different areas of Krynn. The arch in
the Northwest corner takes you to Throtl, the northeast arch sends you to the 
forest just north of Dulcimer, the arch in the southeast goes to Turef (Dwarf 
Village) and the arch in the southwest corner transports you to the west of 
Turef. There are a few enemy encounters to be found if you wander, a band of 
High Wizards and Undead are in a clearing to the south, Fire Minions leap from 
a rock in a glade to the east, and Whisper Spiders lurk by the far north and 
south walls.

 Rest in Dulcimer before entering Voice Wood and memorize many healing spells 
and Fireballs. The sprites will allow no one to rest, and the High Wizards 
cast powerful Magic Missiles. The most direct route to the Hall of the Voice 
is almost directly east, you may walk right through the shorter hedges. Upon 
entering the Wood, go directly east through three arches to an altar to 
Paladine. Making an offering here will make your upcoming battle easier. Exit
through the arch and go north once and east four times. East once more and you 
encounter a large group of High Wizards, Wights, and Giant Undead. The Wizards 
are usually in the front ranks, have your Mages cast Fireball towards the back 
ranks so the edge still hits some Wizards while your fighters work on the 
rest. The number of the enemy will be reduced if you offered to Paladine.

 Proceed east through the arch and south once. At both spots the party will
take unavoidable minor damage from limbs and vines. You may avoid one of these
encounters by taking a slightly different route, but then the battle with evil
forces will take place in a more open area, allowing more Undead to reach you.

 Now to the east where you meet Sprites that intend to block your way. This
is a test of your virtue, if you attack you'll be sent back to the entrance.
Walk past, through the eastern door into the Hall of Voice Wood. The Voice
speaks (Journal Entry 39) and you are given the Rod of Omniscience if you vow
to use it only against Lord Soth. Refuse, and you'll also be sent back. With
the Rod in your possession the overhead view and coordinate disappears, but
the maze seems to remain the same. Retrace your steps to the Dulcimer exit,
and rest.

 The party now has the Rod with which it can destroy Lord Soth. You may go
directly to Dargaard Keep (described next) or complete the side quests to gain
more experience and magic items. It doesn't matter, Soth awaits.

DARGAARD KEEP: FIRST FLOOR

 Dargaard Keep can be entered in two ways, both require that you have found
Ariela's key after slaying her in Kalaman. You may enter from the Cerberus
graveyard tunnel using the key, or through the main drawbridge entrance by
giving the password inscribed on the key (Journal Entry 32). Even if you know
the password from peeking at the Journal you won't be prompted to enter it
until you have the key. As in Dulcimer, Clerical Turning ability is diminished
here, however, the programmers seem to have neglected toning down the 
Paladin's Turning ability. If you have a Paladin in the party, he stands the 
best chance of turning the Spectres and Vampires here.

 If you entered by the main entrance you will be ambushed by Vampires and
Wraiths after passing through the doors north of the drawbridge controls. If 
you want to avoid this, enter through the Cerberus graveyard tunnel (see the 
CERBERUS GRAVEYARD side quest). After the battle with the guards or after en-
tering the Keep via the tunnel, a young woman named Lenore will ask to tag 
along with the party, giving her story (Journal Entry 57). Lenore is really
Kitiara in disguise, and is waiting for you to destroy Lord Soth so she can
take the Rod of Omniscience for herself.

 If the party refuses to allow her to follow, she leaves and if Sir Durfey is 
still with you, he leaves to escort her home. If Durfey is dead but still in 
the party, his body disappears during your first battle. If you allow Lenore 
to follow you, she will "discover" a trap or two, reinforcing her story. If 
the party leaves Dargaard Keep, goes up to the second floor, or enters Camp 
mode for any reason, Lenore will leave and Durfey will leave the party to see
Lenore safely "home."

 Once inside the Keep, the party should make its way to the servants' quarters 
in the northwest corner. From the main entrance, go north to the welded doors, 
west and south through the arches. When you approach the door to the south, 
talk to the maid to hear her story and receive the key to the door that leads 
to their quarters. Now south through the door and follow the hall around to 
the north. If you entered Dargaard from the tunnel you should go directly 
south all the way to the welded doors then west all the way (you'll encounter 
the maid along the way). If you encounter any patrols, go ahead and fight 
them, there are four of them on this level and they must be killed to lift the 
geas on the servants.

 Now, use the key to enter the servants' quarters then north through the next 
door. Here you'll meet the kidnaped citizens from Cerberus and hear how to 
lift the geas that holds them in the Keep (Journal Entry 22). Follow the 
secret passage to the Commander's closet and destroy the Orb. If you try to
enter the Commander's bedroom from the front you will have to fight two Undead
guard groups first.

 If you haven't killed all four patrols, wander the area and you'll find them. 
Once the geas is lifted, a servant will give you a skull stolen from the Com-
mander that will open the tunnel back to Cerberus graveyard. With the patrols 
eliminated, this area of the first floor is safe to wander.

 On the east side of this level is a makeshift prison where Sebas was kept for 
a while. Searching any of the rooms in this area will reveal a amulet with the 
initials "S.A.". In the northeast corner of Soth's throne room is a secret 
door. This leads to another secret door where the party will hear priests 
chanting. If you enter the room beyond before the chanting stops you will 
fight the priests and find a 2-Handed Sword +3 on the altar to the east. If 
you wait until the chanting stops the room will be safe to enter, but the 
sword will be gone.

 Pass through the two doors to the south and the party will enter a room where
it hears cries for help from a coffin in the southwest. If you open the coffin
Vampires ambush the party. There's no reward there, it's best to leave it be.
Go north through the door in the northeast corner of the room to the stairs
leading to the second floor. If Durfey is still with the party when it goes up 
this stairs, Lenore and he depart.

DARGAARD KEEP: SECOND FLOOR

 On this level, the party chases guards who are rushing their prisoners 
further into the Keep. The prisoners are Clerics from the High Clerist Tower
and some citizens from Cerberus. The Clerics are here to recover the body of
Sturm Brightblade before Soth's forces convert him into a Death Knight. You
will find Sebas on this level and a treasure cache. There are no wandering
Undead here, but two battles will include a Death Knight.

 Immediately upon ascending the stair you see the guards to the west, and a 
group of spectres and vampires attack. Chasing the guards, they flee around 
the corner to the south and a portcullis closes behind them. The room to the
west is guarded by vampires who are distracted by something, allowing the 
party to sneak past into the next room if you wish. However, if you intend to 
leave Dargaard for some reason (training, identifying treasure, restoration) 
you may want to fight them now, otherwise they will appear as you go down the 
stairs.

 In the center of the room beyond the vampires, pull the lever to raise the
portcullis. Head east then south through the open portcullis. Cast Resist Fire 
on everyone, as just to the south you will encounter a guard group with Black 
Mages, Vampires, and a Death Knight. The Death Knight is not really tough 
after he casts his Fireball, but he can cause the nearest party members to 
flee from his aura of Fear. After the battle, you rescue the clerics from the 
High Clerist Tower and they ask your help in locating and recovering the body 
of Sturm Brightblade. If you need to leave Dargaard, the clerics will wait at 
the stairs for your return.

 The remaining guards flee to the west and south through another portcullis.
The party must fight Flesh Golems in the room to the west to reach the lever
that opens the portcullis. South from this room you can now reach a row of
cells, any of which is safe to rest in. When you're ready to move on, go south
then turn east at the corner. Through the north door is a guard posted with
Spectres, Flesh Golems and Vampire Mages. This group defeated, exit through
the east door and enter the first cell to the north. You find Sebas Astmoor,
tortured to the point of death. His dying speech (Journal Entry 54) warns the
party to beware of Kitiara, Soth's mistress, who also wants the Rod. Any of 
the other three cells on this hall are safe resting places.

 After resting (be sure to make sure there's enough Resist Fire spells for
everyone) go east to the intersection then north. The prisoners from Cerberus
are about to be converted into rats by evil Clerics. If the party attacks im-
mediately, the battle is much easier. Afterwards, the few prisoners not 
changed will ask you to find a way to restore their friends to human form.
If you haven't done the Cerberus quest yet, they will tell you of the trouble
there. Before you seek the counterspell, you may want to claim the treasure
cache in the Cleric's quarters. Through the western door and all the way down 
the hall, enter the west room where you find Plate Mail +4, a Wand of 
Lightning, a Potion of Extra Healing, a Necklace of Missiles and a Red Mage 
scroll.

 Return to the intersection, through the eastern door and enter the room to 
the south. Read the circled incantation in the tome to change the townspeople 
of Cerberus back into humans. Head back to the intersection and go south where
you find mages and clerics attempting to convert Sturm Brightblade into a 
Death Knight. You interrupt the spell and they attack, with another Death 
Knight. Make sure you have cast Resist Fire on all the party members before 
entering the temple and Fireball the magic users before they can get their 
spells off.

 With this battle won, the Clerics will shower you with praise, proclaim you
heroes, and carry Sturm's body back to the High Clerist's Tower. You still
must find and destroy Lord Soth, deal with Kitiara, and, by the way, where did
Durfey go? From the temple, pass through the west door and go west then south
and east around the corner to the stairs to the third floor. Before you make
this ascent, I advise returning to Kalaman to train, identify items, and rest.

DARGAARD KEEP: THIRD FLOOR & ENDGAME

 Save before climbing the stairs to the third level of Lord Soth's castle.
Once you get past the first room, there is no way back. This floor has several
one way doors, fake doors, and dead ends. The Area command is not available,
and Lord Soth will not allow the party to rest often. There are only two or
three battles to be fought, unless you pass through a wrong door.

 Starting from the stairs, go west and enter the room with 3 doors. Soth's
voice tells you that two of the doors lead to death. That's not quite true:
the right door is an illusion and will do damage to the party, while the mid-
dle door leads to a dead end and a battle with weretigers. Pass through the 
door on the left, this is the point of no return. Enter the next room to face 
another set of doors and Soth speaks again. The left door is fake, the right 
door contains more weretigers, and the middle one (one way) leads on.

 The next room has another trio of doors, the middle and right ones merely 
open into empty rooms. The left door also leads into a room with a secret door
to the north. Here Lady Lenore rejoins the party, claiming that she and Sir
Durfey were attacked by Death Knights on the road. She says Durfey was slain
and made Undead, while she fled and hid here. She follows the party from here
on, claiming to need "protection," and "helpfully" points out the secret door
to the north, also one way.

 Entering the next room, pass through the east door and proceed east then 
south through the archway. If you approach the south doors, trapped with 
spikes and razors, Lenore will tell you there's a secret passage bypassing the 
doors. If a party member attempts to open these doors, it is likely he will 
take damage and be unable to open it. A high-level thief has a better chance, 
but it is wiser to follow the secret passage. The door is in the northeastern 
corner, pass through and go through the door to the east. Now, through the 
door just to the right and follow the narrowing passage to the secret door 
that leads into the room on the other side of the trapped doors. Wasn't Lenore 
helpful?

 Through the archway to the south then east and you come to a door with two
statues who warn the party not to proceed. These are Iron Golems, and the
party may want to attack them now, otherwise they will join in the next fight
just beyond this door. Enter the next room and confront an Undead Durfey, who
attacks his old comrades aided by spectres and the pair of Iron Golems (if you
didn't fight them already). Slay the Undead Durfey to send him to his final
rest, and prepare to face Lord Soth.

 East to the hall then north through the door. Save here then cast Resist 
Fire, Bless, Prayer, Protection/Evil and anything else in your spellcasters'
books that applies (Haste is a good idea). Through the next door waits Lord 
Soth himself, flanked by four more Death Knights and several Iron Golems. If 
you concentrate on one or two Death Knights you may be able to take down at 
least two of them before they can cast their Fireballs, especially if the 
party is Hasted. Once the Fireballs are cast, the fight is mostly a matter of 
brute strength, as most magic spells won't do much good.

 With Soth down but not out, strike him with the Rod of Omniscience before he 
regenerates. If allowed to rise again, he will inform you that he can not be 
destroyed while Dargaard Keep stands then attacks again. The rod opens the way 
to another dimension and Lord Soth is pulled into the vortex as he calls out 
to Kitiara for help. Once he is banished, Lenore reveals herself to be Kitiara 
and reaches out for the Rod. She recites an incantation she wrested from Sebas 
Astmoor through torture, but Sebas has the last laugh even in death as the Rod 
explodes, banishing her to another dimension and transporting the party to the 
High Clerist's Tower.

 You are led to the Knight's Council by the poor Knight in front of whom you 
suddenly appeared. After telling your tale, praise is heaped upon the party 
then you are left alone to do as you wish. The land is much tamer now, enemy 
encounters are greatly diminished and friendly people wander freely. Now you 
can finish any side quests you missed or try "Dave's Challenge," an extra 
quest available in the northwest after Soth is defeated.

SIDE QUESTS

 This section details locations in the game that aren't essential to the main 
story but which provide experience and valuable items. If you're not using a 
transferred, well equipped party from CHAMPIONS OF KRYNN, these quests may be 
very good for you. If you see a quest listed that has an item you would like 
and you think your party can handle the monsters, try it.

CURSED VILLAGE

 This small village is located on the piece of land northwest from Vingaard 
Keep where the river forks. A meteorite has crashed into the tavern, convert-
ing some of the inhabitants into Undead. Black Mages are holding the village
sorcerer prisoner while an impostor assures the villagers that the meteorite
is harmless. Undead wander the town and nowhere is safe to rest until the
meteorite is destroyed by the real sorcerer. The Area command and coordinate
display are not available here.

 Upon entering the village, a boy leads the party to the sorcerer's house in 
the southwest corner. The impostor tries to convince you that there is no evil 
in the village. The shopkeeper and the herbalist express their concern when 
visited. The real sorcerer is being held by High Wizards in a building in the 
northeast corner. The High Wizards cast powerful Magic Missiles, cast Hold 
Person, Stinking Cloud and Magic Missile spells to defeat them. Once the 
village sorcerer is free, he fills you in about the meteorite.

 The sorcerer will follow you to the tavern, the large building in the north-
west. Once you defeat the Wights, Wraiths and Spectres, the sorcerer will 
destroy the meteorite. The party finds a Ring of Protection +2, a White Mage 
scroll and Olin's Quarter Staff. This weapon can stun any enemy for two rounds 
or more. After the battle, return to the sorcerer's house to confront the 
impostor. This is an easy battle as the High Wizard is surrounded by Fire 
Minions who keep damaging him when they flare.

FUN HOUSE

 On the east side of the pass between Throtl Keep and Gargath Outpost, in a
little curve of mountain, a Dwarf named Gluten has built a house of riddles
and monsters. He will award treasure to those who can pass through the house
using a combination of brains and brawn. The Area command and coordinate dis-
play are not available here. Resting is completely safe.

 After Gluten's introduction, enter the door to the north and go north to the 
talking wall, which will ask you a riddle. If the party answers "WATER," it is 
teleported to another talking wall, else it must battle Zombie Giants and 
Spectres before the next riddle. Answer "HANDS" to teleport to the third 
riddling wall, then answer "RING" to the riddle to gain experience. If you
fail the second riddle or after answering the third (correct or not), you are
teleported to fight Wraiths and Spectres.

 Exit south from the last room, west then north at the corner. Pass through
the one way door to the west, then south through the next two doors. The party
battles a Lich and Wights and finds a Mace +4. Pass through the secret door in 
the southeast, then south, west, north and east to teleport back to the en-
trance. Gluten appears and gives the party a Red Mage Scroll and a Girdle of 
Giant Strength, which increases a character's strength to 23 when worn.

FATHER OF TREES

 In the south central part of the land, near the bottom of the map, a faerie
forest is dying. The Father of Trees, which is the life force of the forest,
is under attack from within by evil forces. A Faerie Warrior ventured inside
with a wand of tree healing to heal the tree was captured. The party has only
one chance to do this mission, do not approach this area unless you are ready.
No magic will work inside the tree and if the party leaves before rescuing the
Faerie Warrior and recovering the wand, the quest ends and the forest dies.
Once again, the Area command and coordinate display are unavailable.

 There are some tough battles in this area, Wights to the southeast, Wraiths
in the center, Whisper Spiders in the southwest, and Wyndlass in the north-
east. However, the only fight necessary to complete this quest is in the far 
northwest corner where a High Wizard is using Fire Minions to burn the tree. I 
advise the party (especially less experienced characters) to go straight here, 
as the other battles are much harder, especially the Wyndlass. The High Wizard
can't cast spells, and the Fire Minions damage him as well you. You release
the Faerie Warrior held here and recover the wand of tree healing. The party
finds a Periapt Proof vs. Poison and Boots of Speed, which double a charac-
ter's movement points and lower his armor class by two while worn! Return to 
the entrance to heal the tree and the forest, completing the quest.

SHIPWRECK

 Follow the sea shore northeast from Kalaman to find a ruined pirate ship,
cursed by a Wizard whose ship the pirates sank. There is good treasure here,
but some tough Undead, and Clerical Turning ability is diminished as well. 
Save often as the possibility of lost levels is significant. Giant Zombies, 
Giant Undead Rats and Wraiths occasionally attack, and nowhere is totally safe 
to rest. The Area command and coordinate display are unavailable.

 Use the rope to enter the ship, the ladder will break, injuring the party.
Directly to the east you encounter a large number of Giant Zombies, some of
the former crewmembers. Through the north door and to the east are the offi-
cers' quarters, inhabited by wraiths. Jewelry and gems are found after this 
fight. Across the hall to the west and through two doors you fight the spectre 
captain, his wraith officers and Giant Undead Rats to find jewelry, gems, and 
a Mace +4.

 The hall turns the corner to the north and descends into the ship's hold.
Move east from the ladder and fight a Giant Zombie and a small army of Giant
Undead Rats. In the northwest corner of the hold is a secret passage trapped
with crossbows which you may be able to detect and disarm, else everyone takes
damage. Through the passage the party finds the pirate's treasure, jewelry,
gems, silver pieces, Banded Mail +3 and a Long Sword +3.

TUREF

 Turef is a Hill Dwarf village located on the end of the mountain range south 
from Throtl Keep. Upon entering, you'll meet Skomp, a Mountain Dwarf who is 
trying to unite the dwarf villages against evil. This village is under the 
control of evil forces, and they are using cursed items to convert the Dwarves 
into their warriors. Skomp is knocked from his wild boar mount and set upon by 
the crazed Dwarves. The party should immediately attack and help Skomp, listen 
to his story (Journal Entries 6 & 20), then agree to help him.

 The village is patrolled by a wide variety of evil creatures (Wraiths, 
Wights, Vampires, Ghouls, Ghasts, crazed Dwarves, Black Mages and Priests), 
and the composition of each group as well as the number of the attackers is 
very unpredictable. You should save after every encounter. Only one location 
is totally safe to rest in, but resting indoors is safer than outdoors.

 Upon entering the village, you should enter the building to the east. A
scholar will tell you about the ransacking of his study and the theft of a 
book called "Ambush Made Easy" (Journal Entry ). The enemy is using it to pro-
tect the entrance to their headquarters in the center of the village. If the 
party tries to enter, it will face an overwhelming series of battles. Once the 
book is returned, the scholar will tell you how to avoid the ambush.

 Using the Area command is probably the easiest way for me to direct you to
the locations in Turef. You will spot Skomp's boar between the two buildings
in the southeast corner of the village, just south from the building shaped
like a cross. The party should choose to follow Skomp to gain experience, if
it chooses to fight the patrol instead, it will find Skomp badly injured 
later. Following Skomp will lead the party to a random location, and the boar 
is still loose. You will not find the boar until you defeat the Evil Mages and 
Blue Dragons in the room beyond the ambush.

 In the south central section of Turef is a tavern and a locksmith shop. To 
the east of the tavern is a house where an anguished mother asks you to spare 
her son, who wears a purple hat. Just to the north of this location and 
through the east door you will fight some sentries, after which you continue 
east, north then east again to the one safe resting place. Searching here will 
also yield some gems.

 In the northwestern corner of the village is a building where brainwashed
dwarves are given combat training. The young dwarf wearing a purple hat will
rush the party, you should wrestle him to the ground, knocking him unconscious
until after you battle the rest of the dwarves in the building. Following the
fight, the dwarf recovers, thanks you and mentions that he saw a soldier hid-
ing a book inside a shield. If you return to the mother's house, you will 
receive a Cloak of Displacement.

 Just to the west of the entrance to the village is a barracks with many
soldiers and a Blue Dragon, all asleep. Take the shield propped against the
Dragon (a Shield +4) and the book "Ambush Made Easy" will fall out. The troops
and the Dragon will awaken as you take the shield, the troops will attack and
the Dragon will flee. After the battle, return to the scholar and give him the
book. He will explain that there is a way around the ambush through a secret
passage in the tavern. If you have a drink or two with Milo at the tavern, he
tells you about the secret passage and that the key required is #88.

 The locksmith shop to the south of the tavern sells keys for 100 sp apiece,
and will ask you for the key number. If you carry more than one key, they may
rattle and attract a patrol. Ask for key 88, then return to the tavern. The
passage is in the northwest corner, pass through it and west to rescue the 
village magistrate from her torturers and receive gems. Now north through the 
next three doors to surprise soldiers and spellcasters in the center of the 
cross-shaped room. The next door takes you behind the ambush in the open area, 
and if you choose to fight the remaining bushwackers flee after the first 
fight.

 The door to the east is one way and leads to the room where the mages are us-
ing the cursed items to brainwash the Dwarves. After defeating the force here, 
you must stop the three Blue Dragons who are loaded with the cursed items and 
preparing to flee. This ends the evil in the village, and the dwarves return 
to normal. Exit through the eastern one way door to discover Skomp's slain 
wild boar, whereupon Skomp leaves the party. You may not leave Turef with the 
boar carcass, but if you take it directly east and give it to the cook for his 
meatless stew he'll give you a Short Sword +2.

KUO-TOA SLAVE SHIP

 This quest may start automatically as the party wanders near the river, you 
get no choice whether or not to participate. I advise you to stay away from 
the river (as much as possible) if you aren't ready for this adventure. The 
party sees peasants being put on a ship by Kuo-Toa warriors, but can't attack 
directly for fear that the slaves will be killed. You don disguises and hide 
your weapons (sure... your knight just pockets his Dragonlance!) then allow 
yourselves to be led aboard and put in a cell. The cells are the only safe 
places to rest, and after the fight in the temple you can't return there.
There are no wandering patrols until after the alarm sounds, and once the fire
starts the Kuo-Toa are usually more interested in fleeing into the water.

 Once in your cell, you show your weapons to a slave, who tells you to rest
up then meet the slaves in the room to the east of the cells. Fireballs and
healing spells are needed for this segment, as are Dispel Magic. The Kuo-Toa
clerics cast Poison, so after the fighting starts, save often.

 With the party rested, exit the cell and go east to join the meeting and hear 
the slave leader's escape plan (Journal Entry 15). The meeting is broken up by 
guards who order you to report to the galley. Pass through the north door and 
enter the room to the west. Fight the Kuo-Toa here, then continue out the west 
door, around the corner and through the north door and another attack. You 
find a Long Bow +3, Chain Mail +4 and 10 arrows +3. Neither battle raises an 
alarm and you hide the bodies.

 Return to the hall and follow it north to the galley. Meet the slave in the 
pantry, he gives you some more advice, then exit through the east door of the 
galley. Proceed to the dining room, ignore the insults and the Kuo-Toa will 
become bored and let you pass. The Kuo-Toa in the next room will ignore you if 
you caused no trouble in the previous room, otherwise they attack. Continue
through the south door and down the hall. Be sure you are fully rested before
you enter the temple, then attack immediately for an easier battle with the
Kuo-Toa Monitors and Clerics.

 The battle in the temple sets the ship on fire, making it impossible for the 
party to return the way it came. Leave the temple by the east door and go all 
the way north and through the door. Fight Kuo-Toa who are searching this room 
for loot, then enter the room to the east and fight more Kuo-Toa. In the small 
closet in the east wall the party will find a Mace +4, but only after search-
ing and taking damage from fire. Now back to the bow, through the east doors 
to fight the Kuo-Toa here who are trapped and desperate. With these defeated, 
continue east and rendezvous with the slaves who will defend your rear as you 
dive into the water and swim for the shore.

QUAZLE

 A small gnome village north of Vingaard Keep is in chaos because a mad gnome 
invented a picture making device and locked himself in his workshop. The Sage 
Gnomes, who draw pictures of everything, saw this device as a threat and asked 
the Mechanical Engineering Gnomes to make a device to counter the mad gnome's 
invention. The Mechanical Engineering Guild created such noisy and dangerous 
devices that the town thought it was under attack, and soon the gnomes were 
running around with weapons that often misfired, adding to the massive confu-
sion. An Evil Mage seeking to increase his power came upon the village and 
killed the mad gnome. He took over the workshop, set traps around it and 
turned a pack of Undead Beasts loose to maintain the chaos.

 The party is met by the Foreign Relations guild when it enters Quazle. The
gnomes point out the various guilds, then you sent are on a tour of the Hall 
of Technological innovations. After the party is shown several exhibitions, 
the game warns that they risk being bored to death. It didn't happen to me, 
but you should escape regardless, as you have something more important to do. 
You may be drawn back by the persistent gnome, then you must escape again.

 There are a limited number of Undead Beasts in the Evil Mage's pack, and the 
party encounters them in groups of two while wandering the village. You will 
fight the remaining ones along with the Wizard when it enters the shop in the 
northwest corner. Wander around the village and fight the Undead Beasts you 
encounter until it seems there are no more, this will make the battle with the 
Evil Mage much easier. The encounters with the gnomes around the village and 
in the guilds are amusing, and the party gains experience for healing the 
injured gnome in the hospital.

 The entrance to the workshop is protected by three poison gas clouds that
will damage the party. Two of them can be avoided by passing through the
Mechanical Engineering guild, the building to the north of the entrance to
Quazle. Immediately destroy the machine when you enter the building or the
party will take damage. The workshop door can be opened by a Knock spell cast
by a mage, by bashing it or by picking the lock. The Evil Mage tells his story
(Journal Entry 41) and the fight ensues. The party finds Eyes of Charming, a
Potion of Healing, and a Potion of Speed.

CEKOS

 Dragons have taken control of this town, and with their Sivaks have made 
magic illegal and made the people their servants. Magic is still practiced in
secret, but the people are wary of all strangers. Some of the townspeople will
allow the party to rest in their homes, and the town cleric will allow you to
stay in his house in the northwest part of Cekos. There is a shop in town that
sells normal weapons, but after the party clears out the dragons it will sell
Darts of Hornet's Nest and Arrows +3 for high prices.

 After entering the town, go directly north and you meet an old woman whose
daughter was taken by the dragons. The party should agree to help locate her,
then the woman gives you an amulet and a Quarter Staff +2. In a building to 
the west of the entrance a wizard teaches magic. If the party talks to him, he 
will give information then disappear. If you attack, he casts a Fireball be-
fore vanishing.

 Continue north from the entrance, past the statue of Cekos in the center of
town. If this statue is approached after 14:00 (night), it appeals to the 
party to save the town and gives them a White Mage scroll with three 8th level
spells. On the east central side of town are a tavern and an inn. If you de-
cline to drink while in the tavern, you'll hear a tale of treasure hunters
(Journal Entry 59). If the party refuses to leave the inn when requested,
Sivaks attack. Along the wall north from the tavern, you encounter a vagabond
who tells you about Cekos and the statue (Journal Entry 28) if the party gives
him some steel pieces.

 To the north of the statue of Cekos and slightly west are two small build-
ings. If you enter the northern one, rogues will offer food and drink which 
will mildly damage the party if accepted. In the southern building the party 
meets Igorf, here to reclaim his "family's fortune" (Journal Entry 33). Igorf 
is really a copper dragon in human form, and if allowed to join the party will 
transmogrify during battle. He's a good ally, but his presence may make more 
townspeople (including the cleric) unwilling to let you rest in their homes. 
He will take a portion of the treasure the dragons have kept in their hoard 
when you defeat them, but there's plenty left for the party.

 The town hall is in the northeast corner of town, trying to pass the Sivaks
in the first room will cause them to attack. Pass through the north door and
battle more Sivaks, after which the party finds a key that will open a secret
passage to the dragons' lair. A building to the north of the entrance has a
jail on it's western side. Free the prisoners there to gain experience, and
they will tell you why they were imprisoned. The south door of this building
leads to a kitchen where you may see a servant carrying food. You have a ran-
dom chance to be able to follow her to the passage to the dragons' lair. Pass 
through the north door from the kitchen and you meet the "mayor," a Sivak in 
disguise, attack him to reach the secret passage to the west.

 With the key from the fight with the Sivaks you can pass through to the en-
trance to the dragons' lair. Exit this room to the south, follow the hall to
the west, out the west door then south. Sneak past the Sivak guard post, then
through another secret door to the east. The party must defeat 5 Blue Dragons
here, but if Igorf is here he takes one on himself, leaving you four. After
the battle, Igorf takes his share of the treasure and leaves, and you find
jewelry, gems, silver and a Wand of Paralyzation. If you have the amulet that
the mother gave you near the entrance, the daughter (a princess) will follow
you back to her mother and you will receive gems.

THROTL KEEP

 An evil priest named Lessiter has taken over Throtl Keep and has turned it
into a base of operations from which to create Undead armies. There are no
wandering patrols, but many encounters with High Priests, Skeletal Warriors,
Undead Dragons, and other Undead. Nowhere is completely safe to rest, and
there are some tough battles.

 Upon entering, the party is met by Lessiter, and when it attacks he flees to 
the east. You fight Skeletal Warriors and Wights, then you can chase him east-
ward or take a more direct route directly north. If you follow the chase 
route, there will be several very tough battles. Pass through the arch to the
east and through the door, turn north at the corner and you will encounter 
Undead Dragons. East then through the north arch and directly east is the door 
to the Throtl vault, where the party finds money, a Composite Bow +2 and 10 
Arrows +2. The party may continue to the north and around to the west, but it 
will face some hard fights with Patriarchs and Undead. Alternatively, you can 
retrace your steps back to the entrance and pass north through the arch and 
the next two doors. Both routes lead to the same four-way intersection where 
you face a difficult battle with Priests, Wights, Ghouls and Skeletal 
Warriors.

 From the intersection, continue north through the door and all the arches,
west through the next two doors. You meet Sarah, a Priestess of Mishakal who 
is looking for her love, Sir Michael. They came to Throtl to rid it of evil,
and the Knight was captured. Continue to the west and you encounter a large
group of priests and wights. Exit the room to the south and immediately take
the eastern door. In the center of this room Sir Michael is held, and as Sarah 
rushes to heal him, the party must fight Lessiter and his force of Wights, 
Ghasts, Skeletal Warriors, and Priests.

 With Sir Michael reunited with Sarah, the party can leave the Keep. If it ex-
plores the rest of Throtl, there are more encounters with Priests and Undead.
You can find a cache of jewelry, gems, and steel pieces in the southwest. If
there is a good Thief in the party, he can disarm a trapped door near the
central part of the Keep and the party fights Patriarchs to gain a Wand of Ice
Storm. This is a very hard battle considering what you get, and considering
that the Priests cast Slay Living spells.

CERBERUS

 Although it is not necessary to do the Cerberus and Cerberus Graveyard seg-
ments to complete the game, you may want to do them before fighting Lord Soth 
on level 3 of Dargaard Keep. You are nudged towards them at several spots in 
the game, and if you don't do these quests before facing Lord Soth, they will 
be gone. I only put them in as side quests because they aren't essential to 
winning the game.

 If the party enters the town before the attack in the graveyard, it finds 
some of the citizens in mourning garb. The town is fairly normal, the map is
the same as Dulcimer, the bizarre duplicate created by the Lich. There is a
garden to the west of the entrance and a Farmer's Market to the east. The main 
part of town lies through the arches to north, and contains little of note 
until the attack on Cerberus begins. The town hall, directly to the north, is
vacant as the mayor is recently deceased. The building to the east houses an
inn where the party may stay for free and a tavern where you hear about the
mayor, who was assassinated, and of the funeral to be held in the graveyard.

 To the east of the tavern is an oddities shop whose owner will pay for a rare 
rug. However, I was not able to find a rug anywhere in the game that he would 
buy. In the northwest corner of town is the town cleric's house, and Zakarie 
will tell you about the mayor, and the citizens of Cerberus who were taken to 
Dargaard Keep for servants. The party now should leave Cerberus to attend the 
Mayor's funeral, triggering the attacks on the town and graveyard.

 After banishing the evil from Cerberus Graveyard, you return to the town and 
are attacked by Wights and Spectres upon entering. Zakarie has been kidnaped, 
the town is being pillaged by Undead while the people have fled into town hall 
and barricaded it against the evil forces. The party heads straight for the 
town hall and defeats a group of Zombie Giants to gain entrance. The towns-
people tell you that they need the weapons in the town armory and that only 
Zakarie can open it (Journal Entry 48).

 The cleric is being held in the fortune teller's tent, located in the south-
east corner of the Farmer's Market. Head directly there, fighting random Un-
dead patrols along the way, then defeat the spellcasters to free Zakarie. 
Return him to the town hall and he will release the magical barricade to allow 
the townspeople to arm themselves from the armory in the northeast corner of 
town. You may now go there yourselves and claim what remains: A Mace of Dis-
ruption, Ring of Protection +3, Chain Mail +2, and Gauntlets of Ogre Strength 
which raise a character's strength to 18(00) when worn!

CERBERUS GRAVEYARD

 The funeral for the assassinated mayor of Cerberus is being held here in the 
graveyard. The funeral is interrupted by an Undead attack, triggered by enter-
ing the mausoleum. If the party has entered from the tunnel in Dargaard Keep, 
the attack begins as they exit the building. After you repel the attack and 
secure the graveyard, you return to Cerberus and find it besieged. This is one 
of the game locations where Clerical Turning ability is diminished.

 As you enter the graveyard for the first time, a man gives directions to the 
funeral. You also notice the first of four evil runes that are allowing the 
attackers to pass the fence. Once the attack begins the party must fight 
Undead to exit this gate. Just northeast from the gate, a dog sits at his
master's grave. If you call him, he'll remain with the party until you leave,
and will watch over you while you rest.

 The mausoleum is slightly west from the center of the graveyard, and when you
enter you see the mayor's body twitch. The townspeople will not listen to
your warnings, and the attack on the graveyard begins, starting with the party
fighting the Undead Mayor. With the attack underway, you'll encounter random
groups of Undead as you wander, until you replace the evil runes. In the 
southwest corner is a building where you find the cleric's diary (Journal 
Entry 38) and learn of his concerns about the gravedigger and the protective 
runes.

 The gravedigger is in the northwest corner, to reach his house you must
fight some Undead Rocs to pass through the gate. Once inside, smash the ruby
ring he wears and with the curse lifted he'll tell you about the cleric and
the runes he removed from the fence (Journal Entry 51). Use the shovel he
gives you to recover the runes he buried just outside his door, then follow
the fence around the graveyard and replace the evil runes. With the last rune
replaced, the graveyard will be at peace, and the party should return to the
town of Cerberus. The tunnel entrance into Dargaard Keep is in the northeast
corner of the building in the northeast part of the graveyard and may be 
opened if you have Ariela's key.

 Before you replace the runes, there are two rescues you may do to gain
experience. North five spaces and east once from the entrance the party may
rescue a woman buried alive if it has the shovel or the dog. To the east, a 
mourner is held by Undead, fight them to save him.

DAVE'S CHALLENGE

 After Lord Soth is defeated, the mountains can be passed in the northwest
corner of the map. In the extreme northwest corner of the land lies a buried
temple to Takhisis. When you enter, the spirit of Sir Vansward tells you the 
history of the temple (Journal Entry 45). The only hint I'll give is that a 
thief is really necessary to survive here. Have fun!

COORDINATE LISTINGS

 This section lists most of the locations of encounters and treasures in each 
segment of the game where the coordinate display is available. You shouldn't 
miss anything with this, except in those areas in which the overhead view is 
not available.

GARGATH OUTPOST

The main entrance/exit is at 4,(7,8); the rear exit is at 6,11. The store is 
at 5,6. The Bank/Vault is at 7,5. The Training Hall is at 10,11. The Temple is 
at 6,9. Treasure: Ring of Protection +1 for healing the sick. The Bar is at 
5,9. The inn is at 6,4 (your room is at 7,4). Commander Bertil's office is at 
11,8 on the upper level of the keep. The cemetery is at 11,3. Sir Karl's grave 
is at 9,5. The party encounters the enemy while on patrol at 9,3 or 6,13. The 
party is relieved from patrol duty at 5,8 or 5,7. The party guards 6,8 
(Temple) or 8,10 (Well).

KALAMAN

The main gates are located at (5,6),15. The Whistling Whale Inn is at 4,14 
(your room and ransom note are at 0,15). The Temple of Kal is at 11,15. The 
Training Hall is at 13,8. The party meets Daine and Ariela at 15,3. The party 
fights Sivaks at the entrance to the Dream Pavilion at 2,3. The party meets 
the kidnapers at 6,6. Treasure: Clerical scroll with 3 spells. The party 
fights Ariela in dragon form at 15,0. Treasure: Elixir of Youth. The party 
rescues the young Knight at 0,11. Treasure: Dart of Hornet's Nest. The back 
entrance to the inn is at 0,13.

VINGAARD KEEP

No coordinates available. Treasure: Long Sword +3, Red Mage scroll (after 
the Dragon Pit mission).

HIGH CLERIST'S TOWER

The entrance/exit is at 0,1. The party may rest (except during the attack) at 
3,1. A good place to rest during the attack is at 13,1. Sir Durfey joins the 
party after battling Undead at 11,3. Battles occur at: 14,5; 14,9; 14,13; 
1,10; 5,10; 4,4; 4,7. The entrance into the tunnels is at 1,15.

HIGH CLERIST'S TOWER (TUNNELS)

The party enters from the tower at 1,0. The party first meets Sir Garren and 
the Red Dragon at 1,3. Delaying attacks by Undead occur at 3,7(8) and 8(9),5.
The party fights the Red Dragon at 12,0(1). Another delaying attack at 
14(15),7. Treasure: Short Sword +4, Staff Sling +3. Yet another delaying 
attack occurs at 12,11(12). Treasure: Hoopak +3. The party meets Sir Garren 
again and takes his cursed sword at 7,11(12). Lord Soth confronts the party at 
the exit 5(6),15.

DRAGON PIT

The entrance/exit is located at 15,8. The secret passage is located at 13,2.
Wights convert Sir Bregen into one of their own at 11,0. The party fights Un-
dead at 9,6. Treasure: Plate Mail +3, Shield +2, a White Mage scroll, and a 
Clerical scroll. Undead Dragons guard at 3,6. Spark, a Red Dragon, is chained 
at 2,9(10). The exit, warded against the living is at 15,14(15). A stable for 
Nightmares is at 14,11. Barracks for Skeletal Warriors are at 15,12. The party 
first meets Sir Karl at 4,12. The party finally fights the Dread Wolf at 3,10 
while Sir Karl retreats. Sir Karl and Maya meet, and the party fights the 
Death Dragon at 6,8. Trea sure: Footman's Dragonlance. The Dragon's Lair is at 
11,8. Treasure: Short Bow +3, Leather Armor +3, and Plate Mail +2. The rope 
bridge can be repaired at 12,6 to cross the chasm to 12,4.

DULCIMER

The main entrance/exit is (6,7,8),15. The tavern is at 10,7. The inn is at 
10,5. The stocks are at 6(8),3. The spectre appears as the party approaches 
the door at 15,8 or 7,0. The Lich's guards are at 9,0. The Lich's quarters are 
at 6,0. The Zombie Giants who are gambling are at 14,0. Treasure: Long Sword 
+4, Scroll of Protection against Dragon's Breath, Potion of Invisibility, and 
4 Darts +3. The Lich's phylactery is at 2,13.

VOICE WOODS

Note: You may find the same encounters in locations other than those listed,
especially if you stray from the walkthru. Exit back to Dulcimer is at 0,8.
Encounters with sprites may occur at: 1,8; 0,4; 0,10; 4,7; 10,10 as well as
several other locations. Altars to Paladine are at 4,8 and 7,11. A large group 
of Black Wizards, Wights and Giant Zombies can be found at 8,7. A different 
group of Mages and Undead can be found at 11,4. The party fights Fire Minions 
at 5,9. Whisper Spiders attack at 7,0 and 7,15. Limbs and vines damage the 
party at 9,(6,7,8) 4,4 and numerous other locations. Arches teleport the party 
to different locations: 0,0 to Throtl Keep; 13,0 to Forest north from Dulci-
mer; 13,15 to Turef; 0,15 to West of Turef. Warrior sprites guard at 10,6(8). 
The Hall of Voice Wood is at 12,7.

DARGAARD KEEP: FIRST FLOOR

Drawbridge entrance/exit is at 7(8),15. Tunnel from/to Cerberus graveyard is 
at 8,1. Drawbridge controls are at 7(8),14. The party meets Lenore after the 
ambush at 7(8),13; else, it meets her at 8,2. The party meets the maid and is 
given a key at 7(8),4 or 4(5),13. The door to the servant's quarters is at 
1,9. The party meets the servants at 1,4. The front entrance to the comman-
der's chambers is at 4,3. The commander's closet is at 3,1. The temporary 
prison is at 12,9. The secret passage to the temple begins at 10,2 and ends at 
11,2. The party fights clerics at 11,3 if it didn't wait at 11,2. Treasure at 
13,3: 2-Handed Sword +2. The party hears cries for help at 13,6 coming from a
coffin at 12,7. The party may take stairs up at 14,0 only if it has the Rod of 
Omniscience.

DARGAARD KEEP: SECOND FLOOR

The party enters this level at 8,1 and immediately fights Undead. The port-
cullis at 5,3 is raised by the lever at 1,1. The party may sneak by the 
Vampires at 4,2 to reach 1,1. The party battles the guards holding the clerics 
at 5,5. The portcullis at 2,7 is raised by the lever at 3,3. The party must 
fight Flesh Golems at 3,5 to reach 3,3. The cell at 1,7 and all the cells 
along this hall are safe for resting. The party fights an Undead guard group 
at 5,9. The party finds Sebas Astmoor at 8,7. The cell at 8,9 and the other 
cells on this hall are safe for resting. The party fights to save the Cerberus 
townspeople at 14,2. The tome containing the counterspell is at 13,9. The 
cleric's chamber is at 7,3. Treasure: Plate Mail +4, Necklace of Missiles, 
Wand of Lightning, and a Red Mage scroll. The party fights to rescue the body 
Sturm of Brightblade at 14,13. The stairs up to the third floor of the Keep is 
at 8,14.

DARGAARD KEEP: THIRD FLOOR

No coordinates available.

CURSED VILLAGE

No coordinates available. Treasure: Ring of Protection +2, Olin's Quarter 
Staff, and White Mage Scroll.

FUN HOUSE

No coordinates available. Treasure: Girdle of Giant Strength and a Red Mage 
Scroll.

FATHER OF TREES

No coordinates available. Treasure: Periapt Proof vs. Poison and Boots of 
Speed.

SHIPWRECK

No coordinates available. Treasure: Mace +4, Banded Mail +3, and Long Sword 
+3.

TUREF

The main entrance/exit is located at 10,0; the rear exit is at 8,15. The 
Tavern is at 7,10. The Locksmith is at 7,12. The only completely safe place to 
rest is at 13,7. Skomp spots his boar at 12,13. The party finds the slain boar 
at 9,4 after the fight at 6,5. The dwarf cook is at 13,4. Treasure: Short 
Sword +2 (for giving the boar carcass from 9,4 to the cook). The party meets 
the scholar at 12,1 and returns "Ambush Made Easy" here. The party finds the 
book "Ambush Made Easy" then fights soldiers at 7,1. Treasure: Shield +4. The 
ambushers lie in wait at 8,8. The secret passage that leads behind the ambush 
is entered at 6,9. The party meets the young dwarf's mother at 9,11. Treasure: 
Cloak of Displacement (after rescuing the young dwarf). The party finds the 
dwarf in the purple hat at 2,1. Sentries are posted at 9,10 and 10,14. The 
magistrate is held at 4,9. Evil forces await at 4,4. The party battles sol-
diers followed by a trio of Blue Dragons at 6,5.

KUO-TOA SLAVE SHIP

The party begins this quest inside a cell at 1,15. The slaves meet at 4,14. 
The party fights Kuo-Toa at 4,11 then at 0,9. Treasure: Chain Mail +4, Long 
Bow +3, and 10 Arrows +3 after the fight at 0,9. The galley is at 0,4 and the 
pantry is at 1,1. Kuo-Toa dining rooms are at 6,2 and 6,7. The party inter-
rupts the human sacrifice in the temple at 8,13. After the battle at 8,13 the 
doors at 8,12 and 10,14 are ablaze. The party fights Kuo-Toa at 10,3 and 12,4 
to reach 14,5. The burning closet is at 14,5. Treasure: Mace +4. The party 
battles the fleeing Kuo-Toa at 11,(6,7,8). The party dives from the burning 
ship at 15,(6,7,8).

QUAZLE

The entrance/exit is located at 0,14. The Medical Guild is at 7,14. The 
Military Planning and Weapons Guild is at 10,13. The Education Guild is at 
12,13. The Sage Gnome Guild is at 6,2. The Hall of Technological Innovation is 
at 13,9. The party destroys the machine in the Mechanical Engineering Guild at 
1,9. Poisonous gas clouds are at: 0,3; 1,3; 2,3. The party fights the Evil 
Mage at 0,1. Treasure: Potion of Speed, Potion of Healing, and Eyes of 
Charming.

CEKOS

The entrance/exit is located at (7,8),15. The party may rest at 2,3. The Inn 
is at 14,10. The Tavern is at 14,7. The shop is at 11,9. The party meets the 
old woman at 7,13. Treasure: Quarter Staff +2; Gems when party returns with 
daughter. The statue of Cekos speaks to the party at 8,8 (at night). Treasure: 
White Mage scroll with 3 8th level spells. The party encounters the Wizard at 
2,14. The party meets Igorf at 7,5. The servant is found in the kitchen at 
6,10 (during the day). The vagabond is found at 11,6. The Sivak mayor is at 
6,7. The prisoners are held at 2,8. The party must fight Sivaks at (10,11),4 
and 11,1. It finds the key at 11,1. The secret entrance to the Dragon's Lair 
is at 4,7. No coordinates are available for the Dragon's lair. Treasure: Wand 
of Paralyzation.

THROTL KEEP

The entrance/exit is located at 7,15. The party encounters Undead Dragons at 
11,14 and 0,5. The Throtl Vault is located at 14,13. Treasure: Composite Long 
Bow +2 and 10 Arrows +2. Skeletal Warriors and Zombie Minotaurs attack at:
13,12; 14,15; 14,9; 2,3. Evil Priests and Zombie Minotaurs guard at 10,12. The 
party battles "The Beast Master" and Undead at 9,11. Secret passage at 8,12 
leads to the hall at 7,12. The party fights a large force of Priests and 
Undead at 7,9. Sarah, Priestess of Mishakal, meets the party at 5,1. A large 
patrol of Priests and Undead guard at 3,1. Lesster and his army await at 4,2.
The party fights Skeletal Warriors and Nightmares in the stable at 2,15. Many 
Priests ambush the party through a trapped door at 5,9 (very tough). Treasure: 
Wand of Ice Storm. Skeletal Warriors and Undead guard the hall at 1,11. The 
party fights Priests and Undead at 1,10 for much jewelry, gems and money.

CERBERUS

The entrance/exit is located at (6,7,8),15. 

Before the attack: The tavern is at 10,7. The Inn is at 10,5. The oddities 
shop is at 14,6. The party meets Zakarie at 2,0.

During the attack: The party battles Undead to enter the town at (6,7,8),15.
Spectres attack at 10,5. The party must defeat Giant Zombies at 7,5 to enter 
Town Hall. The party meets the townspeople in Town Hall at 7,4. Zakarie is 
being held by the Fortune Teller at 15,15 (you must reach 7,4 first). The 
party enters the armory at 14,0 after returning Zakarie to Town Hall (7,4). 
Treasure: Chain Mail +2, Ring of Protection +3, Mace of Disruption, and 
Gauntlets of Ogre Strength.

CERBERUS GRAVEYARD

The main entrance/exit is located at 8,15. The party finds the dog sitting on 
it's master's grave at 10,13. The cleric's diary is found at 0,15. The mayor's 
funeral is at 5,7. Undead creatures attack at 4,1 and 11,1. The gravedigger is 
at 1,1; the party finds his shovel. The four good runes are buried at 2,1.
The four evil runes are at: 8,13; 0,7; 8,0; 15,7. The party may rescue the 
girl buried alive at 9,9 if it has the shovel or dog. The party fights Undead 
to rescue a mourner at 12,10. The tunnel entrance to Dargaard Keep is at 15,0.

DEATH KNIGHTS OF KRYNN is published by Strategic Simulations, Incorporated.



