***************************************
*				      *
*     KRAKOWICZ'S KRACKING KORNER     *
*				      *
*      THE BASICS OF KRACKING I:      *
*				      *
*      ROMS AND PROMS AND  F8'S       *
*				      *
***************************************

  ALONG WITH A NUMBER OF REQUESTS FOR MATERIAL USEFUL TO THOSE WHO ARE NOT YET
IN THE RANKS OF PROFESSIONALS IN THIS FIELD, IT HAS BEEN POINTED OUT TO ME THAT
I AM ALL TOO WILLING TO SUGGEST BURNING THIS PROM, INSTALLING THAT ROM, AND
GENERALLY MAKING WHOLESALE HARDWARE CHANGES IN AN UNSUSPECTING APPLE, WITHOUT
PROVIDING BACKGROUND INFORMATION FOR THE UP-AND-COMING KRACKISTS OF THE FUTURE.

  THIS SERIES, WHILE AIMED AT THE BEGINNING TO INTERMEDIATE KRACKIST, WILL STILL
ASSUME A REASONABLE KNOWLEDGE OF ASSEMBLY LANGUAGE.  IF YOU FIND THESE
DISCUSSIONS ARE STILL TOO HEAVY INTO MACHINE CODE FOR YOU, THEN IT'S BEST TO BUY
A BOOK LIKE ROGER WAGNER'S "ASSEMBLY LINES" OR EQUIVALENT, AND STUDY IT
CAREFULLY (IF, ON THE OTHER HAND, YOU FIND THAT THIS IS ALL BENEATH YOU, JUST
KEEP A KNOWING SMIRK ON YOUR LIPS AS YOU SKIP LIGHTLY OVER THESE EPISODES -
THERE MIGHT BE SOMETHING YOU MISSED BECAUSE YOU HAD A BAD HANGOVER ONE DAY IN
KRACKING 101).

  IN THIS AND FUTURE EPISODES IN THE 'BASICS OF KRACKING' SERIES, WE'LL DEAL
WITH THE FUNDAMENTALS OF THE KRACKIST'S ART, STARTING WITH THE HOW (AND WHY) OF
MAKING ALTERATIONS IN THE APPLE'S "PERMANENT" MEMORY.  FIRST OF ALL, THE MOST
IMPORTANT SINGLE TOOL AVAILABLE TO THE ASPIRING KRACKIST IS REPLACING THE
AUTOSTART ROM ON THE MOTHER BOARD WITH AN "OLD MONITOR" ROM.  WITH THIS ROM IN
PLACE, YOU CAN HIT 'RESET' WHENEVER YOU WANT, AND ALWAYS BE RETURNED TO THE
MONITOR FOR THE BEGINNING OF THE SNOOPING PROCESS.  THIS CHANGE, INCIDENTALLY,
WILL MAKE AVAILABLE TO YOU A REASONABLE SET OF "STEP AND TRACE" UTILITIES (SEE
THE APPLE II REFERENCE MANUAL.	PP 51-53).

  TO UNDERSTAND WHAT THE DIFFERENCES ARE BETWEEN THE TWO ROMS, LET'S TAKE A
MINUTE TO EXAMINE WHAT PRESSING THE 'RESET' KEY DOES (OMIGOSH, MAUDE, THERE HE
GOES AGAIN ON THAT DETAILED TECHNICAL CRAP!).  INSTEAD OF GOING THROUGH THE
KEYBOARD INPUT ROUTINE AT C000, THE RESET KEY IS CONNECTED DIRECTLY TO PIN 40 OF
THE 6502 MICROPROCESSOR CHIP.  WHEN THIS PIN IS CONNECTED TO GROUND (0 VOLTS),
THE COMPUTER JUMPS UNCONDITIONALLY TO THE ADDRESS CONTAINED IN LOCATIONS FFFC
AND FFFD.  THIS IS NOT A TRUE INTERRUPT, SINCE THE APPLE FORGETS WHAT IT WAS
DOING BEFORE THE LINE WAS "YANKED", BUT IT IS AN EXAMPLE OF 'VECTORING' OR
SENDING THE COMPUTER TO A SPECIFIC PLACE BY SETTING AN ADDRESS INTO THE PROGRAM
COUNTER.  IN THE AUTOSTART ROM, THESE TWO LOCATIONS CONTAIN 62 FA, SO THE NEXT
INSTRUCTION TO BE EXECUTED IS AT FA62.	THIS SERIES OF ROUTINES (SEE P.  143 AND
PP.  36-38 OF THE REFERENCE MANUAL) CHECKS TO SEE IF THE COMPUTER IS BEING
POWERED UP FOR THE FIRST TIME (COLDSTART) OR RESET WITH THE POWER ON
(WARMSTART).  IF IT IS A WARMSTART, THE SYSTEM JUMPS TO THE INSTRUCTIONS AT
LOCATIONS 3F2 AND 3F3, AND BEGINS RUNNING THE PROGRAM FOUND THERE (USUALLY BASIC
AT E000).

  THE "OLD MONITOR" ROM, HOWEVER, HAS 59 FF STORED IN FFFC-D.  THIS CAUSES AN
APPLE II (OR A II+ WITH AN INTEGER CARD AND THE RED SWITCH "UP") TO GO TO
ROUTINES WHICH SET UP THE KEYBOARD FOR INPUT, THE TV FOR OUTPUT, AND WIND UP IN
THE MONITOR WITH THE '*' PROMPT DISPLAYED.  IN CONTRAST TO THE AUTOSTART ROM,
WHERE ANYONE CAN TELL THE RESET BUTTON WHERE TO GO, THERE IS NO WAY TO PREVENT A
RESET FROM GOING TO FF59 AND WINDING UP IN THE MONITOR.  THIS IS OBVIOUSLY
ESSENTIAL IF YOU WANT TO BREAK INTO A GAME AND START EXAMINING THE CODE, BUT IT
HAS ITS OWN SET OF PROBLEMS.

  IN THE PROCESS OF SETTING UP THE I/O DESCRIBED ABOVE, ESPECIALLY IN SETTING UP
THE TEXT WINDOW ON THE SCREEN, A NUMBER OF LOCATIONS IN ZERO PAGE MUST BE
CHANGED.  THE FOLLOWING LOCATIONS WILL PROBABLY BE ALTERED (ALL HEX):
20,21,22,23,24,25,28,29,32,33,35, 36,37,38,39, AND 48.	WORSE THAN THAT, THE
ENTIRE SCREEN SCROLLS UP ONE LINE WHEN THE MONITOR PROMPT IS PRINTED, WHICH
LOSES THE ENTIRE TOP ROW OF THE TEXT SCREEN (LOCATIONS 400-427), AND ALTERS THE
CONTENTS OF ALL THE OTHER LOCATIONS FROM 400-7FF, WITH THE EXCEPTION OF THE
"SCRATCHPAD" REGIONS AT 478-47F, 4F8-4FF, ETC.  (THE COMPUTER WIMP AT YOUR
SCHOOL SAYS THAT THE TOP LINE "FALLS INTO THE BIT BUCKET", BUT YOU KNOW HOW
EVERYONE FEELS ABOUT HIM.)

  AS MOST SOFTWARE PROTECTORS KNOW, THIS WILL KEEP MOST OF THE AMATEURS OUT OF
THE PROGRAM, AND YOU'LL SEE EVIDENCE OF THIS TECHNIQUE IN THE FORM OF A LOT OF
"GARBAGE" ON THE TEXT SCREEN WHEN YOU RESET OUT OF A PROTECTED GAME.  OUR JOB,
THEN, IS TO KEEP THESE ZERO PAGE AND SCREEN MEMORY LOCATIONS FROM BEING LOST,
SINCE MOST PROTECTION SCHEMES USE THESE AREAS IN SOME WAY OR OTHER (BR0DERBUND,
FOR EXAMPLE, HAS RECENTLY BEEN STORING THE ADDRESS MARKER FOR THE DISK TRACK IN
LOCATIONS 20, 21, AND 22).

  THE SAFE WAY TO PREVENT INFORMATION FROM BEING LOST FROM THESE "VOLATILE"
LOCATIONS IS TO TRANSFER ALL OF THE CONTENTS TO A SAFE AREA -- LOCATIONS 2000 &
UP (OR 4000 & UP) WHERE A HI-RES PICTURE NORMALLY RESIDES.  IN FACT, IT WOULD BE
BEST TO SAVE EVERYTHING FROM 0 TO 8FF, SINCE BOOTING A DISKETTE TO SAVE THE DATA
ALSO DESTROYS LOCATIONS 800-8FF.  (REMEMBER THE FIRST LAW OF DISK KRACKING -
TRACK 0, SECTOR 0 ALWAYS STARTS WITH D5 AA 96 AND ALWAYS LOADS INTO 800-8FF).
BECAUSE THIS IS THE BEGINNING CLASS, LET'S LOOK AT TWO EXAMPLES OF SHORT BINARY
SUBROUTINES THAT WILL DO THE "SAVE" FOR US.  BOTH START, AS WILL BE EXPLAINED
LATER, AT LOCATION FECD IN THE F8 ROM.	THE FIRST IS THE MOST STRAIGHTFORWARD
AND EASIST TO FOLLOW:


  LDY  #$00    ;CLEAR Y-REGISTER
  LDA  $00,Y   ;GET A BYTE FROM 0+Y
  STA  $2000,Y ;STORE AT 2000+Y
  LDA  $0100,Y ;THEN FROM 100+Y
  STA  $2100,Y ;TO 2100+Y
  LDA  $0200,Y ;AND SO ON UNTIL
  STA  $2200,Y ;WE HAVE COVERED
  LDA  $0300,Y ;ALL THE MEMORY
  STA  $2300,Y ;'PAGES' FROM 0 TO 8
  LDA  $0400,Y ;AND STORED INTO
  STA  $2400,Y ;PAGES 20 TO 28
  LDA  $0500,Y
  STA  $2500,Y
  LDA  $0600,Y
  LDA  $2600,Y
  LDA  $0700,Y
  STA  $2700,Y
  LDA  $0800,Y
  STA  $2800,Y
  INY	       ;THEN ADD 1 TO Y-REG
  BNE  $FED0   ;AND REPEAT IF < 256
  JMP  $FF59   ;WHEN WE'RE ALL DONE
	       ;JUMP TO MONITOR START

  THIS 61-BYTE ROUTINE, IF IT COULD BE EXECUTED AUTOMATICALLY WHEN THE RESET KEY
IS PRESSED, WOULD SAFELY STASH ALL OF THE CHANGEABLE MEMORY AND EXIT GRACEFULLY
INTO THE MONITOR.

  A MORE COMPACT AND GENERAL, BUT LESS OBVIOUS ROUTINE IS SHOWN BELOW.	IT IS
INCLUDED BECAUSE IT IS TYPICAL OF THE "MEMORY MOVE PROGRAMS" THAT WE WILL
EVENTUALLY HAVE TO WRITE IN KRACKING ALMOST ANY PROGRAM.

  LDY  #$00    ;CLEAR Y-REGISTER
  LDA  $00,Y   ;XFER THE ZERO PAGE TO
  STA  $2000,Y ;2000-20FF SO WE CAN USE
  INY	       ;THE ZERO PAGE MEMORY
  BNE  $FED0   ;FOR THE OTHER MOVES
  LDA  #$00    ;SET UP LOCNS 0 & 1 AS A
  STA  $00     ;2-BYTE POINTER FOR THE
  STA  $02     ;SOURCE ADDRESS, USE 2&3
  LDA  #$01    ;AS 2-BYTE POINTER FOR
  STA  $01     ;THE DESTINATION ADDRESS
  LDA  #$21    ;STARTING AT $2100
  STA  $03
  LDA  ($00)<- ;GET A BYTE FROM 100-UP
  STA  ($02) ^ ;STORE AT 2100-UP
  INC  $02   ^ ;INCREMENT LO-ORDER BYTE
  INC  $00   ^ ;OF SOURCE & DESTINATION
  BNE  ->->->^ ;(BACK TO LDA ($00) IF
	     ^ ;LO-ORDER IS <256
  INC  $03   ^ ;IF LO-ORDER=0, INC THE
  INC  $01   ^ ;HI BYTE OF EACH
  LDA  $01   ^ ;CHECK TO SEE IF HI-BYTE
  CMP  $#09  ^ ;IS 9 -WE'RE THRU AT 8FF
  BNE  ->->->^ ;IF NOT, LOOP BACK TO
	       ;THE LOAD/STORE UNTIL
	       ;WE'RE ALL DONE
  JMP  $FF59   ;EXIT THRU MONITOR

  UNLIKE THE FIRST ROUTINE, THIS ONE (AT 47 BYTES) USES RAM LOCATIONS 0 THROUGH
3, SO THE ZERO PAGE MUST BE TRANSFERRED BEFORE IT IS ALTERED BY USING THOSE
ADDRESSES AS POINTERS.	WHILE THE FIRST ROUTINE MUST GROW BY SIX BYTES FOR EACH
ADDITIONAL PAGE TRANSFERRED, THE SECOND NEEDS ONLY TO HAVE THE "9" IN THE
COMPARE STATEMENT CHANGED TO THE APPROPRIATE VALUE ONE HIGHER THAN THE LAST PAGE
NUMBER BEING TRANSFERRED.

  TO RETURN TO THE BUSINESS OF ALTERING ROMS, IT IS EASY TO SEE THAT AN
AUTOSTART ROM COULD BE MADE TO BEHAVE LIKE AN OLD ROM JUST BY CHANGING LOCATIONS
FFFC-D TO 59 FF FROM 62 FA.  (A NOTE TO THE FAINT-HEARTED--YOU CAN BUY AN OLD
MONITOR F8 ROM FOR ABOUT $10 AND PLUG IT DIRECTLY INTO YOU APPLE'S F8 SOCKET,
BUT YOU WON'T HAVE ALL THE BENEFITS WE'VE BEEN TALKING ABOUT).  AS LONG AS WE'RE
GOING TO THE EFFORT OF MAKING A CHANGE, THOUGH, WE MIGHT AS WELL ADD ONE OF THE
ROUTINES ABOVE AND ALLOW THE NEW ROM TO SAVE THE VOLATILE MEMORY FOR US.  TO DO
THIS, WE'LL HAVE TO GIVE UP SOMETHING IN THE ROM, AND THE MOST EASILY
SURRENDERED AREA FOR MOST OF US IS THE TAPE READ/SAVE ROUTINES AT $FECD.  IF WE
THEN CHANGED FFFC-D TO CD FE, THE MEMORY FROM 0 TO 8FF WOULD BE SAVED TO
2000-28FF EVERY TIME THE 'RESET' KEY WAS PRESSED.  SINCE IT'S SOMETIMES
INCONVENIENT TO HAVE THAT HAPPEN WHEN THE RESET KEY IS PRESSED, WE CAN REQUIRE
THAT A SPECIFIC KEY BE ALSO PRESSED TO MAKE IT OCCUR.  THESE FEW INSTRUCTIONS
INSERTED BEFORE EITHER OF THE ROUTINES ABOVE WILL GIVE A "RESET AND SAVE" WHEN
THE "-" KEY IS HELD DOWN (OR WAS THE LAST KEY PRESSED), WHILE GIVING A REGULAR
"OLD RESET" THE REST OF THE TIME.

  LDA  $C000  ;LOOK AT THE KEYBOARD
  ROL	      ;MASK OFF HIGH BIT
  CMP  #$5A   ;WAS IT "-"?($2D X 2=$5A)
  BNE  ->->-> ;IF NOT, BRANCH TO THE
	    ! ;LOCATION WITH THE
	    ! ;"JUMP FF59" INSTRUCTION
	    ! ;AT THE END OF THE SAVE
	    ! ;SUBROUTINE.


  OK, OK - WE ALL AGREE THAT THESE WOULD BE NEAT THINGS TO HAVE IN THE F8 ROM,
SO HOW DO WE GET IT THERE?  FIRST, GET HOLD OF A PROMBURNER (PROMBLASTER, EPROM
PROGRAMMER, ETC.) THAT WILL PROGRAM 2716 EPROMS.  EACH ONE IS DIFFERENT, SO I
WON'T TRY TO GIVE DETAILED INSTRUCTIONS ON THE ACTUAL PROGRAMMING.  BUY OR
BORROW A FRIEND'S OLD F8 ROM (OR GET THE BINARY FILE) THEN TYPE IN OR LOAD IN
THE CHANGES YOU WANT TO MAKE AT FECD & UP AND AT FFFC-D, AND PROGRAM A 2716
EPROM WITH OUR MODIFIED VERSION OF APPLE'S F8 MONITOR ROM.

  ALL THAT REMAINS TO TAKE FULL ADVANTAGE OF THE NEW F8 ROM IS TO MAKE A
SLIGHTLY MODIFIED SOCKET AND PLUG IT IN.  BOTH THE 2716 AND THE ORIGINAL 9316
ROM USED BY APPLE ARE READ-ONLY-MEMORY DEVICES HOLDING 2K BY 8 BITS OF
INFORMATION ("16K" ROMS), BUT THE PINOUT, OR ASSIGNMENT OF CHIP FUNCTIONS TO PIN
NUMBERS IS SLIGHTLY DIFFERENT.	TO USE THE 2716 IN A BOARD DESIGNED FOR A 9316,
YOU NEED TO TIE PIN 21 TO 5 VOLTS (PIN 24) AND TIE PIN 18 TO GROUND (PIN 12).
YOU COULD MODIFY THE PROM ITSELF, BUT YOU'RE LIABLE TO RUIN THE CHIP, AND IT
CREATES A REAL MAGILLA IF YOU NEED TO REPROGRAM IT.  (A ROM CARD, SUCH AS AN
INTEGER CARD, CAN BE USED FOR 2716'S IF TWO JUMPERS ARE CONNECTED AT THE TOP OF
THE CARD, AND ->ONLY<- 2716'S ARE USED IN ALL OF ITS SOCKETS AFTER THAT).

  GET A 24-PIN, PREFERABLY LOW-PROFILE IC SOCKET, AND ORIENT IT WITH THE PINS UP
AND THE NOTCH INDICATING THE 'PIN ONE' END TO THE RIGHT.  IT SHOULD LOOK LIKE:

---------------------------------------
!  13 14 15 16 17 18 19 20 21 22 23 24!
! ./ ./ ./ ./ ./ ./ ./ ./ ./ ./ ./ ./ !
!				      !
!				      !
!				     /
!			   (NOTCH)->!
!				     \
!				      !
! .  .	.  .  .  .  .  .  .  .	.  .  !
!/  /  /  /  /	/  /  /  /  /  /  /   !
!12 11 10 9  8	7  6  5  4  3  2  1   !
---------------------------------------

  USING A LOW-WATTAGE SOLDERING IRON, SOLDER A SHORT PIECE OF 26-30 GAUGE WIRE
BETWEEN PINS 21 AND 24, AND ANOTHER ONE BETWEEN PINS 12 AND 18.  MAKE THE
CONNECTION AS CLOSE TO THE SOCKET AS POSSIBLE, AND TRY TO AVOID GETTING ANY
SOLDER ON THE ENDS OF PINS 12 AND 24.  CUT OFF PINS 21 AND 18, AGAIN AS CLOSE AS
POSSIBLE TO THE SOCKET.  (PLUGGING ANOTHER SOCKET INTO THE ONE BEING MODIFIED
WILL HELP TO PREVENT DISTORTION DURING THE SURGERY).  THE SOCKET NOW LOOKS LIKE:

---------------------------------------
!  13 14 15 16 17 18 19 20 21 22 23 24!
! ./ ./ ./ ./ ./  / ./ ./  / ./ ./ ./ !
!		  X	   X	   /  !
!		 /	  /	  /   !
!		/	 /-------/   /
!    /---------/		    !
!   /				     \
!  /				      !
! /  .	.  .  .  .  .  .  .  .	.  .  !
!/  /  /  /  /	/  /  /  /  /  /  /   !
!12 11 10 9  8	7  6  5  4  3  2  1   !
---------------------------------------

	       X=NO PIN

  DOUBLE CHECK THE CONNECTIONS ON THE BOTTOM OF THE SOCKET, AND PLUG THE 2716
INTO THE SOCKET, BEING CAREFUL TO MATCH THE NOTCHED END OF THE CHIP TO THE
SOCKET.  MAKE SURE THAT THE POWER TO THE APPLE IS TURNED OFF, AND PLUG THE
ASSEMBLY INTO THE F8 SOCKET ON THE MOTHER BOARD WITH THE NOTCH TOWARD THE FRONT
(KEYBOARD) END OF THE APPLE.  CROSS YOUR FINGERS AND TURN ON THE APPLE.  IF
THERE IS NO FAMILIAR "BEEP", OR IF THE TV SCREEN STAYS WHITE, OR IF THE SYSTEM
DOESN'T RESPOND TO THE RESET KEY, TURN OFF THE POWER AND EXAMINE THE CHIP AND
SOCKET CAREFULLY TO FIND THE ERROR.  IF BLACK CLOUDS OF SMOKE ROLL OUT FROM THE
APPLE, FORGET WHERE YOU READ THIS.  ACTUALLY, THE MOST COMMON MISTAKE OF
INSERTING THE CHIP BACKWARDS IS SELDOM HARMFUL TO IT, BUT DOES LOCK UP THE
APPLE'S BUS.  REMEMBER THAT BOTH THE 2716 AND THE 9316 THAT YOU REMOVED CAN BE
DAMAGED BY STATIC ELECTRICITY, SO HANDLE WITH CARE AND DON'T SCUFF YOUR FEET ON
THE CAT.

---------------------------------------

***************************************
*				      *
*     KRAKOWICZ'S KRACKING KORNER     *
*				      *
*      THE BASICS OF KRACKING II      *
*				      *
*     SINGLE-LOAD GAMES, STARTING     *
*     LOCATIONS, AND OBFUSCATION.     *
*				      *
***************************************


  THE FIRST IN THIS SERIES WAS STRAIGHTFORWARD, SINCE THE HARDWARE RESET IS A
NECESSITY TO BEGIN KRACKING.  AFTER THAT, THE PATH DIVIDES, AND THERE ARE MANY
MANY WAYS TO PRODUCING AN UNPROTECTED VERSION OF A PROGRAM.  THE PATH YOU FOLLOW
IS GOVERNED BY THREE THINGS:  THE KIND OF PROGRAM, THE TYPE OF PROTECTION
EMPLOYED, AND YOUR OWN PERSONAL STYLE (STYLE, BY THE WAY, IS PRIMARILY THE
RESULT OF LIMITATIONS.	TRY TO KEEP AN OPEN MIND AND DEVELOP AS MUCH VERSATILITY
AS POSSIBLE).  THE EASIEST KIND OF PROGRAM TO DEAL WITH IS THE ONE THAT IS SEEN
LESS FREQUENTLY EVERY MONTH:  THE "SINGLE-LOAD" PROGRAM OR GAME.  THESE ARE
PROGRAMS WHICH ARE LOADED IN FROM DISK ONLY ONCE, AND THEN ARE RUN STRICTLY FROM
MEMORY WITH NO DISK ACCESS.  IN THE GOOD OLD DAYS, ALMOST EVERY GAME WAS LIKE
THIS, AND REMOVING PROTECTION WAS NOT THAT DIFFICULT.  ON THE OTHER HAND, WHEN
YOU READ SOMETHING LIKE OLAF LUBECK'S CHALLENGE IN TRACK 17, SECTOR D OF
CANNONBALL BLITZ:  "YOU'LL NEVER CRACK IT", THERE'S MORE SATISFACTION WHEN YOU
GET TO SAY "OH, YES I DID!".

  IN ORDER TO BECOME PROFICIENT AT THIS AND THE TECHNIQUES TO BE DISCUSSED IN
FUTURE EPISODES, YOU WILL HAVE TO GET USED TO COMMITTING A VERY UNNATURAL ACT:
INTERPRETING ASSEMBLER CODE WITH NO COMMENTS OR INSTRUCTIONS TO GUIDE YOU.  THE
DISASSEMBLER (MONITOR 'L' COMMAND) IS A GREAT HELP IN THIS WORK, SINCE IT
TRANSLATES MACHINE CODE INTO ASSEMBLER MNENONICS, BUT THE REAL BURDEN FALLS ON
THE INGENUITY OF THE KRACKIST.	THERE IS NO SUBSTITUTE FOR EXPERIENCE, AND NO
ONE CAN TEACH YOU HOW TO DO IT BEYOND POINTING OUT SOME OF THE TECHNIQUES WE
USE, AND WARNING YOU ABOUT SOME OF THE TRICKS USED TO KEEP YOU FROM SUCCEEDING.

  THE PHILOSOPHY OF ATTACK WITH THESE GAMES IS TO FIND THE STARTING
LOCATION--THE ADDRESS WHICH WILL ALWAYS RESTART THE GAME, AND THEN TO SAVE THE
GAME (PROGRAM) AS A NORMAL DOS 3.3 BINARY FILE.  AS A SIMPLE EXAMPLE OF A
STARTING LOCATION, YOU PROBABLY ALREADY KNOW THAT WHEN YOU MESS UP WITH APPLE'S
"FID" PROGRAM, YOU CAN RESTART BY TYPING '803G' FROM THE MONITOR.  AT ONE TIME,
BEFORE THE PUBLISHERS GOT SMART, A STARTING LOCATION WAS LIKELY TO BE A COMMON,
EVEN NUMBER LIKE $800, C00, 4000, OR 6000, AND IT'S STILL WORTH CHECKING THESE
'OLD FAVORITES' IN CASE YOU FIND A NAIVE OR LAZY AUTHOR.  IF THESE FAIL, WE WILL
HAVE TO BEGIN THE PROCESS OF MEMORY SNOOPING.  THIS IS THE INTRODUCTION TO THE
UNGLAMOROUS ACTIVITY THAT OCCUPIES MOST OF THE TIME OF THE DEDICATED KRACKIST.
AS ALWAYS, INSPECTOR AND WATSON IN ROM ARE HIGHLY RECOMMENDED, SINCE THEY MAKE
THE PROCESS INFINITELY EASIER.	WHAT WE ARE TRYING TO DO IS DIRECTLY LOCATE THE
BEGINNING ADDRESS OF THE PROGRAM, OR TO SEARCH BACK TO IT FROM SOMETHING WE CAN
RECOGNIZE.

  SINCE MANY GAMES BEGIN BY DISPLAYING A HI-RES "BANNER" OR GAME SCREEN, A GOOD
PLACE TO START LOOKING IS THE SERIES OF INSTRUCTIONS THAT SET UP THE HI-RES
SCREEN (THERE IS A DISCUSSION OF THIS IN THE DOC FOR MASTERKEY PLUS, BUT THEY
MAKE A FEW TOO MANY ASSUMPTIONS).  APPLE'S SCREEN DISPLAY, AS YOU PROBABLY KNOW,
IS SET UP BY ACCESSING SOME "SOFT SWITCHES".  IN HEX, THESE ARE LOCATIONS $C050
TO C057 (SORRY, BUT IF YOU'RE GOING TO LEARN THE GENTLE ART OF KRACKING, YOU'LL
HAVE TO BECOME FLUENT IN HEXADECIMAL--WE WON'T PULL ANY PUNCHES WHEN IT COMES TO
NUMBER SYSTEMS).  IT DOESN'T MATTER WHAT YOU DO TO THESE LOCATIONS, AS LONG AS
YOU MAKE A REFERENCE, SO THE FOLLOWING INSTRUCTIONS ALL ESTABLISH GRAPHICS MODE:


   LDA $C050,	BIT $C050,   ROL $C050
   STA $C050,	CMP $C050,   EOR $C050


(ALSO, THIS ONE: LDY #$71; AND $BFAF,Y)

  MANY AUTHORS HAVE ESTABLISHED THE HABIT, HOWEVER, OF WRITING THE SEQUENCE

   LDA $C054   (SELECT PRIMARY PAGE)
   LDA $C057   (SELECT HI-RES GRAPHICS)
   LDA $C050   (SELECT GRAPHICS MODE)

AND SOMETIMES,

   LDA $C052   (PURE GRAPHICS SCREEN).

  TO FIND THESE INSTRUCTIONS, USE THE INSPECTOR'S 'FIND' FUNCTION, AND PROGRAM
IT TO SEARCH FOR THE TWO-BYTE SEQUENCES OF '50 C0' AND '57 C0'.  GENERALLY, AS
LONG AS THE WRITERS AREN'T DELIBERATELY TRYING TO CONFUSE YOU, YOU WILL FIND ONE
TO SEVERAL LOCATIONS WHERE THESE SEQUENCES ARE CLOSE TO EACH OTHER.  YOU WILL
ALSO FIND SOME ADDRESSES THAT DON'T REALLY CONTAIN A SCREEN REFERENCE, SINCE THE
SEARCH IS ONLY FOR TWO BYTES (FOR YOU TRIVIA/ STATISTICS BUFFS OUT THERE, A
GIVEN TWO-BYTE SEQUENCE WOULD OCCUR LESS THAT ONCE IN THE ENTIRE RAM MEMORY
SPACE FROM 0 TO $BFFF IF THE DISTRIBUTION WERE TRULY RANDOM.  IT'S NOT.).

  TO SEE IF EACH OCCURANCE OF THE PATTERN IS THE STARTING LOCATION, LOOK
BACKWARDS UNTIL YOU FIND AN ABSOLUTE END FOR THE PREVIOUS SUBROUTINE SUCH AS
'RTS' OR 'JMP'.  YOUR SUBROUTINE SHOULD BEGIN IMMEDIATELY AFTER THAT, AND YOU
SHOULD ASSUME FOR THE MOMENT THAT IT'S THE STARTING LOCATION.  IF, FOR EXAMPLE,
THE LOCATION YOU FOUND IS $4123, TEST IT BY RELOADING THE GAME, RESETTING IT,
AND TYPING '4123G'.  IF IT RUNS, SIT BACK AND GLOAT, OTHERWISE READ ON (IT
SOUNDS UNNECESSARY TO RELOAD, BUT THE INSPECTOR USES A FEW LOCATIONS IN PAGES 0,
2, AND 3, SO IT'S BEST TO BE SAFE).  IF MURPHY'S LAW OF DYNAMIC NEGATIVES IS
WITH YOU AND THE GAME DIDN'T START, IT'S USUALLY BECAUSE YOU HAVEN'T FOUND THE
TRUE STARTING LOCATION.  YOU THEN NEED TO TRACE BACK FURTHER IN THE PROGRAM
SEQUENCE TO FIND THE REAL START.

  THERE ARE THREE WAYS FOR ANOTHER ROUTINE TO GET TO THE ONE YOU'RE LOOKING AT:
JMP, JSR, AND THE FAMILY OF BRANCH INSTRUCTIONS.  TO ELIMINATE THE THIRD
POSSIBILITY, KEEP IN MIND THAT BRANCHES CAN REACH UP TO $7F (127) LOCATIONS AWAY
FROM EITHER DIRECTION.	THIS IS EQUAL TO ABOUT 60 INSTRUCTIONS, SO YOU SHOULD
REVIEW ABOUT ONE FULL PAGE OF DISASSEMBLY PRINTOUT (THREE SCREENSFUL) BEFORE AND
RARELY AFTER WHAT LOOKED LIKE A POSSIBLE START.  IF YOU FIND A 'BNE 4123', OR
'BCC 4123', ETC., YOU WILL HAVE TO TRACK BACK TO THE BEGINNING OF THAT ROUTINE
AND TRY AGAIN.	REPEAT THIS PROCESS UNTIL YOU FIND A LOCATION THAT CAN ONLY BE
REACHED BY A JMP OR JSR.

  TO FIND OUT HOW THE PROGRAM GOT TO THIS LOCATION, DO A 3-BYTE SEARCH WITH THE
INSPECTOR FOR A JSR $4123:  20 23 41.  IF NOTHING SHOWS UP, TRY THE JMP $4123:
4C 23 41.  ONE OF THESE MUST PRODUCE A REFERENCE, OR YOU MESSED UP THE EARLIER
CHECK FOR BRANCHES.  ONCE YOU FIND THE EARLIER REFERENCE, GO THROUGH THE SAME
PROCEDURE TO FIND THE START OF THIS ROUTINE, AND TRY IT OUT AS A STARTING
LOCATION FOR THE GAME.	IF IT DOESN'T WORK, TRY ONE MORE STEP FURTHER BACK
(KRAKOWICZ'S FOURTH LAW OF KRACKING SAYS THAT IF YOU HAVE TO GO BACK MORE THAN
TWO STEPS, YOU'RE PROBABLY NOT ON THE RIGHT TRAIL).

  A NUMBER OF GAMES STILL DO US THE FAVOR OF PUTTING UP A SCREEN, PERHAPS
PLAYING A LITTLE MUSIC, AND THEN WAITING FOR THE SPACE BAR OR OTHER KEY TO BE
PRESSED.  IF IT'S NOT POSSIBLE TO FIND THE SCREEN SETUP, WE STILL HAVE A FAIRLY
OBVIOUS "HOOK" INTO FINDING THE STARTING ADDRESS, AND IN MANY CASES THE GAME CAN
BE SAVED 'AS IS' BY USING THE KEYBOARD ROUTINE AS THE STARTING ADDRESS.  DON'T
WORRY FOR NOW ABOUT EXACTLY HOW WE WILL "SAVE THE GAME".  WE'LL GO THROUGH THAT
CAREFULLY AND THOROUGHLY IN THE NEXT EPISODE.

  SINCE THE KEYBOARD ADDRESS IS C000, WE CAN USUALLY LOCATE ALL THE INPUTS BY
SEARCHING FOR THE 3-BYTE SEQUENCE OF 'AD 00 C0' WITH THE INSPECTOR.
OCCASIONALLY, THE X OR Y REGISTER IS USED TO LOAD KEYBOARD DATA, SO THE
SEQUENCES AC 00 C0 AND AE 00 C0 SHOULD BE TRIED IF THE FIRST COMES UP BLANK
(ONLY THE REAL BASTARDS LIKE SIRIUS USE LDY #$67; LDA $BF99,Y FOR THE KEYBOARD
INPUT).  ALSO, KEEP IN MIND THAT ALL THE ADDRESSES FROM C000 TO C00F WILL ACCESS
THE KEYBOARD, AND IF SOMEONE WAS REALLY DETERMINED TO CONFUSE YOU THEY COULD USE
C007 ONE TIME, C00D THE NEXT, AND SO ON.  IF YOU KNOW THAT THE GAME USES THE
KEYBOARD AND THE PRELIMINARY SEARCHES DON'T SHOW HOW, KEEP ON LOOKING FOR THESE
ADDRESSES, OR THE SIRIUS-TYPE COMPUTED ADDRESSES.  IT PROBABLY MEANS THEY HAVE
SOMETHING TO KIDE, AND LOCATING THE KEYBOARD READ WILL REVEAL ENOUGH TO MAKE THE
SEARCH WORTHWHILE.

  IF THE PROGRAM IS WAITING FOR THE SPACE BAR, YOU WILL USUALLY FIND A SEQUENCE
LIKE:



  78E0: LDA $C000   ;READ THE KEYBORARD
	BPL $78E0   ;NO KEY PRESSED
	STA $C010   ;RESET KBD STROBE
       *CMP #$A0    ;WAS IT SPACE?
       *BNE $78E0   ;NOPE, KEEP TRYING
	JMP $6012   ;YES, GO TO START

  *THESE TWO LINES ARE ELIMINATED IF PRESSING ANY KEY WILL START THE GAME.

  TO CHECK OUT 6012 AS A STARTING ADDRESS, SET UP TO VIEW THE HI-RES SCREEN
(OTHERWISE THE GAME MIGHT BE RUNNING WHILE YOU WATCH A BLANK TEXT SCREEN) WITH:
C050 (CR) C057 (CR), THEN TYPE 6012G.  AS BEFORE, YOU WILL KNOW AT ONCE IF YOU
WERE SUCCESSFUL.

  ANOTHER WAY TO FIND A RESTART POINT IS TO SEARCH THROUGH THE KEYBOARD INPUT
ROUTINES FOR A RESTART KEY.  IT HAS BECOME CONVENTIONAL TO USE CTRL-R AS THE
RESTART COMMAND (OCCASIONALLY CTRL-S OR CTRL-B), AND THIS IS EVEN EASIER TO
TRACE.	IN ONE OF THE ROUTINES FOLLOWING A C000 REFERENCE, YOU WILL FIND A CMP
#$92 (SEE THE REFERENCE MANUAL, P.  7 FOR THE HEX VALUES OF THE KEYBOARD).  THE
LOCATION BRANCHED TO OR JUMPED TO BY A SUCCESSFUL COMPARE WILL BE THE RESTART
FOR THE GAME.  AGAIN, YOU CAN SAVE THE GAME AS IS AND USE YOUR NEW-FOUND
STARTING LOCATION.


  IF THESE RELATIVELY SIMPLE APPROACHES FAIL, YOU'LL HAVE TO RESORT TO THE REAL
GRUNT TYPE OF DETECTIVE WORK--LOOKING FOR SOMETHING PROMISING (WE'LL DISCUSS
BOOT-TRACING AS AN ALTERNATIVE WAY OF GETTING TO THIS POINT IN ANOTHER EPISODE
DEVOTED ENTIRELY TO THAT TECHNIQUE).  LIKELY THINGS TO LOOK FOR ARE "SETUPS",
WHERE A LOT OF ZERO PAGE LOCATIONS ARE INITIALIZED TO BEGIN THE GAME:

	   LDA #$00
	   STA $23
	   STA $57
	   LDA #$12
	   STA $30
	   LDA #$E9
	   STA $72
	   ETC.
	   ETC

OR, SOMETIMES, A GAME START IS INDICATED BY A SUBROUTINE SEQUENCE WHICH MAPS OUT
THE PATH FOR THE GAME (THIS IS AN INDICATION OF AN EXPERIENCED, WELL-DISCIPLIED
PROGRAMMER, AND THUS IS MORE COMMONLY SEEN IN BUSINESS OR PROFESSIONAL PROGRAMS;
RARELY IN GAME PROGRAMMING).

	JSR $8CD
	JSR $CE4
	JSR $2020
	JSR $203D
	JSR $8FE
	ETC.

  AND, ALTHOUGH IT'S LESS OFTEN THE START OF A PROGRAM OR GAME, A "JUMP TABLE"
CAN BE A SIGNIFICANT CLUE TO THE ORGANIZATION OF THE PROGRAM:

	JMP $204D
	JMP $2433
	JMP $EF2
	JMP $2077
	ETC.

  UNFORTUNATELY, SNOOPING FOR THESE IS A TIME-CONSUMING, HIT-AND-MISS OPERATION
- THE REAL STARTING ADDRESS CAN BE ANYWHERE FROM 0000 TO BFFF (OR EVEN VIA A
BASIC SUBROUTINE IN D000-F7FF, BUT I DON'T WANT TO DISCOURAGE YOU YET).

  WHILE IT WILL BE DISCONCERTING TO THE BEGINNER, AS YOU GET MORE EXPERIENCE YOU
BEGIN TO ENJOY DEFEATING VARIOUS DELIBERATE ATTEMPTS TO THROW YOU OFF THE
TRAIL--THE GENERAL SUBJECT OF OBFUSCATION, OR INTENTIONAL LACK OF CLARITY.
BECAUSE THE MAJOR SOFTWARE COMPANIES KNOW WE'RE OUT HERE WAITING FOR THEIR
LATEST OUTPUT, THEY OFTEN TRY TO MISDIRECT US OR FIND INNOVATIVE WAYS OF HIDING
SENSITIVE PORTIONS OF THE PROGRAM WITH A VARIETY OF TECHNIQUES.  TAKE A LOOK AT
THE FOLLOWING PIECE OF CODE FROM ON-LINE'S CANNONBALL BLITZ:

59E4-	CE E7 59    DEC   $59E7
59E7-	CF	    ???
59E8-	EA	    NOP
59E9-	59 EF EA    EOR   $EAEF,Y
59EC-	59 AD 51    EOR   $51AD,Y
59EF-	C0 AD	    CPY   #$AD
59F1-	54	    ???
59F2-	C0 AD	    CPY   #$AD
59F4-	57	    ???
59F5-	C0 AD	    CPY   #$AD
59F7-	52	    ???
59F8-	C0 20	    CPY   #$20
59FA-	60	    RTS
59FB-	5B	    ???
59FC-	20 C5 5B    JSR   $5BC5
59FF-	20 4E 5B    JSR   $5B4E

  THIS IS AN EXAMPLE OF "SELF-MODIFYING CODE"-INSTRUCTIONS THAT CHANGE AS THE
PROGRAM IS RUN.  IT'S DANGEROUS AND GENERALLY POOR PROGRAMMING PRACTICE, BUT IT
CAN BE USED TO THROW THE DOGS OFF THE SCENT.  AT FIRST GLANCE, IT LOOKS LIKE
DATA OR GARBAGE STUCK IN BEFORE SOME REAL CODE.  LET'S LOOK AT EXACTLY HOW IT
WORKS.	EXECUTING THE FIRST INSTRUCTION CHANGES THE SECOND INSTRUCTION FROM JUNK
INTO A LEGAL INSTRUCTION:


59E4-	CE E7 59    DEC   $59E7
59E7-	CE EA 59    DEC   $59EA
59EA-	EF	    ???
59EB-	EA	    NOP
59EC-	59 AD 51    EOR   $51AD,Y
59EF-	C0 AD	    CPY   #$AD


  (IF YOU HAVE AN OLD MONITOR ROM, YOU CAN TYPE 59E4S TO EXECUTE THE FIRST
INSTRUCTION).  IF WE EXECUTE THE SECOND INSTRUCTION, THE ENTIRE PICTURE CHANGES:

59E4-	CE E7 59    DEC   $59E7
59E7-	CE EA 59    DEC   $59EA
59EA-	EE EA 59    INC   $59EA
59ED-	AD 51 C0    LDA   $C051
59F0-	AD 54 C0    LDA   $C054
59F3-	AD 57 C0    LDA   $C057
59F6-	AD 52 C0    LDA   $C052
59F9-	20 60 5B    JSR   $5B60
59FC-	20 C5 5B    JSR   $5BC5
59FF-	20 4E 5B    JSR   $5B4E
5A02-	A9 04	    LDA   #$04
5A04-	8D EC B7    STA   $B7EC
5A07-	A9 00	    LDA   #$00
5A09-	8D EB B7    STA   $B7EB
5A0C-	A9 00	    LDA   #$00
5A0E-	8D F0 B7    STA   $B7F0
5A11-	A9 60	    LDA   #$60
5A13-	8D F1 B7    STA   $B7F1
5A16-	A9 40	    LDA   #$40
5A18-	20 45 5A    JSR   $5A45
5A1B-	10 01	    BPL   $5A1E
5A1D-	A9 20	    LDA   #$20
5A1F-	91 5A	    STA   ($5A),Y
5A21-	AD 50 C0    LDA   $C050
5A24-	A9 09	    LDA   #$09

  SUDDENLY, THE SCREEN SETUP CODE THAT WAS ALWAYS THERE POPS INTO VIEW.  THIS
POINTS OUT THE VALUE OF SEARCHING WITH THE INSPECTOR, SINCE EVEN THE CLOSEST
SCRUTINY WOULD PROBABLY NOT HAVE MADE YOU SUSPECT WHAT WAS ACTUALLY HERE.
NOTICE, TOO, THAT THE THIRD INSTRUCTION INCREMENTS 59EA, SO ONCE IT'S BEEN RUN,
IT'S OBSCURED AGAIN.

  ANOTHER STANDARD TRICK, ALSO SHOWN IN THIS EXAMPLE, IS CALLED "FALSE
DISASSEMBLY", AND IS DEAR TO EDU-WARE, ON-LINE, IDSI, AND SCIENTIFIC RESEARCH
ASSOCIATES.  HERE, EXTRA BYTES ARE ADDED FOR THE SOLE PURPOSE OF GIVING A FALSE
INDICATION OF PROGRAM FLOW; THE FAKE BYTES ARE THEN BRANCHED AROUND.  LOOK
CLOSELY AT THE INSTRUCTION IN 5A1B-IT SAYS BPL 5A1E.  THE NEXT INSTRUCTIONS IN
SEQUENCE APPEAR TO THE CASUAL EYE TO BE LDA $#20; STA ($5A),Y.	ACTUALLY, THE
NEXT INSTRUCTION IS JSR $5A91.	THIS IS CRUCIAL, SINCE THIS SUBROUTINE LOADS IN
THE GAME AND DOES A NIBBLE COUNT.  TO SEE A WHOLE BUNCH OF FALSE DISASSEMBLIES
IN A ROW, LOOK AT THE CODE IN THE ACTUAL SUBROUTINE:

5A91-	A9 00	    LDA   #$00
5A93-	10 01	    BPL   $5A96
5A95-	20 A8 59    JSR   $59A8
5A98-	00	    BRK
5A99-	27	    ???
5A9A-	C8	    INY
5A9B-	D0 FA	    BNE   $5A97
5A9D-	85 10	    STA   $10
5A9F-	F0 01	    BEQ   $5AA2
5AA1-	A9 A9	    LDA   #$A9
5AA3-	20 59 00    JSR   $0059
5AA6-	27	    ???
5AA7-	C8	    INY
5AA8-	C8	    INY
5AA9-	D0 F9	    BNE   $5AA4
5AAB-	85 11	    STA   $11
5AAD-	49 B7	    EOR   #$B7
5AAF-	48	    PHA
5AB0-	A5 10	    LDA   $10
5AB2-	49 11	    EOR   #$11
5AB4-	48	    PHA
5AB5-	D0 01	    BNE   $5AB8
5AB7-	4C 60 08    JMP   $0860
5ABA-	60	    RTS

  I STRONGLY URGE YOU TO SIT DOWN AND FIGURE OUT EXACTLY WHAT THE REAL PROGRAM
IS HERE, AND IF POSSIBLE, WHAT IT DOES.  COVER UP THE EXPLANATION BELOW, AND GO
THROUGH THE CODE BYTE BY BYTE TO ELIMINATE THE FAKE BYTES.  IT'S NOT JUST
CHARACTER-BUILDING--IF YOU GO THROUGH A FEW OF THESE, YOU'LL LEARN TO RECOGNIZE
THEM WHEN THEY POP UP.

  THOSE OF YOU WHO REALLY WENT THROUGH IT, GIVE YOURSELVES FOUR KRACKING HONOR
POINTS.  FOR THE REST OF YOU, HERE'S A LISTING OF THE FUNCTIONAL EQUIVALENT
(SOME ADDRESSES ARE CHANGED BECAUSE THE JUNK BYTES HAVE BEEN TAKEN OUT):

5A91-	A9 00	    LDA   #$00
5A93-	A8	    TAY
5A94-	59 00 27    EOR   $2700,Y
5A97-	C8	    INY
5A98-	D0 FA	    BNE   $5A94
5A9A-	85 10	    STA   $10
5A9C-	A9 20	    LDA   #$20
5A9E-	59 00 27    EOR   $2700,Y
5AA1-	C8	    INY
5AA2-	C8	    INY
5AA3-	D0 F9	    BNE   $5A9E
5AA5-	85 11	    STA   $11
5AA7-	45 B7	    EOR   $B7
5AA9-	48	    PHA
5AAA-	A5 10	    LDA   $10
5AAC-	49 11	    EOR   #$11
5AAE-	48	    PHA
5AAF-	60	    RTS

  THIS IS ALSO VALUABLE BECAUSE IT INTRODUCES THE CONCEPT OF "JUMPING THROUGH
THE STACK".  THE RTS INSTRUCTION TRANSFERS THE TWO BYTES ABOVE THE STACK POINTER
IN PAGE ONE TO THE PROGRAM COUNTER, INCREMENTS THE LOW BYTE BY ONE, AND JUMPS TO
THAT LOCATION.	ORDINARILY, THE BYTES ON THE STACK WERE PLACED THERE AS A RETURN
ADDRESS BY THE JSR INSTRUCTION.  IN THIS CASE, IN VERY ROUNDABOUT FASHION, THE
ON-LINERS HAVE PUSHED TWO BYTES ON THE STACK AND EXECUTED AN RTS, WHICH JUMPS TO
THE LOCATION ONE HIGHER THAT THE VALUES STORED.  THE STORY OF THE SUBROUTINE
GOES LIKE THIS:  CREATE A CHECKSUM BY EXCLUSIVE-ORING TOGETHER ALL THE BYTES
FROM 2700 TO 27FF, AND STORE IT IN $10.  THIS ALLOWS A CHECK TO SEE IF ANY OF
THE BYTES IN THE NIBBLE COUNT ROUTINE WERE ALTERED.  DO A SECOND CHECKSUM ON
EVERY OTHER BYTE FROM 2700 TO 27FF, STARTING WITH A VALUE OF #$20.  STORE THIS
IN $11, THEN EXCLUSIVE-OR IT WITH #$B7 TO PRODUCE THE LOW BYTE OF THE RETURN
ADDRESS:FF.  PUSH THIS ON THE STACK, EXCLUSIVE-OR THE FIRST CHECKSUM WITH #$11
TO PRODUCE THE RETURN HIGH BYTE OF $26, THEN DO THE RTS TO JUMP TO 2700.  WHEN
YOU LOOK AT 2700, YOU FIND THIS:

2700-	CE 03 27    DEC   $2703
2703-	EF	    ???
2704-	03	    ???
2705-	27	    ???
2706-	AD 24 27    LDA   $2724
2709-	49 8A	    EOR   #$8A
270B-	D0 01	    BNE   $270E
270D-	20 8D 24    JSR   $248D
2710-	27	    ???
2711-	D0 01	    BNE   $2714
2713-	4C A0 25    JMP   $25A0
2716-	98	    TYA
2717-	59 00 27    EOR   $2700,Y
271A-	99 00 27    STA   $2700,Y
271D-	C8	    INY
271E-	D0 F6	    BNE   $2716

  (YOU SEE, NOW THAT WE'RE FAMILIAR WITH THIS KIND OF TRICK, THERE'S NOTHING TO
DECODING THAT MESS, IS THERE?)

  STAY TUNED FOR NEXT WEEK, WHEN WE FINISH THIS SUBJECT BY ANSWERING THE BURNING
QUESTION "WHAT IS THE WINDOW-SHADE TECHNIQUE?", AND PROCEED TO A DISCUSSION OF
MEMORY MOVING AND FILE SAVING.

---------------------------------------
***************************************
*				      *
*     KRAKOWICZ'S KRACKING KORNER     *
*				      *
*      THE BASICS OF KRACKING 3:      *
*				      *
*   MEMORY MOVES, BINARY FILES, AND   *
*	KRAMMING FOR THE FINALS       *
*				      *
***************************************

  IN THE LAST EPISODE, WE PONDERED THE STARTING ADDRESS OF A PROGRAM AND WAYS TO
FIND IT IN SPITE OF THE PROTECTORS' SUBTERFUGE.  THIS TIME WE'LL DISCUSS HOW TO
GET THE PROGRAM INTO SAVEABLE FORMAT, EVEN IF IT'S TOO LONG TO SAVE AS A BFILE.
ALTHOUGH WE'LL BE REFERRING AT FIRST TO SINGLE-LOAD PROGRAMS, MOST OF THESE
TECHNIQUES ARE APPLICABLE TO PROGRAMS WITH DISK ACCESS.

  BEFORE WE BEGIN THE PROCESS, LET ME PHILOSOPHIZE FOR A FEW SECONDS ON THE
PROCEDURES AND PRACTICES TO BE USED.  THIS IS A DISCIPLINE:  PERHAPS NOT SO
DEMANDING AS CHAMPIONSHIP KARATE OR THE UNIFICATION CHURCH, BUT IT REQUIRES
KNOWLEDGE, PATIENCE, AND ATTENTION TO DETAIL.  I URGE YOU TO BEGIN EACH
ADVENTURE IN KRACKING WITH A SHARP PENCIL, PLENTY OF PAPER, AND A GOOD ERASER.
FROM THIS POINT FORWARD IN OUR QUEST, RECORD-KEEPING WILL OCCUPY AN IMPORTANT
PART OF THE TOTAL ACTIVITY.  IF YOU HAVE A PRINTER, PRINT OUT ANY PERTINENT
SECTIONS OF CODE AND WRITE IN YOUR OWN COMMENTS ABOUT WHAT IT MEANS.  WRITE DOWN
EVERY ADDRESS OF INTEREST, AND KEEP ESPECIALLY CAREFUL NOTES OF THE NATURE AND
SEQUENCE OF ALL MEMORY MOVES, STARTING POINTS, AND TRICKS USED BY THE
PROTECTORS.  DO THIS NOT JUST BECAUSE IT'S CHARACTER BUILDING, BUT BECAUSE
UNLESS YOU HAVE EXCEPTIONAL RECALL, ALL PROGRAMS WILL EVENTUALLY BLEND TOGETHER
INTO A WARM AND FUZZY MEMORY.  KEEP GOOD NOTES ON EVERYTHING YOU LEARN, AND
REMEMBER:  "THOSE WHO CANNOT RECALL THE MISTAKES OF THE PAST ARE DOOMED TO
REPEAT THEM."

  SUPPOSE YOU HAVE LOADED IN, RESET WITH YOUR OLD MONITOR ROM, AND FINALLY
LOCATED THE STARTING ADDRESS TO THE GREATEST GAME EVER WRITTEN:  "HYPERSPACE
ANDROID CLONE KILLER" OR "HACK".  THE STARTING ADDRESS IS 4123, AND THE GAME
OCCUPIES MEMORY FROM 800 TO B000.  YOU ALREADY KNOW THAT IF ANY MEMORY ABOVE
9D00 HAS BEEN USED BY THE PROGRAM, DOS IS DEAD, AND YOU CAN'T SAVE THE PROGRAM
TO DISK WITH A DOS COMMAND.  AS YOU ALSO UNDOUBTEDLY KNOW, IF THE PROGRAM WERE
SMALLER YOU WOULD HAVE THE OPTION OF BOOTING A DISK AND SAVING THE GAME AS A
BINARY FILE.  LET'S TAKE JUST A SECOND, THOUGH, AND REVIEW WHAT HAPPENS TO
MEMORY WHEN YOU BOOT A DISK.

  FIRST OF ALL, DON'T USE A MASTER DISK, SINCE THE DOS ON A MASTER IS LOADED
FIRST INTO 1600-3FFF AND THEN RELOCATED TO THE HIGHER REGIONS OF MEMORY.
BOOTING A 48K SLAVE DISK WILL DISTURB ONLY 0-8FF AND 9600-BFFF, AND IF YOUR
PROGRAM LIVES WITHIN OR CAN BE REARRANGED TO FIT THESE BOUNDARIES, YOU CAN
SAFELY BOOT THE DISK AND SAVE THE PROGRAM AS A BINARY FILE.

  AN OLD METHOD OF SAVING A BINARY FILE IS WELL-KNOWN TO THOSE OF US WHO BOUGHT
APPLES IN THE DARK AGES BEFORE THE DISK II, BUT THERE ARE NOW MAYBE HALF A
MILLION (!) APPLE OWNERS WHO ARE UNFAMILIAR WITH THE CASSETTE PORT AND ITS USE.
IN GENERAL, ALMOST ANY CASSETTE RECORDER THAT HAS A TONE CONTROL CAN BE USED,
BUT FOR SOME REASON THE CHEAPER ONES ARE GENERALLY BETTER.  TO USE ONE, PLUG
BOTH CABLES INTO THE CORRECT CONNECTOR ("IN" MEANS INTO THE COMPUTER, NOT INTO
YOUR RECORDER), AND TURN THE TONE CONTROL ALMOST TO THE TOP OF THE TREBLE RANGE.
SAVE A SMALL BASIC PROGRAM (REFER TO THE MANUAL FOR USE OF THE BASIC COMMANDS)
AT ANY OLD VOLUME CONTROL SETTING.  TRY LOADING THE PROGRAM BACK IN SEVERAL
TIMES, INCREASING THE VOLUME CONTROL SETTING UNTIL THE PROGRAM LOADS RELIABLY.
YOU'LL FIND THAT THE TAPE WORKS VERY WELL, EVEN ON LONG FILES, ESPECIALLY WHEN
THE SAME RECORDER IS USED TO RECORD AND PLAYBACK.

  WHAT'S GOOD ABOUT THE TAPE SYSTEM IS THAT EVEN WHEN DOS IS COMPLETELY DEAD,
THE MONITOR COMMANDS FOR TAPE I/O ARE STILL ACTIVE (ASSUMING YOU DIDN'T WIPE
THEM OUT OF YOUR OLD MONITOR ROM).  SEE THE REFERENCE MANUAL, PAGE 46 FOR A
COMPLETE DESCRIPTION.  WITH TAPE, YOU CAN ALWAYS SAVE ANY PART OF MEMORY AT ANY
TIME!  (WORTH KEEPING IN MIND FOR THOSE CRUCIAL SITUATIONS WHEN THE SYSTEM
CRASHES JUST AS YOU ARE FINISHING YOUR TERM PAPER ON THE WORD PROCESSOR).  THE
CASSETTE ROUTINES USE ONLY LOCATIONS 3C-3F AND 42-43 IN ZERO PAGE, AND THE ONLY
PART OF MEMORY YOU SHOULDN'T TRY TO SAVE IS C000-C0FF-- SOME TERRIBLE THINGS CAN
HAPPEN IF YOU TRY.  IN MOST CASES, IT'S BEST TO SAVE A LONG PROGRAM IN TWO FILES
SO IT CAN BE RELOADED IN BETWEEN 800 AND 9600 AFTER DOS IS IN MEMORY.  FOR OUR
EXAMPLE OF "HACK", THE NECESSARY MONITOR COMMANDS ARE:

      *0.4FFFW	(LONG WAIT)
      *5000.AFFFW  (LONGER WAIT)

  AFTER BOOTING A DISK, YOU CAN RELOAD WITH:

      *1000.5FFFR (RELOAD FIRST HALF)
      *BSAVE HACKLOW,A$1000,L$5000
      *BSAVE HACKHI,A$1000,L$6000

  NOTE THAT IN THE TAPE READ AND WRITE COMMANDS, UNLIKE DOS, THE ACTUAL STARTING
AND ENDING LOCATIONS ARE LISTED.  BE SURE YOU UNDERSTAND THE ONE-BYTE DIFFERENCE
BETWEEN THE TWO BEFORE YOU USE THEM.

  THERE ARE ALSO OCCASIONS WHEN YOU WOULD LIKE TO SAVE APPLESOFT OR INTEGER
BASIC PROGRAMS LOADED IN FROM A MODIFIED DOS ON A PROTECTED DISK (ARCADE MACHINE
AND THE RAPID-FIRE SERIES FROM SSI ARE EXAMPLES).  THIS IS SIMPLE WITH THE TAPE
RECORDER, SINCE THE MONITOR ROUTINES ARE TOTALLY IGNORANT OF THE OPERATING
SYSTEM IN RAM.	IF YOU CAN LIST A BASIC PROGRAM, YOU CAN USUALLY SAVE IT TO
TAPE.  TRY THE FOLLOWING WITH ONE OF THE ABOVE PROGRAMS:  LOAD IN A PROGRAM
MODULE (ANYTHING IN ARCADE MACHINE EXCEPT THE MAIN MENU), THEN HIT RESET WHILE
IT'S RUNNING.  TYPE D6:00 (THIS REMOVES THE APPLESOFT INTERNAL "PROTECTION"),
THEN C081 TO SELECT THE MOTHER BOARD ROM (UNLESS YOU HAVE AN APPLE II WITH
APPLESOFT ON A ROM CARD, THEN IT'S C080 TO SELECT SLOT 0).  TYPE CONTROL-C AND
YOU SHOULD BE ABLE TO LIST THE PROGRAM AND THEN SAVE IT TO TAPE WITH THE "SAVE"
COMMAND (SOMETIMES AN ADDITIONAL FAIRLY TRIVIAL PROTECTION SCHEME IS USED WITH
APPLESOFT PROGRAMS:  DELETING THE FIRST LINE NUMBER SO IT WON'T LIST.  IT WILL
STILL SAVE TO TAPE AND YOU CAN RECONSTRUCT THE LINE NUMBER AT YOUR LEISURE).
REMEMBER THAT THE BASIC "LOAD" AND "SAVE" COMMANDS DON'T ALLOW A FILE NAME TO BE
ADDED.	IF THERE ARE MORE THAN A FEW FILES ON THE DISK, THIS IS A VERY TEDIOUS
WAY TO KRACK A PROGRAM, BUT BACK IN THE MIDDLE AGES BEFORE DEMUFFIN PLUS IT WAS
SOMETIMES THE ONLY WAY.  YOU ALSO HAVE TO BE WARY OF BINARY ROUTINES WHICH ARE
CALLED FROM OR MODIFY THE BASIC PROGRAMS.

  YES, YOU'RE RIGHT.  GETTING OUT AND HOOKING UP THE TAPE RECORDER IS A CRAMP IN
THE CALVINS, SO IT'S USUALLY LEFT WORKS.  IN GENERAL, IT'S BEST TO LEARN HOW TO
MANIPULATE MEMORY TO SCRUNCH YOUR PROGRAM DOWN INTO A DOS FILE (IT WILL ALWAYS
HAVE TO BE DONE, ANYWAY).  IN THE BEST OF ALL POSSIBLE WORLDS, YOUR DOS WOULD BE
IN ROM MEMORY, AND WOULD ALLOW YOU TO SAVE ANY PROGRAM THAT RESIDED IN RAM
MEMORY.  IN THE REAL WORLD, IT'S GENERALLY NECESSARY TO LOADED IN BY DOS FROM A
NORMAL DISK (WE'LL TALK LATER ABOUT THOSE THAT CAN'T BE).  THIS PROCESS IS
USUALLY CALLED "MEMORY MOVING", AND THE PURPOSE IS TO "TUCK IN" ALL THE PIECES
OF THE PROGRAM THAT LIE OUTSIDE THE NORMAL PROGRAM MEMORY OF 800-9600 ALLOWED BY
DOS.  THE OTHER HALF OF THE PROCESS IS THE "UNFOLDING" OF THE TUCKED-IN PORTIONS
OF MEMORY AFTER THE PROGRAM IS RELOADED UNDER DOS.  TO GAIN PERSPECTIVE ON THE
PROCESS, LET'S LOOK AT MEMORY MAPS WITH DOS ACTIVE AND WITH "HACK" IN MEMORY.
_______________________________________
!				      !
!				      !
!F800-FFFF->!MONITOR ROM!AUTOSTART ROM!
!-------------------------------------!
!F000-F7FF->! INTEGER	! APPLESOFT   !
!E800-EFFF->!	  BASIC !     "       !
!E000-E7FF->!  "    "   !     "       !
!D800-DFFF->!(INSPECTOR)!     "       !
!D000-D7FF->! (WATSON)	!     "       !
!-------------------------------------!
!C800-CFFF->!PERIPHERAL SLOT ROM SPACE!
!C000-C7FF->!SOFT SWITCHES & SLOT ROMS!
!-------------------------------------!
!B800-BFFF->!		^	      !
!B000-B7FF->!		!	      !
!A800-AFFF->!	       DOS	      !
!A000-A7FF->!		!	      !
!9800-9FFF->!		V	      !
!-------------------------------------!
!9000-97FF->!	   ^		      !
!8800-8FFF->!	   !		      !
!8000-87FF->!	   !		      !
!7800-7FFF->!	   !		      !
!7000-77FF->!	   !		      !
!6800-6FFF->! PROGRAM MEMORY	      !
!6000-67FF->!	   !		      !
!------------------!------------------!
!5800-5FFF->!	   !	    ^	      !
!5000-57FF->!	   !  (HI-RES PAGE 2) !
!4800-4FFF->!	   !	    !	      !
!4000-47FF->!	   !	    V	      !
!------------------!------------------!
!3800-3FFF->!	   !	    ^	      !
!3000-37FF->!	   !  (HI-RES PAGE 1) !
!2800-2FFF->!	   !	    !	      !
!2000-27FF->!	   !	    V	      !
!------------------!------------------!
!1800-1FFF->!	   !		      !
!1000-17FF->!	   !		      !
!0800-0FFF->!	   V  (TEXT PAGE 2)   !
!--------------------------------------
!0000-07FF->!ZERO PG,STACK,TEXT PAGE 1!
---------------------------------------
       AND, WITH "HACK" IN MEMORY:
_______________________________________
!	    !		!	      !
!F800-FFFF->!MONITOR ROM!AUTOSTART ROM!
!-------------------------------------!
!F000-F7FF->! INTEGER	! APPLESOFT   !
!E800-EFFF->!	  BASIC !     "       !
!E000-E7FF->!  "    "   !     "       !
!D800-DFFF->!(INSPECTOR)!     "       !
!D000-D7FF->! (WATSON)	!     "       !
!-------------------------------------!
!C800-CFFF->!PERIPHERAL SLOT ROM SPACE!
!C000-C7FF->!SOFT SWITCHES & SLOT ROMS!
!-------------------------------------!
!B800-BFFF->!	      (EMPTY)	      !
!B000-B7FF->!	   ^		      !
!A800-AFFF->!	   !		      !
!A000-A7FF->!	   !		      !
!9800-9FFF->!	   !		      !
!------------------!------------------!
!9000-97FF->!	   !		      !
!8800-8FFF->!	   !  (EMPTY)	      !
!8000-87FF->!	   !  (EMPTY)	      !
!7800-7FFF->!	   !		      !
!7000-77FF->!	   !		      !
!6800-6FFF->! PROGRAM "HACK"          !
!6000-67FF->!	   !		      !
!------------------!------------------!
!5800-5FFF->!	   !	    ^	      !
!5000-57FF->!	   !  (HI-RES PAGE 2) !
!4800-4FFF->!	   !	    !	      !
!4000-47FF->!	   !	    V	      !
!------------------!------------------!
!3800-3FFF->!	   !	    ^	      !
!3000-37FF->!	   !  (HI-RES PAGE 1) !
!2800-2FFF->!	   !	    !	      !
!2000-27FF->!	   !	    V	      !
!------------------!------------------!
!1800-1FFF->!	   !  (EMPTY)	      !
!1000-17FF->!	   !  (EMPTY)	      !
!0800-0FFF->!	   V  (TEXT PAGE 2)   !
!-------------------------------------!
!0000-07FF->!ZERO PG,STACK,TEXT PAGE 1!
---------------------------------------

  BEFORE WE BEGIN THE DISCUSSION OF THE TECHNIQUES OF MEMORY MOVING, LET'S
RESTATE THE OBJECTIVE:	WE'RE TRYING TO ARRANGE ALL THE PROGRAM INTO A SMALL
ENOUGH SPACE THAT WE CAN BSAVE A FILE UNDER DOS (THE DOS MANUAL WILL TELL YOU
THAT THE LARGEST BINARY FILE YOU CAN SAVE IS 128 SECTORS, BUT IF YOU CHANGE
LOCATION $A964 (43364) TO $BF(191) YOU CAN SAVE A FILE AS LARGE AS THE ENTIRE
RAM MEMORY).  REMEMBER THAT BOOTING A SLAVE DISK WILL MESS UP 0-8FF AND
9600-BFFF, SO THE LARGEST FILE IT'S PRACTIVAL TO SAVE IS ABOUT 145 SECTORS (YOU
CAN, WITH CARE, OVERWRITE MUCH OF THE SCREEN MEMORY AND PAGES 2 & 3 TO SAVE A
BFILE OF ABOUT 151 SECTORS, BUT THAT REQUIRES KNOWLEDGE AND CONSIDERABLE CARE).

  LOOKING AT THE MEMORY MAP WITH HACK, YOU CAN SEE THAT THE MEMORY FROM 9600 TO
B000 WILL HAVE TO BE STORED SOMEWHERE ELSE TO BRING THE FILE SIZE DOWN, AND THE
PAGE FROM 800-8FF WILL HAVE TO BE STASHED TEMPORARILY DURING THE DISK BOOT TO
RESTORE DOS.  TO FIND OUT WHAT AREAS OF MEMORY ARE FREE, SEARCH THROUGH ALL
MEMORY WITH THE INSPECTOR AND LOOK FOR BLANK PAGES.  THE FOLLOWING TRICK WILL
HELP:  BEFORE YOU LOAD THE ORIGINAL, CLEAR ALL OF MEMORY TO ZERO (OR ANY OTHER
BYTE YOU LIKE) WITH:

	   *800:0
	   *801<800.95FFM

  THEN YOU'LL BE ABLE TO SEE UNUSED MEMORY AREAS.  THIS DOESN'T ALWAYS WORK,
SINCE MANY AREAS ARE COPIED TO A SECOND LOCATION AND NOT USED AFTERWARDS, SO IF
YOU'RE HARD PRESSED FOR STORAGE MEMORY, IT'S A GOOD IDEA TO SCAN THROUGH ONCE
WITH THE INPECTOR SET TO DECODE ASCII TO DETECT SUSPICIOUS SECTORS (LATELY, SOME
OF THE PROTECTORS HAVE TAKEN TO STORING GARBAGE SUCH AS SOURCE CODE IN UNUSED
PAGES OF MEMORY AND ON EMPTY DISK SECTORS).  NOTE DOWN ANY PAGES THAT ARE
TOTALLY CLEAR, ANY THAT ARE ALL ONE BYTE, REGARDLESS OF WHAT IS IS, OR ANY THAT
CONTAIN JUNK.  LET'S ASSUME FOR THIS EXAMPLE THAT LOCATIONS 1000-1FFF AND
8000-8FFF ARE BLANK.  WE HAVE 1A00 (B000-9600) BYTES OF MEMORY "LEFTOVER" OR
OUTSIDE OF THE DOS BOUNDARIES, SO THEY WILL ALL FIT INTO THE $2000 BLANK
LOCATIONS THAT WE LOCATED.

  STORE THE EXCESS BYTES IN THE HOLES BY TYPING:


     *8000<9600.A5FFM
     *1000<A600.AFFFM

  OR EQUIVALENT; THE SPLIT CAN BE ANY WAY THAT HELPS YOU KEEP TRACK OF THE
PROCESS.  FINALLY, STASH THE MEMORY FROM PAGE 8 WITH *1B00<800.8FFM.  REMEMBER
THAT THIS IS ONLY TEMPORARY.  BEFORE YOU DO ANYTHING ELSE, BOOT YOUR 48K SLAVE
DISK, THEN RESTORE PAGE 8 WITH *800<1B00.1BFFM.  BEFORE YOU DO ANYTHING ELSE,
SAVE THE PROGRAM WITH "BSAVE HACKALL,A$800,L$8E00 (NINE OUT OF TEN TIMES YOU'LL
FORGET TO CHANGE $A964; CONSIDER CHANGING IT IN THE DOS IN MEMORY BEFORE YOU
INITIALIZE THE DISK SO IT WILL BE PERMANENT).  YOU CAN NOW TAKE A DEEP BREATH
AND RELAX:  ALL OF THE PROGRAM MEMORY IS SAFELY TUCKED AWAY.  ALL THAT'S LEFT IS
TO WRITE A SHORT PROGRAM TO REVERSE THE MEMORY STORAGE.

  TWO SHORT ROUTINES, SIMILAR TO THOSE SHOWN IN OUR FIRST BASICS LESSON ARE
REQUIRED.  AGAIN, LET'S REVIEW THE STEPS NECESSARY FROM HERE TO RUN THE GAME:


  1.  LOAD THE (COMPRESSED) GAME INTO 800-95FF.
  2.  MOVE THE PIECE OF MEMORY AT 8000-9FFF TO 9600-A5FF.
  3.  MOVE THE PIECE OF MEMORY AT 1000-19FF TO A600-AFFF.
  4.  JUMP TO THE STARTING ADDRESS AT $4123.

  THE FOLLOWING PROGRAM WILL TAKE CARE OF STEPS 2-4.  IT MAY NOT BE IMMEDIATELY
OBVIOUS THAT THIS PROGRAM MUST BE STORED WITHIN THE COMPRESSED PROGRAM IN A PAGE
THAT IS BOTH EMPTY AND UNAFFECTED BY THE MEMORY MOVES YOU ARE ABOUT TO MAKE.  IN
THIS CASE, PAGE 1C IS SAFE.

 1C00  LDY #$0	   ;CLR Y-REG
 1C02  LDA $8000,Y ;GET A BYTE AT 8000+
 1C05  STA $9600,Y ;STORE IT AT 9600+
 1C08  INY	   ;INCR. COUNTER
 1C09  BNE $1C02   ;IF NOT PAGEND, REDO
 1C0B  INC $1C04   ;INCR. SOURCE HIBYTE
 1C0E  INC $1C07   ;INCR. DEST HIBYTE
 1C11  LDA $1C07   ;GET THE DEST HIBYTE
 1C14  CMP #$90    ;IF 90,WE'RE DONE
 1C16  BNE $1C02   ;IF NOT, DO MORE
 1C18  LDA $1000,Y ;REPEAT THE PROCESS
 1C1B  STA $A600,Y ;FOR THE SECOND
 1C1E  INY	   ;BLOCK
 1C1F  BNE $1CA8
 1C21  INC $1C1A
 1C24  INC $1C1D
 1C27  LDA $1C1D
 1C2A  CMP #$1B
 1C2D  BNE $1CA8
 1C2F  JMP 4123    ;AND JUMP TO THE
		    STARTING LOCATION

  THIS MAY SEEM HARD AT FIRST, BUT THE FORM IS SO CONSTANT THAT YOU'LL BE ABLE
TO WRITE THESE MOVES IN YOUR SLEEP AFTER A FEW TRIES WITH THE MINI- ASSEMBLER
(THE PLACE YOU'LL MOST LIKELY MESS UP IS IN THE 'CMP #90' BY TYPING 'CMP
$90'--WATCH IT CAREFULLY!).

  TIME OUT FOR A BRIEF DISCUSSION OF ONE OF THE SUBTLE POINTS OF MEMORY MOVES.
ALTHOUGH YOU'RE GENERALLY ABLE TO MAKE YOUR MEMORY MOVES NON-OVERLAPPING, YOU
CAN HAVE A PROBLEM MOVING LARGE AMOUNTS OF MEMORY.  THE MEMORY MOVE ROUTINES
SHOWN ABOVE ARE "FORWARD" MEMORY MOVES:  THAT MEANS THAT UST MOVED.  SOMETIMES
YOU WILL NEED TO MOVE, FOR INSTANCE, LOCATIONS 6000-8FFF TO 8000-AFFF.	IF YOU
USE THE FORWARD MOVES AS SHOWN, YOU CAN SEE THAT THE FIRST PAGE (PAGE 60 OR
6000-60FF) WILL LAND AT 8000-80FF, SMACK ON TOP OF THE ORIGINAL PAGE THAT WAS
SUPPOSED TO BE MOVED LATER TO PAGE A0 (A000-A0FF).  TO WORKS "DOWN" IN MEMORY
INSTEAD OF UP.

  IN THIS EXAMPLE, PAGE 8F IS FIRST MOVED TO AF, THEN 8E TO AE, ETC.  THIS WAY,
WHEN IT FINALLY COMES TIMES TIME FOR PAGE 60 TO BE MOVED TO PAGE 80, THE
ORIGINAL PAGE 80 WILL ALREADY HAVE BEEN MOVED.	A TYPICAL ROUTINE FOR THIS IS:


 1000  LDY #$0
 1002  LDA $8F00,Y
 1005  STA $6000,Y
 1008  INY
 1009  BNE $1002
 100B  DEC $1004
 100E  DEC $1007
 1011  LDA $1007
 1014  CMP #$5F
 1017  BNE $1002

  OK--ALL THAT REMAINS IS TO GET TO THE START OF THE EARLIER MEMORY MOVE ROUTINE
WHEN WE "BRUN" THE GAME.  THIS IS ACCOMPLISHED BY PUTTING THE CODE FOR "JMP
$1C00" OR 4C 00 1C AT LOCATION $7FD-$7FF AND MAKING THIS THE FIRST LOCATION OF
THE PROGRAM.  WE CAN THEN SAVE A COMPLETE, FUNTIONING VERSION OF HACK WITH
"BSAVE HACK,A$7FD,L$8E03".  THIS CREATES YOUR FINAL, 145-SECTOR FILE OF HACK
WHICH WILL BRUN WHENEVER YOU WISH.

----------A FEW HELPFUL HINTS----------

  1.  ALWAYS KEEP A FEW INITIALLIZED 48K SLAVE DISKS NEARBY--IT'S ALARMING HOW
FAST A DISK FILLS UP WITH SLIGHTLY DIFFERENT 145-SECTOR VERSIONS OF THE PROGRAM
UNDERGOING KRACKING.

  2.  MAKE YOUR PROGRAM NAMES AS DESCRIPTIVE AS YOU CAN, ESPECIALLY WHEN SAVING
A PROGRAM IN PIECES.  IT'S VERY DISTURBING TO RETURN TO A KRACKING EFFORT AFTER
A LONG WEEKEND TO FIND PROGRAMS ON THE DISK TITLES "HACKHI", "HACKHIGH", "HIGH",
"HH", ETC.  AND NOT BE SURE WHAT EACH ONE IS.  BETTER TO TYPE IN A FEW EXTRA
LETTERS TO LET YOU KNOW THAT IT'S "HACK WITHOUT 9600UP" OR OR "HACK 4000-B000
ONLY".

  3.  WHENEVER POSSIBLE, COMPRESS THE GAME TO THE MINIMUM NUMBER OF SECTORS BY
DOING A FEW MORE MEMORY MOVES BEFORE AND AFTER SAVING.	YOUR FRIENDS WILL
APPRECIATE YOUR THOUGHTFULNESS IN MAXIMIZING THE NUMBER OF GAMES PER DISK AND
MINIMIZING MODEM TIME.

  4.  =>VERY IMPORTANT<= WHEN YOU THINK YOU HAVE A COMPLETE, WORKING VERSION,
CHECK IT OUT THOROUGHLY ON ALL LEVELS AND IN ALL MODES.  IT'S EXTREMELY
EMBARASSING TO HAVE TO ISSUE A "PRODUCT RECALL" WHEN YOU LEARN A MONTH LATER
THAT HACK CRASHES ON LEVEL 47 JUST AS THE HYPERGALACTIC FROG IS ABOUT TO DEVOUR
NEW PITTSBURGH ON THE MARS COLONY...

*** NEXT TIME--PICTURE PACKING AND ***
********* RAM CARD TECHNIQUES ********

---------------------------------------
***************************************
*				      *
*     KRAKOWICZ'S KRACKING KORNER     *
*				      *
*      BASICS OF KRACKING - 104       *
*				      *
***************************************

	  WHERE DO I BEGIN?

  SEVERAL PREVIOUS EPISODES OF THIS COLUMN HAVE DEALT WITH THE RELATIVELY SIMPLE
TECHNIQUES WHICH CAN BE USED TO SAVE A SINGLE-LOAD FILE TO DISK AS AN
UNPROTECTED BINARY PROGRAM, AND IT IS NOW TIME TO EXPLORE THE LARGER AREA OF
MULTIPLE-PROGRAM DISKS, PROGRAMS WITH DISK ACCESS, AND THE APPROACHES USED TO
PROTECT THEM FROM BEING COPIED.  WE WILL BEGIN WITH SIZING UP A DISK PROTECTION
SCHEME, DECIDING ON A BASIC APPROACH, AND BEGINNING THE UNPROTECTION PROCESS
(THE SUBJECT OF BOOT-TRACING AS ANOTHER MEANS TO THE SAME END WILL BE DESCRIBED
IN A FUTURE EPISODE, SINCE IT IS GENERALLY USED WITH MORE SOPHISTICATED
PROTECTION SCHEMES).  THE SUBJECT IS TRULY MAMMOTH, AND WILL REQUIRE SEVERAL
EPISODES TO COMPLETE.  FOR NOW, SETTLE BACK, OPEN A COLD BEVERAGE OF YOUR
CHOICE, AND LET'S BEGIN A JOURNEY INTO THE FIRST LEVEL OF DISK PROTECTION:  THE
MODIFIED DOS (AS WE HAVE OFTEN MENTIONED BEFORE, TWO STALWART FRIENDS IN THIS
QUEST ARE "BENEATH APPLE DOS" BY WORTH AND LECHNER, AND RANDY HYDE'S
"DOSSOURCE".  IT IS POSSIBLE TO KRACK DISKS WITHOUT THEM, BUT WITH ABOUT THE
SAME EASE AS PERFORMING AN ORAL APPENDECTOMY).

  APPLE'S DOS, COMBINED WITH THE DIVISION OF HARDWARE BETWEEN THE DISK
CONTROLLER CARD AND THE DISK ANALOG BOARD, IS A VERITABLE PLAYGROUND FOR THOSE
WHO PRODUCE DISK PROTECTION.  THERE ARE LITERALLY THOUSANDS OF DIFFERENT THINGS
WHICH CAN BE DONE TO MAKE COPYING A DISK DIFFICULT, CHALLENGING, AND (MAYBE
SOMEDAY), IMPOSSIBLE.  IN SO DOING, THEY PROVIDE HOURS OF VERY INGENIOUS
PUZZLES, BOUNDLESS INTELLECTUAL STIMULATION, AND NOT INCIDENTALLY, THE INCENTIVE
TO LEARN MUCH MORE ABOUT PROGRAMMING, THE APPLE, DOS, ASSEMBLY LANGUAGE, AND
TREACHERY THAN WE WOULD OTHERWISE HAVE THE DESIRE TO LEARN.

  BY FAR THE MOST COMMON TECHNIQUE USED TO PROTECT ENTIRE DISKS IS TO MAKE
MODIFICATIONS TO THE OPERATING SYSTEM, AND SPECIFICALLY TO THE READ/WRITE TRACK
AND SECTOR (RWTS) ROUTINES WHICH DEFEAT ORDINARY COPY PROGRAMS (COPYA AND SUPER
DISK COPY 3.X ARE EXAMPLES, BUT WE'LL SEE LATER HOW BOTH OF THESE CAN BE USED TO
OUR ADVANTAGE).  TO FIND THE MOST EFFICIENT APPROACH TO DEFEATING THESE
PROTECTION TECHNIQUES, WE NEED FIRST TO SPEND A FAIR AMOUNT OF TIME DESCRIBING
IT FROM THE CRACKIST'S VIEWPOINT.

  (ON THE FUNDAMENTAL PRINCIPLE THAT GIVING A MAN A FISH ALLOWS HIM TO EAT FOR A
DAY WHILE TEACHING HIM TO FISH ALLOWS HIM TO EAT FOR LIFE, WE WILL NOT DWELL ON
THE SUBJECT OF "COPYING" AS SUCH.  MANY OF THE TECHNIQUES DESCRIBED HERE ARE,
HOWEVER, VERY USEFUL IN DECIDING HOW TO GO ABOUT COPYING A DISK.  PERHAPS AN
ASPIRING AUTHOR OUT THERE WILL BUILD FROM THE INTRODUCTION GIVEN HERE TO PURSUE
THE SUBJECT IN DEPTH...?)

  BEFORE WE CAN GET TO THE CORE OF THE MATTER, WE MUST UNDERSTAND MUCH MORE OF
THE PROCESSING AND ENCODING SYSTEMS USED BY DOS TO STORE INFORMATION ON THE
DISK.  THIS IS FAIRLY HEAVY STUFF, BUT YOUR KRACKING ABILITY DEPENDS MORE THAN
ANYTHING ELSE ON YOUR KNOWLEDGE OF THIS SUBJECT.  TRY YOUR BEST TO WORK THROUGH
IT NOW, AND THE REST OF THE PROCESS WILL BE MUCH EASIER.

  WE ALREADY KNOW THAT EACH TRACK CONSISTS OF 16 SECTORS WHICH EACH REPRESENT
ONE PAGE (256 BYTES) OF DATA.  A SECTOR ACTUALLY CONSISTS OF TWO SEPARATE PARTS,
AN ADDRESS FIELD, WHICH TELLS DOS WHICH SECTOR IT IS, AND A DATA FIELD, WHERE
THE ACTUAL BYTES ARE STORED.  TO BEGIN A TRIP AROUND THE DISK, LET'S LOOK FIRST
AT THE BYTE SEQUENCE TAKEN FROM A NORMAL, UNMODIFIED DOS DISK AT TRACK0, SECTOR
0 (AS WE MENTIONED EARLIER, THE TERMS 'BYTE' AND 'NIBBLE' ARE OFTEN USED
INTERCHANGEABLY TO REFER TO THE DATA READ OFF THE DISK.  THE USE OF 'NIBBLE' IS
NOT REALLY ACCURATE IN REFERENCE TO DOS 3.3, BUT PERSISTS FOR HISTORICAL
REASONS).



----FF FF FF FF D5 AA 96 FF FE AA AA ->
	      / \      / \   / \   /
________(1)__/	 \_(2)/   (3)	(4)


->AA AA FF FE DE AA EB FF FF FF FF ----
  \   / \   / \   /    \
   (5)	 (6)   (7)	\_____(8)______


  THE FIRST FEW FF'S (1) ARE KNOWN AS GAPBYTES, BUT THEY'RE CORRECTLY TERMED
SYNCBYTES, AND WE'LL TREAT THEM AS SIMPLE SEPARATORS FOR NOW.  NEXT ARE THE
THREE MOST IMPORTANT BYTES ON THE DISK, D5 AA 96 (2).  THIS SEQUENCE MAY NOT
OCCUR ANYWHERE ELSE ON THE DISK EXCEPT THE ADDRESS FIELD, AND SERVES AS A UNIQUE
IDENTIFICATION MARKER.	THESE BYTES ARE KNOWN BY ALL SORTS OF COLLOQUIALISMS,
INCLUDING "ADDRESS MARKER", "HEADER BYTES", "LEADER BYTES", "PROLOG", AND
OTHERS.  THEY WILL ALWAYS, REPEAT ALWAYS, OCCUR ON AT LEAST SECTOR 0 OF TRACK 0
OF EVERY APPLE DISK WHICH LOADS UNDER DOS 3.3 (THE FIRST LAW DEMANDS IT).

  THE NEXT FOUR SEQUENCES ENCODE THE VOLUME NUMBER (3), TRACK NUMBER (4), SECTOR
NUMBER (5), AND CHECKSUM (6).  EACH NUMBER IS A SINGLE BYTE, WRITTEN IN AN
OLD-STYLE ENCODING SCHEME CALLED 4+4 NIBBLIZING.  THIS IS A FORMAT FOR STORING
DATA ON THE DISK IN WHICH THE EVEN BITS OF A BYTE ARE STORED IN ONE 8-BIT
SEQUENCE (REPRESENTING ONE-HALF OF THE ORIGINAL BYTE OR ONE NIBBLE), AND THE ODD
BITS ARE STORED IN THE SECOND "BYTE" (THE REQUIREMENT FOR THIS SORT OF
"BYTE-SPLITTING" OR NIBBLIZING WAS ESTABLISHED LARGELY BY THE LIMITATIONS
IMPOSED BY DISK DRIVE HARDWARE.  YOU CAN FIND MUCH MORE INFORMATION IN B.  A.
D., PP.  3-12 TO 3-21, BUT AN OVERSIMPLIFICATION IS THAT, IN THE OLD DAYS, AT
LEAST EVERY OTHER BIT READ FROM THE DISK HAD TO BE A LOGICAL "ONE", OR THE
CIRCUITRY THAT READ THE DISK "FORGOT" WHERE IS WAS AND WHAT IT WAS DOING).  IF
YOU ARE INTERESTED IN MORE DETAIL ON THE MECHANICS OF THE 4+4 SCHEME, REFER TO
THE VERY FIRST KRACKING KORNER FILE ON CYCLOD AND THE FILE ON WAY OUT.	THE
TABLE BELOW LISTS THE VALUES OF NIBBLES OF INTEREST TO US IN THIS FORMAT:

FIRST  SECOND BYTE   FIRST  SECOND BYTE
NIBBLE NIBBLE VALUE  NIBBLE NIBBLE VAL.
------ ------ -----  ------ ------ ----

 AA	 AA	0     AA      BA    10
 AA	 AB	1     AA      BB    11
 AB	 AA	2     AB      BA    12
 AB	 AB	3     AB      BB    13
 AA	 AE	4     AA      BE    14
 AA	 AF	5     AA      BF    15
 AB	 AE	6     AB      BE    16
 AB	 AF	7     AB      BF    17
 AE	 AA	8     AE      BA    18
 AE	 AB	9     AE      BB    19
 AF	 AA	A     AF      BA    1A
 AF	 AB	B     AF      BB    1B
 AE	 AE	C     AE      BE    1C
 AE	 AF	D     AE      BF    1D
 AF	 AE	E     AF      BE    1E
 AF	 AF	F     AF      BF    1F

		      BA      AA    20
		      BA      AB    21
		      BB      AA    22

		      FF      FE    FE
			      (VOL#254)

  WE CAN NOW DECODE THE FOUR GROUPS OF BYTES AS:  VOL# 254 (3), TRACK# 0 (4),
SECTOR# 0 (5), AND CHECKSUM $FE (6).  THE FIRST THREE ARE SELF- EXPLANATORY, AND
THE LAST IS USED TO DETECT ANY ERRORS WHICH MAY CREEP IN AFTER MANY HOURS OF
DISK USE.  FOLLOWING THESE IS A SEQUENCE OF BYTES (7) USED TO MARK THE END OF
THE ADDRESS FIELD.  A TOTAL OF THREE BYTES (DE AA EB) ARE WRITTEN TO THE DISK,
BUT ONLY THE FIRST TWO ARE CHECKED WHEN THE FIELD IS READ.  THIS PAIR OF BYTES
IS KNOWN VARIOUSLY AS "CLOSING BYTES", "TRAILERS", OR THE "EPILOG".  FINALLY,
THERE IS ANOTHER SERIES OF GAPBYTES (8) WHICH SEPARATES THE ADDRESS FIELD FROM
THE FOLLOWING DATA FIELD.8

  THE DATA FIELD HAS A SIMILAR STRUCTURE:

----FF FF FF D5 AA AD ----342 BYTES OF
	   / \	    / \
______(1)_/   \_(2)/   \_____(3)____->



DATA----(CKSUM) DE AA EB FF FF FF----
   /	\     / \   /	    \
<-/	 \(4)/	 (5)	     \__(6)__

  WHERE THE GAPBYTES (1) ARE SAME GROUP THAT ENDED THE ADDRESS FIELD.  THE DATA
MARKER BYTES (2) ARE ALSO CALLED BY ALL THE NAMES MENTIONED FOR THE ADDRESS
MARKER, AND ARE INTERPRETED BY DOS AS "HERE COMES THE DATA..." THE BIG STRETCH
OF 342 BYTES (3) IS A VERY COMPLEX WAY OF STORING 256 BYTES ON A DISK, FOLLOWING
SOME COMPROMISES MADE WITH THE ORIGINAL LAWS OF DISK RECORDING.  WITHOUT GOING
INTO EXACTLY WHY, EACH "BYTE" CAN REPRESENT ONLY 6 BITS OF AN ORIGINAL BYTE,
WHICH MEANS THAT EACH BYTE HAS TWO BITS LEFT OVER.  PACKING THESE TOGETHER AT 6
BITS EACH REQUIRES ANOTHER 256/3 OR 86 DISKBYTES, FOR A TOTAL OF 256+86=342
"BYTES", WHICH NO LONGER REPRESENT A NIBBLE OR HALF A BYTE, BUT 3/4 OF A BYTE
(MAKE UP YOUR OWN NAME FOR IT, THERE'S NO REAL AGREEMENT WHAT IT SHOULD BE
CALLED).

  FOLLOWING THE DATA IS A SINGLE CHECKSUM BYTE (4), WHICH WILL GIVE ZERO WHEN
EXCLUSIVE-ORED WITH ALL THE OTHER BYTES FROM THE DATA, AND THEN THE SAME ACTIVE
CLOSING BYTES THAT WERE USED IN THE ADDRESS FIELD (5).	FINALLY, MORE GAPBYTES
(6) PAD THE SPACE BETWEEN THIS DATA FIELD AND THE ADDRESS FIELD WHICH COMES
NEXT.

  THIS SEQUENCE IS REPEATED 15 MORE TIMES TO MAKE A COMPLETE TRACK, AND THERE IS
USUALLY A LARGE "GAP" OF UP TO 128 FF'S SEPARATING THE LAST AND THE FIRST
SECTORS ON THE TRACK.  ONE FINAL ITEM OF INTEREST IS THAT THE SECTORS DO NOT
NORMALLY FOLLOW EACH OTHER IN NUMERICAL SEQUENCE OF 0,1,2...ETC.  THE ACTUAL
SEQUENCE (CALLED "SKEWING" OR INTERLEAVING) IS CHOSEN FOR SPEED OF READING AND
WRITING, AND CAN VARY ON SOME DOS'S WHICH ARE OTHERWISE STRICTLY IDENTICAL IN
FORMAT TO DOS 3.3.

  THIS WOULD BE A GOOD POINT, IF YOU'RE NOT ALREADY VERY COMFORTABLE WITH THE
SEQUENCES DESCRIBED ABOVE, TO GET OUT A UTILITY WHICH WILL PERFORM A "NIBBLE
READ" OF A DISK TRACK (INSPECTOR, NIBBLES AWAY, LOCKSMITH, ETC.), AND READ IN A
STANDARD DOS TRACK.  SCAN THROUGH THE BYTES UNTIL YOU COME TO THE MAGICAL D5 AA
96 SEQUENCE, THEN COMPARE ALL THE BYTES WHICH FOLLOW IT TO THE DESCRIPTION GIVEN
ABOVE.	TRY A FEW TRACKS AND DECODE THE START OF SEVERAL SECTORS UNTIL YOU
BECOME FAMILIAR WITH THE APPEARANCE OF THEM.  YOU'LL SAVE YOURSELF A LOT OF TIME
AND EFFORT BY BECOMING FAMILIAR WITH THE APPEARANCE OF NORMAL DOS SECTORS AND
TRACKS.

  KNOWING THAT ALL THESE THINGS ARE REQUIRED TO MAKE A DISK COMPATIBLE WITH DOS
3.3 (AND MAKE IT COPY WITH COPYA), YOU CAN EASILY SEE HOW TO MAKE A PROTECTED OR
MODIFIED DOS:  SIMPLY CHANGE ALMOST ANY ONE OF THE IMPORTANT BYTES IN EITHER OR
BOTH FIELDS, AND MAKE THE APPROPRIATE CHANGES TO THE READ AND WRITE ROUTINES IN
DOS.  IN ORDER TO APPRECIATE WHAT THIS MEANS, LET'S SPEND A MINUTE OR TWO ON THE
STRUCTURE OF DOS.

  JUST AS WAS GAUL, DOS IS DIVIDED INTO THREE MAIN PARTS.  THE FIRST ONE, CALLED
THE COMMAND INTERPRETER, HAS BEEN DESCRIBED IN CONSIDERABLE DETAIL BY BERT
KERSTHE DISK UNDER ANYTHING RESEMBLING A NORMAL DOS.  AFTER A COMMAND (KEYBOARD
OR PROGRAM) HAS BEEN PROCESSED BY THE COMMAND INTERPRETER, AND THE RIGHT PART OF
THE RIGHT FILE HAS BEEN SELECTED BY THE FILE MANAGER, THE RWTS ROUTINES ARE
CALLED ON TO DO THE CRUCIAL JOB OF EXCHANGING INFORMATION BETWEEN THE APPLE'S
MEMORY AND THE DISKETTE.

  SPACE PREVENTS US FROM LISTING ALL THE ROUTINES, BUT THOSE OF PARTICULAR
INTEREST ARE:


 ADDRESS  NAME		FUNCTION
 -------  ----	  ---------------------
B700-B749 -- DO 2ND STAGE BOOT LOAD, RUN HELLO PROG.

B793-B7B4 RWPAGES READ OR WRITE A GROUP OF PAGES

B7B5-B7C1 CALLRWTS DISABLE INTERRUPT AND CALL RWTS

B7E8-B7F8 IOBLOCK RWTS PARMLIST-SEE B.	A.  D.

B800-B829 PRENIB CONVERT BYTES TO NIB- BLES FOR WRITING

B82A-B8C1 WRITE WRITE SECTOR TO DISK

B8C2-B8DB POSTNIB CONVERT NIBBLES TO BYTES AFTER READING

B8DC-B943 READ READ SECTOR FROM DISK

B944-B99F RDADR READ AN ADDRESS FIELD

B9A0-BA28 SEEKABS POSITION READ HEAD TO THE DESIRED TRACK

BA29-BA68 NIBL WRITE TRANSLATE TABLE

BA69-BA95 (EMPTY) =>WATCH THIS SPACE<=

BA96-BAFF -- READ TRANSLATE TABLE

BB00-BBFF NBUF1 BUFFER (PRIM) USED TO STASH THE NIBBLES

BC00-BC55 NBUF2   SEC. BUFFER FOR NIBLS

BC56-BCC3 WRADR WRITE ADDRESS FIELD (ONLY DURING INIT)

BCDF-BCFF (EMPTY) =>BE SUSPICIOUS<=

BD00-BDEC RWTS	  MAIN READ/WRITE ORGN

BDED-BE03 RDRIGHT GOOD READ, CK TRACK #

BE10-BE25 RTTRK   RIGHT TRK, CK VOL#

BE26-BE45 CRCTVOL RIGHT VOL#, CK SECT#

BEAF-BFB7 DSKFORM INITIALLIZE DISK

BFD8-BFC7 SECMAP  SECTOR INTERLEAVE MAP

BFC8-BFFF PATCHES CORRECTIONS FOR SMALL DOS BUGS =>BEWARE<=
=======================================

AS BEFORE, YOU ARE STRONGLY URGED TO GET AS FAMILIAR AS YOU CAN WITH THESE
ROUTINES, USING DOSSOURCE AND B.  A.  D.  AS YOUR PRIMARY REFERENCES.

RETURNING TO THE SUBJECT OF DETECTING AND CIRCUMVENTING MODIFIED DOS'S, YOU HAVE
A CHOICE.  YOU CAN EITHER LOOK FOR CHANGES BY INSPECTING A TRACK, OR YOU CAN
SEARCH THROUGH THE ABOVE RWTS ROUTINES FOR SOMETHING THAT ISN'T NORMAL.  NEITHER
APPROACH WILL WORK 100% OF THE TIME, SO IT'S BEST TO BECOME PROFICIENT AT BOTH.
THE TABLE BELOW LISTS MOST OF THE CRUCIAL LOCATIONS IN RWTS THAT ARE COMMONLY
CHANGED FOR THE PURPOSE OF PROTECTION.

	NORMAL
ADDRESS VALUE	 USE
------- ------ ------------------------
 B853	  D5   DATA ADDR MARKER 1-WRITE
 B858	  AA   DATA ADDR MARKER 2-WRITE
 B85D	  AD   DATA ADDR MARKER 3-WRITE
 B89E	  DE   EPILOG BYTE 1
 B8A3	  AA   EPILOG BYTE 2
 B8A8	  EB   EPILOG BYTE 3-NOT READ
 B8AC	  FF   EPILOG BYTE 4-NOT READ
 B8E7	  D5   DATA ADDR MARKER 1-READ
 B8F1	  AA	 "   "     "    2   "
 B8FC	  AD	 "   "     "    3   "
B92A-C D9 00 BA LOCATION FOR CHECKSUM
		COMPARE

 B935	  DE   EPILOG BYTE 1-READ
 B93F	  AA   EPILOG BYTE 2-READ

 B942	  38   SET CARRY FOR I/O ERROR

 B955	  D5   ADDR DATA MARKER 1-READ
 B95F	  AA	 "    "     "   2  "
 B96A	  96	 "    "     "   3  "

 B991	  DE   ADDR EPILOG BYTE 1
 B99B	  AA   ADDR EPILOG BYTE 2

BA29-68   *    WRITE TRANSLATE TABLE

BA96-FF   *    READ TRANSLATE TABLE

 BC5F	  FF   SYNC BYTE VALUE

 BC7A	  D5   ADDR MARKER WRITE-1
 BC7F	  AA   ADDR MARKER WRITE-2
 BC84	  96   ADDR MARKER WRITE-3

 BCAE	  DE   ADDR EPILOG BYTE 1-WRITE
 BCB3	  AA	 "     "     "  2   "
 BCB8	  EB	 "     "     "  3   "

BFB8-C7   *    SECTOR INTERLEAVING
	       TABLE

* SEE DOSSOURCE LISTING FOR CORRECT CONTENTS.

ANY OF THE LOCATIONS ABOVE CAN BE MODIFIED, EITHER PERMANENTLY (WHICH CHANGES IN
THE DOS IMAGE ON TRACKS 0-2), OR TEMPORARILY.  THE TEMPORARY DOS CHANGES ARE
MUCH TOUGHER TO FIND THAN THE PERMANENT ONES, SINCE THE CHANGES MAY BE ERASED
AFTER THEY HAVE BEEN USED.  A GOOD EXAMPLE OF THIS WAS 'MASK OF THE SUN' AND
'THE SERPENT'S STAR', WHERE THE MAIN DISK IS PROTECTED (AMONG OTHER TECHNIQUES)
BY USING FF'S FOR ALL THE EPILOG BYTES, BUT THE SAVE GAME IS WRITTEN OUT AND
READ IN USING THE NORMAL DE AA'S.  A PAIR OF SUBROUTINES WAS CALLED TO SWAP THE
BYTES IN AND OUT AS REQUIRED.  MUCH MORE DEVIOUS WAS THE PROTECTION SCHEME USED
BY TSR ON 'COMPUTER DUNGEON' AND 'THESEUS AND THE MINOTAUR', WHERE EPILOG BYTES
WERE COMPUTED ACCORDING TO WHICH TRACK WAS BEING READ.

THERE ARE MANY OTHER EXAMPLES OF DOS MODIFICATIONS USED TO KEEP US AT BAY,
INCLUDING SOME SECONDARY PROTECTION TECHNIQUES, BUT WE'LL LOOK AT THOSE AFTER WE
DESCRIBE THE BASIC APPROACHES TO UNPROTECTING THESE DISKS IN PART 5 OF THE
BASICS OF KRACKING.  IN THE MEANTIME, STUDY THE FORMAT, BECOME FAMILIAR WITH THE
STANDARD TRICKS, AND REMEMBER:


"THE NIGHT SHALL BE FILLED WITH MUSIC,
     AND CARES THAT INFEST THE DAY,
 SHALL FOLD THEIR TENTS LIKE THE ARABS,
     AND AS SILENTLY, STEAL AWAY."


	    -HENRY WADSWORTH LONGFELLOW

---------------------------------------
***************************************
*				      *
*				      *
*    KRAKOWICZ'S KRACKING KORNER      *
*				      *
*				      *
*      THE BASICS OF KRACKING 5       *
*				      *
* UNPROTECTION OF MODIFIED DOS DISKS  *
*				      *
*				      *
***************************************


  IN EPISODE 4 OF THIS SERIES, WE BEGAN A DISCUSSION OF PROTECTION SCHEMES WHICH
ARE BASED ON MODIFICATION OF A STANDARD APPLE DOS.  AS WE MENTIONED, THERE ARE
MANY CHANGES WHICH CAN BE MADE, AND LITERALLY THOUSANDS OF COMBINATIONS OF WHICH
CAN BE USED TO THWART THE STANDARD COPY PROGRAMS.  HOWEVER, RATHER THAN DWELLING
ON ALL THE POSSIBLE TECHNIQUES, LET'S CONCENTRATE ON THE "SHOTGUN" APPROACH
WHICH WORKS TO THE VAST MAJORITY.

  REGARDLESS OF THE MODIFICATION TECHNIQUE USED, MOST OF THESE DISKS CAN BE
RENDERED COPYABLE WITH SOME UTILITY PROGRAMS (BOTH OLD AND NEW).

  IN GENERAL, IT IS POSSIBLE TO IDENTIFY DISKS WITH A MODIFIED DOS BY THE
APPEARANCE OF A BASIC PROMPT AT THE BOTTOM OF THE SCREEN DURING THE BOOT.  SOME
PROTECTORS HAVE BEGUN TO BYPASS THE ROUTINE WHICH OUTPUTS THE PROMPT, BUT YOU
CAN STILL GUESS THAT THERE'S A MODIFIED DOS PRESENT IF THE BOOT SOUNDS LIKE A
NORMAL DOS BOOT, BUT THE DISK WON'T COPY WITH COPYA (COMPARING THE SOUNDS MADE
BY THE BOOT UNDER DIFFERENT PROTECTION SCHEMES CAN BE VERY VALUABLE AFTER YOU
HAVE A FAIR AMOUNT OF EXPERIENCE WITH A GIVEN PUBLISHER AND HIS PROTECTION
SCHEME.  IT CAN ALSO BE MISLEADING; I KNOW A LOT OF PEOPLE WHO SWORE THE LONG
HEAD MOVE DURING THE BOOT OF THE SSI RDOS DISKS WAS A NIBBLE COUNT, WHILE IT
TURNED OUT TO BE NOTHING MORE THAN LOADING IN A SHORT PROGRAM CALLED "QWERTY"
FROM TRACK 18-22).

  THE CLASSIC PROGRAM FOR DEALING WITH MODIFIED DOS'S IS CALLED DEMUFFIN PLUS
(WILL THE REAL AUTHOR PLEASE STEP FORWARD SOMEDAY TO ACCEPT THE THANKS OF THE
ENTIRE WORLD OF SOFTWARE UNPROTECTORS?), AND IT WORKS IN MUCH THE SAME WAY AS
APPLE'S MUFFIN PROGRAM.  MUFFIN WAS WRITTEN TO READ FILES FROM A DOS 3.2 DISK
AND THEN WRITE THEM OUT IN 3.3 FORMAT.	DEMUFFIN (AND A SIMILAR PRODUCT CALLED
"NIFFUM") WERE WRITTEN TO CONVERT DOS 3.3 PROGRAMS TO 3.2 FOR THE REAL DIEHARDS.
DEMUFFIN PLUS OPERATES ON THE SAME PRINCIPLE, BUT USES WHATEVER DOS IS IN MEMORY
TO READ, THEN WRITES OUT TO AN INITIALLIZED DISK UNDER 3.3 FORMAT.  WHILE THIS
IS A POWERFUL UTILITY, YOU MUST KEEP IN MIND THAT IT IS STRICTLY BASED ON DOS,
AND WILL ONLY TRANSFER PROGRAMS WHICH CAN BE LOCATED FROM A CATALOG AS NORMAL
TEXT, BINARY, INTEGER OR APPLESOFT FILES.

  IT IS SAFE TO SAY THAT MORE SOFTWARE HAS BEEN UNPROTECTED WITH THIS UTILITY
THAN WITH ANY OTHER, AND PROBABLY MORE THAN WITH ALL OTHERS COMBINED.  IT STILL
FINDS FREQUENT APPLICATION TODAY, SO WE'LL TAKE A LITTLE TIME HERE TO DESCRIBE
SEVERAL WAYS OF USING IT.

  IN MOST CASES, THE CLASSICAL TECHNIQUE WHICH FOLLOWS FOR USING DEMUFFIN PLUS
TO KRACK A MODIFIED DOS DISK IS RESTRICTED TO THOSE WITH AN APPLE II (NOT A II+)
OR A ROMCARD OR OTHER MODIFED F8 ROM WHICH ALLOWS YOU TO RESET INTO THE MONITOR
(SEE THE BASICS OF KRACKING 1):

  1.  INITIALLIZE A DISK UNDER DOS 3.3, THEN DELETE THE HELLO PROGRAM (JUST TO
BE SAFE).

  2.  BLOAD DEMUFFIN PLUS, A$6000.

  3.  BOOT THE PROTECTED DISK, AND AS SOON AS A PROMPT APPEARS, HIT RESET
(GENERALLY ABOUT 3-4 SECONDS AFTER THE HEAD CLACKETY-CLACK).

  4.  FROM THE MONITOR, MOVE DEMUFFIN PLUS TO ITS NORMAL LOCATION WITH
803<6000.78FFM.

  5.  TYPE 803G AND FOLLOW THE FAMILIAR FIDDISH INSTRUCTIONS FOR SLOT AND DRIVE
USAGE.

  6.  IF YOU WANT THE DISK TO AUTORUN FROM THE BOOT, DETERMINE THE NAME OF THE
HELLO PROGRAM AND ENTER IT INTO TRACK 1, SECTOR 9, BYTES 75-92 WITH THE
INSPECTOR (OTHERWISE THE DISK WILL ALWAYS LOOK FOR AN ACTUAL PROGRAM NAMED
'HELLO').  IF THE HELLO PROGRAM HAPPENS TO BE A BINARY FILE, CHANGE BYTE 42 IN
TRACK 0, SECTOR D TO $34, OR USE $14 TO EXEC A TEXT FILE FOR THE START.

  IN ADDITION TO HIDING THE PROMPT, A NUMBER OF PUBLISHERS HAVE ADDED ROUTINES
WHICH CLEAR OUT MEMORY DURING THE BOOT, OR LOOK FOR SPECIFIC DATA LOADED IN
PREVIOUSLY (THE PLATO SERIES IS A GOOD EXAMPLE OF THIS--WITHOUT EXTENSIVE AND
CAREFUL BOOT TRACING, IT IS VERY DIFFICULT TO GET THE DOS IN MEMORY INTACT).
THE FOLLOWING APPROACH ELIMINATES THE NEED TO RESET INTO THE MONITOR, AND ALSO
GETS AROUND MANY OF THE ROUTINES BEING ADDED TO THWART THOSE WHO WOULD RESET.
BECAUSE THERE IS NO NEED TO RESET DURING THE BOOT, THIS APPROACH CAN BE USED ON
ANY FLAVOR OF APPLE ][ (YES, NIBBLESPOCK, EVEN ON A IIE).  BASICALLY, THE
DIFFERENCE LIES IN USING THE COMMAND INTERPRETER AND FILE MANAGER PORTIONS OF A
STANDARD DOS, AND ADDING TO IT THE MODIFIED RWTS FROM THE PROTECTED DISK:

1. INITIALLIZE A DISK AS BEFORE.

  2.  BOOT UP A STANDARD DOS DISK, AND BLOAD DEMUFFIN PLUS,A$4000 (JUST TO BE
SAFE).

  3.  UNLESS YOU HAVE INSPECTOR IN ROM, BLOAD INSPECTOR,A$8800.

  4.  USING THE INSPECTOR, READ TRACK 0, SECTOR 1 THROUGH TRACK 0, SECTOR 9 INTO
$7700 TO $7FFF.  USE CONTROL-I AFTER THE FIRST 'R' COMMAND TO SPEED THE LOAD
(SEE THE SECTION BELOW ON CHANGING LOCATION $B942 IF YOU CAN'T READ THE SECTORS
WITH THE INSPECTOR).

  5.  GET INTO THE MONITOR, THEN MOVE THE RWTS THAT YOU JUST READ IN ON TOP OF
THE RESIDENT RWTS WITH B700<7700.7FFFM.

  6.  MOVE DEMUFFIN AS BEFORE WITH 803<4000.58FFM.

  7.  TYPE 803G AND PROCEED WITH THE FILE TRANSFER.

  THERE ARE A FEW CASES WHERE JUST A LITTLE MORE INTELLIGENCE IS USED TO MODIFY
DOS AFTER THE PROGRAM BEGINS TO RUN (USUALLY THE MODIFICATION OF PROLOG/EPILOG
BYTES, BUT SOMETIMES A LITTLE BIT MORE), AND IN THIS CASE YOU HAVE TO BOOT THE
DISK AND LET IT RUN A SECOND OR TWO BEFORE RESETTING.  THE INSPECTOR IN ROM IS A
BIG HELP IN A CASE LIKE THIS:  YOU CAN RESET AND SCAN THE ENTIRE DISK WITH THE
'SHIFT +' KEYS TO SEE IF ALL THE SECTORS CAN BE READ WITH THE DOS CURRENTLY IN
THE SYSTEM.  IF THEY CAN BE, CHANCES ARE GOOD THAT YOU WILL BE SUCCESSFUL WITH
THE CONVERSION.  AFTER RESETTING, SAVE THE ENTIRE DOS WITH D00<9D00.BFFFM, THEN
BOOT UP YOUR STANDARD DISK AND BLOAD DEMUFFIN PLUS.  PUT THE MODIFIED DOS BACK
WITH 9D00<D00.2FFFM, AND PROCEED WITH STEPS 6 AND 7 ABOVE.

  ASSUMING THAT THE ORIGINAL COPY WAS GOOD, AND THAT NO SECONDARY PROTECTION WAS
USED, YOU SHOULD NOW HAVE A COPYA VERSION OF THE PROGRAM.  IN MANY CASES, IT'S
POSSIBLE TO DO THE JOB WITH EVEN LESS HASSLE THAN THIS, SO LET'S LOOK AT WHAT IS
(MAYBE) AN EVEN EASIER WAY.

  MANY OF THE RWTS MODIFICATIONS ARE FAIRLY TRIVIAL, AND THE MOST COMMON CONSIST
ONLY OF CHANGING THE PROLOG OR EPILOG BYTES FOR THE ADDRESS OR DATA FIELD.  YOU
CAN OFTEN PRODUCE AN UNPROTECTED VERSION OF THESE DISKS BY MAKING A FEW-BYTE
CHANGE TO THE RWTS IN MEMORY, AND THEN RUNNING COPYA.  THE FOLLOWING DISASSEMBLY
CONTAINS THE ROUTINES WHICH READ IN THE ADDRESS AND DATA FIELDS, AND WHICH NEED
TO BE MODIFIED TO CIRCUMVENT A LARGE NUMBER OF RWTS CHANGE SCHEMES:

B8DC-	A0 20	    LDY   #$20
B8DE-	88	    DEY
B8DF-	F0 61	    BEQ   $B942
B8E1-	BD 8C C0    LDA   $C08C,X
B8E4-	10 FB	    BPL   $B8E1
B8E6-	49 D5	    EOR   #$D5
B8E8-	D0 F4	    BNE   $B8DE
B8EA-	EA	    NOP
B8EB-	BD 8C C0    LDA   $C08C,X
B8EE-	10 FB	    BPL   $B8EB
B8F0-	C9 AA	    CMP   #$AA
B8F2-	D0 F2	    BNE   $B8E6
B8F4-	A0 56	    LDY   #$56
B8F6-	BD 8C C0    LDA   $C08C,X
B8F9-	10 FB	    BPL   $B8F6
B8FB-	C9 AD	    CMP   #$AD
B8FD-	D0 E7	    BNE   $B8E6

B8FF-	A9 00	    LDA   #$00
B901-	88	    DEY
B902-	84 26	    STY   $26
B904-	BC 8C C0    LDY   $C08C,X
B907-	10 FB	    BPL   $B904
B909-	59 00 BA    EOR   $BA00,Y
B90C-	A4 26	    LDY   $26
B90E-	99 00 BC    STA   $BC00,Y
B911-	D0 EE	    BNE   $B901
B913-	84 26	    STY   $26
B915-	BC 8C C0    LDY   $C08C,X
B918-	10 FB	    BPL   $B915
B91A-	59 00 BA    EOR   $BA00,Y
B91D-	A4 26	    LDY   $26
B91F-	99 00 BB    STA   $BB00,Y
B922-	C8	    INY
B923-	D0 EE	    BNE   $B913

B925-	BC 8C C0    LDY   $C08C,X
1928-	10 FB	    BPL   $B925
B92A-	D9 00 BA    CMP   $BA00,Y
B92D-	D0 13	    BNE   $B942
B92F-	BD 8C C0    LDA   $C08C,X
B932-	10 FB	    BPL   $B92F
B934-	C9 DE	    CMP   #$DE
B936-	D0 0A	    BNE   $B942
B938-	EA	    NOP
B939-	BD 8C C0    LDA   $C08C,X
B93C-	10 FB	    BPL   $B939
B93E-	C9 AA	    CMP   #$AA
B940-	F0 5C	    BEQ   $B99E
B942-	38	    SEC
B943-	60	    RTS
B944-	A0 FC	    LDY   #$FC
B946-	84 26	    STY   $26
B948-	C8	    INY
B949-	D0 04	    BNE   $B94F
B94B-	E6 26	    INC   $26
B94D-	F0 F3	    BEQ   $B942

B94F-	BD 8C C0    LDA   $C08C,X
B952-	10 FB	    BPL   $B94F
B954-	C9 D5	    CMP   #$D5
B956-	D0 F0	    BNE   $B948
B959-	BD 8C C0    LDA   $C08C,X
B95C-	10 FB	    BPL   $B959
B95E-	C9 AA	    CMP   #$AA
B960-	D0 F2	    BNE   $B954
B962-	A0 03	    LDY   #$037
B964-	BD 8C C0    LDA   $C08C,X
B967-	10 FB	    BPL   $B964
B969-	C9 96	    CMP   #$96
B96B-	D0 E7	    BNE   $B954

B96D-	A9 00	    LDA   #$00
B96F-	85 27	    STA   $27
B971-	BD 8C C0    LDA   $C08C,X
B974-	10 FB	    BPL   $B971
B976-	2A	    ROL
B977-	85 26	    STA   $26
B979-	BD 8C C0    LDA   $C08C,X
B97C-	10 FB	    BPL   $B979
B97E-	25 26	    AND   $26
B980-	99 2C 00    STA   $002C,Y
B983-	45 27	    EOR   $27
B985-	88	    DEY
B986-	10 E7	    BPL   $B96F
B988-	A8	    TAY
B989-	D0 B7	    BNE   $B942

B98B-	BD 8C C0    LDA   $C08C,X
B98E-	10 FB	    BPL   $B98B
B990-	C9 DE	    CMP   #$DE
B992-	D0 AE	    BNE   $B942
B994-	EA	    NOP
B995-	BD 8C C0    LDA   $C08C,X
B998-	10 FB	    BPL   $B995
B99A-	C9 AA	    CMP   #$AA
B99C-	D0 A4	    BNE   $B942
B99E-	18	    CLC
B99F-	60	    RTS


  BEFORE WE GET INTO ALTERATIONS OF THIS CODE, LET'S GET FAMILIAR WITH THE
TERRAIN.  THERE ARE TWO SUBROUTINES:  'READ', WHICH READS IN A SECTOR OF DATA
AND LIVES FROM $B8DC TO $B943; AND 'RDADR', WHICH READS IN THE ADDRESS FIELD FOR
A SECTOR FROM $B944 TO B99F.  NOTE THAT THESE ARE IN THE REVERSE ORDER OF THEIR
USE IN READING A SECTOR.  LET'S LOOK FIRST AT RDADR:  AFTER SETTING UP SOME
PRELIMINARIES AT $B944-$B94E, WE BEGIN TO LOOK ($B94F-$B96C) FOR THE THREE
FAMOUS BYTES OF D5 AA 96 TO IDENTIFY THE START OF THE FIELD.  AFTER THEY ARE
FOUND, THE VOLUME NUMBER, TRACK NUMBER, AND SECTOR NUMBER ARE STORED IN
LOCATIONS $2F, $2E, AND $2D, RESPECTIVELY, AND THE CHECKSUM FOR THE ADDRESS
FIELD IS VERIFIED ($B96D-$B98A).  FINALLY, THE TWO EPILOG BYTES OF DE AND AA ARE
SOUGHT AT THE END OF THE FIELD ($B98B- $B99F).

  AFTER AN ADDRESS FIELD IS SUCCESSFULLY READ, 'READ' IS EXECUTED TO READ IN THE
DATA FIELD.  THE CODE FROM $B8DC TO $B8FE FINDS THE HEADER BYTES OF D5 AA AD,
AND THE DATA SECTOR IS READ INTO A PAIR OF BUFFERS WITH THE CODE AT $B8FF-B924
(THE "NIBBLIZING" PROCESS STORED THE 256 BYTES FROM A PAGE OF MEMORY AS A TOTAL
OF 342 "NIBBLES" IN THE SECTOR, BUT LET'S NOT GET TOO WORRIED ABOUT THAT YET).
FINALLY, THE CHECKSUM (ONE BYTE) IS CHECKED, AND THE EPILOG BYTES ARE ONCE AGAIN
VERIFIED ($B925-$B941).  NOTICE THE INNOCENT-APPEARING "SEC RTS" AT B942-B943.
THIS IS THE HEART OF THE ERROR-DETECTION PROCESS, AND MOST FREQUENTLY MODIFIED
(FOR OUR PURPOSES) PART OF THE ENTIRE ROUTINE.

  THE ONE BYTE WHICH YOU SHOULD BECOME MOST FAMILIAR WITH IN ORDER TO DO ANY
KRACKING, SNOOPING, OR DISK REPAIR IS THE $38 AT LOCATION $B942.  THE CARRY BIT
(OF THE PROCESSOR STATUS WORD) IS USED THROUGHOUT THE RWTS ROUTINES TO INDICATE
A DISK I/O ERROR.  WHENEVER ANYTHING GOES WRONG, THE ROUTINES BRANCH TO $B942 TO
SET THE CARRY AND RETURN.  THE OTHER ROUTINES IN RWTS MONITOR THE CARRY BIT, AND
CHECK IT TO SEE IF THERE WAS A BAD ADDRESS READ, A BAD DATA READ, NO HEADER
BYTES, WRONG EPILOG BYTES, ETC., ETC.

 => THE MOST IMPORTANT CHANGE YOU <=
 => CAN LEARN TO MAKE IS CHANGING <=
 => $B942 TO $18 (OR, IF YOU ARE  <=
 => HOPELESSLY BASIC-BOUND, POKE  <=
 => 47426,24).			  <=

  THE $18 IS 'CLC' OR 'CLEAR THE CARRY'.  BY CHANGING IT, YOU ARE SAYING TO THE
RWTS ROUTINES:	"DON'T EVEN LOOK TO SEE IF THERE WERE ANY ERRORS.  ASSUME
EVERYTHING IS ALL RIGHT AND GO ON".  THIS IS OBVIOUSLY NOT A GOOD GENERAL
PROGRAMMING PRACTICE, SINCE YOU'RE DEFEATING ALL OF THE CAREFUL ERROR- CHECKING
THAT DOS DOES, BUT IT'S VERY HANDY TO ALLOW COPYING OF A MODIFIED DOS.  IT WILL
GENERALLY HANDLE CHANGES IN THE EPILOG BYTES OR INTENTIONAL ERRORS IN THE
CHECKSUM OF EITHER FIELD, BUT NOT IN THE HEADER BYTES.	HEADER CHANGES (BECAUSE
THE BYTES ARE INDIVIDUALLY CHECKED FOR) MUST BE DONE BY MODIFYING THE
APPROPRIATE CODE IN THE SUBROUTINE.  IN MANY CASES, THIS IS THE ONLY CHANGE
WHICH WILL BE REQUIRED TO MAKE A COPYA VERSION OF THE DISK.

  FOR INSTANCE, LET'S SUPPOSE YOU ARE TRYING TO KRACK A PROGRAM, AND YOU SUSPECT
THAT THE PROTECTION CONSISTS OF A MODIFIED DOS.  READ IN AN ENTIRE TRACK WITH
THE INSPECTOR OR NIBBLES AWAY II (THERE IS A BUG IN THE SHIFT-N COMMAND IN SOME
VERSIONS OF THE INSPECTOR--YOU CAN'T DO A NIBBLE READ ON ANOTHER TRACK UNLESS
YOU FIRST NIBBLE-READ IN TRACK ZERO).  EXAMINE AN ADDRESS FIELD AND ITS DATA
FIELD.	IF YOU FIND BOTH 'D5 AA 96' AND 'D5 AA AD', THEN REMOVE THE DISK AND
BOOT UP COPYA.	WHILE THE PROGRAM IS ASKING FOR THE SLOT AND DRIVE INFORMATION,
PRESS RESET OR TYPE CTRL-C.  DELETE LINE 70 (LINE 90 IF YOU ARE USING THE
INTEGER VERSION CALLED "COPY"), THEN FROM THE MONITOR CHANGE

	   *B942:18

  RE-ENTER BASIC AND RUN THE PROGRAM.  CHANCES ARE VERY GOOD THAT THE RESULT
WILL BE A COPYA VERSION OF THE DISK.  BE AWARE, HOWEVER, THAT YOU CAN PROPAGATE
OR GENERATE ERRORS IN THIS PROCESS, SINCE ALL OF THE ERROR-CHECKING IN RWTS HAS
BEEN TURNED OFF.  AS ALWAYS, CHECK THE PROGRAM OUT THOROUGHLY AFTER KRACKING.

  IF YOUR EARLIER SNOOPING REVEALED NON-STANDARD HEADER BYTES, MAKE THE CHANGES
LISTED BELOW AFTER RUNNING AND INTERRUPTING COPYA:

  ADDRESS FIELD: $B955 - BYTE #1
		  B95F - BYTE #2
		  B96A - BYTE #3

     DATA FIELD:  B8E7 - BYTE #1
		  B8F1 - BYTE #2
		  B8FC - BYTE #3


  THEN PROCEED AS DESCRIBED EARLIER.

  REGARDLESS OF WHETHER YOU MAKE THESE SIMPLE MODS, OR GO THROUGH THE DEMUFFIN
PLUS PROCESS, BEAR IN MIND THAT SECONDARY PROTECTION SCHEMES CAN DEFEAT THESE
ATTEMPTS AND REQUIRE YOU TO DO MUCH MORE IN THE WAY OF SNOOPING AND UNDOING.
WE'LL PICK UP WITH A DISCUSSION OF THOSE TECHNIQUES NEXT TIME, AND PERHAPS BEGIN
TO EXPLORE SOME NON-STANDARD DISK FORMATS.

  OUR QUOTATION OF THE WEEK (MONTH?) IS FROM DON LANCASTER, IN THE INTRODUCTION
TO HIS BOOK "ENHANCING YOUR APPLE II, VOL.  1" (A SEMI-GOOD BUT SERIOUSLY
"STRETCHED" COMPILATION OF LITTLE HARDWARE TRICKS TO MAKE YOUR APPLE DO NEW
THINGS):

  "ANY ATTEMPT AT COPY PROTECTION WILL HACK OFF AND INCONVENIENCE YOUR
LEGITIMATE USERS, AND IT WILL DRAMATICALLY INCREASE THE NUMBER OF BOOTLEG COPIES
IN CIRCULATION...

  "THE BIG THING ABOUT COPY PROTECTION IS THAT IT DOESN'T.  A YEAR'S EFFORT BY A
CRACKERJACK MILITARY CRYPTOGRAPY TEAM CAN USUALLY BE UNDONE IN FIFTEEN MINUTES,
BETWEEN KLINGON ZAPPINGS, BY YOUR AVERAGE FOURTEEN- YEAR-OLD.  AND, MORALITY AND
ECONOMICS ASIDE, ONE FACT STANDS OUT...

  UNDOING COPY PROTECTION IS FUN!

  "NOT ONLY IS IT FUN, BUT CRACKING THE UNCOPYABLE IS ABOUT THE MOST CHALLENGING
AND REWARDING THING THAT YOU CAN POSSIBLY DO WITH YOUR APPLE.  AND, THE THINGS
YOU LEARN ALONG THE WAY ARE EXACTLY THE SKILLS THAT YOU WILL NEED TO BECOME A
REALLY GREAT PROGRAMMER.  SO, I GUESS WE SHOULD ALL BE THANKFUL FOR THE
COPY-PROTECTION PEOPLE SINCE THEY ARE ARE GIVING US ALL THIS FASCINATING
ENTERTAINMENT AND SUPERB TRAINING AT AN UNBEATABLE PRICE."

  BEAUTIFULLY PUT, DON; AN EXCELLENT RENDITION OF THE "KRACKIST'S MANIFESTO".

---------------------------------------
***************************************
*				      *
*     KRAKOWICZ'S KRACKING KORNER     *
*				      *
*				      *
*     THE BASICS OF KRACKING 106      *
*				      *
*  MATING ZONE & NIBBLIZING MYSTERIES *
*				      *
*				      *
***************************************


  CONGRATULATIONS ARE DUE TO TOM LUHRS AND THE PEOPLE AT DATAMOST, FOR PROVIDING
BOTH AN ENJOYABLE GAME AND AN ENJOYABLE CHALLENGE IN KRACKING THEIR LATEST
OFFERING:  "MATING ZONE".  THE GAME IS DEFINITELY ABOVE AVERAGE FOR A
SHOOT-EM-UP, WITH A NOVEL CONCEPT AND GOOD VARIETY IN THE BEHAVIOUR OF MATED
PAIRS, EXPLODING EGGS, AND MULTIPLE LEVELS.  THE KRACK IS A LITTLE MORE
DIFFICULT THAN THE MODIFIED DOS'S WE HAVE BEEN DISCUSSING, BUT WE ARE STILL
DEALING WITH A RELATIVELY STANDARD RWTS.

  AS SUPPLIED, THE GAME CAN BE COPIED WITH NIBBLES AWAY II (NO PARMS NEEDED) FOR
TRACKS 0-F AND 10.5 TO 13.5.  EXCEPT FOR THE HALF TRACKING, THE ONLY DEVIATION
FROM NORMAL DOS 3.3 SECTOR STRUCTURE IS AN EPILOG OF 'DF AA' INSTEAD OF THE
NORMAL 'DE AA', FOR BOTH THE ADDRESS AND DATA FIELDS.  THE DISK ACCESS IS
CONTROLLED BY AN ABBREVIATED RWTS LOADED ACROSS SCREEN MEMORY, WITH A CUTE
LITTLE SURPRISE AT THE END.  I'LL START WITH A SYNOPSIS OF THE KRACKING PROCESS,
AND EXPLAIN THE JUICY PARTS IN DETAIL LATER.  THE DESCRIPTION WILL BE LIMITED TO
REDUCING THE GAME TO A COPYA DISK; HOWEVER, I STRONGLY SUSPECT THAT THE GAME CAN
BE STUFFED INTO A SINGLE LONG BFILE (I KNOW, I THOUGHT THAT SIGMA 7 COULD BE,
TOO, BUT THAT'S ANOTHER STORY FOR A LATER TIME).

  THE KRACKING SEQUENCE IS TO FIRST RELOCATE THE HALF-TRACKS, THEN ELIMINATE THE
SECONDARY PROTECTION.  AMONG OTHER UTILITIES, NIBBLES AWAY II CAN BE USED FOR
THE MOVE AS FOLLOWS:

  1.  BOOT NA II AND COPY TRACKS 0-F ONTO AN INITIALIZED DISK (YOU'LL WANT THE
      OTHER TRACKS COPYABLE LATER).

  2.  SELECT THE TRACK/BIT EDITOR (T), THEN READ IN TRACK 10.5.  TYPE 'Z' TO
      ALLOW NA II TO ANALYZE THE TRACK FOR WRITE-OUT.

  3.  CHANGE THE TRACK TO 10 EVEN, THEN INSERT THE COPY DISK.  TYPE 'W' TO
      WRITE, THEN 'Y' TO CONFIRM.  WHAT WAS ON TRACK 10.5 OF THE ORIGINAL IS NOW
      ON TRACK 10 OF YOUR COPY.

  4.  REPEAT STEPS 2 & 3 FOR TRACKS 11.5, 12.5, AND 13.5.

  5.  TELL THE PROGRAM THAT THE TRACKS HAVE BEEN CHANGED BY MODIFYING TRACK
      1,SECTOR F, BYTE 19 FROM $1F TO $1E.

  6.  CORRECT THE EPILOG BYTE CHECK BY CHANGING $DF TO $DE IN BYTES 35 AND AB OF
      T0,S5; AND BYTE 9B OF T0,SD.

  7.  ELIMINATE THE SECONDARY PROTECTION AND THE HIGH SCORE WRITE TO DISK BY
      CHANGING THE FOLLOWING BYTES:


   T0 S5 BYTES E8-EA CHANGE TO 4C B5 04
   T4 SC  BYTE 38    CHANGE TO 60

  8.  LOAD UP COPYA, DEFEAT THE CHECKSUM BY CHANGING $B942 TO $18, THEN MAKE A
      COPY OF THE DISK.

  9.  BOOT AND ENJOY.


  THAT'S THE PROCEDURE, NOW LET'S GO OVER THE THEORY:  NORMALLY, RWTS OCCUPIES
THE MEMORY SPACE FROM $B700 TO $BFFF.  IN ORDER TO SQUEEZE IT INTO $400-7FF,
COMPROMISES MUST BE MADE.  FIRST, A MINIUMUM OF ONE COMPLETE TRACK IS READ IN,
AND THE SECTORS ARE DESTINED FOR SEQUENTIAL PAGES IN MEMORY, BUT WITHOUT THE
INTERLEAVING USED BY DOS 3.3.  TRACKS ARE REFERRRED TO BY THE EQUIVALENT NUMBER
OF HALF-TRACKS:  TRACK 6 IS C, F IS 1E, 10.5 IS 21, ETC.  THE TRACK READ ROUTINE
INCREMENTS THE TRACK NUMBER BY TWO, THEN READS IN THE 16 SECTORS OF THE NEW
TRACK.	EXAMINING THE CODE FROM $4DC-55D SHOWS A NORMAL DATA FIELD READ ROUTINE
WITH STANDARD POST-NIBBLIZING TO RECONSTRUCT THE ORIGINAL BYTES:


04DC-	A0 20	    LDY   #$20
04DE-	88	    DEY
04DF-	F0 7B	    BEQ   $055C
04E1-	AD EC C0    LDA   $C0EC
04E4-	10 FB	    BPL   $04E1
04E6-	49 D5	    EOR   #$D5
04E8-	D0 F4	    BNE   $04DE
04EA-	EA	    NOP
24EB-	AD EC C0    LDA   $C0EC *
04EE-	10 FB	    BPL   $04EB
04F0-	C9 AA	    CMP   #$AA
04F2-	D0 F2	    BNE   $04E6
04F4-	A0 56	    LDY   #$56
04F6-	AD EC C0    LDA   $C0EC *
04F9-	10 FB	    BPL   $04F6
04FB-	C9 AD	    CMP   #$AD
04FD-	D0 E7	    BNE   $04E6
04FF-	A9 00	    LDA   #$00
0501-	88	    DEY
0502-	84 26	    STY   $26
0504-	AC EC C0    LDY   $C0EC *
0507-	10 FB	    BPL   $0504
0509-	59 00 07    EOR   $0700,Y
050C-	A4 26	    LDY   $26
050E-	99 00 03    STA   $0300,Y
0511-	D0 EE	    BNE   $0501
0513-	84 26	    STY   $26
0515-	AC EC C0    LDY   $C0EC *
0518-	10 FB	    BPL   $0515
051A-	59 00 07    EOR   $0700,Y
051D-	A4 26	    LDY   $26
051F-	99 00 02    STA   $0200,Y
0522-	C8	    INY
0523-	D0 EE	    BNE   $0513
0525-	AC EC C0    LDY   $C0EC *
0528-	10 FB	    BPL   $0525
052A-	D9 00 07    CMP   $0700,Y
052D-	D0 2D	    BNE   $055C
052F-	AD EC C0    LDA   $C0EC *
0532-	10 FB	    BPL   $052F
0534-	C9 DF	    CMP   #$DF
0536-	D0 24	    BNE   $055C
0538-	EA	    NOP
0539-	AD EC C0    LDA   $C0EC *
053C-	10 FB	    BPL   $0539
053E-	C9 AA	    CMP   #$AA
0540-	D0 1A	    BNE   $055C
0542-	A0 00	    LDY   #$00
0544-	A2 56	    LDX   #$56
0546-	CA	    DEX
0547-	30 FB	    BMI   $0544
0549-	B9 00 02    LDA   $0200,Y
054C-	5E 00 03    LSR   $0300,X
054F-	2A	    ROL
0550-	5E 00 03    LSR   $0300,X
0553-	2A	    ROL
0554-	99 00 3F    STA   $3F00,Y
0557-	C8	    INY
0558-	D0 EC	    BNE   $0546
055A-	18	    CLC
055B-	60	    RTS
055C-	38	    SEC
055D-	60	    RTS

  (* = THESE INSTRUCTIONS START OUT AS 'C08C', AND HAVE THE SLOT-DEPENDENT VALUE
OF 'C0EC' POKED IN AT RUN-TIME.  ACCORDING TO MR.  SLIPPERY, "REAL MEN WRITE
SELF-MODIFYING CODE!").

  THIS IS AS IT SHOULD BE FOR ALL NORMAL SECTOR READING.  AT LOCATION $5E8,
HOWEVER, ANOTHER DATA FIELD READ ROUTINE BEGINS.  THIS IS VERY SUSPICIOUS,
INDEED-- WHY SHOULD THEY WASTE SPACE ON A ->SECOND<- DATA FIELD READ ROUTINE,
ESPECIALLY IN A "SQUEEZED" RWTS LIKE THIS (REMEMBER THE THIRD LAW OF KRACKING:
ACCEPTANCE OF UNUSUAL CODE IS NO VIRTUE; SUSPICION TO THE POINT OF PARANOIA IS
NO VICE):


05E5-	20 44 07    JSR   $0744
05E8-	20 B9 04    JSR   $04B9
05EB-	A0 20	    LDY   #$20
05ED-	88	    DEY
05EE-	F0 F8	    BEQ   $05E8
05F0-	AD EC C0    LDA   $C0EC
05F3-	10 FB	    BPL   $05F0
05F5-	49 D5	    EOR   #$D5
05F7-	D0 F4	    BNE   $05ED
05F9-	EA	    NOP
05FA-	AD EC C0    LDA   $C0EC
05FD-	10 FB	    BPL   $05FA
05FF-	C9 AA	    CMP   #$AA
0601-	D0 F2	    BNE   $05F5
0603-	EA	    NOP
0604-	AD EC C0    LDA   $C0EC
0607-	10 FB	    BPL   $0604
0609-	C9 AD	    CMP   #$AD
060B-	D0 E8	    BNE   $05F5
060D-	A2 31	    LDX   #$31
060F-	EA	    NOP
0610-	86 26	    STX   $26
0612-	AC EC C0    LDY   $C0EC
0615-	10 FB	    BPL   $0612
0617-	B9 00 07    LDA   $0700,Y
061A-	9D 00 02    STA   $0200,X
061D-	EA	    NOP
061E-	EA	    NOP
061F-	EA	    NOP
0620-	CA	    DEX
0621-	10 EF	    BPL   $0612
0623-	AD EC C0    LDA   $C0EC
0626-	10 FB	    BPL   $0623
0628-	C9 DF	    CMP   #$DF
062A-	D0 BC	    BNE   $05E8
062C-	AD EC C0    LDA   $C0EC
062F-	10 FB	    BPL   $062C
0631-	49 AA	    EOR   #$AA
0633-	D0 B3	    BNE   $05E8
0635-	A2 31	    LDX   #$31
0637-	5D 00 02    EOR   $0200,X
063A-	CA	    DEX
063B-	10 FA	    BPL   $0637
063D-	0A	    ASL
063E-	D0 A8	    BNE   $05E8
0640-	4C B5 04    JMP   $04B5


  ONCE AGAIN, THE CANONICAL PROLOG BYTES OF 'D5 AA AD' ARE LOCATED, AND THEN,
STANGELY, ONLY $31 (49 DECIMAL) NIBBLES INSTEAD OF THE NORMAL $156 (342 DECIMAL)
ARE READ IN BEFORE SEARCHING FOR THE EPILOG OF 'DF AA'.  THE BYTES READ IN ARE
EOR'ED TOGETHER, AND IF THE RESULT, SHIFTED LEFT ONCE, IS NOT ZERO, THE READ IS
REDONE.  THIS IS A VERY CLEVER LITTLE ANTI-COPY ROUTINE WHICH WORKS AS FOLLOWS:
WHEN THE SECTOR IS READ INTO MEMORY FROM THE DISK, ALL $156 (342 DECIMAL)
NIBBLES ARE READ IN AND POSTNIBBLIZED TO RECONSTRUCT 256 BYTES.  THESE BYTES ARE
THEN RE-NIBBLIZED AND WRITTEN OUT TO THE NEW DISK BEING MADE.  SINCE THE
ORIGINAL NIBBLES OF DF AND AA WERE NOT THE RESULT OF A PRENIBBLIZING PROCESS,
THEY WILL HAVE DISAPPEARED AS THE 50TH AND 51ST NIBBLES OF THE DATA FIELD, AND
BEEN REPLACED BY THE NIBBLES WHICH RESULT FROM A LEGITIMATE NIBBLIZING AND
EXCLUSIVE-ORING PROCESS.  ONE PASS THROUGH ANY STANDARD DOS SECTOR-BASED COPIER
WILL THUS "DESTROY" THE SECTOR FROM THE STANDPOINT OF THE PROTECTION SCHEME.


  THE SCHEME, ALTHOUGH A SUBTLE AND CUTE SECONDARY PROTECTION SYSTEM, IS RATHER
HOLLOW, SINCE NOTHING FURTHER IS DONE WITH THE CHECKSUM OF THE $31 NIBBLES.
THIS WAY, AS SOON AS THE SCHEME IS DECODED, THE ROUTINE CAN SIMPLY BE BYPASSED
WITH NO PENALTY.

  NOW, I REALIZE THAT THIS DISCUSSION BROUGHT MANY OF YOU TO THE "MEGO" POINT
(GOVERNMENT-TALK ACRONYM FOR "MY EYES GLAZE OVER") AT THE FIRST USE OF THE TERMS
PRE- AND POST- NIBBLIZING.  THOSE WHO KNOW IT ALL NEED READ NO FURTHER, BUT FOR
THOSE TO WHOM THIS IS STILL DIALECTIC SWAHILI, I WILL HUMBLY OFFER MY VERSION OF
AN EXPLANATION (IN FULL KNOWLEDGE THAT IT MAY DO NO MORE THAN INCREASE THE EYE-
GLAZE COEFFICIENT).  ONCE AGAIN, THE PRIMARY SOURCE FOR THIS SORT OF EXPOSITION
IS "BENEATH APPLE DOS", WHICH BY NOW HAS ACHIEVED THE STATUS OF THE MOST
FREQUENTLY-REFERENCED TEXT IN ALL OF APPLE KRACKDOM, IF NOT APPLE PROGRAMMING IN
GENERAL.

  WE'RE STILL NOT READY TO GO INTO THE INNERMOST WORKINGS OF THE DISK STORAGE
PROCESS (THAT'LL BE BASICS 107) BUT LET'S STIPULATE FOR THE MOMENT THAT THERE IS
A NEED TO USE ONLY BYTES WHICH MEET CERTAIN STRICT REQUIREMENTS WHEN WRITING
ONTO AN APPLE DOS 3.3 DISK.  THE STONE TABLETS CARRIED UP FROM CUPERTINO LIST
THOSE REQUIREMENTS:


  1.  THE HIGH BIT OF THE BYTE MUST BE '1'

  2.  THE BYTE MUST CONTAIN NO MORE THAN ONE PAIR OF ADJACENT ZEROES.

  3.  THERE MUST BE AT LEAST TWO ADJACENT ONES IN THE BYTE, NOT INCLUDING THE
      HIGH BIT.

  AS IT TURNS OUT, THERE ARE EXACTLY 64 BYTES WHICH MEET ALL OF THESE CRITERIA.
IN ORDER TO STORE INFORMATION ON THE DISK, WE MUST "ENCODE" A TOTAL OF 256 BYTES
(ONE PAGE AND ALSO ONE SECTOR) IN THE 64 PSEUDO-BYTES WHICH CAN BE WRITTEN.

  64 DIFFERENT BYTES MEANS THAT WE CAN SET UP A TABLE IN WHICH EACH BYTE
UNIQUELY CORRESPONDS TO ONE OF THE SIX-BIT NUMBERS FROM 00 TO $3F (IN BINARY,
0000 0000 TO 0011 1111).  THE PROCESS OF CHOPPING UP FULL 8-BIT BYTES INTO
PIECES WHICH CAN CORRESPOND TO 6-BIT BYTES IS CALLED "NIBBLIZING".  WE CAN BEGIN
TO SIMULATE THE "PRENIBBLIZING" PROCESS BY MAKING UP TWO TABLES.  THE FIRST ONE,
WHICH NORMALLY RESIDES AT $BB00-BBFF, IS SET UP TO CONTAIN THE FIRST SIX BITS OF
EACH OF THE 256 BYTES:

  IF THE      THE CORRESPONDING
ORIGINAL BYTE  ENTRY IN THE BB00
 ALUE WAS:	  TABLE IS:
				  TABLE

(HEX) (BINARY)	 (HEX)	(BINARY)   ADDR
 00   0000 0000    00	0000 0000  BB00
 3F   0011 1111    3F	0011 1111  BB01
 47   0100 0111    07	0000 0111  BB02
 69   0110 1001    29	0010 1001  BB03
 7F   0111 1111    3F	0011 1111  BB04
 85   1000 0101    05	0000 0101  BB05
 BC   1011 1100    3C	0011 1100  BB06
 F0   1111 0000    30	0011 0000  BB07
 FF   1111 1111    3F	0011 1111  BB08
			  !    !     !
			  !    !     !
			  V    V     V


  AS YOU CAN SEE, IN EACH CASE THE FIRST TWO BITS HAVE BEEN CHOPPED OFF AND
REPLACED WITH ZEROES.  THE RESULTING BYTE, NOW BETWEEN 0 AND $3F (0 AND 63) CAN
BE RELATED, ONE FOR ONE, TO THE WRITEABLE BYTES.  HOWEVER, IF WE DON'T STORE, IN
SOME ORGANIZIED FASHION, THOSE TWO BITS WE LOPPED OFF EVERY BYTE, WE WON'T BE
ABLE TO RECONSTRUCT THE ORIGINAL BYTES WHEN WE READ THESE FUNNY LITTLE 6-BIT
NIBBLEBYTES FROM THE TRACK.  THE WAY THAT'S DONE IS TO CONTRUCT A SECOND TABLE,
NORMALLY AT BC00-BC55, WHICH CONTAINS ALL THE LITTLE BITS AND PIECES (HO-HO-HO)
LEFT OVER AFTER THE TRUNCATION OF THE ORIGINAL BYTES TO SIX BITS.  IN THE
EXAMPLE LIST GIVEN ABOVE, THE LEFTOVERS ARE:


       00 -------------------\
       00 ---------------\    \
       01 -------------\  \    \
       01		\  \	\
       01		 \  \	 \
       10		  \  \	  \
       10		   !  !   !
       11		   !  !   !
       11		   !  !   !
			   !  !   !
THIS SECOND LIST WORKS	   !  !   !
FROM THE BOTTOM UP, SO	   !  !   !
THE CONTENTS WOULD BE:	   !  !   !
			   !  !   !
	^	^   ^	   !  !   !
	!	!   !	   !  !   !
	!	!   !	   !  !   !
      BC4D    00XX YY11    !  !   !
      BC4E    00XX YY11    !  !   !
      BC4F    00XX YY10    !  !   !
      BC50    00XX YY10    !  !   !
      BC51    00XX YY01    !  !  /
      BC52    00XX YY01   /  /	/
      BC53    00XX YY01 -/  /  /
      BC54    00XX YY00 ---/  /
      BC55    00XX YY00 -----/


  SO, THE FIRST TWO BITS OF THE ORIGINAL BYTE BECOME THE LAST TWO BITS OF THE
BYTES IN THIS TABLE, WORKING FROM THE BOTTOM UP.  AFTER $56 (86 DECIMAL) BYTES
HAVE HAD THEIR FIRST TWO BITS STUFFED INTO THE TABLE, THE NEXT ONE REPLACES THE
"YY" AT LOCATION BC55, THEN AT BC54, ETC.  AFTER $AC (172) BYTES, THE NEXT PAIR
OF LEFTOVERS GOES INTO THE "XX" SLOT OF LOCATION BC55, AND WORKS UP AGAIN UNTIL
THE LAST TWO BITS ARE STUFFED INTO THE "XX" SLOT OF LOCATION BC00.  REMEMBER
THAT THE TWO MOST SIGNIFICANT BITS MUST ALWAYS BE ZERO TO STAY WITHIN THE 0-3F
RESTRICTION.

  AFTER THESE TWO TABLES HAVE BEEN CONSTRUCTED, EACH VALUE IN THE TABLE IS
EXCLUSIVE-ORED ON WITH THOSE THAT WENT BEFORE, TO FORM A NEW SIX-BIT BYTE.  THE
RESULTING VALUE, WHICH IS STILL BETWEEN 0 AND $3F, IS TRANSLATED TO ONE OF THE
64 BYTES WHICH OBEY ALL THE LAWS LISTED ABOVE FOR THE DISK BYTES, AND THEN
REALLY AND TRULY WRITTEN TO DISK.  THE TABLE WHICH DOES THIS CONVERSION IS
CALLED THE "WRITE TRANSLATE TABLE" AND LIVES AT $BA29 TO $BA68.  IN OUR EXAMPLE,
THEN THE PROCESS GOES LIKE THIS:


  1.  GET A BYTE FROM BB00 =00
  2.  EXCLUSIVE-OR IT WITH 00 (IT'S THE FIRST BYTE) 00 EOR 00=00
  3.  LOOK UP THE BYTE AT $BA29 + 0 =96
  4.  WRITE IT TO DISK.

----THE NEXT BYTE-------------


  1.  GET THE BYTE FROM BB01 =3F
  2.  EXCLUSIVE-OR IT WITH THE PREVIOUS VALUE OF 00 3F EOR 00=3F
  3.  LOOK UP THE BYTE AT $BA29 + $3F FF
  4.  WRITE IT TO DISK

----AND THE THIRD BYTE--------

  1.  GET THE BYTE FROM BB02 =07
  2.  EXCLUSIVE-OR IT WITH THE PREVIOUS VALUE OF 3F 07 EOR 3F=34
  3.  LOOK UP THE BYTE AT $BA29 + $34 F3
  4.  WRITE IT TO DISK


----FOURTH AND LAST EXAMPLE---


  1.  GET THE BYTE FROM BB03 =29
  2.  EXCLUSIVE-OR IT WITH THE PREVIOUS VALUE OF 34 29 EOR 34=1D
  3.  LOOK UP THE BYTE AT $BA29 + $1D CE
  4.  WRITE IT TO DISK


  AND SO ON UNTIL THE TOTAL OF $156 OR 342 BYTES FROM THE TWO TABLES IS WRITTEN
TO DISK.  (LOOKING AT THIS PROCESS, YOU CAN SEE THAT A SECTOR WITH ALL ZEROES
WOULD NEVER CHANGE THE FIRST BYTE WRITTEN OUT, AND WOULD DISPLAY A SECTOR FULL
OF 96'S ON A NIBBLE READ).

  WHEN THE DATA FIELD OF A SECTOR IS READ BACK IN, THE PROCESS IS REVERSED.
AFTER ALL 342 BYTES ARE READ INTO BB00-BC55, EACH BYTE IS EXCLUSIVE-ORED OFF THE
PILE, AND THE RESULT IS USED TO LOOK UP A VALUE OF 0-3F IN A "READ TRANSLATE
TABLE" AT BA96-BAFF.  THROUGH SOME ELEGANT, IF INTRICATE CODE, THIS 6-BIT "BYTE"
IS RECOMBINED WITH ITS LONG-LOST 2 BITS, AND THE FINAL, REAL BYTE IS STORED
WHERE $3E AND $3F ARE POINTING.

  IN THE FEW REMAINING LINES, LET ME EXPOUND FOR A MOMENT ON THE EXCLUSIVE- OR
OPERATOR.  THE INSTRUCTION EOR (WHICH USES THE MNEMONIC XOR IN EVERY OTHER
ASSEMBLY LANGUAGE) WORKS LIKE THIS:  FOR EACH BIT OF THE TWO BYTES TO BE
OPERATED ON, THE OUTPUT IS A ONE IF ONE AND ONLY ONE OF THE BITS IS ONE, BUT A
ZERO IF BOTH ARE ZERO OR ONE.  THE TRUTH TABLE BELOW SUMMARIZES:

	INPUT 1  INPUT 2   OUTPUT
	  0	    0	     0
	  0	    1	     1
	  1	    0	     1
	  1	    1	     0

AND THE LAST EXAMPLE GIVEN ABOVE IS:


	  0010 1001  (29)
    EOR   0011 0100  (34)
	  ---------
	  0001 1101  (1D)


  THIS IS BASICALLY A NEAT LITTLE OPERATOR WHICH HAS BEEN FREQUENTLY PERVERTED
BY THE ENEMY TO DO THEIR DIRTY WORK.  MORE ON THIS LATER--STAY TUNED FOR THE
NEXT EPISODE:  "NON-STANDARD ENCODING SCHEMES."

---------------------------------------
***************************************
*				      *
*				      *
*     KRAKOWICZ'S KRACKING KORNER     *
*				      *
*     THE BASICS OF KRACKING 107      *
*				      *
*    BEYOND DEMUFFIN:NON-STANDARD     *
*      DISK ENCODING TECHNIQUES       *
*	 AND DISKBIT TIDBITS	      *
*				      *
*				      *
***************************************



  RECENTLY, WE HAVE DISCUSSED THE UNPROTECTION OF DISKS WITH A MODIFIED DOS,
PRIMARILY THROUGH THE USE OF DEMUFFIN PLUS.  THIS TIME WE'LL TALK A LITTLE ABOUT
SOME OTHER APPROACHES TO CONVERTING MODIFIED DOS DISKS, THEN GET INTO SOME
SLIGHTLY HEAVIER STUFF ABOUT THOSE PROTECTION TECHNIQUES WHICH GO WAY BEYOND
MODIFYING DOS.

  IN ADDITION TO DEMUFFIN PLUS, TWO PROGRAMS HAVE RECENTLY BECOME AVAILABLE FOR
UNPROTECTING A DISK WITH MODIFIED DOS:	COPYB AND ADVANCED DEMUFFIN.  SINCE, AS
WE DISCUSSED EARLIER, MOST MODS ARE MADE TO THE RWTS PORTIONS OF DOS, ALL THAT'S
REALLY NECESSARY TO REMOVE THE PRIMARY PROTECTION IS TO READ THE DISK INTO
MEMORY USING ITS OWN RWTS, THEN SWITCH IN A NORMAL RWTS AND WRITE IT BACK OUT TO
ANOTHER DISK.  SINCE THE FILE MANAGER IS NOT INVOKED AS IT IS IN DEMUFFIN PLUS,
THIS APPROACH HAS THE ADDED ADVANTAGE THAT A DISK WITH FAIRLY NORMAL SECTOR
STRUCTURE BUT NO DOS FILE STRUCTURE OR CATALOG CAN STILL BE CONVERTED.	IN THE
EARLY DAYS, THE TECHNIQUE WAS THIS:  STORE BOTH RWTS'S IN MEMORY, THEN USE THE
INSPECTOR TO READ IN ABOUT 8 TRACKS.  MOVE THE NORMAL RWTS IN WITH THE MONITOR,
THEN WRITE OUT THE TRACKS TO AN INITIALIZED DISK.  ABOUT 5 TIMES AROUND MAKES A
COPYA DISK AND JACK A DULL BOY.  FORTUNATELY, THINGS HAVE IMPROVED.

  COPYB IS A MODIFICATION OF COPYA WHICH AUTOMATICALLY SWAPS THE RWTS ROUTINES
FOR YOU.  TO RUN IT, YOU BOOT THE PROTECTED PROGRAM AND INTERRUPT IT, THEN MOVE
THE RWTS ROUTINES FROM $B700 TO $8000 (YOU CAN ALSO USE THE READ-IN TECHNIQUE
DESCRIBED IN BASICS 105 TO PUT THE MODIFIED RWTS INTO MEMORY, AND YOU CAN KEEP A
LIBRARY OF RWTS'S IF YOU FIND PEOPLE LIKE MUSE AND SSI USING A PARTICULAR ONE
OVER AND OVER.	THESE CAN SIMPLY BE LOADED AS BFILES INTO $8000 AFTER BOOTING
COPYB).  BOOTING COPYB AND ANSWERING ONE CRYPTIC AND FOUR FIDDISH QUESTIONS
ALLOWS YOU TO PRODUCE A COPYA DISK, INCLUDING AUTOMATIC INITIALIZATION OF THE
TARGET DISK.  REASONABLY COMPLETE INSTRUCTIONS, WRITTEN BY THE AUTHOR WHO HAS
ACHIEVED NATIONAL PROMINENCE FOR VERBAL DIARRHEA, ACCOMPANY THE PROGRAM, SO WE
WON'T BELABOR THEM HERE.

  A MUCH MORE COMPLETE PROGRAM CALLED ADVANCED DEMUFFIN HAS RECENTLY ISSUED FROM
CORRUPT COMPUTING, UNDER THE ABLE AUTHORSHIP OF "THE STACK" AND "THE INSPECTOR".
IT ALSO MAKES UNPROTECTED COPIES VIA RWTS SWAPS, BUT IS MUCH MORE USER-FRIENDLY
AND VERSATILE.	THOROUGH SOFTDOC ACCOMPANIES THAT PROGRAM AS WELL, SO WE NEEDN'T
DWELL ON IT, EXCEPT TO CONGRATULATE THE AUTHORS ON AN EXCELLENT AND HIGHLY
PROFESSIONAL CONTRIBUTION TO THE ART OF UNPROTECTION.


  EXCEPT FOR SOME CLEVER AND WELL-HIDDEN SECONDARY PROTECTION, THERE IS NOT MUCH
THAT A PROTECTOR CAN DO THESE DAYS WITH A MODIFIED DOS THAT WE CAN'T UNDO IN
SHORT ORDER WITH THE TOOLS AND TECHNIQUES AVAILABLE TO US.  WHY ARE THERE STILL
SOME PROGRAMS THAT TAKE A LONG TIME TO KRACK?  MORE EXTENSIVE MODIFICATIONS,
EXTENDING EVEN TO COMPLETE CUSTOM DOS'S.  HERE, HOWEVER, WE START TO SEPARATE
THE MEN FROM THE BOYS, SINCE WRITING YOUR OWN OPERATING SYSTEM, NO MATTER HOW
LIMITED, COSTS MONEY.  WHILE DOS MODIFICATIONS, EVEN WITH SEVERAL VARIATIONS,
CAN BE WHIPPED OUT IN A FEW MINUTES BY ANY KLUTZY HACKER, READING AND WRITING IN
WAYS NOT SANCTIONED BY THE GODS OF APPLEDOS REQUIRE HIRING SOMEONE WHO KNOWS HIS
SHIT, AND HE ALSO USUALLY KNOWS HOW MUCH HE'S WORTH.  THIS HAS ADVANTAGES FOR US
AS WELL, SINCE PUBLISHERS WILL TRY TO GET THEIR MONEY'S WORTH OUT OF AN
EXPENSIVE SYSTEM BY USING IT ON AS MANY PRODUCTS AS POSSIBLE.  ONCE BROKEN, THE
PRICIPLES CAN BE READILY APPLIED TO ALL DISKS OF THE SAME GENERATION OF
PROTECTION.

  IF A PUBLISHER IS GOING TO GO BEYOND MODIFYING DOS, HE WILL NORMALLY ALSO
ABANDON STANDARD TRACK AND SECTOR FORMAT FOR SOMETHING WHICH AFFORDS GREATER
SECURITY AND EASE OF USE (SOMETIMES, SINCE THE APPLE DISK HARDWARE IF SO
FLEXIBLE, FORMATS WHICH WERE BORN ON ENTIRELY DIFFERENT SYSTEMS FIND THEIR WAY
INTO APPLE PROTECTION SCHEMES).  GAMES, ESPECIALLY, HAVE MUCH SIMPLER STRUCTURE,
AND ARE READILY ADAPTED TO A FORMAT WITH LESS COMPLEXITY.  SINCE SPACE ON A GAME
DISK IS USUALLY NOT AT A PREMIUM, A VERY COMMON SIMPLIFICATION IS TO ELIMINATE
SECTORING ALTOGETHER, AND MAKE EACH TRACK ONE BIG SECTOR.  THIS NOT ONLY
SIMPLIFIES THE PROGRAM THAT HAS TO READ THE DISK, BUT CAN ALSO DRAMATICALLY
INCREASE THE DATA TRANSFER RATE (SIRIUS'S HADRON BROUGHT IN A FULL 48K IN JUST
OVER FOUR SECONDS--EAT YOUR HEART OUT, DOS).  BEFORE WE DISCUSS SOME OF THE
FORMATS USED, WE HAVE TO TAKE A MUCH CLOSER LOOK AT THE WAY INFORMATION IS
ACTUALLY READ FROM A DISK.

  THERE ARE A FEW ABSOLUTE LAWS OF DISK WRITING AND READING WHICH MUST BE
OBSERVED, AND SEVERAL MINOR STATUTES WHICH MAY BE VIOLATED WITH ONLY A SUMMONS.
THE REAL, DEEP DOWN, TRUE WAY THAT DATA IS RECORDED ON ANY DISK IS BY WAY OF
"MAGNETIC FLUX CHANGES", THAT IS, REVERSALS IN THE DIRECTION OF MAGNETIZATION OF
A THIN COATING OF IRON OXIDE ON THE DISK SURFACE.  WE ALL RECALL FONDLY THE
SCIENCE EXPERIMENTS WITH IRON FILINGS AND A BAR MAGNET; DISK RECORDING
TECHNOLOGY IS BASED ON MAKING THE PARTICLES VERY SMALL, AND IMMOBILIZING THEM ON
THE DISK SO THEY CAN BE EXAMINED LATER FOR THE STATE OF THEIR MAGNETIZATION.
DISKETTE READING IS ACTUALLY A (GASP!) ANALOG PROCESS, AND IS MADE DIGITAL BY
SOME CLEVER CIRCUITRY JUST DOWNSTREAM OF THE READ HEAD.  THIS CIRCUITRY SENSES
THE MAGNETIC FIELD OVER A PRECISELY DEFINED TIME INTERVAL, AND TRANSLATES A
*CHANGE* (REVERSAL) IN THE DIRECTION OF MAGNETIZATION TO A DIGITAL "ONE", AND
INTERPRETS *NO CHANGE*, OR THE ABSENCE OF REVERSAL, AS A "ZERO".

  "NIBBLE" (IN CASE YOU WERE CURIOUS, THE DISK SPINS AT 300 RPM WHICH IS 5
REVOLUTIONS PER SECOND, OR 200 MILLISECONDS (MSEC) PER ROTATION.  SINCE 8 BITS =
ONE BYTE, A BYTE IS READ EVERY 32 USEC, OR 0.032 MSEC, AND EACH REVOLUTION OF
THE DISK CORRESPONDS TO 200 MSEC/0.032 MSEC OR ABOUT 6000 BYTES.  THIS IS
ROUGHLY $1800 BYTES PER TRACK, WHICH IS ABOUT THE NUMBER OF BYTES YOU NORMALLY
SEE DISPLAYED DURING A NIBBLE COUNT WITH NIBBLES AWAY OR LOCKSMITH).

  IT'S NOT TOO BAD A PHYSICAL PICTURE TO REPRESENT THE ORIENTATION OF THE
MAGNETIC FIELDS WITH ARROWS (UP AND DOWN ARROWS WOULD BE NICER, BUT THE APPLE
SCREEN NO GOTS).  IN THE DIAGRAM BELOW, THE ORIENTATION OF MAGNETIC "DOMAINS" ON
THE DISK FOR 9 BITS ARE REPRESENTED:


READ PT     1  2  3  4	5  6  7  8  9
DIR'N     -> -> <- -> -> -> <- <- -> ->
	   \ /\ /\ /\ /\ /\ /\ /\ /\ /
BIT VALUE   0  1  1  0	0  1  0  1  0


  NOTICE THAT EACH TIME THE MAGNETIC FIELD REVERSES DURING THE READ INTERVAL,
THE BIT VALUE IS READ AS "1", AND AS "0" WITH NO REVERSAL.

  THE DISK ANALOG CARD AND CONTROLLER CARD COOPERATE TO STACK UP THIS "SERIAL
BIT STREAM" INTO AN 8-BIT BYTE, USING A SHIFT REGISTER WHICH IS THE HARDWARE
EQUIVALENT OF THE "ASL" OR "ARITHMETIC SHIFT LEFT" INSTRUCTION IN APPLE ASSEMBLY
LANGUAGE.  THE SHIFT REGISTER STARTS OUT FULL OF ZEROES, AND KEEPS SCHLEPPING
IN, FROM THE LEFT, THE NEW BIT READ FROM THE DISK EVERY 4 MICROSECONDS.  THE
SEQUENCE BELOW REPRESENTS THE SHIFT REGISTER CONTENTS AT EACH OF THE READ POINTS
SHOWN IN THE ARROW CHART ABOVE:


SHIFT			     NEXT BIT
REGISTER		      TO BE
BIT #  --> 7 6 5 4 3 2 1 0     ADDED
	  +---------------+	/
(# OF	  !		  !    /
 SHIFTS) 0!0 0 0 0 0 0 0 0!<- 0
	  !		  !
	 1!0 0 0 0 0 0 0 0!<- 1
	  !		  !
	 2!0 0 0 0 0 0 0 1!<- 1
	  !		  !
	 3!0 0 0 0 0 0 1 1!<- 0
	  !		  !
	 4!0 0 0 0 0 1 1 0!<- 0
	  !		  !
	 5!0 0 0 0 1 1 0 0!<- 1
	  !		  !
	 6!0 0 0 1 1 0 0 1!<- 0
	  !		  !
	 7!0 0 1 1 0 0 1 0!<- 1
	  !		  !
	 8!0 1 1 0 0 1 0 1!<- 0
	  !		  !
	 9!1 1 0 0 1 0 1 0!
	  +---------------+

  NOTICE THAT THE MOST SIGNIFICANT BIT ("MSB", OR BIT 7) OF THE SHIFT REGISTER
STAYS AT "0" UNTIL THE NINTH SHIFT, WHEN A "1" IS SHIFTED IN.  THIS IS THE
SIGNAL WE USE TO DECIDE WHEN WE SHOULD STOP READING AND SHIFTING, AND CALL IT A
BYTE.  THE SHIFT REGISTER IS DECODED AS ADDRESS $C0EC (FOR SLOT SIX), AND THE
FAMILIAR INSTRUCTION SEQUENCE:

  $B954  LDA $C08C,X (X=60 FOR SLOT 6)
	 BPL $B954

  IS USED AS A "WAIT AND WATCH" LOOP TO DETECT WHEN THE MSB HAS FINALLY BECOME A
ONE.  IF YOU ARE STILL FOLLOWING THE DISCUSSION, YOU SHOULD NOW BE ABLE TO SEE
THE REASON FOR THE FIRST LAW OF DISK BYTES (LISTED IN BASICS 106):  IF THE FIRST
BIT OF THE BYTE WEREN'T A ONE, BIT 7 OF THE SHIFT REGISTER WOULD STILL HAVE A
ZERO WHEN WE SHOULD BE AT THE END, AND WE WOULD SHIFT AT LEAST ONE MORE TIME,
LOOKING IN VAIN FOR A "1".  THE SECOND (NOT MORE THAT ONE PAIR OF ADJACENT
ZEROES) IS REQUIRED TO KEEP THE CIRCUITRY FROM GETTING LOST (THE THIRD LAW,
WHICH REQUIRES AT LEAST ONE PAIR OF ADJACENT ONES NOT INVOLVING BIT 7, IS ONLY
FOR DOS 3.3, AND DOES NOT AFFECT THE HARDWARE).  LET'S LOOK, FOR REVIEW, AT SOME
LEGAL AND ILLEGAL NIBBLES:


 BYTE  BINARY	     LEGAL  VIOLATION
 ---- ---------      -----  ---------
  7F  0111 1111        NO    RULE 1
  8F  1000 1111        NO    RULE 2
  92  1001 0010        NO    RULE 2
  95  1001 0101       YES   NOT DOS 3.3
  96  1001 0110       YES     NONE
  97  1001 0111       YES     NONE
  98  1001 1000        NO    RULE 2
  9A  1001 1010       YES   NOT DOS 3.3
  9B  1001 1011       YES     NONE
  D5  1101 0101       YES      *
  AA  1010 1010       YES      *

  *THESE TWO BYTES ARE NOT ALLOWED IN THE DOS 3.3 NIBBLIZING SCHEME, BUT ARE
USED IN PROLOGS AND EPILOGS.

  ALSO, TUCK THIS AWAY IN THE BACK OF YOUR MIND:  *N0* LEGAL DISKBYTES CAN
CONTAIN 8, 1, OR 0.

  NOW, IF YOU WANT TO CREATE A NON-STANDARD DISK FORMAT TO KEEP THOSE NASTY
PIRATES OUT OF YOUR "UNKRACKABLE" SOFTWARE, ALL YOU HAVE TO DO IS PICK A
SELECTION OF LEGAL BYTES (AND MAYBE A FEW OF THE ILLEGAL ONES), AND ARRANGE YOUR
OWN ENCODING SCHEME.  THE MOST COMMON TECHNIQUE IS AN ADAPTATION OF THE OLD
ENCODING SCHEME CALLED 4+4 NIBBLIZING INTRODUCED TO DISK PROTECTION (I BELIEVE)
BY MY GOOD FRIENDS AT SIRIUS SOFTWARE.	THIS IS THE SAME SYSTEM APPLE USES TO
STORE VOLUME, TRACK AND SECTOR DATA IN THE ADDRESS FIELD (SEE BASICS 104).  AS
WE DESCRIBED, EACH REAL BYTE IS SPLIT INTO ODD AND EVEN HALVES, AND ENCODED SO
THAT EACH BYTE STORED ON THE DISK REPRESENTS EXACTLY 4 BITS, OR ONE NIBBLE, OF
THE ORIGINAL BYTE (THE BEGINNING OF THE DISKNIBBLEBYTE CONFUSION).  THE CHOICE
FOR THESE IS LIMITED:  ALL DISK BYTES ARE MADE UP OF A,B,E AND F, SO YOU CAN
HAVE,ON THE DISK:


      AA AB AE AF BB BA BE BF
      EA EB EE EF FA FB FE FF

  YOU CAN FIND (PERHAPS TOO MUCH) MORE INFORMATION ON THIS TECHNIQUE AND
DECODING IT IN THE FILES ON CYCLOD, WAY OUT, AND TYPE ATTACK.

  IN GENERAL, WHILE THE APPROACH TO UNPROTECTING ALL OF THESE ODDBALL FORMATS IS
STRAIGHTFORWARD, THE WORK CAN BE LONG AND HARD, AND CAN PROVIDE SOME REAL
CHALLENGE TO OUR SKILL AS KRACKISTS AND PROGRAMMERS.  IN BROAD OUTLINE:

  A.  TRY TO FIGURE OUT THE DISK ACCESS LOGIC AND ISOLATE THE READER/LOADER
CODE.

  B.  MODIFY IT TO READ IN ALL THE PERTINENT PARTS OF THE DISK.

  C.  SAVE THE PIECES OUT TO DISK UNDER NORMAL RWTS STRUCTURE.9

  D.  RECONSTRUCT THE PROGRAM, USING AS LITTLE NEW CODE AS POSSIBLE.


  BY NOW YOU SHOULD KNOW WHAT A LOADER ROUTINE LOOKS LIKE, AND IN MOST CASES
THESE DISKS WILL LOAD A COMPLETE TRACK AT A TIME INTO A PREDETERMINED AREA OF
MEMORY.  BY LOCATING AND ALTERING THE TABLE OF "WHERE TO READ IN", YOU CAN, IN A
FEW PASSES, READ THE TRACK INTO MEMORY, BOOT A DISK, AND WRITE THE MEMORY
CONTENTS OUT UNDER THE NORMAL DOS FORMAT.  AFTER ALL THE INFORMATION IS SAVED,
YOU CAN BEGIN THE PROCESS OF RECONSTRUCTION.  USUALLY, THIS CONSISTS OF LOADING
DOS (OR AT LEAST RWTS) INTO MEMORY AND USING IT TO MANIPULATE SECTIONS OF THE
ORIGINAL CODE.	IN CASES LIKE CYCLOD, THE ADDITIONAL DISK ACCESS BETWEEN LEVELS
IS TOTALLY UNNECESSARY AND CAN BE ELIMINATED.  IN SOMETHING LIKE BANDITS,
HOWEVER, A GREAT DEAL OF REAL DATA IS READ IN AT EACH LEVEL, AND A MEANS MUST BE
FOUND TO ACCOMMODATE THE DISK ACCESS.  USUALLY, THIS MEANS TRYING TO SQUEEZE THE
ABSOLUTELY CRUCIAL SUBROUTINES FROM RWTS INTO THE SPACE ORIGINALLY OCCUPIED BY
THE LOADER ROUTINE.

  THERE ARE A NUMBER OF THESE "SHORT DOS" ROUTINES IN EXISTENCE.  THESE PROGRAMS
ARE ALL LESS THAN $400 BYTES LONG, AND INCLUDE TRACK SEEK, ADDRESS AND DATA
FIELD READERS, AND POSTNIBBLIZING ROUTINES.  IN THE PROCESS OF KRACKING BANDITS,
BOTH THE SHY "NAMELESS" KRACKER ("THEY SAID IT COULDN'T BE DONE...") AND I WROTE
VIRTUALLY IDENTICAL ROUTINES WHICH LIVED IN TEXT MEMORY AT 400-7FF.  LONG- JOHN
SILVER HAS HIS OWN VERSION OF A SHORT DOS, AND AN EXCELLENT IMPLEMENTATION HAS
RECENTLY BEEN INTRODUCED BY THE STACK AND THE INSPECTOR OF "CORRUPT COMPUTING".
IT IS EXTREMELY WELL DOCUMENTED, AND JUST AS IN THE CASE OF ADVANCED DEMUFFIN,
THE BEST UTILITY AVAILABLE TO THE PRACTICING KRACKIST.

  THAT'S A CRUDE OUTLINE OF THE DISK PROTECTION SCHEMES WHICH GO BEYOND MODIFIED
DOS; UNFORTUNATELY, MOST ARE QUITE DIFFERENT IN DETAIL, AND YOUR SKILL AS A
KRACKIST MUST BE MADE EQUAL TO THE TASK OF EACH ONE.  WE'LL CONTINUE THE BASICS
OF KRACKING SERIES NEXT TIME WITH THE LONG-PROMISED ARTICLE ON BOOT- TRACING.

---------------------------------------
***************************************
*				      *
*				      *
*     KRAKOWICZ'S KRACKING KORNER     *
*				      *
*				      *
*     THE BASICS OF KRACKING 108:     *
*				      *
*      BOOT CODE TRACING PART 1       *
*				      *
*				      *
*				      *
***************************************


  AT LAST!  THE LONG-AWAITED DESCRIPTION OF BOOT-CODE TRACING AND ITS
APPLICATION TO DISK UNPROTECTION.  OY KRACKING LAW #7 SAYS "WHEN ALL ELSE FAILS,
BOOT TRACE." FOR MANY KRACKISTS, NOTABLE AMONG WHOM WAS MR.  XEROX (MAY HE REST
IN PEACE), THE MOTTO WAS OPPOSITE:  "BEFORE YOU DO ANYTHING ELSE, TRACE THE BOOT
CODE." DEPENDING ON YOUR SKILL AND PREDISPOSITION, YOU'LL SETTLE SOMEWHERE IN
BETWEEN THESE EXTREMES.

  IF MR.  XEROX DIDN'T INVENT BOOT- TREACING HE WAS CERTAINLY THE FIRST TO
DOCUMENT IT CLEARLY IN THE UNDERGROUND PRESS.  THE DESCRIPTION THAT FOLLOWS
BORROWS HEAVILY FROM HIS ORIGINAL TREATISE ON THE PIRATE'S HARBOR CRACKING DISO
#1.  IN ADDMTION, "MYCROFT" WROTE A THOROUGH ARTICLE IN HARDCORE COMPUTING
UPDATE 3.1 DESCRIBING HIS OWN, SLIGHTLY DIFFERENT APPROACH TO BOOT-TRACING.
WHILE I FIND HIS PROCESS A LITTLE MORE LABORIOUS, IT MIGHT BE NECESSARY FOR SOME
VERY DIFFICULT CASES.

  THE PROCESS IS BASED FIRMLY ON THE FRIST LAW:  TRACK 0, SECTOR 0 OF EVGRY DISK
MUST <ALWAYS> LOAD INTO PAGE 8 ($800-8FF).  THE FURTHER ASSUMPTION IS THAT, IF
WE CAN VIEW EVERY STAGE OF THE BOOT PROCESS, WE CAN LEARN ENOUGH TO PRODUCE AN
UNPROTECTED VGRSION OF THE PROGRAM.  IT DOES NOT HAVE MYSTICAL POWERS, AND STILL
REQUIRES THE ABILITY TO TEAR APART AND UNDERSTAND ASSEMBLY LANGUAGE, MUCH OF
WHICH IS INTENTIONALLY MISLEADING.  WE'LL BEGIN WITH BACKGROUND MATERIAL AND A
REVIEW OF THE NORMAL BOOT PROCESS (DAMMIT, MAUDE, WE ALWAYS HAVE TO SIT THROUGH
THE SERMON FIRST!), AND PROCEED THROUGH AN EXAMPLE OF A NEW PROGRAM.

  (AS WITH MOST KRACKING ACTIVITIES, INITIALLIZED DISK FOR SAVING PIECES OF THE
CODE AS THEY BECOME AVAILABLE).

  ORDINARILY, WHEN YOU BOOT A 48K SLAVE DISK (A MASTER IS SLIGHTLY DIFFERENT,
BUT WE'LL IGNORE THAT FOR THE TIME BEING), A THREE-STAGE PROCESS IS STARTED
WHICH ENDS UP WITH THE DESIRED (HELLO) PROGRAM RUNNING.  FIRST, THE CONTROLLER
CARD ROM AT $C600-C6FF LOADS T0, S0 INTO PAGE 8, THEN JUMPS TO LOCATION $801.
THIS IS A SHORT PROGRAM THAT LOADS ALL 10 SECTORS OF RWTS FROM T0, S0 THROUGH
T0,S9 INTO PAGES $B6-BF ($B600-BFFF), THEN JUMPS TO LOCATION $B700.  THIS
PROGRAM, IN TURN, LOADS $1B (27) PAGES INTO $9D00-B5FF FROM T2, S4 THROUGH T0,
SB (NOTE-THIS IS A "BACKWARDS LOAD" FOR SPEED.  APPLE KNEW ABOUT IT, SO WHY
DIDN'T DOS EVER USE IT FOR QUICKLOADING FILES???).  AFTER A LITTLE HOUSEKEEPING,
THE PROGRAM JUMPS TO THE DOS COLDSTART IN $9D84, WHICH RUNS OR EXECS THE HELLO
PROGRAM.  IN SUMMARY:

  CODE	  # OF	 DEST	 NAME	NEXT
LOCATION  SECT.  PAGE		JUMP
--------  -----  ----  -------	----
C600-C6FF    1	  08   STAGE 0	 801
0801-08FF    9	B6-BF  STAGE 1	B700
B700-B7FF   27	9D-B5  STAGE 2	9D84


  OF COURSE, IN A NONSTANDARD FORMAT INTENDED FOR PROTECTION, THINGS AREN'T
NECESSARILY THE SAME.  TO SEE THE DIFFERENCES, YOU NEED TO EXAMINE EACH STAGE
SEPARATELY TO SEE WHAT IT DOES AND WHERE IT GOES.

  THE THEORY OF BOOT-TRACING IS STRAIGHTFORWARD:  FOLLOW THE BOOT PROCESS ONE
STEP AT A TIME TO SEE WHERE IS LEADS YOU, BY CREATIVELY ALTERING THE THE CODE TO
PREVENT IT FROM RUNNING AWAY FROM YOU.	IN SUMMARY, WE WILL:

  1.  READ IN THE STAGE 1 BOOT CODE, BUT NOT ALLOW IT TO EXECUTE,

  2.  ALTER THE FIRST STAGE BOOT SO IT WILL EXECUTE TO LOAD IN STAGE TWO, WHILE
      PREVENTING THE NEW STAGE FROM RUNNING,

  3.  IF NECESSARY, REPEAT THE PROCESS OF ALTERING, LOADING, AND HALTING UNTIL
      ALL THE STAGES OF THE BOOT HAVE BEEN EXAMINED AND UNDERSTOOD.

  IN PRACTICE, THE FIRST TWO STEPS ARE RELATIVELY STANDARD, BUT STEP THREE CAN
GET QUITE INVOLVED AS THE TRACE PROGRESSES.

  THE TECHNIQUE FOR INTERRUPTING THE ORDERLY FLOW OF THE BOOT IS REFERRED TO AS
"SETTING BREAK POINTS".  THE TERMINOLOGY IS BORROWED FROM THE DARK AGES WHEN
COMPUTERS HAD REAL FRONT PANELS WITH KNOBS AND SWITCHES AND LIGHTS, AND YOU
COULD ACTUALLY "DIAL-IN" AN ADDRESS WHERE YOU WANTED THE COMPUTER TO HALT FOR
EXAMINATION (IS ANYONE OUT THERE OLD ENOUGH TO SHARE MY FOND RECOLLECTION OF
'EXECUTE-STOP' AND 'FETCH-STOP' KNOBS?).  SOPHISTICATED SYSTEMS WITH HIGH-LEVEL
EXECUTIVE PROGRAMS STILL ALLOW THIS TODAY, BUT IN THE APPLE WE HAVE TO BE A
LITLE MORE IMAGINATIVE.

  IN ALL APPLE II SYSTEMS, THE INSTRUCTION SEQUENCE '4C 59 FF' OR JMP FF59 GOES
TO THE RESET CODE AND PROVIDES A POSITIVE, PERMANENT STOPPING PLACE FROM
ANYPLACE IN ASSEMBLY LANGUAGE CODE, AND HALTS WITH A WELL-DEFINED MACHINE STATE.
WHENEVER WE WANT TO SET A "BREAKPOINT" IN THE APPLE, WE CAN REPLACE ANY THREE
BYTES OF CODE WITH '4C 59 FF'.

  TO BEGIN THE PROCESS, LETS LOOK AT SOME CODE FROM PART OF THE CONTROLLER CARD
BOOT ROM:

  C600- A2 20	    LDX #$20
C602-	A0 00	    LDY   #$00
C604-	A2 03	    LDX   #$03
	   !
	   !
C621-	20 58 FF    JSR   $FF58
C625-	BD 00 01    LDA   $0100,X
C628-	0A	    ASL
C629-	0A	    ASL
C62A-	0A	    ASL
C62B-	0A	    ASL
C62C-	85 2B	    STA   $2B
C62E-	AA	    TAX
C62F-	BD 8E C0    LDA   $C08E,X
	    !
	    !
C658-	A9 08	    LDA   #$08
C65A-	85 27	    STA   $27
C65C-	18	    CLC
C65D-	08	    PHP
C65E-	BD 8C C0    LDA   $C08C,X
C661-	10 FB	    BPL   $C65E
C663-	49 D5	    EOR   #$D5
C665-	D0 F7	    BNE   $C65E
C667-	BD 8C C0    LDA   $C08C,X
C66A-	10 FB	    BPL   $C667
C66C-	C9 AA	    CMP   #$AA
C66E-	D0 F3	    BNE   $C663
C670-	EA	    NOP
C671-	BD 8C C0    LDA   $C08C,X
C674-	10 FB	    BPL   $C671
C676-	C9 96	    CMP   #$96
C678-	F0 09	    BEQ   $C683
	     !
	     !
C6E6-	91 26	    STA   ($26),Y
C6E8-	C8	    INY
C6E9-	D0 EE	    BNE   $C6D9
C6EB-	E6 27	    INC   $27
C6ED-	E6 3D	    INC   $3D
C6EF-	A5 3D	    LDA   $3D
C6F1-	CD 00 08    CMP   $0800
C6F4-	A6 2B	    LDX   $2B
C6F6-	90 DB	    BCC   $C6D3
C6F8-	4C 01 08    JMP   $0801
C6FB-	00	    BRK
C6FC-	00	    BRK
C6FD-	00	    BRK


  NOTICE THE INSTRUCTION 'JMP $0801' AT C6F8.  THIS IS THE "LINK" TO STAGE 1 OF
THE BOOT.  IF WE COULD CHANGE IT TO 'JMP FF59', *EVERY* DISK WE BOOTED WOULD
LOAD IN THE FIRST SECTOR, BEEP INTO THE MONITOR, AND OBLIGINGLY WAIT WHILE WE
SNOOP THROUGH PAGE 8 TO OUR HEART'S CONTENT.  SINCE THE PROGRAM IS IN ROM, WE
CAN'T ALTER IT, BUT WE CAN COPY IT DOWN TO A COMPATIBLE LOCATION AND ALTER IT SO
THAT THE PROGRAM HALTS INSTEAD OF CONTINUING WITH THE BOOT PROCESS.  BECAUSE THE
BOOT CODE HAS TO EXECUTE FROM AN} SLOT, IT CONTAINS A "WHERE ARE WE" ROUTINE AT
C621-C62E TO FIND OUT WHAT ITS CURRENT LOCATION IS.  HAPPILY FOR US, THIS KIND
OF RELOCATABLE CODE WILL RUN MANY PLACES BESIDES THE C100-C7FF PERIPHERAL ROM
SPACE (SEE THE REFERENCE MANUAL P.  81 FOR A DESCRIPTION OF THE "WHERE ARE WE"
ROUTINE).  MR.	XEROX'S FAMOUS MONITOR INSTRUCTIONS WHICH RELOCATE THE BOOT ROM
CODE AND INSERT THE FIRST BREAKPOINT ARE:


	9600<C600.C6FFM
	96F8:4C 59 FF

  (NOTE-PAGE 96 IS NOT REQUIRED, BUT THE PAGE YOU USE MUST END IN 6 SO THAT SLOT
6 IS DECODED AS THE CONTROLLER CARD LOACTION).	THE LAST FEW LINES OF THE
(RELOCATED) BOOT ROM CODE NOW READ:

96F4-	A6 2B	    LDX $2B
96F6-	90 DB	    BCC $96D3
96F8-	4C 59 FF    JMP $FF59

SO THAT TYPING:

	9600G


  WILL INITIATE A BOOT SEQUENCE FROM OUR CODE AT 9600 WHICH ENDS AT THE "BREAK
POINT" AT $96F8, RATHER THAN CONTINUING THE BOOT.  IF YOU TRY THIS, YOU'LL FIND
THAT THE DISK IS STILL SPINNING, AND YOU CAN TURN IT OFF BY INCLUDING THE
INSTRUCTION '2C E8 C0' (BIT C0E8) AT 96F8 BEFORE THE JMP FF59, OR YOU CAN JUST
TYPE 'C0E8' FROM THE MONITOR.  AFTER PAGE 8 HAS BEEN LOADED WITH THE STAGE 1
BOOT CODE, THE FUN BEGINS (UNTIL YOU GET GOOD AT THIS, IT'S A GOOD IDEA TO SAVE
EACH PIECE OF BOOT CODE AS A BFILE ON A SPARE DISK BEFORE PROCEEDING.  IT'S
USUALLY EASIER THAN RUNNING THROUGH THE ENTIRE SEQUENCE EACH TIME A STEP DOESN'T
WORK AS YOU EXPECT, AND IT WILL MAKE IT EASIER TO PRINT OUT A DISASSEMBLY OF THE
CODE TO FIGURE OUT WHAT IT DOES.


  AT THIS POINT, PAGE 8 MUST CONTAIN STAGE 1 OF THE BOOT WITH LOCATION $801 AS
THE STARTING POINT.  IF THE FIRST STAGE IS KOSHER, LOCATION $84A CONTAINS '6C FD
08', WHICH IS AN INDIRECT JUMP THROUGH THE LOCATION IN 8FD & 8FE.  THIS IS THE
EXIT POINT OF THE STAGE ONE BOOT, AND NORMALLY JUMPS TO B700 TO BEGIN READING IN
THE CODE FOR STAGE 2 (THE B6 AT 8FE BECOMES B7 DURING THE 10-SECTOR LOAD).  TO
CONTINUE OUR MISSION, WE MUST LOCATE THE EXIT POINT OF THIS STAGE AND INSERT A
BREAKPOINT.



0801-	A5 27	    LDA   $27
0803-	C9 09	    CMP   #$09
0805-	D0 18	    BNE   $081F
0807-	A5 2B	    LDA   $2B
0809-	4A	    LSR
080A-	4A	    LSR
080B-	4A	    LSR
080C-	4A	    LSR
080D-	09 C0	    ORA   #$C0
080F-	85 3F	    STA   $3F
0811-	A9 5C	    LDA   #$5C
0813-	85 3E	    STA   $3E
0815-	18	    CLC
0816-	AD FE 08    LDA   $08FE
0819-	6D FF 08    ADC   $08FF
081C-	8D FE 08    STA   $08FE
081F-	AE FF 08    LDX   $08FF
0822-	30 15	    BMI   $0839
0824-	BD 4D 08    LDA   $084D,X
0827-	85 3D	    STA   $3D
0829-	CE FF 08    DGC   $08FF
082C-	AD FE 08    LDA   $08FE
082F-	85 27	    STA   $27
0831-	CE FE 08    DEC   $08FE
0834-	A6 2B	    LDX   $2B
0836-	6C 3E 00    JMP   ($003E)
0839-	EE FE 08    INC   $08FE
083C-	EE FE 08    INC   $08FE
083F-	20 89 FE    JSR   $FE89
0842-	20 93 FE    JSR   $FE93
0845-	20 2F FB    JSR   $FB2F
0848-	A6 2B	    LDX   $2B
084A-	6C FD 08    JMP   ($08FD)
084D-	00	    BRK
084E-	0D 0B 09    ORA   $090B
0851-	07	    ???
0852-	05 03	    ORA   $03
0854-	01 0E	    ORA   ($0E,X)
0856-	0C	    ???
0857-	0A	    ASL
0858-	08	    PHP
0859-	06 04	    ASL   $04
085B-	02	    ???
085C-	0F	    ???
085D-	00	    BRK
	 !
	 !
08FD-	00	    BRK
08FE-	B6 09	    LDX   $09,Y

  NONSTANDARD FORMATS CAN HAVE ANY NUMBER OF EXIT INSTRUCTIONS, AND THIS IS
WHERE YOUR KNOWLEDGE OF ASSEMBLY LANGUAGE AND EXPERIENCE AT READING CODE WILL
START TO PAY OFF.  UNLESS THE FIRST STAGE IS RELATIVELY STANDARD, IT'S NECESSARY
TO SPEND TIME EXAMINING AND TEARING APART THE CODE UNTIL YOU UNDERSTAND WHAT'S
GOING ON.  LOOK FIRST FOR A JUMP OR INDIRECT JUMP TO SOMEPLACE OUTSIDE OF PAGE
8, AND CHANGE THAT TO JMP FF59.  IF NONE APPEARS, LOOK FOR A "JUMP THROUGH THE
STACK" TRICK AS DESCRIBED IN THE ARCADG MACHINE FILE:  FOR EXAMPLE, TO GO TO
$BB00 THERE WILL BE, SOMEWHERE IN THE CODE, TWO "PHA'S" AND AN "RTS".  THE FIRST
PUSH ONTO THE STACK WOULD BE $BA; THE SECOND $FF.  WHEN THE RTS IS EXECUTED, THE
TWO BYTES ARE PULLED OFF THE STACK, INCREMENTED BY ONE TO BB00, AND JUMPED TO.
IN ADDITION, MORE THAN ONE PAGE CAN BE LOADED UNDER STAGE 0, AND ACCESSED BY A
RELATIVE BRANCH INSTRUCTIoN, SO YOU'LL HAVE TO EXAMINE <ALL> THE CODE LOADED IN
(IT'S GOOD PRACTICE TO CLEAR OUT ALL OF MEMORY BEFORE STARTING; THIS WILL WORK
IF DOS IS NOT ACTIVE:

800:0 N 801<800.BFFFM).

  WHEN YOU FIND THE EXIT POINT, MAKE IT A BREAKPOINT WITH '4C 59 FF' TO PREVENT
THE CONTINUATION OF THE BOOT.  BEFORE PROCEEDING, TAKE A GOOD LOOK AT ALL THE
CODE TO BE SURE YOU UNDERSTAND WHERE THE NEXT STAGE LOADS, AND ANY UNUSUAL
CONDITIONS OR INSTRUCTIONS.


  THE ALTERED PORTION OF CODE IS NOW:


0839-	EE FE 08    INC   $08FE
083C-	EE FE 08    INC   $08FE
083F-	20 89 FG    JSR   $FE89
0842-	20 93 FE    JSR   $FE93
0845-	20 2F FB    JSR   $FB2F
0848-	A6 2B	    LDX   $2B
084A-	4C 59 FF    JMP   $FF59
084D-	00	    BRK

  THE THEORY NOW IS TO ALLOW THE BOOT TO PROCEED THROUGH ONE MORE STAGE, HALTING
AFTER RWTS HAS BEEN READ IN, AND GIVING US A CHANCE TO EXAMINE THAT PORTION OF
THE PROGRAM FOR ALTERATIONS.  IF WE JUST REBOOTED WITH '9600G', THE ORIGINAL
CODE WOULD OVERWRITE OUR ALTERED PAGE 8, SO WE HAVE TO ARRANGE IT SO THAT THE
FIRST STAGE BOOT CODE IS SENT OFF INTO OBLIVION.  REFERRING BACK TO THE BOOT
CODE, LOCATION 9658 (ORIGINALLY C658) CONTAINS THE PAGE NUMBER WHERE T0, S0
LOADS IN, NORMALLY 08.	CHANGING IT TO $20 WILL CAUSE T0, S0 TO LOAD INTO $2000
INSTEAD OF $0800, AND THE BOOT WILL CONTINUE THROUGH OUR ALTERED PAGE 8.  NOTE
THAT WE HAVE TO REMOVE THE FIRST BREAK POINT AT 96F8 AND RESTORE THE ORIGINAL
JMP $0801:

	   9658:20
	   96F8:4C 01 08

  NOW, WHEN WE TYPE '9600G', THE BOOT CODE WILL LOAD T0, S0 INTO $2000-20FF,
WHERE IT WON'T BOTHER US AT ALL, THEN JUMP TO 801 TO EXECUTE OUR CODE.  AFTER
RWTS HAS BEEN LOADED IN, INSTEAD OF JUMPING TO $B700 TO CONTINUE LOADING DOS,
THE PROGRAM HITS THE (SECOND) BREAK POINT AT 84A AND HALTS.

  THE FINAL PHASE OF THIS PROCESS IS TO LOCATE THE EXIT POINT FROM THIS AREA OF
CODE, INSERT ANOTHER BREAKPOINT, AND EXAMINE ALL THE CODE LOADED IN BY STAGE 2.
AGAIN, WE HAVE TO MAKE SURE THAT THE BOOT PROCESS DOESN'T OVERWRITE THE CHANGES,
WHICH MEANS WE HAVE TO UNDERSTAND HOW THE DESTINATION ADDRESSES ARE SET UP IN
STAGE 1.  EVEN IN NORMAL DOS IT'S NOT OBVIOUS, BUT ENOUGH HEAD-SCRATCHING OR
READING OF BENEATH APPLE DOS WILL REVEAL DHAT THE BYTE IN LOCATION 8FE IS ONE
HIGHER THAN THE FIRST PAGE LOADED INTO, AND THE BYTE AT 8FF IS ONE LESS THAN THE
NUMBER OF SECTORS TO BE LOADED.  AS BEFORE, WE REMOVE THE PREVIOUS BREAKPOINT,
ALTER THE DESTINATION OF THE REAL CODE LOADED IN UNDER THIS STAGE, AND SET THE
NEW BREAKPOINT:

B700-	8E E9 B7    STX   $B7E9
B703-	8E F7 B7    STX   $B7F7
B706-	A9 01	    LDA   #$01
B708-	8D F8 B7    STA   $B7F8
B70B-	8D EA B7    STA   $B7EA
B70E-	AD E0 B7    LDA   $B7E0
B711-	8D E1 B7    STA   $B7E1
B714-	A9 02	    LDA   #$02
B716-	8D EC B7    STA   $B7EC
B719-	A9 04	    LDA   #$04
B71B-	8D ED B7    STA   $B7ED
B71E-	AC E7 B7    LDY   $B7E7
	   !
	   !
B738-	20 93 B7    JSR   $B793
B73B-	A2 FF	    LDX   #$FF
B73D-	9A	    TXS
B73E-	8E EB B7    STX   $B7EB
B741-	4C C8 BF    JMP   $BFC8
B744-	20 89 FE    JSR   $FE89
B747-	4C 84 9D    JMP   $9D84

THE CHANGES ARE:


      84A:4C 00 B7
  (WE CAN'T USE THE INDIRECT JUMP IN THE ORIGINAL, SMNCE WE HAVE REDIRECTED THE
BOOT)

      8FE:20 09
  (PAGE 20 OR ANYPLACE ELSE WHERE 10 PAGES OF CODE WON'T HURT ANYTHING)


      B747:4C 59 FF
  (JMP 9D84 IS THE DOS COLD- START.  THE JMP BFC8 IS A PATCH WHICH RETURNS WITH
A JMP B744)



THE LAST FEW LINES OF CODE ARE NOW:


B741-	4C C8 BF    JMP $BFC8
B744-	20 89 FE    JSR $FE89
B747-	4C 59 FF    JMP $FF59

  NOW TYPE '9600G', AND LET'S RECAP THE PROCESS THAT WILL OCCUR:

  1.  THE MODIFIED STAGE 0 CODE AT 9600-96FF WILL LOAD T0, S0 INTO PAGE 20
(SINCE WE DON'T WANT IT), THEN JUMP TO THE START OF OUR MODIFIED PAGE 8 AT 801.

  2.  THE MODIFIED PAGE 8 WILL LOAD T0, S0 THROUGH T0, S9 INTO PAGES 20 TO 2=,
THEN JUMP TO OUR MODIFIED CODE AT B700.

  3.  THE MODIFIED CODE AT B700 WILL LOAD 27 SECTORS OF DOS INTO PAGES 9A-B5,
THEN HALT WHEN IT HITS THE BREAKPOINT AT B747.


---------------------------------------
***************************************
*				      *
*				      *
*				      *
*     THE BASICS OF KRACKING 109:     *
*				      *
*    BOOT-TRACING PART 2- RDF 1985    *
*				      *
*				      *
*				      *
***************************************

THIS IS THE SECOND PART OF THE BOOT-TRACING EPISODE--IT'S PROBABLY NOT HAZARDOUS
TO YOUR HEALTH TO READ THIS BEFORE YOU LOOK AT PART 1 (BASICS 108), BUT IT'LL
MAKE A MORE SENSE TO READ 108 FIRST IF YOU'RE NOT INTIMATELY FAMILIAR WITH THE
SUBJECT.  THE THEORY (?) WAS ALL IN THE FIRST PART; THIS IS JUST AN EXAMPLE,
WITH A LOT OF DISASSEMBLED CODE, OF THE USE OF BOOT-TRACING TO LOOK AT (BUT NOT
REALLY TO KRACK) A NOT-TOO-UNUSUAL DISK:  RDF 1985 FROM THOSE FUN-LOVING WAR
GAME FREAKS AT SSI.  THIS LOADER/DOS APPEARS TO BE THE SUCCESSOR TO RDOS 2.1,
WHICH WAS THE LATE UNLAMENTED OPERATING SYSTEM THAT KEPT SO MANY DISKS FROM
BEING UNPROTECTED FOR SO LONG.

APPROACHING THIS DISK AS WE WOULD ANY OTHER, WE ENTER THE MONITOR AND SET THE
FIRST BREAKPOINT BY TYPING:

	 9600<C600.C6FFM
	 96F9:59 FF
	 9600G

AFTER THE BEEP, AND C0E8 TO DESPIN THE DISK, 801LLLL GETS US THE FOLLOWING:

0801-	A6 2B	    LDX   $2B
0803-	8E 1F 02    STX   $021F
0806-	A9 02	    LDA   #$02
0808-	8D 20 02    STA   $0220
080B-	18	    CLC
080C-	08	    PHP
080D-	BD 8C C0    LDA   $C08C,X
0810-	10 FB	    BPL   $080D
0812-	49 D5	    EOR   #$D5
0814-	D0 F7	    BNE   $080D
0816-	BD 8C C0    LDA   $C08C,X
0819-	10 FB	    BPL   $0816
081B-	C9 AA	    CMP   #$AA
081D-	D0 F3	    BNE   $0812
081F-	EA	    NOP
0820-	BD 8C C0    LDA   $C08C,X
0823-	10 FB	    BPL   $0820
0825-	C9 B5	    CMP   #$B5
0827-	F0 09	    BEQ   $0832
0829-	28	    PLP
082A-	90 DF	    BCC   $080B
082C-	49 AD	    EOR   #$AD
082E-	F0 20	    BEQ   $0850
0830-	D0 D9	    BNE   $080B
0832-	A0 03	    LDY   #$03
0834-	84 2A	    STY   $2A
0836-	BD 8C C0    LDA   $C08C,X
0839-	10 FB	    BPL   $0836
083B-	2A	    ROL
083C-	85 3C	    STA   $3C
083E-	BD 8C C0    LDA   $C08C,X
0841-	10 FB	    BPL   $083E
0843-	25 3C	    AND   $3C
0845-	88	    DEY
0846-	D0 EE	    BNE   $0836
0848-	28	    PLP
0849-	CD 20 02    CMP   $0220
084C-	D0 BD	    BNE   $080B
084E-	B0 BC	    BCS   $080C
0850-	A0 00	    LDY   #$00
0852-	A9 00	    LDA   #$00
0854-	85 47	    STA   $47
0856-	BD 8C C0    LDA   $C08C,X
0859-	10 FB	    BPL   $0856
085B-	29 55	    AND   #$55
085D-	0A	    ASL
085E-	85 46	    STA   $46
0860-	BD 8C C0    LDA   $C08C,X
0863-	10 FB	    BPL   $0860
0865-	29 55	    AND   #$55
0867-	05 46	    ORA   $46
0869-	45 47	    EOR   $47
086B-	85 47	    STA   $47
086D-	99 00 10    STA   $1000,Y
0870-	C8	    INY
0871-	D0 E3	    BNE   $0856
0873-	BD 8C C0    LDA   $C08C,X
0876-	10 FB	    BPL   $0873
0878-	29 55	    AND   #$55
087A-	0A	    ASL
087B-	85 46	    STA   $46
087D-	BD 8C C0    LDA   $C08C,X
0880-	10 FB	    BPL   $087D
0882-	29 55	    AND   #$55
0884-	05 46	    ORA   $46
0886-	45 47	    EOR   $47
0888-	F0 02	    BEQ   $088C
088A-	D0 A4	    BNE   $0830
088C-	4C 00 10    JMP   $1000


  A FEW THINGS ARE WORTH POINTING OUT BEFORE WE CONTINUE THE TRACE.  NOTICE THAT
THE EARLY PART IS AN ADAPTATION OF THE BOOT ROM CODE:  IF THE CARRY BIT IS
CLEAR, IT'S LOOKING FOR D5 AA B5 TO READ IN THE ADDRESS FIELD (SOME THINGS NEVER
CHANGE), IF THE CARRY IS SET, D5 AA AD IS BEING SOUGHT FOR THE DATA FIELD
PROLOG.  AFTER VERIFYING THE VOLUME, TRACK, AND SECTOR (832-846), WE READ IN A
SINGLE "PSEUDO-SECTOR" IN 4+4 NIBBLIZING, STORING IT AT $1000.  IF THE CHECKSUM
IS RIGHT ($888), THEN WE JUMP TO 1000 TO CONTINUE THE BOOT.  IF YOU'VE BEEN
KEEPING UP, YOU KNOW THE NEXT SERIES OF MONITOR INSTRUCTIONS TO SET BREAKPOINT
#2:

	   96F9:01 08
	   9659:20
	   088C:4C 59 FF
	   9600G

THE CODE LOADED INTO PAGE $10 IS:

1000-	D8	    CLD
1001-	D8	    CLD
1002-	A9 00	    LDA   #$00
1004-	8D F2 03    STA   $03F2
1007-	A9 E0	    LDA   #$E0
1009-	8D F3 03    STA   $03F3
100C-	49 A5	    EOR   #$A5
100E-	8D F4 03    STA   $03F4
1011-	A9 4C	    LDA   #$4C
1013-	8D D0 03    STA   $03D0
1016-	A9 00	    LDA   #$00
1018-	8D D1 03    STA   $03D1
101B-	A9 BD	    LDA   #$BD
101D-	8D D2 03    STA   $03D2
1020-	AD 1F 02    LDA   $021F
1023-	8D D3 03    STA   $03D3
1026-	A9 01	    LDA   #$01
1028-	8D D4 03    STA   $03D4
102B-	A9 03	    LDA   #$03
102D-	8D 20 02    STA   $0220

1030-	A9 BD	    LDA   #$BD
1032-	8D 99 10    STA   $1099

1035-	18	    CLC
1036-	08	    PHP
1037-	BD 8C C0    LDA   $C08C,X
103A-	10 FB	    BPL   $1037
103C-	49 D5	    EOR   #$D5
103E-	D0 F7	    BNE   $1037
1040-	BD 8C C0    LDA   $C08C,X
1043-	10 FB	    BPL   $1040
1045-	C9 AA	    CMP   #$AA
1047-	D0 F3	    BNE   $103C
1049-	EA	    NOP
104A-	BD 8C C0    LDA   $C08C,X
104D-	10 FB	    BPL   $104A
104F-	C9 B5	    CMP   #$B5
1051-	F0 09	    BEQ   $105C
1053-	28	    PLP
1054-	90 DF	    BCC   $1035
1056-	49 AD	    EOR   #$AD
1058-	F0 20	    BEQ   $107A
105A-	D0 D9	    BNE   $1035
105C-	A0 03	    LDY   #$03
105E-	84 2A	    STY   $2A
1060-	BD 8C C0    LDA   $C08C,X
1063-	10 FB	    BPL   $1060
1065-	2A	    ROL
1066-	85 3C	    STA   $3C
1068-	BD 8C C0    LDA   $C08C,X
106B-	10 FB	    BPL   $1068
106D-	25 3C	    AND   $3C
106F-	88	    DEY
1070-	D0 EE	    BNE   $1060
1072-	28	    PLP
1073-	CD 20 02    CMP   $0220
1076-	D0 BD	    BNE   $1035
1078-	B0 BC	    BCS   $1036
107A-	A0 00	    LDY   #$00
107C-	A9 00	    LDA   #$00
107E-	85 47	    STA   $47
1080-	BD 8C C0    LDA   $C08C,X
1083-	10 FB	    BPL   $1080
1085-	29 55	    AND   #$55
1087-	0A	    ASL
1088-	85 46	    STA   $46
108A-	BD 8C C0    LDA   $C08C,X
108D-	10 FB	    BPL   $108A
108F-	29 55	    AND   #$55
1091-	05 46	    ORA   $46
1093-	45 47	    EOR   $47
1095-	85 47	    STA   $47

1097-	99 00 10    STA   $1000,Y

109A-	C8	    INY
109B-	D0 E3	    BNE   $1080
109D-	BD 8C C0    LDA   $C08C,X
10A0-	10 FB	    BPL   $109D
10A2-	29 55	    AND   #$55
10A4-	0A	    ASL
10A5-	85 46	    STA   $46
10A7-	BD 8C C0    LDA   $C08C,X
10AA-	10 FB	    BPL   $10A7
10AC-	29 55	    AND   #$55
10AE-	05 46	    ORA   $46
10B0-	45 47	    EOR   $47
10B2-	F0 02	    BEQ   $10B6
10B4-	D0 A4	    BNE   $105A
10B6-	EE 99 10    INC   $1099
10B9-	AD 99 10    LDA   $1099
10BC-	C9 C0	    CMP   #$C0
10BE-	F0 06	    BEQ   $10C6
10C0-	EE 20 02    INC   $0220
10C3-	4C 35 10    JMP   $1035
10C6-	A9 BA	    LDA   #$BA
10C8-	85 00	    STA   $00
10CA-	A9 BC	    LDA   #$BC
10CC-	85 01	    STA   $01
10CE-	A9 01	    LDA   #$01
10D0-	85 03	    STA   $03
10D2-	A9 00	    LDA   #$00
10D4-	85 04	    STA   $04
10D6-	A9 06	    LDA   #$06
10D8-	85 05	    STA   $05
10DA-	20 D0 03    JSR   $03D0
10DD-	A9 F0	    LDA   #$F0
10DF-	85 36	    STA   $36
10E1-	A9 FD	    LDA   #$FD
10E3-	85 37	    STA   $37
10E5-	4C 00 BA    JMP   $BA00

  THE EARLY PART FROM 1002-102D SETS UP THE 3D0-3FF REGION AS VECTORS FOR THE
"DOS" CALLS TO BE MADE, THEN STORES $BD IN $1099 FOR THE PAGE NUMBER TO BEGIN
LOADING IN THE NEXT PORTION OF THE BOOT.  AFTER THAT, THE CODE FROM 80C-847 IS
MIRRORED TO LOAD IN THE NEXT STAGE.  THE THREE LINES AT 10B6-10BF INDICATE THAT
THE LOAD CONTINUES UNTIL PAGES BD, BE, AND BF HAVE BEEN LOADED, THEN QUITS AT
PAGE $C0.  YOU WOULD NORMALLY EXPECT TO FIND A "JMP BD00" AS THE EXIT POINT FROM
THIS STAGE OF THE BOOT; INSTEAD THERE IS A "JMP BA00" AT 10E5.  THE REASON IS
THAT LINES 10C6- 10DA CALL THE NEWLY-LOADED LOADER ROUTINE AT BD00 THROUGH THE
VECTOR AT 3D0.	BY LOOKING AT THE SETUP FOR THAT LOAD, WE CAN LEARN A LITTLE
ABOUT THE LOADER.  THE IMPORTANT PARTS OF ANY LOADER ROUTINE ARE THE DESTINATION
PAGE, THE LENGTH OF THE LOAD, AND THE TRACK AND SECTOR TO BEGIN LOADING FROM.
IN THIS CASE, THE FIRST AND LAST DESTINATION PAGE ARE LOADED INTO LOCATIONS 0
AND 1, AND THE TRACK AND SECTOR IN 4 AND 5.  AFTER THAT, A CALL TO THE 3D0
VECTOR JUMPS MERRILY UP TO BD00, WHICH IS THE "RWTS" ROUTINE FOR THIS PROGRAM.


  WE CAN VIEW ALL OF THAT BY SETTING THE NEXT BREAKPOINT AT 10E5 AND REBOOTING
FOR WHAT IS HOPEFULLY THE LAST TIME:

	   086F:20
	   088C:4C 00 10
	   10E5:4C 59 FF
	   9600G

  SINCE THE EXIT POINT SAID JUMP BA00, LETS LOOK AT THAT CODE:


BA00-	D8	    CLD
BA01-	4C 00 BC    JMP   $BC00
BA04-	A5 8D	    LDA   $8D
BA06-	9E	    ???

  THE REST OF THE PAGE IS OF NO INTEREST, SO LET'S FOLLOW THE JUMP TO BC00:

BC00-	AD 00 08    LDA   $0800
BC03-	C9 EA	    CMP   #$EA
BC05-	D0 0D	    BNE   $BC14
BC07-	A2 05	    LDX   #$05
BC09-	BD BE BC    LDA   $BCBE,X
BC0C-	95 00	    STA   $00,X
BC0E-	CA	    DEX
BC0F-	10 F8	    BPL   $BC09
BC11-	20 D0 03    JSR   $03D0
BC14-	AD D7 BC    LDA   $BCD7
BC17-	D0 48	    BNE   $BC61
BC19-	AD 81 C0    LDA   $C081
BC1C-	A9 00	    LDA   #$00
BC1E-	8D F2 03    STA   $03F2
BC21-	A9 BC	    LDA   #$BC
BC23-	8D F3 03    STA   $03F3
BC26-	A9 19	    LDA   #$19
BC28-	8D F4 03    STA   $03F4
BC2B-	A9 00	    LDA   #$00
BC2D-	8D 11 03    STA   $0311
BC30-	A9 00	    LDA   #$00
BC32-	8D 13 03    STA   $0313
BC35-	A2 05	    LDX   #$05
BC37-	BD AC BC    LDA   $BCAC,X
BC3A-	95 00	    STA   $00,X
BC3C-	CA	    DEX
BC3D-	10 F8	    BPL   $BC37
BC3F-	20 D0 03    JSR   $03D0
BC42-	A9 00	    LDA   #$00
BC44-	8D 12 03    STA   $0312
BC47-	20 00 A8    JSR   $A800
BC4A-	EE D7 BC    INC   $BCD7
BC4D-	AD 12 03    LDA   $0312
BC50-	C9 02	    CMP   #$02
BC52-	F0 70	    BEQ   $BCC4
BC54-	A2 05	    LDX   #$05
BC56-	BD B2 BC    LDA   $BCB2,X
BC59-	95 00	    STA   $00,X
BC5B-	CA	    DEX
BC5C-	10 F8	    BPL   $BC56
BC5E-	20 D0 03    JSR   $03D0
BC61-	AD 12 03    LDA   $0312
BC64-	D0 5E	    BNE   $5CC4
BC66-	A9 25	    LDA   #$25
BC68-	85 03	    STA   $03
BC6A-	A9 00	    LDA   #$00
BC6C-	8D 10 03    STA   $0310
BC6F-	2C 10 C0    BIT   $C010
BC72-	A2 06	    LDX   #$06
BC74-	A9 80	    LDA   #$80
BC76-	95 F6	    STA   $F6,X
BC78-	CA	    DEX
BC79-	10 FB	    BPL   $BC76
BC7B-	AD 50 C0    LDA   $C050
BC7E-	AD 54 C0    LDA   $C054
BC81-	AD 57 C0    LDA   $C057
BC84-	AD 09 03    LDA   $0309
BC87-	F0 06	    BEQ   $BC8F
BC89-	AD 52 C0    LDA   $C052
BC8C-	4C 92 BC    JMP   $BC92
BC8F-	AD 53 C0    LDA   $C053
BC92-	A9 00	    LDA   #$00
BC94-	8D 14 03    STA   $0314
BC97-	8D 07 03    STA   $0307
BC9A-	20 00 65    JSR   $6500
BC9D-	AD 11 03    LDA   $0311
BCA0-	D0 8E	    BNE   $BC30
BCA2-	AD 12 03    LDA   $0312
BCA5-	C9 01	    CMP   #$01
BCA7-	F0 1B	    BEQ   $5CC4
BCA9-	4C 00 E0    JMP   $E000

BCAC-	A8	    TAY
BCAD-	BB	    ???
BCAE-	00	    BRK
BCAF-	01 01	    ORA   ($01,X)
BCB1-	00	    BRK

BCB2-	A8	    TAY
BCB3-	BB	    ???
BCB4-	00	    BRK
BCB5-	01 13	    ORA   ($13,X)
BCB7-	00	    BRK

BCB8-	A8	    TAY
BCB9-	BB	    ???
BCBA-	00	    BRK
BCBB-	01 15	    ORA   ($15,X)
BCBD-	00	    BRK

BCBE-	08	    PHP
BCBF-	14	    ???
BCC0-	00	    BRK
BCC1-	01 03	    ORA   ($03,X)
BCC3-	00	    BRK

BCC4-	A2 05	    LDX   #$05
BCC6-	BD B8 BC    LDA   $BCB8,X
BCCB-	CA	    DEX
BCCC-	10 F8	    BPL   $BCC6
BCD1-	20 00 A8    JSR   $A800
BCD4-	4C 54 BC    JMP   $BC54


  FINALLY, HERE'S THE MEAT OF THE PROGRAM.  BC00 IS A TEST TO SEE IF IT'S THE
FIRST TIME THROUGH--LOCATION 800 IS 01 THE FIRST TIME, SO WE TRANSFER THE 5
VALUES FOUND AT BCBE-BCC3 INTO LOCATIONS 0-5, THEN CALL THE LOADER ROUTINE, AND
PAGES 8-14 ARE LOADED FROM TRACK 3, SECTOR 0.  AT BC1C-BC2B, WE SET THE RESET
VECTOR TO RETURN TO BC00 (AND RESTART THE GAME) WHENEVER RESET IS PRESSED (THE
REFERENCE MANUAL TELLS YOU HOW ON P.  37; IT'S P.  82 IN THE IIE MANUAL, IF YOU
GOT RIPPED OFF FOR THAT ONE).  NEXT, PAGES A8-BB ARE LOADED FROM T1, S0, AND THE
GAME BEGINS IN EARNEST.

  ORDINARILY, THIS IS ABOUT AS FAR AS BOOT-TRACING CAN TAKE YOU INTO THE
ORGANIZATION OF A DISK.  JUST FOR THE EXERCISE, HOWEVER, LET'S PRETEND WE REALLY
WANT TO FIND OUT WHAT GETS LOADED INTO PAGES A8-BB BEFORE THE GAME STARTS.  THE
BREAKPOINT GOES IN...

	    10E5:4C 00 BA
	    1099:20
	    10BD:23 (UNLESS YOU KNOW
		     IT'S SAFE, KEEP
		     THE # OF PAGES THE
		     SAME)
	    BC47:4C 59 FF

SEE WHAT THAT CODE LOOKS LIKE BEFORE IT HAS A CHANCE TO UNSCRUNCH A PICTURE OR
WHATEVER ELSE IT IS GOING TO DO.  ALSO, NOTICE THAT THE CODE AT BC54 AND AT THE
ALTERNATIVE DESTINATION OF BCC4 BOTH LOAD OVER PAGES A8-BB.  IF NECESSARY, WE
COULD CONTINUE WITH THIS PROCESS, PUTTING A BREAKPOINT AFTER EACH LOAD, UNTIL WE
HAVE EXAMINED, SAVED, OR ALTERED EVERY ACCESSIBLE PART OF THE PROGRAM.

  SO MUCH FOR THE "EASY" PART--NOW THE HARD WORK BEGINS.  WE HAVE LEARNED ABOUT
ALL WE NEED TO KNOW ABOUT THE LOADER, BUT NOW WE HAVE TO FIND A WAY TO PUT ALL
OF THIS INTO A FORMAT WHICH UNLESS WE CAN USE DOS ON THE LANGUAGE CARD,
CONSIDERING THAT ALL OF THESE FILES LOAD RIGHT OVER THE MIDDLE OF DOS), OR
CONVERT THE 4+4 NIBBLIZED SECTORS INTO STANDARD DOS 3.3 SECTORS (ALSO NOT TOO
EASY, CONSIDERING THAT WE ONLY HAVE 3 PAGES FOR THE "DOS").

  IN CONCLUSION, YOU SHOULD BE AWARE THAT THE TECHNIQUES DESCRIBED HERE WORK
EQUALLY WELL ON AN APPLE IIE (I HELD OUT FOR ALMOST 8 MONTHS, BUT NOW I CAN
CONTEND THAT ALL THE TYPOS IN THIS EPISODE ARE THE RESULT OF HAVING FUNNY KEYS
LIKE "][" ON AN APPLE KEYBOARD AFTER 5+ YEARS OF TYPING ON GOOD OLD APPLE II S/N
3603).	STAY TUNED FOR AN EXAMPLE WHICH IS A LITTLE MORE COMPLICATED THAN THIS
ONE, AND REQUIRES CHANGES IN THE BOOT-TRACE TECHNIQUE.	ALSO IN THE WINGS IS
(WHAT ELSE) HARDWARE MODIFICATIONS TO THE IIE (NO MOTHER BOARD SURGERY, I
PROMISE) TO ALLOW KRAKROMS, HARD RESETS, AND KREATIVE KRACKING USE OF THE 64K
80-COLUMN BOARD.

-------------------------------------
