/* sockdefs.js */

/*
 * Constants and structures defined by the internet system,
 * Per RFC 790, September 1981, taken from the BSD file netinet/in.h.
 */

/* $Id: sockdefs.js,v 1.1 2001/09/18 21:46:11 rswindell Exp $ */

/*
 * Protocols
 */
var IPPROTO_IP              =0               /* dummy for IP */
var IPPROTO_ICMP            =1               /* control message protocol */
var IPPROTO_IGMP            =2               /* internet group management protocol */
var IPPROTO_GGP             =3               /* gateway^2 (deprecated) */
var IPPROTO_TCP             =6               /* tcp */
var IPPROTO_PUP             =12              /* pup */
var IPPROTO_UDP             =17              /* user datagram protocol */
var IPPROTO_IDP             =22              /* xns idp */
var IPPROTO_ND              =77              /* UNOFFICIAL net disk proto */

var IPPROTO_RAW             =255             /* raw IP packet */
var IPPROTO_MAX             =256

/*
 * Port/socket numbers: network standard functions
 */
var IPPORT_ECHO             =7
var IPPORT_DISCARD          =9
var IPPORT_SYSTAT           =11
var IPPORT_DAYTIME          =13
var IPPORT_NETSTAT          =15
var IPPORT_FTP              =21
var IPPORT_TELNET           =23
var IPPORT_SMTP             =25
var IPPORT_TIMESERVER       =37
var IPPORT_NAMESERVER       =42
var IPPORT_WHOIS            =43
var IPPORT_MTP              =57

/*
 * Port/socket numbers: host specific functions
 */
var IPPORT_TFTP             =69
var IPPORT_RJE              =77
var IPPORT_FINGER           =79
var IPPORT_TTYLINK          =87
var IPPORT_SUPDUP           =95

/*
 * UNIX TCP sockets
 */
var IPPORT_EXECSERVER       =512
var IPPORT_LOGINSERVER      =513
var IPPORT_CMDSERVER        =514
var IPPORT_EFSSERVER        =520

/*
 * UNIX UDP sockets
 */
var IPPORT_BIFFUDP          =512
var IPPORT_WHOSERVER        =513
var IPPORT_ROUTESERVER      =520
                                        /* 520+1 also used */

/*
 * Ports < IPPORT_RESERVED are reserved for
 * privileged processes (e.g. root).
 */
var IPPORT_RESERVED         =1024

/*
 * Types
 */
var SOCK_STREAM     =1               /* stream socket */
var SOCK_DGRAM      =2               /* datagram socket */
var SOCK_RAW        =3               /* raw-protocol interface */
var SOCK_RDM        =4               /* reliably-delivered message */
var SOCK_SEQPACKET  =5               /* sequenced packet stream */

/*
 * Option flags per-socket.
 */
var SO_DEBUG        =0x0001          /* turn on debugging info recording */
var SO_ACCEPTCONN   =0x0002          /* socket has had listen() */
var SO_REUSEADDR    =0x0004          /* allow local address reuse */
var SO_KEEPALIVE    =0x0008          /* keep connections alive */
var SO_DONTROUTE    =0x0010          /* just use interface addresses */
var SO_BROADCAST    =0x0020          /* permit sending of broadcast msgs */
var SO_USELOOPBACK  =0x0040          /* bypass hardware when possible */
var SO_LINGER       =0x0080          /* linger on close if data present */
var SO_OOBINLINE    =0x0100          /* leave received OOB data in line */

var SO_DONTLINGER   =(~SO_LINGER)

/*
 * Additional options.
 */
var SO_SNDBUF       =0x1001          /* send buffer size */
var SO_RCVBUF       =0x1002          /* receive buffer size */
var SO_SNDLOWAT     =0x1003          /* send low-water mark */
var SO_RCVLOWAT     =0x1004          /* receive low-water mark */
var SO_SNDTIMEO     =0x1005          /* send timeout */
var SO_RCVTIMEO     =0x1006          /* receive timeout */
var SO_ERROR        =0x1007          /* get error status and clear */
var SO_TYPE         =0x1008          /* get socket type */

/*
 * WinSock 2 extension -- new options
 */
var SO_GROUP_ID       =0x2001      /* ID of a socket group */
var SO_GROUP_PRIORITY =0x2002      /* the relative priority within a group*/
var SO_MAX_MSG_SIZE   =0x2003      /* maximum message size */
var SO_PROTOCOL_INFOA =0x2004      /* WSAPROTOCOL_INFOA structure */
var SO_PROTOCOL_INFOW =0x2005      /* WSAPROTOCOL_INFOW structure */
var PVD_CONFIG        =0x3001          /* configuration info for service provider */

/*
 * TCP options.
 */
var TCP_NODELAY     =0x0001

/*
 * Level number for (get/set)sockopt() to apply to socket itself.
 */
var SOL_SOCKET      =0xffff          /* options for socket level */
