/* This is the ASCII version of my door app for Synchronet
 * that can solve a Sudoku puzzle.
 *
 * Author: Eric Oulashin (AKA Nightfox)
 * BBS: Digital Distortion
 * BBS address: digdist.bbsindex.com
 *
 * Date       User              Description
 * 2009-11-09 Eric Oulashin     Created
 * 2009-11-15 Eric Oulashin     Updated to make use of the new
 *                              solveSudokuPuzzle() function (in
 *                              DDSudokuSolver_Misc.js) to solve
 *                              the puzzle.
 */

// Create a SudokuSolver object to use for solving the puzzle.
var gSolver = new SudokuSolver();

// Input the puzzle's numbers from the user
var userInput = 0;
console.print("nEnter the Sudoku puzzle numbers (use 0 for a blank space):\r\n");
for (var row = 0; row < 9; ++row)
{
   for (var col = 0; col < 9; ++col)
   {
      userInput = console.getkey(K_NUMBER|K_NOCRLF|K_NOECHO);
      gSolver.grid[row][col] = userInput;
      console.print(userInput);
      if ((col == 2) || (col == 5))
         console.print(" ");
   }
   console.crlf();
   if ((row == 2) || (row == 5))
      console.crlf();
}

// Output the results.  First check to see if the puzzle
// is empty or doesn't contain enough numbers from 1 to 9.
if (gSolver.isEmpty())
   console.print("Can't solve the puzzle because it's empty.\r\n");
else if (gSolver.numSetNumbers() < 17)
   console.print("The puzzle needs at least 17 numbers before being solved.\r\n");
else
{
   // Solve the puzzle
   console.print("Solving...\r\n");
   solveSudokuPuzzle();
   if (gSolver.numSolutions() > 0)
   {
      // Output the solution
      console.print("Here is the solution:\r\n");
      for (var row = 0; row < 9; ++row)
      {
         for (var col = 0; col < 9; ++col)
         {
            console.print(gSolver.getSolutionValue(0, row, col));
            if ((col == 2) || (col == 5))
               console.print(" ");
         }
         console.crlf();
         if ((row == 2) || (row == 5))
            console.crlf();
      }
   }
   else
      console.print("No solution was found.\r\n");
}
console.pause();