/* This is a door app for Synchronet that can solve a Sudoku
 * puzzle.  The algorithm that is used is a brute force
 * algorithm that came from the following Wikipedia page:
 * http://en.wikipedia.org/wiki/Algorithmics_of_sudoku
 *
 * Author: Eric Oulashin (AKA Nightfox)
 * BBS: Digital Distortion
 * BBS address: digdist.bbsindex.com
 *
 * Date       User              Description
 * 2009-11-07 Eric Oulashin     Started
 * 2009-11-08 Eric Oulashin     Worked on the ANSI display and user
 *                              input for the ANSI version..  Also,
 *                              added getANSIDigitInputLocations().
 * 2009-11-09 Eric Oulashin     Added gSudokuSolverVersion and
 *                              gSudokuSolverVersionDate.  Moved
 *                              some things to the _Misc.js script.
 */

// Determine the script's startup directory.
// This code is a trick that was created by Deuce, suggested by Rob Swindell
// as a way to detect which directory the script was executed in.  I've
// shortened the code a little.
var startup_path = '.';
try { throw dig.dist(dist); } catch(e) { startup_path = e.fileName; }
startup_path = backslash(startup_path.replace(/[\/\\][^\/\\]*$/,''));

// Bring in the general stuff
load(startup_path + "DDSudokuSolver_Misc.js");

// Make sure the slashes in startup_path are all consistent.
startup_path = fixPathSlashes(startup_path);

// Use an ANSI interface if the user's terminal supports it; otherwise,
// use a plain text interface.
if (console.term_supports(USER_ANSI))
   load(startup_path + "DDSudokuSolverANSI.js");
else
   load(startup_path + "DDSudokuSolverASCII.js");
console.crlf();
console.pause();
exit(0);
// End of script execution.



////////////////////////////////////////////////////////////////////////////////
// Misc. functions & stuff

function test()
{
   var solver = new SudokuSolver();
   solver.grid[0][3] = 2;
   solver.grid[0][7] = 6;
   solver.grid[0][8] = 3;
   solver.grid[1][0] = 3;
   solver.grid[1][5] = 5;
   solver.grid[1][6] = 4;
   solver.grid[1][8] = 1;
   solver.grid[2][2] = 1;
   solver.grid[2][5] = 3;
   solver.grid[2][6] = 9;
   solver.grid[2][7] = 8;
   solver.grid[3][7] = 9;
   solver.grid[4][3] = 5;
   solver.grid[4][4] = 3;
   solver.grid[4][5] = 8;
   solver.grid[5][1] = 3;
   solver.grid[6][1] = 2;
   solver.grid[6][2] = 6;
   solver.grid[6][3] = 3;
   solver.grid[6][6] = 5;
   solver.grid[7][0] = 5;
   solver.grid[7][2] = 3;
   solver.grid[7][3] = 7;
   solver.grid[7][8] = 8;
   solver.grid[8][0] = 4;
   solver.grid[8][1] = 7;
   solver.grid[8][5] = 1;
   solver.solve();
   if (solver.numSolutions() > 0)
   {
      for (var row = 0; row < 9; ++row)
      {
         for (var col = 0; col < 9; ++col)
         {
            console.print(solver.getSolutionValue(0, row, col));
            if (col % 3 == 2)
               console.print(" ");
         }
         console.crlf();
         if (row % 3 == 2)
            console.crlf();
      }
   }
   else
      console.print("No solutions found.\r\n\1p");
}