/* This shows the doors installed on the BBS.
 *
 * Date       Author           Comment
 * 2011-01-29 Eric Oulashin    Created
 * 2011-01-30 Eric Oulashin    Added the closing </li> tag on the door names
 */

load("sbbsdefs.js");
load("../../web/lib/template.ssjs");

// Read the list of category names to reject
var sectionsToReject = readSectionRejectFile();

// Build an array of app lists with the section as the
// array index.  I'm doing this because there are some
// apps I don't want to list (i.e., ones which only the
// sysop can access).
var appList = new Array();
for (var secIndex in xtrn_area.sec_list)
{
	if (listSection(xtrn_area.sec_list[secIndex], sectionsToReject))
	{
		appList[secIndex] = new Object();
		appList[secIndex].name = xtrn_area.sec_list[secIndex].name;
		appList[secIndex].list = "<ul>";
		for (var progIndex in xtrn_area.sec_list[secIndex].prog_list)
		{
			if (canListItem(xtrn_area.sec_list[secIndex].prog_list[progIndex].ars))
				appList[secIndex].list += "<li>" + xtrn_area.sec_list[secIndex].prog_list[progIndex].name + "</li>";
		}
		appList[secIndex].list += "</ul>";
	}
}


// Start outputting the web page
http_reply.header.pragma='no-cache';
http_reply.header.expires='0';
http_reply.header['cache-control']='must-revalidate';

writeln("<head>");
writeln("<title>Doors installed on " + system.name + "</title>");
writeln("<link rel=stylesheet href=\"DoorList.css\">");
writeln("</head>");

writeln("<body>");
writeln("<center>");
writeln("<h3>Door games &amp; apps installed on this BBS</h3>");
writeln("<p>These games &amp; apps are accessible when logged into this BBS via the text interface.</p>");
writeln("<table class=\"DoorList\">");

// Write the table header row - App section names
write("<tr nowrap>");
for (var index in appList)
	write("<th>" + appList[index].name + "</th>");
writeln("</tr>");
// Write the app list
write("<tr nowrap>");
for (var index in appList)
{
	write("<td>" + appList[index].list + "</td>");
}
writeln("</tr>");
writeln("</table>");
writeln("</center>");

writeln("</body>");
writeln("</html>");

////////////////////////////////////////////////////////////////////
// Functions

// Returns whether or not we can list an item, based on its
// ARS security string.
//
// Parameters:
//  pARS: The item's access requirements string
function canListItem(pARS)
{
	var canListIt = true;

	// For a regular user, don't list doors that require sysop access.
	if (user.number != 1)
	{
		var ARS_Upper = pARS.toUpperCase();
		canListIt = !((ARS_Upper.search(/SYSOP/) > -1) || (ARS_Upper.search(/LEVEL 90/) > -1));
	}

	return canListIt;
}

// Returns whether or not to list an app section.
//
// Parameters:
//  pSection: A Synchronet external program section object
//  pRejectCatNames: An array of category names not to list
function listSection(pSection, pRejectCatNames)
{
	// Make sure we can list the item using its ARS string.  Also,
	// don't list my "Other BBSs" or "Chat doors" sections.
	// First, see if we can list the section based on its ARS.
	var listIt = canListItem(pSection.ars);
	// If we can list it based on its ARS, then check the category
	// reject list.
	if (listIt)
	{
		for (var index in pRejectCatNames)
		{
			if (pSection.name == pRejectCatNames[index])
			{
				listIt = false;
				break;
			}
		}
	}

	return listIt;
}

// Opens the category rejection configuration file.  Returns
// an array of the lines from the file.
function readSectionRejectFile()
{
	// Determine the script's startup directory.
   // This code is a trick that was created by Deuce, suggested by Rob Swindell
   // as a way to detect which directory the script was executed in.  I've
   // shortened the code a little.
   var startup_path = '.';
   try { throw dig.dist(dist); } catch(e) { startup_path = e.fileName; }
   startup_path = backslash(startup_path.replace(/[\/\\][^\/\\]*$/,''));

	var categories = new Array();

	// Open the configuration file
	var fileLine = null;     // A line read from the file
   var cfgFile = new File(startup_path + "DoorList-Section-Reject.cfg");
   if (cfgFile.open("r"))
   {
      var fileLine = null;     // A line read from the file
      while (!cfgFile.eof)
      {
         // Read the next line from the config file.
         fileLine = cfgFile.readln(2048);

         // fileLine should be a string, but I've seen some cases
         // where it isn't, so check its type.
         if (typeof(fileLine) != "string")
            continue;

			// Add the line to categories
			categories.push(fileLine);
      }

      cfgFile.close();
	}

	return categories;
}