// Duplicate BC functions for SMB which aren't part of UNiX C - Public Domain
// Full type casts are included, so even a strict C++ compiler won't complain :)
// -----------------------------------------------------------------------------
// Code written by Rao / HaRDCoDE [Paul Nivin Fisher] (rao1@freenet.hut.fi)
// -----------------------------------------------------------------------------
// If you use these routines, please mention my name somewhere in your
// documentation.
// -----------------------------------------------------------------------------
// Compiled and tested under Linux 1.2.4 using GCC 2.6.3 and the standard C lib
// -----------------------------------------------------------------------------

#include <sys/stat.h>
#include <unistd.h>
#include <string.h>
#include <ctype.h>
#include <sys/file.h>
#include "smblib.h"

// Get file length from a handle
long filelength (int handle)
{
  struct stat filestat;

  fstat(handle, &filestat);
  return((long)filestat.st_size);
}

// Compare s2 to s1 - ignore case
int stricmp (const char *s1, const char *s2)
{
  return(strcasecmp(s1, s2)); // Gotta love 1-liners :)
}

// Truncate a file to 'size' - or append NULLS if (size > filesize)
int chsize (int handle, long size)
{
  return(ftruncate(handle, (size_t)size));
}

// Convert string to lowercase and return char* to s
char *strlwr (char *s)
{
char *tmp_ptr = s;

  for (;*s != (char)NULL;s++)
    if (isupper((int)*s))
      *s = (char)tolower((int)*s);

return(tmp_ptr);
}

// Convert string to uppercase and return char* to s
char *strupr (char *s)
{
char *tmp_ptr = s;

  for (;*s != (char)NULL;s++)
    if (islower((int)*s))
      *s = (char)toupper((int)*s);

return(tmp_ptr);
}

// Lock up a region of a file
int lock (int handle, long offset, long length)
{
off_t cur_pos;
int   return_code;

  cur_pos = lseek(handle, (off_t)0, SEEK_CUR);
  lseek(handle, (off_t)offset, SEEK_SET);
  return_code = fcntl(handle, F_LOCK, length);
  lseek(handle, (off_t)cur_pos, SEEK_SET);    // even if the lock fails, reset the file position
  if (return_code == -1) return (-1);
  return (0);
}

// Unlock a region of a file
int unlock (int handle, long offset, long length)
{
off_t cur_pos;
int   return_code;

  cur_pos = lseek(handle, (off_t)0, SEEK_CUR);
  lseek(handle, (off_t)offset, SEEK_SET);
  return_code = fcntl(handle, F_ULOCK, length);
  lseek(handle, (off_t)cur_pos, SEEK_SET);
  if (return_code == -1) return (-1);
  return (0);
}

// Check for the existence of a file. 
// Return 1 if it exists, 0 if it doesn't. 
char fexist(char *filespec)
{
struct stat f;

  if(stat(filespec,&f)==-1) return(0);
  return(1);
}

// Return the length of the file in 'filespec' - assume file exists
long flength(char *filespec)
{
struct stat f;

    stat(filespec,&f);
    return((long)f.st_size);
}