/*****************************************************************************  
         _____         _____                            ____     ______
         \    \______ _)    \______  vanguard mods  ___/ __ )____>    /
          \    \    /_\_,    \    /___  ____ _______\_ ____  /  _    /
hx!------\ \  __\  /  _    \  \  /  _/_(   _U  \    _  \        /   / /--------
           /_______   \  ___\_____  L_     )        \  _\     ______\
                 /_______\       \   /  ___,----,______\ \_____\
                                 /_______\

javascript light bar for connex! private messenger version 1.0b by ispyhumanfly

*****************************************************************************/

load("sbbsdefs.js");

//ansi keys
var KEY_UP = String.fromCharCode(0x1e);
var KEY_DOWN = String.fromCharCode(0x0a);
var KEY_RIGHT = String.fromCharCode(0x06);
var KEY_LEFT = String.fromCharCode(0x1d);
var KEY_HOME = String.fromCharCode(0x02);
var KEY_END = String.fromCharCode(0x05);
var KEY_BACK = String.fromCharCode(0x08);
var KEY_DEL = String.fromCharCode(0x7F);


function inputNumber(inNumber,iMax) {
//gets a numeric input
//  inNumber (first number, generally already inputted)
//  inMax (maximum allowed number to input)
	var bDone = false;
	var sRet = "" + inNumber;
	
	console.print(inNumber);
	while (bbs.online && (!bDone)) {
		if ((sRet.length >= iMax.toString().length)||((sRet.length == iMax.toString().length-1)&&(parseInt(sRet.substr(0,1)) > parseInt(iMax.toString().substr(0,1))))) {
			console.ansi_left(sRet.length);
			console.print("                                             ".substr(0,sRet.length));
			console.ansi_left(sRet.length);
			return "" + sRet;
		}

		var c = console.getkey();
		
		if (c == "") {
			sleep(200);
		}else{
			switch (c.toString()) {
				case KEY_BACK:
				case KEY_DEL:
					//cut the length of the string.
					sRet = sRet.substr(0,sRet.length-1);
					
					console.ansi_left(1);
					console.print(" ");
					console.ansi_left(1);
					if (sRet.length <= 0)
						bDone = true;
					break;
				case "0":
				case "1":
				case "2":
				case "3":
				case "4":
				case "5":
				case "6":
				case "7":
				case "8":
				case "9":
					sRet += "" + c;
					console.print(c);
					break;
				case "\r":
				case "\n":
					bDone = true;
					break;
			}
		}
	}
	
	if (sRet != "") {
		console.ansi_left(sRet.length);
		console.print("                                             ".substr(0,sRet.length));
		console.ansi_left(sRet.length);
		console.print("returning: "+sRet+"\r\n");
		console.pause();
		return sRet + "\r";
	} else {
		return "";
	}
}


function main() {
// main function to run the read prompt

	//array of menu text lines
	var options = new Array();
	options[0] = "\1ncwk7 m e s s a g e h0  c h a t   t e l e g r a m   q u i tnc hk[n[h[ncinputhk: n";
	options[1] = "\1ncw hkm e s s a g e  nk7 c h a t h0  t e l e g r a m   q u i tnc hk[n[h[ncinputhk: n";
	options[2] = "\1ncw hkm e s s a g e   c h a t  nk7 t e l e g r a m h0  q u i tnc hk[n[h[ncinputhk: n";
	options[3] = "\1ncw hkm e s s a g e   c h a t   t e l e g r a m  nk7 q u i t h0[n[h[ncinputhk: n";
	
	//array of the commands to return
	var values = new Array();
	values[0] = "M";
	values[1] = "C";
	values[2] = "T";
	values[3] = "Q";
	
	//variables to hold the menu position and return value
	var current = 0;
	var last = 1;
	var ret = "";
	
	//reset ctrl-c/abort
	if (bbs.sys_status&SS_ABORT) bbs.sys_status &= ~SS_ABORT;
	
	//print devider line.
	console.print ("\r\n")
	
	//begin menu input
	while (bbs.online && (ret=="")) {
		//if the menu has changed, display the new line.
		if (current != last) {
			console.ansi_left(80);
			console.clearline();
			console.putmsg(options[current]);
			last=current;
		}
		
		//get an input waiting
		var c = console.inkey();
		
		//if no input
		if (c == "") {
			//if ctrl-c pressed
			if (bbs.sys_status&SS_ABORT) {
				//abort reading
				bbs.sys_status &= ~SS_ABORT;
				ret = "Q";
			}
			//sleep 1/10th of a second, to release cpu time
			sleep(100);
		//otherwise if there is input
		}else{
			//determin the key pressed
			switch (c) {
				//if left or up key
				case (KEY_LEFT):
				case (KEY_UP):
					current--; //decrease the current menu option
					
					//if outside of range
					if (current < 0)
						//set to end of range
						current = options.length-1;
					break;
				//if right or down key pressed
				case (KEY_RIGHT):
				case (KEY_DOWN):
					current++; //increase the current menu option
					
					//if outside of range
					if (current >= options.length)
						current = 0;  //set to beginning of range
					break;
				//if cr or lf
				case "\r":
				case "\n":
					//return the currently selected option
					ret = values[current];
					break;
				//check other input
				default:
					//if a number
					if (!isNaN(c)) {
						//get numeric input, within the max messages in the area.
						ret = inputNumber(c,bbs.smb_msgs);
					//if a sysop
					} else if (user.security.level >= 90) {
						//check for valid input
						if ("?-CAPDRM<>{}[]@$%&=/\;BUSVIQYFLTNOZEGHJKX*".indexOf(c.toUpperCase()) >= 0)
							ret = c.toUpperCase();
					}else{
						//check for valid input
						if ("?-CAPDRM<>{}[]@$%&=/\;BUSVIQYFLNTZEGHJKX*".indexOf(c.toUpperCase()) >= 0)
							ret = c.toUpperCase();
					}
					break;
			}
		}
	}
	
	//if cold-key input append a cr
	if ((user.settings&USER_COLDKEYS)&&(ret.indexOf("\r") < 0)) {
		ret += "\r";
	}
	
	//unget selected command key/option to the input buffer
	console.ungetstr(ret);
	
}
main();
