#include <stdlib.h>

#include "tith-file.h"

long
tith_flen(const char *fname)
{
	FILE *fp = fopen(fname, "rb");
	if (!fp)
		return -1L;
	if (fseek(fp, 0, SEEK_END)) {
		fclose(fp);
		return -1L;
	}
	long ret = ftell(fp);
	fclose(fp);
	return ret;
}

char *
tith_readLine(FILE *fp)
{
	if (fp == NULL)
		return NULL;
	char *ret = malloc(1);
	if (ret == NULL)
		return NULL;
	*ret = 0;
	size_t sz = 1;
	size_t len = 0;
	for (;;) {
		int ch = fgetc(fp);
		if (ch == EOF)
			break;
		if (ch < 0 || ch > 0xFF)
			break;
		if (ch == '\n') {
			char *small = realloc(ret, len + 1);
			if (small == NULL)
				return ret;
			return small;
		}
		if (ch < 32 && ch != '\t')
			break;
		if ((len + 1) >= sz) {
			size_t newsz = sz == 1 ? 4096 : sz * 2;
			char *newret = realloc(ret, newsz);
			if (newret == NULL)
				break;
			sz = newsz;
			ret = newret;
		}
		ret[len++] = (char)ch;
		ret[len] = 0;
	}

	free(ret);
	return NULL;
}
