#ifndef JS_SOCKET_H
#define JS_SOCKET_H

#include <cryptlib.h>
#include "gen_defs.h"
#include "sbbs.h"
#include "sockwrap.h"
#include "multisock.h"

typedef struct
{
	SOCKET sock;
	BOOL external;      /* externally created, don't close */
	BOOL debug;
	BOOL nonblocking;
	BOOL is_connected;
	BOOL network_byte_order;
	int last_error;
	char last_error_str[128];
	int type;
	union xp_sockaddr remote_addr;
	CRYPT_SESSION session;
	BOOL tls_server;
	char *hostname;
	struct xpms_set *set;
	size_t unflushed;
	char peeked_byte;
	BOOL peeked;
	uint16_t local_port;
	js_callback_t *js_cb;
	int tls_minver;
	JSObject *tls_psk;
	bool tls_nameverify;
	bool tls_disable_certverify;
	bool tls_clientauth;
	bool tls_enhanced_certcheck;
} js_socket_private_t;

#ifdef __cplusplus
extern "C" {
#endif

#ifdef __cplusplus
}
#endif

#endif
