Program Dukedom;

{                     Author:  Miles E Crawford          }
{               Date Started:  06/09/86                  }
{       Modified for WWIV by:  The Wasteland Warrior/2af }
{         Modified by 2af on:  05/07/87                  }
{     Last modified by WW on:  05/09/87                  }


{$I COMMON.PAS}

Type
  kingn = record
            kingname,
            nduke,
            sduke,
            eduke,
            wduke    : string[25];
            age      : integer;
          end;

Const
  version           = '3.03';
  normal_yield      = 9;
  bumper_crop       = 12;
  max_yield         = 13;
  min_yield         = 7;
  king              = 1;
  duke              = 2;
  dukedom_birthrate = 0.085; {8% birthrate}

Var
  kf: file of kingn;
  kn: kingn;
  dukedom_war_deaths_this_battle,    opponent_war_deaths_this_battle,
  dukedom_war_deaths,                opposing_duke_peasants,
  dukedom_captured,                  land_confiscated,
  gift_of_land,                      misc_income,
  gambling_expense,                  response,
  kings_need,                        special_event_code,
  peasants_given_to_king,            land_given_to_king,
  misc_expense,                      dukedom_starved,
  dukedom_acres_planted,             dukedom_yield,
  dukedom_grain_prev_turn,           dukedom_seed,
  dukedom_food,                      dukedom_expenses,
  royal_taxes,                       dukedom_harvest,
  dukedom_births,                    dukedom_defectors,
  dukedom_deaths_natural,            kings_attitude,
  dukedom_attitude,                  kings_land,
  dukedom_land,                      dukedom_land_prev_turn,
  kings_grain,                       dukedom_grain,
  kings_peasants,                    dukedom_peasants,
  dukedom_peasants_prev_turn,        land_expenses,
  year, xk,                          age,
  dukedom_disaster_victims,          crop_disaster_code,
  land_to_sell,                      land_to_buy,
  sea_event_code,                    land_price,
  kings_peasants_inoc                : integer;

  travel_days, can_only_plant : integer;
  display_stats, display_time,
  north_duke, south_duke,
  east_duke, west_duke : boolean;
  username, ii, warduke, where_duke : str;
  iii, ooo : char;

PROCEDURE prt3(i:str);
begin
  ansic(3); prompt(i); ansic(0);
end;

PROCEDURE prt4(i:str);
begin
  ansic(4); prompt(i); ansic(0);
end;

PROCEDURE prt5(i:str);
begin
  ansic(5); prompt(i); ansic(0);
end;

{
PROCEDURE mmkey(var i:str);
 var
   c:char;
 begin
   repeat
     repeat
       getkey(c);
     until (((c>=' ') and (c<chr(127))) or (c=chr(13))) or hangup;
     c:=upcase(c);
     outkey(c);
     thisline:=thisline+c;
     if (c='/') or (c='1') then begin
       i:=c;
       repeat
         getkey(c);
       until ((c>=' ')and(c<=chr(127))) or (c=chr(13)) or (c=chr(8)) or hangup;
       c:=upcase(c);
       if c<>chr(13) then begin outkey(c); thisline:=thisline+c; end;
       if (c=chr(8)) or (c=chr(127)) then prompt(' '+c);
       if c='/' then input(i,20) else if c<>chr(13) then i:=i+c;
     end else i:=c;
   until (c<>chr(8)) and (c<>chr(127)) or hangup;
   nl;
 end;
 }

procedure ideas;
  var
    suggest : text;
    sug : array[1..10] of string[79];
    templn : str;
    xtc : integer;
  begin
    assign(suggest,'gfiles\ideas.duk');
    nl; prt('View other suggestions? ');
    if yn then
      begin
        nl;
        printfile('gfiles\ideas.duk');
      end;
    nl; prt('Would you like to Add an Idea for a Modification to Dukedom? ');
    if yn then
      begin
        for xtc:=1 to 10 do sug[xtc]:='';
        print(' Enter Suggestion now [80chr X 10Lines Max]'); xtc:=0;
        while (xtc<11) and (not hangup) do
          begin
            xtc:=xtc+1;
            inputl(templn,79);
            sug[xtc]:=templn;
            if sug[xtc] = '' then xtc:=11;
          end;
        nl; prt('Ok? '); if yn then
          begin
            append(suggest);
            for xtc := 1 to 10 do
              begin
                if sug[xtc]<>'' then writeln(suggest,sug[xtc]);
              end;
              writeln(suggest,' ');
            close(suggest);
          end;
        nl;
      end;
  end;


PROCEDURE info;
Var
   which:char;
Begin
   repeat
   cls; nl;
   print('Documentation Station');
   print('~~~~~~~~~~~~~ ~~~~~~~');
   print('N - Note from Author');
   print('G - General play info');
   print('H - History of game');
   print('S - Hints & Suggestions');
   print('I - Ideas for Modifications');
   nl;
   print('Configurations');
   print('~~~~~~~~~~~~~~');
   prompt('1 - Toggle extended status display  ');
   if display_stats then print('[ON]') else print('[OFF]');
   prompt('2 - Toggle time left display  ');
   if display_time then print('[ON]') else print('[OFF]');
   nl;
   print('Q - Quit to game');
   nl;
   prompt('Which ? '); onek(which,'NGHSQI12');
   if (which <> 'S') and (which <> 'Q') then cls;
   nl;
   case which of
      'N' : begin printfile('gfiles\note.duk'); pausescr; end;
      'G' : begin printfile('gfiles\info.duk'); pausescr; end;
      'H' : begin printfile('gfiles\history.duk'); pausescr; end;
      'S' : begin printfile('gfiles\hints.duk'); pausescr; end;
      'I' : ideas;
      '1' : if display_stats then display_stats := false else display_stats := true;
      '2' : if display_time then display_time := false else display_time := true;
   end;
   until ((which = 'Q') or hangup);
   nl; nl;
End;


PROCEDURE wait_for_keypress;
 BEGIN
  repeat
    tleft;
    nl;
    if display_time then prt4('['+tlef+' - ') else prt4('[');
    prt4('Any key to continue..(Q)uit (I)nfo]');
    getkey(ooo);
    ansic(0);
    if upcase(ooo)='Q' then return;
    if upcase(ooo)='I' then info;
  until (upcase(ooo)<>'I') or (hangup);
END;

PROCEDURE intro;
var a, b, c : integer;

 begin
  a:=0;b:=0;c:=0;
  a := length(version);
  b := (34-a) div 2;
  Cls; nl;
  for c := 1 to b do prompt(' ');
  ansic(3);
  print('Dukedom  v'+version);nl;
  ansic(4);
  print('    Programmed by:  Wasteland Warrior/2af');ansic(7);
  Print('    ~~~~~~~~~~ ~~   ~~~~~~~~~ ~~~~~~~ ~~~');
  print('        Modified by:   2af Associates');
  a:=0;b:=0;c:=0;
  a := length(kn.kingname);
  b := (25-a) div 2;
  nl;nl;nl;
  for c := 1 to b do prompt(' ');
  print('The Ruling King is '+kn.kingname);
  nl;nl;nl;nl;nl;nl;nl;wait_for_keypress;
 end;


PROCEDURE inc(VAR number :integer);
 BEGIN
  number := number + 1;
 END {inc};

PROCEDURE initialize;
 BEGIN
  kings_peasants := random(500)+500;   {between   500 &  1000 peasants}
  dukedom_peasants := random(20)+100;   {between  90 &   120 peasants}
  kings_land := random(10000)+10000;   {between 10000 & 20000 acres}
  dukedom_land := random(100)+500;     {between   500 &   600 acres}
  kings_grain := random(5000)+15000;  {between 15000 & 20000 bushels}
  dukedom_grain := round(normal_yield * dukedom_peasants * 4.5);
  kings_attitude := 5;
  dukedom_attitude := 5;
  dukedom_captured := 0;
  land_confiscated := 0;
  age := random(6)+15;
  year := 0;
  north_duke := true;
  south_duke := true;
  east_duke := true;
  west_duke := true;
  display_stats := true;
  display_time :=false;
 END {initialize};

PROCEDURE display_previous_turn;
BEGIN
  If display_stats then begin
  Cls;
  nl;
  ansic(4);print('Summary of Previous Year ');
  nl;
  ansic(0);
  print('Number of Peasants (Start) : '+cstr(dukedom_peasants_prev_turn + dukedom_war_deaths));
  print('Births                     : '+cstr(dukedom_births));
  print('Natural Deaths             : '+cstr(dukedom_deaths_natural));
  print('Disaster/Starvation Victims: '+cstr(dukedom_starved+dukedom_disaster_victims));
  print('War Deaths                 : '+cstr(dukedom_war_deaths));
  print('Peasants Given To King     : '+cstr(peasants_given_to_king));
  print('Peasants Captured/Bought   : '+cstr(dukedom_captured));
  print('Immigrants                 : '+cstr(dukedom_defectors));
  print('Number of Peasants (End)   : '+cstr(dukedom_peasants));
  nl;wait_for_keypress;cls;
  print('Land (Start)      : '+cstr(dukedom_land_prev_turn));
  print('Land Bought       : '+cstr(land_to_buy));
  print('Land Sold         : '+cstr(land_to_sell));
  print('Land Given to King: '+cstr(land_given_to_king));
  print('Land Given to You : '+cstr(gift_of_land));
  print('Land Captured     : '+cstr(land_confiscated));
  print('Land (Ending)     : '+cstr(dukedom_land));
  nl;
  print('Grain (Beginning) : '+cstr(dukedom_grain_prev_turn));
  print('Food Expenses     : '+cstr(dukedom_food));
  print('Castle Expenses   : '+cstr(dukedom_expenses));
  print('Gambling Expense  : '+cstr(gambling_expense));
  print('Misc Expense      : '+cstr(misc_expense));
  print('Land Expenses     : '+cstr(land_expenses));
  print('Royal Taxes       : '+cstr(royal_taxes));
  print('Seed Expenses     : '+cstr((dukedom_seed*2)));
  print('Grain Harvested   : '+cstr(dukedom_harvest));
  print('Misc Income       : '+cstr(misc_income));
  print('Grain (Ending)    : '+cstr(dukedom_grain));
  land_confiscated := 0;
  wait_for_keypress;
 end;
END {display_previous_turn};

function lower(s:str):str;              { Many thanks to }
                                         { 2AF for this }
var                                       { procedure! }
  spaceflag :boolean;
  i : integer;

begin
  spaceflag := true;
  for i := 1 to length(s) do
    begin
      if s[i] <> #32 then
        begin
          if not spaceflag then
            begin
              if ((s[i] >= 'A') and (s[i] <= 'Z')) then
                s[i] := chr(ord(s[i])+32);
            end
          else
            spaceflag := false;
        end
      else
        spaceflag := true;
    end;
  lower := s;
end;

PROCEDURE new_king;

 BEGIN
   kn.kingname:=lower(thisuser.name);
   kn.age:=age;
   rewrite(kf);
   write(kf,kn);
   close(kf);
 END;

PROCEDURE new_duke;
Begin
   rewrite(kf);
   write(kf,kn);
   close(kf);
End;

PROCEDURE display_status;
 BEGIN
  cls;
  nl;
  ansic(3);print('Status:  [Year # '+cstr(year)+']');
  print('         [Your Age: '+cstr(age)+']  [Kings age: '+cstr(kn.age)+']');
  nl;nl;
  ansic(4);print('                    King        You');
  ansic(7);print('                    ~~~~        ~~~');
           print(' # of Peasants:     '+cstr(kings_peasants)+'          '+cstr(dukedom_peasants));
           print(' Acres of Land:    '+cstr(kings_land)+'        '+cstr(dukedom_land));
           print(' Bushels of Grain: '+cstr(kings_grain)+'        '+cstr(dukedom_grain));
          prompt(' Attitude:            '+cstr(kings_attitude)+'           '+cstr(dukedom_attitude)+'     ');
           print(' (1=poor, 5=avg, 10=good)');
  nl;
  IF dukedom_grain > (dukedom_peasants * 50) THEN
   begin
     ansic(5);prompt('  WARNING:  ');ansic(0);
     print('You have so much grain that the King is starting to resent you...');
   end;
  IF dukedom_grain > (dukedom_peasants * 100) THEN
   begin
     ansic(5);prompt('  WARNING:  ');ansic(0);
     print('You have so much grain that you are losing favor with the King...');
   end;
  IF dukedom_peasants >= 400 THEN
   begin
     ansic(5);prompt('   NOTICE:  ');ansic(0);
     print('The King is getting nervous about you having '+cstr(dukedom_peasants)+' peasants...');
   end;
  IF kings_attitude <= 4 THEN
   begin
     ansic(5);prompt('  WARNING:  ');ansic(0);
     print('The King has taken a definite dislike toward you...');
   end;
  IF kings_attitude <= 2 THEN
   begin
     ansic(8);prompt('   DANGER:  ');ansic(0);
     print('The king is thinking about replacing you with another duke...');
   end;
  IF dukedom_attitude <= 4 THEN
   begin
     ansic(5);prompt('  WARNING:  ');ansic(0);
     print('The peasants are getting rebellious...');
   end;
  IF dukedom_attitude <= 2 THEN
   begin
     ansic(8);prompt('   DANGER:  ');ansic(0);
     print('The peasants threaten civil war unless conditions change...');
   end;
  IF kn.age > 75 then
   begin
     xk:=round(random(8));
     if xk = 1 then
       begin
         print(kn.kingname+' has died of natural causes, you are the new King.');
         new_king; sysoplog('  * King died of natural causes'); return;
       end;
     if xk = 2 then
       begin
         print(kn.kingname+' has become severly ill, and has relenquished his');
         print('Kingdom to you.');
         new_king; sysoplog('  * King Relenquished his Crown'); return;
       end;
   end;
 wait_for_keypress;
 END {display_status};

PROCEDURE win_game;
  Begin
    cls;
    nl;nl;nl;nl;nl;nl;nl;ansic(8);print('                  You Won!');
    delay(700);nl;nl;nl;ansic(8);print('         All Hail King '+thisuser.name);nl;nl;wait_for_keypress;
    display_previous_turn;
    display_status;
    new_king;
    sysoplog('  * Won at Dukedom');
    return;
  End;

PROCEDURE update_previous_turn_values;
 BEGIN
  dukedom_births := round(dukedom_peasants * dukedom_birthrate) + round(dukedom_attitude); {8% birth rate}
  dukedom_deaths_natural := round(dukedom_peasants * 0.04);    {4% death rate}
  kings_peasants := kings_peasants - 45 + round(random(100));  {between down 45 & up 55}
  kings_grain := kings_grain - 2000 + round(random(4000));     {between down 2000 and up 2000 bu}
  IF (dukedom_attitude > 5) AND (kings_attitude < 5) THEN
   dukedom_defectors := round(dukedom_peasants div (random(40)+10) + round(kings_attitude * 3)) {2% to 10% defectors}
  ELSE
   dukedom_defectors := round(random(8));
   dukedom_peasants := dukedom_peasants_prev_turn
                     + dukedom_captured
                     + dukedom_defectors
                     + dukedom_births
                     - dukedom_deaths_natural
                     - dukedom_starved
                     - dukedom_disaster_victims
                     - peasants_given_to_king;
  IF dukedom_peasants < 0 THEN dukedom_peasants := 0;
  dukedom_harvest := round(dukedom_seed * dukedom_yield);
  dukedom_expenses := round(dukedom_peasants * 3.8)  {3.8 bu per peasant};
  royal_taxes := round(dukedom_land/2) + round(dukedom_harvest * 0.18)  {1/2 bu per acre plus 18% of harvest};
  dukedom_land := dukedom_land_prev_turn
                + land_to_buy
                - land_to_sell
                - land_given_to_king
                + land_confiscated
                + gift_of_land;
  IF land_to_sell < 0 THEN land_to_sell := 0;
  IF land_to_buy < 0 THEN land_to_buy := 0;
  land_expenses := 0 - (land_to_buy * land_price) + (land_to_sell * (land_price-5));
  dukedom_grain := dukedom_grain_prev_turn
                 - dukedom_food
                 - dukedom_expenses
                 - gambling_expense
                 - royal_taxes
                 - (dukedom_seed * 2)
                 - misc_expense
                 + misc_income
                 + dukedom_harvest
                 + land_expenses;
  IF dukedom_grain    > (dukedom_peasants *100) THEN kings_attitude := kings_attitude - 1; {king is getting nervous}
  IF dukedom_peasants < 10 THEN dukedom_attitude := 0;   {end game if less than 10 peasants left}
  IF dukedom_grain < 0 THEN
   BEGIN
    dukedom_grain := 0;   {grain can't be neg}
    dukedom_attitude := 0; {end game if no grain}
   END;
  IF kings_attitude   > 10 THEN kings_attitude := 10;
  IF dukedom_attitude > 10 THEN dukedom_attitude := 10;
  IF kings_attitude   < 0 THEN kings_attitude := 0;
  IF dukedom_attitude < 0 THEN dukedom_attitude := 0;
 END {update_previous_turn_values};

PROCEDURE how_much_food;
 BEGIN
 dukedom_food := -1;
 dukedom_starved := 0;
  repeat
   BEGIN
    prompt('Food for this winter (optimum: '+cstr(round(dukedom_peasants * 13))+') :  '); ansic(7);input(ii,5);
    if ((ii='') or (ii=#13)) then
      begin
        ii:=cstr(round(dukedom_peasants*13));
        print(' '+ii+' bushels used for food.')
      end;
    dukedom_food:=value(ii);
    IF dukedom_food > dukedom_grain THEN
     BEGIN
      print('  Not enough Grain!!!   We only have '+cstr(dukedom_grain)+' bushels...');
      dukedom_food := -1;
     END;
   END;
  until (dukedom_food>=0) or (hangup);
   IF dukedom_food >= (dukedom_peasants * 26)  THEN
    BEGIN
     print('  The peasants are impressed...  Their attitude improves...');
     IF dukedom_attitude < 10 THEN dukedom_attitude := dukedom_attitude + 1;
    END;
   IF dukedom_food < (dukedom_peasants * 13) THEN
    BEGIN
     print('  Some peasants starved during the winter...');
     dukedom_starved := round(dukedom_peasants - round(dukedom_food div 13));
     dukedom_attitude := dukedom_attitude - 1;
    END;
 END {how_much_food};

PROCEDURE how_much_seed;
 BEGIN
  dukedom_seed := -1;
  IF (dukedom_peasants - dukedom_starved) > 0 THEN
   repeat
     prompt('Acres to Seed (max: '+cstr(round((dukedom_peasants - dukedom_starved)*4))+'):  ');
      ansic(7);input(ii,5);
      if ((ii='') or (ii=#13)) then
        begin
          ii:=cstr(round((dukedom_peasants - dukedom_starved)*4));
          print(' '+ii+' acres planted.');
        end;
      dukedom_seed:=value(ii);
      IF dukedom_seed > dukedom_land THEN              {not enough acres}
       BEGIN
        print('  You only have '+cstr(dukedom_land)+' acres...');
        dukedom_seed := -1;
       END;
      IF dukedom_seed > ((dukedom_peasants-dukedom_starved) * 4) THEN {not enough peasants}
       BEGIN
        print('  Not enough peasants to plant that much...');
        prompt(cstr(dukedom_peasants - dukedom_starved)+' peasants can only plant ');
        can_only_plant := round((dukedom_peasants-dukedom_starved) * 4)-1;
        if can_only_plant < 0 then can_only_plant := 0;
         print(cstr(can_only_plant)+' acres...');
        dukedom_seed := -1;
       END;
      IF dukedom_seed > (dukedom_grain - dukedom_food)/2 THEN {not enough sees }
       BEGIN
        print('  You can only plant '+cstr(round(((dukedom_grain-dukedom_food)/2)-1))+' Acres...');
        dukedom_seed := -1;
       END;
   until(dukedom_seed>=0) or (hangup)
   ELSE
    dukedom_seed := 0;
 END {how_much_seed};

PROCEDURE buy_sell_land;
 BEGIN
  land_to_buy := -1;
  land_to_sell := -1;
  land_price := round(random(20)+6);
  repeat
    land_to_buy := 0;
    prompt('How much land to buy @ '+cstr(land_price)+' per acre?  '); ansic(7);input(ii,5);land_to_buy:=value(ii);
     IF land_to_buy * land_price < 0 THEN
      BEGIN
       print('  Let''s be reasonable!');
       land_to_buy := -1;
      END;
     IF (dukedom_grain - dukedom_food - dukedom_seed) < round(land_to_buy * land_price) THEN
      BEGIN
       prompt  ('  You can only buy ');
       print(cstr(round(((dukedom_grain-dukedom_food-dukedom_seed)/land_price)-1))+' acres...');
       land_to_buy := -1;
      END;
  until (land_to_buy>=0) or (hangup);
  IF land_to_buy = 0 THEN
   Repeat
     land_to_sell := 0;
     prompt('Land to sell @ '+cstr(land_price-5)+' per acre?  '); ansic(7);input(ii,5);land_to_sell:=value(ii);
     IF land_to_sell * (land_price - 5)< 0 THEN
      BEGIN
       print('  Let''s be reasonable!');
       land_to_sell := -1;
      END;
     IF land_to_sell > (dukedom_land div 4) THEN   {only can sell 25% of land}
      BEGIN
       print('  Nobody has enough grain...  Sell it for less!');
       land_price := land_price - 1;
       if land_price < 5 then land_price := 5;
       land_to_sell := -1;
      END;
   until (land_to_sell>=0) or (hangup);
 END;

PROCEDURE harvest_crop;
VAR
   locust_year:boolean;
 BEGIN
  locust_year := false;
  if (age/17) = round(age/17) then locust_year := true;
  dukedom_disaster_victims := 0;
  IF dukedom_seed > 0 THEN
   BEGIN
    nl;
    dukedom_yield := random(max_yield-min_yield)+min_yield;
    crop_disaster_code := round(random(20));
    IF dukedom_yield >= bumper_crop THEN
     BEGIN
      dukedom_attitude := dukedom_attitude + 1;
      ansic(8);prompt('  A    B U M P E R    C R O P !  ');
      nl;
     END;
    IF crop_disaster_code = 1 THEN {drought}
     BEGIN
      print('Drought has severely lowered your yield...');
      dukedom_yield := min_yield;
      dukedom_attitude := dukedom_attitude - 1;
     END;
    IF crop_disaster_code = 2 THEN {Grasshoppers}
     BEGIN
      print('A swarm of grasshoppers ate 30% of your crop...');
      dukedom_yield := round(dukedom_yield * 0.7);
      dukedom_attitude := dukedom_attitude - 1;
     END;
    IF crop_disaster_code = 3 THEN {flood}
     BEGIN
      dukedom_disaster_victims := round(dukedom_peasants * 0.12);
      print('Flash Flood!  22% of your crop and '+cstr(dukedom_disaster_victims)+' peasants wash away in the storm...');
      dukedom_yield := round(dukedom_yield * 0.78);
      dukedom_attitude := dukedom_attitude - 1;
     END;
    IF (crop_disaster_code in [4,5,6,7,8,9,11,12,13,14,15]) and locust_year THEN  {Locust!}
     BEGIN
      print('The 17 year locusts have arrived!  Much of your crop is destoyed.');
      dukedom_yield := round(dukedom_yield * 0.645);
      dukedom_attitude := dukedom_attitude - 1;
     END;
    prompt('  This year''s crop yield is:  '+cstr(dukedom_yield)+' bushels per acre.  ');
   nl;wait_for_keypress;
   END;
END {harvest_crop};

PROCEDURE special_events;
 BEGIN
  special_event_code := round(random(10));
  gift_of_land := 0;
  land_given_to_king := 0;
  misc_income := 0;
  misc_expense := 0;
  peasants_given_to_king := 0;
  response := 0;
  IF special_event_code in [1,2,3,4] THEN
   BEGIN
    Cls;
    IF special_event_code = 1 THEN {king needs peasants}
     BEGIN
      kings_need := random(round(dukedom_peasants * 0.13)) + 1;
      print('  '+kn.kingname+' has a need for '+cstr(kings_need)+' peasants to build');
      print('  him a new vacation home in an isolated spot in your property.  You have');
      print('  already decided that you will let him use the piece of land but you');
      print('  haven''t decide whether or not to give him the peasants.');
      nl;
      print('  You may either 1.  Release the required number of peasants to him.');
      print('              or 2.  Give '+kn.kingname+' a gift of '+cstr(round(kings_need*50)));
      print('                     bushels of grain and hope that makes him happy.');
      nl;
      prompt  ('  Which do you wish to do (1 or 2): ');  ansic(7);onek(iii,'12');response:=value(iii);
      nl;
      IF response = 1 THEN
       BEGIN
        print('  '+kn.kingname+' thanks you for your patronage...');
        peasants_given_to_king := kings_need;
        IF kings_attitude < 10 THEN kings_attitude := kings_attitude + 1;
       END
      ELSE
       BEGIN
        print('  '+kn.kingname+' is disgusted...  He takes the gift of grain');
        print('  but you have still mad him mad.  He will be able to get');
        print('  the men he needs from another Duke though...');
        kings_attitude := kings_attitude - 1;
        misc_expense := round(kings_need * 50);
       END;
    END;
    IF special_event_code =  2 THEN {king needs land}
     BEGIN
      kings_need := random(round(dukedom_land * 0.095));
      print('  '+kn.kingname+' wishes a parcel of your land that is '+cstr(kings_need));
      print('  acres in size to build a new riding arena for his daughter.');
      nl;
      print('  You may either  1.  Give him the land.');
      print('              or  2.  Lose some "brownie points" with his highness');
      nl;
      prompt  ('  Which do you wish to do (1 or 2): '); ansic(7);onek(iii,'12');response:=value(iii);
      nl;
      IF response = 1 THEN
       BEGIN
        print('  '+kn.kingname+' thanks you for your patronage...');
        land_given_to_king := kings_need;
        IF kings_attitude < 10 THEN kings_attitude := kings_attitude + 1;
       END
      ELSE
       BEGIN
        print('  '+kn.kingname+' get it from one of your rival dukes anyway...');
        kings_attitude := kings_attitude - 1;
       END;
     END;
    IF special_event_code =  3 THEN {king wants party}
     BEGIN
      kings_need := round((dukedom_peasants * 4.3) + random(dukedom_peasants)); {about 5 * peasants}
      print('  '+kn.kingname+' is coming to town to evaluate your skills as a');
      print('  ruler of people.  Since it is customary to throw him a party,');
      print('  you have a choice to make.');
      nl;
      print('  You may either  1.  Give him the party which will cost you');
      print('                      approximately '+cstr(kings_need)+' bushels of grain.');
      print('              or  2.  Skip the party and make him mad.');
      nl;
      prompt  ('  Which do you wish to do (1 or 2): ');  ansic(7);onek(iii,'12');response:=value(iii);
      nl;
      IF response = 1 THEN
       BEGIN
        misc_expense := kings_need - 100 + round(random(200)); {+ or - 100}
        print('  '+kn.kingname+' thanks you for a nice evening and tells you');
        print('  that he thinks of you as the son he never had...');
        IF kings_attitude < 10 THEN kings_attitude := kings_attitude + 1;
       END
      ELSE
       BEGIN
        print('  '+kn.kingname+' just wrote you out of his Will...');
        kings_attitude := kings_attitude - 1;
       END;
     END;
    IF special_event_code = 4 THEN {king is under attack}
     BEGIN
      kings_need := round(random(round(dukedom_peasants * 0.17)));
      print('  '+kn.kingname+' is being attacked by another Duke and requests');
      print('  men and supplies from you to help with his defense.');
      nl;
      print('  You may either  1.  Defend him by sending '+cstr(kings_need));
      print('                      peasants and 850 bu of grain.');
      print('              or  2.  Stay neutral and do nothing.');
      nl;
      prompt  ('  Which do you wish to do: (1 or 2): '); ansic(7);onek(iii,'12');response:=value(iii);
      nl;
       IF response = 1 THEN
        BEGIN
         peasants_given_to_king := kings_need;
         misc_expense := 850;
         kings_attitude := kings_attitude + 3;
         gift_of_land := round(random(dukedom_peasants));
         misc_income := round(random(1000)+500);
         print('  '+kn.kingname+' is grateful for your contribution.  He');
         print('  gives you '+cstr(misc_income)+' bu of grain, '+cstr(gift_of_land)+' acres of land and');
         print('  his and everlasting gratitude.  (By the way, '+cstr(round(kings_peasants * 0.15)));
         print('  of '+kn.kingname+'s'' peasants were killed in the skirmish!)');
         kings_peasants := round(kings_peasants * 0.85);
        END
       ELSE
        BEGIN
         kings_need := round(random(100));
         print('  '+kn.kingname+' scoffs at you for turning your back on him.');
         print('  Meanwhile, the attacking Duke is busy fighting '+kn.kingname+',');
         print('  so you sneaked in and captured '+cstr(kings_need)+' slaves from him!');
         print('  This helps sooth '+kn.kingname+'s'' sore feelings (a little)...');
         dukedom_captured := dukedom_captured + kings_need;
         kings_attitude := kings_attitude - 3;             {king is pissed!}
         IF kings_attitude <= 1 THEN kings_attitude := 1;  {no less than 1}
        END;
       END;
     wait_for_keypress;
   END;
END {special_events};

PROCEDURE wanna_gamble;
 BEGIN
  response := 0;
  gambling_expense := 0;
  prompt('Gamble with 10% of your grain? [Y/N]: ');ansic(7); if yn then response:=1;
  IF response = 1 THEN
   BEGIN
    gambling_expense := 0 - (dukedom_grain div 10) + round(random(dukedom_grain div 5)); {50/50 chance}
    IF gambling_expense < 0 THEN
     print('  You lost '+cstr(ABS(gambling_expense))+' bushels of grain...  That''ll teach ya...')
    ELSE
     print('  You WON '+cstr(gambling_expense)+' bushels of grain...  Good job!');
   END;
 END {wanna_gamble};


PROCEDURE sea_events;
Var
   boarded, shot, drowned : integer;
   drown, friend : boolean;
   monster : str;
Begin
   boarded := 0; shot := 0; drowned :=0;
   sea_event_code := round(random(10));
   if sea_event_code in [1,2,3,4,5,6] then
   begin
      if sea_event_code = 1 then  {  Drownings have occurred  }
      begin
         drowned := round(random(dukedom_peasants div 12)+1);
         dukedom_peasants := dukedom_peasants - drowned;
         print('Oops, '+cstr(drowned)+' of your men fell overboard!');
         nl;
      end;
      if sea_event_code = 2 then   { Found another ship }
      begin
         friend := false;
         if random(3) = 1 then friend := true;
         if not friend then
         begin
            print('You notice another ship approaching...');
            shot := round(random(dukedom_peasants div 9)+1);
            dukedom_peasants := dukedom_peasants - shot;
            print('They fire a volley while passing, '+cstr(shot)+' of your peasants are killed.');
            nl;
         end else
         begin
            print('You see a few men floating in the ocean crying for help.');
            prompt('Do you pick them up? ');
            if yn then
            begin
               nl;
               boarded := round(random(5)+5);
               print('You hoist the '+cstr(boarded)+' men to the deck.');
               print('They thank you very much and offer to help you in battle.');
               print('You have lost a day of travel, but morale is up!');
               travel_days := travel_days + 1;
               dukedom_peasants := dukedom_peasants + boarded;
               dukedom_attitude := dukedom_attitude + 1;
               nl;
            end
            else print('Your concience may haunt you...');
         end;
      end;
      if sea_event_code = 3 then  { Wind }
      begin
         print('Strong winds have increased your speed!');
         travel_days := travel_days - 1;
         dukedom_attitude := dukedom_attitude + 1;
         nl;
      end;
      if sea_event_code = 4 then  { Monsters! }
      begin
         if random(2) = 1 then monster := 'slithering sea-demon'
         else monster := 'giant octopus';
         drowned := round(random(dukedom_peasants div 11)+1);
         dukedom_peasants := dukedom_peasants - drowned;
         if random(2) = 1 then
         print('A '+monster+' attacked your ship and killed '+cstr(drowned)+' men.')
         else
         begin
            print('While some of your men were using a '+monster+' as target practice,');
            print(cstr(drowned)+' were slain by its enraged mother!');
         end;
      end;
      if sea_event_code = 5 then  { No wind.. }
      begin
         print('Becalmed seas have hindered your progress.');
         travel_days := travel_days + 1;
      end;
      if sea_event_code = 6 then  { Dummy ship }
      begin
         print('You notice another ship approaching...');
         print('You waive to your humble-helper, Harold.');
      end;
   end;
End;


PROCEDURE seaquest;
Var
   suprise_num, guessdays, day :integer;
   suprise:boolean;

Begin
   nl;print('Attacking by sea involves many risks, but you might');
   print('be able to catch them by suprise...');
   nl;prompt('Wish to continue? ');
   if yn then
   begin
      cls;
      travel_days := random(5)+3;
      guessdays := random(5)+3;
      nl;
      print('The Navigator''s report...');
      print('"The journey will take approximately '+cstr(guessdays)+' days, sir."');
      for day := 1 to travel_days do
      begin
         nl;
         prt3('Day '+cstr(day));nl;
         sea_events;
         dukedom_grain := dukedom_grain - random(dukedom_peasants);  {They have to eat.}
         if dukedom_grain <= 0 then dukedom_grain := 0;
         prt5('Another sunset..'); nl;
      end;
      nl;prt4('Journey complete.'); nl;
      suprise := true;
      suprise_num := random(5);
      if (suprise_num = 1) or (suprise_num = 2) then suprise := false;
      if suprise then
      begin
         nl;print('You have suprised the King''s forces!');
         kings_peasants_inoc := round(kings_peasants * 0.23);
         kings_peasants := kings_peasants - kings_peasants_inoc;
         print('About 1/4 of his forces are tanning in Ocean City!');
         nl;
      end
      else
      begin
         nl;
         print(kn.kingname+' was expecting you..');
         nl;
      end;
   end
   else
   begin
      nl;
      print('Re-aligning forces for land based attack.. Tally Ho!');
      nl;
   end;
end;

PROCEDURE fight_king;
 BEGIN
  kings_peasants_inoc := 0;
  response := 0; iii := 'A';
  dukedom_attitude := dukedom_attitude - 1;  {peasants hate war!}
  kings_attitude := kings_attitude - 1;
  nl;
  print('Engaging '+kn.kingname+' in battle!');nl;
  Begin
     prompt('Attack via ');prt4('L'); prompt('and or '); prt4('S'); prompt('ea ? ');
     onek(iii,'LS');
        case iii of
           'L' : begin nl; print('Forward Ho!'); nl; end;
           'S' : seaquest;
               {  begin nl;
                 print('Sorry, docks are still under construction..maybe if we were fed more?');
                 nl;end;  }
        end;
  end;
  repeat
    IF kings_peasants < 27 THEN  win_game;
    prompt('We are prepared to fight...  Should we attack sir? [Y/N]: ');  ansic(7); if yn then response:=1
     else response := 2; if response = 2 then nl;
    IF response = 1 THEN
     BEGIN
      IF dukedom_peasants > 100 THEN
       BEGIN
        nl;nl;
        dukedom_war_deaths_this_battle := round(random(20));
        opponent_war_deaths_this_battle := round (random(30));
        dukedom_war_deaths := dukedom_war_deaths + dukedom_war_deaths_this_battle;
        dukedom_peasants := dukedom_peasants - dukedom_war_deaths_this_battle;
        kings_peasants := kings_peasants - opponent_war_deaths_this_battle;
        response := 0;
        IF kings_peasants < 0 THEN kings_peasants := 0;
        prompt('   We lost '); ansic(3); prompt(cstr(dukedom_war_deaths_this_battle));
         ansic(0); prompt(' men, and have '); ansic(7); prompt(cstr(dukedom_peasants));
         ansic(0); print(' men left...');
        prompt(' They lost '); ansic(3); prompt(cstr(opponent_war_deaths_this_battle));
         ansic(0); prompt(' men, and have '); ansic(7); prompt(cstr(kings_peasants));
         ansic(0); print(' men left..');
        nl;nl;
       END
      ELSE {if dukedom_peasants < 100}
       BEGIN
        print('    We only have '+cstr(dukedom_peasants)+' left!');
        print('    The men refuse to attack against such great odds!  As a result');
        print('    of your bogus orders, ther attitude goes down 1 more point!');
        dukedom_attitude := dukedom_attitude - 1;
        response := 2;
       END;
     END;
  until (response<>0) or (hangup);
  kings_peasants := kings_peasants + kings_peasants_inoc; {they come back}
 END {fight_king};

PROCEDURE fight_duke;
VAR fight:boolean;
 BEGIN
  response := 0; fight := false;
  opposing_duke_peasants := dukedom_peasants;
  dukedom_captured := 0;                     {no peasants captured... yet}
  dukedom_attitude := dukedom_attitude - 1;  {peasants hate war!}
  kings_attitude := kings_attitude + 1;      {king likes you to fight other dukes}
  repeat
    nl;
    prompt('Attack which Duke? (N,E,S,W,[Q]uit) : '); onek(iii,'NESWQ'+#13);
     case iii of
        'N' : begin
                 where_duke := 'North'; warduke:=kn.nduke;
                 if not north_duke then
                 begin
                    nl; ansic(5); print('You have already defeated that Duke!!');
                    nl; iii := 'Q';
                 end else fight := true;
              end;
        'E' : begin
                 where_duke := 'East'; warduke:=kn.eduke;
                 if not east_duke then
                 begin
                    nl; ansic(5); print('You have already defeated that Duke!!');
                    nl; iii := 'Q';
                 end else fight := true;
              end;
        'S' : begin
                 where_duke := 'South'; warduke:=kn.sduke;
                 if not south_duke then
                 begin
                    nl; ansic(5); print('You have already defeated that Duke!!');
                    nl; iii := 'Q';
                 end else fight := true;
              end;
        'W' : begin
                 where_duke := 'West'; warduke:=kn.wduke;
                 if not west_duke then
                 begin
                    nl; ansic(5); print('You have already defeated that Duke!!');
                    nl; iii := 'Q';
                 end else fight := true;
              end;
        'Q' : begin
                 response := 2;
                 fight := true;
                 nl;
              end;
        #13 : begin
                 response := 2;
                 fight := true;
                 nl;
               end;
     end;
  until fight or hangup;
  if iii <> 'Q' then
     begin
        nl;
        print('Attacking the '+where_duke+'ern Duke!');
        print('Who is in league with '+warduke);
        nl;
     end;
  repeat
    prompt('We are prepared to fight...  Should we attack sir? [Y/N]: '); ansic(7); if yn then response:=1
     else response := 2; if response = 2 then nl;
    IF response = 1 THEN
     BEGIN
     IF dukedom_peasants > 100 THEN
       BEGIN
        nl;nl;
        dukedom_war_deaths_this_battle := round(random(20));
        opponent_war_deaths_this_battle := round (random(30));
        dukedom_war_deaths := dukedom_war_deaths + dukedom_war_deaths_this_battle;
        dukedom_peasants := dukedom_peasants - dukedom_war_deaths_this_battle;
        opposing_duke_peasants := opposing_duke_peasants - opponent_war_deaths_this_battle;
        response := 0;
        IF opposing_duke_peasants < 0 THEN opposing_duke_peasants := 0;
        prompt('   We lost '); ansic(3); prompt(cstr(dukedom_war_deaths_this_battle));
         ansic(0); prompt(' men, and have '); ansic(7); prompt(cstr(dukedom_peasants));
         ansic(0); print(' men left...');
        prompt(' They lost '); ansic(3); prompt(cstr(opponent_war_deaths_this_battle));
         ansic(0); prompt(' men, and have '); ansic(7); prompt(cstr(opposing_duke_peasants));
         ansic(0); print(' men left..');
        nl;nl;
       END
      ELSE {if dukedom_peasants < 100}
       BEGIN
        print('    We only have '+cstr(dukedom_peasants)+' left!');
        print('    The men refuse to attack against such great odds!  As a result');
        print('    of your bogus orders, ther attitude goes down 1 more point!');
        dukedom_attitude := dukedom_attitude - 1;
        response := 2;
       END;
     END;
    IF opposing_duke_peasants < 25 THEN  {win battle against opposing duke}
     BEGIN
      response := 2;         {make sure you don't still attack}
      land_confiscated := round(random(dukedom_land));
      dukedom_captured := round(random(200));
      print('You Won!!  The opposing duke surrenders!');
      print('Your Spoils:'); nl;
      prt4(cstr(dukedom_captured)); print(' Peasants captured...');
      prt4(cstr(land_confiscated)); print(' Acres of land confiscated...');
      username := lower(thisuser.name);
      case iii of
         'N' : begin north_duke := false;  kn.nduke:=username; end;
         'S' : begin south_duke := false;  kn.sduke:=username; end;
         'E' : begin east_duke := false;   kn.eduke:=username; end;
         'W' : begin west_duke := false;   kn.wduke:=username; end;
      end;
      nl;
      new_duke;
     END;
  until (response<>0) or (hangup);
 END {fight_duke};

PROCEDURE wanna_attack_king;
 BEGIN
  response := 0;
    prompt('Attack '+kn.kingname+'? [Y/N]: ');ansic(7); if yn then response:=1;
    IF response = 1 THEN fight_king;
 END {wanna_attack_king};

PROCEDURE wanna_attack_duke;
 BEGIN
  response := 0;
    prompt('Attack another Duke? [Y/N]: ');ansic(7);if yn then response:=1;
    IF response = 1 THEN fight_duke;
 END {wanna_attack_duke};

PROCEDURE get_options_for_turn;
 BEGIN
  nl;
   dukedom_war_deaths := 0;
   dukedom_captured := 0;
   IF dukedom_peasants > 500 THEN {king attacks if you have too many men}
    fight_king
   ELSE   {if dukedom_peasants < 500 }
    BEGIN
     nl;
     wanna_attack_king;
     wanna_attack_duke;
     wanna_gamble;
    END;
   how_much_food;
   how_much_seed;
   buy_sell_land;
   harvest_crop;
 END {get_options_for_turn};

PROCEDURE take_turn;
 BEGIN
  topscr;
  inc(year);
  inc(age);
  inc(kn.age);
  IF year > 1 THEN display_previous_turn;
  IF dukedom_grain > 0 THEN
    begin
      IF dukedom_attitude > 0 THEN
        BEGIN
          display_status;
          get_options_for_turn;
          special_events;
         END;
      dukedom_peasants_prev_turn := dukedom_peasants;
      dukedom_grain_prev_turn := dukedom_grain;
      dukedom_land_prev_turn := dukedom_land;
      update_previous_turn_values;
    end;
 END {take_turn};

 BEGIN
  iport;
  sysoplog('  * Played Dukedom');
  assign(kf,'gfiles\KING30.DAT');
  {$I-} reset(kf); {$I+}
  if ioresult <> 0 then
    begin
      print('Creating KING30.DAT...');
      kn.kingname:='King Arthur';
      kn.nduke:='Sir Galahad';
      kn.sduke:='Lord Baltimore';
      kn.eduke:='Wasteland Warrior';
      kn.wduke:='King Mark';
      kn.age:=25 + random(8);
      rewrite(kf);
      write(kf,kn);
      close(kf);
    end
  else
    begin
      read(kf,kn);
      close(kf);
    end;
  if kn.age > 70 then kn.age := 35;
  if kn.age > 60 then kn.age := kn.age - random(10);
  initialize;
  intro;
  WHILE (((dukedom_attitude > 0) AND (dukedom_grain>0) AND (kings_attitude > 0) AND (age < 65)) and (not hangup)) DO
   BEGIN
    IF (age < 65) THEN take_turn
    ELSE
     BEGIN
      display_status;
      Cls;
      nl;
      print('You have reached the age of mandatory retirement... ');
      print('Your life has been a waste.  To have a chance at    ');
      print('taking over the kingdom, you must accumulate around ');
      print('500 peasants and then attack '+kn.kingname+'.  Better');
      print('luck next time... you SHOULD do better!');
      wait_for_keypress;
     END;
    IF kings_attitude <= 0 THEN
     BEGIN
      display_status;
      Cls;
      nl;
      print(kn.kingname+' has grow weary of your cut-throat ways and removed');
      print('you from power.  Your life will be spared but you are sentenced');
      print('to eternal exile in the land of gang-warfare.  The place known');
      print('to all mortal men as NEW YORK CITY... May you find what you seek!');
      wait_for_keypress;
     END;
    IF dukedom_attitude = 0 THEN
     BEGIN
      display_status;
      Cls;
      nl;
      print('The people have grown tired of such tyranny... '+kn.kingname);
      print('intervenes and divides your dukedom amoung the other Dukes');
      print('in the hope that they will take better care of the people.');
      print('They deserve it...  Better luck next time...              ');
      wait_for_keypress;
     END;
    IF dukedom_grain < 1 THEN
     BEGIN
       display_status;
       cls;
       nl;
       print('You have expelled your resources, and can no longer feed the');
       print('peasants.  '+kn.kingname+' intervened to save your peasants');
       print('and banish you from his Kingdom.');
       wait_for_keypress;
      END;
   END;
 sysoplog('  * Lost at Dukedom');
 return;
END.
