program Arena;

{$V-} {$C-}

{$I COMMON.PAS}

const colors = 8;

label start;

type
  colorary = array[1..8] of byte;
  playertype =
    record
      name,killer,password,ally : string[30];
      status,flights,alliance,plus: integer;
      r,experience,strength,intelligence,gold,luck,dexterity,constitution,charisma,weapon,vehicle,shield,damage,bank,
      attack,power : real;
    end;

  opponent =
    record
      name : string[30];
      gold,strength,dexterity,shield,luck,experience,weapon,weapon2,attack,power,vehicle : real;
    end;

var
  required : array[1..28] of real;
  wname,sname : array[1..25] of string[30];
  strip,temp : string[50];
  cost,w2,w3 : array[1..25] of real;
  vary,vary2,d,e,rd,roll,z,opt,x,buy,g: real;
  opty : char;
  option : string[1];
  mess : array[1..20] of string[85];
  infile,outfile,messfile : text;
  doc : string[80];
  opp : opponent;
  name,password : string[30];
  gamble,a,b,m,amount,j,skim,number,dog,f,y,number_of_players,number2,verify,trips : integer;
  allied,finder,verbose,play,doga,uni,live,found,ftn : boolean;
  player : array[1..50] of playertype;
  enemy : string[30];
  result : array[1..51] of string[80];
  tempcol:colorary;

const colorar:colorary = (7,14,2,12,11,31,9,140);


var
  abort : boolean;

procedure printm(clr:integer; i : str);
  begin
    if colors>9 then clr:=clr-8;
    ansic(clr);
    print(i);
  end;

procedure prtc(clr:integer; i:str);
  begin
    ansic(clr);prompt(i);ansic(0);
  end;

procedure printam(i : str);
var
  next : boolean;

  begin
    printa(i,abort,next);
  end;

procedure prtm(clr:integer; i : str);
  begin
    prtc(clr,i);
  end;

procedure ct(clr:integer; std:str);
begin
  if colors>=9 then clr:=clr-8;
  printm(clr,std);
end;

procedure cp(clr:integer; stp:str);
begin
  if colors>=9 then clr:=clr-8;
  prtm(clr,stp);
end;

function playerattack : real;
  begin
    playerattack:=(vary*player[b].attack*player[b].strength*player[b].dexterity*(random*5+1))/
              (opp.vehicle*opp.dexterity*opp.luck*vary2);
  end;

function playerattack2 : real;
  begin
    playerattack2:=round((vary*player[b].power*player[b].strength*(random*5+1)*(random*5+1))/
                  ((opp.vehicle)*opp.luck*vary2));
  end;

function roller : integer;
  begin
    roller:=round(random*3+1);
  end;


function opponentattack : real;
  begin
    opponentattack:=(vary2*opp.weapon*opp.strength*opp.dexterity*(random*5+1))/
            ((player[b].vehicle)*player[b].dexterity*player[b].luck*vary);
  end;


function opponentattack2 : real;
  begin
    opponentattack2:=round((vary2*opp.weapon2*opp.strength*(random*5+1)*((random*5)+1))/
                  ((player[b].vehicle)*player[b].luck*vary));
  end;


function find1 : real;
  begin
    find1:=w2[round(player[b].weapon)];
  end;

function find2 : real;
  begin
    find2:=w3[round(player[b].weapon)];
  end;

function supplant : real;
  begin
    supplant:=(random(4)/10+(0.8));
  end;

function experience: real;
  begin
    experience:=((opp.vehicle-1+(opp.weapon+opp.weapon2-2)/2)*20+(opp.shield*7.5)+((opp.strength-10)*20)+
    (opp.luck+opp.dexterity-20)*15);
  end;

function spin : real;
  begin
    spin:=(random*6+1)+(random*6+1)+(random*6+1);
  end;

procedure depobank;
  var
    tempbank : real;
  begin
    tempbank:=player[b].gold;
    if tempbank>((player[b].r*player[b].r)*1000)-player[b].bank then
      begin
        tempbank:=((player[b].r*player[b].r)*1000)-player[b].bank;
        str(((player[b].r*player[b].r)*1000):1:0,temp);
      ct(5,'Ye can''t put in more than '+temp+' at your current rank');
      ct(5,'So I''ll just put in the max');
      end;
    if tempbank<0 then tempbank:=0;
    player[b].gold:=player[b].gold-tempbank;
    player[b].bank:=player[b].bank+tempbank;
    str(player[b].bank:1:0,temp);
    ct(5,'Ye now have '+temp+' Gold Pieces in the depository');
  end;


procedure withdrawbank;
  var
    tempbank : real;
  begin
    tempbank:=player[b].bank;
    if tempbank<0 then tempbank:=0;
    player[b].gold:=player[b].gold+tempbank;
    player[b].bank:=player[b].bank-tempbank;
    str(player[b].bank:1:0,temp);
    ct(5,'Ye now have '+temp+' Gold Pieces in the depository');
  end;


procedure playerlist;
  var
    p,q,v,t: integer;
    ts:str;

  begin
    cls;
   nl;
   ansic(7);
   print('         Rank  Player                Level       Aquired pts.');
    for p:=1 to number_of_players do
      begin
        ts:='';
        str(p:3,temp);
        prtc(7,'         '+temp+'.  ');
        temp:=player[p].name;
        prtc(7,temp);
        for q:=1 to 20-length(player[p].name) do ts:=ts+' ';
        prtc(7,ts);
        t:=round(player[p].r);
        str(t:2,temp);
        prtc(7,'   '+temp+'        ');
        str(player[p].experience:9:0,temp);
        ansic(7);
        print(temp);
      end;
    nl;
    cp(2,'(--Hit enter to proceed--)');
    input(option,1); nl;nl;
  end;


procedure leave; forward;


 procedure checkday;
  var
    oldy : str;
    h : integer;
  begin
    for a:=1 to number_of_players-1 do
     begin
      for h:=a+1 to number_of_players do
       begin
        if player[h].experience>player[a].experience then
         begin
          if h=b then b:=a
          else if a=b then b:=h;
          player[number_of_players+1]:=player[h];
          player[h]:=player[a];
          player[a]:=player[number_of_players+1];
         end;
       end;
     end;
    assign(infile,'date.arn');
    reset(infile);
    readln(infile,oldy);
    if oldy<>date then
      begin
        rewrite(infile);
        writeln(infile,date);
        for a:=1 to number_of_players do
          begin
            player[a].flights:=3;
            player[a].status:=0;
          end;
        assign(outfile,'record.arn');
        rewrite(outfile);
        writeln(outfile,'0');
        close(outfile);
      end;
    close(infile);
  end;

procedure goodbye;
  begin
    sysoplog('Played Arena');
    close(infile);
    close(outfile);
    return;
  end;

procedure heal;
  begin
   nl;
    str(player[b].gold:9:0,temp);
    ct(5,'Ye have '+temp+' gold pieces.');
    str(player[b].damage:9:0,temp);
    ct(7,'Ye have '+temp+' damage to repair');
    str(round(10*player[b].r),temp);
    ct(3,' Each Repair costs '+temp+' gold pieces.');
    cp(2,'How many does ye want?');
    repeat
      {$I-}
      input(temp,3);
      opt:=value(temp);
      {$I+}
      j:=ioresult;
      checkhangup;
    until (j=0) or hangup;
    if hangup then leave;
    if ((round(opt))*(player[b].r)*10)>player[b].gold then
      begin
    ansic(8); print('Ye don''t have enough left !');
        opt:=0;
      end
    else if opt>player[b].damage then opt:=player[b].damage;
    player[b].damage:=player[b].damage-opt;
    player[b].gold:=player[b].gold-10*opt*player[b].r;
    str(round(opt),temp);
    ct(4,'Ye have '+temp+' Repairs !');
 end;


procedure battle;  forward;

{procedure revenge;
  begin
    if player[a].alliance=1 then
      begin
       enemy:=player[a].ally;
       for a:=1 to number_of_players do
       begin
         if enemy=player[a].name then
          begin
           if player[a].status=0 then finder:=true;
          end;
       end;
       if finder=false then exit;
     nl;
     ct(5,'Ye are being Jousted by the vengeful '+enemy+'!');
      for a:=1 to number_of_players do
      if player[a].name=enemy then
        begin
          m:=a;
          opp.name:=player[a].name;
          opp.shield:=player[a].shield;
          f:=b;
          d:=player[b].attack;
          e:=player[b].power;
          g:=player[b].weapon;
          b:=a;
          player[b].weapon:=player[a].weapon;
          opp.weapon:=find1;
          opp.weapon2:=find2;
          b:=f;
          player[b].weapon:=g;
          player[b].attack:=d;
          player[b].power:=e;
          opp.vehicle:=player[a].vehicle;
          opp.luck:=player[a].luck;
          opp.strength:=player[a].strength;
          opp.dexterity:=player[a].dexterity;
          opp.gold:=player[a].gold;
          z:=player[a].experience/10;
          finder:=false;
          doga:=false;
          battle;
        end;
      end;
    end;}

procedure recorda;
  var
    o:integer;
  begin
    assign(outfile,'record.arn');
    rewrite(outfile);
    writeln(outfile,number);
    for o:=1 to number do
    writeln(outfile,result[o]);
    close(outfile);
  end;

procedure readla;
  var
    o:integer;
  begin
    assign(infile,'record.arn');
    reset(infile);
    readln(infile,number);
    if number >50 then number:=50;
    for o:=1 to number do
    readln(infile,result[o]);
    close(infile);
  end;

procedure mutantvictory;
var bt:integer;
  begin
    a:=m;
    nl;
    if not doga then opp.gold:=opp.gold*supplant;
    str(opp.gold:8:0,temp);
    ct(5,'Ye get his '+temp+' Gold Pieces!');
    player[b].gold:=player[b].gold+opp.gold;
    nl;
    if doga then
      begin
        player[a].killer:=player[b].name;
        player[a].status:=1;
        player[a].gold:=0;
          if player[a].weapon>player[b].weapon then
            begin
              d:=player[b].weapon;
              player[b].weapon:=player[a].weapon;
              player[a].weapon:=d;
              bt:=player[b].plus;
              player[b].plus:=player[a].plus;
              player[a].plus:=bt;
            end;
          if player[a].vehicle>player[b].vehicle then
            begin
              d:=player[b].vehicle;
              player[b].vehicle:=player[a].vehicle;
              player[a].vehicle:=d;
            end;
          player[b].attack:=find1;
          player[b].power:=find2;
          readla;
          number:=number+1;
          result[number]:=(player[b].name+' defeated '+player[a].name+'!');
          recorda;

       end;
    z:=z*supplant;
    player[b].experience:=player[b].experience+z;
    str(z:6:0,temp);
    ct(5,'Ye also get '+temp+' Acquired points!'); nl;
    cp(2,'(--Hit enter to proceed--)');
    input(option,1);
    doga:=false;
   nl;nl;
  end;



procedure levelupdate;
var x:integer;
  begin
   nl;
    str(round(player[b].r)+1,temp);
    ct(7,'To reach skill rank '+temp);
    str(required[round(player[b].r+1)]:3:0,temp);
    ct(7,'ye need '+temp+' Acquired points.');
    str(player[b].experience:9:0,temp);
    if player[b].experience>required[round(player[b].r+1)] then
      begin
        ct(2,'So ye have been granted a higher rank!!!');
        player[b].r:=player[b].r+1;
        a:=roller; x:=random(6)+1;
        if a=1 then case x of
                         1:player[b].strength:=player[b].strength+1;
                         2:player[b].intelligence:=player[b].intelligence+1;
                         3:player[b].luck:=player[b].luck+1;
                         4:player[b].dexterity:=player[b].dexterity+1;
                         5:player[b].constitution:=player[b].constitution+1;
                         6:player[b].charisma:=player[b].charisma+1;
                    end;
        player[b].shield:=player[b].shield+(random*5+1)+(player[b].constitution/4);
         for a:= 1 to 10 do
           begin
             nl;
             checkhangup;
             if hangup=true then leave;
           end;
      end
     else for a:=1 to 2 do
      begin
       nl;
       checkhangup;
       if hangup=true then leave;
      end;
    end;

procedure leave;
  begin
  nl;
  ct(7,'That ends this Venture!');
  assign(outfile,'character.arn');
  rewrite(outfile);
  writeln(outfile,number_of_players);

  for a:= 1 to number_of_players do
    begin
      writeln(outfile,player[a].name);
      writeln(outfile,player[a].status);
      if player[a].status=1 then
        writeln(outfile,player[a].killer);
      writeln(outfile,round(player[a].strength),' ',round(player[a].intelligence),' ',
       round(player[a].luck),' ',round(player[a].dexterity),' ',round(player[a].constitution),
       ' ',round(player[a].charisma),' ',(player[a].experience):1:0,' ',
       round(player[a].r),' ',round(player[a].shield),' ',round(player[a].weapon),
       ' ',round(player[a].vehicle),' ',player[a].gold:1:0,' ',
       ' ',player[a].flights,' ',player[a].bank:1:0,' ',player[a].plus);
    end;
  close(outfile);
  close(infile);
  goodbye;
end;


procedure universeexplain;
begin
  nl;
  ct(7,'^^^^^^^^^^^^^^^^^^^^');
  ct(7,'|- Coloseum Arena -|');
  ct(7,'vvvvvvvvvvvvvvvvvvvv'); nl;
  ct(5,'(S)-Battle a Slave');
  ct(3,'(T)-Battle a Trainee');
  ct(4,'(F)-Battle a Gladiator');
  ct(5,'(C)-Battle a Centurian Guard');
  ct(7,'(G)-Battle a God');
  ct(3,'(R)-Repairs to armor');
  ct(7,'(+)-deposit gold');
  ct(2,'(-)-withdraw gold');
  ct(5,'(Q)-Quit Coloseum Arena');nl;nl;
end;

procedure quickexit;
begin
  goodbye;
end;

procedure amode;
begin
  roll:=playerattack;
  if roll<1.5 then
    ct(5,'Ye missed him!')
  else
    begin
      roll:=playerattack2;
      if roll>5*player[b].power then roll:=5*player[b].power;
      opp.shield:=opp.shield-roll;
      nl;
      str(round(roll),temp);
      printm(4,'Ye got him for '+temp); nl;
      if opp.shield<=0 then
        begin
          nl;
          ct(8,'Ye slew him!');
          mutantvictory;
          live:=false;
        end;
    end;
end;

procedure bmode;
var bt:integer;
begin
  if (opp.shield>0) and live then
    begin
      roll:=opponentattack;
        if roll<1.5 then
          begin
            nl;
            ct(5,'He Missed Ye!');
          end
        else
          begin
            roll:=opponentattack2;
            if roll>5*opp.weapon2 then roll:=5*opp.weapon2;
              str(round(roll),temp);
              ct(5,'He hit ye for '+temp+' damage!');
              player[b].damage:=player[b].damage+roll;
            if (player[b].damage>=player[b].shield) then begin
              nl;
          ansic(8); print('He did ye in!');
          ct(2,'Farewell '+player[b].name);
              if doga then
                begin
                  player[a].gold:=player[a].gold+player[b].gold;
                  player[b].gold:=0;
                  if player[a].weapon<player[b].weapon then
                    begin
                      d:=player[a].weapon;
                      player[a].weapon:=player[b].weapon;
                      player[b].weapon:=d;
                      bt:=player[b].plus;
                      player[b].plus:=player[a].plus;
                      player[a].plus:=bt;
                    end;
                  if player[a].vehicle<player[b].vehicle then
                    begin
                      d:=player[a].vehicle;
                      player[a].vehicle:=player[b].vehicle;
                      player[b].vehicle:=d;
                    end;
                  readla;
                  number:=number+1;
                  result[number]:=(player[b].name+' was defeated by '+player[a].name+'!');
                  recorda;
                end;
                live:=false;
                leave;
              end;
             end;
           end;
end;


procedure question;
begin
  nl;
  ct(7,'+^^^^^^^^^^^^^^^^^^+');
  ct(2,'A - Go for it');
  ct(5,'R - Retreat! ');
  ct(7,'+vvvvvvvvvvvvvvvvvv+'); nl;
end;

procedure attackmodes;
begin
  if opp.dexterity>player[b].dexterity then
    begin
      bmode;
      amode;
    end else
  if opp.dexterity<player[b].dexterity then
    begin
      amode;
      bmode;
    end
  else ct(7,'Ye parry each other''s blows');
end;

procedure battle;
var loss:real; option:char;
  begin
    nl;
    live:=true;
    while live=true do
    begin
    printm(8,'Ye come upon a  '+opp.name); nl;
      repeat
        if verbose then question;
        cp(2,'Option?');
        onek(option,'AR?');
        if (option='?')and (verbose=false) then
          question;
          checkhangup;
      until (hangup) or (option='A') or (option='R');
        if hangup then leave;
        case option of
             'A':attackmodes;
             'R':if (random*4+1)+player[b].dexterity>opp.dexterity then
                   begin
                     nl;
                     ct(3,'Ye escaped!');
                     doga:=false;
                     live:=false;
                   end;
        end;
    end;
end;

procedure searcher;
  begin
    trips:=trips+1;
    readln(infile,amount);
      rd:=random*(amount-1)+1;
      amount:=round(rd);
        for a:=1 to amount do
         begin
          readln(infile,opp.name);
          readln(infile,opp.shield,opp.weapon,opp.weapon2,opp.vehicle,opp.luck,
          opp.strength,opp.dexterity,opp.gold,z);

         end;
         close(infile);
         opp.weapon:=opp.weapon*supplant;
         opp.weapon2:=opp.weapon2*supplant;
         opp.vehicle:=opp.vehicle*supplant;
         opp.luck:=opp.luck*supplant;
         opp.strength:=opp.strength*supplant;
         opp.dexterity:=opp.dexterity*supplant;
         opp.shield:=opp.shield*supplant;
  end;


procedure fight(filename:str);
begin
  assign(infile,filename);
  reset(infile);
  searcher;
  battle;
end;


procedure doggie;
  begin
   if dog<2 then
   begin
   nl;
    repeat
     repeat
     prtc(2,'Which of ye fellow Romans do ye want to attack?');
      input(enemy,40);

      if enemy='?' then for a:=1 to number_of_players do
       begin
        checkhangup;
        if hangup then leave;
        if player[a].name<>player[b].name then
         if player[a].status=0 then
          if player[a].r>(player[b].r-4) then
          begin
            str(player[a].r:2:0,temp);
            print('rank: '+temp+'  '+player[a].name);
          end;
       end;
      if enemy='' then exit;
      if enemy=player[b].name then exit;
      checkhangup;
     until (hangup) or (enemy<>'?');
     if hangup then leave;
     for a:=1 to number_of_players do
       begin
         if enemy=player[a].name then
          begin
           if player[a].status=0 then
            if player[a].r>(player[b].r-4) then
             begin
               finder:=true;
               m:=a;
             end;
          end;
       end;
       checkhangup;
    until (hangup) or (finder=true);
    if hangup then leave;
      a:=m;
        begin
          opp.name:=player[a].name;
          opp.shield:=player[a].shield;
          f:=b;
          vary2:=supplant;
          doga:=true;
          d:=player[b].attack;
          e:=player[b].power;
          g:=player[b].weapon;
          b:=a;
          dog:=dog+1;
          opp.weapon:=find1;
          opp.weapon2:=find2;
          b:=f;
          player[b].weapon:=g;
          player[b].attack:=d;
          player[b].power:=e;
          opp.vehicle:=player[a].vehicle;
          opp.luck:=player[a].luck;
          opp.strength:=player[a].strength;
          opp.dexterity:=player[a].dexterity;
          opp.gold:=player[a].gold;
          if opp.gold<0 then opp.gold:=0;
          z:=player[a].experience/10;
          finder:=false;
          if enemy=player[b].ally then
           begin
            player[b].alliance:=0;
            player[a].alliance:=0;
           end;
          battle;
        end;
    end;
  end;

  procedure docs;
  begin
    assign(infile,'docs.arn');
    reset(infile);
    readln(infile,number);
     a:=1;
       repeat
        checkhangup;
        if hangup then leave;
        readln(infile,doc);
        ansic(3);
        printam(doc);
        nl;
        if a=20 then
          begin
            cp(2,'(--Hit enter to proceed--)');
            input(option,1);
          end;
        a:=a+1;
       until (a>number) or (abort) or (hangup);
     close(infile);nl;nl;
   end;

procedure statussheet;
  var
    word : string[20];
  begin
    cls;
    ct(7,'Ye status:');
  ansic(4); print('                         -----------------------------');
  ansic(2); print('                                Name: '+player[b].name); nl;
    str(round(player[b].r),temp);
  ansic(3); print('                               Level: '+temp);
  ansic(3); print('                              Weapon: '+wname[round(player[b].weapon)]);
  ansic(3); print('                             Vehicle: '+sname[round(player[b].vehicle)]);
    str(player[b].gold:1:0,temp);
  ansic(3); print('                             Ye Gold: '+temp);
     str(player[b].strength:1:0,temp);
  ansic(3); print('                            Strength: '+temp);
    str(player[b].experience:1:0,temp);
  ansic(3); print('                          Aq. Points: '+temp);
    str(player[b].damage:1:0,temp);
  ansic(3); print('                             Damage to Repair:');
  ansic(8); print('                                     v');
  ansic(3); print('                                     '+temp); nl;
    if verbose then
     begin
      cp(5,'(--Hit enter to continue--)');
      input(option,1);
     end;
  end;

procedure create(new:boolean);
begin
  if new then
    begin
      nl;
      docs;
      nl;
      a:=number_of_players+1;
      player[a].name:=thisuser.name;
      a:=number_of_players+1;
    end else
  begin
    a:=b;
    player[a].name:=thisuser.name;
  end;
  with player[a] do
    begin
      strength:=spin;
      status:=0;
      if new then number_of_players:=number_of_players+1;
      intelligence:=spin;
      luck:=spin;
      alliance:=0;
      dexterity:=spin;
      constitution:=spin;
      charisma:=spin;
      gold:=0;
      weapon:=1;
      vehicle:=1;
      experience:=0;
      plus:=0;
      bank:=(random(199)+1);
      r:=1;
      shield:=(random*4+1)+player[a].constitution;
      flights:=3;
    end;
  nl;
  b:=a;
end;


procedure universe;
 VAR
  option:char;
 begin
  cls;
  uni:=true;
  while uni do
    begin
      if trips>10 then
        begin
          nl;
          ct(7,'Ye have fought long this venture!');
          ct(4,'Ye may only have 10 battles per venture.');
          uni:=false;
        end
      else
        begin
              ct(7,'As ye look about ye are awed by the immenensity of this huge Coloseum');
              ct(7,'Ye look about and smell the blood of the victims that died here before.');
              ct(7,'Ye can''t help to wonder if ye will survive the ordeals ahead of ye.');
              nl;nl;
           if verbose then universeexplain;
          cp(2,'Battle command? :');
          onek(option,'QSTCFGR+-?');

          if (option='?') and (verbose=false) then universeexplain;
          case option of
             '+':depobank;
             '-':withdrawbank;
             'Q':begin;uni:=false;nl;nl;nl;end;
             'S':fight('slave.arn');
             'T':fight('trainee.arn');
             'C':fight('centurio.arn');
             'F':fight('gladiator.arn');
             'G':fight('god.arn');
             'R':heal;
          end;
        end;
    end;
end;

procedure strait;
var p:integer;
begin
  for p:=1 to 25-length(strip) do
    strip:=' '+strip;
end;

procedure weaponlist;
 var
   next : boolean;

begin
  nl;
  nl;
  a:=1;
  repeat
    checkhangup;
    if hangup then leave;
    str(cost[a]:9:0,temp);
    str(a:2,opp.name);
    ansic(4);
    strip:=wname[a];
    strait;
    printa(opp.name+'.'+(strip)+'   '+temp+'  '+(sname[a]),abort,next);
    nl;
    a:=a+1;
  until (a>25) or (abort);
end;


procedure readlist;
  begin
    assign(infile,'character.arn');
    reset(infile);
    readln(infile,number_of_players);
    a:=1;
    b:=1;
    while (a<=number_of_players) do
      begin
        readln(infile,player[a].name,player[a].status);
        if player[a].status=1 then
          readln(player[a].killer);
        read(infile,player[a].strength,player[a].intelligence,player[a].luck,player[a].dexterity);
        read(infile,player[a].constitution,player[a].charisma,player[a].experience,player[a].r);
        read(infile,player[a].shield,player[a].weapon,player[a].vehicle,player[a].gold);
        read(infile,player[a].flights,player[a].bank);
        readln(infile,player[a].plus);
        a:=a+b;
      end;
    close(infile);
end;

procedure weaponquip;
begin

  input(temp,1);
  weaponlist;
end;

procedure craps(var bet:real);
var finished:boolean;
    dye,dice1,dice2,number,nr,multi,dice:integer;
    choice:string[2];


  procedure win;
  begin
    ct(8,'Ye Win!!');
    finished:=true;
    bet:=multi*bet;
    player[b].gold:=player[b].gold+bet;
  end;

  procedure lose;
  begin
    ct(4,'Ye Lose!');
    finished:=true;
    bet:=0;
    player[b].gold:=player[b].gold+bet;
  end;

  procedure showdice(n:integer);
  begin
    printm(4,'+-----+');
    case n of
         1:begin
             printm(4,'|     |');
             printm(4,'|  *  |');
             printm(4,'|     |');
           end;
         2:begin
             printm(4,'| *   |');
             printm(4,'|     |');
             printm(4,'|   * |');
           end;
         3:begin
             printm(4,'| *   |');
             printm(4,'|  *  |');
             printm(4,'|   * |');
           end;
         4:begin
             printm(4,'| * * |');
             printm(4,'|     |');
             printm(4,'| * * |');
           end;
         5:begin
             printm(4,'| * * |');
             printm(4,'|  *  |');
             printm(4,'| * * |');
           end;
         6:begin
             printm(4,'| * * |');
             printm(4,'| * * |');
             printm(4,'| * * |');
           end;
    end;
    printm(4,'+-----+');nl;
  end;



begin
  multi:=random(25)+1;
  repeat
  cls;
  finished:=false;
  nr:=0;
  nl; ct(8,'The  B O N E S'); nl; nl;
  ct(3,'----------------------');
  ct(4,'(P)ass');
  ct(5,'(D)on''t pass');
  ct(7,'(Q)uit');
  ct(3,'----------------------');
  str(multi,temp);
  ct(5,'House pays: '+temp+' to 1');
  cp(7,'Your choice:  ');
  {$I-}
  input(choice,2);
  {$I+}
  checkhangup;
  until (choice='P') or (choice='D') or (choice='Q');
  if choice='Q' then exit;
  if choice='P' then repeat number:=random(6)+random(6)+2; until number in [4..6,8..10];
  repeat
    nr:=nr+1;
    dice1:=random(6)+1; showdice(dice1);
    dice2:=random(6)+1; showdice(dice2);
    dice:=dice1+dice2;
    if nr = 1 then dye:=dice1+dice2;
    if choice='D'
    then printm(5,'Ye are trying for a don''t pass')
      else begin
             str(number,temp);
             ct(5,'Ye are trying for a '+temp);
           end;

    str(dice,temp);
    ct(7,'ye rolled a total of '+temp);
    str(dye,temp);
    if choice='D' then ct(2,'The point is '+temp);
    if ((choice='P') and (nr=1) and ((dice=7) or (dice=11))) then win
    else if ((choice='P') and (dice=number)) then win
    else if ((choice='D') and (nr=1) and ((dice=2) or (dice=3) or (dice=12))) then win
    else if ((choice='D') and (nr>1) and ((dice=7) or (dice=11))) then win
    else if ((choice='P') and (nr>1) and ((dice=7) or (dice=11))) then lose
    else if ((choice='D') and (nr=1) and ((dice=7) or (dice=11))) then lose
    else if ((choice='D') and (nr>1) and (dice=dye)) then lose
    else if ((choice='P') and (nr=1) and ((dice=2) or (dice=3) or (dice=12))) then lose;

    pausescr;
  until finished;
end;

procedure weaponshop;
begin
  cls;
  ct(3,'The Coloseum Arena - "YE OLE WEAPON SHOP"');
  ct(2,'Choose Wisely Citizen !');nl;
  option:='B';
  while option<>'' do
    begin
      repeat
      if verbose then
      begin
      cp(4,'(--Hit enter to proceed--)');
       weaponquip;
     end;nl;
      cp(5,'Would ye like to buy or sell(B or S)?');
      INPUT(OPTION,1);
      checkhangup;
      until (option='B') or (option='S') or (option='') or (option='Q') or hangup;
      if hangup then leave;
        if option='B' then
          begin
            nl;
           repeat
            {$I-}
            cp(3,'What number(0 for list)?');
            input(temp,5);
            buy:=value(temp);
            {$I+}
            j:=ioresult;
            checkhangup;
           until (hangup) or(j=0);
           if hangup then leave;

              if (buy=0) and (verbose=false) then weaponlist
              else
                begin
                 if buy>25 then printm(2,'What?')
              else if cost[round(buy)]>player[b].gold then printm(2,'Not enough gold!')
                 else
                   begin
                     repeat
                     cp(7,'(W)eapon or (V)ehicle?');
                     input(option,1);
                     checkhangup;
                     until (hangup) or (option<>'D');
                     if hangup then leave;
                     if option='W' then
                       begin
                         player[b].gold:=player[b].gold-cost[round(buy)];
                         player[b].weapon:=buy;
                         cp(2,'Ye have bought a '+wname[round(buy)]); nl;
                         player[b].attack:=find1;
                         player[b].power:=find2;
                       end
                     else if option='V' then
                       begin
                         player[b].gold:=player[b].gold-cost[round(buy)];
                         player[b].vehicle:=buy;
                         ct(5,'Ye have bought a '+sname[round(buy)]); nl;
                       end
                     else printm(2,'W or V, nothing else will be acknowledged!');
                   end;
                end;
            end
          else if option='S' then
            begin
              repeat
              cp(3,'Sell your (W)eapon or (V)ehicle?');
              input(option,1);
              checkhangup;
              until (hangup) or (option='W') or (option='V') or (option='') or (option='Q');
              if hangup then leave;
                if option='W' then
                  begin
                    y:=(round(player[b].weapon));
                    x:=player[b].charisma;
                    x:=x*cost[y];
                    x:=((1/20)*x);
                    str(x:7:0,temp);
                    repeat
                    cp(5,'I can give ye '+temp+' OK?');
                    input(option,1);
                    checkhangup;
                    until (hangup) or (option<>'D');
                    if hangup then leave;
                    if option='Y' then
                      begin
                        player[b].weapon:=1;
                        player[b].gold:=player[b].gold+x;

                      end;
                   end
                 else if option='V' then
                   begin
                     x:=((1/20)*(player[b].charisma)*(cost[round(player[b].vehicle)]));
                     str(x:7:0,temp);
                     repeat
                     cp(4,'I can give ye '+temp+' OK?');
                     input(option,1);
                     until (hangup) or (option<>'D');
                     if option='Y' then
                       begin
                         player[b].vehicle:=1;
                         player[b].gold:=player[b].gold+x;
                       end;
                    end;
            end;
       end;
end;

procedure pick25(var bet : real);
var multi,pick,number:integer;
    n:string[2];
begin
  number:=random(25)+1;
  str(number,temp);
  if thisuser.sl>=100 then printm(4,temp);
  multi:=random(100)+1;
  str(multi,temp);
  ct(7,'Payoff at '+temp+' to 1'); nl;
  repeat
    {$I-}
    cp(4,' **** PICK 25 ****'); nl;
    cp(2,'what number do ye wish to bet on, (1-25): ?  ');
    input(n,2);
    pick:=value(n);
    {$I+}
    if pick=0 then exit;
  until pick in [1..25];
     str(number,temp);
  if number=pick then bet:=bet*multi else bet:=0;
  if bet<>0 then printm(5,'Ye got the number!') else printm(8,'ye lose!');
  if bet = 0 then printm(2,'The number was : '+temp);
  player[b].gold:=player[b].gold+bet;
end;


procedure treyslot(var bet:real);
var slot:array[1..3] of integer;
    display:str;

  procedure win(var bet:real; multi:real);
  begin
    ct(8,'Ye Win!');
    bet:=bet*multi;
  end;

  procedure show(var  n:integer);
  begin
    case n of
         1:prtc(4,'   7    ');
         2:prtc(1,'  Bar   ');
         3:prtc(7,'  Plum  ');
         4:prtc(2,'  Lemon ');
         5:prtc(4,' Cherry ');
    end;
    prtc(5,'|');
  end;

begin
  prtc(5,'                         |        |        |        |');
  prtc(0,#13);
  slot[1]:=random(5)+1;
  prtc(5,'                         |'); show(slot[1]);
  delay(1000); prtc(5,'        |        |'); prtc(0,#13);
  prtc(5,'                         |'); show(slot[1]);
  slot[2]:=random(5)+1;
  show(slot[2]);
  delay(1000); prtc(5,'        |'); prtc(0,#13);
  slot[3]:=random(5)+1;
  prtc(5,'                         |'); show(slot[1]); show(slot[2]); show(slot[3]); nl;
  nl;


  if ((slot[1]=1) and (slot[2]=1) and (slot[3]=1)) then win(bet,100000.0) else
  if ((slot[1]=2) and (slot[2]=2) and (slot[3]=2)) then win(bet,12500) else
  if ((slot[1]=3) and (slot[2]=3) and (slot[3]=3)) then win(bet,1000) else
  if ((slot[1]=3) and (slot[2]=3)) then win(bet,500) else
  if ((slot[1]=4) and (slot[2]=4) and (slot[3]=4)) then win(bet,250) else
  if ((slot[1]=4) and (slot[2]=4)) then win(bet,100) else
  if ((slot[1]=5) and (slot[2]=5) and (slot[3]=5)) then win(bet,25) else
  if ((slot[1]=5) and (slot[2]=5)) then win(bet,2) else
  begin
    ct(4,'Ye Lose ...!');
    bet:=0;
  end;
  player[b].gold:=player[b].gold+bet;
end;



procedure error;
  begin
    quickexit;
  end;

procedure listplayers;
  begin
    ct(2,'This is a list of the battles that have occured today:');
    readla;
    for a:=1 to number do
     begin
      checkhangup;
      if hangup then leave;
      printm(3,result[a]); nl;
     end;
  end;

procedure casino;
  var
    hack,luck,spin : real;
    tempty : string[12];
    o : real;
    gam : integer;
    opt : char;

  begin
    repeat;
    cls;
    nl;
    ct(7,'(B)ones');
    ct(5,'(P)ick a number');
    ct(4,'(S)lots'); nl;
    cp(2,'Which would ye like?');
    onek(opt,'PBS');
    repeat
    ct(7,'Good Luck!'); nl;
    repeat
    if gamble>9 then
      begin
        ct(4,'Ye have used up your 10 Bets, Ohhhhh too bad !!');
        exit;
      end;
    str(player[b].gold:1:0,temp);
    ct(3,'Ye have '+temp+' Gold Pieces.');
    gam:=10-gamble;
    str(gam,temp);
    ct(5,'Ye have '+temp+' Bets left.');
    ct(4,'House Limit: 25000 '); nl;
    cp(3,'How much ye gonna bet?');
    {$I-}
    input(temp,5);
    cls;
    hack:=value(temp);
    {$I+}
    if hack>25000 then
      begin
        ct(8,'Ye mean the max of 25000!!!');
        hack:=25000;
      end;
    if hack>player[b].gold then
      begin
        ct(4,'Ye don''t have that much!');
        ct(5,'Ye are betting all ye have?');
        hack:=player[b].gold;
      end;
    if hack<0 then
      begin
       hack:=0;
      end;
    if hack=0 then exit;
    j:=ioresult;
    checkhangup;
    until (j=0) or (hangup);
    if hangup then leave;
    gamble:=gamble+1;
    player[b].gold:=player[b].gold-hack;
    case opt of
         'P':pick25(hack);
         'B':craps(hack);
         'S':treyslot(hack);
    end;

    checkhangup;
    until (hack=0) or (hangup);
    if hangup then leave;
    cp(7,'Would ye like to play again ? (Y/N)');
    until (not yn);
    checkhangup;
    if hangup then leave;
  end;



procedure magician;
begin
  if player[b].gold<((player[b].plus+1)*(player[b].plus+1))*1000
    then begin ct(7,'Ye do not have enough gold'); exit; end;
  player[b].plus:=player[b].plus+1;
  player[b].gold:=player[b].gold-((player[b].plus*player[b].plus)*1000);
  ct(3,'Ye weapon has been Magically altered');
end;



procedure fountain;

    function droll(D:integer):integer;
    begin
      droll:=random(D)+1;
    end;

    procedure show(st:str; var numb:real);
    var as:str;
    begin
      if droll(2)=1
        then begin
          numb:=numb+1;
          if numb>25.0 then numb:=25.0;
          as:='added';
          end
        else begin
          numb:=numb-1;
          if numb<3.0 then numb:=3.0;
          as:='subtracted';
          end;
      ct(droll(2),'Ye had a strange experience there.');
      ct(droll(5),'your '+st+' was '+as+' by one');
    end;

begin
  if ftn then begin ct(2,'Ye can only visit the fountain once per venture'); exit; end;
  repeat
    cp(droll(5),'Do ye really wish to enter?');
    input(option,1);
    checkhangup;
  until hangup or (option<>'');
  if hangup then leave;
  if option='N' then exit;

  case droll(6) of
       1:show('strength',player[a].strength);
       2:show('intelligence',player[a].intelligence);
       3:show('luck',player[a].luck);
       4:show('charisma',player[a].charisma);
       5:show('constitution',player[a].constitution);
       6:show('dexterity',player[a].dexterity);
  end;
  ftn:=true;
end;




begin
  errorptr:=ofs(error);
  hangup:=false;
  gamble:=0;
  allied:=false;
  ftn:=false;
  iport;
  cls;
  vary:=supplant;
  dog:=0;
  doga:=false;
  for a:=1 to 74 do
    player[a].damage:=0;
  play:=true;
  trips:=0;
  verbose:=true;
  found:=false;
  verify:=0;
  printfile('convert.arn');nl;nl;
  cp(5,'Do you want verbose messages?');
  if (not yn) then verbose:=false; cls;
  checkhangup;
  if hangup then leave;
  name:=thisuser.name;
  ct(7,'Welcome '+name+'!');
  ct(2,'Ye are embarking on a great adventure');
  ct(2,'Be prepared to do great battle !!'); nl;
  cp(4,'(--Hit return to proceed!--)');
  input(option,1);
  cls; cp(5,'Would Ye Please Wait, Emperor at Work !!');
      assign(infile,'characte.arn');
      reset(infile);
      readln(infile,number);
      number_of_players:=number;
      a:=1;
      b:=1;
      repeat
        with player[a] do
          begin
          readln(infile,name);
          readln(infile,status);
          if status=1 then readln(infile,killer);
          read(infile,strength,intelligence,luck,dexterity,constitution,charisma,experience,r,shield,weapon,vehicle,gold);
          read(infile,flights,bank,plus); readln(infile);
          a:=a+b;
          end;
          until (a>number_of_players);
       close(infile);
       for a:=1 to number_of_players do
         if player[a].name=name then
           begin
             found:=true;
             b:=a;
           end;
       if (not found) then create(true);
        checkday;
        if (player[b].flights<1) and (thisuser.sl<255) then
          begin
            nl;
            ct(4,'Ye can not do battle anymore today. Call back tomorrow!');
            quickexit;
          end;
        player[b].flights:=player[b].flights-1;
       assign(infile,'weapons.arn');
       reset(infile);
         for a:=1 to 25 do
          begin
           readln(infile,wname[a]);
           readln(infile,w2[a],w3[a]);
          end;
       close(infile);
       assign(infile,'vehicle.arn');
       reset(infile);
         for a:=1 to 25 do
           readln(infile,sname[a]);
       nl;
       close(infile);
         assign(infile,'prices.arn');
         reset(infile);
           for a:=1 to 25 do
             readln(infile,cost[a]);
         close(infile);
         player[b].attack:=find1;
         player[b].power:=find2;
       nl;
         assign(infile,'experience.arn');
         reset(infile);
           for a:=1 to 28 do
             readln(infile,required[a]);
         close(infile);

        assign(infile,'message.arn');
        reset(infile);
          repeat
            begin
              readln(infile,mess[a]);
              printm(4,mess[a]);
            end;
          until (eof(infile));
        close(infile);
        nl;
      ansic(4); if player[b].status=1 then printm(2,'You were slain by '+player[b].killer+'!');
        player[b].status:=0;
        nl;
        vary2:=1;
        cp(5,'(--Hit enter to continue--)');
        repeat
        input(option,1);
        checkhangup;
        until (hangup) or (option='');
        if hangup then leave;
        levelupdate; { remove brackets from levelupdate if wanted}

        play:=true;
start:    repeat
           vary2:=1;
           if verbose then
          begin
            printfile('menu.arn');
          end;
           if thisuser.sl=255 then vary:=1.9;
           cp(7,'What Option ( ? for Options ) :');
           onek(opty,'QARWLJDVFGPSXCM+-?');
           if opty='' then goto start;
             case opty of
                  'Q':play:=false;
                  'A':universe;
                  'R':begin nl;heal; nl;nl;end;
                  'W':begin nl;weaponshop; nl;nl;end;
                  'L':begin nl;levelupdate;nl;nl;end;
                  'J':begin nl;doggie;nl;nl;end;
                  'D':begin nl;Docs;nl;nl;end;
                  'V':verbose:=not verbose;
                  'F':begin nl;fountain;nl;nl;end;
                  'G':begin nl;casino;nl;nl;end;
                  'P':begin nl;playerlist;nl;nl;end;
                  'S':begin nl;listplayers;nl;nl;end;
                  'X':create(false);
                  'C':begin nl;statussheet;nl;nl;end;
                  'M':begin nl;magician;nl;nl;end;
                  '+':begin nl;depobank;nl;nl;end;
                  '-':begin nl;withdrawbank;nl;nl;end;
                  '?':if not verbose then begin nl;printfile('menu.arn');nl;end;
             else printfile('menu.arn');
             end;

             checkhangup;
          until (play=false) or (hangup);
        leave;

end.

