//---------------------------------------------------------------------------
#include <vcl\vcl.h>
#pragma hdrstop

// YOU MUST INCLUDE THE HEADER FOR UNIT1
#include "Unit1.h"
#include "Unit2.h"

extern HANDLE hComm;
char InBuff[100];

//---------------------------------------------------------------------------
//   Important: Methods and properties of objects in VCL can only be
//   used in a method called using Synchronize, for example:
//
//      Synchronize(UpdateCaption);
//
//   where UpdateCaption could look like:
//
//      void __fastcall TRead::UpdateCaption()
//      {
//        Form1->Caption = "Updated in a thread";
//      }
//---------------------------------------------------------------------------
__fastcall TRead::TRead(bool CreateSuspended)
	: TThread(CreateSuspended)
{
}
//---------------------------------------------------------------------------
void __fastcall TRead::DisplayIt(void)
{
  Form1->Memo1->SetSelTextBuf(InBuff);
}
//---------------------------------------------------------------------------
void __fastcall TRead::Execute()
{
	//---- Place thread code here ----

  DWORD dwBytesRead;

  // MAKE THE THREAD OBJECT AUTOMATICALLY DESTROYED WHEN THE THREAD
  // TERMINATES.

  FreeOnTerminate = true;

  while(1)
  {

    // SEE IF THERE ARE ANY CHARACTERS IN THE INTERNAL RECEIVE BUFFER.
    // IF THERE ARE, READ THEM. OTHERWISE, WAIT FOR CHARACTERS
    // TO ARRIVE OR LEAVE IF THE THREAD IS TERMINATED.

    if(Terminated) return;

	  ReadFile(hComm, InBuff, 50, &dwBytesRead, NULL);
    if(dwBytesRead)
    {
      InBuff[dwBytesRead] = 0; // NULL TERMINATE THE STRING
      Synchronize(DisplayIt);
    }

  }

}
//---------------------------------------------------------------------------
