//---------------------------------------------------------------------------
#include <vcl\vcl.h>
#pragma hdrstop

#include "Unit1.h"

// YOU MUST INCLUDE THE HEADER FOR UNIT2 (THE THREAD UNIT)
#include "Unit2.h"

// GLOBAL VARIABLES
HANDLE hComm = NULL;
TRead *ReadThread;
COMMTIMEOUTS ctmoNew = {0}, ctmoOld;


//---------------------------------------------------------------------------
#pragma resource "*.dfm"
TForm1 *Form1;
//---------------------------------------------------------------------------
__fastcall TForm1::TForm1(TComponent* Owner)
	: TForm(Owner)
{
}
//---------------------------------------------------------------------------
void __fastcall TForm1::FormClose(TObject *Sender, TCloseAction &Action)
{
  // TERMINATE THE THREAD.
  ReadThread->Terminate(); // TERMINATE THE THREAD

  // IF A PORT WAS OPENED, CLOSE IT
	if(hComm) {
    Sleep(250); // WAIT FOR THREAD TO FINISH
    SetCommTimeouts(hComm, &ctmoOld);
	  CloseHandle(hComm);
  }
}
//---------------------------------------------------------------------------
void __fastcall TForm1::Memo1KeyPress(TObject *Sender, char &Key)
{
 // TRANSMITS ANYTHING TYPED INTO THE MEMO AREA.

  TransmitCommChar(hComm, Key);

  // THIS PREVENTS TYPED TEXT FROM DISPLAYING GARBAGE ON THE SCREEN.
  // IF YOU ARE CONNECTED TO A DEVICE THAT ECHOES CHARACTERS, SET
  // Key = 0 WITHOUT THE OTHER STUFF.

  if(Key != 13 && (Key < ' ' || Key > 'z')) Key = 0;
}
//---------------------------------------------------------------------------
void __fastcall TForm1::FormCreate(TObject *Sender)
{
 DCB dcbCommPort;

  // OPEN THE COMM PORT.

  hComm = CreateFile("COM2",
                      GENERIC_READ | GENERIC_WRITE,
                      0,
                      0,
                      OPEN_EXISTING,
                      0,
                      0);

  // IF THE PORT CANNOT BE OPENED, BAIL OUT.

  if(hComm == INVALID_HANDLE_VALUE) Application->Terminate();

  // SET THE COMM TIMEOUTS.

  GetCommTimeouts(hComm,&ctmoOld);
 	ctmoNew.ReadTotalTimeoutConstant = 100;
  ctmoNew.ReadTotalTimeoutMultiplier = 0;
  ctmoNew.WriteTotalTimeoutMultiplier = 0;
  ctmoNew.WriteTotalTimeoutConstant = 0;  
  SetCommTimeouts(hComm, &ctmoNew);

  // SET BAUD RATE, PARITY, WORD SIZE, AND STOP BITS.
  // THERE ARE OTHER WAYS OF DOING SETTING THESE BUT THIS IS THE EASIEST.
  // IF YOU WANT TO LATER ADD CODE FOR OTHER BAUD RATES, REMEMBER
  // THAT THE ARGUMENT FOR BuildCommDCB MUST BE A POINTER TO A STRING.
  // ALSO NOTE THAT BuildCommDCB() DEFAULTS TO NO HANDSHAKING.

  dcbCommPort.DCBlength = sizeof(DCB);
  GetCommState(hComm, &dcbCommPort);
  BuildCommDCB("9600,N,8,1", &dcbCommPort);
  SetCommState(hComm, &dcbCommPort);

  // ACTIVATE THE THREAD. THE FALSE ARGUMENT SIMPLY MEANS IT HITS THE
  // GROUND RUNNING RATHER THAN SUSPENDED.

  ReadThread = new TRead(false);
}
//---------------------------------------------------------------------------