VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
END
Attribute VB_Name = "Clients"
Attribute VB_Creatable = True
Attribute VB_Exposed = True
' ==========================================
' == WINS VB Service Kit                  ==
' == Copyright 1997, Mustang Software Inc ==
' ==========================================
' == Clients.cls                          ==
' == Bob Dalton bob.dalton@mustang.com    ==
' == 03/19/97                             ==
' ==========================================
' == For MS Visual Basic v4.0 and         ==
' == MSI's WCDRM32.DLL                    ==
' == Class Implementation                 ==
' ==========================================

Option Explicit

Private Type TClientData
    Dead As Boolean
    Status As Long
    Handle As Long
    SendReady As Boolean
    CloseWhenSent As Boolean
    Timeout As Date
    Created As Date
    SendData As String
    ReceiveData As String
    flags(1 To 20) As Long
    MiscData(1 To 20) As String
    Timeouts(1 To 20) As Date
End Type

Const RecvBufferSize = 1024

Dim RawMode As Boolean

Dim ListeningSocket As Long
Dim hWndHook As Long

Dim Clients() As TClientData

Private Sub Class_Initialize()
    
    On Error GoTo ErrHandler
       
    ReDim Preserve Clients(1)
    
    Clients(1).Dead = True

    RawMode = False
    ListeningSocket = INVALID_SOCKET
    hWndHook = -1

ErrHandler:

End Sub

Private Sub Class_Terminate()

    On Error GoTo ErrHandler
        
    Dim i As Long
    
    For i = 1 To UBound(Clients())
        If Not Clients(i).Dead Then
            closesocket Clients(i).Handle
            Clients(i).Dead = True
        End If
    Next
    
    If ListeningSocket <> INVALID_SOCKET Then
        closesocket ListeningSocket
    End If

    WildcatServerDeleteContext
    WSACleanup

ErrHandler:

End Sub

Private Function Find(ByVal Socket As Long) As Long
    
    Find = -1
    
    On Error GoTo ErrHandler
    
    Dim i As Long
    
    For i = 1 To UBound(Clients())
        If (Clients(i).Handle = Socket) And _
           (Not Clients(i).Dead) Then
            Find = i
            Exit Function
        End If
    Next
    
ErrHandler:
    
End Function

Private Sub ReadBufferedData(ByVal ClientHandle As Long)
    
    On Error GoTo ErrHandler
    
    Dim BytesRead As Long
    Dim TempBuffer As String
    
    TempBuffer = Space$(RecvBufferSize)
    
    Do
    
        BytesRead = recv(Clients(ClientHandle).Handle, TempBuffer, RecvBufferSize, 0)
    
        If (BytesRead > 0) Then
            Clients(ClientHandle).ReceiveData = _
                Clients(ClientHandle).ReceiveData + Mid(TempBuffer, 1, BytesRead)
        Else
            Exit Do
        End If
    
    Loop
    
    Exit Sub
    
ErrHandler:

End Sub

Private Sub SendBufferedData(ByVal ClientHandle As Long)

    On Error GoTo ErrHandler
    
    If Not Clients(ClientHandle).SendReady Then Exit Sub
    
    Dim BytesSent As Long
    
    Do
    
        If Len(Clients(ClientHandle).SendData) <= 0 Then
            Clients(ClientHandle).SendReady = True
            
            If Clients(ClientHandle).CloseWhenSent Then
                Clients(ClientHandle).Dead = True
                closesocket Clients(ClientHandle).Handle
            End If
            
            Exit Do
        End If
    
        BytesSent = send(Clients(ClientHandle).Handle, _
                         Clients(ClientHandle).SendData, _
                         Len(Clients(ClientHandle).SendData), _
                         0)
    
        If BytesSent > 0 Then
            Clients(ClientHandle).SendData = Mid(Clients(ClientHandle).SendData, BytesSent + 1)
        Else
            Clients(ClientHandle).SendReady = False
            Exit Do
        End If
        
    Loop
    Exit Sub

ErrHandler:

End Sub

Private Sub ResetTimeout(ByVal ClientHandle As Long)

    On Error GoTo ErrHandler
    
    Clients(ClientHandle).Timeout = DateAdd("s", Clients_Timeout, Now)
    
ErrHandler:

End Sub

Private Function CheckTimeout(ByVal ClientHandle As Long, Mask As Long) As Boolean
    
    CheckTimeout = False
    Mask = 0
    
    On Error GoTo ErrHandler
        
    If (Now > Clients(ClientHandle).Timeout) Then
        CheckTimeout = True
        Mask = Mask Or 1
    End If
        
    Dim i As Long
    For i = 1 To UBound(Clients(ClientHandle).Timeouts())
        If Now > Clients(ClientHandle).Timeouts(i) Then
            Mask = Mask Or (2 ^ (i + 1))
            CheckTimeout = True
        End If
    Next
    
    Exit Function
    
ErrHandler:

End Function

Public Function StartupService(ByVal SName As String, ByVal SVendor As String, ByVal SVersion As Long, ByVal hWnd As Long) As Long
    
    Dim Socket As Integer
        
    StartupService = -1
    
    On Error GoTo ErrHandler
        
    Socket = DrmStartupService(hWnd, SName, SVendor, SVersion, WM_INCOMING)
            
    If Socket <> -1 Then
        
        Dim tmpService As TWildcatService
        Dim b As Boolean
        b = GetServiceByName(SName, tmpService)
        
        'closesocket Socket
        '    Exit Function
        'End If
        
        ListeningSocket = Socket
        StartupService = tmpService.Port
        hWndHook = hWnd
    End If
    Exit Function
    
ErrHandler:

End Function

Public Function Add(ByVal Socket As Long) As Long

    Dim i As Long
    Dim j As Long
    
    Add = 0
    
    On Error GoTo ErrorHandler
    
    Debug.Print "Add: " + Trim(Str(Socket))
    
    j = -1

    For i = 1 To UBound(Clients())
        If Clients(i).Dead Then
            j = i
            Exit For
        End If
    Next
    
    If j = -1 Then
        j = UBound(Clients()) + 1
        ReDim Preserve Clients(j)
    End If
    
    With Clients(j)
        .Dead = False
        .Status = 0
        .Handle = Socket
        .SendReady = False
        .CloseWhenSent = False
        .Timeout = DateAdd("s", Clients_Timeout, Now)
        .Created = Now
        .SendData = ""
        .ReceiveData = ""
    End With

    Add = j
    Exit Function

ErrorHandler:
    closesocket Socket

End Function

Public Function ProcessIncoming(ByVal wp As Long, ByVal lp As Long, ClientHandle As Long) As Long

    ProcessIncoming = 0
    
    On Error GoTo ErrHandler

    If (wp = ListeningSocket) And (lp And FD_ACCEPT <> 0) Then
    
        Dim Socket As Long
        
        ' Acknowledge incoming connection
        Socket = DrmAcceptConnection(ListeningSocket, hWndHook, WM_CLIENT)
        
        ' Pass new socket to Clients object
        ClientHandle = Add(Socket)
    
        ProcessIncoming = Clients_NewClient
    
    End If

ErrHandler:

End Function

Public Sub CloseClient(ByVal ClientHandle As Long)
    
    On Error GoTo ErrHandler
        
    Clients(ClientHandle).Dead = True
    
    closesocket Clients(ClientHandle).Handle
    
    Exit Sub
    
ErrHandler:

End Sub

Public Function ProcessMessage(ByVal wp As Long, ByVal lp As Long, ClientHandle As Long) As Long
    
    ProcessMessage = 0
    
    Dim Result As Long
    
    Result = 0
    
    ClientHandle = Find(wp)
    
    If (ClientHandle < 1) Or (ClientHandle > UBound(Clients())) Then Exit Function

    If (lp And FD_READ) Then
        ResetTimeout ClientHandle
        ReadBufferedData ClientHandle
        Result = Result Or Clients_DataRead
    End If
        
    If (lp And FD_CLOSE) Then
        Result = Result Or Clients_Closed
        GoTo ExitFunction
    End If
    
    If (lp And FD_WRITE) Then
        ResetTimeout ClientHandle
        Clients(ClientHandle).SendReady = True
        SendBufferedData ClientHandle
        Result = Result Or Clients_DataSent
        If Clients(ClientHandle).Dead Then
            Result = Result Or Clients_Closed
        End If
    End If

ExitFunction:

    ProcessMessage = Result

End Function

Public Property Get DataReady(ByVal ClientHandle As Long) As Boolean

    DataReady = False
    
    On Error GoTo ErrHandler
    
    If Len(Clients(ClientHandle).ReceiveData) > 0 Then
    
        If RawMode = True Then
            DataReady = True
            Exit Property
        End If
    
        Dim i As Long
        
        If InStr(Clients(ClientHandle).ReceiveData, Chr$(13)) > 0 Then
            DataReady = True
        ElseIf InStr(Clients(ClientHandle).ReceiveData, Chr$(10)) > 0 Then
            DataReady = True
        End If
    
    End If
    
    Exit Property
    
ErrHandler:

End Property

Public Property Get ReadData(ByVal ClientHandle As Long) As String
    
    ReadData = ""
    
    On Error GoTo ErrHandler

    ' If using Raw mode, skip CRLF parsing
    
    If RawMode Then
        ReadData = Clients(ClientHandle).ReceiveData
        Clients(ClientHandle).ReceiveData = ""
        Exit Property
    End If

    ' === CRLF parsing ===

    ' Find end of first string

    Dim cr As Long
    Dim lf As Long
    Dim endstr As Long
       
    cr = InStr(Clients(ClientHandle).ReceiveData, Chr$(13))
    lf = InStr(Clients(ClientHandle).ReceiveData, Chr$(10))

    If lf < cr Then
        endstr = lf
    Else
        endstr = cr
    End If
    
    ' Extract String
    
    Dim TempStr As String
    
    TempStr = Mid(Clients(ClientHandle).ReceiveData, 1, endstr - 1)
    
    ' Find beginning of next string
    
    Dim i As Long
    For i = endstr + 1 To Len(Clients(ClientHandle).ReceiveData)
        Select Case Mid(Clients(ClientHandle).ReceiveData, i, 1)
            Case Chr$(13)
            Case Chr$(10)
            Case Else
                Exit For
        End Select
    Next
    
    ' Reset buffer to start at next string
    
    Clients(ClientHandle).ReceiveData = _
        Mid(Clients(ClientHandle).ReceiveData, i)
    
    ' Return the string we extracted
    
    ReadData = TempStr
    
    Exit Property

ErrHandler:

End Property

Public Sub CloseWhenDoneSending(ByVal ClientHandle As Long)
    
    On Error GoTo ErrHandler

    Clients(ClientHandle).CloseWhenSent = True

ErrHandler:

End Sub

Public Function SendData(ByVal ClientHandle As Long, ByVal Str As String) As Boolean

    SendData = True
    
    On Error GoTo ErrHandler
        
    If Not RawMode Then
        Clients(ClientHandle).SendData = _
            Clients(ClientHandle).SendData + _
            Str + Chr$(13) + Chr$(10)
    Else
        Clients(ClientHandle).SendData = _
            Clients(ClientHandle).SendData + Str
    End If
    
    If Clients(ClientHandle).SendReady Then
        ResetTimeout ClientHandle
        SendBufferedData ClientHandle
    End If
    
    Exit Function
    
ErrHandler:
    
    SendData = False

End Function

Public Function CheckTimeouts(ByVal Start As Long, Mask As Long) As Long

    CheckTimeouts = 0
    
    On Error GoTo ErrHandler
    
    If Start < 1 Then Start = 0

    Dim i As Long
    
    For i = (Start + 1) To UBound(Clients())
        If Not Clients(i).Dead Then
            If CheckTimeout(i, Mask) Then
                CheckTimeouts = i
                Exit Function
            End If
        End If
    Next
    Exit Function
    
ErrHandler:
    
End Function

Public Sub SetStatus(ByVal ClientHandle As Long, ByVal nStatus As Long)

    On Error GoTo ErrHandler
    
    Clients(ClientHandle).Status = nStatus
    Exit Sub
    
ErrHandler:

End Sub

Public Sub SetFlag(ByVal ClientHandle As Long, ByVal FlagIndex As Long, ByVal nFlag As Long)

    On Error GoTo ErrHandler
    
    Clients(ClientHandle).flags(FlagIndex) = nFlag
    Exit Sub
    
ErrHandler:

End Sub

Public Sub SetTimeout(ByVal ClientHandle As Long, ByVal TOIndex As Long, ByVal nTime As Long)

    On Error GoTo ErrHandler
    
    Clients(ClientHandle).Timeouts(TOIndex) = DateAdd("s", Now, nTime)
    Exit Sub
    
ErrHandler:

End Sub

Public Sub SetMiscData(ByVal ClientHandle As Long, ByVal DataIndex As Long, ByVal data As String)

    On Error GoTo ErrHandler
    
    Clients(ClientHandle).MiscData(DataIndex) = data
    Exit Sub
    
ErrHandler:

End Sub

Public Property Get Status(ByVal ClientHandle As Long) As Long

    Status = -1
    
    On Error GoTo ErrHandler
    
    Status = Clients(ClientHandle).Status
    Exit Property
    
ErrHandler:

End Property

Public Property Get flags(ByVal ClientHandle As Long, ByVal FlagIndex As Long) As Long

    flags = -1
    
    On Error GoTo ErrHandler
    
    flags = Clients(ClientHandle).flags(FlagIndex)
    Exit Property

ErrHandler:

End Property

Public Property Get MiscData(ByVal ClientHandle As Long, ByVal DataIndex As Long) As String

    MiscData = ""
    
    On Error GoTo ErrHandler
    
    MiscData = Clients(ClientHandle).MiscData(DataIndex)
    Exit Property
    
ErrHandler:

End Property

Public Property Get SocketHandle(ByVal ClientHandle As Long) As Long

    SocketHandle = INVALID_SOCKET
    
    On Error GoTo ErrHandler
    
    SocketHandle = Clients(ClientHandle).Handle
    
ErrHandler:

End Property

Public Property Get ClientCreate(ByVal ClientHandle As Long) As Date

    ClientCreate = 0

    On Error GoTo ErrHandler
    
    ClientCreate = Clients(ClientHandle).Created
    
    Exit Property

ErrHandler:

End Property

Public Property Get ClientCount() As Long

    ClientCount = -1
    
    On Error GoTo ErrHandler

    Dim i As Long
    Dim r As Long
    
    r = 0
    For i = 1 To UBound(Clients())
        If Not Clients(i).Dead Then r = r + 1
    Next
    ClientCount = r
    
ErrHandler:

End Property

Public Property Get IterateClients(ByVal Start As Long) As Long

    IterateClients = -1

    On Error GoTo ErrHandler

    If Start < 1 Then Start = 0

    Dim i As Long
    
    For i = (Start + 1) To UBound(Clients())
        If Not Clients(i).Dead Then
            IterateClients = i
            Exit Property
        End If
    Next
    Exit Property
    
ErrHandler:

End Property

' End of File
