VERSION 4.00
Begin VB.Form frmMain 
   Caption         =   "WINS Service Kit for VB Test Service"
   ClientHeight    =   3945
   ClientLeft      =   1515
   ClientTop       =   1470
   ClientWidth     =   7920
   Height          =   4350
   Icon            =   "frmMain.frx":0000
   Left            =   1455
   LinkTopic       =   "Form1"
   ScaleHeight     =   3945
   ScaleWidth      =   7920
   Top             =   1125
   Width           =   8040
   Begin VB.Timer Timer1 
      Interval        =   1000
      Left            =   0
      Top             =   480
   End
   Begin VB.ListBox lstUsers 
      Columns         =   1
      Height          =   3375
      Left            =   5400
      TabIndex        =   1
      Top             =   120
      Width           =   2415
   End
   Begin VB.TextBox txtConsole 
      Height          =   3375
      Left            =   120
      Locked          =   -1  'True
      MultiLine       =   -1  'True
      ScrollBars      =   2  'Vertical
      TabIndex        =   0
      Top             =   120
      Width           =   5175
   End
   Begin ComctlLib.StatusBar StatusBar1 
      Align           =   2  'Align Bottom
      Height          =   345
      Left            =   0
      TabIndex        =   2
      Top             =   3600
      Width           =   7920
      _Version        =   65536
      _ExtentX        =   13970
      _ExtentY        =   609
      _StockProps     =   68
      AlignSet        =   -1  'True
      SimpleText      =   ""
      _timers         =   2
      NumPanels       =   8
      i1              =   "frmMain.frx":0442
      i2              =   "frmMain.frx":054E
      i3              =   "frmMain.frx":068B
      i4              =   "frmMain.frx":07FA
      i5              =   "frmMain.frx":0965
      i6              =   "frmMain.frx":0AB0
      i7              =   "frmMain.frx":0C1F
      i8              =   "frmMain.frx":0D6E
   End
   Begin MsghookLib.Msghook Msghook1 
      Left            =   0
      Top             =   0
      _Version        =   65536
      _ExtentX        =   847
      _ExtentY        =   847
      _StockProps     =   0
   End
End
Attribute VB_Name = "frmMain"
Attribute VB_Creatable = False
Attribute VB_Exposed = False
Option Explicit

' Some vital variables
Dim FirstActivation As Boolean

' The cool VB Service object
Dim MyClients As New WCRDR32.Clients

' Text for the status bar
Dim MyStatus As String

' Constants for Client Info
Const Flags_LoggedIn = 1
Const Flags_Context = 2

' Service Name constants
Const Service_Name As String = "WCRDR32 Test"
Const Service_Vendor As String = "Rider Enterprises"
Const Service_Version As Long = 1

' Form_Activate
' ~~~~~~~~~~~~~
' This routine contains the initialization code
' for the service.  The reason it is here, and
' not in Form_Load() is so we can display info
' to the console window in real time.

Private Sub Form_Activate()
    
    Refresh
    
    If FirstActivation Then
                        
        ' Only run this code once, the first time
        ' this window is made active (ie: startup)
                        
        AddText txtConsole, "Starting service..."
    
        Dim Port As Long
        
        Port = MyClients.StartupService(Service_Name, Service_Vendor, Service_Version, Msghook1.HwndHook)
        If Port >= 0 Then
            AddText txtConsole, "Listening on port " + Trim(Str(Port))
            MyStatus = "Listening on port " + Trim(Str(Port))
        Else
            AddText txtConsole, "Could not start service!"
        End If
        
    End If
    
    FirstActivation = False

End Sub

' Form_Load
' ~~~~~~~~~~~~~
' Initialize our vital variables, etc.

Private Sub Form_Load()

    ' Initialize some variables
    FirstActivation = True
        
    ' Set up some stuff for the status bar
    MyStatus = "Initializing..."
    StatusBar1.Panels(1).text = MyStatus
                
    ' Get the Mabry Msghook control set up
    Msghook1.HwndHook = hWnd
    Msghook1.Message(WM_INCOMING) = True
    Msghook1.Message(WM_CLIENT) = True
                                
End Sub

' ClientIdledOut
' ~~~~~~~~~~~~~~
' This routine is called when a client is idle
' too long.
'
' This should typically only be called by the
' timer routine.

Sub ClientIdledOut(ByVal ClientHandle As Long)
    
    AddText txtConsole, "Client (" + Trim(Str(ClientHandle)) + ") idled out!"
    
    ClientClosed ClientHandle
    MyClients.CloseClient ClientHandle

End Sub

' ClientWelcome
' ~~~~~~~~~~~~~
' This routine is called when a client first
' logs in.
'
' This should typically only be called when
' Clients.Add is called.

Sub ClientWelcome(ByVal ClientHandle As Long)
        
    AddText txtConsole, "New client (" + Trim(Str(ClientHandle)) + ")"

    lstUsers.AddItem "Unknown (" + Trim(Str(ClientHandle)) + ")"
    lstUsers.ItemData(lstUsers.NewIndex) = ClientHandle
    
    MyClients.SetFlag ClientHandle, Flags_LoggedIn, 0
    
    MyClients.SendData ClientHandle, "Welcome!"

End Sub

' ClientClosed
' ~~~~~~~~~~~~
' This routine is called when a client is closed.
'
' This should be freely called by the developer
' whenever they choose to close a client.  This
' routine does not close the client, but performs
' universal clean-up after a client is closed.

Sub ClientClosed(ByVal ClientHandle As Long)
            
    AddText txtConsole, "Client (" + Trim(Str(ClientHandle)) + ") closed"

    Dim i As Long
    For i = 0 To lstUsers.ListCount - 1
        If lstUsers.ItemData(i) = ClientHandle Then
            lstUsers.RemoveItem i
            Exit For
        End If
    Next

End Sub

' ClientHandler
' ~~~~~~~~~~~~~
' This routine is called whenever a new string is
' received for a client.
'
' This should typically be called by the socket
' notification handler.

Sub ClientHandler(ByVal DataStr As String, ByVal ClientHandle As Long)
                
    Dim CmdStr As String
    Dim ParmStr As String
    Dim Seperator As Long
    
    Seperator = InStr(DataStr, ":")
    
    If Seperator > 0 Then
        CmdStr = UCase(Trim(Mid(DataStr, 1, Seperator - 1)))
        ParmStr = Mid(DataStr, Seperator + 1)
    Else
        CmdStr = UCase(Trim(DataStr))
        ParmStr = ""
    End If
                
    Select Case CmdStr
        Case "CONTEXT"
            
            Dim ContextHandle As Long
            
            Dim r As Long
            Dim tmpUser As TUser
            Dim ChalStr As String

            ContextHandle = Val(ParmStr)

            ChalStr = Space(200)

            r = DrmGetUserInfo(ContextHandle, ChalStr, 100, tmpUser)
            
            AddText txtConsole, "User Name: " + tmpUser.Info.Name
            AddText txtConsole, ""
            Debug.Print tmpUser.Info.Name
            
        Case "QUIT"
            MyClients.CloseWhenDoneSending ClientHandle
            MyClients.SendData ClientHandle, "Bye!"
            ClientClosed ClientHandle
            Exit Sub
        
        Case Else
    
            ' Echo data to all clients
    
            Dim i As Long
            Dim j As Long
    
            i = 0
            Do
                j = MyClients.IterateClients(i)
                If (j > 0) Then
                    MyClients.SendData j, "ECHO:" + DataStr
                    i = j
                Else
                    Exit Do
                End If
            Loop
    
    End Select
    
End Sub

' Message Handler
' ~~~~~~~~~~~~~~~
' This is the heart of the service.  All the socket
' notification messages come here.
'
' WM_INCOMING is used when an incoming connection
' reaches the listening socket.
' WM_CLIENT is used when send/receive/close events
' occur on the client sockets.

Private Sub Msghook1_Message(ByVal msg As Long, ByVal wp As Long, ByVal lp As Long, Result As Long)
        
    Dim ClientHandle As Long
    Dim r As Long
    
    If (msg = WM_INCOMING) Then
                
        ' == INCOMING CONNECTION ==
                
        r = MyClients.ProcessIncoming(wp, lp, ClientHandle)
        If (r And Clients_NewClient) Then
            ' Welcome our new client
            ClientWelcome ClientHandle
        End If
    
    ElseIf (msg = WM_CLIENT) Then
    
        ' == CLIENT EVENT ==
            
        ' Pass the event to the Clients object
        r = MyClients.ProcessMessage(wp, lp, ClientHandle)
        
        ' Check if data has been read
        If (r And Clients_DataRead) Then
            Dim TempStr As String
            '
            Do While MyClients.DataReady(ClientHandle)
                TempStr = MyClients.ReadData(ClientHandle)
                ClientHandler TempStr, ClientHandle
            Loop
        End If
        
        If (r And Clients_Closed) Then
            ClientClosed ClientHandle
            MyClients.CloseClient ClientHandle
        End If
        
    End If

End Sub

' Timer
' ~~~~~
' This routine is used to check the timeouts
' on all the clients, and to update the status
' bar.

Private Sub Timer1_Timer()

    ' Check idle timeouts for all clients
    
    Dim i As Long
    Dim Mask As Long
    
    i = 0
    Do
        i = MyClients.CheckTimeouts(i, Mask)
        If (i > 0) And (Mask And 1) Then
            ClientIdledOut i
        End If
    Loop While (i > 0)

    ' Update status bar
    
    Dim NewText As String
    
    NewText = MyStatus
    
    If StatusBar1.Panels(1).text <> NewText Then
        StatusBar1.Panels(1).text = NewText
    End If
    
    NewText = "Clients: " + Trim(Str(MyClients.ClientCount))
    
    If StatusBar1.Panels(2).text <> NewText Then
        StatusBar1.Panels(2).text = NewText
    End If

End Sub

' lstUsers_DblClick
' ~~~~~~~~~~~~~~~~~
' This gives the administrator a convenient way
' to remove a client.

Private Sub lstUsers_DblClick()

    If lstUsers.ListIndex < 0 Then Exit Sub
    
    If MsgBox("Remove " + lstUsers.List(lstUsers.ListIndex) + "?", vbYesNo, "Boot the user?") = vbYes Then
        MyClients.CloseClient lstUsers.ItemData(lstUsers.ListIndex)
        ClientClosed lstUsers.ItemData(lstUsers.ListIndex)
    End If

End Sub

Public Sub AddText(Text1 As TextBox, TextStr As String)

    On Error GoTo ErrHandler
    
    Text1.SelStart = Len(Text1) + 1
    Text1.SelText = TextStr + Chr$(13) + Chr$(10)
    Exit Sub
    
ErrHandler:

End Sub

