// tttoe.h : header file
//
#ifndef _tttoe_h
#define _tttoe_h

#include "common1.h"

enum { 
 /* 0 */ etNone,
 /* 1 */ etPlayerMove,
 /* 2 */ etPlayerMessage,
 /* 3 */ etMax 
};

/* make your structures a descendent of this structure! */
struct TBaseStruct {
  DWORD type; // type of structure
  DWORD size; // size of structure
};

/* Important note: total structure size MUST be divisible
   by 4 or it won't work and nothing will appear to be
   sent due to a packing error!
 */
struct TPlayerMove : public TBaseStruct {
  long MyGameNumber;
  long MyPlayerNumber;
  long PermissionToMove;
  long IsThereAWinnerYet;
  long MovePosition;
  long OMovePosition;
  char TTTServiceMessage[36];
};           

struct TPlayerMessage : public TBaseStruct {
  char message[1024];
};

/////////////////////////////////////////////////////////////////////////////
// TicTacToe dialog

class TicTacToe : public CDialog
{
// Construction
protected:
  BOOL Startup;
  BOOL Disconnect;
  SOCKET ServiceSocket;
  TWildcatService Service;
  char GlobalBuffer[8192];
  DWORD GlobalTop;
public:
	~TicTacToe();
	TicTacToe(CWnd* pParent = NULL);	// standard constructor

// Dialog Data
	//{{AFX_DATA(TicTacToe)
	enum { IDD = IDD_TICTACTOE };
	CString	m_TicTacToeMsg;
	CString	m_msgfromyou;
	CString	m_msgtoyou;
	CString	m_edit11;
	CString	m_edit12;
	CString	m_edit13;
	CString	m_edit21;
	CString	m_edit22;
	CString	m_edit23;
	CString	m_edit31;
	CString	m_edit32;
	CString	m_edit33;
	//}}AFX_DATA
protected:
  void delay();
  void SubmitPlayerData(struct TPlayerMove *pm);
  void CheckForGameOver(struct TPlayerMove *pm);
  void PostPlayerMove(struct TPlayerMove *pm);
  void ProcessServiceActions(struct TPlayerMove *MyPlayerInfo);
  void ProcessStructure(const TBaseStruct *bs);
  void HandleIncoming(void *data, int size); 
// Implementation
protected:
	// Generated message map functions
	//{{AFX_MSG(TicTacToe)
	virtual BOOL OnInitDialog();
  virtual void DoDataExchange(CDataExchange* pDX);	// DDX/DDV support	
	afx_msg LRESULT OnServiceNotify_Again(UINT wParam, long lParam);
	afx_msg void OnBtn11();
	afx_msg void OnBtn12();
	afx_msg void OnBtn13();
	afx_msg void OnBtn21();
	afx_msg void OnBtn22();
	afx_msg void OnBtn23();
	afx_msg void OnBtn31();
	afx_msg void OnBtn32();
	afx_msg void OnBtn33();
	afx_msg void OnSendmsgbtn();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

void DoTicTacToe();

#endif
