// framedoc.cpp : implementation of the CFramesdiDoc class
//
#include "common1.h"
#pragma hdrstop

#include "framesdi.h"
#include "framedoc.h"

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

#define SIZE_DATA_BUF	4096

struct TPageMessage {
  char From[28];
  char Message[3][80];
  };
  
/////////////////////////////////////////////////////////////////////////////
// CFramesdiDoc

IMPLEMENT_DYNCREATE(CFramesdiDoc, CDocument)

BEGIN_MESSAGE_MAP(CFramesdiDoc, CDocument)
	//{{AFX_MSG_MAP(CFramesdiDoc)
	ON_COMMAND(ID_WILDCAT_FILES, OnWildcatFiles)
	ON_COMMAND(ID_WILDCAT_MESSAGES, OnWildcatMessages)
	ON_COMMAND(ID_WILDCAT_PAGE, OnWildcatPage)
	ON_COMMAND(ID_WILDCAT_EXPORTADDRESSLIST, OnWildcatExportaddresslist)
	ON_COMMAND(ID_WILDCAT_ADDKEYTOREGISTRY, OnWildcatAddkeytoregistry)
	ON_COMMAND(ID_WILDCAT_SYSTEMPAGE, OnWildcatSystempage)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CFramesdiDoc construction/destruction

CFramesdiDoc::CFramesdiDoc()
{
	// TODO: add one-time construction code here
}

CFramesdiDoc::~CFramesdiDoc()
{
}

BOOL CFramesdiDoc::OnNewDocument()
{
	if (!CDocument::OnNewDocument())
		return FALSE;

	// TODO: add reinitialization code here
	// (SDI documents will reuse this document)

	return TRUE;
}

/////////////////////////////////////////////////////////////////////////////
// CFramesdiDoc serialization

void CFramesdiDoc::Serialize(CArchive& ar)
{
	if (ar.IsStoring())
	{
		// TODO: add storing code here
	}
	else
	{
		// TODO: add loading code here
	}
}

/////////////////////////////////////////////////////////////////////////////
// CFramesdiDoc diagnostics

#ifdef _DEBUG
void CFramesdiDoc::AssertValid() const
{
	CDocument::AssertValid();
}

void CFramesdiDoc::Dump(CDumpContext& dc) const
{
	CDocument::Dump(dc);
}
#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CFramesdiDoc commands

void CFramesdiDoc::OnWildcatFiles() // "F" button command on toolbar
{   
    /* What we are accomplishing here:
       a.  When the Files ("F") toolbar button (or menu item) is selected we are
            routed to this function.
       b.  If successful the file transfer client is loaded and ran.
       c.  If unsuccessful at any stage we get a warning message box and exit.
       
       NOTE:  This function requires the services of "cloadsys.h" (Wildcat System API)
    */
         
	/* Starts up the Wildcat File Transfer client
       NOTE:  The file name ("TEST.ZIP") has been hard coded into this example
              but normally you would build a dialog to ask for the name of the
              file that the user wants to download and then pass that name
              (or variable) to the WcDownloadFile function call as the first parameter
    */
	WcDownloadFile("TEST.ZIP", 0, 0, NULL, FALSE);
	
	/* Note:  See CFramesdiApp::CFramesdiApp() (ie; the Constructor)
	          and CFramesdiApp::~CFramesdiApp() (ie; the destructor)
	          for required master startup and shutdown/cleanup functions in FRAMESDI.CPP.
	*/ 
}

void CFramesdiDoc::OnWildcatMessages() // "M" button command on toolbar
{
    /* What we are accomplishing here:
       a.  When the Messages ("M") toolbar button (or menu item) is selected we are
            routed to this function.
       b.  If successful the message client is loaded and ran.
       c.  If unsucessful at any stage we get a warning message box and exit.
       
       NOTE:  This function requires the services of both "cloadsys.h" 
              (Wildcat System API) and <Memory.h>
    */    
    
  TUserInfo TMyInfo; // Defines a structure of type TUserInfo
	memset(&TMyInfo, 0, sizeof(TMyInfo));  /* zeros out the elements of the structure -
	  - From <memory.h> */	
	
	/* Starts up the Wildcat Page client */
	
	if(!WcWriteMessage(&TMyInfo, NULL, NULL)){
	 AfxMessageBox("It didn't work!", MB_ICONSTOP|MB_OK, 0);
	}
	  
    /* Note:  See CFramesdiApp::CFramesdiApp() (ie; the Constructor)
	          and CFramesdiApp::~CFramesdiApp() (ie; the destructor)
	          for required master startup and shutdown functions in FRAMESDI.CPP.
	*/	
}

void CFramesdiDoc::OnWildcatPage() // "P" button command on toolbar
{
    /* What we are accomplishing here:
       a.  When the Page ("P") toolbar button (or menu item) is selected we are
            routed to this function.
       b.  If successful the Instant message dialog from the chat client
            is loaded and ran.
       c.  If unsuccessful at any stage we get a warning message box and exit.
       
       This would be a simple and quick way to implement a chat function in a game. Just
        provide a button that launches this function or something similar
       
       NOTE:  This function requires the services of "cloadsys.h" (Wildcat System API)
    */	
	
	/* Starts up the Wildcat Page client - by using NULLS in the parameters section
	       we can pick from a Page Client provided list of those currently online
   */
		
	if(!WcWriteUserPage(NULL, NULL, NULL, 0)){
   AfxMessageBox("It didn't work!", MB_ICONSTOP|MB_OK, 0);
  }	
    /* Note:  See CFramesdiApp::CFramesdiApp() (ie; the Constructor)
	          and CFramesdiApp::~CFramesdiApp() (ie; the destructor)
	          for required master startup and shutdown/cleanup functions in FRAMESDI.CPP.
	*/	
}

void CFramesdiDoc::OnWildcatExportaddresslist() // "Ex" button command on toolbar
{
    /* What we are accomplishing here:
       a.  When the Export Address List ("Ex") toolbar button (or menu item) is
            selected we are routed to this function.
       b.  If successful we will export a Navigator Address Book List in comma
            delimited format to a file for later text file viewing purposes.
       c.  If unsuccessful at any stage we get a warning message box and exit.
       
       This is an example of how to pull information OUT of the WCCACHE.DAT file
       registry.  This is an important function for developers who want to store
       information and then be able to retrieve that information in a manner similar
       to the old Win 3.1 INI file format.
       
       NOTE:  This function requires the services of "wccache.h" (Wildcat Cache API)
              and cloadsys.h" (Wildcat System API)
    */	
	
	WCHKEY MyKey, MyKey1; // Defines variables to accept the key values
	
	// the next 6 lines define some local variables you will need
	char name[64]; // for sub-keys names 
	unsigned long bytes;
	char data[4096], Data1[SIZE_DATA_BUF]; // arrays for storing string data
	char* pszFileName = "AddrList.Txt";  // name of output file
	DWORD i = 0;
	CFile myFile;
	                                                             
  memset(name, 0, sizeof(name)); // initializes Data1 array	                                                             
	memset(&MyKey, 0, sizeof(MyKey)); // initializing it's values
	memset(&MyKey1, 0, sizeof(MyKey1)); // initializing it's values
	memset(data, 0, sizeof(data)); // initializes Data1 array
	memset(Data1, 0, sizeof(Data1)); // initializes Data1 array
	
	/* 1 - Creates file called "AddrList.Txt" and Opens for output */
	
	if(!myFile.Open(pszFileName,
	      CFile::modeCreate | CFile::modeReadWrite)) {
	  AfxMessageBox("Unable to create file", MB_ICONSTOP|MB_OK, 0);
	  return;
	  }
	  	
	/* 2 - Opens a registry key in the WcCache.dat file - stores returned key value
           in the MyKey variable you passed.  If successful, retrieves the data associated
           with the key and then closes the key.
   */     
      
   if(WcOpenKey(WCHKEY_ADDRESSBOOK_ROOT, 	"USERS", &MyKey)) {     
     while(WcEnumKey(WCHKEY_ADDRESSBOOK_USERS_ROOT, i, name, sizeof(name))) {   
           WcOpenKey(MyKey, name, &MyKey1); // opens sub-key under "USERS" key
           bytes = sizeof(data);
           if (WcQueryValue(MyKey1, "Name", data, &bytes)){ // gets data from "Name" record
            strcpy(Data1, data); // copies if to the Data1 string array
            strcat(Data1, ",");  // adds a comma "," character to the string
            bytes = sizeof(data);
           }
           if (WcQueryValue(MyKey1, "Notes", data, &bytes)){ // gets data from "Notes" record
           	strcat(Data1, data); // adds the next data string
           	strcat(Data1, ",");  // add a comma "," character to the string
           	bytes = sizeof(data);
           }
           if (WcQueryValue(MyKey1, "Phone", data, &bytes)){  // gets data from "Phone" record
            strcat(Data1, data); // adds the next data string
            strcat(Data1, ",");           
            bytes = sizeof(data);
           }
           if (WcQueryValue(MyKey1, "Title", data, &bytes)){ // gets data from "Title" record
            strcat(Data1, data); // adds the next data string
            strcat(Data1, ",");           
            bytes = sizeof(data);
           }
           if (WcQueryValue(MyKey1, "Company", data, &bytes)){ // gets data from "Company" record
            strcat(Data1, data);
            strcat(Data1, ",");           
            bytes = sizeof(data);
           }
           if (WcQueryValue(MyKey1, "AddressType", data, &bytes)){/* gets data from "AddressType"
                                                                 record */
           strcat(Data1, data);
           strcat(Data1, ",");
           }          
           memset(name, 0, sizeof(name));
           if(WcQueryValue(MyKey1, "Default Address", data, &bytes)){/* gets data from "Default
                                                                     Address" record */
           strcat(Data1, data);
           }
           else{           
            strcat(Data1, "\r\n"); // adds a carriage return & line feed to the string line
           }
           WcCloseKey(MyKey1);  // closes this individual master record sub-key
           myFile.Write(Data1, strlen(Data1)); // writes the string line to the file
           i++;  // increments the index number
          }
       WcCloseKey(MyKey);  // closes the "USER" key
     }	
	/* 3 - Message box to let you know the process is complete */
	 
	AfxMessageBox("Address list completed", MB_OK, 0);
	
	/* 4 - Closes the file */
	
	myFile.Close();

    /* Note:  See CFramesdiApp::CFramesdiApp() (ie; the Constructor)
	          and CFramesdiApp::~CFramesdiApp() (ie; the destructor)
	          for required master startup and shutdown/cleanup functions in FRAMESDI.CPP.
	*/	
}

void CFramesdiDoc::OnWildcatAddkeytoregistry() // "R" button command on toolbar
{
    /* What we are accomplishing here:
       a.  When the Add Key to Registry ("R") toolbar button (or menu item) is
            selected we are routed to this function.
       b.  If successful we will add a new key to the registry and add some data
            to it.
       c.  If unsuccessful at any stage we get a warning message box and exit.
       
       This is an example of how to put information INTO the WCCACHE.DAT file
       registry. This is an important function for developers who want to create
       their own registry entry keys and then store information under those keys.
       This is similar to the old Win 3.1 INI file way of doing things.
       
       NOTE:  This function requires the services of "wccache.h" (Wildcat Cache API)
              and cloadsys.h" (Wildcat System API)
    */	
	
	WCHKEY MyKey; // Defines variable to accept the key values
	
	// the next 2 lines define some local variables you will need
	unsigned long bytes;
	char Data[4096]; // array for storing string data
		
	/* 1 - Makes a registry key in the WcCache.dat file - If successful, installs 
	        data to the key and then closes the key.  To check the results use the
	        DFView (File Viewer) tool which comes with Visual C++ to look at the
	        WcCache.DAT file (located in the WCNavigator directory) and it's contents.
    */     
    memset(Data, 0, sizeof(Data));   // initializes Data array
    strcpy(Data, "This is a test!"); // copies string into data array
    bytes = 0;
   
    if(WcCreateKey(WCHKEY_CURRENT_SYSTEM, 	"GAME1", &MyKey)) {  // Creates Game1 sub-key   
     bytes = strlen(Data); // gets size of the string in DATA
     WcSetValue(MyKey, "Player1", Data, bytes);  // writes data under heading of Player1
     WcCloseKey(MyKey);  // closes the "GAME1" key - don't forget this!
     }
     	
	/* 2 - Message box to let you know the process is complete */
	 
	AfxMessageBox("Key and data added to registry", MB_OK, 0);
    
    /* Note:  See CFramesdiApp::CFramesdiApp() (ie; the Constructor)
	          and CFramesdiApp::~CFramesdiApp() (ie; the destructor)
	          for required master startup and shutdown/cleanup functions in FRAMESDI.CPP.
	*/
}

void CFramesdiDoc::OnWildcatSystempage() // "SP" button command on toolbar
{
    /* What we are accomplishing here:
       a.  When the System Page ("SP") toolbar button (or menu item) is
            selected we are routed to this function.
       b.  If successful we will broadcast (Global Page) an instant message through
            the chat channel to everyone currently logged onto the Wildcat Server.
       c.  If unsuccessful at any stage we get a warning message box and exit.
       
       This is an example of how to send a message through the chat channel to
       everyone currently logged onto the Wildcat Server.  One possible use for this
       would be to invite others to participate in an online game.
       
       NOTE:  This function requires the services of "cloadpxy.h" (Wildcat Proxy API),
              cloadsys.h" (Wildcat System API) and "wildsock.h" (with Wildsock.Lib)
    */	
	

	/* 1 - Opens a socket to the Navigator Server agent. The WM_SOCKETNOTIFY parameter
	       is defined as a constant in the FRAMESDI.H portion of the code. Upon
	       receipt of a Network event message (WM_SOCKETNOTIFY) you are routed to
	       the message map in the MAINFRM.CPP and eventually to the
	       LRESULT CMainFrame::OnSockNotify(WPARAM wp, LPARAM lp) function you will
	       find there in that unit.  In addition that function has been
	       added to the public area of the CMainFrame class of MAINFRM.H.
	       NOTE:  "s" is assigned our created socket...
	 */
    SOCKET s = OpenChannel(AfxGetMainWnd()->GetSafeHwnd(), WM_SOCKETNOTIFY,
     "System.Page", FALSE);
     
    /* 2 - Checks for valid socket, if not valid exits */
    
    if(s == INVALID_SOCKET){ 
	   AfxMessageBox("Socket NOT opened!", MB_ICONSTOP|MB_OK, 0);
	  return;
	  }
	  
    /* 3 - Writes the message to the socket in a broadcast format */
    
    if(s!= INVALID_SOCKET){
      TPageMessage msg;  // defined from TPageMessage Struct at top of this unit
      memset(&msg, 0, sizeof(msg)); // initializes msg
      strcpy(msg.From, "Player #1"); // sets from addressee
      strcpy(msg.Message[0], "Anyone want to join me in Game #1?"); // sets message content
      WriteChannel(s, 0, 0, &msg, sizeof(msg)); // writes message in broadcast format
      closesocket(s); // Very important! Don't forget to do this when you are done...
     }

	/* 4 - Message box to let you know the process is complete */ 
	
	AfxMessageBox("Broadcast message sent!", MB_OK, 0);
    
    /* Note:  See CFramesdiApp::CFramesdiApp() (ie; the Constructor)
	          and CFramesdiApp::~CFramesdiApp() (ie; the destructor)
	          for required master startup and shutdown/cleanup functions in FRAMESDI.CPP.
	*/	
}
