Attribute VB_Name = "EnhancedDate"
Option Explicit

Type SystemTime
        wYear As Integer
        wMonth As Integer
        wDayOfWeek As Integer
        wDay As Integer
        wHour As Integer
        wMinute As Integer
        wSecond As Integer
        wMilliseconds As Integer
End Type

Declare Function FileTimeToSystemTime Lib "kernel32" (lpFileTime As FileTime, lpSystemTime As SystemTime) As Long
Declare Function SystemTimeToFileTime Lib "kernel32" (lpSystemTime As SystemTime, lpFileTime As FileTime) As Long



Public Function DateToFileTime(d As Date) As FileTime
  Dim sysDate As SystemTime
  Dim t As Long
  ' Convert Date to SystemTime
  sysDate.wDay = DatePart("d", d)
  sysDate.wMonth = DatePart("m", d)
  sysDate.wYear = DatePart("yyyy", d)
  ' Convert SystemTime to FileTime
  t = SystemTimeToFileTime(sysDate, DateToFileTime)
End Function



Public Function FileTimeToDate(f As FileTime) As Variant
  Dim strDate As String
  Dim sysDate As SystemTime
  If FileTimeToSystemTime(f, sysDate) Then
    ' Convert SystemTime to String
    strDate = Trim(Str(sysDate.wMonth)) + "/" + Trim(Str(sysDate.wDay)) + "/" + Trim(Str(sysDate.wYear))
    ' Convert String to Date
    FileTimeToDate = DateValue(strDate)
  Else
    FileTimeToDate = 0
  End If
End Function



Public Function FileTimeToString(f As FileTime) As String
  Dim sysDate As SystemTime
  If FileTimeToSystemTime(f, sysDate) Then
    ' Convert SystemTime to String
    FileTimeToString = Trim(Str(sysDate.wMonth)) + "/" + Trim(Str(sysDate.wDay)) + "/" + Trim(Str(sysDate.wYear))
  Else
    FileTimeToString = vbNull
  End If
End Function
