Attribute VB_Name = "cgi4upld"
Option Explicit
'-----------------------------------------------
'CGI4upld File upload
'Author : Kevin O'Brien [obrienk@pobox.com]
'                       [obrienk@ix.netcom.com]
'Version 1.0 (October 1996)
'Requires CGI4VB.BAS and CGI4RTN.BAS
'-----------------------------------------------
'
'Warning!
'--------
'This is an exercise in handling multipart headers.
'I myself would never make my own PC available for
'anonymous file uploads, and I assume you won't either.
'
'The dangers, I hope, are obvious.
'See: http://www-genome.wi.mit.edu/WWW/faqs/www-security-faq.html
'
'Use it as an educational tool, and not as an opportunity
'to shoot yourself in the foot.
'----------
'Attention!
'----------
'Voici un exercise pour manier les "multipart headers".
'Moi, je n'ouvrirais jamais mon propre ordinateur pour permettre
'les inconnus  m'envoyer des fichiers anonymes.
'
'J'espre que les dangers sont vidents.
'Voir: http://www-genome.wi.mit.edu/WWW/faqs/www-security-faq.html (en anglais)
'
'Utilisez-la comme un outil educatif, et pas un moyen de se faire mal.
'

Public bFilePart  As Boolean
Public sBody      As String
Public sUploadDir As String
Public fPair()    As pair
Sub AddPairF(sName As String, sValue As String)
Dim n As Long

n = UBound(fPair) + 1
ReDim Preserve fPair(n)
fPair(n).Name = sName
fPair(n).Value = sValue
End Sub

Function GetFileInfo(sItem As String) As String
'---------------------------------------------------
' All of the file information for the uploaded file
' has been stored in fPair()
'---------------------------------------------------
Dim x As Long
 
For x = 1 To UBound(fPair)
   If UCase$(sItem) = UCase$(fPair(x).Name) Then
      GetFileInfo = fPair(x).Value   'this is what we are looking for
      Exit For
   End If
Next x

End Function

Sub ReadLine(sLine As String)
'--------------------------------------------------------
'split out the name/value pairs and add them to
'  fPair() or tPair(), depending on whether we are saving
'  file information or not.
'AddPairT() will add a pair to tPair()
'AddPairF() will add a pair to fPair() (file information)
'--------------------------------------------------------
Dim v As Variant
Dim x As Long
Dim pos As Long
Dim sItem As String

If InStr(sLine, "filename=""") Then   'identifies the line that
   bFilePart = True                   '  contains the file info.
   ReDim fPair(0)                     'initialize fPair()
End If

v = ParseToArray(sLine, "; ")  'split the line by semi-colon into items
      
For x = 0 To UBound(v)         'for each item within the header line
   sItem = v(x)
   If sItem = "" Then GoTo Iterate              'go to the next item
   pos = InStr(sItem, "=")
                   
   If bFilePart Then                            'part contains a file
      If InStr(sItem, "filename=""") = 1 Then   'save the original name
         AddPairF Left$(sItem, pos - 1), _
             Strip(Mid$(sItem, pos + 1), Chr$(34))
                                                '...and our temp name
         AddPairF "saveAs", _
             TempFile(sUploadDir, "up")
                                                '...and the file size
         AddPairF "fileSize", _
             Trim$(Str$(Len(sBody)))
      
      ElseIf pos > 0 Then                       'all other pairs
         AddPairF Left$(sItem, pos - 1), _
             Strip(Mid$(sItem, pos + 1), Chr$(34))
      
      ElseIf InStr(1, sItem, "Content-type: ", 1) Then
         AddPairF "Content-type", _
            ParseItem(sItem, ": ", 2)
      End If
   
   Else
      '      part does not contain a file
      '      here we will find name="comments" and name="uploader"
      If InStr(sItem, "name=") = 1 Then    'pairs containing "name="
         AddPairT Strip(Mid$(sItem, 6), Chr$(34)), _
                  sBody
      
      ElseIf pos > 0 Then                   'all other pairs
         AddPairT Left$(sItem, pos - 1), _
             Strip(Mid$(sItem, pos + 1), Chr$(34))
      End If
   End If
Iterate:
Next x
End Sub


Sub AddPairT(sName As String, sValue As String)
Dim n As Long

n = UBound(tPair) + 1
ReDim Preserve tPair(n)
tPair(n).Name = sName
tPair(n).Value = sValue
End Sub
Sub Cgi_Main()

sUploadDir = "d:\temp"   'directory where uploads and log will be saved
SendHeader "File upload"

If InStr(1, CGI_ContentType, "multipart", 1) > 0 Then
   Multipart sFormData
Else
   Send "File not received. " _
   & "Your browser did not send the expected multipart headers"
End If


SendFooter
End Sub
Sub Multipart(sData As String)
'--------------------------------------------------
' The CGI_contentType will identify the data as
' multipart/form-data;boundary=[boundary-string]
' Parts need to be split out.
'--------------------------------------------------
Dim sLog          As String  'log message
Dim sHeader       As String  'headers
Dim sBoundary     As String  'boundary-string
Dim lBoundary     As Long    'pos of the crlf at end of 1st boundary
Dim lNextBoundary As Long    'start byte of next boundary-string
Dim lLastBoundary As Long    'start byte of last boundary-string
Dim lBody         As Long    'start byte of body
Dim lBodyLen      As Long    'length of body
Dim pos           As Long    'pos of target used with InStr

lBoundary = InStr(1, sData, vbCrLf)
sBoundary = Left$(sData, lBoundary - 1)
lLastBoundary = InStr(1, sData, sBoundary & "--")
pos = lBoundary + 2                             'move past the crlf
Send "<h2>File Upload</h2>"
 
Do
   sData = Mid$(sData, pos)
   lBody = InStr(1, sData, vbCrLf & vbCrLf) + 4 'identified by 2 crlfs
   If lBody = 4 Then Exit Do                    'should never happen
   
   sHeader = Left$(sData, lBody - 5)
   
   ' find the next boundary string
   ' get the content (sBody) of the data
   lNextBoundary = InStr(lBody, sData, sBoundary)
   lBodyLen = lNextBoundary - lBody - 2        'there is a crlf between
   sBody = Mid$(sData, lBody, lBodyLen)        '    the body & boundary
   
   ReadPart sHeader
   
   pos = lNextBoundary + Len(sBoundary) + 2
Loop Until lNextBoundary = lLastBoundary

sLog = "Date         " & Now & vbCrLf _
   & "Filename     " & GetFileInfo("filename") & vbCrLf _
   & "Saved as     " & GetFileInfo("saveAs") & vbCrLf _
   & "Content-Type " & GetFileInfo("Content-type") & vbCrLf _
   & "Size         " & GetFileInfo("fileSize") & vbCrLf _
   & "From         " & CGI_RemoteAddr & " " & CGI_RemoteHost & vbCrLf _
   & "Uploaded by  " & GetCgiValue("uploader") & vbCrLf _
   & "Comments     " & GetCgiValue("comments") & vbCrLf

Open sUploadDir & "\upload.log" For Append As #1
Print #1, sLog
Close #1

Send Translate(sLog, vbCrLf, "<br>")
Send "<hr>"
End Sub
Sub ReadPart(sHeader As String)
'--------------------------------------------------
'read the header for this part
'split out the individual lines of the header
'save the uploaded file, if this part contains one
'--------------------------------------------------
Dim v As Variant
Dim x As Long

'split out the individual lines
v = ParseToArray(sHeader, vbCrLf) 'returns an array
    
bFilePart = False
For x = 0 To UBound(v)            'for each line within the part
    ReadLine v(x)
Next x

If bFilePart Then                 'this part contains a file
   Open GetFileInfo("saveAs") For Binary As #1
   Put #1, , sBody
   Close #1
End If
End Sub


