Attribute VB_Name = "cgi4Cntr"
Option Explicit
'-------------------------------------------------
' CGI4CNTR - Display a page counter on a web page
' Author : Kevin O'Brien [obrienk@pobox.com]
'                        [obrienk@ix.netcom.com]
' Requires CGI4VB.BAS
'-------------------------------------------------
'
'The trick to executing a cgi script from an <img> tag
'is that you have to return an image,
'even if its a 1x1 pixel transparent gif.
'
'-------------------------------------------------
'Instead of reading the images from a disk file,
'each of the images has been loaded into a string.
'This should speed things up by reducing disk I-O on the server,
'and it means that I don't need to supply the gif files separately.
'
'Each byte within the image is represented in the string by two hex digits.
'The string will be converted back to bytes (sImage) before it's sent.
'
'To read images directly from disk, the code is much simpler:
'
'  Open "c:\digit.gif" For Binary Access Read As #1
'  sImage = String(LOF(1), Chr$(0))
'  Get #1, , sImage
'  Close #1
'------------------------------------------------------------------
'Place the following in your HTML doc. Put all of the <img> tags
'on one line without any spaces between the tags.
'
' <img src="\cgi-bin\cgi4cntr.exe?c=cntr&p=1">
' <img src="\cgi-bin\cgi4cntr.exe?c=cntr&p=2">
' <img src="\cgi-bin\cgi4cntr.exe?c=cntr&p=3">
' <img src="\cgi-bin\cgi4cntr.exe?c=cntr&p=4">
'------------------------------------------------------------------
'

Sub Cgi_Main()
Dim sImage      As String  ' hex values converted to bytes
Dim x           As Long    ' index of byte within sImgHex
Dim ff          As Long    ' file number
Dim lNum        As Long    ' counter number
Dim sNum        As String  ' counter string
Dim sImgHex(10) As String  ' digits 0-9 and transparent gif
Dim p           As String  ' input parm - position of the digit
Dim c           As String  ' input parm - the name of the counter
Dim iIndex      As Integer ' index for sImgHex array

sImgHex(0) = "47494638376110001500910000FFFFFF4A7B9452C6FF0000002C00000000100015000002409C8FA9BBE20F931802D83BE77114666D54E0068CA27292635822A9DB6E5340D79D52E7013AEBB78A8AB156146191F83A064D9F086753BC5832124F8481CD2E0A003B"
sImgHex(1) = "47494638376110001500910000FFFFFF395A6B52C6FF0000002C000000001000150000023F9C8FA9BBE10F5318300AE4681DE29EA70880678089486AD33962199B66D5D429F3EBAA60FDE107EA5A21803DE1AF550C214B931927A6B3486E3E86F58A2800003B"
sImgHex(2) = "47494638376110001500910000FFFFFF315A6B52C6FF0000002C00000000100015000002469C8FA9BBE20F531802D82B280A133A9A1DDC9454A1312AE6C6A9C039A4E5CB82D1375F166C7C5ED63AAC24C11E8D4832F26245CA919504D91E4C44A6A2A345A73F86F7CB2800003B"
sImgHex(3) = "47494638376110001500910000FFFFFF315A6B52C6FF0000002C00000000100015000002449C8FA9BBE20F531802D82B280A133A9A1DDC9454A1312AE6C6A9C039A4E5CB82D1375F168C761EC8222156A2D60C261BD28AC203B1677B004514DD4E33F44418DCEEA200003B"
sImgHex(4) = "47494638376110001500910000FFFFFF315A6B52C6FF0000002C00000000100015000002409C8FA9BBE10F931830CE23660D2323015C5F388A18799A0668B28A8B4DD92CAB1D80E7B6D3D135F278A10C41C990C2339A8A252067D30322A1AA4D8481CD2E0A003B"
sImgHex(5) = "47494638376110001500910000FFFFFF315A6B52C6FF0000002C00000000100015000002449C8FA9BBE20F931802D83B037214667D545312941B3022256888CA7AA6071C4EDEA75497251BE6DD51992428212B549C0D63C65CD2A7017266941D8F22B93D18DC2EA300003B"
sImgHex(6) = "47494638376110001500910000FFFFFF315A6B52C6FF0000002C00000000100015000002429C8FA9BBE20F931802D83B037214667D545312941B3022256888CA7AA6071C4EDEA7549725B7B6D789E550420931742CB6924819E7160C51763C8AE4F66068B78C02003B"
sImgHex(7) = "47494638376110001500910000FFFFFF315A6B52C6FF0000002C00000000100015000002429C8FA9BBE20F531802D82B280A133A9A1DDC9454A1312AE6C6A9C039A4E5CBC663FB49B75CEF1DCC3BAC44AD19B08818A290421AD176036DA03B0DCBC76468B78802003B"
sImgHex(8) = "47494638376110001500910000FFFFFF52C6FF0000000000002C000000001000150000023D948FA9BBE10F531001D83BE77114666D54E0068CA27292635822A9DB6E5FC4491786CE4F07AF54CCF2BD7E42201165E4783EAEDFADB55A4618D4EAA200003B"
sImgHex(9) = "47494638376110001500910000FFFFFF315A6B52C6FF0000002C00000000100015000002409C8FA9BBE20F931802D83BE77114666D54E0068CA27292635822A9DB6E5FC44917A60441478FFA6EF3E95031C38F2804C284BC4707B1ABDC5A2B8F8781CD320A003B"
sImgHex(10) = "47494638396101000100800000000000FFFFFF21F90401000000002C000000000100010000020144003B"
   
sNum = "0000"
ff = FreeFile

p = GetCgiValue("p")
c = GetCgiValue("c")

'set up the name of the counter in the registry
'If not entered, it will be "counter" by default.
If c <= " " Then c = "counter"

' validity check - p can be from "1" to "4"
If (p < "1") Or (p > "4") Then
    iIndex = 10 ' send transparent 1x1 pixel gif to satisfy <img>
    GoTo SendImage
End If

On Error Resume Next

sNum = GetSetting(App.Title, "counters", c, "0000")
If Not IsNumeric(sNum) Then sNum = "0000"  'initialize the counter

If p = "1" Then
   lNum = Val(sNum) + 1                    'increment the counter
   sNum = Format(Str(lNum), "0000")
   SaveSetting App.Title, "counters", c, sNum 'update registry
End If

sNum = Format(sNum, "0000")
iIndex = Mid$(sNum, Val(p), 1)

SendImage:
   
   'convert the hex values of the hex-coded image string to bytes
   'remove this if you're reading your own image from disk
   
   sImage = ""
   For x = 1 To Len(sImgHex(iIndex)) Step 2
      sImage = sImage & Chr$("&H" & Mid$(sImgHex(iIndex), x, 2))
   Next x
   
   ' Use SendB() to send the image, instead of Send().
   ' Make sure content-type agrees with what you're sending.
   ' Use image/jpeg for jpg files.
   
   Send "Status: 200 OK"
   Send "Content-type: image/gif" & vbCrLf
   SendB sImage
End Sub

