; Template file: NOTIFY.APL
; Type         : Notify
;
; This template generates a status report along with three different lists:
;
; 1 - A list of all the fileechos a system only receives files in.
; 2 - A list of all the fileechos a system only sends files in,
; 3 - A list of all the fileechos a system both sends and receives files in.
;
  Following are the options  that are set for your system and a list of areas
  that your system is connected to at this system. Please check if everything
  is correct.

  Aka used              : @akatouse
  AreaMgr password      : @mgrpassword
  File echo password    : @echopassword
  File attach status    : @filestat
  Other mail status     : @mailstat
  TIC file mode         : @ticmode
  Packing mode          : @packmode
  Include template file : @template
  Send notify list      : @notify
  Compression type      : @compression
  Available groups      : @availgroups


@assign(@bcount,0)
@assign(@count,0)
@assign(@doneheader,"No")
@areabegin
@test(@echostat,=,"+")
@test(@doneheader,=,"No")
  Your system receives files from our system for the following fileechos:

  Fileecho      Description                                Avg Kb   Avg Files
  ---------------------------------------------------------------------------
@assign(@doneheader,"Yes")
@end
  @just(@fileecho,L,14)@just(@echodesc,L,39) @just(@avgkb,R,9)   @just(@avgfiles,R,9)
@add(@count,1)
@add(@bcount,1)
@end
@end
@test(@doneheader,=,"Yes")
  ---------------------------------------------------------------------------
  @count fileecho(s)
@end


@assign(@count,0)
@assign(@doneheader,"No")
@areabegin
@test(@echostat,=,"*")
@test(@doneheader,=,"No")
  Our system receives files from your system for the following fileechos:

  Fileecho      Description                                Avg Kb   Avg Files
  ---------------------------------------------------------------------------
@assign(@doneheader,"Yes")
@end
  @just(@fileecho,L,14)@just(@echodesc,L,39) @just(@avgkb,R,9)   @just(@avgfiles,R,9)
@add(@count,1)
@add(@bcount,1)
@end
@end
@test(@doneheader,=,"Yes")
  ---------------------------------------------------------------------------
  @count fileecho(s)
@end


@assign(@count,0)
@assign(@doneheader,"No")
@areabegin
@test(@echostat,=,"&")
@test(@doneheader,=,"No")
  We both send files to each other for the following fileechos:

  Fileecho      Description                                Avg Kb   Avg Files
  ---------------------------------------------------------------------------
@assign(@doneheader,"Yes")
@end
  @just(@fileecho,L,14)@just(@echodesc,L,39) @just(@avgkb,R,9)   @just(@avgfiles,R,9)
@add(@count,1)
@add(@bcount,1)
@end
@end
@test(@doneheader,=,"Yes")
  ---------------------------------------------------------------------------
  @count fileecho(s)
@end
@test(@bcount,=,0)
  You are not connected to any fileechos.
@end

---
 * Origin: use %HELP for help using the AreaMgr in ALLFIX (@akatouse)
