!Ŀ
!VScript Name: DATESCAN.V            Author: Grak Ockton #1 @1619045 VNET     
!Release Date: 11-04-1994            Modified By: NONE                        
!Written For: VBBS-DOS v6.10a                                                 
!External Effects: None                                                       
!Internal Effects: Uses User's EXTRA 4 variable                               
!                                                                             
!                                                                             
! Description: Currently, VBBS requires that one must enter the number of     
!              days back to scan for a New File Scan.  If it's been awhile    
!              though, it's difficult to remember the last time you scanned   
!              for new files.  Or, it's difficult to count the number of      
!              days since a certain date you are interested in scanning       
!              for.                                                           
!                                                                             
!              This VScript is meant to replace the default New File Scan     
!              routine.  It allows the User to store a Last Scan, so          
!              he or she does not have to remember the last time they         
!              scanned for new files.  It also accepts not only the usual     
!              number of days back to scan, but a bonafide date as well!      
!                                                                             
!              DATESCAN.V provides a useful display for the User, and allows  
!              him or her various options like the style of the date (i.e.    
!              American or European) and a flexibility in entry.              
!                                                                             
!              For Example:                                                   
!                                                                             
!                  Scan New Files since...                                    
!                  [Style: American]                                          
!                  [Today's Date: 11/04/1994]                                 
!                  [Last Scan Performed: 04/14/1994]                          
!                  [S/T/L/(a date)/(#)/<ENTER>/?/Q]:                          
!                                                                             
!              It also provides configurability for the Sysop.  Including in  
!              part: near-complete configurability in text strings and        
!              informational displays; control over what the User can actually
!              change and see; style configurability; and primative speed     
!              control.  All within easy reach of the Sysop.                  
!                                                                             
!                                                                             
! Installation: Simply place this VScript in your \VBBS\V directory (or the   
!               directory where you normally keep your VScripts and Function  
!               Blocks).  Make any necessary changes to it and compile it by  
!               running 'VCOM datescan' from the command line.  Finally,      
!               replace all instances of NEWFILES within your Function Blocks 
!               with DATESCAN.  For example:                                  
!                                                                             
!               Replace...                                                    
!               n 001 1 ^newfiles                                             
!                                                                             
!               With...                                                       
!               n 001 2 datescan                                              
!                                                                             
!                                                                             
!
!------------------------------------------------------------------------------ 
!  Following changes made by: Grak Ockton #1 @1619045 VirtualNET
!                   Sysop of: Kasterborus Constellation BBS (+1-619-484-9351)
!
!  Remarks:
!
!  This VScript I made on 9/28/94.  It will let the User perform a New File
!  Scan by either inputing the DATE for the Scan, or the number of days back
!  to scan.  Since VBBS only accepts the latter directly, I had to manually
!  transform the DATE into the number of days back so VBBS would accept it.
!
!  It is currently *verified* accurate from 1583 A.D. to 9999 A.D., but should
!  theoretically work as far back as 1000 A.D..  The number of days is limited
!  to 10 digits internally by VBBS, and this VScript checks for that.
!
!  This VScript turned out to be pretty long in length.  There isn't much
!  room for slack if anyone else wants to make any personal modifications.
!  That is regrettable, but I had to cut SO much configurability out of this 
!  script as it stands!  For instance, ERRORCODE processing is now out of the 
!  picture.
!
!  Current problems include mainly speed.  It takes a while to load and to
!  process the User's Last Scan, so I inserted a little display to let the
!  User know that the VScript is actually doing something <grin>.
!
!  As I mention below, the "meat" of this VScript is the part that calculates
!  the number of dates back to a given date.  This routine is adapted from 
!  another VScript I wrote called DAYCALC.V, so if you would like a further 
!  explanation on how this is done or if you would like to develop another
!  VScript that isn't so fancy, you might want to take a look at it. 
!
!  I encourage anyone to modify or otherwise improve upon this VScript (the
!  restriction in it's current length is duely noted).
!  I do ask that they log their changes, though, and sign their names up top.
!  One doesn't have to be as long-winded as I, however.  
!
!  I've tried to make the code as readable as possible.  Temporary variables
!  include a, b, c, d, e, etc.  I've also tried to arrange things nicely
!  If things need more explanation, or if you have a suggestion for 
!  improvement, please don't hesitate to contact me!
!
!  Oh, and forgive my spelling, please.   :-)
!
!
! * END OF REMARKS *
!
!
!  Log of changes:
!
!  [11/03/94]: Made some final changes to it, and performed the final checkups.
!              Let's hope it works!
!  [10/28/94]: Did some more messing around with it.  I had to chop a lot of its
!              configurability because the size increased too much.  I've kept
!              easily configurable strings, colours, speedlevels, among other
!              things.  I've added a total of three different styles of dates.
!              I've also developed a general day calculation routine called
!              DAYCALC.V, and incorporated it into this script for accurate
!              calculations (see DAYCALC.V itseld to see how this is done).
!  [10/5/94]: Added more features, including allowing more kinds of deliminators
!             between the month/day/year.  Sysop can force "European style" date
!             formats.  Also made the colour scheme general and easily
!             configurable.  Also changed the general format of the user
!             interface to allow more natural choices.  The code stills needs
!             a clean-up job!
!  [9/30/94]: An even *little* more testing, still.  Made it safer.
!             Though methinks the code is looking "yucky," and needs a clean-up.
!  [9/29/94]: A *little* more testing.  Let's User now enter one-digit date
!             parts and stores a "last scan" date in User's account (Extra 4).
!             Also does a little date checking to see if it's entered correctly.
!  [9/28/94]: Wrote it today.  So far, it seems to work, but I haven't done 
!             much testing on it.
!
!-------------------------------------------------------------------------------



! This line lets the User know something is going on here, as this begining 
!  portion of code can take awhile.
ts $CRLF "Loading Configuration"


!******************************************************************************
!*                         Begin Sysop Customisation                          *
!******************************************************************************


!*************** Customise the basic operation of the VScript *****************
!******************************************************************************
! This line updates the display to the User so he knows something is going on.
ts "."


!  $speedlevel attempts to adjust the speed of the VScript depending on what
!    value you set this to.  I recommend a setting of '0'.  A setting of '3'
!    should work if you're sure a User will not enter a date that includes
!    a Leap Year.
!  speedlevel = 0   - normal operation
!  speedlevel = 1   - shortcut for keys; requires Sysop to manually change
!                       stylefields/stylekeys accordingly
!  speedlevel = 3   - shortcut for calculations (don't count leapdays);
!                       may produce inaccurate results!
!  speedlevel = 13  - both level 1 AND level 3
$speedlevel           = 0

!  $defaultseperator - the character you want displayed between the
!    month/day/year by default.
!        valid options: '-'
!                       '/'
!                       '.'
!                       '\'
!                       ' '
$defaultseperator     = "-"

!  $defaultdatestyle - the date style you want set by default.
!    valid options:  1 - for style1   (see below)
!                    2 - for style2
!                    3 - for style3   
$defaultdatestyle     = 1

!  $changeableseperator - define whether or not the User is able to enter
!    the date using a different seperator.  
!   valid options:  0 - don't allow (the $defaultseperator will then be used)
!                   1 - allow
$changeableseperator  = 1

!  $changeabledatestyle - define whether or not the User is able to change
!    the style of the date displayed/entered.
!   valid options:  0 - don't allow (the $defaultdatestyle will always to used)
!                   1 - allow
$changeabledatestyle  = 1

!  $chooseabletodaysdate - define whether or not the User is able to choose
!    today's date as an option for scanning.
!   valid options:  0 - don't allow (User has to manually enter the date or
!                                    will just press "<ENTER>"
!                   1 - allow
$chooseabletodaysdate = 1

!  $changeablelastscan - define whether or not the User can choose to keep his
!    last New File Scan
!   valid options:  0 - don't allow (the User's Last Scan will be always 
!                                    replaced by his current scan)
!                   1 - allow
$changeablelastscan   = 1

!  $hidestyledisp - define whether or not the User will see the current Style
!  valid options:   0 - don't hide display
!                   1 - hide display
$hidestyledisp        = 0

!  $hidetodaydisp - define whether or not the User will see today's date
!  valid options:   0 - don't hide display
!                   1 - hide display
$hidetodaydisp        = 0

!  $hidelastscandisp - define whether or not the User will see his Last Scan
!  valid options:   0 - don't hide display
!                   1 - hide display
$hidelastscandisp     = 0

!  $yeardigits - the number of digits of the year to use
!  valid options:   2 - Example: '94' (assumes 21st century)
!                   4 - Example: '1994' (allows for any date)
$yeardigits           = 2

!  $showhelp - define whether or not the User sees the help screen upon entering
!    the VScript.  The User can always opt. to display it if need be.
!  valid options:   0 - don't show
!                   1 - show
$showhelp             = 0        



!*************** Customise the basic colours of the VScript *******************
!******************************************************************************
! you MUST put something in the following colour banks
$headercolour       = "4"     ! for headers
$highlightcolour    = "1"     ! for text that is highlighted
$normalcolour       = "9"     ! for most "normal" text
$specialhighlight1  = "3"     ! for the Style key
$specialhighlight2  = "5"     ! for the Today's Date key
$specialhighlight3  = "A"     ! for the Last Scan key


ts "."

! An Example of a typical display:
!---------------------------------
! 4Scan New Files since...   
! 9[3S9tyle: 1American9]         
! 9[5T9oday's Date: 111/04/19949]
! 9[AL9ast Scan Performed: 104/14/19949]
! 9[3S9/5T9/AL9/1(a date)9/1(# of days)9/1<ENTER>9/1?9/1Q9]:


!***************** Customise the Date Styles of the VScript *******************
!******************************************************************************
$style1 = "American"   ! these just describe the Styles to your Users
$style2 = "European"
$style3 = "Japanese"
!  The actual format of the respective styles.
!  valid options:    mdy, dmy, ymd, myd, dym, ydm
$styledispform1 = "mdy"    ! m = month, d = day, y = year
$styledispform2 = "dmy"    ! can be any combination
$styledispform3 = "ymd"



!************ Customise basic information displays of the VScript *************
!******************************************************************************
! Text for User informational displays.
$stylefield = "Style: "
$todayfield = "Today's Date: "
$lastfield  = "Last Scan Performed: "
! The keys defined for those informational displays.
! valid options:  any letter contained in the above fields
$stylekey   = "S" 
$todaykey   = "T"
$lastkey    = "L"
! The following need only be entered if $speedlevel = 1 or 13.  
! valid options:  format is the respective field colour-coded correctly for 
!                 the key.
$stylestring = ""
$todaystring = ""
$laststring  = ""


ts "."


!*************** Customise various text displays of the VScript ***************
!******************************************************************************
!  I suggest running the VScript to see what these look like
$openbracket   = "["
$closebracket  = "]"
$header        = $headercolour & "Scan New Files since..."
$scanning      = $normalcolour & "Scanning for new files: "
$scaninfo1     = $normalcolour & "since " & $highlightcolour
$scaninfo2     = " "
$scandaysinfo1 = $normalcolour & "(" & $highlightcolour
$scandaysinfo2 = $normalcolour & ")"
$errormsg0     = "You made a wrong response!  Try again..."
$fatalerrmsg0  = $CRLF & "A fatal error has occurred!  Contact your Sysop!!"
$updatelast1   = $normalcolour & "Keep old 'last scan date' (" & $highlightcolour
$updatelast2   = $normalcolour & ")?"
$lastreplaced  = $normalcolour & "Old scan date replaced with new one just performed."
$lastpreserved = $normalcolour & "Old scan date preserved."
$helpheader    = $highlightcolour & "You may enter one of the following:"
$examplemon = "04"      ! the date used as an example
$exampleday = "14"
$exampleyr  = "1973"


!*************** Customise the User's prompt of the VScript *******************
!******************************************************************************
! these are also used in the help screen, and are automatically centered
!   within the 20-column space.
!  coloumns                             1         2
!                              12345678901234567890
$choice1 = $highlightcolour & "(a date)"
$choice2 = $highlightcolour & "(# of days)"
$choice3 = $highlightcolour & "<ENTER>"
$choice4 = $highlightcolour & "?"    ! help
$choice5 = $highlightcolour & "Q"    ! quit
$helpkey = "?"   ! for $choice4
$quitkey = "Q"   ! for $choice5

ts "."


!*********** Customise the help screen descriptions of the VScript ************
!******************************************************************************
! For Example:
!
! You may enter one of the following:
!        S        -  select different date format
!        T        -  scan for all files new as of today
!        L        -  scan for all files new as of the date you have saved
!     (a date)    -  scan for all files new as of specified date
!                       In the Format: mm/dd/yyyy  For Example: '04/14/1973'
!       (#)       -  scan for all files new as of # of day(s) back
!                       For Example: '25'
!     <ENTER>     -  accept current value; today's date if none
!        ?        -  this help screen
!        Q        -  quit
!
!  coloumns                                 1         2         3         4         5         6         7
!    60 columns max.               1234567890123456789012345678901234567890123456789012345678901234567890
$stylehelp      = $normalcolour & "-  select different date format"
$todayhelp      = $normalcolour & "-  scan for all files new as of today"
$lasthelp       = $normalcolour & "-  scan for all files new as of the date you have saved"
$datehelp       = $normalcolour & "-  scan for all files new as of specified date"
$dayshelp       = $normalcolour & "-  scan for all files new as of # of day(s) back"
$enterhelp      = $normalcolour & "-  accept current value; today's date if none"
$helpscreenhelp = $normalcolour & "-  this help screen"
$quithelp       = $normalcolour & "-  quit"
! Not counted in columns
$examplehlp1 = $highlightcolour & "  For Example"
$examplehlp2 = $highlightcolour & "  In the Format"

!******************************************************************************
!*                             End Customisation                              *
!******************************************************************************


 
ifval $yeardigits <> 4         ! double-check the year digits
  ifval $yeardigits <> 2
    GO fatalerror
  endif
endif

$a = $stylekey UPPER 0       ! double-check the hotkeys for conflicts
$b = $todaykey UPPER 0
$c = $lastkey UPPER 0
test $a = $c fatalerror
test $a = $b fatalerror
test $b = $c fatalerror

! update User display so he knows something is happening
ts "."    

testval $speedlevel = 1 begin       ! check for speed levels
testval $speedlevel = 13 begin

$colour = $specialhighlight1        ! this routine processes the stylefield
$processkey = $stylekey             !  and creates a colour-coded string for
$processstr = $stylefield           !  display
$change = $changeabledatestyle
CALL processkeys
$stylestring = $string

$colour = $specialhighlight2        ! this routine processes the today's date
$processkey = $todaykey             !  field and creates a colour-coded string
$processstr = $todayfield           !  for display
$change = $chooseabletodaysdate
CALL processkeys
$todaystring = $string

$colour = $specialhighlight3        ! this routine processes the lastscanfield
$processkey = $lastkey              !  and creates a colour-coded string for 
$processstr = $lastfield            !  display
$change = $changeablelastscan
CALL processkeys
$laststring = $string

ts "."


# begin

$m1 = 31               ! The number of total days of each month in the year.
$m2 = 28
$m3 = 31
$m4 = 30
$m5 = 31
$m6 = 30
$m7 = 31
$m8 = 31
$m9 = 30
$m10 = 31
$m11 = 30
$m12 = 31

$currentdatestyle = $defaultdatestyle
$currentseperator = $defaultseperator

$lastdatescan = $DATE            ! Grab User's Last Scan Performed
if $extra4 <> ""                 !  Stored in the format ...
  $a = $extra4 INSTR ":"         !     [date style][colon][last scan performed]
  ifval $a = 2
      $oldstyle = $extra4 MID 1 LEFT 1
      ifval $oldstyle = 1
        $currentdatestyle = 1
      endif
      ifval $oldstyle = 2
        $currentdatestyle = 2
      endif
      ifval $oldstyle = 3
        $currentdatestyle = 3
      endif
    $a = $a + 1
    $lastdatescan = $extra4 MID $a
  endif
endif

ts "."

ifval $currentdatestyle = 1
  $currentdispform = $styledispform1
endif
ifval $currentdatestyle = 2
  $currentdispform = $styledispform2
endif
ifval $currentdatestyle = 3
  $currentdispform = $styledispform3
endif

test $lastdatescan = $DATE parsedates   ! attempt to skip processing if possible

# checkvaliddate         ! check for a valid last scan date
$invalidlast = 0
$numa = 0                
$numb = 0
$numc = 0
$numd = 0
$nume = 0
$len = $lastdatescan LEN 0
$str = $lastdatescan
$invaliddate = 0
CALL countseps
ifval $invaliddate = 1
  $invalidlast = 1
  $lastdatescan = $DATE
endif

test $lastdatescan = $DATE parsedates

ts "."

# checkformat               ! check if the last scan is a date or number of days
$lastscanindaysformat = 0
ifval $numa = 0
  ifval $numb = 0
    ifval $numc = 0
      ifval $numd = 0
        ifval $nume = 0
          $lastscanindaysformat = 1       ! last scan is a number of days
          $lastdatescan = $lastdatescan INT 0
        endif
      endif
    endif
  endif
endif

$len = $lastdatescan LEN 0         ! verify correct last scan date
ifval $len > 10
  $lastdatescan = $DATE
  $lastscanindaysformat = 0
endif
ifval $len < 3
  ifval $lastscanindaysformat = 0
    $lastdatescan = $DATE
  endif
endif

test $lastdatescan = $DATE parsedates
testval $lastscanindaysformat = 1 parsedates

ts "."

# checkseperator              
$lastseperator = $defaultseperator
  ifval $numa = 2
    $lastseperator = "-"
    GO out2
  endif
  ifval $numb = 2
    $lastseperator = "/"
    GO out2
  endif
  ifval $numc = 2
    $lastseperator = "."
    GO out2
  endif
  ifval $numd = 2
    $lastseperator = "\"
    GO out2
  endif
  ifval $nume = 2
    $lastseperator = " "
    GO out2
  endif
  $lastdatescan = $DATE
# out2

ifval $changeableseperator = 1       ! if a valid last scan date, change the
  $currentseperator = $lastseperator !  seperator to the one used in the User's
endif                                !  last scan.

ts "."

# parsedates
$currday = $DATE MID 4 LEFT 2     ! Parse the current date.
$currmon = $DATE LEFT 2
$curryr =  $DATE MID 7

if $lastdatescan = $DATE
  $lastscanindaysformat = 0
  $lastmon = $currmon
  $lastday = $currday
  $lastyr = $curryr
  GO pass
endif

testval $lastscanindaysformat = 1 pass      ! parse the last scan date
  $a = $lastdatescan INSTR $lastseperator
  $trav = $a + 1
  $b = $lastdatescan MID $trav
  $trav = $a - 1
  $lastmon = $lastdatescan LEFT $trav
  $a = $b INSTR $lastseperator
  $trav = $a - 1
  $lastday = $b LEFT $trav
  $trav = $a + 1
  $lastyr = $b MID $trav

  $mon = $lastmon            ! this routine switches the date information
  $day = $lastday            !  depending on which style is used
  $year = $lastyr
  CALL interchangedates
  $lastmon = $mon
  $lastday = $day
  $lastyr = $year

  $invaliddate = 0           ! format the last scan date correctly
  $mon = $lastmon            !   e.g.  mm-dd-yyyy
  $day = $lastday
  $year = $lastyr
  CALL formatdate
  ifval $invaliddate = 1
    $invalidlast = 1
    $lastdatescan = $DATE
    GO parsedates
  endif
  $lastmon = $mon
  $lastday = $day
  $lastyr = $year

  $invaliddate = 0           ! check if the last scan date is valid
  $mon = $lastmon
  $day = $lastday
  $year = $lastyr
  CALL checkdate
  ifval $invaliddate = 1
    $invalidlast = 1
    $lastdatescan = $DATE
    GO parsedates
  endif
# pass

$len = $lastyr LEN 0         
ifval $len = 2
  $a = $curryr LEFT 2
  $lastyr = $a & $lastyr
endif

CALL flipdateformats   ! update displays based on date style

tr "."

# question                       ! Prompts the User
tr $CRLF $header "0"
testval $showhelp <> 1 skiphelp  
  CALL helpscreen                ! a small help screen is wanted
  $showhelp = 0
# skiphelp                    
ifval $hidestyledisp = 0
  CALL builddispstyle            ! "Style" display
  tr $t "0"
endif
ifval $hidetodaydisp = 0
  CALL builddisptodaysdate       ! "Today's Date" display
  tr $t "0"
endif
ifval $hidelastscandisp = 0
  CALL builddisplastscan         ! "Last Scan" display
  tr $t "0"
endif
CALL builduserprompt             ! User prompt display
rs $resp $t
tr ""
if $resp = $quitkey              ! check if the User wants to Quit
  $resp = $lastdatedisp
  GO endquestion
endif
if $resp = $helpkey              ! check if the User wants a little help
  $showhelp = 1
  GO question
endif
test $resp <> $stylekey skips    ! check if the User wants to change styles
  testval $changeabledatestyle <> 1 skips
    ifval $currentdatestyle = 1
      $a = 2
    endif
    ifval $currentdatestyle = 2
      $a = 3
    endif
    ifval $currentdatestyle = 3
      $a = 1
    endif
    $currentdatestyle = $a
    CALL flipdateformats
    GO question
# skips
test $resp <> "" skipenter       ! check if the User inputted nothing 
  $resp = $currdatedisp          !  (hit <ENTER>
  GO startscanning
# skipenter
test $resp <> $todaykey skipt    ! check if the User chose "Today's Date"
  test $chooseabletodaysdate <> 1 skipt
    $resp = $currdatedisp
    GO startscanning
# skipt
test $resp <> $lastkey skipl     ! check if the User chose "Last Scan"
  testval $changeablelastscan <> 1 skipl
    $resp = $lastdatedisp
# skipl


# startscanning                  
ts $scanning "0"


# checkresponse     ! PROCESS THE ENTERED SCAN 
ifval $len > 10
  GO wrongresp
endif

$numa = 0               ! check entered scan for valid seperators        
$numb = 0
$numc = 0
$numd = 0
$nume = 0
$len = $resp LEN 0
$str = $resp
$invaliddate = 0
CALL countseps
ifval $invaliddate = 1
  GO wrongresp
endif

$scanindaysformat = 0
ifval $numa = 0
  ifval $numb = 0
    ifval $numc = 0
      ifval $numd = 0
        ifval $nume = 0
          $daystoscan = $resp      ! entered scan is in number of days format
          $scanindaysformat = 1
          GO daysback          ! skip all this date processing stuff
        endif
      endif
    endif
  endif
endif

ifval $numa > 0               ! change seperator if date is valid
  $scanseperator = "-"
  $num = $numa
  testval $numa = 2 datescan      ! two dashes in response: date format
  testval $numa = 1 datescan      ! date format: assume current year
  GO wrongresp
endif
ifval $numb > 0
  $scanseperator = "/"
  $num = $numb
  testval $numb = 2 datescan
  testval $numb = 1 datescan
  GO wrongresp
endif
ifval $numc > 0
  $scanseperator = "."
  $num = $numc
  testval $numc = 2 datescan
  testval $numc = 1 datescan
  GO wrongresp
endif
ifval $numd > 0
  $scanseperator = "\"
  $num = $numd
  testval $numd = 2 datescan
  testval $numd = 1 datescan
  GO wrongresp
endif
ifval $nume > 0
  $scanseperator = " "
  $num = $nume
  testval $nume = 2 datescan
  testval $nume = 1 datescan
  GO wrongresp
endif

GO wrongresp              ! anything else is wrong


# datescan        ! the User probably chose the "date" format; process it
ifval $changeableseperator = 0   ! switch to User-entered seperator
  test $scanseperator <> $currentseperator wrongresp
else
  $currentseperator = $scanseperator
endif

$a = $resp INSTR $currentseperator     ! parse the User-entered scan date info.
$trav = $a + 1
$b = $resp MID $trav
$trav = $a - 1
$scanmon = $resp LEFT $trav
ifval $num = 2                 ! if User enters year
  $a = $b INSTR $currentseperator
  if $a = 1
    $num = 1
  endif
  $trav = $a - 1
  $scanday = $b LEFT $trav
  $trav = $a + 1
  $scanyr = $b MID $trav
endif
ifval $num = 1                 ! if User omits year (assume current year)
  testval $len > 5 wrongresp
  $scanday = $b MID 1
  $scanyr = $curryr
endif

$mon = $scanmon           ! change date values based on current date style
$day = $scanday
$year = $scanyr
CALL interchangedates
$scanmon = $mon
$scanday = $day
$scanyr = $year

$invaliddate = 0           ! format scan date correctly
$mon = $scanmon            !  e.g. mm-dd-yyyy
$day = $scanday
$year = $scanyr
CALL formatdate
testval $invaliddate = 1 wrongresp
$scanmon = $mon
$scanday = $day
$scanyr = $year

$invaliddate = 0          ! check validity of scan date
$mon = $scanmon
$day = $scanday
$year = $scanyr
CALL checkdate
testval $invaliddate = 1 wrongresp

!********************* everything checks out o.k.*******************************

CALL flipdateformats       ! update displays based on date style

# updatedisplay                ! update display to User
CALL buildscanningdisp
ts $t "0"
$resp = $scandatedisp


# calcdays    ! start calculating number of days back
$fullyears = 0                  ! calculate number of complete years in between
$old = $calcscanyr              !  the two dates  (days5) SEE DAYCALC.V
$new = $calccurryr
ifval $calccurryr <> $calcscanyr
  $new = $calccurryr - 1
  $old = $calcscanyr + 1
  $fullyears = $new - $old + 1
  ifval $fullyears < 0
    $fullyears = 0
    $old = $calcscanyr
    $new = $calccurryr
  endif
endif

$fullyearsdays = $fullyears * 365

$begin = 1                      ! find the number of days from the high date
$end = $calccurrmon - 1         !   to the begining of same year  (days1)
$days = 0                       !   SEE DAYCALC.C
ifval $calccurrmon <> 1
  CALL calcdaysofmonths
endif
$monthsdays = $days
$monthsdays = $monthsdays + $calccurrday - 1

$begin = 1                      ! find the number of days from the low date
$end = $calcscanmon - 1         !  to the begining of same year   (days3)
$days = 0                       !  SEE DAYCALC.V
ifval $calcscanmon <> 1
  CALL calcdaysofmonths
endif
$monthsdays2 = $days
$monthsdays2 = $monthsdays2 + $calcscanday - 1
ifval $calccurryr <> $calcscanyr
  $monthsdays2 = 365 - $monthsdays2
endif

testval $speedlevel = 3 skipleapdays    ! check for speed levels
testval $speedlevel = 13 skipleapdays

$begin = $old                   ! find any Leap Years in the complete years
$end = $new                     !  between the two dates  (in days5)
$addleapdays = 0                !  SEE DAYCALC.V
DO $iterate = $begin $end
  CALL calcleapyear
LOOP
endif
ifval $calccurrmon = 2          ! find any Leap Years of the High Date year
  ifval $calccurrday > $m2      !   if applicable  (in days1)
    $begin = $calccurryr        !   SEE DAYCALC.V
    $end = $calccurryr
DO $iterate = $begin $end
   CALL calcleapyear
LOOP
  endif
endif
ifval $calcscanmon < 3          ! find any Leap Years of the Low Date year
  $begin = $calcscanyr          !   if applicable  (in days4) SEE DAYCALC.V
  $end = $calcscanyr          
DO $iterate = $begin $end
   CALL calcleapyear
LOOP
endif

# skipleapdays

! tr ""                          ! output helpful values
! tr "fullyearsdays (days5)  = " $fullyearsdays
! tr "monthsdays    (days1)  = " $monthsdays
! tr "monthsdays2 (days3/4)  = " $monthsdays2
! tr "addleapdays            = " $addleapdays

$daystoscan = $monthsdays + $monthsdays2     ! add everything together
ifval $calccurryr = $calcscanyr
  $daystoscan = $monthsdays - $monthsdays2
endif

$daystoscan = $daystoscan + $addleapdays
$daystoscan = $daystoscan + $fullyearsdays

                             ! total number of days between the two
! tr "Totals days between    = " $daystoscan



# daysback                       ! This is where it skips to if the User enters
$len = $daystoscan LEN 0         !  a number of days directly.
testval $len > 10 wrongresp
$daystoscan = $daystoscan INT 0
testval $daystoscan < 0 wrongresp

CALL buildscanningdaysdisp
tr $t "0"
setnewfilesscan $daystoscan        ! tell VBBS the number of days back to scan
GO scan                       



!*******************************************************************************
!*                         Begin CALL routines                                 *
!*******************************************************************************

!*******************************************************************************
!  This CALL routine flips the date displays when the User changes date styles.
!    It also updates the help screen examples.
# flipdateformats
$processnorm = 0
testval $currentdatestyle <> 1 skip1    
  $processnorm = 1
  $style = $style1
  $currentdispform = $styledispform1
  $sep = $currentseperator
# skip1
testval $currentdatestyle <> 2 skip2
  $processnorm = 1
  $style = $style2
  $currentdispform = $styledispform2
  $sep = $currentseperator
# skip2
testval $currentdatestyle <> 3 skip3
  $processnorm = 1
  $style = $style3
  $currentdispform = $styledispform3
  $sep = $currentseperator
# skip3
ifval $processnorm = 1
  $mon = $currmon
  $day = $currday
  $year = $curryr
  CALL processeurope
  $currdatedisp = $datedisp
  $mon = $scanmon
  $day = $scanday
  $year = $scanyr
  CALL processeurope
  $scandatedisp = $datedisp
  $dateformatdesc = $datedesc
  $exampledesc = $exdesc
endif

$processlast = 0
testval $lastscanindaysformat <> 0 passit
  ifval $currentdatestyle = 1
    $processlast = 1
  endif
  ifval $currentdatestyle = 2
    $processlast = 1
  endif
  ifval $currentdatestyle = 3
    $processlast = 1
  endif
# passit
ifval $processlast = 1
  $mon = $lastmon
  $day = $lastday
  $year = $lastyr
  CALL processeurope
  $lastdatedisp = $datedisp
  $dateformatdesc = $datedesc
  $exampledesc = $exdesc
endif
ifval $lastscanindaysformat = 1
  $lastdatedisp = $lastdatescan
endif
RET

# processeurope             ! go through the current date format and change
  $e = "yyyy"               !  the date display accordingly
  $exyr = $exampleyr
  ifval $yeardigits = 2
    $year = $year MID 3
    $exyr = $exampleyr MID 3
    $e = "yy"
  endif
  DO $a = 1, 3
    $b = $currentdispform MID $a LEFT 1
    test $b <> "m" skipabby
      ifval $a = 1
        $datedisp = $mon
        $datedesc = "mm"
        $exdesc = $examplemon
      endif
      ifval $a > 1
        $datedisp = $datedisp & $sep & $mon
        $datedesc = $datedesc & $sep & "mm"
        $exdesc = $exdesc & $sep & $examplemon
      endif
# skipabby
     test $b <> "d" skipbaker
      ifval $a = 1
        $datedisp = $day
        $datedesc = "dd"
        $exdesc = $exampleday
      endif
      ifval $a > 1
        $datedisp = $datedisp & $sep & $day
        $datedesc = $datedesc & $sep & "dd"
        $exdesc = $exdesc & $sep & $exampleday
      endif
# skipbaker
     test $b <> "y" skipcharlie
      ifval $a = 1
        $datedisp = $year
        $datedesc = $e
        $exdesc = $exyr
      endif
      ifval $a > 1
        $datedisp = $datedisp & $sep & $year
        $datedesc = $datedesc & $sep & $e
        $exdesc = $exdesc & $sep & $exyr
      endif
# skipcharlie
  LOOP
RET
!*******************************************************************************


!*******************************************************************************
!  This CALL routine simply displays the help screen.
# helpscreen
tr $helpheader "0"
ifval $changeabledatestyle = 1
  $t = $specialhighlight1 & $stylekey & "0"
  JC $t 20
  tr $t $stylehelp "0"
endif
ifval $chooseabletodaysdate = 1
  $t = $specialhighlight2 & $todaykey & "0"
  JC $t 20
  tr $t $todayhelp "0"
endif
ifval $changeablelastscan = 1
  $t = $specialhighlight3 & $lastkey & "0"
  JC $t 20
  tr $t  $lasthelp  "0"
endif
$t = $choice1 & "0"
JC $t 20
tr $t  $datehelp "0"
$t = $examplehlp2 & $normalcolour & ": "
$t = $t & $highlightcolour &  $dateformatdesc
$t = $t & $examplehlp1 & $normalcolour
$t = $t & ": '" & $highlightcolour
$t = $t & $exampledesc & $normalcolour
$t = $t & "'" & "0"
tr %s20 "" %s70 $t
$t = $choice2 & "0"
JC $t 20
tr $t  $dayshelp "0"
$t = $examplehlp1 & $normalcolour & ": '"
$t = $t & $highlightcolour & "25"
$t = $t & $normalcolour & "'"
$t = $t & "0"
tr %s20 "" %s65 $t
$t = $choice3 & "0"
JC $t 20
tr $t $enterhelp "0"
$t = $choice4 & "0"
JC $t 20
tr $t $helpscreenhelp "0"
$t = $choice5 & "0"
JC $t 20
tr $t $quithelp "0"
RET
!*******************************************************************************


!*******************************************************************************
! This CALL routine simply builds a display for the User
# builddispstyle
$t = $normalcolour & $openbracket & $normalcolour
$t = $t & $stylestring
$t = $t & $highlightcolour
$t = $t & $style
$t = $t & $normalcolour & $closebracket
RET
!*******************************************************************************


!*******************************************************************************
! This CALL routine simply builds a display for the User
# builddisptodaysdate
$t = $normalcolour & $openbracket & $normalcolour
$t = $t & $todaystring
$t = $t & $highlightcolour
$t = $t & $currdatedisp
$t = $t & $normalcolour & $closebracket
RET
!*******************************************************************************


!*******************************************************************************
! This CALL routine simply builds a display for the User
# builddisplastscan
$t = $normalcolour & $openbracket & $normalcolour
$t = $t & $laststring
$t = $t & $highlightcolour
$t = $t & $lastdatedisp
$e = $t
ifval $lastscanindaysformat = 1
  $e = $t & " days back"
  ifval $lastdatedisp = 1
    $e = $t & " day back"
  endif
endif
$t = $e & $normalcolour & $closebracket
RET
!*******************************************************************************


!*******************************************************************************
! This CALL routine simply builds a display for the User
# buildscanningdisp
$t = $scaninfo1 & $scandatedisp
$e = $t
ifval $scanindaysformat = 1
  $e = $t & " days back"
  ifval $lastdatedisp = 1
    $e = $t & " day back"
  endif
endif
$t = $e & $scaninfo2
RET
!*******************************************************************************


!*******************************************************************************
! This CALL routine simply builds a display for the User
# buildscanningdaysdisp
$t = $scandaysinfo1 & $daystoscan
$e = $t & " days back"
ifval $daystoscan = 1
  $e = $t & " day back"
endif
$t = $e & $scandaysinfo2
RET
!*******************************************************************************


!*******************************************************************************
! This CALL routine simply builds a display for the User
# buildkeepdisp
$t = $updatelast1 & $lastdatedisp
$e = $t
ifval $lastscanindaysformat = 1
  $e = $t & " days back"
  ifval $lastdatedisp = 1
    $e = $t & " day back"
  endif
endif
$t = $e & $updatelast2
RET
!*******************************************************************************


!*******************************************************************************
! This CALL routine builds the User prompt
# builduserprompt
$t = $normalcolour & $openbracket & $specialhighlight2
ifval $changeabledatestyle = 1
  $t = $normalcolour & $openbracket & $specialhighlight1
  $t = $t & $stylekey & $normalcolour
  $t = $t & "/" & $specialhighlight2
endif
ifval $chooseabletodaysdate = 1
  $t = $t & $todaykey & $normalcolour
  $t = $t & "/" & $specialhighlight3
endif
ifval $changeablelastscan = 1
  $t = $t & $lastkey & $normalcolour
  $t = $t & "/" & $highlightcolour
endif
$t = $t & $choice1 & $normalcolour
$t = $t & "/" & $highlightcolour
$t = $t & $choice2 & $normalcolour
$t = $t & "/" & $highlightcolour
$t = $t & $choice3 & $normalcolour
$t = $t & "/" & $highlightcolour
$t = $t & $choice4 & $normalcolour
$t = $t & "/" & $highlightcolour
$t = $t & $choice5 & $normalcolour
$t = $t & $closebracket & ": "
RET
!*******************************************************************************


!*******************************************************************************
!  This CALL routine determines whether or not a year is a Leap Year using the
!  forumla:
! leapyear := ((yr mod 4 = 0) and (not(yr mod 100 = 0))) or ( yr mod 400 = 0 )
# calcleapyear          
  $addit = 0
  $a = $iterate / 4
  $b = $a INT 0
  ifval $a = $b
    $a = $iterate / 100
    $b = $a INT 0
    ifval $a <> $b
      $addit = 1
    endif
  endif
  $a = $iterate / 400
  $b = $a INT 0
  ifval $a = $b
    $addit = 1
  endif
  ifval $addit = 1
    $addleapdays = $addleapdays + 1
  endif
RET
!*******************************************************************************


!*******************************************************************************
!  This CALL routine goes through a specified number of months and adds their
!    total days together.
# calcdaysofmonths                  
DO $iterate = $begin $end            
  testval $iterate <> 1 skipone
    $days = $days + $m1
# skipone
  testval $iterate <> 2 skiptwo
    $days = $days + $m2
# skiptwo
  testval $iterate <> 3 skipthree
    $days = $days + $m3
# skipthree
  testval $iterate <> 4 skipfour
    $days = $days + $m4
# skipfour
  testval $iterate <> 5 skipfive
    $days = $days + $m5
# skipfive
  testval $iterate <> 6 skipsix
    $days = $days + $m6
# skipsix
  testval $iterate <> 7 skipseven
    $days = $days + $m7
# skipseven
  testval $iterate <> 8 skipeight
    $days = $days + $m8
# skipeight
  testval $iterate <> 9 skipnine
    $days = $days + $m9
# skipnine
  testval $iterate <> 10 skipten
    $days = $days + $m10
# skipten
  testval $iterate <> 11 skipeleven
    $days = $days + $m11
# skipeleven
  testval $iterate <> 12 skiptwelve
    $days = $days + $m12
# skiptwelve
LOOP
RET
!*******************************************************************************


!*******************************************************************************
!  This CALL routine goes through each character in the string $resp and counts
!    each valid seperator character.
# countseps
DO $a = 1, $len                 
  $b = $str MID $a LEFT 1     
  if $b = "-"                 
    $numa = $numa + 1
  endif
  if $b = "/"
    $numb = $numb + 1
  endif
  if $b = "."
    $numc = $numc + 1
  endif
  if $b = "\"
    $numd = $numd + 1
  endif
  if $b = " "
    $nume = $nume + 1
  endif
  $c = $b ASC 0
  testval $c >= 48 skipcheck
    testval $c = 45 skipcheck
    testval $c = 47 skipcheck
    testval $c = 46 skipcheck
    testval $c = 32 skipcheck
    $invaliddate = 1
# skipcheck
  ifval $c > 57
    ifval $c <> 92
      $invaliddate = 1
    endif
  endif
LOOP
RET
!*******************************************************************************


!*******************************************************************************
!  This CALL routine checks the current date format and flips the date 
!    accordingly.
# interchangedates
if $currentdispform = "mdy"
endif
if $currentdispform = "myd"
  $a = $year
  $mon = $mon
  $year = $day
  $day = $a
endif
if $currentdispform = "dmy"
  $a = $day
  $day = $mon
  $mon = $a
  $year = $year
endif
if $currentdispform = "dym"
  $a = $day
  $day = $mon
  $year = $a
  $mon = $year
endif
if $currentdispform = "ymd"
  $a = $year
  $year = $mon
  $mon = $day
  $day = $a
endif
if $currentdispform = "ydm"
  $a = $year
  $year = $mon
  $day = $day
  $mon = $a
endif
RET
!*******************************************************************************


!*******************************************************************************
!  This CALL routine transforms the date into a correct-formatted one
!    e.g. mm-dd-yyyy, for processing.
# formatdate
$len = $mon LEN 0          
testval $len > 2 invalid
testval $len < 1 invalid
ifval $len = 1                  
  $mon = "0" & $mon
endif
$len = $day LEN 0
testval $len > 2 invalid
testval $len < 1 invalid
ifval $len = 1
  $day = "0" & $day
endif
$len = $year LEN 0            ! if User enters two-digit year, transform
ifval $len = 2                  !   into a four-digit year
  $a = $curryr LEFT 2
  $a = $a & "00"
  $year = $a + $year
  $len = $year LEN 0
endif
testval $len > 4 invalid
testval $len < 4 invalid

GO skipinvalid
# invalid
$invaliddate = 1
# skipinvalid
RET
!*******************************************************************************


!*******************************************************************************
!  This CALL routine checks the date to see if a date is valid.
# checkdate
$calcscanmon = $mon INT 0   ! convert all the date values to numbers
$calcscanday = $day INT 0   !  e.g.:  "09" becomes 9
$calcscanyr  = $year INT 0
$calccurrmon = $currmon INT 0
$calccurrday = $currday INT 0
$calccurryr  = $curryr INT 0

testval $calcscanmon > 12 invalid2
testval $calcscanmon <= 0 invalid2
testval $calcscanday > 31 invalid2
testval $calcscanday <= 0 invalid2

ifval $calcscanmon = 1
  testval $calcscanday > $m1 invalid2
endif
testval $calcscanmon <> 2 skipleap
  $Febm2 = $m2
  $begin = $calcscanyr
  $end = $calcscanyr
  $addleapdays = 0
  DO $iterate = $begin $end
    CALL calcleapyear
  LOOP
  ifval $addleapdays = 1
    $Febm2 = $Febm2 + 1
  endif
  testval $calcscanday > $Febm2 invalid2
# skipleap
ifval $calcscanmon = 3
  testval $calcscanday > $m3 invalid2
endif
ifval $calcscanmon = 4
  testval $calcscanday > $m4 invalid2
endif
ifval $calcscanmon = 5
  testval $calcscanday > $m5 invalid2
endif
ifval $calcscanmon = 6
  testval $calcscanday > $m6 invalid2
endif
ifval $calcscanmon = 7
  testval $calcscanday > $m7 invalid2
endif
ifval $calcscanmon = 8
  testval $calcscanday > $m8 invalid2
endif
ifval $calcscanmon = 9
  testval $calcscanday > $m9 invalid2
endif
ifval $calcscanmon = 10
  testval $calcscanday > $m10 invalid2
endif
ifval $calcscanmon = 11
  testval $calcscanday > $m11 invalid2
endif
ifval $calcscanmon = 12
  testval $calcscanday > $m12 invalid2
endif

testval $calcscanyr < 0 invalid2
testval $calcscanyr > $calccurryr invalid2
ifval $calcscanyr = $calccurryr         ! final date checking
  testval $calcscanmon > $calccurrmon invalid2    ! make sure the scan date isn't in
  ifval $calcscanmon = $calccurrmon                !     the future...
    testval $calcscanday > $calccurrday invalid2
  endif
endif
GO skipinvalid2
# invalid2
$invaliddate = 1
# skipinvalid2
RET
!*******************************************************************************


!*******************************************************************************
!  This CALL routine processes a string and colours a specified letter in it 
!    accordingly.
# processkeys
ifval $change = 0
  $c = 1
  $colour = $normalcolour
else
  $c = 0
endif
$a = $processkey ASC 0
$string = $normalcolour
$len = $processstr LEN 0
DO $count = 1, $len
  $char = $processstr MID $count LEFT 1
  $b = $char ASC 0
  if $b = $a
    $string = $string & $colour & $char
    $string = $string & $normalcolour
    $c = 1
  else
    $string = $string & $char
  endif
LOOP
testval $c = 0 fatalerror
RET
!*******************************************************************************

!*******************************************************************************
!*                           End CALL routines                                 *
!*******************************************************************************

GO fatalerror

# wrongresp              ! Whoops...User did something wrong
tr $errormsg0
GO question

# fatalerror             ! Whoops...Sysop did something wrong
tr $fatalerrmsg0
GO end


# scan                   ! perform New File Scan, finally
newfiles
                         
# endquestion            ! ask User to keep same "last scan"
$a = "N"                   
testval $hidelastscandisp = 1 skipendquestion
if $resp = $lastdatedisp     ! determine if we really need to ask the question 
  $a = "Y"
  testval $oldstyle <> $currentdatestyle skipendquestion
  testval $invalidlast = 1 skipendquestion
  GO end
endif
testval $changeablelastscan = 0 skipendquestion
tr ""
CALL buildkeepdisp               ! ask the question
getny $a $t                    
# skipendquestion
if $a = "N"                         ! replace last scan
  $b = $currentdatestyle & ":" & $resp
  setextra 4 $b
  ifval $hidelastscandisp = 0
    tr $CRLF $lastreplaced "0"
  endif
endif
if $a = "Y"                         ! don't replace last scan
  $b = $currentdatestyle & ":" & $lastdatedisp
  setextra 4 $b
  ifval $hidelastscandisp = 0
    tr $CRLF $lastpreserved "0"
  endif
endif
GO end


# end                    ! all done!
