! 
! SPCT TCHNLGS 1996                                       09/21/96
! BoardList v3.0.596                                             File 1 of 5
! etaX Tested []
!
! This script only supports ANSI or higher graphics - NO ASCII. All versions
! of VBBS should work, but has not been tested.
!
! The source code will have a minimum amount of comments so it will require
! some experience with the script language to interpret it.
!
! Refer to the program documentation for installation procedures.
! Filename: BD_LIST.DOC
!
! BoardList v3.0         Copyright (c) 1996
! VBBS                   Copyright (c) 1991-1996  (by Roland De Graaf)
! All Rights Reserved
!
!  Notice 
!
! This script is property of Aspect Technologies and may not be changed in a
!    manner that eliminates its possession.  You may modify the script to
!    customize it for the sysop's needs as long as references to Aspect and
!    its affiliates are not changed or destroyed.  This script may be freely
!    distributed WITHOUT charge.
!
! Aspect Technologies expresses no warranties of any kind.  In no case will
!    Aspect Technologies be held liable for direct, indirect or incidental
!    damages resulting from any defect in this software.  Use at your own
!    risk.
!
!  History 
!
! Version 1.0   - First public release.
!  05/15/95     - New BBS listing script that allows users to advertise their
!                  BBS.  Displays phone number, BBS name, baud rate, and type
!                  of software used.
!               - Includes the download option.
!               - Fully graphical interface with scrolling menus.
!               - Sysop can create their own background for the main menu and
!                  set the coordinates for the main menu.
!
! Version 1.01  - Public release.
!  05/16/95     - Added configuration option to main menu.
!               - Corrected a documentation error.
!
! Version 1.03  - Non-public release.
!  05/20/95     - Fixed the advertisement problem, so when you view an ad, it
!                  will redisplay the entries that were on the screen.
!
! Version 2.0   - Public release.
!  05/25/95     - Added more help options, added sysop options: Delete entries,
!                  and Modify entries.
!
! Version 2.0.1 - Minor update to version 2.0.
!
! Version 2.1   - Non-public release.
!  06/05/95     - Redid the default background.
!               - Added 'true' remote arrow keys.
!               - It now allows multiple backgrounds to be made in the standard
!                  VBBS way: ANS, MNU, and RIP.
!                
! Version 2.2   - Public release.
!  06/13/95     - Added the sysop option of adding advertisements to existing
!                  entries.
!
! Version 2.5   - Public release.
!  07/28/95     - Fixed bugs that were caused when there are no entries in
!                  the list.
!
! Version 2.6   - Public release.
!  08/08/95     - Added option for 16800 baud rate.
!               - Shortened the code up a bit.
!               - Fixed a few errors in text.
!
! Version 2.61  - Public release.
!  08/12/95     - Fixed menu and display problem caused by the new features of
!                  version 2.6.
!
! Version 2.7   - Public release.
!  09/28/95     - Reformatted the source code.
!               - Added new BBSs to the add choice.
!               - Fixed menu problem.
!
! Version 3.0   - Public release.                
!  09/08/96     - Fixed installation error when VBBS directory was on a drive
!                  other than C:.
!               - Added full interactive menu to position main options menu.
!               - All menus now allow the use of arrow keys/numeric keypad.
!               - New option to delete existing advertisements.
!               - Fixed downloading bug: it now no longer includes heart-code
!                  in the text file.
!               - You may now use heart-code in the bbsname or description and
!                  get the full field of entry.
!               - Fixed a bug that has been present for a long time: when a
!                  new page started, the suppose to be first entry was cut off.
!               - Added sysop option to delete all entries.
!               - Added help bar to main menu. The sysop has three options:
!                  Top of screen, Bottom of screen, or disabled. Added sysop
!                  option to Sysop Options menu.
!               - Now when you delete an entry, any advertisement that went
!                  with it will be deleted as well.
!               - Added more information on the download screen.
!               - Added 'Return to BBS' message upon exit.
!
! 

! Aspect standard header file - required to compile
& "ASPECT.VH"

action "[ASPECT]  BoardList"

call Check_ANSI

suspendpagebreak

! Buffer Location (Do not change unless extremely necessary!)
$BUFFER = "B" & $port & ".TMP"

! Datafile location is in your \TXT directory called BD_LIST.TXT
$DATAFILE = $textpath & "BD_LIST.TXT"

! Configuration file location is in your \TXT directory called BD_LIST.CFG
$CONFIGFILE = $textpath & "BD_LIST.CFG"

! Temporary File location - Please do not change!
$TEMP = $textpath & "BDLIST." & $port
$TEMP2 = $textpath & "BDLIST2." & $port

tr $clear

menu "BD_LIST"

call Check_Config
call Get_Config

$x = $XMIN
$y = $YMIN

! Make the Options Menu
$location = 1
$option1 = "View the List of BBSs"
$option2 = "Add to the List of BBSs" 
$option3 = "Download the List of BBSs"
$option4 = "Online Help"
$option5 = "Quit BoardList"
$option6 = "Sysop Option Menu"

testval $HELPBAR = 0 menu
$status = 1
ifval $HELPBAR = 2 then
   $status = 24
endif
$status_y = $y
ifval $status_y = $status then
   call Find_Status
   call Status_Bar_Display
else
   call Status_Bar_Display
endif

# Menu
loc $y $x
tr "-Ŀ"
$y = $y + 1
loc $y $x
tr "  [0;34mBo[1mar[36md[37mLis[36mt [34mv3[0;34m.0  [1;37mOptions Menu [30m"
$y = $y + 1
loc $y $x
tr "- 1" $option1 "        -"
$y = $y + 1
loc $y $x
tr "- 9" $option2 "      -"
$y = $y + 1
loc $y $x
tr "- 9" $option3 "     "
$y = $y + 1
loc $y $x
tr "- 9" $option4 "                  -"
$y = $y + 1
loc $y $x
tr "0 9" $option5 "               0"
$y = $y + 1
ifval $security >= 255 then
   loc $y $x
   tr "0 9" $option6 "             "
else
   loc $y $x
   tr "0                               "
endif
$y = $y + 1
loc $y $x
tr "0                              "


# GetKey
loc 23 1
ts "0 "
loc 23 1
rc $key


# TestKey
if $key = $cr then
   testval $location = 1 View
   testval $location = 2 Link_Over
   testval $location = 3 Link_Over
   testval $location = 5 Exit_Script
   testval $location = 4 Boardlist_Link4
   testval $location = 6 Link_Over
endif

if $key = "" then
   ts $bs
   rc $key
   ts $bs
   rc $key
   loc 23 1
   ts "0 "
endif

$x = $XMIN + 2

test $key = Q Exit_Script
test $key = A Up
test $key = B Down
testval $key = 8 Up
testval $key = 2 Down
$key = $key asc 0
testval $key = 254 Up
testval $key = 253 Down
go GetKey


# Up
testval $location = 2 U_Location2
testval $location = 3 U_Location3
testval $location = 4 U_Location4
testval $location = 5 U_Location5
testval $location = 6 U_Location6
testval $security >= 255 U_Location1_C
go U_Location1


# Down
testval $location = 1 D_Location1
testval $location = 2 D_Location2
testval $location = 3 D_Location3
testval $location = 4 D_Location4
testval $location = 6 D_Location6
testval $security >= 255 D_Location5_C
go D_Location5


# U_Location1
$y = $YMIN + 2
loc $y $x
ts "9" $option1
$y = $y + 4
loc $y $x
ts "1" $option5
$location = 5
go GetKey

# U_Location1_C
$y = $YMIN + 2
loc $y $x
ts "9" $option1
$y = $y + 5
loc $y $x
ts "1" $option6
$location = 6
go GetKey

# U_Location2
$y = $YMIN + 3
loc $y $x
ts "9" $option2
$y = $y - 1
loc $y $x
ts "1" $option1
$location = 1
go GetKey

# U_Location3
$y = $YMIN + 4
loc $y $x
ts "9" $option3
$y = $y - 1
loc $y $x
ts "1" $option2
$location = 2
go GetKey

# U_Location4
$y = $YMIN + 5
loc $y $x
ts "9" $option4
$y = $y - 1
loc $y $x
ts "1" $option3
$location = 3
go GetKey

# U_Location5
$y = $YMIN + 6
loc $y $x
ts "9" $option5
$y = $y - 1
loc $y $x
ts "1" $option4
$location = 4
go GetKey

# U_Location6
$y = $YMIN + 7
loc $y $x
ts "9" $option6
$y = $y - 1
loc $y $x
ts "1" $option5
$location = 5
go GetKey


# D_Location1
$y = $YMIN + 2
loc $y $x
ts "9" $option1
$y = $y + 1
loc $y $x
ts "1" $option2
$location = 2
go GetKey

# D_Location2
$y = $YMIN + 3
loc $y $x
ts "9" $option2
$y = $y + 1
loc $y $x
ts "1" $option3
$location = 3
go GetKey

# D_Location3
$y = $YMIN + 4
loc $y $x
ts "9" $option3
$y = $y + 1
loc $y $x
ts "1" $option4
$location = 4
go GetKey

# D_Location4
$y = $YMIN + 5
loc $y $x
ts "9" $option4
$y = $y + 1
loc $y $x
ts "1" $option5
$location = 5
go GetKey

# D_Location5
$y = $YMIN + 6
loc $y $x
ts "9" $option5
$y = $y - 4
loc $y $x
ts "1" $option1
$location = 1
go GetKey

# D_Location5_C
$y = $YMIN + 6
loc $y $x
ts "9" $option5
$y = $y + 1
loc $y $x
ts "1" $option6
$location = 6
go GetKey

# D_Location6
$y = $YMIN + 7
loc $y $x
ts "9" $option6
$y = $y - 5
loc $y $x
ts "1" $option1
$location = 1
go GetKey


# Find_Status
$move = $status
ifval $y = 1 then
   $status = 24
else
   $status = 1
endif
ret


# Status_Bar_Display
ifval $move > 0 then
   loc $move 1
   ts "0                                                                                "
   $move = 0
endif
loc $status 1
ts "4      Use Numeric Keypad / Arrow Keys to Scroll Options  L  JEnter = Select      "
ret


# Check_Config
checkfile $here $CONFIGFILE
ifval $here = 0 then
   open $CONFIGFILE output
      write "25"
      write "14"
      write "1"
   close
endif
ret


# Get_Config
open $CONFIGFILE input
   read $XMIN
   read $YMIN
   read $HELPBAR
close
ret


# View
tr $clear

call View_Display

checkfile $here $DATAFILE
ifval $here = 0 then
   loc 24 1
   pause "9End of File U 9Press any key to continue. . ."
   go Boardlist_Link
endif

open $DATAFILE input

   # View_Loop
   read $line1

   $test = $line1 left 1
   test $test = ";" View_Loop

   test $line1 = "!EOF!" End_Of_File

   read $line2
   read $desc

   testval $row >= 23 End_Of_Screen

   # View_Loop_EOS
   $desc = $desc mid 4
   $desc = "- 0" & $desc
   $view_phone = $line2 left 16
   $ac = $view_phone mid 2 left 3
   $1p = $view_phone mid 7 left 3
   $2p = $view_phone mid 11
   $view_phone = "0(U" & $ac & "0) U"
   $view_phone = $view_phone & $1p & "0-U"
   $view_phone = $view_phone & $2p
   $view_other = $line2 mid 15

   call Re_Entry

   loc $row 3
   tr $view_phone
   loc $row 19
   tr "U" $line1
   loc $row 58
   tr "U" $view_other
   $row = $row + 1
   loc $row 5
   tr $desc
   tr
   $row = $row + 2
   go View_Loop

# View_End
close
go Boardlist_Link


# End_Of_File
$where = 1
loc 24 1
rc $prompt "9End of File U [1AU]9dvertisements U 9Press any key to continue. . ."
test $prompt = A BBS_Ad
go View_End


# End_Of_Screen
$where = 2
loc 24 1
rc $prompt "U[1QU]9uit U[1AU]9dvertisements U 9Press any key to continue. . ."
test $prompt = Q View_End
test $prompt = A BBS_Ad

call Clear_Var
call View_Display

go View_Loop_EOS


# Re_Entry
ifval $row = 4 then
   $ph1 = $view_phone
   $li1 = $line1
   $ot1 = $view_other
   $de1 = $desc
endif
ifval $row = 7 then
   $ph2 = $view_phone
   $li2 = $line1
   $ot2 = $view_other
   $de2 = $desc
endif
ifval $row = 10 then
   $ph3 = $view_phone
   $li3 = $line1
   $ot3 = $view_other
   $de3 = $desc
endif
ifval $row = 13 then
   $ph4 = $view_phone
   $li4 = $line1
   $ot4 = $view_other
   $de4 = $desc
endif
ifval $row = 16 then
   $ph5 = $view_phone
   $li5 = $line1
   $ot5 = $view_other
   $de5 = $desc
endif
ifval $row = 19 then
   $ph6 = $view_phone
   $li6 = $line1
   $ot6 = $view_other
   $de6 = $desc
endif
ifval $row = 22 then
   $ph7 = $view_phone
   $li7 = $line1
   $ot7 = $view_other
   $de7 = $desc
endif
ret


# Clear_Var
$ph1 = ""
$li1 = ""
$ot1 = ""
$de1 = ""
$ph2 = ""
$li2 = ""
$ot2 = ""
$de2 = ""
$ph3 = ""
$li3 = ""
$ot3 = ""
$de3 = ""
$ph4 = ""
$li4 = ""
$ot4 = ""
$de4 = ""
$ph5 = ""
$li5 = ""
$ot5 = ""
$de5 = ""
$ph6 = ""
$li6 = ""
$ot6 = ""
$de6 = ""
$ph7 = ""
$li7 = ""
$ot7 = ""
$de7 = ""
ret


# ReDisplay
tr $clear

call View_Display

if $ph1 <> "" then
   loc $row 3
   tr $ph1
   loc $row 19
   tr $li1
   loc $row 58
   tr $ot1
   $row = $row + 1
   loc $row 5
   tr $de1
   $row = $row + 2
endif
if $ph2 <> "" then
   loc $row 3
   tr $ph2
   loc $row 19
   tr $li2
   loc $row 58
   tr $ot2
   $row = $row + 1
   loc $row 5
   tr $de2
   $row = $row + 2
endif
if $ph3 <> "" then
   loc $row 3
   tr $ph3
   loc $row 19
   tr $li3
   loc $row 58
   tr $ot3
   $row = $row + 1
   loc $row 5
   tr $de3
   $row = $row + 2
endif
if $ph4 <> "" then
   loc $row 3
   tr $ph4
   loc $row 19
   tr $li4
   loc $row 58
   tr $ot4
   $row = $row + 1
   loc $row 5
   tr $de4
   $row = $row + 2
endif
if $ph5 <> "" then
   loc $row 3
   tr $ph5
   loc $row 19
   tr $li5
   loc $row 58
   tr $ot5
   $row = $row + 1
   loc $row 5
   tr $de5
   $row = $row + 2
endif
if $ph6 <> "" then
   loc $row 3
   tr $ph6
   loc $row 19
   tr $li6
   loc $row 58
   tr $ot6
   $row = $row + 1
   loc $row 5
   tr $de6
   $row = $row + 2
endif
if $ph7 <> "" then
   loc $row 3
   tr $ph7
   loc $row 19
   tr $li7
   loc $row 58
   tr $ot7
   $row = $row + 1
   loc $row 5
   tr $de7
   $row = $row + 2
endif

testval $where = 1 End_Of_File
testval $where = 2 End_Of_Screen


# BoardList_Link
link BD_LIST

# BoardList_Link2
link BD_LIST2

# BoardList_Link3
link BD_LIST3

# BoardList_Link4
link BD_LIST4


# View_Display
$row = 4
tr $clear
tr "[?7h[40m[2J[0;1;30m[0m[1;30mĿ[19C[0;34mSP[1mC[36mT T[37mCHN[36mL[34mG[0;34mS [1;37m [0;34mBo[1mar[36md[37mLis[36mt [34mv3[0;34m.0[22C[1;30m [0m[36mPhone Number[37m  [36mBulletin Board System Name[37m  [36mBaud[37m  [36mSoftware[37m [1;30m[78C[78C[78C[79C[78C[79C[79C[78C[0m[1;30m[78C[0m[78C[78C"
tr "[78C"
tr
tr "[0m[255D"
ret


# BBS_Ad
loc 24 1
ts "9Enter the entry phone number you would like to see advertised: U(R   U)0 R   U-R    "

# Ad_1
loc 24 65
$choice = "1234567890" & $cr
rr $p1 $choice "5"
test $p1 = $cr ReDisplay

# Ad_2
loc 24 66
rr $p2 1234567890 "5"
if $p2 =  then
   loc 24 65
   ts "R "
   go Ad_1
endif

# Ad_3
loc 24 67
rr $p3 1234567890 "5"
if $p3 =  then
   loc 24 66
   ts "R "
   go Ad_2
endif

# Ad_4
loc 24 70
rr $p4 1234567890 "5"
if $p4 =  then
   loc 24 67
   ts "R "
   go Ad_3
endif

# Ad_5
loc 24 71
rr $p5 1234567890 "5"
if $p5 =  then
   loc 24 70
   ts "R "
   go Ad_4
endif

# Ad_6
loc 24 72
rr $p6 1234567890 "5"
if $p6 =  then
   loc 24 71
   ts "R "
   go Ad_5
endif

# Ad_7
loc 24 74
rr $p7 1234567890 "5"
if $p7 =  then
   loc 24 72
   ts "R "
   go Ad_6
endif

# Ad_8
loc 24 75
rr $p8 1234567890 "5"
if $p8 =  then
   loc 24 74
   ts "R "
   go Ad_7
endif

# Ad_9
loc 24 76
rr $p9 1234567890 "5"
if $p9 =  then
   loc 24 75
   ts "R "
   go Ad_8
endif

# Ad_10
loc 24 77
rr $p10 1234567890 "5"
if $p10 =  then
   loc 24 76
   ts "R "
   go Ad_9
endif

$ad = $textpath & $p4 & $p5
$ad = $ad & $p6 & $p7
$ad = $ad & $p8 & $p9
$ad = $ad & $p10 & "."
$ad = $ad & $p1 & $p2
$ad = $ad & $p3

checkfile $here $ad
ifval $here <> 0 then
   tr $clear
   ef $ad
   loc 24 1
   pause "9Press any key to continue. . ."
else
   tr
   tr "1Advertisement missing."
   delay 3
endif

go ReDisplay


# Link_Over
ifval $location = 2 then
   open $TEMP output
      write "ADD"
   close
   go Boardlist_Link2
endif
ifval $location = 3 then
   open $TEMP output
      write "DOWNLOAD"
   close
   go Boardlist_Link4
endif
open $TEMP output
   write "CONFIG"
close
go Boardlist_Link3
