/*****************************************************************************/
/*                                                                           */
/*                 (C) Copyright 1991-1997  Alberto Pasquale                 */
/*                 (C) Copyright 1999       Paul Kourochka                   */
/*                                                                           */
/*                   A L L   R I G H T S   R E S E R V E D                   */
/*                                                                           */
/*****************************************************************************/
/*                                                                           */
/*   How to contact the author:  Paul Kourochka of 2:464/52@fidonet          */
/*                               nefpk@nefpk.8m.com                          */
/*                               Murmanskaja str, 2-28                       */
/*                               320098 Dniepropetrovsk                      */
/*                               Ukraine                                     */
/*                                                                           */
/*****************************************************************************/

// feature.c

// This is a sample source for a NEF Feature DLL.
// It only writes to the screen the full filename, tag and desc of
// tossed files.
// A prefix can be specified with the "OutPrefix" cfg statement; example:
// OutPrefix "New File: "


#include <string.h>
#include "NeFeat.H"


static	FeatOut	pf;		// function for output to screen and log
static	char	outpref[100];


APIRET FEATAPIENTRY Init (FeatOut prnf)
{
	pf = prnf;
			// default output prefix
	strcpy (outpref, "New File: ");
	return NFI_OK;
}


APIRET FEATAPIENTRY ParseCfg (PCSZ clnline)
{
	const char *p;
	int len;

	if (strnicmp (clnline, "OutPrefix ", 10) == 0) {
		p = clnline;
		p += 10;		// skip the keyword
		p += strspn (p, " ");	// skip space(s)

		if (*p != '\"') return NFP_ERR;
		++p;			// skip opening quotes
		len = strlen (p);
		if (len == 0) return NFP_ERR;
		if (*(p+len-1) != '"') {// check closing quotes
			return NFP_ERR;
		}
		--len;
					// store format string in static data
		strncpy (outpref, p, len);
		outpref[len] = '\0';
		return NFP_OK;
	}
	return NFP_ERR;
}


APIRET FEATAPIENTRY BeforeNefToss (PCSZ fullname, PCSZ Tag, PCSZ Desc)
{
	pf (FO_BOTH, '*', "%s%s %s\n", outpref, fullname, Tag);
	return BNT_OK;
}


APIRET FEATAPIENTRY BeforeNefHatch (PCSZ fullname, _TICDATA const * td)
{
	pf (FO_BOTH, '*', "%s%s %s\n", outpref, fullname, td->areatag);
	return BNT_OK;
}


APIRET FEATAPIENTRY AfterNefToss (_TICDATA const * td)
{
	pf (FO_BOTH, ' ', "%s\n", td->desc);
	return ANT_OK;
}
