@echo off
rem
rem Newfie -- A NEWFILES.DAT posting program
rem Copyright (c) 1994 by Bruce A. Bergman.  All rights reserved.
rem This is v1.0a, dated 03-Sep-94.
rem
rem This program will search for Synchronet NEWFILES.DAT files that
rem are transferred with QWK packets from other systems.  If one is
rem found, it will be posted to the specified subgroup.
rem
rem Usage: newfie [DATA path] [internal name] [site name] ( [site name] ... )
rem
rem Where: [DATA path]     is the FULL path to the SBBS\DATA directory.
rem        [internal name] is the Synchronet internal name of the subgroup
rem                        that the located file should be posted to.
rem        [site name]     is the name of one or more sites to check.  Each
rem                        site name must be the QWK name of the other system.
rem
rem Example: newfie d:\sbbs\data sys-newf SITE1 SITE2 SITE3
rem

if "%1" == "/?" goto USAGE
if "%1" == "?" goto USAGE
if "%3" == "" goto USAGE

set sbbsctrl=
set dszlog=
set sbbsnnum=

set p1=%1
set p2=%2

if "%sbbsnode%" == "" goto NO_NODEVAR

cd %sbbsnode%\TEMP


rem
rem Top of DO..LOOP
rem

:TOP_OF_LOOP
if "%3" == "" goto END

set p3=%3

if exist %p1%\qnet\%p3%.in\newfiles.dat goto FOUND

echo No work to do for %p3%
echo.

goto BOT_OF_LOOP


rem
rem A matching file was found, so post it
rem

:FOUND
del newfie.inp    >nul

echo All                    >newfie.inp
echo NEWFILES daemon       >>newfie.inp
echo %p3% NEWFILES Listing >>newfie.inp

smbutil i%p1%\qnet\%p3%.in\newfiles.dat %p1%\subs\%p2%.shd <newfie.inp

del newfie.inp    >nul
del %p1%\qnet\%p3%.in\newfiles.dat    > nul

echo Imported NEWFILES.DAT file from %p3%
echo.


rem
rem Bottom of DO..LOOP
rem

:BOT_OF_LOOP
shift

goto TOP_OF_LOOP


rem
rem SBBSNODE not set -- complain
rem

:NO_NODEVAR
echo The environment variable SBBSNODE *must* be set in order to use
echo this program.  Please set it and re-run this program.
echo.

goto END


rem
rem Incorrect/improper command line, so display a usage message
rem

:USAGE
echo Usage: newfie [DATA path] [internal name] [site name] ( [site name] ... )
echo.

:END
