{
          
                
              The DoorKit!
              
             
The BBS Door Development Kit By The People - For The People!


   Feel free to modify or optimize this code at will. All I ask is that if
   find a better way to do things (and you will), please send me a copy of
   your modifications. Thanks in advance!....Larry L. Athey....



NOTE: This door requires Async Professional for DOS before you can
      compile it.  The MAX_UPD.PAS unit can be easily modified for
      use with any other protocol library or any external protocol
      driver such as PDrive, DSZ, GSZ, CEXY, Etc.}

{$A+,B-,D+,E+,F+,G+,I-,L+,N-,O+,P-,Q-,R-,S-,T-,V+,X+}
UNIT MAX_UPD;

INTERFACE

USES _EXIT,CRT,DOS,TDK_VARS,APVARS,__TEXT,_PROTO,
     MAX_UNIT,DOORKIT1,DOORKIT2,DOORKIT3;

VAR
  TheTerminal : STRING[80];
  NewExe      : STRING[80];
  NewOvr      : STRING[80];
  Version     : STRING[4];
  HomeDir     : STRING[67];
  WorkPath    : STRING[80];
  DropRIP     : BOOLEAN;
  NewTerm     : BOOLEAN;
  DropIt      : BOOLEAN;
  Count       : LONGINT;
  DT          : BYTE;

PROCEDURE ReadCfg;
PROCEDURE MaxUpdate;

IMPLEMENTATION

PROCEDURE DoThePort;
BEGIN
  DoTextColors;
  Colours.WindowHeaderForeE := 15;
  Colours.WindowHeaderBack := 3;
  IF Ctl.UseFossil THEN CommDef.Device := 2
                   ELSE CommDef.Device := 1;
  IF Ctl.UseDigi THEN CommDef.Device := 3;
  IF Ctl.NSP THEN CommDef.Port := Ctl.Port
             ELSE CommDef.Port := DoorSys.ComPort;
  IF Ctl.NSP THEN CommDef.PortAddr := Ctl.HexAddr
             ELSE CommDef.PortAddr := '0';
  IF Ctl.NSP THEN CommDef.IRQ := Ctl.IRQ
             ELSE CommDef.IRQ := 0;
  ActualBaud := DoorSys.BaudRate;
END;

PROCEDURE SendFiles(FTP : BYTE ; TheFile : STRING);
VAR
  Protocol : STRING[10];
BEGIN
  IF Graphics <> MAX THEN BEGIN
    CASE FTP OF
      1 : Protocol := 'Zmodem';
      2 : Protocol := 'Xmodem';
      3 : Protocol := 'Xmodem-1K';
      4 : Protocol := 'Ymodem';
      5 : Protocol := 'Ymodem-G';
    END;
    sClrScr;
    IceText('Start Your ' + Protocol + ' Download Now!',TRUE);
    IceText('Press CTRL-X Several Times To Abort.',TRUE);
  END;
  Wait(2);
  ShowStatusBar;
  AbortedProtocol := FALSE;
  WeAbort         := FALSE;
  IF Comm_Init THEN BEGIN
    IF FTP IN [1,4,5] THEN TransmitFiles('',FTP)
                      ELSE TransmitFiles(TheFile,FTP);
  END;
  DoorSys.IdleCount := 0;
  UpdateTime;
  ShowStatusBar;
  PurgeInput;
  PurgeOutput;
  IF DataAvailable THEN WHILE DataAvailable DO GetChar;
END;

PROCEDURE FixScreen(FName : STRING);
VAR
  Txt1 : TEXT;
  Txt2 : TEXT;
  St   : STRING;
  Hide : WORD;
  Show : WORD;
BEGIN
  Hide := 0;
  Show := 0;
  IF NOT FExist(FName + '.MAX') THEN EXIT;
  ASSIGN(Txt1,FName + '.MAX');
  ASSIGN(Txt2,FName + '.MA_');
  RESET(Txt1);
  REWRITE(Txt2);
  WHILE NOT EOF(Txt1) DO BEGIN
    READLN(Txt1,St);
    St := StripBoth(St,' ');
    IF (St = '~') OR (AllCaps(St) = 'START_SCREEN()') THEN St := '~';
    IF ((St = '~') OR (AllCaps(St) = 'END_SCREEN()')) AND (Show = 0) THEN BEGIN
      WRITELN(Txt2,'~');
      INC(Show);
    END;
    IF St = '~' THEN INC(Hide);
    IF St = '~' THEN INC(Show);
    IF (St = '~') AND (St <> #12) AND (Hide = 1) THEN WRITELN(Txt2,St);
    IF (St = '~') AND (St <> #12) AND (Show = 1) THEN WRITELN(Txt2,St);
    IF (St <> '~') AND (St <> '~') AND (St <> #12) THEN WRITELN(Txt2,St);
  END;
  CLOSE(Txt1);
  CLOSE(Txt2);
  ERASE(Txt1);
  CopyFile(FName + '.MA_',FName + '.MAX');
  ERASE(Txt2);
END;

PROCEDURE SystemScreen(FName : STRING);
VAR
  OldGraphics : BYTE;
BEGIN
  OldGraphics := Graphics;
  IF Graphics = RIP THEN BEGIN
    IF NOT FExist(FName + '.RIP') THEN BEGIN
      RipToText;
      Graphics := ANSI;
    END;
  END;
  IF Graphics = MAX THEN BEGIN
    IF NOT FExist(FName + '.MAX') THEN BEGIN
      RipToText;
      Graphics := ANSI;
    END;
  END;
  IF (Graphics = AVATAR) AND (NOT FExist(FName + '.AVT')) THEN Graphics := ANSI;
  IF (Graphics = ANSI) AND (NOT FExist(FName + '.ANS')) THEN Graphics := TTY;
  IF Graphics <> MAX THEN sClrScr;
  CASE Graphics OF
    RIP    : ShowScreen(FName + '.RIP');
    MAX    : ShowScreen(FName + '.MAX');
    AVATAR : ShowScreen(FName + '.AVT');
    ANSI   : ShowScreen(FName + '.ANS');
    TTY    : BEGIN
               Set_Color(7,0);
               ShowScreen(FName + '.ASC');
             END;
  END;
  Graphics := OldGraphics;
END;

PROCEDURE CleanUpWorkDirectory; Far;
VAR
  WorkFile : STRING[12];
  DirInfo  : SEARCHREC;
BEGIN
  CHDIR(NoPath(WorkPath));
  FINDFIRST('*.*',Anyfile - Directory - VolumeID,DirInfo);
  WHILE DOSERROR = 0 DO BEGIN
    WorkFile := AllCaps(DirInfo.Name);
    FErase(WorkFile);
    FINDNEXT(DirInfo);
  END;
  CHDIR(HomeDir);
END;

FUNCTION GetProtocol : BYTE;
VAR
  Ch   : CHAR;
  Done : BOOLEAN;
BEGIN
  Done := FALSE;
  SystemScreen('PROTOCOL');
  IF Graphics <> MAX THEN sWrite(' ');
  REPEAT
    Ch := UPCASE(sReadKey);
    OutTxt(15,0,Ch);
    CASE Ch OF
      '1' : BEGIN
              GetProtocol := 1;
              Done        := TRUE;
              Log('ZModem Protocol Selected');
            END;
      '2' : BEGIN
              GetProtocol := 4;
              Done        := TRUE;
              Log('YModem Protocol Selected');
            END;
      '3' : BEGIN
              GetProtocol := 5;
              Done        := TRUE;
              Log('YModem-G Protocol Selected');
            END;
      '4' : BEGIN
              GetProtocol := 2;
              Done        := TRUE;
              Log('XModem Protocol Selected');
            END;
      '5' : BEGIN
              GetProtocol := 3;
              Done        := TRUE;
              Log('XModem-1K Protocol Selected');
            END;
      #13 : SystemScreen('PROTOCOL');
      'Q' : BEGIN
              GetProtocol := 0;
              Done        := TRUE;
            END;
    END;
  UNTIL Done;
END;

PROCEDURE RipProcess;
VAR
  Ch : CHAR;
  P  : BYTE;
BEGIN
  RipToText;
  Graphics := ANSI;
  Log('Informing RIPterm Caller Of MAXterm Policy');
  SystemScreen('RIPTERM');
  sWrite(' ');
  REPEAT Ch := UPCASE(sReadKey) UNTIL Ch IN ['D','H','Q'];
  OutTxt(15,0,Ch);
  CASE Ch OF
    'D' : BEGIN
            P := GetProtocol;
            IF P <> 0 THEN BEGIN
              FileQueue[1] := TheTerminal;
              FilesInQueue := 1;
              IF P IN [2,3] THEN SendFiles(P,TheTerminal) ELSE SendFiles(P,'');
            END;
            IF DropRIP THEN _HangUp := TRUE;
            HALT(ErrLevel);
          END;
    'H' : BEGIN
            _HangUp := TRUE;
            HALT(ErrLevel);
          END;
    'Q' : BEGIN
            IF DropRIP THEN _HangUp := TRUE;
            HALT(ErrLevel);
          END;
  END;
END;

PROCEDURE AddToMaxQueue(TheFile : STRING);
VAR
  ULQ : TEXT;
BEGIN
  ASSIGN(ULQ,WorkPath + 'ULQUEUE.TXT');
  IF NOT FExist(WorkPath + 'ULQUEUE.TXT') THEN BEGIN
    REWRITE(ULQ);
    CLOSE(ULQ);
  END;
  APPEND(ULQ);
  WRITELN(ULQ,TheFile);
  CLOSE(ULQ);
END;

FUNCTION RemoteHasIt(TheFile,TheCrc : STRING) : BOOLEAN;
VAR
  TFile   : TEXT;
  ResFile : STRING[12];
  ResCrc  : STRING[8];
  Temp    : STRING;
  DoFile  : BOOLEAN;
  DoCrc   : BOOLEAN;
  Loop    : BYTE;
BEGIN
  RemoteHasIt := FALSE;
  IF FExist(HomeDir + '\RES.' + IntToStr(DoorSys.Node)) THEN BEGIN
    ASSIGN(TFile,HomeDir + '\RES.' + IntToStr(DoorSys.Node));
    RESET(TFile);
    WHILE NOT EOF(TFile) DO BEGIN
      ResFile := '';
      ResCrc  := '';
      DoFile  := TRUE;
      DoCrc   := FALSE;
      READLN(TFile,Temp);
      Temp := StripBoth(AllCaps(Temp),' ');
      FOR Loop := 1 TO LENGTH(Temp) DO BEGIN
        IF Temp[Loop] = ' ' THEN BEGIN
          DoFile := FALSE;
          DoCrc  := TRUE;
        END;
        IF (DoFile) AND (Temp[Loop] <> ' ') THEN ResFile := ResFile + Temp[Loop];
        IF (DoCrc) AND (Temp[Loop] <> ' ') THEN ResCrc := ResCrc + Temp[Loop];
      END;
      IF ResCrc = '' THEN ResCrc := 'XXXXXXXX';
      IF (ResFile = TheFile) AND (ResCrc = TheCrc) THEN BEGIN
        RemoteHasIt := TRUE;
        CLOSE(TFile);
        EXIT;
      END;
    END;
    CLOSE(TFile);
    MaxCommand('}' + #39 + TheFile + #39 + '');
  END;
END;

FUNCTION CheckResources(StuffIt : BOOLEAN) : BOOLEAN;
VAR
  DirList : TEXT;
  ResList : TEXT;
  ResFile : STRING[12];
  ResCrc  : STRING[8];
  TheDir  : STRING;
  Temp    : STRING;
  DoFile  : BOOLEAN;
  DoCrc   : BOOLEAN;
  Loop    : BYTE;
BEGIN
  Count          := 0;
  CheckResources := FALSE;
  ASSIGN(DirList,'DIR.LST');
  RESET(DirList);
  WHILE NOT EOF(DirList) DO BEGIN
    READLN(DirList,TheDir);
    TheDir := NoPath(TheDir);
    CHDIR(TheDir);
    IF FExist('RESOURCE.LST') THEN BEGIN
      ASSIGN(ResList,'RESOURCE.LST');
      RESET(ResList);
      WHILE NOT EOF(ResList) DO BEGIN
        ResFile := '';
        ResCrc  := '';
        DoFile  := TRUE;
        DoCrc   := FALSE;
        READLN(ResList,Temp);
        Temp := StripBoth(AllCaps(Temp),' ');
        FOR Loop := 1 TO LENGTH(Temp) DO BEGIN
          IF Temp[Loop] = ' ' THEN BEGIN
            DoFile := FALSE;
            DoCrc  := TRUE;
          END;
          IF (DoFile) AND (Temp[Loop] <> ' ') THEN ResFile := ResFile + Temp[Loop];
          IF (DoCrc) AND (Temp[Loop] <> ' ') THEN ResCrc := ResCrc + Temp[Loop];
        END;
        IF (NOT RemoteHasIt(ResFile,ResCrc)) AND (FExist(ResFile)) THEN BEGIN
          INC(Count);
          CheckResources := TRUE;
          IF StuffIt THEN BEGIN
            CopyFile(ResFile,WorkPath + ResFile);
            AddToMaxQueue(WorkPath + ResFile);
            IF ResFile = 'BACKDROP.MAX' THEN DropIt := TRUE;
          END;
        END;
      END;
      CLOSE(ResList);
    END;
    CHDIR(HomeDir);
  END;
  CLOSE(DirList);
END;

FUNCTION CheckOneList(StuffIt : BOOLEAN) : BOOLEAN;
VAR
  ResList : TEXT;
  ResFile : STRING[12];
  ResCrc  : STRING[8];
  TheDir  : STRING;
  Temp    : STRING;
  DoFile  : BOOLEAN;
  DoCrc   : BOOLEAN;
  Loop    : BYTE;
BEGIN
  Count        := 0;
  CheckOneList := FALSE;
  IF FExist(MiscFile) THEN BEGIN
    CHDIR(NoPath(GetFilePath(MiscFile)));
    ASSIGN(ResList,MiscFile);
    RESET(ResList);
    WHILE NOT EOF(ResList) DO BEGIN
      ResFile := '';
      ResCrc  := '';
      DoFile  := TRUE;
      DoCrc   := FALSE;
      READLN(ResList,Temp);
      Temp := StripBoth(AllCaps(Temp),' ');
      FOR Loop := 1 TO LENGTH(Temp) DO BEGIN
        IF Temp[Loop] = ' ' THEN BEGIN
          DoFile := FALSE;
          DoCrc  := TRUE;
        END;
        IF (DoFile) AND (Temp[Loop] <> ' ') THEN ResFile := ResFile + Temp[Loop];
        IF (DoCrc) AND (Temp[Loop] <> ' ') THEN ResCrc := ResCrc + Temp[Loop];
      END;
      IF (NOT RemoteHasIt(ResFile,ResCrc)) AND (FExist(ResFile)) THEN BEGIN
        INC(Count);
        CheckOneList := TRUE;
        IF StuffIt THEN BEGIN
          CopyFile(ResFile,WorkPath + ResFile);
          AddToMaxQueue(WorkPath + ResFile);
          IF ResFile = 'BACKDROP.MAX' THEN DropIt := TRUE;
        END;
      END;
    END;
    CLOSE(ResList);
  END;
  CHDIR(HomeDir);
END;

PROCEDURE QueryTerminal;
VAR
  TFile   : TEXT;
  ResFile : STRING[12];
BEGIN
  SendStr(#13#10);
  SendStr(#12#13#10);
  MaxCommand('~19');
  NoKill := TRUE;
  FixScreen('QUERY1');
  SystemScreen('QUERY1');
  Log('Getting Remote System Information');
  Wait(3);
  MaxCommand('}');
  Wait(3);
  NoKill := TRUE;
  FixScreen('QUERY2');
  SystemScreen('QUERY2');
  Log('Getting Remote System Resource List');
  Wait(3);
  MaxCommand('}');
  Wait(3);
  IF FExist('KILL.LST') THEN BEGIN
    ASSIGN(TFile,'KILL.LST');
    RESET(TFile);
    WHILE NOT EOF(TFile) DO BEGIN
      READLN(TFile,ResFile);
      ResFile := StripBoth(AllCaps(ResFile),' ');
      MaxCommand('}' + #39 + ResFile + #39 + '');
    END;
    CLOSE(TFile);
  END;
  MaxCommand('~0');
  SendStr(#13#10);
  SendStr(#12#13#10);
END;

PROCEDURE CheckTerminal;
VAR
  Info : TEXT;
  St   : STRING;
BEGIN
  Count    := 0;
  NewTerm  := TRUE;
  ShowLog  := TRUE;
  TextAttr := 7;
  CLRSCR;
  IF FExist('REMOTE.' + IntToStr(DoorSys.Node)) THEN BEGIN
    ASSIGN(Info,'REMOTE.' + IntToStr(DoorSys.Node));
    RESET(Info);
    WHILE NOT EOF(Info) DO BEGIN
      INC(Count);
      READLN(Info,St);
      IF (Count = 2) AND (POS(Version,St) > 0) THEN NewTerm := FALSE;
      Log(St);
    END;
    CLOSE(Info);
  END;
  IF NewTerm THEN BEGIN
    Log('Outdated MAXterm Program Detected');
    SystemScreen('BADTERM');
    sReadKey;
    SendStr(#13#10);
    SendStr(#12#13#10);
    Log('Updating Remote Caller''s MAXterm Program');
    FileQueue[1] := NewExe;
    FileQueue[2] := NewOvr;
    FilesInQueue := 2;
    ShowLog      := FALSE;
    SendFiles(1,'');
  END;
END;

PROCEDURE DoMaxFiles;
VAR
  Info : TEXT;
  St   : STRING;
  Ch   : CHAR;
BEGIN
  ShowLog := TRUE;
  SystemScreen('UPDATEYN');
  REPEAT Ch := UPCASE(sReadKey) UNTIL Ch IN ['Y','N'];
  IF Ch = 'N' THEN BEGIN
    IF NewTerm THEN BEGIN
      _HangUp := TRUE;
      ShowLog := FALSE;
      RipToText;
      HALT(ErrLevel);
    END;
    Log('Caller Aborted Full Resource Update Process');
    ShowLog := FALSE;
    HALT(ErrLevel);
  END ELSE Log('Running Full Resource Update Process');
  MaxCommand('~19');
  SystemScreen('UDNOTICE');
  Log('Comparing Remote and Local Resource Lists');
  IF MiscFile = '' THEN CheckResources(TRUE);
  IF MiscFile <> '' THEN CheckOneList(TRUE);
  Log('Sending ' + IntToStr(Count) + ' Resource Files Via Zmodem');
  ASSIGN(Info,WorkPath + 'ULQUEUE.TXT');
  RESET(Info);
  MaxCommand('}');
  Wait(2);
  MaxCommand('}');
  FilesInQueue := 0;
  ShowLog      := FALSE;
  WHILE NOT EOF(Info) DO BEGIN
    INC(FilesInQueue);
    READLN(Info,FileQueue[FilesInQueue]);
    IF FilesInQueue = 15 THEN BEGIN
      SendFiles(1,'');
      FILLCHAR(FileQueue,SIZEOF(FileQueue),0);
      FilesInQueue := 0;
    END;
  END;
  CLOSE(Info);
  IF FilesInQueue > 0 THEN SendFiles(1,'');
  MaxCommand('}');
  Wait(2);
  MaxCommand('}');
  MaxCommand('~0');
  MaxCommand('}');
  IF Count > 0 THEN BEGIN
    IF (WeAbort) OR (AbortedProtocol) THEN BEGIN
      SystemScreen('UPD_FAIL');
      sReadKey;
    END ELSE BEGIN
      IF (DropIt) OR (NewTerm) THEN SystemScreen('UPD_DROP') ELSE SystemScreen('UPD_DONE');
      sReadKey;
    END;
  END;
  ShowLog := FALSE;
  CleanUpWorkDirectory;
  IF (DropIt) OR (NewTerm) THEN BEGIN
    IF NewTerm THEN BEGIN
      SystemScreen('TERMNOTE');
      sReadKey;
    END;
    _HangUp := TRUE;
    RipToText;
  END;
  Wait(5);
  WINDOW(1,1,80,25);
  HALT(ErrLevel);
END;

PROCEDURE AnsiTtyProcess;
VAR
  Ch : CHAR;
  P  : BYTE;
BEGIN
  CASE Graphics OF
    AVATAR : Insert1 := 'AVATAR';
    ANSI   : Insert1 := 'ANSI';
    TTY    : Insert1 := 'ASCII';
    RIP    : Insert1 := 'RIP';
  END;
  Log('Offering MAXterm To ' + Insert1 + ' Caller');
  SystemScreen('MAXTERM');
  sWrite(' ');
  REPEAT Ch := UPCASE(sReadKey) UNTIL Ch IN ['Y','N'];
  OutTxt(15,0,Ch);
  IF (NOT Local) AND (Ch = 'Y') THEN BEGIN
    P := GetProtocol;
    IF P <> 0 THEN BEGIN
      Log('Caller Downloading MAXterm');
      FileQueue[1] := TheTerminal;
      FilesInQueue := 1;
     IF P IN [2,3] THEN SendFiles(P,TheTerminal) ELSE SendFiles(P,'');
    END;
  END;
  IF Ch = 'N' THEN Log(Insert1 + ' Caller Declined MAXterm Offer');
  HALT(ErrLevel);
END;

PROCEDURE ReadCfg;
VAR
  Cfg   : TEXT;
  DTstr : STRING[3];
BEGIN
  IF NOT FExist('UP_DOOR.CFG') THEN ErrorLog('CRITICAL ERROR: UP_DOOR.CFG IS MISSING!',6,TRUE);
  DropRIP := FALSE;
  ASSIGN(Cfg,'UP_DOOR.CFG');
  RESET(Cfg);
  READLN(Cfg,DTstr); DT := StrToInt(DTstr);
  READLN(Cfg,Version);
  READLN(Cfg,TheTerminal);
  READLN(Cfg,NewExe);
  READLN(Cfg,NewOvr);
  READLN(Cfg,LogPath);
  READLN(Cfg,LogFile);
  READLN(Cfg,DTstr);
  IF POS('Y',AllCaps(DTstr)) > 0 THEN DropRIP := TRUE;
  CLOSE(Cfg);
  LogPath := CvtVars(LogPath);
  LogFile := CvtVars(LogFile);
END;

PROCEDURE MaxUpdate;
BEGIN
  DropIt  := FALSE;
  NewTerm := FALSE;
  GETDIR(0,HomeDir);
  WorkPath := HomeDir + '\WORK' + IntToStr(DoorSys.Node) + '\';
  MakeDir(WorkPath);
  AddToExitChain(CleanUpWorkDirectory);
  ReadCfg;
  MaxID := Version;
  CleanUpWorkDirectory;
  DoThePort;
  IF Graphics = RIP THEN RipProcess ELSE
  IF Graphics = MAX THEN BEGIN
    IF NOT FExist('DIR.LST') THEN ErrorLog('CRITICAL ERROR: DIR.LST IS MISSING!',6,TRUE);
    ShowProgramAd;
    WINDOW(1,6,80,24);
    QueryTerminal;
    CheckTerminal;
    IF MiscFile = '' THEN BEGIN
      IF CheckResources(FALSE) THEN BEGIN
        Log('Update Method: Complete DIR.LST/RESOURCE.LST');
        Log('Remote Needs ' + IntToStr(Count) + ' Resource Files');
        DoMaxFiles;
      END;
    END ELSE BEGIN
      IF CheckOneList(FALSE) THEN BEGIN
        Log('Update Method: Singular RESOURCE.LST');
        Log('Remote Needs ' + IntToStr(Count) + ' Resource Files');
        DoMaxFiles;
      END;
    END;
    IF NewTerm THEN BEGIN
      SystemScreen('TERMNOTE');
      sReadKey;
      _HangUp := TRUE;
      RipToText;
      Wait(5);
      WINDOW(1,1,80,25);
      HALT(ErrLevel);
    END;
  END ELSE AnsiTtyProcess;
END;

END.
