{

              
            
               ͻ ͻ ͻ    ͻ ͻ
                    ˼ ͹ ͼ ͹     ͻ
                   ͼ          ͼ ͼ

  The Universal Multimedia Interface For BBS Software
  Copyright 1995-1997 * Larry L. Athey * BBS Utiliteez Software


  Information Regarding MAX Graphics:
  
  Notice is hereby given that the MAXscript/MAXcontrol/MAXcolor language,
  and MAXterm are products of BBS Utiliteez Software and are protected by
  US copyrights listed with the US Library Of Congress (1996)....

  No changes, additions, subtractions, or other modifications shall be made
  to MAXscript/MAXcontrol/MAXcolor language or the MAX Graphics development
  kit without express written permission from Larry L. Athey, BBS Utiliteez
  Software, Alliance, Nebraska, USA....

  The MAXscript/MAXcontrol/MAXcolor language may be used in any BBS or Door
  software 100% royalty free. You are also allowed to implement full local
  graphics viewing in any BBS or Door software 100% royalty free. However,
  any program that uses the MAXscript/MAXcontrol/MAXcolor language *MUST*
  bear the MAX Graphics/BBS Utiliteez Software copyright notice....


  Example: MAX Graphics and the MAXscript/MAXcontrol/MAXcolor language is
           Copyright 1995-1997 * Larry L. Athey * BBS Utiliteez Software

    }
{$A+,B-,D+,E+,F+,G+,I-,L+,N-,O-,P-,Q-,R-,S-,T-,V+,X+}
PROGRAM MAKEDROP;

USES CRT, TDK_VARS, DOORKIT2, DOORKIT3;

VAR
  WorkDir : STRING;

PROCEDURE CommandLineHelp;
BEGIN
  ShowProgramAd;
  Writeln('');
  IceText('Command Syntax:',TRUE);
  LineBar(1,0,15);
  IceText('MAKEDROP.EXE /N[Node #] /S[Baud Rate] /M[Minutes Left] /D=[DropFile Path]',TRUE);
  Writeln('');
  IceText('Or:',TRUE);
  Writeln('');
  IceText('MAKEDROP.EXE /N1 /S28800 /M30 /D=C:\BBS\NODE1\',TRUE);
  GotoXY(1,24);
  AnyKey;
  HALT;
END;

PROCEDURE WriteDorInfo;
VAR
  _DorInfo : TEXT;
   Loop    : BYTE;
   DI      : ARRAY[1..12] OF STRING[40];
BEGIN
  WRITELN('Creating '+DropFilePath+'DORINFO1.DEF');
  ASSIGN(_DorInfo,DropFilePath+'DORINFO1.DEF');
  DI[1] := Ctl.BBSname;                       {BBS Name}
  DI[2] := Ctl.SFirst;                        {Sysop First}
  DI[3] := Ctl.SLast;                         {Sysop Last}
  DI[4] := 'COM' + IntToStr(DoorSys.Comport); {Comm Port}
  DI[5] := IntToStr(DoorSys.BaudRate) + ' BAUD,' +
           Ctl.Parity + ',' +
           IntToStr(Ctl.WordSize) + ',' +
           IntToStr(Ctl.StopBits);            {Baud And Parity}
  DI[6] := '0';                               {Always Zero}
  DI[7] := IntToStr(DoorSys.BaudRate)+'Baud'; {User First}
  DI[8] := 'Caller';                          {User Last}
  DI[9] := Ctl.BBSname;                       {User Location}
  DI[10] := '1';                              {Terminal Emulation}
  DI[11] := '0';                              {Security}
  DI[12] := IntToStr(DoorSys.MinutesLeft);    {Minutes Remaining}
  REWRITE(_Dorinfo);
  FOR Loop := 1 TO 12 DO WRITELN(_Dorinfo,DI[Loop]);
  CLOSE(_Dorinfo);
END;

PROCEDURE ReadCTL;
VAR
  NodeStr : STRING[3];
  CtlFile : FILE OF ControlFile;
BEGIN
  STR(DoorSys.Node,NodeStr);
  IF NOT FExist('NODE' + NodeStr + '.CTL') THEN BEGIN
    ClrScr;
    OutTxtL(15,4,'!!! FATAL ERROR !!!');
    Writeln('');
    OutTxtL(12,0,'NODE' + NodeStr + '.CTL Not Found!');
    Writeln('');
    OutTxtL(4,0,'Please Run The MAKECTL.EXE Program');
    OutTxtL(4,0,'To Create A Control File For Node #' + NodeStr + '!');
    AlertTones;
    Wait(2);
    ErrorLog('FATAL ERROR - NODE' + NodeStr + '.CTL NOT FOUND!',6,TRUE);
  END;
  ASSIGN(CtlFile,'NODE' + NodeStr + '.CTL');
  RESET(CtlFile);
  READ(CtlFile,Ctl);
  CLOSE(CtlFile);
  IF Ctl.HomePath = '\' THEN BEGIN
    ClrScr;
    OutTxtL(15,4,'!!! FATAL ERROR !!!');
    Writeln('');
    OutTxtL(12,0,'No BBS Home Directory Defined In NODE' + NodeStr + '.CTL!');
    Writeln('');
    OutTxtL(4,0,'Please Run The MAKECTL.EXE Program');
    OutTxtL(4,0,'To Correct This Error.............');
    AlertTones;
    Wait(2);
    ErrorLog('FATAL ERROR - No BBS Home Directory Defined In NODE' + NodeStr + '.CTL!',6,TRUE);
  END;
  WITH DoorSys DO BEGIN
    IF Ctl.UseFossil THEN WhichIO := FossilIO ELSE WhichIO := InternalIO;
    Comport    := Ctl.Port;
    WordSize   := Ctl.WordSize;
    Parity     := Ctl.Parity;
    StopBits   := Ctl.StopBits;
    InBufSize  := Ctl.InBuffer;
    OutBufSize := Ctl.OutBuffer;
  END;
END;

PROCEDURE DoCommandLine;
VAR
  TempParam : STRING;
  Time,
  NewBaud   : LONGINT;
  NewNode,
  Code      : INTEGER;
  Loop      : BYTE;
BEGIN
  NewNode := - 1;
  NewBaud := 0;
  Local   := FALSE;
  IF PARAMCOUNT = 0 THEN CommandLineHelp;
  FOR Loop := 1 TO PARAMCOUNT DO BEGIN
    TempParam := AllCaps(PARAMSTR(Loop));
    IF TempParam[1] = '/' THEN BEGIN
      CASE TempParam[2] OF
        'D' : BEGIN
                DropFilePath := COPY(TempParam,4,255);
                DropFilePath := FixPath(DropFilePath);
              END;
        'M' : BEGIN
                VAL(COPY(TempParam,3,255),Time,Code);
                IF Code <> 0 THEN BEGIN
                  WRITELN('Error In Forced Time Limit: ' + TempParam);
                  AlertTones;
                  ErrorLog('Error In Forced Time Limit: ' + TempParam,ErrLevel,TRUE);
                END;
              END;
        'N' : BEGIN
                VAL(COPY(TempParam,3,255),NewNode,Code);
                IF Code <> 0 THEN BEGIN
                  WRITELN('Error In Forced Node Number: ' + TempParam);
                  AlertTones;
                  ErrorLog('Error In Forced Node Number: ' + TempParam,ErrLevel,TRUE);
                END;
              END;
        'S' : BEGIN
                VAL(COPY(TempParam,3,255),NewBaud,Code);
                IF Code <> 0 THEN BEGIN
                  WRITELN('Error In Forced Baud Rate: ' + TempParam);
                  AlertTones;
                  ErrorLog('Error In Forced Baud Rate: ' + TempParam,ErrLevel,TRUE);
                END;
              END;
        '?' : CommandLineHelp;
        'H' : CommandLineHelp;
        ELSE BEGIN
          CommandLineHelp;
        END;
      END;
    END ELSE BEGIN
      CommandLineHelp;
    END;
  END;
  IF NewNode <> - 1 THEN DoorSys.Node := NewNode;
  IF Time <> 0 THEN DoorSys.MinutesLeft := Time;
  IF NewBaud <> 0 THEN DoorSys.BaudRate := NewBaud;
  ReadCTL;
END;

{-----------------------------------------------------------------------------}

BEGIN
  ClrScr;
  ProgramName := 'MAKEDROP.EXE v2.03';
  ProgramDesc := 'DORINFO1.DEF DropFile Creator';
  GETDIR(0,WorkDir);
  IF PARAMCOUNT < 4 THEN CommandLineHelp;
  DoCommandLine;
  WorkDir := WorkDir + IntToStr(DoorSys.Node);
  MakeDir(WorkDir);
  IF NOT DExist(DropFilePath) THEN BEGIN
    WRITELN('Error In Drop File Path: ' + DropFilePath);
    AlertTones;
    ErrorLog('Error In Drop File Path: ' + DropFilePath,ErrLevel,TRUE);
  END;
  WriteDorInfo;
END.
